---
title: AZU003
summary: Unencrypted managed disk. [azurerm_managed_disk] 
resources: 
permalink: /docs/azure/AZU003/
nav_order: 2
parent: AZURE Checks
---

## Unencrypted managed disk.

### Explanation


Manage disks should be encrypted at rest. When specifying the <code>encryption_settings</code> block, the enabled attribute should be set to <code>true</code>.



### Insecure Example

The following example will fail the AZU003 check.

{% highlight terraform %}

resource "azurerm_managed_disk" "my-disk" {
	encryption_settings {
		enabled = false
	}
}
{% endhighlight %}



### Secure Example

The following example will pass the AZU003 check.

{% highlight terraform %}

resource "azurerm_managed_disk" "my-disk" {
	encryption_settings {
		enabled = true
	}
}
{% endhighlight %}


### Related Links


- [https://docs.microsoft.com/en-us/azure/virtual-machines/linux/disk-encryption](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/disk-encryption){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://www.terraform.io/docs/providers/azurerm/r/managed_disk.html](https://www.terraform.io/docs/providers/azurerm/r/managed_disk.html){:target="_blank" rel="nofollow noreferrer noopener"}

