---
title: AWS054
summary: ElasticSearch domains should enforce HTTPS [aws_elasticsearch_domain] 
resources: 
permalink: /docs/aws/AWS054/
nav_order: 2
parent: AWS Checks
---

## ElasticSearch domains should enforce HTTPS

### Explanation


Amazon Elasticsearch Service now lets you configure your domains to require that all traffic be submitted over HTTPS so that you can ensure that communications between your clients and your domain are encrypted. 

You can also configure the minimum required TLS version to accept. 

This option is a useful additional security control to ensure your clients are not misconfigured.



### Insecure Example

The following example will fail the AWS054 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "bad_example" {
  domain_name           = "example"
  elasticsearch_version = "1.5"

  domain_endpoint_options {
    enforce_https = false
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS054 check.

{% highlight terraform %}

resource "aws_elasticsearch_domain" "good_example" {
  domain_name           = "example"
  elasticsearch_version = "1.5"

  domain_endpoint_options {
    enforce_https = true
  }
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/elasticsearch_domain#enforce_https](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/elasticsearch_domain#enforce_https){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html){:target="_blank" rel="nofollow noreferrer noopener"}

