---
title: AWS046
summary: AWS IAM policy document has wildcard action statement. [aws_iam_policy_document] 
resources: 
permalink: /docs/aws/AWS046/
nav_order: 2
parent: AWS Checks
---

## AWS IAM policy document has wildcard action statement.

### Explanation


IAM profiles should be configured with the specific, minimum set of permissions required.



### Insecure Example

The following example will fail the AWS046 check.

{% highlight terraform %}

data "aws_iam_policy_document" "my-policy" {
	statement {
		sid = "1"

        actions = [
      		"*"
    	]
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS046 check.

{% highlight terraform %}

data "aws_iam_policy_document" "my-policy" {
	statement {
		sid = "1"

        actions = [
      		"s3:ListAllMyBuckets",
      		"ec2:DescribeInstances"
    	]
	}
}

{% endhighlight %}


### Related Links


