---
title: AWS023
summary: ECR repository has image scans disabled. [aws_ecr_repository] 
resources: 
permalink: /docs/aws/AWS023/
nav_order: 2
parent: AWS Checks
---

## ECR repository has image scans disabled.

### Explanation


Repository image scans should be enabled to ensure vulnerable software can be discovered and remediated as soon as possible.



### Insecure Example

The following example will fail the AWS023 check.

{% highlight terraform %}

resource "aws_ecr_repository" "foo" {
  name                 = "bar"
  image_tag_mutability = "MUTABLE"

  image_scanning_configuration {
    scan_on_push = false
  }
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS023 check.

{% highlight terraform %}

resource "aws_ecr_repository" "foo" {
  name                 = "bar"
  image_tag_mutability = "MUTABLE"

  image_scanning_configuration {
    scan_on_push = true
  }
}

{% endhighlight %}


### Related Links


