---
title: GCP012
summary: Checks for service account defined for GKE nodes [google_container_cluster google_container_node_pool] 
resources: 
permalink: /docs/google/GCP012/
nav_order: 2
parent: GOOGLE Checks
---

## Checks for service account defined for GKE nodes

### Explanation


You should create and use a minimally privileged service account to run your GKE cluster instead of using the Compute Engine default service account.



### Insecure Example

The following example will fail the GCP012 check.

{% highlight terraform %}

resource "google_container_cluster" "my-cluster" {
	node_config {
	}
}

{% endhighlight %}



### Secure Example

The following example will pass the GCP012 check.

{% highlight terraform %}

resource "google_container_cluster" "my-cluster" {
	node_config {
		service_account = "cool-service-account@example.com"
	}
}

{% endhighlight %}


### Related Links


- [https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#use_least_privilege_sa](https://cloud.google.com/kubernetes-engine/docs/how-to/hardening-your-cluster#use_least_privilege_sa){:target="_blank" rel="nofollow noreferrer noopener"}

