---
title: AWS037
summary: IAM Password policy should prevent password reuse. [aws_iam_account_password_policy] 
resources: 
permalink: /docs/aws/AWS037/
nav_order: 2
parent: AWS Checks
---

## IAM Password policy should prevent password reuse.

### Explanation


IAM account password policies should prevent the reuse of passwords. 

The account password policy should be set to prevent using any of the last five used passwords.



### Insecure Example

The following example will fail the AWS037 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	password_reuse_prevention = 1
	# ...
}

{% endhighlight %}



### Secure Example

The following example will pass the AWS037 check.

{% highlight terraform %}

resource "aws_iam_account_password_policy" "strict" {
	# ...
	password_reuse_prevention = 5
	# ...
}

{% endhighlight %}


### Related Links


- [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html#password-policy-details){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/iam_account_password_policy){:target="_blank" rel="nofollow noreferrer noopener"}

