---
title: AZU012
summary: The default action on Storage account network rules should be set to deny [azurerm_storage_account azurerm_storage_account_network_rules] 
resources: 
permalink: /docs/azure/AZU012/
nav_order: 2
parent: AZURE Checks
---

## The default action on Storage account network rules should be set to deny

### Explanation


The default_action for network rules should come into effect when no other rules are matched.

The default action should be set to Deny.



### Insecure Example

The following example will fail the AZU012 check.

{% highlight terraform %}

resource "azurerm_storage_account_network_rules" "bad_example" {
  
  default_action             = "Allow"
  ip_rules                   = ["127.0.0.1"]
  virtual_network_subnet_ids = [azurerm_subnet.test.id]
  bypass                     = ["Metrics"]
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU012 check.

{% highlight terraform %}

resource "azurerm_storage_account_network_rules" "good_example" {
  
  default_action             = "Deny"
  ip_rules                   = ["127.0.0.1"]
  virtual_network_subnet_ids = [azurerm_subnet.test.id]
  bypass                     = ["Metrics"]
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account_network_rules#default_action](https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account_network_rules#default_action){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/firewall/rule-processing](https://docs.microsoft.com/en-us/azure/firewall/rule-processing){:target="_blank" rel="nofollow noreferrer noopener"}

