---
title: AZU010
summary: Ensure HTTPS is enabled on Azure Storage Account [azurerm_storage_account enable_https_traffic_only] 
resources: 
permalink: /docs/azure/AZU010/
nav_order: 2
parent: AZURE Checks
---

## Ensure HTTPS is enabled on Azure Storage Account

### Explanation


Requiring HTTPS in Storage Account helps to minimize the risk of eavesdropping.



### Insecure Example

The following example will fail the AZU010 check.

{% highlight terraform %}

resource "azurerm_storage_account" "my-storage-account" {
	enable_https_traffic_only = false
}

{% endhighlight %}



### Secure Example

The following example will pass the AZU010 check.

{% highlight terraform %}

resource "azurerm_storage_account" "my-storage-account" {
	enable_https_traffic_only = true
}

{% endhighlight %}


### Related Links


- [https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account](https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/storage_account){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.microsoft.com/en-us/azure/storage/blobs/security-recommendations](https://docs.microsoft.com/en-us/azure/storage/blobs/security-recommendations){:target="_blank" rel="nofollow noreferrer noopener"}

