---
title: "output"
description: "output configuration"
menu:
  docs:
    parent: "configuration"
weight: 125
toc: true
---

Since `v0.12.0`

Save generated output to a file, if `output.file` is not empty.

{{< alert type="info" >}}
`output.file` can be relative to module root or an absolute path.
{{< /alert >}}

Saving behavior can be controlled by `output.mode`:

- `inject` (default)

  Partially replace the `output-file` content with generated output.

  {{< alert type="info" >}}
  This creates the `output-file` if it doesn't exist, otherwise it appends to
  `output-file` if it doesn't have surrounding comments.
  {{< /alert >}}

- `replace`

  Completely replace the `output-file` with generated output.

  {{< alert type="info" >}}
  This creates the `output-file` if it doesn't exist.
  {{< /alert >}}

The output generated by formatters (`markdown`, `asciidoc`, etc) will first be
inserted into a template before getting saved into the file. This template can be
customized with `output.template`.

{{< alert type="info" >}}
`output.template` is optional for mode `replace`.
{{< /alert >}}

The default template value is:

```text
<!-- BEGIN_TF_DOCS -->
{{ .Content }}
<!-- END_TF_DOCS -->
```

This template consists of at least three lines (all of which are mandatory):

- begin comment
- `{{ .Content }}` slug
- end comment

Wording of the comments may be changed as necessary, but the comment must be
present in the template. Also note that `SPACE`s inside `{{ }}` are mandatory.

You may also add as many lines as you'd like before or after `{{ .Content }}` line.

{{< alert type="info" >}}
If you want to customize template for mode `replace`, `{{ .Content }}` is mandatory.
{{< /alert >}}

## Template Comment

Markdown doesn't officially support inline commenting, there are multiple ways
to do it as a workaround, though. The following formats are supported as begin
and end comments of a template:

- `<!-- This is a comment -->`
- `[]: # (This is a comment)`
- `[]: # "This is a comment"`
- `[]: # 'This is a comment'`
- `[//]: # (This is a comment)`
- `[comment]: # (This is a comment)`

The following is also supported for AsciiDoc format:

- `// This is a comment`

## Options

Available options with their default values.

```yaml
output:
  file: ""
  mode: inject
  template: |-
    <!-- BEGIN_TF_DOCS -->
    {{ .Content }}
    <!-- END_TF_DOCS -->
```

## Examples

Inject the generated output into `README.md` between the sorrounding comments.

```yaml
output:
  file: README.md
  mode: inject
  template: |-
    <!-- BEGIN_TF_DOCS -->
    {{ .Content }}
    <!-- END_TF_DOCS -->
```

Replace the content of `USAGE.md` with generated output. Note that any manual
changes to that file will be overwritten.

```yaml
output:
  file: USAGE.md
  mode: replace
  template: |-
    {{ .Content }}
```

To output to YAML file with leading comment, the following can be used:

```yaml
formatter: yaml

output:
  file: output.yaml
  mode: replace
  template: |-
    # Example leading comments block which will be placed at the top of the
    # 'output.yaml' file.
    #
    # Note that there's no <!-- BEGIN_TF_DOCS --> and <!-- END_TF_DOCS -->
    # which will break the integrity yaml file.

    {{ .Content }}
```

The following can be used where HTML comments are not supported (e.g. Bitbucket
Cloud):

{{< alert type="warning" >}}
The empty line before `[//]: # (END_TF_DOCS)` is mandatory in order for
Markdown engine to properly process the comment line after the paragraph.
{{< /alert >}}

```yaml
output:
  file: README.md
  mode: inject
  template: |-
    [//]: # (BEGIN_TF_DOCS)
    {{ .Content }}

    [//]: # (END_TF_DOCS)
```
