// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistence/v1/workflow_mutable_state.proto

package persistence

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	v1 "go.temporal.io/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type WorkflowMutableState struct {
	ActivityInfos       map[int64]*ActivityInfo       `protobuf:"bytes,1,rep,name=activity_infos,json=activityInfos,proto3" json:"activity_infos,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	TimerInfos          map[string]*TimerInfo         `protobuf:"bytes,2,rep,name=timer_infos,json=timerInfos,proto3" json:"timer_infos,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ChildExecutionInfos map[int64]*ChildExecutionInfo `protobuf:"bytes,3,rep,name=child_execution_infos,json=childExecutionInfos,proto3" json:"child_execution_infos,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	RequestCancelInfos  map[int64]*RequestCancelInfo  `protobuf:"bytes,4,rep,name=request_cancel_infos,json=requestCancelInfos,proto3" json:"request_cancel_infos,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	SignalInfos         map[int64]*SignalInfo         `protobuf:"bytes,5,rep,name=signal_infos,json=signalInfos,proto3" json:"signal_infos,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	SignalRequestedIds  []string                      `protobuf:"bytes,6,rep,name=signal_requested_ids,json=signalRequestedIds,proto3" json:"signal_requested_ids,omitempty"`
	ExecutionInfo       *WorkflowExecutionInfo        `protobuf:"bytes,7,opt,name=execution_info,json=executionInfo,proto3" json:"execution_info,omitempty"`
	ExecutionState      *WorkflowExecutionState       `protobuf:"bytes,8,opt,name=execution_state,json=executionState,proto3" json:"execution_state,omitempty"`
	NextEventId         int64                         `protobuf:"varint,9,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	BufferedEvents      []*v1.HistoryEvent            `protobuf:"bytes,10,rep,name=buffered_events,json=bufferedEvents,proto3" json:"buffered_events,omitempty"`
	Checksum            *Checksum                     `protobuf:"bytes,11,opt,name=checksum,proto3" json:"checksum,omitempty"`
}

func (m *WorkflowMutableState) Reset()      { *m = WorkflowMutableState{} }
func (*WorkflowMutableState) ProtoMessage() {}
func (*WorkflowMutableState) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b5581c180807aa7, []int{0}
}
func (m *WorkflowMutableState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkflowMutableState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkflowMutableState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkflowMutableState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowMutableState.Merge(m, src)
}
func (m *WorkflowMutableState) XXX_Size() int {
	return m.Size()
}
func (m *WorkflowMutableState) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowMutableState.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowMutableState proto.InternalMessageInfo

func (m *WorkflowMutableState) GetActivityInfos() map[int64]*ActivityInfo {
	if m != nil {
		return m.ActivityInfos
	}
	return nil
}

func (m *WorkflowMutableState) GetTimerInfos() map[string]*TimerInfo {
	if m != nil {
		return m.TimerInfos
	}
	return nil
}

func (m *WorkflowMutableState) GetChildExecutionInfos() map[int64]*ChildExecutionInfo {
	if m != nil {
		return m.ChildExecutionInfos
	}
	return nil
}

func (m *WorkflowMutableState) GetRequestCancelInfos() map[int64]*RequestCancelInfo {
	if m != nil {
		return m.RequestCancelInfos
	}
	return nil
}

func (m *WorkflowMutableState) GetSignalInfos() map[int64]*SignalInfo {
	if m != nil {
		return m.SignalInfos
	}
	return nil
}

func (m *WorkflowMutableState) GetSignalRequestedIds() []string {
	if m != nil {
		return m.SignalRequestedIds
	}
	return nil
}

func (m *WorkflowMutableState) GetExecutionInfo() *WorkflowExecutionInfo {
	if m != nil {
		return m.ExecutionInfo
	}
	return nil
}

func (m *WorkflowMutableState) GetExecutionState() *WorkflowExecutionState {
	if m != nil {
		return m.ExecutionState
	}
	return nil
}

func (m *WorkflowMutableState) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *WorkflowMutableState) GetBufferedEvents() []*v1.HistoryEvent {
	if m != nil {
		return m.BufferedEvents
	}
	return nil
}

func (m *WorkflowMutableState) GetChecksum() *Checksum {
	if m != nil {
		return m.Checksum
	}
	return nil
}

func init() {
	proto.RegisterType((*WorkflowMutableState)(nil), "temporal.server.api.persistence.v1.WorkflowMutableState")
	proto.RegisterMapType((map[int64]*ActivityInfo)(nil), "temporal.server.api.persistence.v1.WorkflowMutableState.ActivityInfosEntry")
	proto.RegisterMapType((map[int64]*ChildExecutionInfo)(nil), "temporal.server.api.persistence.v1.WorkflowMutableState.ChildExecutionInfosEntry")
	proto.RegisterMapType((map[int64]*RequestCancelInfo)(nil), "temporal.server.api.persistence.v1.WorkflowMutableState.RequestCancelInfosEntry")
	proto.RegisterMapType((map[int64]*SignalInfo)(nil), "temporal.server.api.persistence.v1.WorkflowMutableState.SignalInfosEntry")
	proto.RegisterMapType((map[string]*TimerInfo)(nil), "temporal.server.api.persistence.v1.WorkflowMutableState.TimerInfosEntry")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistence/v1/workflow_mutable_state.proto", fileDescriptor_0b5581c180807aa7)
}

var fileDescriptor_0b5581c180807aa7 = []byte{
	// 677 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x95, 0x4f, 0x6f, 0xd3, 0x3e,
	0x18, 0xc7, 0xeb, 0xf5, 0xb7, 0xfd, 0x36, 0x77, 0xff, 0x64, 0x86, 0x88, 0x7a, 0xb0, 0xaa, 0x49,
	0x93, 0x7a, 0x80, 0x74, 0x7f, 0x00, 0xc1, 0x38, 0x20, 0x28, 0x43, 0xab, 0x06, 0x08, 0x32, 0x24,
	0x24, 0x2e, 0x21, 0x4b, 0x9e, 0x6e, 0x66, 0x69, 0x52, 0x6c, 0xb7, 0x5b, 0x25, 0x84, 0x10, 0x12,
	0x77, 0x5e, 0x06, 0x2f, 0x85, 0xe3, 0x8e, 0x3b, 0xb2, 0xec, 0xc2, 0x71, 0x37, 0xae, 0x28, 0x4e,
	0xda, 0xba, 0x6b, 0x27, 0x42, 0x6f, 0xf1, 0xe3, 0x3e, 0x9f, 0xcf, 0xd7, 0x8e, 0x9e, 0x06, 0x3f,
	0x94, 0xd0, 0x68, 0x86, 0xdc, 0xf1, 0x2b, 0x02, 0x78, 0x1b, 0x78, 0xc5, 0x69, 0xb2, 0x4a, 0x13,
	0xb8, 0x60, 0x42, 0x42, 0xe0, 0x42, 0xa5, 0xbd, 0x56, 0x39, 0x0a, 0xf9, 0x61, 0xdd, 0x0f, 0x8f,
	0xec, 0x46, 0x4b, 0x3a, 0x7b, 0x3e, 0xd8, 0x42, 0x3a, 0x12, 0xcc, 0x26, 0x0f, 0x65, 0x48, 0x96,
	0xbb, 0x00, 0x33, 0x01, 0x98, 0x4e, 0x93, 0x99, 0x1a, 0xc0, 0x6c, 0xaf, 0x15, 0x57, 0x7a, 0x92,
	0x98, 0x7e, 0xc0, 0x84, 0x0c, 0x79, 0x27, 0x26, 0x37, 0x40, 0x08, 0x67, 0x3f, 0x45, 0x15, 0x37,
	0x32, 0x64, 0x81, 0x63, 0x70, 0x5b, 0x92, 0x85, 0x81, 0x48, 0x9a, 0x96, 0x7f, 0xcf, 0xe2, 0xa5,
	0x37, 0x69, 0xc0, 0xe7, 0x49, 0xbe, 0xdd, 0x38, 0x1e, 0xe1, 0x78, 0xde, 0x71, 0x25, 0x6b, 0x33,
	0xd9, 0xb1, 0x59, 0x50, 0x0f, 0x85, 0x81, 0x4a, 0xf9, 0x72, 0x61, 0x7d, 0xc7, 0xfc, 0x7b, 0x62,
	0x73, 0x14, 0xd1, 0x7c, 0x94, 0xe2, 0x6a, 0x31, 0x6d, 0x2b, 0x90, 0xbc, 0x63, 0xcd, 0x39, 0x7a,
	0x8d, 0x30, 0x5c, 0x90, 0xac, 0x01, 0x3c, 0x15, 0x4e, 0x28, 0xe1, 0xf6, 0xd8, 0xc2, 0xd7, 0x31,
	0x4b, 0xb3, 0x61, 0xd9, 0x2b, 0x90, 0xaf, 0x08, 0x5f, 0x77, 0x0f, 0x98, 0xef, 0xd9, 0xbd, 0x2b,
	0x49, 0xad, 0x79, 0x65, 0x7d, 0x35, 0xb6, 0xb5, 0x1a, 0x53, 0xb7, 0xba, 0x50, 0x4d, 0x7f, 0xcd,
	0x1d, 0xde, 0x21, 0x5f, 0x10, 0x5e, 0xe2, 0xf0, 0xa1, 0x05, 0x42, 0xda, 0xae, 0x13, 0xb8, 0xe0,
	0xa7, 0x31, 0xfe, 0x53, 0x31, 0x5e, 0x8e, 0x1d, 0xc3, 0x4a, 0xa0, 0x55, 0xc5, 0xd4, 0x52, 0x10,
	0x3e, 0xb4, 0x41, 0x7c, 0x3c, 0x2b, 0xd8, 0x7e, 0xe0, 0x74, 0xdd, 0x93, 0xca, 0x5d, 0x1b, 0xdb,
	0xbd, 0xab, 0x60, 0x9a, 0xb4, 0x20, 0xfa, 0x15, 0xb2, 0x8a, 0x97, 0x52, 0x5b, 0x1a, 0x05, 0x3c,
	0x9b, 0x79, 0xc2, 0x98, 0x2a, 0xe5, 0xcb, 0x33, 0x16, 0x49, 0xf6, 0xac, 0xee, 0x56, 0xcd, 0x13,
	0xe4, 0x1d, 0x9e, 0x1f, 0x7c, 0x4b, 0xc6, 0xff, 0x25, 0x54, 0x2e, 0xac, 0xdf, 0xff, 0x97, 0x84,
	0x03, 0x17, 0x6f, 0xcd, 0x81, 0xbe, 0x24, 0x2e, 0x5e, 0xe8, 0x1b, 0xd4, 0x7c, 0x1a, 0xd3, 0x4a,
	0xb1, 0x39, 0x96, 0x42, 0x5d, 0x83, 0xd5, 0x0f, 0x9d, 0x8c, 0xd4, 0x32, 0x9e, 0x0b, 0xe0, 0x58,
	0xda, 0xd0, 0x86, 0x40, 0xda, 0xcc, 0x33, 0x66, 0x4a, 0xa8, 0x9c, 0xb7, 0x0a, 0x71, 0x71, 0x2b,
	0xae, 0xd5, 0x3c, 0xf2, 0x02, 0x2f, 0xec, 0xb5, 0xea, 0x75, 0xe0, 0xe0, 0x25, 0xbf, 0x13, 0x06,
	0x56, 0x6f, 0x63, 0xa5, 0x1f, 0x24, 0x4e, 0x90, 0xfe, 0x0b, 0xc4, 0xf6, 0xed, 0xe4, 0x51, 0x11,
	0xac, 0xf9, 0x6e, 0xb7, 0x5a, 0x0a, 0xb2, 0x8d, 0xa7, 0xdd, 0x03, 0x70, 0x0f, 0x45, 0xab, 0x61,
	0x14, 0xd4, 0x89, 0x6e, 0x66, 0x39, 0x51, 0x35, 0xed, 0xb1, 0x7a, 0xdd, 0x45, 0x8e, 0xc9, 0xf0,
	0x04, 0x93, 0x45, 0x9c, 0x3f, 0x84, 0x8e, 0x81, 0xd4, 0x49, 0xe2, 0x47, 0xf2, 0x14, 0x4f, 0xb6,
	0x1d, 0xbf, 0x05, 0xc6, 0x84, 0xd2, 0xad, 0x66, 0xd1, 0xe9, 0x60, 0x2b, 0x69, 0xdf, 0x9c, 0xb8,
	0x87, 0x8a, 0x3e, 0x5e, 0xb8, 0x34, 0xc4, 0xba, 0x70, 0x26, 0x11, 0x56, 0x07, 0x85, 0xb7, 0xb2,
	0x08, 0x7b, 0x54, 0xdd, 0xf6, 0x09, 0x1b, 0x57, 0x0d, 0xef, 0x88, 0x73, 0x3e, 0x1b, 0xd4, 0xde,
	0xcd, 0x76, 0xad, 0x97, 0xf1, 0xba, 0xff, 0x23, 0xbe, 0x71, 0xc5, 0xd4, 0x8e, 0xd0, 0xef, 0x0c,
	0xea, 0xef, 0x64, 0xd1, 0x0f, 0xd1, 0x75, 0x7b, 0x80, 0x17, 0x2f, 0xcf, 0xed, 0x08, 0xed, 0x93,
	0x41, 0xad, 0x99, 0x45, 0xdb, 0xc7, 0x6a, 0xbe, 0xc7, 0xef, 0x4f, 0xce, 0x68, 0xee, 0xf4, 0x8c,
	0xe6, 0x2e, 0xce, 0x28, 0xfa, 0x1c, 0x51, 0xf4, 0x3d, 0xa2, 0xe8, 0x47, 0x44, 0xd1, 0x49, 0x44,
	0xd1, 0xcf, 0x88, 0xa2, 0x5f, 0x11, 0xcd, 0x5d, 0x44, 0x14, 0x7d, 0x3b, 0xa7, 0xb9, 0x93, 0x73,
	0x9a, 0x3b, 0x3d, 0xa7, 0xb9, 0xb7, 0xb7, 0xf7, 0xc3, 0xbe, 0x92, 0x85, 0x57, 0x7f, 0xea, 0x1e,
	0x68, 0xcb, 0xbd, 0x29, 0xf5, 0xb1, 0xdb, 0xf8, 0x13, 0x00, 0x00, 0xff, 0xff, 0x67, 0x0d, 0xa0,
	0x51, 0xaf, 0x07, 0x00, 0x00,
}

func (this *WorkflowMutableState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WorkflowMutableState)
	if !ok {
		that2, ok := that.(WorkflowMutableState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ActivityInfos) != len(that1.ActivityInfos) {
		return false
	}
	for i := range this.ActivityInfos {
		if !this.ActivityInfos[i].Equal(that1.ActivityInfos[i]) {
			return false
		}
	}
	if len(this.TimerInfos) != len(that1.TimerInfos) {
		return false
	}
	for i := range this.TimerInfos {
		if !this.TimerInfos[i].Equal(that1.TimerInfos[i]) {
			return false
		}
	}
	if len(this.ChildExecutionInfos) != len(that1.ChildExecutionInfos) {
		return false
	}
	for i := range this.ChildExecutionInfos {
		if !this.ChildExecutionInfos[i].Equal(that1.ChildExecutionInfos[i]) {
			return false
		}
	}
	if len(this.RequestCancelInfos) != len(that1.RequestCancelInfos) {
		return false
	}
	for i := range this.RequestCancelInfos {
		if !this.RequestCancelInfos[i].Equal(that1.RequestCancelInfos[i]) {
			return false
		}
	}
	if len(this.SignalInfos) != len(that1.SignalInfos) {
		return false
	}
	for i := range this.SignalInfos {
		if !this.SignalInfos[i].Equal(that1.SignalInfos[i]) {
			return false
		}
	}
	if len(this.SignalRequestedIds) != len(that1.SignalRequestedIds) {
		return false
	}
	for i := range this.SignalRequestedIds {
		if this.SignalRequestedIds[i] != that1.SignalRequestedIds[i] {
			return false
		}
	}
	if !this.ExecutionInfo.Equal(that1.ExecutionInfo) {
		return false
	}
	if !this.ExecutionState.Equal(that1.ExecutionState) {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if len(this.BufferedEvents) != len(that1.BufferedEvents) {
		return false
	}
	for i := range this.BufferedEvents {
		if !this.BufferedEvents[i].Equal(that1.BufferedEvents[i]) {
			return false
		}
	}
	if !this.Checksum.Equal(that1.Checksum) {
		return false
	}
	return true
}
func (this *WorkflowMutableState) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&persistence.WorkflowMutableState{")
	keysForActivityInfos := make([]int64, 0, len(this.ActivityInfos))
	for k, _ := range this.ActivityInfos {
		keysForActivityInfos = append(keysForActivityInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForActivityInfos)
	mapStringForActivityInfos := "map[int64]*ActivityInfo{"
	for _, k := range keysForActivityInfos {
		mapStringForActivityInfos += fmt.Sprintf("%#v: %#v,", k, this.ActivityInfos[k])
	}
	mapStringForActivityInfos += "}"
	if this.ActivityInfos != nil {
		s = append(s, "ActivityInfos: "+mapStringForActivityInfos+",\n")
	}
	keysForTimerInfos := make([]string, 0, len(this.TimerInfos))
	for k, _ := range this.TimerInfos {
		keysForTimerInfos = append(keysForTimerInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForTimerInfos)
	mapStringForTimerInfos := "map[string]*TimerInfo{"
	for _, k := range keysForTimerInfos {
		mapStringForTimerInfos += fmt.Sprintf("%#v: %#v,", k, this.TimerInfos[k])
	}
	mapStringForTimerInfos += "}"
	if this.TimerInfos != nil {
		s = append(s, "TimerInfos: "+mapStringForTimerInfos+",\n")
	}
	keysForChildExecutionInfos := make([]int64, 0, len(this.ChildExecutionInfos))
	for k, _ := range this.ChildExecutionInfos {
		keysForChildExecutionInfos = append(keysForChildExecutionInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForChildExecutionInfos)
	mapStringForChildExecutionInfos := "map[int64]*ChildExecutionInfo{"
	for _, k := range keysForChildExecutionInfos {
		mapStringForChildExecutionInfos += fmt.Sprintf("%#v: %#v,", k, this.ChildExecutionInfos[k])
	}
	mapStringForChildExecutionInfos += "}"
	if this.ChildExecutionInfos != nil {
		s = append(s, "ChildExecutionInfos: "+mapStringForChildExecutionInfos+",\n")
	}
	keysForRequestCancelInfos := make([]int64, 0, len(this.RequestCancelInfos))
	for k, _ := range this.RequestCancelInfos {
		keysForRequestCancelInfos = append(keysForRequestCancelInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForRequestCancelInfos)
	mapStringForRequestCancelInfos := "map[int64]*RequestCancelInfo{"
	for _, k := range keysForRequestCancelInfos {
		mapStringForRequestCancelInfos += fmt.Sprintf("%#v: %#v,", k, this.RequestCancelInfos[k])
	}
	mapStringForRequestCancelInfos += "}"
	if this.RequestCancelInfos != nil {
		s = append(s, "RequestCancelInfos: "+mapStringForRequestCancelInfos+",\n")
	}
	keysForSignalInfos := make([]int64, 0, len(this.SignalInfos))
	for k, _ := range this.SignalInfos {
		keysForSignalInfos = append(keysForSignalInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForSignalInfos)
	mapStringForSignalInfos := "map[int64]*SignalInfo{"
	for _, k := range keysForSignalInfos {
		mapStringForSignalInfos += fmt.Sprintf("%#v: %#v,", k, this.SignalInfos[k])
	}
	mapStringForSignalInfos += "}"
	if this.SignalInfos != nil {
		s = append(s, "SignalInfos: "+mapStringForSignalInfos+",\n")
	}
	s = append(s, "SignalRequestedIds: "+fmt.Sprintf("%#v", this.SignalRequestedIds)+",\n")
	if this.ExecutionInfo != nil {
		s = append(s, "ExecutionInfo: "+fmt.Sprintf("%#v", this.ExecutionInfo)+",\n")
	}
	if this.ExecutionState != nil {
		s = append(s, "ExecutionState: "+fmt.Sprintf("%#v", this.ExecutionState)+",\n")
	}
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	if this.BufferedEvents != nil {
		s = append(s, "BufferedEvents: "+fmt.Sprintf("%#v", this.BufferedEvents)+",\n")
	}
	if this.Checksum != nil {
		s = append(s, "Checksum: "+fmt.Sprintf("%#v", this.Checksum)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringWorkflowMutableState(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *WorkflowMutableState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkflowMutableState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkflowMutableState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Checksum != nil {
		{
			size, err := m.Checksum.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.BufferedEvents) > 0 {
		for iNdEx := len(m.BufferedEvents) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.BufferedEvents[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.NextEventId != 0 {
		i = encodeVarintWorkflowMutableState(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x48
	}
	if m.ExecutionState != nil {
		{
			size, err := m.ExecutionState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.ExecutionInfo != nil {
		{
			size, err := m.ExecutionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.SignalRequestedIds) > 0 {
		for iNdEx := len(m.SignalRequestedIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SignalRequestedIds[iNdEx])
			copy(dAtA[i:], m.SignalRequestedIds[iNdEx])
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(len(m.SignalRequestedIds[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.SignalInfos) > 0 {
		for k := range m.SignalInfos {
			v := m.SignalInfos[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.RequestCancelInfos) > 0 {
		for k := range m.RequestCancelInfos {
			v := m.RequestCancelInfos[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ChildExecutionInfos) > 0 {
		for k := range m.ChildExecutionInfos {
			v := m.ChildExecutionInfos[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.TimerInfos) > 0 {
		for k := range m.TimerInfos {
			v := m.TimerInfos[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ActivityInfos) > 0 {
		for k := range m.ActivityInfos {
			v := m.ActivityInfos[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintWorkflowMutableState(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintWorkflowMutableState(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintWorkflowMutableState(dAtA []byte, offset int, v uint64) int {
	offset -= sovWorkflowMutableState(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *WorkflowMutableState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ActivityInfos) > 0 {
		for k, v := range m.ActivityInfos {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovWorkflowMutableState(uint64(l))
			}
			mapEntrySize := 1 + sovWorkflowMutableState(uint64(k)) + l
			n += mapEntrySize + 1 + sovWorkflowMutableState(uint64(mapEntrySize))
		}
	}
	if len(m.TimerInfos) > 0 {
		for k, v := range m.TimerInfos {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovWorkflowMutableState(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovWorkflowMutableState(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovWorkflowMutableState(uint64(mapEntrySize))
		}
	}
	if len(m.ChildExecutionInfos) > 0 {
		for k, v := range m.ChildExecutionInfos {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovWorkflowMutableState(uint64(l))
			}
			mapEntrySize := 1 + sovWorkflowMutableState(uint64(k)) + l
			n += mapEntrySize + 1 + sovWorkflowMutableState(uint64(mapEntrySize))
		}
	}
	if len(m.RequestCancelInfos) > 0 {
		for k, v := range m.RequestCancelInfos {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovWorkflowMutableState(uint64(l))
			}
			mapEntrySize := 1 + sovWorkflowMutableState(uint64(k)) + l
			n += mapEntrySize + 1 + sovWorkflowMutableState(uint64(mapEntrySize))
		}
	}
	if len(m.SignalInfos) > 0 {
		for k, v := range m.SignalInfos {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovWorkflowMutableState(uint64(l))
			}
			mapEntrySize := 1 + sovWorkflowMutableState(uint64(k)) + l
			n += mapEntrySize + 1 + sovWorkflowMutableState(uint64(mapEntrySize))
		}
	}
	if len(m.SignalRequestedIds) > 0 {
		for _, s := range m.SignalRequestedIds {
			l = len(s)
			n += 1 + l + sovWorkflowMutableState(uint64(l))
		}
	}
	if m.ExecutionInfo != nil {
		l = m.ExecutionInfo.Size()
		n += 1 + l + sovWorkflowMutableState(uint64(l))
	}
	if m.ExecutionState != nil {
		l = m.ExecutionState.Size()
		n += 1 + l + sovWorkflowMutableState(uint64(l))
	}
	if m.NextEventId != 0 {
		n += 1 + sovWorkflowMutableState(uint64(m.NextEventId))
	}
	if len(m.BufferedEvents) > 0 {
		for _, e := range m.BufferedEvents {
			l = e.Size()
			n += 1 + l + sovWorkflowMutableState(uint64(l))
		}
	}
	if m.Checksum != nil {
		l = m.Checksum.Size()
		n += 1 + l + sovWorkflowMutableState(uint64(l))
	}
	return n
}

func sovWorkflowMutableState(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozWorkflowMutableState(x uint64) (n int) {
	return sovWorkflowMutableState(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *WorkflowMutableState) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForBufferedEvents := "[]*HistoryEvent{"
	for _, f := range this.BufferedEvents {
		repeatedStringForBufferedEvents += strings.Replace(fmt.Sprintf("%v", f), "HistoryEvent", "v1.HistoryEvent", 1) + ","
	}
	repeatedStringForBufferedEvents += "}"
	keysForActivityInfos := make([]int64, 0, len(this.ActivityInfos))
	for k, _ := range this.ActivityInfos {
		keysForActivityInfos = append(keysForActivityInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForActivityInfos)
	mapStringForActivityInfos := "map[int64]*ActivityInfo{"
	for _, k := range keysForActivityInfos {
		mapStringForActivityInfos += fmt.Sprintf("%v: %v,", k, this.ActivityInfos[k])
	}
	mapStringForActivityInfos += "}"
	keysForTimerInfos := make([]string, 0, len(this.TimerInfos))
	for k, _ := range this.TimerInfos {
		keysForTimerInfos = append(keysForTimerInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForTimerInfos)
	mapStringForTimerInfos := "map[string]*TimerInfo{"
	for _, k := range keysForTimerInfos {
		mapStringForTimerInfos += fmt.Sprintf("%v: %v,", k, this.TimerInfos[k])
	}
	mapStringForTimerInfos += "}"
	keysForChildExecutionInfos := make([]int64, 0, len(this.ChildExecutionInfos))
	for k, _ := range this.ChildExecutionInfos {
		keysForChildExecutionInfos = append(keysForChildExecutionInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForChildExecutionInfos)
	mapStringForChildExecutionInfos := "map[int64]*ChildExecutionInfo{"
	for _, k := range keysForChildExecutionInfos {
		mapStringForChildExecutionInfos += fmt.Sprintf("%v: %v,", k, this.ChildExecutionInfos[k])
	}
	mapStringForChildExecutionInfos += "}"
	keysForRequestCancelInfos := make([]int64, 0, len(this.RequestCancelInfos))
	for k, _ := range this.RequestCancelInfos {
		keysForRequestCancelInfos = append(keysForRequestCancelInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForRequestCancelInfos)
	mapStringForRequestCancelInfos := "map[int64]*RequestCancelInfo{"
	for _, k := range keysForRequestCancelInfos {
		mapStringForRequestCancelInfos += fmt.Sprintf("%v: %v,", k, this.RequestCancelInfos[k])
	}
	mapStringForRequestCancelInfos += "}"
	keysForSignalInfos := make([]int64, 0, len(this.SignalInfos))
	for k, _ := range this.SignalInfos {
		keysForSignalInfos = append(keysForSignalInfos, k)
	}
	github_com_gogo_protobuf_sortkeys.Int64s(keysForSignalInfos)
	mapStringForSignalInfos := "map[int64]*SignalInfo{"
	for _, k := range keysForSignalInfos {
		mapStringForSignalInfos += fmt.Sprintf("%v: %v,", k, this.SignalInfos[k])
	}
	mapStringForSignalInfos += "}"
	s := strings.Join([]string{`&WorkflowMutableState{`,
		`ActivityInfos:` + mapStringForActivityInfos + `,`,
		`TimerInfos:` + mapStringForTimerInfos + `,`,
		`ChildExecutionInfos:` + mapStringForChildExecutionInfos + `,`,
		`RequestCancelInfos:` + mapStringForRequestCancelInfos + `,`,
		`SignalInfos:` + mapStringForSignalInfos + `,`,
		`SignalRequestedIds:` + fmt.Sprintf("%v", this.SignalRequestedIds) + `,`,
		`ExecutionInfo:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionInfo), "WorkflowExecutionInfo", "WorkflowExecutionInfo", 1) + `,`,
		`ExecutionState:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionState), "WorkflowExecutionState", "WorkflowExecutionState", 1) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`BufferedEvents:` + repeatedStringForBufferedEvents + `,`,
		`Checksum:` + strings.Replace(fmt.Sprintf("%v", this.Checksum), "Checksum", "Checksum", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringWorkflowMutableState(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *WorkflowMutableState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorkflowMutableState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkflowMutableState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkflowMutableState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActivityInfos == nil {
				m.ActivityInfos = make(map[int64]*ActivityInfo)
			}
			var mapkey int64
			var mapvalue *ActivityInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorkflowMutableState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ActivityInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorkflowMutableState(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ActivityInfos[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimerInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimerInfos == nil {
				m.TimerInfos = make(map[string]*TimerInfo)
			}
			var mapkey string
			var mapvalue *TimerInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorkflowMutableState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &TimerInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorkflowMutableState(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TimerInfos[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChildExecutionInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChildExecutionInfos == nil {
				m.ChildExecutionInfos = make(map[int64]*ChildExecutionInfo)
			}
			var mapkey int64
			var mapvalue *ChildExecutionInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorkflowMutableState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ChildExecutionInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorkflowMutableState(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ChildExecutionInfos[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestCancelInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestCancelInfos == nil {
				m.RequestCancelInfos = make(map[int64]*RequestCancelInfo)
			}
			var mapkey int64
			var mapvalue *RequestCancelInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorkflowMutableState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RequestCancelInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorkflowMutableState(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.RequestCancelInfos[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignalInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SignalInfos == nil {
				m.SignalInfos = make(map[int64]*SignalInfo)
			}
			var mapkey int64
			var mapvalue *SignalInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorkflowMutableState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorkflowMutableState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &SignalInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorkflowMutableState(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthWorkflowMutableState
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SignalInfos[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignalRequestedIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SignalRequestedIds = append(m.SignalRequestedIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionInfo == nil {
				m.ExecutionInfo = &WorkflowExecutionInfo{}
			}
			if err := m.ExecutionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionState == nil {
				m.ExecutionState = &WorkflowExecutionState{}
			}
			if err := m.ExecutionState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BufferedEvents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BufferedEvents = append(m.BufferedEvents, &v1.HistoryEvent{})
			if err := m.BufferedEvents[len(m.BufferedEvents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Checksum == nil {
				m.Checksum = &Checksum{}
			}
			if err := m.Checksum.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorkflowMutableState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWorkflowMutableState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipWorkflowMutableState(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowWorkflowMutableState
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWorkflowMutableState
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthWorkflowMutableState
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupWorkflowMutableState
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthWorkflowMutableState
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthWorkflowMutableState        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowWorkflowMutableState          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupWorkflowMutableState = fmt.Errorf("proto: unexpected end of group")
)
