// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: mutableState.go

// Package history is a generated GoMock package.
package history

import (
	reflect "reflect"
	time "time"

	gomock "github.com/golang/mock/gomock"
	command "go.temporal.io/api/command/v1"
	common "go.temporal.io/api/common/v1"
	enums "go.temporal.io/api/enums/v1"
	failure "go.temporal.io/api/failure/v1"
	history "go.temporal.io/api/history/v1"
	taskqueue "go.temporal.io/api/taskqueue/v1"
	workflowservice "go.temporal.io/api/workflowservice/v1"
	enums0 "go.temporal.io/server/api/enums/v1"
	historyservice "go.temporal.io/server/api/historyservice/v1"
	persistence "go.temporal.io/server/api/persistence/v1"
	cache "go.temporal.io/server/common/cache"
	definition "go.temporal.io/server/common/definition"
	persistence0 "go.temporal.io/server/common/persistence"
)

// MockmutableState is a mock of mutableState interface.
type MockmutableState struct {
	ctrl     *gomock.Controller
	recorder *MockmutableStateMockRecorder
}

// MockmutableStateMockRecorder is the mock recorder for MockmutableState.
type MockmutableStateMockRecorder struct {
	mock *MockmutableState
}

// NewMockmutableState creates a new mock instance.
func NewMockmutableState(ctrl *gomock.Controller) *MockmutableState {
	mock := &MockmutableState{ctrl: ctrl}
	mock.recorder = &MockmutableStateMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockmutableState) EXPECT() *MockmutableStateMockRecorder {
	return m.recorder
}

// AddActivityTaskCancelRequestedEvent mocks base method.
func (m *MockmutableState) AddActivityTaskCancelRequestedEvent(arg0, arg1 int64, arg2 string) (*history.HistoryEvent, *persistence.ActivityInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskCancelRequestedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*persistence.ActivityInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddActivityTaskCancelRequestedEvent indicates an expected call of AddActivityTaskCancelRequestedEvent.
func (mr *MockmutableStateMockRecorder) AddActivityTaskCancelRequestedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskCancelRequestedEvent", reflect.TypeOf((*MockmutableState)(nil).AddActivityTaskCancelRequestedEvent), arg0, arg1, arg2)
}

// AddActivityTaskCanceledEvent mocks base method.
func (m *MockmutableState) AddActivityTaskCanceledEvent(arg0, arg1, arg2 int64, arg3 *common.Payloads, arg4 string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskCanceledEvent", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskCanceledEvent indicates an expected call of AddActivityTaskCanceledEvent.
func (mr *MockmutableStateMockRecorder) AddActivityTaskCanceledEvent(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).AddActivityTaskCanceledEvent), arg0, arg1, arg2, arg3, arg4)
}

// AddActivityTaskCompletedEvent mocks base method.
func (m *MockmutableState) AddActivityTaskCompletedEvent(arg0, arg1 int64, arg2 *workflowservice.RespondActivityTaskCompletedRequest) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskCompletedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskCompletedEvent indicates an expected call of AddActivityTaskCompletedEvent.
func (mr *MockmutableStateMockRecorder) AddActivityTaskCompletedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskCompletedEvent", reflect.TypeOf((*MockmutableState)(nil).AddActivityTaskCompletedEvent), arg0, arg1, arg2)
}

// AddActivityTaskFailedEvent mocks base method.
func (m *MockmutableState) AddActivityTaskFailedEvent(arg0, arg1 int64, arg2 *failure.Failure, arg3 enums.RetryState, arg4 string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskFailedEvent", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskFailedEvent indicates an expected call of AddActivityTaskFailedEvent.
func (mr *MockmutableStateMockRecorder) AddActivityTaskFailedEvent(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskFailedEvent", reflect.TypeOf((*MockmutableState)(nil).AddActivityTaskFailedEvent), arg0, arg1, arg2, arg3, arg4)
}

// AddActivityTaskScheduledEvent mocks base method.
func (m *MockmutableState) AddActivityTaskScheduledEvent(arg0 int64, arg1 *command.ScheduleActivityTaskCommandAttributes) (*history.HistoryEvent, *persistence.ActivityInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskScheduledEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*persistence.ActivityInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddActivityTaskScheduledEvent indicates an expected call of AddActivityTaskScheduledEvent.
func (mr *MockmutableStateMockRecorder) AddActivityTaskScheduledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskScheduledEvent", reflect.TypeOf((*MockmutableState)(nil).AddActivityTaskScheduledEvent), arg0, arg1)
}

// AddActivityTaskStartedEvent mocks base method.
func (m *MockmutableState) AddActivityTaskStartedEvent(arg0 *persistence.ActivityInfo, arg1 int64, arg2, arg3 string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskStartedEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskStartedEvent indicates an expected call of AddActivityTaskStartedEvent.
func (mr *MockmutableStateMockRecorder) AddActivityTaskStartedEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskStartedEvent", reflect.TypeOf((*MockmutableState)(nil).AddActivityTaskStartedEvent), arg0, arg1, arg2, arg3)
}

// AddActivityTaskTimedOutEvent mocks base method.
func (m *MockmutableState) AddActivityTaskTimedOutEvent(arg0, arg1 int64, arg2 *failure.Failure, arg3 enums.RetryState) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddActivityTaskTimedOutEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddActivityTaskTimedOutEvent indicates an expected call of AddActivityTaskTimedOutEvent.
func (mr *MockmutableStateMockRecorder) AddActivityTaskTimedOutEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddActivityTaskTimedOutEvent", reflect.TypeOf((*MockmutableState)(nil).AddActivityTaskTimedOutEvent), arg0, arg1, arg2, arg3)
}

// AddChildWorkflowExecutionCanceledEvent mocks base method.
func (m *MockmutableState) AddChildWorkflowExecutionCanceledEvent(arg0 int64, arg1 *common.WorkflowExecution, arg2 *history.WorkflowExecutionCanceledEventAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionCanceledEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionCanceledEvent indicates an expected call of AddChildWorkflowExecutionCanceledEvent.
func (mr *MockmutableStateMockRecorder) AddChildWorkflowExecutionCanceledEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).AddChildWorkflowExecutionCanceledEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionCompletedEvent mocks base method.
func (m *MockmutableState) AddChildWorkflowExecutionCompletedEvent(arg0 int64, arg1 *common.WorkflowExecution, arg2 *history.WorkflowExecutionCompletedEventAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionCompletedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionCompletedEvent indicates an expected call of AddChildWorkflowExecutionCompletedEvent.
func (mr *MockmutableStateMockRecorder) AddChildWorkflowExecutionCompletedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionCompletedEvent", reflect.TypeOf((*MockmutableState)(nil).AddChildWorkflowExecutionCompletedEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) AddChildWorkflowExecutionFailedEvent(arg0 int64, arg1 *common.WorkflowExecution, arg2 *history.WorkflowExecutionFailedEventAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionFailedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionFailedEvent indicates an expected call of AddChildWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) AddChildWorkflowExecutionFailedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).AddChildWorkflowExecutionFailedEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionStartedEvent mocks base method.
func (m *MockmutableState) AddChildWorkflowExecutionStartedEvent(arg0 string, arg1 *common.WorkflowExecution, arg2 *common.WorkflowType, arg3 int64, arg4 *common.Header) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionStartedEvent", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionStartedEvent indicates an expected call of AddChildWorkflowExecutionStartedEvent.
func (mr *MockmutableStateMockRecorder) AddChildWorkflowExecutionStartedEvent(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionStartedEvent", reflect.TypeOf((*MockmutableState)(nil).AddChildWorkflowExecutionStartedEvent), arg0, arg1, arg2, arg3, arg4)
}

// AddChildWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockmutableState) AddChildWorkflowExecutionTerminatedEvent(arg0 int64, arg1 *common.WorkflowExecution, arg2 *history.WorkflowExecutionTerminatedEventAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionTerminatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionTerminatedEvent indicates an expected call of AddChildWorkflowExecutionTerminatedEvent.
func (mr *MockmutableStateMockRecorder) AddChildWorkflowExecutionTerminatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockmutableState)(nil).AddChildWorkflowExecutionTerminatedEvent), arg0, arg1, arg2)
}

// AddChildWorkflowExecutionTimedOutEvent mocks base method.
func (m *MockmutableState) AddChildWorkflowExecutionTimedOutEvent(arg0 int64, arg1 *common.WorkflowExecution, arg2 *history.WorkflowExecutionTimedOutEventAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChildWorkflowExecutionTimedOutEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddChildWorkflowExecutionTimedOutEvent indicates an expected call of AddChildWorkflowExecutionTimedOutEvent.
func (mr *MockmutableStateMockRecorder) AddChildWorkflowExecutionTimedOutEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChildWorkflowExecutionTimedOutEvent", reflect.TypeOf((*MockmutableState)(nil).AddChildWorkflowExecutionTimedOutEvent), arg0, arg1, arg2)
}

// AddCompletedWorkflowEvent mocks base method.
func (m *MockmutableState) AddCompletedWorkflowEvent(arg0 int64, arg1 *command.CompleteWorkflowExecutionCommandAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddCompletedWorkflowEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddCompletedWorkflowEvent indicates an expected call of AddCompletedWorkflowEvent.
func (mr *MockmutableStateMockRecorder) AddCompletedWorkflowEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddCompletedWorkflowEvent", reflect.TypeOf((*MockmutableState)(nil).AddCompletedWorkflowEvent), arg0, arg1)
}

// AddContinueAsNewEvent mocks base method.
func (m *MockmutableState) AddContinueAsNewEvent(arg0, arg1 int64, arg2 string, arg3 *command.ContinueAsNewWorkflowExecutionCommandAttributes) (*history.HistoryEvent, mutableState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddContinueAsNewEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(mutableState)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddContinueAsNewEvent indicates an expected call of AddContinueAsNewEvent.
func (mr *MockmutableStateMockRecorder) AddContinueAsNewEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddContinueAsNewEvent", reflect.TypeOf((*MockmutableState)(nil).AddContinueAsNewEvent), arg0, arg1, arg2, arg3)
}

// AddExternalWorkflowExecutionCancelRequested mocks base method.
func (m *MockmutableState) AddExternalWorkflowExecutionCancelRequested(arg0 int64, arg1, arg2, arg3 string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddExternalWorkflowExecutionCancelRequested", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddExternalWorkflowExecutionCancelRequested indicates an expected call of AddExternalWorkflowExecutionCancelRequested.
func (mr *MockmutableStateMockRecorder) AddExternalWorkflowExecutionCancelRequested(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddExternalWorkflowExecutionCancelRequested", reflect.TypeOf((*MockmutableState)(nil).AddExternalWorkflowExecutionCancelRequested), arg0, arg1, arg2, arg3)
}

// AddExternalWorkflowExecutionSignaled mocks base method.
func (m *MockmutableState) AddExternalWorkflowExecutionSignaled(arg0 int64, arg1, arg2, arg3, arg4 string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddExternalWorkflowExecutionSignaled", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddExternalWorkflowExecutionSignaled indicates an expected call of AddExternalWorkflowExecutionSignaled.
func (mr *MockmutableStateMockRecorder) AddExternalWorkflowExecutionSignaled(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddExternalWorkflowExecutionSignaled", reflect.TypeOf((*MockmutableState)(nil).AddExternalWorkflowExecutionSignaled), arg0, arg1, arg2, arg3, arg4)
}

// AddFailWorkflowEvent mocks base method.
func (m *MockmutableState) AddFailWorkflowEvent(arg0 int64, arg1 enums.RetryState, arg2 *command.FailWorkflowExecutionCommandAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddFailWorkflowEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddFailWorkflowEvent indicates an expected call of AddFailWorkflowEvent.
func (mr *MockmutableStateMockRecorder) AddFailWorkflowEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddFailWorkflowEvent", reflect.TypeOf((*MockmutableState)(nil).AddFailWorkflowEvent), arg0, arg1, arg2)
}

// AddFirstWorkflowTaskScheduled mocks base method.
func (m *MockmutableState) AddFirstWorkflowTaskScheduled(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddFirstWorkflowTaskScheduled", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// AddFirstWorkflowTaskScheduled indicates an expected call of AddFirstWorkflowTaskScheduled.
func (mr *MockmutableStateMockRecorder) AddFirstWorkflowTaskScheduled(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddFirstWorkflowTaskScheduled", reflect.TypeOf((*MockmutableState)(nil).AddFirstWorkflowTaskScheduled), arg0)
}

// AddRecordMarkerEvent mocks base method.
func (m *MockmutableState) AddRecordMarkerEvent(arg0 int64, arg1 *command.RecordMarkerCommandAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddRecordMarkerEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddRecordMarkerEvent indicates an expected call of AddRecordMarkerEvent.
func (mr *MockmutableStateMockRecorder) AddRecordMarkerEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddRecordMarkerEvent", reflect.TypeOf((*MockmutableState)(nil).AddRecordMarkerEvent), arg0, arg1)
}

// AddRequestCancelExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) AddRequestCancelExternalWorkflowExecutionFailedEvent(arg0, arg1 int64, arg2, arg3, arg4 string, arg5 enums.CancelExternalWorkflowExecutionFailedCause) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddRequestCancelExternalWorkflowExecutionFailedEvent", arg0, arg1, arg2, arg3, arg4, arg5)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddRequestCancelExternalWorkflowExecutionFailedEvent indicates an expected call of AddRequestCancelExternalWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) AddRequestCancelExternalWorkflowExecutionFailedEvent(arg0, arg1, arg2, arg3, arg4, arg5 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddRequestCancelExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).AddRequestCancelExternalWorkflowExecutionFailedEvent), arg0, arg1, arg2, arg3, arg4, arg5)
}

// AddRequestCancelExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockmutableState) AddRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 string, arg2 *command.RequestCancelExternalWorkflowExecutionCommandAttributes) (*history.HistoryEvent, *persistence.RequestCancelInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddRequestCancelExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*persistence.RequestCancelInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddRequestCancelExternalWorkflowExecutionInitiatedEvent indicates an expected call of AddRequestCancelExternalWorkflowExecutionInitiatedEvent.
func (mr *MockmutableStateMockRecorder) AddRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddRequestCancelExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockmutableState)(nil).AddRequestCancelExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// AddSignalExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) AddSignalExternalWorkflowExecutionFailedEvent(arg0, arg1 int64, arg2, arg3, arg4, arg5 string, arg6 enums.SignalExternalWorkflowExecutionFailedCause) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddSignalExternalWorkflowExecutionFailedEvent", arg0, arg1, arg2, arg3, arg4, arg5, arg6)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddSignalExternalWorkflowExecutionFailedEvent indicates an expected call of AddSignalExternalWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) AddSignalExternalWorkflowExecutionFailedEvent(arg0, arg1, arg2, arg3, arg4, arg5, arg6 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddSignalExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).AddSignalExternalWorkflowExecutionFailedEvent), arg0, arg1, arg2, arg3, arg4, arg5, arg6)
}

// AddSignalExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockmutableState) AddSignalExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 string, arg2 *command.SignalExternalWorkflowExecutionCommandAttributes) (*history.HistoryEvent, *persistence.SignalInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddSignalExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*persistence.SignalInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddSignalExternalWorkflowExecutionInitiatedEvent indicates an expected call of AddSignalExternalWorkflowExecutionInitiatedEvent.
func (mr *MockmutableStateMockRecorder) AddSignalExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddSignalExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockmutableState)(nil).AddSignalExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// AddSignalRequested mocks base method.
func (m *MockmutableState) AddSignalRequested(requestID string) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "AddSignalRequested", requestID)
}

// AddSignalRequested indicates an expected call of AddSignalRequested.
func (mr *MockmutableStateMockRecorder) AddSignalRequested(requestID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddSignalRequested", reflect.TypeOf((*MockmutableState)(nil).AddSignalRequested), requestID)
}

// AddStartChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) AddStartChildWorkflowExecutionFailedEvent(arg0 int64, arg1 enums.StartChildWorkflowExecutionFailedCause, arg2 *history.StartChildWorkflowExecutionInitiatedEventAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddStartChildWorkflowExecutionFailedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddStartChildWorkflowExecutionFailedEvent indicates an expected call of AddStartChildWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) AddStartChildWorkflowExecutionFailedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddStartChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).AddStartChildWorkflowExecutionFailedEvent), arg0, arg1, arg2)
}

// AddStartChildWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockmutableState) AddStartChildWorkflowExecutionInitiatedEvent(arg0 int64, arg1 string, arg2 *command.StartChildWorkflowExecutionCommandAttributes) (*history.HistoryEvent, *persistence.ChildExecutionInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddStartChildWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*persistence.ChildExecutionInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddStartChildWorkflowExecutionInitiatedEvent indicates an expected call of AddStartChildWorkflowExecutionInitiatedEvent.
func (mr *MockmutableStateMockRecorder) AddStartChildWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddStartChildWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockmutableState)(nil).AddStartChildWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// AddTimeoutWorkflowEvent mocks base method.
func (m *MockmutableState) AddTimeoutWorkflowEvent(arg0 int64, arg1 enums.RetryState) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimeoutWorkflowEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTimeoutWorkflowEvent indicates an expected call of AddTimeoutWorkflowEvent.
func (mr *MockmutableStateMockRecorder) AddTimeoutWorkflowEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimeoutWorkflowEvent", reflect.TypeOf((*MockmutableState)(nil).AddTimeoutWorkflowEvent), arg0, arg1)
}

// AddTimerCanceledEvent mocks base method.
func (m *MockmutableState) AddTimerCanceledEvent(arg0 int64, arg1 *command.CancelTimerCommandAttributes, arg2 string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimerCanceledEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTimerCanceledEvent indicates an expected call of AddTimerCanceledEvent.
func (mr *MockmutableStateMockRecorder) AddTimerCanceledEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).AddTimerCanceledEvent), arg0, arg1, arg2)
}

// AddTimerFiredEvent mocks base method.
func (m *MockmutableState) AddTimerFiredEvent(arg0 string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimerFiredEvent", arg0)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTimerFiredEvent indicates an expected call of AddTimerFiredEvent.
func (mr *MockmutableStateMockRecorder) AddTimerFiredEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerFiredEvent", reflect.TypeOf((*MockmutableState)(nil).AddTimerFiredEvent), arg0)
}

// AddTimerStartedEvent mocks base method.
func (m *MockmutableState) AddTimerStartedEvent(arg0 int64, arg1 *command.StartTimerCommandAttributes) (*history.HistoryEvent, *persistence.TimerInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTimerStartedEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*persistence.TimerInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddTimerStartedEvent indicates an expected call of AddTimerStartedEvent.
func (mr *MockmutableStateMockRecorder) AddTimerStartedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerStartedEvent", reflect.TypeOf((*MockmutableState)(nil).AddTimerStartedEvent), arg0, arg1)
}

// AddTimerTasks mocks base method.
func (m *MockmutableState) AddTimerTasks(timerTasks ...persistence0.Task) {
	m.ctrl.T.Helper()
	varargs := []interface{}{}
	for _, a := range timerTasks {
		varargs = append(varargs, a)
	}
	m.ctrl.Call(m, "AddTimerTasks", varargs...)
}

// AddTimerTasks indicates an expected call of AddTimerTasks.
func (mr *MockmutableStateMockRecorder) AddTimerTasks(timerTasks ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTimerTasks", reflect.TypeOf((*MockmutableState)(nil).AddTimerTasks), timerTasks...)
}

// AddTransferTasks mocks base method.
func (m *MockmutableState) AddTransferTasks(transferTasks ...persistence0.Task) {
	m.ctrl.T.Helper()
	varargs := []interface{}{}
	for _, a := range transferTasks {
		varargs = append(varargs, a)
	}
	m.ctrl.Call(m, "AddTransferTasks", varargs...)
}

// AddTransferTasks indicates an expected call of AddTransferTasks.
func (mr *MockmutableStateMockRecorder) AddTransferTasks(transferTasks ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTransferTasks", reflect.TypeOf((*MockmutableState)(nil).AddTransferTasks), transferTasks...)
}

// AddUpsertWorkflowSearchAttributesEvent mocks base method.
func (m *MockmutableState) AddUpsertWorkflowSearchAttributesEvent(arg0 int64, arg1 *command.UpsertWorkflowSearchAttributesCommandAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddUpsertWorkflowSearchAttributesEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddUpsertWorkflowSearchAttributesEvent indicates an expected call of AddUpsertWorkflowSearchAttributesEvent.
func (mr *MockmutableStateMockRecorder) AddUpsertWorkflowSearchAttributesEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddUpsertWorkflowSearchAttributesEvent", reflect.TypeOf((*MockmutableState)(nil).AddUpsertWorkflowSearchAttributesEvent), arg0, arg1)
}

// AddVisibilityTasks mocks base method.
func (m *MockmutableState) AddVisibilityTasks(visibilityTasks ...persistence0.Task) {
	m.ctrl.T.Helper()
	varargs := []interface{}{}
	for _, a := range visibilityTasks {
		varargs = append(varargs, a)
	}
	m.ctrl.Call(m, "AddVisibilityTasks", varargs...)
}

// AddVisibilityTasks indicates an expected call of AddVisibilityTasks.
func (mr *MockmutableStateMockRecorder) AddVisibilityTasks(visibilityTasks ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddVisibilityTasks", reflect.TypeOf((*MockmutableState)(nil).AddVisibilityTasks), visibilityTasks...)
}

// AddWorkflowExecutionCancelRequestedEvent mocks base method.
func (m *MockmutableState) AddWorkflowExecutionCancelRequestedEvent(arg0 *historyservice.RequestCancelWorkflowExecutionRequest) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionCancelRequestedEvent", arg0)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionCancelRequestedEvent indicates an expected call of AddWorkflowExecutionCancelRequestedEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowExecutionCancelRequestedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionCancelRequestedEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowExecutionCancelRequestedEvent), arg0)
}

// AddWorkflowExecutionCanceledEvent mocks base method.
func (m *MockmutableState) AddWorkflowExecutionCanceledEvent(arg0 int64, arg1 *command.CancelWorkflowExecutionCommandAttributes) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionCanceledEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionCanceledEvent indicates an expected call of AddWorkflowExecutionCanceledEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowExecutionCanceledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowExecutionCanceledEvent), arg0, arg1)
}

// AddWorkflowExecutionSignaled mocks base method.
func (m *MockmutableState) AddWorkflowExecutionSignaled(signalName string, input *common.Payloads, identity string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionSignaled", signalName, input, identity)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionSignaled indicates an expected call of AddWorkflowExecutionSignaled.
func (mr *MockmutableStateMockRecorder) AddWorkflowExecutionSignaled(signalName, input, identity interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionSignaled", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowExecutionSignaled), signalName, input, identity)
}

// AddWorkflowExecutionStartedEvent mocks base method.
func (m *MockmutableState) AddWorkflowExecutionStartedEvent(arg0 common.WorkflowExecution, arg1 *historyservice.StartWorkflowExecutionRequest) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionStartedEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionStartedEvent indicates an expected call of AddWorkflowExecutionStartedEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowExecutionStartedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionStartedEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowExecutionStartedEvent), arg0, arg1)
}

// AddWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockmutableState) AddWorkflowExecutionTerminatedEvent(firstEventID int64, reason string, details *common.Payloads, identity string) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowExecutionTerminatedEvent", firstEventID, reason, details, identity)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowExecutionTerminatedEvent indicates an expected call of AddWorkflowExecutionTerminatedEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowExecutionTerminatedEvent(firstEventID, reason, details, identity interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowExecutionTerminatedEvent), firstEventID, reason, details, identity)
}

// AddWorkflowTaskCompletedEvent mocks base method.
func (m *MockmutableState) AddWorkflowTaskCompletedEvent(arg0, arg1 int64, arg2 *workflowservice.RespondWorkflowTaskCompletedRequest, arg3 int) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskCompletedEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskCompletedEvent indicates an expected call of AddWorkflowTaskCompletedEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowTaskCompletedEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskCompletedEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowTaskCompletedEvent), arg0, arg1, arg2, arg3)
}

// AddWorkflowTaskFailedEvent mocks base method.
func (m *MockmutableState) AddWorkflowTaskFailedEvent(scheduleEventID, startedEventID int64, cause enums.WorkflowTaskFailedCause, failure *failure.Failure, identity, binChecksum, baseRunID, newRunID string, forkEventVersion int64) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskFailedEvent", scheduleEventID, startedEventID, cause, failure, identity, binChecksum, baseRunID, newRunID, forkEventVersion)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskFailedEvent indicates an expected call of AddWorkflowTaskFailedEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowTaskFailedEvent(scheduleEventID, startedEventID, cause, failure, identity, binChecksum, baseRunID, newRunID, forkEventVersion interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskFailedEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowTaskFailedEvent), scheduleEventID, startedEventID, cause, failure, identity, binChecksum, baseRunID, newRunID, forkEventVersion)
}

// AddWorkflowTaskScheduleToStartTimeoutEvent mocks base method.
func (m *MockmutableState) AddWorkflowTaskScheduleToStartTimeoutEvent(arg0 int64) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskScheduleToStartTimeoutEvent", arg0)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskScheduleToStartTimeoutEvent indicates an expected call of AddWorkflowTaskScheduleToStartTimeoutEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowTaskScheduleToStartTimeoutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskScheduleToStartTimeoutEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowTaskScheduleToStartTimeoutEvent), arg0)
}

// AddWorkflowTaskScheduledEvent mocks base method.
func (m *MockmutableState) AddWorkflowTaskScheduledEvent(bypassTaskGeneration bool) (*workflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskScheduledEvent", bypassTaskGeneration)
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskScheduledEvent indicates an expected call of AddWorkflowTaskScheduledEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowTaskScheduledEvent(bypassTaskGeneration interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskScheduledEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowTaskScheduledEvent), bypassTaskGeneration)
}

// AddWorkflowTaskScheduledEventAsHeartbeat mocks base method.
func (m *MockmutableState) AddWorkflowTaskScheduledEventAsHeartbeat(bypassTaskGeneration bool, originalScheduledTimestamp *time.Time) (*workflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskScheduledEventAsHeartbeat", bypassTaskGeneration, originalScheduledTimestamp)
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskScheduledEventAsHeartbeat indicates an expected call of AddWorkflowTaskScheduledEventAsHeartbeat.
func (mr *MockmutableStateMockRecorder) AddWorkflowTaskScheduledEventAsHeartbeat(bypassTaskGeneration, originalScheduledTimestamp interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskScheduledEventAsHeartbeat", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowTaskScheduledEventAsHeartbeat), bypassTaskGeneration, originalScheduledTimestamp)
}

// AddWorkflowTaskStartedEvent mocks base method.
func (m *MockmutableState) AddWorkflowTaskStartedEvent(arg0 int64, arg1 string, arg2 *workflowservice.PollWorkflowTaskQueueRequest) (*history.HistoryEvent, *workflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskStartedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*workflowTaskInfo)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddWorkflowTaskStartedEvent indicates an expected call of AddWorkflowTaskStartedEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowTaskStartedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskStartedEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowTaskStartedEvent), arg0, arg1, arg2)
}

// AddWorkflowTaskTimedOutEvent mocks base method.
func (m *MockmutableState) AddWorkflowTaskTimedOutEvent(arg0, arg1 int64) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddWorkflowTaskTimedOutEvent", arg0, arg1)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddWorkflowTaskTimedOutEvent indicates an expected call of AddWorkflowTaskTimedOutEvent.
func (mr *MockmutableStateMockRecorder) AddWorkflowTaskTimedOutEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddWorkflowTaskTimedOutEvent", reflect.TypeOf((*MockmutableState)(nil).AddWorkflowTaskTimedOutEvent), arg0, arg1)
}

// CheckResettable mocks base method.
func (m *MockmutableState) CheckResettable() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckResettable")
	ret0, _ := ret[0].(error)
	return ret0
}

// CheckResettable indicates an expected call of CheckResettable.
func (mr *MockmutableStateMockRecorder) CheckResettable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckResettable", reflect.TypeOf((*MockmutableState)(nil).CheckResettable))
}

// ClearStickyness mocks base method.
func (m *MockmutableState) ClearStickyness() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "ClearStickyness")
}

// ClearStickyness indicates an expected call of ClearStickyness.
func (mr *MockmutableStateMockRecorder) ClearStickyness() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClearStickyness", reflect.TypeOf((*MockmutableState)(nil).ClearStickyness))
}

// CloneToProto mocks base method.
func (m *MockmutableState) CloneToProto() *persistence.WorkflowMutableState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CloneToProto")
	ret0, _ := ret[0].(*persistence.WorkflowMutableState)
	return ret0
}

// CloneToProto indicates an expected call of CloneToProto.
func (mr *MockmutableStateMockRecorder) CloneToProto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloneToProto", reflect.TypeOf((*MockmutableState)(nil).CloneToProto))
}

// CloseTransactionAsMutation mocks base method.
func (m *MockmutableState) CloseTransactionAsMutation(now time.Time, transactionPolicy transactionPolicy) (*persistence0.WorkflowMutation, []*persistence0.WorkflowEvents, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CloseTransactionAsMutation", now, transactionPolicy)
	ret0, _ := ret[0].(*persistence0.WorkflowMutation)
	ret1, _ := ret[1].([]*persistence0.WorkflowEvents)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CloseTransactionAsMutation indicates an expected call of CloseTransactionAsMutation.
func (mr *MockmutableStateMockRecorder) CloseTransactionAsMutation(now, transactionPolicy interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloseTransactionAsMutation", reflect.TypeOf((*MockmutableState)(nil).CloseTransactionAsMutation), now, transactionPolicy)
}

// CloseTransactionAsSnapshot mocks base method.
func (m *MockmutableState) CloseTransactionAsSnapshot(now time.Time, transactionPolicy transactionPolicy) (*persistence0.WorkflowSnapshot, []*persistence0.WorkflowEvents, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CloseTransactionAsSnapshot", now, transactionPolicy)
	ret0, _ := ret[0].(*persistence0.WorkflowSnapshot)
	ret1, _ := ret[1].([]*persistence0.WorkflowEvents)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CloseTransactionAsSnapshot indicates an expected call of CloseTransactionAsSnapshot.
func (mr *MockmutableStateMockRecorder) CloseTransactionAsSnapshot(now, transactionPolicy interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CloseTransactionAsSnapshot", reflect.TypeOf((*MockmutableState)(nil).CloseTransactionAsSnapshot), now, transactionPolicy)
}

// CreateNewHistoryEvent mocks base method.
func (m *MockmutableState) CreateNewHistoryEvent(eventType enums.EventType) *history.HistoryEvent {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNewHistoryEvent", eventType)
	ret0, _ := ret[0].(*history.HistoryEvent)
	return ret0
}

// CreateNewHistoryEvent indicates an expected call of CreateNewHistoryEvent.
func (mr *MockmutableStateMockRecorder) CreateNewHistoryEvent(eventType interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNewHistoryEvent", reflect.TypeOf((*MockmutableState)(nil).CreateNewHistoryEvent), eventType)
}

// CreateNewHistoryEventWithTime mocks base method.
func (m *MockmutableState) CreateNewHistoryEventWithTime(eventType enums.EventType, time time.Time) *history.HistoryEvent {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNewHistoryEventWithTime", eventType, time)
	ret0, _ := ret[0].(*history.HistoryEvent)
	return ret0
}

// CreateNewHistoryEventWithTime indicates an expected call of CreateNewHistoryEventWithTime.
func (mr *MockmutableStateMockRecorder) CreateNewHistoryEventWithTime(eventType, time interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNewHistoryEventWithTime", reflect.TypeOf((*MockmutableState)(nil).CreateNewHistoryEventWithTime), eventType, time)
}

// CreateTransientWorkflowTaskEvents mocks base method.
func (m *MockmutableState) CreateTransientWorkflowTaskEvents(di *workflowTaskInfo, identity string) (*history.HistoryEvent, *history.HistoryEvent) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTransientWorkflowTaskEvents", di, identity)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(*history.HistoryEvent)
	return ret0, ret1
}

// CreateTransientWorkflowTaskEvents indicates an expected call of CreateTransientWorkflowTaskEvents.
func (mr *MockmutableStateMockRecorder) CreateTransientWorkflowTaskEvents(di, identity interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTransientWorkflowTaskEvents", reflect.TypeOf((*MockmutableState)(nil).CreateTransientWorkflowTaskEvents), di, identity)
}

// DeleteSignalRequested mocks base method.
func (m *MockmutableState) DeleteSignalRequested(requestID string) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "DeleteSignalRequested", requestID)
}

// DeleteSignalRequested indicates an expected call of DeleteSignalRequested.
func (mr *MockmutableStateMockRecorder) DeleteSignalRequested(requestID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteSignalRequested", reflect.TypeOf((*MockmutableState)(nil).DeleteSignalRequested), requestID)
}

// DeleteWorkflowTask mocks base method.
func (m *MockmutableState) DeleteWorkflowTask() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "DeleteWorkflowTask")
}

// DeleteWorkflowTask indicates an expected call of DeleteWorkflowTask.
func (mr *MockmutableStateMockRecorder) DeleteWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).DeleteWorkflowTask))
}

// FailWorkflowTask mocks base method.
func (m *MockmutableState) FailWorkflowTask(arg0 bool) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "FailWorkflowTask", arg0)
}

// FailWorkflowTask indicates an expected call of FailWorkflowTask.
func (mr *MockmutableStateMockRecorder) FailWorkflowTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FailWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).FailWorkflowTask), arg0)
}

// FlushBufferedEvents mocks base method.
func (m *MockmutableState) FlushBufferedEvents() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FlushBufferedEvents")
	ret0, _ := ret[0].(error)
	return ret0
}

// FlushBufferedEvents indicates an expected call of FlushBufferedEvents.
func (mr *MockmutableStateMockRecorder) FlushBufferedEvents() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushBufferedEvents", reflect.TypeOf((*MockmutableState)(nil).FlushBufferedEvents))
}

// GetActivityByActivityID mocks base method.
func (m *MockmutableState) GetActivityByActivityID(arg0 string) (*persistence.ActivityInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityByActivityID", arg0)
	ret0, _ := ret[0].(*persistence.ActivityInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetActivityByActivityID indicates an expected call of GetActivityByActivityID.
func (mr *MockmutableStateMockRecorder) GetActivityByActivityID(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityByActivityID", reflect.TypeOf((*MockmutableState)(nil).GetActivityByActivityID), arg0)
}

// GetActivityInfo mocks base method.
func (m *MockmutableState) GetActivityInfo(arg0 int64) (*persistence.ActivityInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityInfo", arg0)
	ret0, _ := ret[0].(*persistence.ActivityInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetActivityInfo indicates an expected call of GetActivityInfo.
func (mr *MockmutableStateMockRecorder) GetActivityInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityInfo", reflect.TypeOf((*MockmutableState)(nil).GetActivityInfo), arg0)
}

// GetActivityInfoWithTimerHeartbeat mocks base method.
func (m *MockmutableState) GetActivityInfoWithTimerHeartbeat(scheduleEventID int64) (*persistence.ActivityInfo, time.Time, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityInfoWithTimerHeartbeat", scheduleEventID)
	ret0, _ := ret[0].(*persistence.ActivityInfo)
	ret1, _ := ret[1].(time.Time)
	ret2, _ := ret[2].(bool)
	return ret0, ret1, ret2
}

// GetActivityInfoWithTimerHeartbeat indicates an expected call of GetActivityInfoWithTimerHeartbeat.
func (mr *MockmutableStateMockRecorder) GetActivityInfoWithTimerHeartbeat(scheduleEventID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityInfoWithTimerHeartbeat", reflect.TypeOf((*MockmutableState)(nil).GetActivityInfoWithTimerHeartbeat), scheduleEventID)
}

// GetActivityScheduledEvent mocks base method.
func (m *MockmutableState) GetActivityScheduledEvent(arg0 int64) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetActivityScheduledEvent", arg0)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetActivityScheduledEvent indicates an expected call of GetActivityScheduledEvent.
func (mr *MockmutableStateMockRecorder) GetActivityScheduledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetActivityScheduledEvent", reflect.TypeOf((*MockmutableState)(nil).GetActivityScheduledEvent), arg0)
}

// GetChildExecutionInfo mocks base method.
func (m *MockmutableState) GetChildExecutionInfo(arg0 int64) (*persistence.ChildExecutionInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChildExecutionInfo", arg0)
	ret0, _ := ret[0].(*persistence.ChildExecutionInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetChildExecutionInfo indicates an expected call of GetChildExecutionInfo.
func (mr *MockmutableStateMockRecorder) GetChildExecutionInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChildExecutionInfo", reflect.TypeOf((*MockmutableState)(nil).GetChildExecutionInfo), arg0)
}

// GetChildExecutionInitiatedEvent mocks base method.
func (m *MockmutableState) GetChildExecutionInitiatedEvent(arg0 int64) (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChildExecutionInitiatedEvent", arg0)
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetChildExecutionInitiatedEvent indicates an expected call of GetChildExecutionInitiatedEvent.
func (mr *MockmutableStateMockRecorder) GetChildExecutionInitiatedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChildExecutionInitiatedEvent", reflect.TypeOf((*MockmutableState)(nil).GetChildExecutionInitiatedEvent), arg0)
}

// GetCompletionEvent mocks base method.
func (m *MockmutableState) GetCompletionEvent() (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCompletionEvent")
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCompletionEvent indicates an expected call of GetCompletionEvent.
func (mr *MockmutableStateMockRecorder) GetCompletionEvent() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCompletionEvent", reflect.TypeOf((*MockmutableState)(nil).GetCompletionEvent))
}

// GetCronBackoffDuration mocks base method.
func (m *MockmutableState) GetCronBackoffDuration() (time.Duration, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCronBackoffDuration")
	ret0, _ := ret[0].(time.Duration)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCronBackoffDuration indicates an expected call of GetCronBackoffDuration.
func (mr *MockmutableStateMockRecorder) GetCronBackoffDuration() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCronBackoffDuration", reflect.TypeOf((*MockmutableState)(nil).GetCronBackoffDuration))
}

// GetCurrentBranchToken mocks base method.
func (m *MockmutableState) GetCurrentBranchToken() ([]byte, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCurrentBranchToken")
	ret0, _ := ret[0].([]byte)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCurrentBranchToken indicates an expected call of GetCurrentBranchToken.
func (mr *MockmutableStateMockRecorder) GetCurrentBranchToken() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCurrentBranchToken", reflect.TypeOf((*MockmutableState)(nil).GetCurrentBranchToken))
}

// GetCurrentVersion mocks base method.
func (m *MockmutableState) GetCurrentVersion() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCurrentVersion")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetCurrentVersion indicates an expected call of GetCurrentVersion.
func (mr *MockmutableStateMockRecorder) GetCurrentVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCurrentVersion", reflect.TypeOf((*MockmutableState)(nil).GetCurrentVersion))
}

// GetExecutionInfo mocks base method.
func (m *MockmutableState) GetExecutionInfo() *persistence.WorkflowExecutionInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetExecutionInfo")
	ret0, _ := ret[0].(*persistence.WorkflowExecutionInfo)
	return ret0
}

// GetExecutionInfo indicates an expected call of GetExecutionInfo.
func (mr *MockmutableStateMockRecorder) GetExecutionInfo() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetExecutionInfo", reflect.TypeOf((*MockmutableState)(nil).GetExecutionInfo))
}

// GetExecutionState mocks base method.
func (m *MockmutableState) GetExecutionState() *persistence.WorkflowExecutionState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetExecutionState")
	ret0, _ := ret[0].(*persistence.WorkflowExecutionState)
	return ret0
}

// GetExecutionState indicates an expected call of GetExecutionState.
func (mr *MockmutableStateMockRecorder) GetExecutionState() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetExecutionState", reflect.TypeOf((*MockmutableState)(nil).GetExecutionState))
}

// GetHistoryBuilder mocks base method.
func (m *MockmutableState) GetHistoryBuilder() *historyBuilder {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHistoryBuilder")
	ret0, _ := ret[0].(*historyBuilder)
	return ret0
}

// GetHistoryBuilder indicates an expected call of GetHistoryBuilder.
func (mr *MockmutableStateMockRecorder) GetHistoryBuilder() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHistoryBuilder", reflect.TypeOf((*MockmutableState)(nil).GetHistoryBuilder))
}

// GetInFlightWorkflowTask mocks base method.
func (m *MockmutableState) GetInFlightWorkflowTask() (*workflowTaskInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInFlightWorkflowTask")
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetInFlightWorkflowTask indicates an expected call of GetInFlightWorkflowTask.
func (mr *MockmutableStateMockRecorder) GetInFlightWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInFlightWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).GetInFlightWorkflowTask))
}

// GetLastFirstEventID mocks base method.
func (m *MockmutableState) GetLastFirstEventID() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLastFirstEventID")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetLastFirstEventID indicates an expected call of GetLastFirstEventID.
func (mr *MockmutableStateMockRecorder) GetLastFirstEventID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLastFirstEventID", reflect.TypeOf((*MockmutableState)(nil).GetLastFirstEventID))
}

// GetLastWriteVersion mocks base method.
func (m *MockmutableState) GetLastWriteVersion() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLastWriteVersion")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLastWriteVersion indicates an expected call of GetLastWriteVersion.
func (mr *MockmutableStateMockRecorder) GetLastWriteVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLastWriteVersion", reflect.TypeOf((*MockmutableState)(nil).GetLastWriteVersion))
}

// GetNamespaceEntry mocks base method.
func (m *MockmutableState) GetNamespaceEntry() *cache.NamespaceCacheEntry {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNamespaceEntry")
	ret0, _ := ret[0].(*cache.NamespaceCacheEntry)
	return ret0
}

// GetNamespaceEntry indicates an expected call of GetNamespaceEntry.
func (mr *MockmutableStateMockRecorder) GetNamespaceEntry() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNamespaceEntry", reflect.TypeOf((*MockmutableState)(nil).GetNamespaceEntry))
}

// GetNextEventID mocks base method.
func (m *MockmutableState) GetNextEventID() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNextEventID")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetNextEventID indicates an expected call of GetNextEventID.
func (mr *MockmutableStateMockRecorder) GetNextEventID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNextEventID", reflect.TypeOf((*MockmutableState)(nil).GetNextEventID))
}

// GetPendingActivityInfos mocks base method.
func (m *MockmutableState) GetPendingActivityInfos() map[int64]*persistence.ActivityInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingActivityInfos")
	ret0, _ := ret[0].(map[int64]*persistence.ActivityInfo)
	return ret0
}

// GetPendingActivityInfos indicates an expected call of GetPendingActivityInfos.
func (mr *MockmutableStateMockRecorder) GetPendingActivityInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingActivityInfos", reflect.TypeOf((*MockmutableState)(nil).GetPendingActivityInfos))
}

// GetPendingChildExecutionInfos mocks base method.
func (m *MockmutableState) GetPendingChildExecutionInfos() map[int64]*persistence.ChildExecutionInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingChildExecutionInfos")
	ret0, _ := ret[0].(map[int64]*persistence.ChildExecutionInfo)
	return ret0
}

// GetPendingChildExecutionInfos indicates an expected call of GetPendingChildExecutionInfos.
func (mr *MockmutableStateMockRecorder) GetPendingChildExecutionInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingChildExecutionInfos", reflect.TypeOf((*MockmutableState)(nil).GetPendingChildExecutionInfos))
}

// GetPendingRequestCancelExternalInfos mocks base method.
func (m *MockmutableState) GetPendingRequestCancelExternalInfos() map[int64]*persistence.RequestCancelInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingRequestCancelExternalInfos")
	ret0, _ := ret[0].(map[int64]*persistence.RequestCancelInfo)
	return ret0
}

// GetPendingRequestCancelExternalInfos indicates an expected call of GetPendingRequestCancelExternalInfos.
func (mr *MockmutableStateMockRecorder) GetPendingRequestCancelExternalInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingRequestCancelExternalInfos", reflect.TypeOf((*MockmutableState)(nil).GetPendingRequestCancelExternalInfos))
}

// GetPendingSignalExternalInfos mocks base method.
func (m *MockmutableState) GetPendingSignalExternalInfos() map[int64]*persistence.SignalInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingSignalExternalInfos")
	ret0, _ := ret[0].(map[int64]*persistence.SignalInfo)
	return ret0
}

// GetPendingSignalExternalInfos indicates an expected call of GetPendingSignalExternalInfos.
func (mr *MockmutableStateMockRecorder) GetPendingSignalExternalInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingSignalExternalInfos", reflect.TypeOf((*MockmutableState)(nil).GetPendingSignalExternalInfos))
}

// GetPendingTimerInfos mocks base method.
func (m *MockmutableState) GetPendingTimerInfos() map[string]*persistence.TimerInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingTimerInfos")
	ret0, _ := ret[0].(map[string]*persistence.TimerInfo)
	return ret0
}

// GetPendingTimerInfos indicates an expected call of GetPendingTimerInfos.
func (mr *MockmutableStateMockRecorder) GetPendingTimerInfos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingTimerInfos", reflect.TypeOf((*MockmutableState)(nil).GetPendingTimerInfos))
}

// GetPendingWorkflowTask mocks base method.
func (m *MockmutableState) GetPendingWorkflowTask() (*workflowTaskInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPendingWorkflowTask")
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetPendingWorkflowTask indicates an expected call of GetPendingWorkflowTask.
func (mr *MockmutableStateMockRecorder) GetPendingWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPendingWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).GetPendingWorkflowTask))
}

// GetPreviousStartedEventID mocks base method.
func (m *MockmutableState) GetPreviousStartedEventID() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPreviousStartedEventID")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetPreviousStartedEventID indicates an expected call of GetPreviousStartedEventID.
func (mr *MockmutableStateMockRecorder) GetPreviousStartedEventID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPreviousStartedEventID", reflect.TypeOf((*MockmutableState)(nil).GetPreviousStartedEventID))
}

// GetQueryRegistry mocks base method.
func (m *MockmutableState) GetQueryRegistry() queryRegistry {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetQueryRegistry")
	ret0, _ := ret[0].(queryRegistry)
	return ret0
}

// GetQueryRegistry indicates an expected call of GetQueryRegistry.
func (mr *MockmutableStateMockRecorder) GetQueryRegistry() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetQueryRegistry", reflect.TypeOf((*MockmutableState)(nil).GetQueryRegistry))
}

// GetRequestCancelInfo mocks base method.
func (m *MockmutableState) GetRequestCancelInfo(arg0 int64) (*persistence.RequestCancelInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRequestCancelInfo", arg0)
	ret0, _ := ret[0].(*persistence.RequestCancelInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetRequestCancelInfo indicates an expected call of GetRequestCancelInfo.
func (mr *MockmutableStateMockRecorder) GetRequestCancelInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRequestCancelInfo", reflect.TypeOf((*MockmutableState)(nil).GetRequestCancelInfo), arg0)
}

// GetRetryBackoffDuration mocks base method.
func (m *MockmutableState) GetRetryBackoffDuration(failure *failure.Failure) (time.Duration, enums.RetryState) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRetryBackoffDuration", failure)
	ret0, _ := ret[0].(time.Duration)
	ret1, _ := ret[1].(enums.RetryState)
	return ret0, ret1
}

// GetRetryBackoffDuration indicates an expected call of GetRetryBackoffDuration.
func (mr *MockmutableStateMockRecorder) GetRetryBackoffDuration(failure interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRetryBackoffDuration", reflect.TypeOf((*MockmutableState)(nil).GetRetryBackoffDuration), failure)
}

// GetSignalInfo mocks base method.
func (m *MockmutableState) GetSignalInfo(arg0 int64) (*persistence.SignalInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSignalInfo", arg0)
	ret0, _ := ret[0].(*persistence.SignalInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetSignalInfo indicates an expected call of GetSignalInfo.
func (mr *MockmutableStateMockRecorder) GetSignalInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSignalInfo", reflect.TypeOf((*MockmutableState)(nil).GetSignalInfo), arg0)
}

// GetStartEvent mocks base method.
func (m *MockmutableState) GetStartEvent() (*history.HistoryEvent, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetStartEvent")
	ret0, _ := ret[0].(*history.HistoryEvent)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetStartEvent indicates an expected call of GetStartEvent.
func (mr *MockmutableStateMockRecorder) GetStartEvent() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStartEvent", reflect.TypeOf((*MockmutableState)(nil).GetStartEvent))
}

// GetStartVersion mocks base method.
func (m *MockmutableState) GetStartVersion() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetStartVersion")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetStartVersion indicates an expected call of GetStartVersion.
func (mr *MockmutableStateMockRecorder) GetStartVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStartVersion", reflect.TypeOf((*MockmutableState)(nil).GetStartVersion))
}

// GetUpdateCondition mocks base method.
func (m *MockmutableState) GetUpdateCondition() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUpdateCondition")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetUpdateCondition indicates an expected call of GetUpdateCondition.
func (mr *MockmutableStateMockRecorder) GetUpdateCondition() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUpdateCondition", reflect.TypeOf((*MockmutableState)(nil).GetUpdateCondition))
}

// GetUserTimerInfo mocks base method.
func (m *MockmutableState) GetUserTimerInfo(arg0 string) (*persistence.TimerInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserTimerInfo", arg0)
	ret0, _ := ret[0].(*persistence.TimerInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetUserTimerInfo indicates an expected call of GetUserTimerInfo.
func (mr *MockmutableStateMockRecorder) GetUserTimerInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserTimerInfo", reflect.TypeOf((*MockmutableState)(nil).GetUserTimerInfo), arg0)
}

// GetUserTimerInfoByEventID mocks base method.
func (m *MockmutableState) GetUserTimerInfoByEventID(arg0 int64) (*persistence.TimerInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserTimerInfoByEventID", arg0)
	ret0, _ := ret[0].(*persistence.TimerInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetUserTimerInfoByEventID indicates an expected call of GetUserTimerInfoByEventID.
func (mr *MockmutableStateMockRecorder) GetUserTimerInfoByEventID(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserTimerInfoByEventID", reflect.TypeOf((*MockmutableState)(nil).GetUserTimerInfoByEventID), arg0)
}

// GetWorkflowStateStatus mocks base method.
func (m *MockmutableState) GetWorkflowStateStatus() (enums0.WorkflowExecutionState, enums.WorkflowExecutionStatus) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowStateStatus")
	ret0, _ := ret[0].(enums0.WorkflowExecutionState)
	ret1, _ := ret[1].(enums.WorkflowExecutionStatus)
	return ret0, ret1
}

// GetWorkflowStateStatus indicates an expected call of GetWorkflowStateStatus.
func (mr *MockmutableStateMockRecorder) GetWorkflowStateStatus() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowStateStatus", reflect.TypeOf((*MockmutableState)(nil).GetWorkflowStateStatus))
}

// GetWorkflowTaskInfo mocks base method.
func (m *MockmutableState) GetWorkflowTaskInfo(arg0 int64) (*workflowTaskInfo, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowTaskInfo", arg0)
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// GetWorkflowTaskInfo indicates an expected call of GetWorkflowTaskInfo.
func (mr *MockmutableStateMockRecorder) GetWorkflowTaskInfo(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowTaskInfo", reflect.TypeOf((*MockmutableState)(nil).GetWorkflowTaskInfo), arg0)
}

// GetWorkflowType mocks base method.
func (m *MockmutableState) GetWorkflowType() *common.WorkflowType {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowType")
	ret0, _ := ret[0].(*common.WorkflowType)
	return ret0
}

// GetWorkflowType indicates an expected call of GetWorkflowType.
func (mr *MockmutableStateMockRecorder) GetWorkflowType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowType", reflect.TypeOf((*MockmutableState)(nil).GetWorkflowType))
}

// HasBufferedEvents mocks base method.
func (m *MockmutableState) HasBufferedEvents() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasBufferedEvents")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasBufferedEvents indicates an expected call of HasBufferedEvents.
func (mr *MockmutableStateMockRecorder) HasBufferedEvents() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasBufferedEvents", reflect.TypeOf((*MockmutableState)(nil).HasBufferedEvents))
}

// HasInFlightWorkflowTask mocks base method.
func (m *MockmutableState) HasInFlightWorkflowTask() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasInFlightWorkflowTask")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasInFlightWorkflowTask indicates an expected call of HasInFlightWorkflowTask.
func (mr *MockmutableStateMockRecorder) HasInFlightWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasInFlightWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).HasInFlightWorkflowTask))
}

// HasParentExecution mocks base method.
func (m *MockmutableState) HasParentExecution() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasParentExecution")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasParentExecution indicates an expected call of HasParentExecution.
func (mr *MockmutableStateMockRecorder) HasParentExecution() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasParentExecution", reflect.TypeOf((*MockmutableState)(nil).HasParentExecution))
}

// HasPendingWorkflowTask mocks base method.
func (m *MockmutableState) HasPendingWorkflowTask() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasPendingWorkflowTask")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasPendingWorkflowTask indicates an expected call of HasPendingWorkflowTask.
func (mr *MockmutableStateMockRecorder) HasPendingWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasPendingWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).HasPendingWorkflowTask))
}

// HasProcessedOrPendingWorkflowTask mocks base method.
func (m *MockmutableState) HasProcessedOrPendingWorkflowTask() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasProcessedOrPendingWorkflowTask")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasProcessedOrPendingWorkflowTask indicates an expected call of HasProcessedOrPendingWorkflowTask.
func (mr *MockmutableStateMockRecorder) HasProcessedOrPendingWorkflowTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasProcessedOrPendingWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).HasProcessedOrPendingWorkflowTask))
}

// IsCancelRequested mocks base method.
func (m *MockmutableState) IsCancelRequested() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsCancelRequested")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsCancelRequested indicates an expected call of IsCancelRequested.
func (mr *MockmutableStateMockRecorder) IsCancelRequested() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsCancelRequested", reflect.TypeOf((*MockmutableState)(nil).IsCancelRequested))
}

// IsCurrentWorkflowGuaranteed mocks base method.
func (m *MockmutableState) IsCurrentWorkflowGuaranteed() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsCurrentWorkflowGuaranteed")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsCurrentWorkflowGuaranteed indicates an expected call of IsCurrentWorkflowGuaranteed.
func (mr *MockmutableStateMockRecorder) IsCurrentWorkflowGuaranteed() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsCurrentWorkflowGuaranteed", reflect.TypeOf((*MockmutableState)(nil).IsCurrentWorkflowGuaranteed))
}

// IsResourceDuplicated mocks base method.
func (m *MockmutableState) IsResourceDuplicated(resourceDedupKey definition.DeduplicationID) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsResourceDuplicated", resourceDedupKey)
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsResourceDuplicated indicates an expected call of IsResourceDuplicated.
func (mr *MockmutableStateMockRecorder) IsResourceDuplicated(resourceDedupKey interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsResourceDuplicated", reflect.TypeOf((*MockmutableState)(nil).IsResourceDuplicated), resourceDedupKey)
}

// IsSignalRequested mocks base method.
func (m *MockmutableState) IsSignalRequested(requestID string) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSignalRequested", requestID)
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsSignalRequested indicates an expected call of IsSignalRequested.
func (mr *MockmutableStateMockRecorder) IsSignalRequested(requestID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSignalRequested", reflect.TypeOf((*MockmutableState)(nil).IsSignalRequested), requestID)
}

// IsStickyTaskQueueEnabled mocks base method.
func (m *MockmutableState) IsStickyTaskQueueEnabled() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsStickyTaskQueueEnabled")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsStickyTaskQueueEnabled indicates an expected call of IsStickyTaskQueueEnabled.
func (mr *MockmutableStateMockRecorder) IsStickyTaskQueueEnabled() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsStickyTaskQueueEnabled", reflect.TypeOf((*MockmutableState)(nil).IsStickyTaskQueueEnabled))
}

// IsWorkflowExecutionRunning mocks base method.
func (m *MockmutableState) IsWorkflowExecutionRunning() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsWorkflowExecutionRunning")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsWorkflowExecutionRunning indicates an expected call of IsWorkflowExecutionRunning.
func (mr *MockmutableStateMockRecorder) IsWorkflowExecutionRunning() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsWorkflowExecutionRunning", reflect.TypeOf((*MockmutableState)(nil).IsWorkflowExecutionRunning))
}

// Load mocks base method.
func (m *MockmutableState) Load(arg0 *persistence.WorkflowMutableState) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Load", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// Load indicates an expected call of Load.
func (mr *MockmutableStateMockRecorder) Load(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Load", reflect.TypeOf((*MockmutableState)(nil).Load), arg0)
}

// ReplicateActivityInfo mocks base method.
func (m *MockmutableState) ReplicateActivityInfo(arg0 *historyservice.SyncActivityRequest, arg1 bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityInfo", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityInfo indicates an expected call of ReplicateActivityInfo.
func (mr *MockmutableStateMockRecorder) ReplicateActivityInfo(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityInfo", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityInfo), arg0, arg1)
}

// ReplicateActivityTaskCancelRequestedEvent mocks base method.
func (m *MockmutableState) ReplicateActivityTaskCancelRequestedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskCancelRequestedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskCancelRequestedEvent indicates an expected call of ReplicateActivityTaskCancelRequestedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateActivityTaskCancelRequestedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskCancelRequestedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityTaskCancelRequestedEvent), arg0)
}

// ReplicateActivityTaskCanceledEvent mocks base method.
func (m *MockmutableState) ReplicateActivityTaskCanceledEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskCanceledEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskCanceledEvent indicates an expected call of ReplicateActivityTaskCanceledEvent.
func (mr *MockmutableStateMockRecorder) ReplicateActivityTaskCanceledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityTaskCanceledEvent), arg0)
}

// ReplicateActivityTaskCompletedEvent mocks base method.
func (m *MockmutableState) ReplicateActivityTaskCompletedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskCompletedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskCompletedEvent indicates an expected call of ReplicateActivityTaskCompletedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateActivityTaskCompletedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskCompletedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityTaskCompletedEvent), arg0)
}

// ReplicateActivityTaskFailedEvent mocks base method.
func (m *MockmutableState) ReplicateActivityTaskFailedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskFailedEvent indicates an expected call of ReplicateActivityTaskFailedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateActivityTaskFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskFailedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityTaskFailedEvent), arg0)
}

// ReplicateActivityTaskScheduledEvent mocks base method.
func (m *MockmutableState) ReplicateActivityTaskScheduledEvent(arg0 int64, arg1 *history.HistoryEvent) (*persistence.ActivityInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskScheduledEvent", arg0, arg1)
	ret0, _ := ret[0].(*persistence.ActivityInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateActivityTaskScheduledEvent indicates an expected call of ReplicateActivityTaskScheduledEvent.
func (mr *MockmutableStateMockRecorder) ReplicateActivityTaskScheduledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskScheduledEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityTaskScheduledEvent), arg0, arg1)
}

// ReplicateActivityTaskStartedEvent mocks base method.
func (m *MockmutableState) ReplicateActivityTaskStartedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskStartedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskStartedEvent indicates an expected call of ReplicateActivityTaskStartedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateActivityTaskStartedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskStartedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityTaskStartedEvent), arg0)
}

// ReplicateActivityTaskTimedOutEvent mocks base method.
func (m *MockmutableState) ReplicateActivityTaskTimedOutEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateActivityTaskTimedOutEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateActivityTaskTimedOutEvent indicates an expected call of ReplicateActivityTaskTimedOutEvent.
func (mr *MockmutableStateMockRecorder) ReplicateActivityTaskTimedOutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateActivityTaskTimedOutEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateActivityTaskTimedOutEvent), arg0)
}

// ReplicateChildWorkflowExecutionCanceledEvent mocks base method.
func (m *MockmutableState) ReplicateChildWorkflowExecutionCanceledEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionCanceledEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionCanceledEvent indicates an expected call of ReplicateChildWorkflowExecutionCanceledEvent.
func (mr *MockmutableStateMockRecorder) ReplicateChildWorkflowExecutionCanceledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateChildWorkflowExecutionCanceledEvent), arg0)
}

// ReplicateChildWorkflowExecutionCompletedEvent mocks base method.
func (m *MockmutableState) ReplicateChildWorkflowExecutionCompletedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionCompletedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionCompletedEvent indicates an expected call of ReplicateChildWorkflowExecutionCompletedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateChildWorkflowExecutionCompletedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionCompletedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateChildWorkflowExecutionCompletedEvent), arg0)
}

// ReplicateChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) ReplicateChildWorkflowExecutionFailedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionFailedEvent indicates an expected call of ReplicateChildWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateChildWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateChildWorkflowExecutionFailedEvent), arg0)
}

// ReplicateChildWorkflowExecutionStartedEvent mocks base method.
func (m *MockmutableState) ReplicateChildWorkflowExecutionStartedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionStartedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionStartedEvent indicates an expected call of ReplicateChildWorkflowExecutionStartedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateChildWorkflowExecutionStartedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionStartedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateChildWorkflowExecutionStartedEvent), arg0)
}

// ReplicateChildWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockmutableState) ReplicateChildWorkflowExecutionTerminatedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionTerminatedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionTerminatedEvent indicates an expected call of ReplicateChildWorkflowExecutionTerminatedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateChildWorkflowExecutionTerminatedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateChildWorkflowExecutionTerminatedEvent), arg0)
}

// ReplicateChildWorkflowExecutionTimedOutEvent mocks base method.
func (m *MockmutableState) ReplicateChildWorkflowExecutionTimedOutEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateChildWorkflowExecutionTimedOutEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateChildWorkflowExecutionTimedOutEvent indicates an expected call of ReplicateChildWorkflowExecutionTimedOutEvent.
func (mr *MockmutableStateMockRecorder) ReplicateChildWorkflowExecutionTimedOutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateChildWorkflowExecutionTimedOutEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateChildWorkflowExecutionTimedOutEvent), arg0)
}

// ReplicateExternalWorkflowExecutionCancelRequested mocks base method.
func (m *MockmutableState) ReplicateExternalWorkflowExecutionCancelRequested(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateExternalWorkflowExecutionCancelRequested", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateExternalWorkflowExecutionCancelRequested indicates an expected call of ReplicateExternalWorkflowExecutionCancelRequested.
func (mr *MockmutableStateMockRecorder) ReplicateExternalWorkflowExecutionCancelRequested(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateExternalWorkflowExecutionCancelRequested", reflect.TypeOf((*MockmutableState)(nil).ReplicateExternalWorkflowExecutionCancelRequested), arg0)
}

// ReplicateExternalWorkflowExecutionSignaled mocks base method.
func (m *MockmutableState) ReplicateExternalWorkflowExecutionSignaled(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateExternalWorkflowExecutionSignaled", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateExternalWorkflowExecutionSignaled indicates an expected call of ReplicateExternalWorkflowExecutionSignaled.
func (mr *MockmutableStateMockRecorder) ReplicateExternalWorkflowExecutionSignaled(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateExternalWorkflowExecutionSignaled", reflect.TypeOf((*MockmutableState)(nil).ReplicateExternalWorkflowExecutionSignaled), arg0)
}

// ReplicateRequestCancelExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) ReplicateRequestCancelExternalWorkflowExecutionFailedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateRequestCancelExternalWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateRequestCancelExternalWorkflowExecutionFailedEvent indicates an expected call of ReplicateRequestCancelExternalWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateRequestCancelExternalWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateRequestCancelExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateRequestCancelExternalWorkflowExecutionFailedEvent), arg0)
}

// ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockmutableState) ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 *history.HistoryEvent, arg2 string) (*persistence.RequestCancelInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*persistence.RequestCancelInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent indicates an expected call of ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// ReplicateSignalExternalWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) ReplicateSignalExternalWorkflowExecutionFailedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateSignalExternalWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateSignalExternalWorkflowExecutionFailedEvent indicates an expected call of ReplicateSignalExternalWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateSignalExternalWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateSignalExternalWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateSignalExternalWorkflowExecutionFailedEvent), arg0)
}

// ReplicateSignalExternalWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockmutableState) ReplicateSignalExternalWorkflowExecutionInitiatedEvent(arg0 int64, arg1 *history.HistoryEvent, arg2 string) (*persistence.SignalInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateSignalExternalWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*persistence.SignalInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateSignalExternalWorkflowExecutionInitiatedEvent indicates an expected call of ReplicateSignalExternalWorkflowExecutionInitiatedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateSignalExternalWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateSignalExternalWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateSignalExternalWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// ReplicateStartChildWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) ReplicateStartChildWorkflowExecutionFailedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateStartChildWorkflowExecutionFailedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateStartChildWorkflowExecutionFailedEvent indicates an expected call of ReplicateStartChildWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateStartChildWorkflowExecutionFailedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateStartChildWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateStartChildWorkflowExecutionFailedEvent), arg0)
}

// ReplicateStartChildWorkflowExecutionInitiatedEvent mocks base method.
func (m *MockmutableState) ReplicateStartChildWorkflowExecutionInitiatedEvent(arg0 int64, arg1 *history.HistoryEvent, arg2 string) (*persistence.ChildExecutionInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateStartChildWorkflowExecutionInitiatedEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(*persistence.ChildExecutionInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateStartChildWorkflowExecutionInitiatedEvent indicates an expected call of ReplicateStartChildWorkflowExecutionInitiatedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateStartChildWorkflowExecutionInitiatedEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateStartChildWorkflowExecutionInitiatedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateStartChildWorkflowExecutionInitiatedEvent), arg0, arg1, arg2)
}

// ReplicateTimerCanceledEvent mocks base method.
func (m *MockmutableState) ReplicateTimerCanceledEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTimerCanceledEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateTimerCanceledEvent indicates an expected call of ReplicateTimerCanceledEvent.
func (mr *MockmutableStateMockRecorder) ReplicateTimerCanceledEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTimerCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateTimerCanceledEvent), arg0)
}

// ReplicateTimerFiredEvent mocks base method.
func (m *MockmutableState) ReplicateTimerFiredEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTimerFiredEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateTimerFiredEvent indicates an expected call of ReplicateTimerFiredEvent.
func (mr *MockmutableStateMockRecorder) ReplicateTimerFiredEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTimerFiredEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateTimerFiredEvent), arg0)
}

// ReplicateTimerStartedEvent mocks base method.
func (m *MockmutableState) ReplicateTimerStartedEvent(arg0 *history.HistoryEvent) (*persistence.TimerInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTimerStartedEvent", arg0)
	ret0, _ := ret[0].(*persistence.TimerInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateTimerStartedEvent indicates an expected call of ReplicateTimerStartedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateTimerStartedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTimerStartedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateTimerStartedEvent), arg0)
}

// ReplicateTransientWorkflowTaskScheduled mocks base method.
func (m *MockmutableState) ReplicateTransientWorkflowTaskScheduled() (*workflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateTransientWorkflowTaskScheduled")
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateTransientWorkflowTaskScheduled indicates an expected call of ReplicateTransientWorkflowTaskScheduled.
func (mr *MockmutableStateMockRecorder) ReplicateTransientWorkflowTaskScheduled() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateTransientWorkflowTaskScheduled", reflect.TypeOf((*MockmutableState)(nil).ReplicateTransientWorkflowTaskScheduled))
}

// ReplicateUpsertWorkflowSearchAttributesEvent mocks base method.
func (m *MockmutableState) ReplicateUpsertWorkflowSearchAttributesEvent(arg0 *history.HistoryEvent) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "ReplicateUpsertWorkflowSearchAttributesEvent", arg0)
}

// ReplicateUpsertWorkflowSearchAttributesEvent indicates an expected call of ReplicateUpsertWorkflowSearchAttributesEvent.
func (mr *MockmutableStateMockRecorder) ReplicateUpsertWorkflowSearchAttributesEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateUpsertWorkflowSearchAttributesEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateUpsertWorkflowSearchAttributesEvent), arg0)
}

// ReplicateWorkflowExecutionCancelRequestedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionCancelRequestedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionCancelRequestedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionCancelRequestedEvent indicates an expected call of ReplicateWorkflowExecutionCancelRequestedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionCancelRequestedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionCancelRequestedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionCancelRequestedEvent), arg0)
}

// ReplicateWorkflowExecutionCanceledEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionCanceledEvent(arg0 int64, arg1 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionCanceledEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionCanceledEvent indicates an expected call of ReplicateWorkflowExecutionCanceledEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionCanceledEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionCanceledEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionCanceledEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionCompletedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionCompletedEvent(arg0 int64, arg1 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionCompletedEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionCompletedEvent indicates an expected call of ReplicateWorkflowExecutionCompletedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionCompletedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionCompletedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionCompletedEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionContinuedAsNewEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionContinuedAsNewEvent(arg0 int64, arg1 string, arg2 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionContinuedAsNewEvent", arg0, arg1, arg2)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionContinuedAsNewEvent indicates an expected call of ReplicateWorkflowExecutionContinuedAsNewEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionContinuedAsNewEvent(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionContinuedAsNewEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionContinuedAsNewEvent), arg0, arg1, arg2)
}

// ReplicateWorkflowExecutionFailedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionFailedEvent(arg0 int64, arg1 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionFailedEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionFailedEvent indicates an expected call of ReplicateWorkflowExecutionFailedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionFailedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionFailedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionFailedEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionSignaled mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionSignaled(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionSignaled", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionSignaled indicates an expected call of ReplicateWorkflowExecutionSignaled.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionSignaled(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionSignaled", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionSignaled), arg0)
}

// ReplicateWorkflowExecutionStartedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionStartedEvent(arg0 string, arg1 common.WorkflowExecution, arg2 string, arg3 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionStartedEvent", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionStartedEvent indicates an expected call of ReplicateWorkflowExecutionStartedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionStartedEvent(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionStartedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionStartedEvent), arg0, arg1, arg2, arg3)
}

// ReplicateWorkflowExecutionTerminatedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionTerminatedEvent(arg0 int64, arg1 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionTerminatedEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionTerminatedEvent indicates an expected call of ReplicateWorkflowExecutionTerminatedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionTerminatedEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionTerminatedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionTerminatedEvent), arg0, arg1)
}

// ReplicateWorkflowExecutionTimedoutEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowExecutionTimedoutEvent(arg0 int64, arg1 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowExecutionTimedoutEvent", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowExecutionTimedoutEvent indicates an expected call of ReplicateWorkflowExecutionTimedoutEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowExecutionTimedoutEvent(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowExecutionTimedoutEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowExecutionTimedoutEvent), arg0, arg1)
}

// ReplicateWorkflowTaskCompletedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowTaskCompletedEvent(arg0 *history.HistoryEvent) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskCompletedEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowTaskCompletedEvent indicates an expected call of ReplicateWorkflowTaskCompletedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowTaskCompletedEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskCompletedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowTaskCompletedEvent), arg0)
}

// ReplicateWorkflowTaskFailedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowTaskFailedEvent() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskFailedEvent")
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowTaskFailedEvent indicates an expected call of ReplicateWorkflowTaskFailedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowTaskFailedEvent() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskFailedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowTaskFailedEvent))
}

// ReplicateWorkflowTaskScheduledEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowTaskScheduledEvent(arg0, arg1 int64, arg2 *taskqueue.TaskQueue, arg3, arg4 int32, arg5, arg6 *time.Time) (*workflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskScheduledEvent", arg0, arg1, arg2, arg3, arg4, arg5, arg6)
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateWorkflowTaskScheduledEvent indicates an expected call of ReplicateWorkflowTaskScheduledEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowTaskScheduledEvent(arg0, arg1, arg2, arg3, arg4, arg5, arg6 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskScheduledEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowTaskScheduledEvent), arg0, arg1, arg2, arg3, arg4, arg5, arg6)
}

// ReplicateWorkflowTaskStartedEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowTaskStartedEvent(arg0 *workflowTaskInfo, arg1, arg2, arg3 int64, arg4 string, arg5 time.Time) (*workflowTaskInfo, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskStartedEvent", arg0, arg1, arg2, arg3, arg4, arg5)
	ret0, _ := ret[0].(*workflowTaskInfo)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplicateWorkflowTaskStartedEvent indicates an expected call of ReplicateWorkflowTaskStartedEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowTaskStartedEvent(arg0, arg1, arg2, arg3, arg4, arg5 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskStartedEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowTaskStartedEvent), arg0, arg1, arg2, arg3, arg4, arg5)
}

// ReplicateWorkflowTaskTimedOutEvent mocks base method.
func (m *MockmutableState) ReplicateWorkflowTaskTimedOutEvent(arg0 enums.TimeoutType) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicateWorkflowTaskTimedOutEvent", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReplicateWorkflowTaskTimedOutEvent indicates an expected call of ReplicateWorkflowTaskTimedOutEvent.
func (mr *MockmutableStateMockRecorder) ReplicateWorkflowTaskTimedOutEvent(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicateWorkflowTaskTimedOutEvent", reflect.TypeOf((*MockmutableState)(nil).ReplicateWorkflowTaskTimedOutEvent), arg0)
}

// RetryActivity mocks base method.
func (m *MockmutableState) RetryActivity(ai *persistence.ActivityInfo, failure *failure.Failure) (enums.RetryState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RetryActivity", ai, failure)
	ret0, _ := ret[0].(enums.RetryState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RetryActivity indicates an expected call of RetryActivity.
func (mr *MockmutableStateMockRecorder) RetryActivity(ai, failure interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RetryActivity", reflect.TypeOf((*MockmutableState)(nil).RetryActivity), ai, failure)
}

// SetCurrentBranchToken mocks base method.
func (m *MockmutableState) SetCurrentBranchToken(branchToken []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetCurrentBranchToken", branchToken)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetCurrentBranchToken indicates an expected call of SetCurrentBranchToken.
func (mr *MockmutableStateMockRecorder) SetCurrentBranchToken(branchToken interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCurrentBranchToken", reflect.TypeOf((*MockmutableState)(nil).SetCurrentBranchToken), branchToken)
}

// SetHistoryBuilder mocks base method.
func (m *MockmutableState) SetHistoryBuilder(hBuilder *historyBuilder) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetHistoryBuilder", hBuilder)
}

// SetHistoryBuilder indicates an expected call of SetHistoryBuilder.
func (mr *MockmutableStateMockRecorder) SetHistoryBuilder(hBuilder interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHistoryBuilder", reflect.TypeOf((*MockmutableState)(nil).SetHistoryBuilder), hBuilder)
}

// SetHistoryTree mocks base method.
func (m *MockmutableState) SetHistoryTree(treeID string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHistoryTree", treeID)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetHistoryTree indicates an expected call of SetHistoryTree.
func (mr *MockmutableStateMockRecorder) SetHistoryTree(treeID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHistoryTree", reflect.TypeOf((*MockmutableState)(nil).SetHistoryTree), treeID)
}

// SetNextEventID mocks base method.
func (m *MockmutableState) SetNextEventID(nextEventID int64) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetNextEventID", nextEventID)
}

// SetNextEventID indicates an expected call of SetNextEventID.
func (mr *MockmutableStateMockRecorder) SetNextEventID(nextEventID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetNextEventID", reflect.TypeOf((*MockmutableState)(nil).SetNextEventID), nextEventID)
}

// SetUpdateCondition mocks base method.
func (m *MockmutableState) SetUpdateCondition(arg0 int64) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetUpdateCondition", arg0)
}

// SetUpdateCondition indicates an expected call of SetUpdateCondition.
func (mr *MockmutableStateMockRecorder) SetUpdateCondition(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetUpdateCondition", reflect.TypeOf((*MockmutableState)(nil).SetUpdateCondition), arg0)
}

// StartTransaction mocks base method.
func (m *MockmutableState) StartTransaction(entry *cache.NamespaceCacheEntry) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartTransaction", entry)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartTransaction indicates an expected call of StartTransaction.
func (mr *MockmutableStateMockRecorder) StartTransaction(entry interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartTransaction", reflect.TypeOf((*MockmutableState)(nil).StartTransaction), entry)
}

// StartTransactionSkipWorkflowTaskFail mocks base method.
func (m *MockmutableState) StartTransactionSkipWorkflowTaskFail(entry *cache.NamespaceCacheEntry) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartTransactionSkipWorkflowTaskFail", entry)
	ret0, _ := ret[0].(error)
	return ret0
}

// StartTransactionSkipWorkflowTaskFail indicates an expected call of StartTransactionSkipWorkflowTaskFail.
func (mr *MockmutableStateMockRecorder) StartTransactionSkipWorkflowTaskFail(entry interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartTransactionSkipWorkflowTaskFail", reflect.TypeOf((*MockmutableState)(nil).StartTransactionSkipWorkflowTaskFail), entry)
}

// UpdateActivity mocks base method.
func (m *MockmutableState) UpdateActivity(arg0 *persistence.ActivityInfo) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateActivity", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateActivity indicates an expected call of UpdateActivity.
func (mr *MockmutableStateMockRecorder) UpdateActivity(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateActivity", reflect.TypeOf((*MockmutableState)(nil).UpdateActivity), arg0)
}

// UpdateActivityProgress mocks base method.
func (m *MockmutableState) UpdateActivityProgress(ai *persistence.ActivityInfo, request *workflowservice.RecordActivityTaskHeartbeatRequest) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateActivityProgress", ai, request)
}

// UpdateActivityProgress indicates an expected call of UpdateActivityProgress.
func (mr *MockmutableStateMockRecorder) UpdateActivityProgress(ai, request interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateActivityProgress", reflect.TypeOf((*MockmutableState)(nil).UpdateActivityProgress), ai, request)
}

// UpdateActivityWithTimerHeartbeat mocks base method.
func (m *MockmutableState) UpdateActivityWithTimerHeartbeat(arg0 *persistence.ActivityInfo, arg1 time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateActivityWithTimerHeartbeat", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateActivityWithTimerHeartbeat indicates an expected call of UpdateActivityWithTimerHeartbeat.
func (mr *MockmutableStateMockRecorder) UpdateActivityWithTimerHeartbeat(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateActivityWithTimerHeartbeat", reflect.TypeOf((*MockmutableState)(nil).UpdateActivityWithTimerHeartbeat), arg0, arg1)
}

// UpdateCurrentVersion mocks base method.
func (m *MockmutableState) UpdateCurrentVersion(version int64, forceUpdate bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateCurrentVersion", version, forceUpdate)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateCurrentVersion indicates an expected call of UpdateCurrentVersion.
func (mr *MockmutableStateMockRecorder) UpdateCurrentVersion(version, forceUpdate interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateCurrentVersion", reflect.TypeOf((*MockmutableState)(nil).UpdateCurrentVersion), version, forceUpdate)
}

// UpdateDuplicatedResource mocks base method.
func (m *MockmutableState) UpdateDuplicatedResource(resourceDedupKey definition.DeduplicationID) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateDuplicatedResource", resourceDedupKey)
}

// UpdateDuplicatedResource indicates an expected call of UpdateDuplicatedResource.
func (mr *MockmutableStateMockRecorder) UpdateDuplicatedResource(resourceDedupKey interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDuplicatedResource", reflect.TypeOf((*MockmutableState)(nil).UpdateDuplicatedResource), resourceDedupKey)
}

// UpdateUserTimer mocks base method.
func (m *MockmutableState) UpdateUserTimer(arg0 *persistence.TimerInfo) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUserTimer", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateUserTimer indicates an expected call of UpdateUserTimer.
func (mr *MockmutableStateMockRecorder) UpdateUserTimer(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUserTimer", reflect.TypeOf((*MockmutableState)(nil).UpdateUserTimer), arg0)
}

// UpdateWorkflowStateStatus mocks base method.
func (m *MockmutableState) UpdateWorkflowStateStatus(state enums0.WorkflowExecutionState, status enums.WorkflowExecutionStatus) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateWorkflowStateStatus", state, status)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateWorkflowStateStatus indicates an expected call of UpdateWorkflowStateStatus.
func (mr *MockmutableStateMockRecorder) UpdateWorkflowStateStatus(state, status interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowStateStatus", reflect.TypeOf((*MockmutableState)(nil).UpdateWorkflowStateStatus), state, status)
}

// UpdateWorkflowTask mocks base method.
func (m *MockmutableState) UpdateWorkflowTask(arg0 *workflowTaskInfo) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "UpdateWorkflowTask", arg0)
}

// UpdateWorkflowTask indicates an expected call of UpdateWorkflowTask.
func (mr *MockmutableStateMockRecorder) UpdateWorkflowTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateWorkflowTask", reflect.TypeOf((*MockmutableState)(nil).UpdateWorkflowTask), arg0)
}
