// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/archiver/v1/message.proto

package archiver

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v12 "go.temporal.io/api/common/v1"
	v11 "go.temporal.io/api/enums/v1"
	v1 "go.temporal.io/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type HistoryBlobHeader struct {
	Namespace            string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	NamespaceId          string `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId           string `protobuf:"bytes,3,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId                string `protobuf:"bytes,4,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	IsLast               bool   `protobuf:"varint,5,opt,name=is_last,json=isLast,proto3" json:"is_last,omitempty"`
	FirstFailoverVersion int64  `protobuf:"varint,6,opt,name=first_failover_version,json=firstFailoverVersion,proto3" json:"first_failover_version,omitempty"`
	LastFailoverVersion  int64  `protobuf:"varint,7,opt,name=last_failover_version,json=lastFailoverVersion,proto3" json:"last_failover_version,omitempty"`
	FirstEventId         int64  `protobuf:"varint,8,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	LastEventId          int64  `protobuf:"varint,9,opt,name=last_event_id,json=lastEventId,proto3" json:"last_event_id,omitempty"`
	EventCount           int64  `protobuf:"varint,10,opt,name=event_count,json=eventCount,proto3" json:"event_count,omitempty"`
}

func (m *HistoryBlobHeader) Reset()      { *m = HistoryBlobHeader{} }
func (*HistoryBlobHeader) ProtoMessage() {}
func (*HistoryBlobHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ad6e64b6a1a2278, []int{0}
}
func (m *HistoryBlobHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryBlobHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryBlobHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryBlobHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryBlobHeader.Merge(m, src)
}
func (m *HistoryBlobHeader) XXX_Size() int {
	return m.Size()
}
func (m *HistoryBlobHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryBlobHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryBlobHeader proto.InternalMessageInfo

func (m *HistoryBlobHeader) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *HistoryBlobHeader) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *HistoryBlobHeader) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *HistoryBlobHeader) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *HistoryBlobHeader) GetIsLast() bool {
	if m != nil {
		return m.IsLast
	}
	return false
}

func (m *HistoryBlobHeader) GetFirstFailoverVersion() int64 {
	if m != nil {
		return m.FirstFailoverVersion
	}
	return 0
}

func (m *HistoryBlobHeader) GetLastFailoverVersion() int64 {
	if m != nil {
		return m.LastFailoverVersion
	}
	return 0
}

func (m *HistoryBlobHeader) GetFirstEventId() int64 {
	if m != nil {
		return m.FirstEventId
	}
	return 0
}

func (m *HistoryBlobHeader) GetLastEventId() int64 {
	if m != nil {
		return m.LastEventId
	}
	return 0
}

func (m *HistoryBlobHeader) GetEventCount() int64 {
	if m != nil {
		return m.EventCount
	}
	return 0
}

type HistoryBlob struct {
	Header *HistoryBlobHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Body   []*v1.History      `protobuf:"bytes,2,rep,name=body,proto3" json:"body,omitempty"`
}

func (m *HistoryBlob) Reset()      { *m = HistoryBlob{} }
func (*HistoryBlob) ProtoMessage() {}
func (*HistoryBlob) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ad6e64b6a1a2278, []int{1}
}
func (m *HistoryBlob) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryBlob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryBlob.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryBlob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryBlob.Merge(m, src)
}
func (m *HistoryBlob) XXX_Size() int {
	return m.Size()
}
func (m *HistoryBlob) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryBlob.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryBlob proto.InternalMessageInfo

func (m *HistoryBlob) GetHeader() *HistoryBlobHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *HistoryBlob) GetBody() []*v1.History {
	if m != nil {
		return m.Body
	}
	return nil
}

// ArchiveVisibilityRequest is request to Archive single workflow visibility record
type ArchiveVisibilityRequest struct {
	NamespaceId        string                      `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Namespace          string                      `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowId         string                      `protobuf:"bytes,3,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId              string                      `protobuf:"bytes,4,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	WorkflowTypeName   string                      `protobuf:"bytes,5,opt,name=workflow_type_name,json=workflowTypeName,proto3" json:"workflow_type_name,omitempty"`
	StartTime          *time.Time                  `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3,stdtime" json:"start_time,omitempty"`
	ExecutionTime      *time.Time                  `protobuf:"bytes,7,opt,name=execution_time,json=executionTime,proto3,stdtime" json:"execution_time,omitempty"`
	CloseTime          *time.Time                  `protobuf:"bytes,8,opt,name=close_time,json=closeTime,proto3,stdtime" json:"close_time,omitempty"`
	Status             v11.WorkflowExecutionStatus `protobuf:"varint,9,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"status,omitempty"`
	HistoryLength      int64                       `protobuf:"varint,10,opt,name=history_length,json=historyLength,proto3" json:"history_length,omitempty"`
	Memo               *v12.Memo                   `protobuf:"bytes,11,opt,name=memo,proto3" json:"memo,omitempty"`
	SearchAttributes   map[string]string           `protobuf:"bytes,12,rep,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	HistoryArchivalUri string                      `protobuf:"bytes,13,opt,name=history_archival_uri,json=historyArchivalUri,proto3" json:"history_archival_uri,omitempty"`
}

func (m *ArchiveVisibilityRequest) Reset()      { *m = ArchiveVisibilityRequest{} }
func (*ArchiveVisibilityRequest) ProtoMessage() {}
func (*ArchiveVisibilityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ad6e64b6a1a2278, []int{2}
}
func (m *ArchiveVisibilityRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ArchiveVisibilityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ArchiveVisibilityRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ArchiveVisibilityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArchiveVisibilityRequest.Merge(m, src)
}
func (m *ArchiveVisibilityRequest) XXX_Size() int {
	return m.Size()
}
func (m *ArchiveVisibilityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ArchiveVisibilityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ArchiveVisibilityRequest proto.InternalMessageInfo

func (m *ArchiveVisibilityRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ArchiveVisibilityRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ArchiveVisibilityRequest) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *ArchiveVisibilityRequest) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *ArchiveVisibilityRequest) GetWorkflowTypeName() string {
	if m != nil {
		return m.WorkflowTypeName
	}
	return ""
}

func (m *ArchiveVisibilityRequest) GetStartTime() *time.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ArchiveVisibilityRequest) GetExecutionTime() *time.Time {
	if m != nil {
		return m.ExecutionTime
	}
	return nil
}

func (m *ArchiveVisibilityRequest) GetCloseTime() *time.Time {
	if m != nil {
		return m.CloseTime
	}
	return nil
}

func (m *ArchiveVisibilityRequest) GetStatus() v11.WorkflowExecutionStatus {
	if m != nil {
		return m.Status
	}
	return v11.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

func (m *ArchiveVisibilityRequest) GetHistoryLength() int64 {
	if m != nil {
		return m.HistoryLength
	}
	return 0
}

func (m *ArchiveVisibilityRequest) GetMemo() *v12.Memo {
	if m != nil {
		return m.Memo
	}
	return nil
}

func (m *ArchiveVisibilityRequest) GetSearchAttributes() map[string]string {
	if m != nil {
		return m.SearchAttributes
	}
	return nil
}

func (m *ArchiveVisibilityRequest) GetHistoryArchivalUri() string {
	if m != nil {
		return m.HistoryArchivalUri
	}
	return ""
}

func init() {
	proto.RegisterType((*HistoryBlobHeader)(nil), "temporal.server.api.archiver.v1.HistoryBlobHeader")
	proto.RegisterType((*HistoryBlob)(nil), "temporal.server.api.archiver.v1.HistoryBlob")
	proto.RegisterType((*ArchiveVisibilityRequest)(nil), "temporal.server.api.archiver.v1.ArchiveVisibilityRequest")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.archiver.v1.ArchiveVisibilityRequest.SearchAttributesEntry")
}

func init() {
	proto.RegisterFile("temporal/server/api/archiver/v1/message.proto", fileDescriptor_7ad6e64b6a1a2278)
}

var fileDescriptor_7ad6e64b6a1a2278 = []byte{
	// 816 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x41, 0x6f, 0x1b, 0x45,
	0x14, 0xf6, 0x3a, 0xa9, 0x13, 0xbf, 0x4d, 0xa2, 0x74, 0x48, 0x60, 0x65, 0x55, 0x6b, 0x37, 0x6a,
	0xa5, 0x1c, 0x60, 0xdd, 0x9a, 0x1e, 0x10, 0x1c, 0xaa, 0xa4, 0x4a, 0x69, 0x50, 0x01, 0x69, 0x5b,
	0x8a, 0xc4, 0x65, 0x35, 0xf6, 0xbe, 0x38, 0xa3, 0xee, 0xee, 0x2c, 0x33, 0xb3, 0x2e, 0x96, 0x38,
	0xf0, 0x0f, 0xe8, 0x6f, 0xe0, 0xc4, 0x4f, 0xe1, 0x98, 0x63, 0x6f, 0x10, 0xe7, 0xc2, 0xb1, 0x67,
	0x4e, 0x68, 0xde, 0xee, 0x3a, 0x75, 0x4c, 0xd5, 0x8a, 0xdb, 0xcc, 0xf7, 0x7d, 0xef, 0x9b, 0xe7,
	0x79, 0xdf, 0x78, 0xe1, 0x13, 0x83, 0x69, 0x2e, 0x15, 0x4f, 0xfa, 0x1a, 0xd5, 0x04, 0x55, 0x9f,
	0xe7, 0xa2, 0xcf, 0xd5, 0xe8, 0x54, 0xd8, 0xcd, 0xe4, 0x6e, 0x3f, 0x45, 0xad, 0xf9, 0x18, 0x83,
	0x5c, 0x49, 0x23, 0x59, 0xb7, 0x96, 0x07, 0xa5, 0x3c, 0xe0, 0xb9, 0x08, 0x6a, 0x79, 0x30, 0xb9,
	0xdb, 0xe9, 0x8e, 0xa5, 0x1c, 0x27, 0xd8, 0x27, 0xf9, 0xb0, 0x38, 0xe9, 0x1b, 0x91, 0xa2, 0x36,
	0x3c, 0xcd, 0x4b, 0x87, 0xce, 0xcd, 0x18, 0x73, 0xcc, 0x62, 0xcc, 0x46, 0x02, 0x75, 0x7f, 0x2c,
	0xc7, 0x92, 0x70, 0x5a, 0x55, 0x92, 0x5b, 0xf3, 0x9e, 0x6c, 0x33, 0x23, 0x99, 0xa6, 0x32, 0x5b,
	0x6a, 0xa5, 0x73, 0x7b, 0x41, 0x75, 0x2a, 0xb4, 0x91, 0x6a, 0xba, 0x2c, 0x5b, 0x34, 0xc3, 0xac,
	0x48, 0xb5, 0x15, 0xbd, 0x90, 0xea, 0xf9, 0x49, 0x22, 0x5f, 0x94, 0xaa, 0xbd, 0x7f, 0x9a, 0x70,
	0xfd, 0x51, 0x69, 0x71, 0x98, 0xc8, 0xe1, 0x23, 0xe4, 0x31, 0x2a, 0x76, 0x03, 0xda, 0x19, 0x4f,
	0x51, 0xe7, 0x7c, 0x84, 0x9e, 0xd3, 0x73, 0xf6, 0xdb, 0xe1, 0x25, 0xc0, 0x6e, 0xc2, 0xc6, 0x7c,
	0x13, 0x89, 0xd8, 0x6b, 0x92, 0xc0, 0x9d, 0x63, 0xc7, 0x31, 0xeb, 0x82, 0x5b, 0x1f, 0x64, 0x15,
	0x2b, 0xa4, 0x80, 0x1a, 0x3a, 0x8e, 0xd9, 0x2e, 0xb4, 0x54, 0x91, 0x59, 0x6e, 0x95, 0xb8, 0x6b,
	0xaa, 0xc8, 0x8e, 0x63, 0xf6, 0x11, 0xac, 0x09, 0x1d, 0x25, 0x5c, 0x1b, 0xef, 0x5a, 0xcf, 0xd9,
	0x5f, 0x0f, 0x5b, 0x42, 0x3f, 0xe6, 0xda, 0xb0, 0x7b, 0xf0, 0xe1, 0x89, 0x50, 0xda, 0x44, 0x27,
	0x5c, 0x24, 0x72, 0x82, 0x2a, 0x9a, 0xa0, 0xd2, 0x42, 0x66, 0x5e, 0xab, 0xe7, 0xec, 0xaf, 0x84,
	0x3b, 0xc4, 0x3e, 0xac, 0xc8, 0x67, 0x25, 0xc7, 0x06, 0xb0, 0x6b, 0xbd, 0x96, 0x8b, 0xd6, 0xa8,
	0xe8, 0x03, 0x4b, 0x5e, 0xad, 0xb9, 0x05, 0x5b, 0xe5, 0x49, 0x38, 0xc1, 0xcc, 0xd8, 0x0e, 0xd7,
	0x49, 0xbc, 0x41, 0xe8, 0x91, 0x05, 0x8f, 0x63, 0xb6, 0x07, 0x9b, 0xe4, 0x3c, 0x17, 0xb5, 0x49,
	0xe4, 0x5a, 0xb0, 0xd6, 0x74, 0xc1, 0x2d, 0xe9, 0x91, 0x2c, 0x32, 0xe3, 0x01, 0x29, 0x80, 0xa0,
	0x07, 0x16, 0xd9, 0xfb, 0xd5, 0x01, 0xf7, 0x8d, 0xcb, 0x67, 0x5f, 0x41, 0xeb, 0x94, 0x06, 0x40,
	0x77, 0xee, 0x0e, 0x06, 0xc1, 0x3b, 0x52, 0x17, 0x2c, 0x8d, 0x2e, 0xac, 0x1c, 0xd8, 0x3d, 0x58,
	0x1d, 0xca, 0x78, 0xea, 0x35, 0x7b, 0x2b, 0xfb, 0xee, 0xa0, 0x77, 0xe9, 0x64, 0x2d, 0xaa, 0xd0,
	0xbc, 0xe1, 0x10, 0x92, 0x7a, 0xef, 0xb7, 0x16, 0x78, 0x07, 0xa5, 0xff, 0x33, 0xa1, 0xc5, 0x50,
	0x24, 0xc2, 0x4c, 0x43, 0xfc, 0xb1, 0x40, 0x6d, 0x96, 0xe6, 0xee, 0x2c, 0xcf, 0x7d, 0x21, 0x38,
	0xcd, 0xab, 0xc1, 0xf9, 0xbf, 0xa9, 0xf8, 0x18, 0xd8, 0xbc, 0xce, 0x4c, 0x73, 0x8c, 0xac, 0x25,
	0x05, 0xa4, 0x1d, 0x6e, 0xd7, 0xcc, 0xd3, 0x69, 0x8e, 0xdf, 0xf0, 0x14, 0xd9, 0x7d, 0x00, 0x6d,
	0xb8, 0x32, 0x91, 0x7d, 0x81, 0x14, 0x0f, 0x77, 0xd0, 0x09, 0xca, 0xe7, 0x19, 0xd4, 0xcf, 0x33,
	0x78, 0x5a, 0x3f, 0xcf, 0xc3, 0xd5, 0x97, 0x7f, 0x76, 0x9d, 0xb0, 0x4d, 0x35, 0x16, 0x65, 0x5f,
	0xc2, 0x16, 0xfe, 0x84, 0xa3, 0xc2, 0x08, 0x99, 0x95, 0x26, 0x6b, 0xef, 0x69, 0xb2, 0x39, 0xaf,
	0x23, 0xa3, 0xfb, 0x00, 0xa3, 0x44, 0x6a, 0x2c, 0x4d, 0xd6, 0xdf, 0xb7, 0x13, 0xaa, 0x21, 0x83,
	0x87, 0xd0, 0xd2, 0x86, 0x9b, 0x42, 0x53, 0xbc, 0xb6, 0x06, 0xc1, 0xe2, 0x18, 0xe9, 0x51, 0xdb,
	0x21, 0x7e, 0x5f, 0xdd, 0xc1, 0x51, 0x7d, 0xfc, 0x13, 0xaa, 0x0a, 0xab, 0x6a, 0x76, 0x1b, 0xb6,
	0xaa, 0x91, 0x47, 0x09, 0x66, 0x63, 0x73, 0x5a, 0x85, 0x71, 0xb3, 0x42, 0x1f, 0x13, 0xc8, 0xee,
	0xc0, 0x6a, 0x8a, 0xa9, 0xf4, 0x5c, 0xea, 0xf4, 0xc6, 0xe2, 0x61, 0xe5, 0xdf, 0x91, 0x3d, 0xed,
	0x6b, 0x4c, 0x65, 0x48, 0x4a, 0xf6, 0x33, 0x5c, 0xd7, 0x68, 0x03, 0x19, 0x71, 0x63, 0x94, 0x18,
	0x16, 0x06, 0xb5, 0xb7, 0x41, 0x91, 0xfb, 0xf6, 0x9d, 0xe1, 0x7d, 0x5b, 0xd0, 0x82, 0x27, 0x64,
	0x79, 0x30, 0x77, 0x3c, 0xca, 0x8c, 0x9a, 0x86, 0xdb, 0xfa, 0x0a, 0xcc, 0xee, 0xc0, 0x4e, 0xfd,
	0xb3, 0x4a, 0x5f, 0x9e, 0x44, 0x85, 0x12, 0xde, 0x26, 0x25, 0x83, 0x55, 0xdc, 0x41, 0x45, 0x7d,
	0xa7, 0x44, 0xe7, 0x01, 0xec, 0xfe, 0xa7, 0x39, 0xdb, 0x86, 0x95, 0xe7, 0x38, 0xad, 0x22, 0x6d,
	0x97, 0x6c, 0x07, 0xae, 0x4d, 0x78, 0x52, 0xd4, 0x31, 0x2e, 0x37, 0x9f, 0x37, 0x3f, 0x73, 0x0e,
	0xe3, 0xb3, 0x73, 0xbf, 0xf1, 0xea, 0xdc, 0x6f, 0xbc, 0x3e, 0xf7, 0x9d, 0x5f, 0x66, 0xbe, 0xf3,
	0xfb, 0xcc, 0x77, 0xfe, 0x98, 0xf9, 0xce, 0xd9, 0xcc, 0x77, 0xfe, 0x9a, 0xf9, 0xce, 0xdf, 0x33,
	0xbf, 0xf1, 0x7a, 0xe6, 0x3b, 0x2f, 0x2f, 0xfc, 0xc6, 0xd9, 0x85, 0xdf, 0x78, 0x75, 0xe1, 0x37,
	0x7e, 0x08, 0xc6, 0xf2, 0xf2, 0x46, 0x84, 0x7c, 0xcb, 0x67, 0xe7, 0x8b, 0x7a, 0x3d, 0x6c, 0x51,
	0x40, 0x3e, 0xfd, 0x37, 0x00, 0x00, 0xff, 0xff, 0x51, 0xa7, 0x35, 0x6c, 0xa9, 0x06, 0x00, 0x00,
}

func (this *HistoryBlobHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryBlobHeader)
	if !ok {
		that2, ok := that.(HistoryBlobHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.IsLast != that1.IsLast {
		return false
	}
	if this.FirstFailoverVersion != that1.FirstFailoverVersion {
		return false
	}
	if this.LastFailoverVersion != that1.LastFailoverVersion {
		return false
	}
	if this.FirstEventId != that1.FirstEventId {
		return false
	}
	if this.LastEventId != that1.LastEventId {
		return false
	}
	if this.EventCount != that1.EventCount {
		return false
	}
	return true
}
func (this *HistoryBlob) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryBlob)
	if !ok {
		that2, ok := that.(HistoryBlob)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Header.Equal(that1.Header) {
		return false
	}
	if len(this.Body) != len(that1.Body) {
		return false
	}
	for i := range this.Body {
		if !this.Body[i].Equal(that1.Body[i]) {
			return false
		}
	}
	return true
}
func (this *ArchiveVisibilityRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ArchiveVisibilityRequest)
	if !ok {
		that2, ok := that.(ArchiveVisibilityRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.WorkflowTypeName != that1.WorkflowTypeName {
		return false
	}
	if that1.StartTime == nil {
		if this.StartTime != nil {
			return false
		}
	} else if !this.StartTime.Equal(*that1.StartTime) {
		return false
	}
	if that1.ExecutionTime == nil {
		if this.ExecutionTime != nil {
			return false
		}
	} else if !this.ExecutionTime.Equal(*that1.ExecutionTime) {
		return false
	}
	if that1.CloseTime == nil {
		if this.CloseTime != nil {
			return false
		}
	} else if !this.CloseTime.Equal(*that1.CloseTime) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.HistoryLength != that1.HistoryLength {
		return false
	}
	if !this.Memo.Equal(that1.Memo) {
		return false
	}
	if len(this.SearchAttributes) != len(that1.SearchAttributes) {
		return false
	}
	for i := range this.SearchAttributes {
		if this.SearchAttributes[i] != that1.SearchAttributes[i] {
			return false
		}
	}
	if this.HistoryArchivalUri != that1.HistoryArchivalUri {
		return false
	}
	return true
}
func (this *HistoryBlobHeader) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&archiver.HistoryBlobHeader{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "IsLast: "+fmt.Sprintf("%#v", this.IsLast)+",\n")
	s = append(s, "FirstFailoverVersion: "+fmt.Sprintf("%#v", this.FirstFailoverVersion)+",\n")
	s = append(s, "LastFailoverVersion: "+fmt.Sprintf("%#v", this.LastFailoverVersion)+",\n")
	s = append(s, "FirstEventId: "+fmt.Sprintf("%#v", this.FirstEventId)+",\n")
	s = append(s, "LastEventId: "+fmt.Sprintf("%#v", this.LastEventId)+",\n")
	s = append(s, "EventCount: "+fmt.Sprintf("%#v", this.EventCount)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryBlob) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&archiver.HistoryBlob{")
	if this.Header != nil {
		s = append(s, "Header: "+fmt.Sprintf("%#v", this.Header)+",\n")
	}
	if this.Body != nil {
		s = append(s, "Body: "+fmt.Sprintf("%#v", this.Body)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ArchiveVisibilityRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&archiver.ArchiveVisibilityRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "WorkflowTypeName: "+fmt.Sprintf("%#v", this.WorkflowTypeName)+",\n")
	s = append(s, "StartTime: "+fmt.Sprintf("%#v", this.StartTime)+",\n")
	s = append(s, "ExecutionTime: "+fmt.Sprintf("%#v", this.ExecutionTime)+",\n")
	s = append(s, "CloseTime: "+fmt.Sprintf("%#v", this.CloseTime)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "HistoryLength: "+fmt.Sprintf("%#v", this.HistoryLength)+",\n")
	if this.Memo != nil {
		s = append(s, "Memo: "+fmt.Sprintf("%#v", this.Memo)+",\n")
	}
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]string{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	if this.SearchAttributes != nil {
		s = append(s, "SearchAttributes: "+mapStringForSearchAttributes+",\n")
	}
	s = append(s, "HistoryArchivalUri: "+fmt.Sprintf("%#v", this.HistoryArchivalUri)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *HistoryBlobHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryBlobHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryBlobHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EventCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.EventCount))
		i--
		dAtA[i] = 0x50
	}
	if m.LastEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastEventId))
		i--
		dAtA[i] = 0x48
	}
	if m.FirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FirstEventId))
		i--
		dAtA[i] = 0x40
	}
	if m.LastFailoverVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastFailoverVersion))
		i--
		dAtA[i] = 0x38
	}
	if m.FirstFailoverVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FirstFailoverVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.IsLast {
		i--
		if m.IsLast {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HistoryBlob) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryBlob) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryBlob) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Body) > 0 {
		for iNdEx := len(m.Body) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Body[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ArchiveVisibilityRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ArchiveVisibilityRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ArchiveVisibilityRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HistoryArchivalUri) > 0 {
		i -= len(m.HistoryArchivalUri)
		copy(dAtA[i:], m.HistoryArchivalUri)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.HistoryArchivalUri)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.SearchAttributes) > 0 {
		for k := range m.SearchAttributes {
			v := m.SearchAttributes[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMessage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Memo != nil {
		{
			size, err := m.Memo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.HistoryLength != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.HistoryLength))
		i--
		dAtA[i] = 0x50
	}
	if m.Status != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x48
	}
	if m.CloseTime != nil {
		n3, err3 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CloseTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CloseTime):])
		if err3 != nil {
			return 0, err3
		}
		i -= n3
		i = encodeVarintMessage(dAtA, i, uint64(n3))
		i--
		dAtA[i] = 0x42
	}
	if m.ExecutionTime != nil {
		n4, err4 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExecutionTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime):])
		if err4 != nil {
			return 0, err4
		}
		i -= n4
		i = encodeVarintMessage(dAtA, i, uint64(n4))
		i--
		dAtA[i] = 0x3a
	}
	if m.StartTime != nil {
		n5, err5 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime):])
		if err5 != nil {
			return 0, err5
		}
		i -= n5
		i = encodeVarintMessage(dAtA, i, uint64(n5))
		i--
		dAtA[i] = 0x32
	}
	if len(m.WorkflowTypeName) > 0 {
		i -= len(m.WorkflowTypeName)
		copy(dAtA[i:], m.WorkflowTypeName)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowTypeName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HistoryBlobHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.IsLast {
		n += 2
	}
	if m.FirstFailoverVersion != 0 {
		n += 1 + sovMessage(uint64(m.FirstFailoverVersion))
	}
	if m.LastFailoverVersion != 0 {
		n += 1 + sovMessage(uint64(m.LastFailoverVersion))
	}
	if m.FirstEventId != 0 {
		n += 1 + sovMessage(uint64(m.FirstEventId))
	}
	if m.LastEventId != 0 {
		n += 1 + sovMessage(uint64(m.LastEventId))
	}
	if m.EventCount != 0 {
		n += 1 + sovMessage(uint64(m.EventCount))
	}
	return n
}

func (m *HistoryBlob) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.Body) > 0 {
		for _, e := range m.Body {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	return n
}

func (m *ArchiveVisibilityRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowTypeName)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ExecutionTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExecutionTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.CloseTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CloseTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovMessage(uint64(m.Status))
	}
	if m.HistoryLength != 0 {
		n += 1 + sovMessage(uint64(m.HistoryLength))
	}
	if m.Memo != nil {
		l = m.Memo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.SearchAttributes) > 0 {
		for k, v := range m.SearchAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + len(v) + sovMessage(uint64(len(v)))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	l = len(m.HistoryArchivalUri)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HistoryBlobHeader) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryBlobHeader{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`IsLast:` + fmt.Sprintf("%v", this.IsLast) + `,`,
		`FirstFailoverVersion:` + fmt.Sprintf("%v", this.FirstFailoverVersion) + `,`,
		`LastFailoverVersion:` + fmt.Sprintf("%v", this.LastFailoverVersion) + `,`,
		`FirstEventId:` + fmt.Sprintf("%v", this.FirstEventId) + `,`,
		`LastEventId:` + fmt.Sprintf("%v", this.LastEventId) + `,`,
		`EventCount:` + fmt.Sprintf("%v", this.EventCount) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryBlob) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForBody := "[]*History{"
	for _, f := range this.Body {
		repeatedStringForBody += strings.Replace(fmt.Sprintf("%v", f), "History", "v1.History", 1) + ","
	}
	repeatedStringForBody += "}"
	s := strings.Join([]string{`&HistoryBlob{`,
		`Header:` + strings.Replace(this.Header.String(), "HistoryBlobHeader", "HistoryBlobHeader", 1) + `,`,
		`Body:` + repeatedStringForBody + `,`,
		`}`,
	}, "")
	return s
}
func (this *ArchiveVisibilityRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]string{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%v: %v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	s := strings.Join([]string{`&ArchiveVisibilityRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`WorkflowTypeName:` + fmt.Sprintf("%v", this.WorkflowTypeName) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ExecutionTime:` + strings.Replace(fmt.Sprintf("%v", this.ExecutionTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`CloseTime:` + strings.Replace(fmt.Sprintf("%v", this.CloseTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`HistoryLength:` + fmt.Sprintf("%v", this.HistoryLength) + `,`,
		`Memo:` + strings.Replace(fmt.Sprintf("%v", this.Memo), "Memo", "v12.Memo", 1) + `,`,
		`SearchAttributes:` + mapStringForSearchAttributes + `,`,
		`HistoryArchivalUri:` + fmt.Sprintf("%v", this.HistoryArchivalUri) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HistoryBlobHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryBlobHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryBlobHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLast", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsLast = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstFailoverVersion", wireType)
			}
			m.FirstFailoverVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstFailoverVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFailoverVersion", wireType)
			}
			m.LastFailoverVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastFailoverVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstEventId", wireType)
			}
			m.FirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastEventId", wireType)
			}
			m.LastEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventCount", wireType)
			}
			m.EventCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryBlob) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryBlob: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryBlob: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &HistoryBlobHeader{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = append(m.Body, &v1.History{})
			if err := m.Body[len(m.Body)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ArchiveVisibilityRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ArchiveVisibilityRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ArchiveVisibilityRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTypeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTypeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionTime == nil {
				m.ExecutionTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExecutionTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CloseTime == nil {
				m.CloseTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CloseTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= v11.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryLength", wireType)
			}
			m.HistoryLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryLength |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memo == nil {
				m.Memo = &v12.Memo{}
			}
			if err := m.Memo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttributes == nil {
				m.SearchAttributes = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryArchivalUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryArchivalUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
