// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/indexer/v1/message.proto

package indexer

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	v1 "go.temporal.io/server/api/enums/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Deprecated. Remove with kafka removal.
type Field struct {
	Type v1.FieldType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.FieldType" json:"type,omitempty"`
	// Types that are valid to be assigned to Data:
	//	*Field_StringData
	//	*Field_IntData
	//	*Field_BoolData
	//	*Field_BinaryData
	Data isField_Data `protobuf_oneof:"data"`
}

func (m *Field) Reset()      { *m = Field{} }
func (*Field) ProtoMessage() {}
func (*Field) Descriptor() ([]byte, []int) {
	return fileDescriptor_919e816ae27b9678, []int{0}
}
func (m *Field) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Field) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Field.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Field) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Field.Merge(m, src)
}
func (m *Field) XXX_Size() int {
	return m.Size()
}
func (m *Field) XXX_DiscardUnknown() {
	xxx_messageInfo_Field.DiscardUnknown(m)
}

var xxx_messageInfo_Field proto.InternalMessageInfo

type isField_Data interface {
	isField_Data()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Field_StringData struct {
	StringData string `protobuf:"bytes,2,opt,name=string_data,json=stringData,proto3,oneof" json:"string_data,omitempty"`
}
type Field_IntData struct {
	IntData int64 `protobuf:"varint,3,opt,name=int_data,json=intData,proto3,oneof" json:"int_data,omitempty"`
}
type Field_BoolData struct {
	BoolData bool `protobuf:"varint,4,opt,name=bool_data,json=boolData,proto3,oneof" json:"bool_data,omitempty"`
}
type Field_BinaryData struct {
	BinaryData []byte `protobuf:"bytes,5,opt,name=binary_data,json=binaryData,proto3,oneof" json:"binary_data,omitempty"`
}

func (*Field_StringData) isField_Data() {}
func (*Field_IntData) isField_Data()    {}
func (*Field_BoolData) isField_Data()   {}
func (*Field_BinaryData) isField_Data() {}

func (m *Field) GetData() isField_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Field) GetType() v1.FieldType {
	if m != nil {
		return m.Type
	}
	return v1.FIELD_TYPE_UNSPECIFIED
}

func (m *Field) GetStringData() string {
	if x, ok := m.GetData().(*Field_StringData); ok {
		return x.StringData
	}
	return ""
}

func (m *Field) GetIntData() int64 {
	if x, ok := m.GetData().(*Field_IntData); ok {
		return x.IntData
	}
	return 0
}

func (m *Field) GetBoolData() bool {
	if x, ok := m.GetData().(*Field_BoolData); ok {
		return x.BoolData
	}
	return false
}

func (m *Field) GetBinaryData() []byte {
	if x, ok := m.GetData().(*Field_BinaryData); ok {
		return x.BinaryData
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Field) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Field_StringData)(nil),
		(*Field_IntData)(nil),
		(*Field_BoolData)(nil),
		(*Field_BinaryData)(nil),
	}
}

// Deprecated. Remove with kafka removal.
type Message struct {
	MessageType v1.MessageType    `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=temporal.server.api.enums.v1.MessageType" json:"message_type,omitempty"`
	NamespaceId string            `protobuf:"bytes,2,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId  string            `protobuf:"bytes,3,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId       string            `protobuf:"bytes,4,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	Version     int64             `protobuf:"varint,5,opt,name=version,proto3" json:"version,omitempty"`
	Fields      map[string]*Field `protobuf:"bytes,6,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Message) Reset()      { *m = Message{} }
func (*Message) ProtoMessage() {}
func (*Message) Descriptor() ([]byte, []int) {
	return fileDescriptor_919e816ae27b9678, []int{1}
}
func (m *Message) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Message) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Message.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Message) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Message.Merge(m, src)
}
func (m *Message) XXX_Size() int {
	return m.Size()
}
func (m *Message) XXX_DiscardUnknown() {
	xxx_messageInfo_Message.DiscardUnknown(m)
}

var xxx_messageInfo_Message proto.InternalMessageInfo

func (m *Message) GetMessageType() v1.MessageType {
	if m != nil {
		return m.MessageType
	}
	return v1.MESSAGE_TYPE_UNSPECIFIED
}

func (m *Message) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *Message) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *Message) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *Message) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *Message) GetFields() map[string]*Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func init() {
	proto.RegisterType((*Field)(nil), "temporal.server.api.indexer.v1.Field")
	proto.RegisterType((*Message)(nil), "temporal.server.api.indexer.v1.Message")
	proto.RegisterMapType((map[string]*Field)(nil), "temporal.server.api.indexer.v1.Message.FieldsEntry")
}

func init() {
	proto.RegisterFile("temporal/server/api/indexer/v1/message.proto", fileDescriptor_919e816ae27b9678)
}

var fileDescriptor_919e816ae27b9678 = []byte{
	// 486 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x53, 0xbf, 0x8f, 0xd3, 0x30,
	0x14, 0x8e, 0x9b, 0xfe, 0x7c, 0xa9, 0x10, 0xb2, 0x84, 0x54, 0x1d, 0xc2, 0xa4, 0x27, 0x21, 0x02,
	0x3a, 0xa5, 0x6a, 0x6f, 0x41, 0x74, 0x3b, 0x01, 0x6a, 0x05, 0x2c, 0x11, 0x13, 0x4b, 0x71, 0x89,
	0xaf, 0xb2, 0xae, 0xb1, 0x23, 0x27, 0xcd, 0x91, 0x8d, 0x3f, 0x81, 0x3f, 0x83, 0x3f, 0x85, 0x09,
	0x75, 0xbc, 0x91, 0xa6, 0x0b, 0xe3, 0xed, 0x2c, 0x28, 0x76, 0xc2, 0xdd, 0x50, 0x1d, 0x9b, 0xfd,
	0x7d, 0xdf, 0xfb, 0x5e, 0xbe, 0xf7, 0x62, 0x38, 0x49, 0x59, 0x14, 0x4b, 0x45, 0xd7, 0xa3, 0x84,
	0xa9, 0x8c, 0xa9, 0x11, 0x8d, 0xf9, 0x88, 0x8b, 0x90, 0x7d, 0x61, 0x6a, 0x94, 0x8d, 0x47, 0x11,
	0x4b, 0x12, 0xba, 0x62, 0x7e, 0xac, 0x64, 0x2a, 0x31, 0xa9, 0xd5, 0xbe, 0x51, 0xfb, 0x34, 0xe6,
	0x7e, 0xa5, 0xf6, 0xb3, 0xf1, 0xd1, 0xf3, 0x43, 0x6e, 0x4c, 0x6c, 0xa2, 0xa4, 0xf4, 0xaa, 0x85,
	0xda, 0xeb, 0xf8, 0x27, 0x82, 0xd6, 0x1b, 0xce, 0xd6, 0x21, 0x9e, 0x42, 0x33, 0xcd, 0x63, 0x36,
	0x40, 0x2e, 0xf2, 0xee, 0x4d, 0x9e, 0xfa, 0x87, 0x9a, 0x68, 0x13, 0x3f, 0x1b, 0xfb, 0xba, 0xe4,
	0x43, 0x1e, 0xb3, 0x40, 0x17, 0xe1, 0x21, 0x38, 0x49, 0xaa, 0xb8, 0x58, 0x2d, 0x42, 0x9a, 0xd2,
	0x41, 0xc3, 0x45, 0x5e, 0x6f, 0x66, 0x05, 0x60, 0xc0, 0x57, 0x34, 0xa5, 0xf8, 0x21, 0x74, 0xb9,
	0x48, 0x0d, 0x6f, 0xbb, 0xc8, 0xb3, 0x67, 0x56, 0xd0, 0xe1, 0x22, 0xd5, 0xe4, 0x23, 0xe8, 0x2d,
	0xa5, 0x5c, 0x1b, 0xb6, 0xe9, 0x22, 0xaf, 0x3b, 0xb3, 0x82, 0x6e, 0x09, 0x69, 0x7a, 0x08, 0xce,
	0x92, 0x0b, 0xaa, 0x72, 0x23, 0x68, 0xb9, 0xc8, 0xeb, 0x97, 0xf6, 0x06, 0x2c, 0x25, 0x67, 0x6d,
	0x68, 0x96, 0xdc, 0xf1, 0x9f, 0x06, 0x74, 0xde, 0x9b, 0x71, 0xe1, 0x77, 0xd0, 0xaf, 0x26, 0xb7,
	0xb8, 0x15, 0xed, 0xd9, 0xdd, 0xd1, 0xaa, 0x62, 0x1d, 0xce, 0x89, 0x6e, 0x2e, 0x78, 0x08, 0x7d,
	0x41, 0x23, 0x96, 0xc4, 0xf4, 0x33, 0x5b, 0xf0, 0xd0, 0x84, 0x0c, 0x9c, 0x7f, 0xd8, 0x3c, 0xc4,
	0x8f, 0xc1, 0xb9, 0x94, 0xea, 0xe2, 0x7c, 0x2d, 0x2f, 0x4b, 0x85, 0xad, 0x15, 0x50, 0x43, 0xf3,
	0x10, 0x3f, 0x80, 0xb6, 0xda, 0x88, 0x92, 0x6b, 0x6a, 0xae, 0xa5, 0x36, 0x62, 0x1e, 0xe2, 0x01,
	0x74, 0x32, 0xa6, 0x12, 0x2e, 0x85, 0xce, 0x66, 0x07, 0xf5, 0x15, 0xbf, 0x85, 0xf6, 0x79, 0x39,
	0xeb, 0x64, 0xd0, 0x76, 0x6d, 0xcf, 0x99, 0x9c, 0xfa, 0x77, 0x2f, 0xbf, 0xfe, 0x7c, 0xb3, 0xa1,
	0xe4, 0xb5, 0x48, 0x55, 0x1e, 0x54, 0x16, 0x47, 0x9f, 0xc0, 0xb9, 0x05, 0xe3, 0xfb, 0x60, 0x5f,
	0xb0, 0x5c, 0x4f, 0xa5, 0x17, 0x94, 0x47, 0x3c, 0x85, 0x56, 0x46, 0xd7, 0x1b, 0xa6, 0xb3, 0x39,
	0x93, 0x27, 0xff, 0x6b, 0xa6, 0xdd, 0x02, 0x53, 0xf3, 0xb2, 0xf1, 0x02, 0x9d, 0x2d, 0xb7, 0x3b,
	0x62, 0x5d, 0xed, 0x88, 0x75, 0xbd, 0x23, 0xe8, 0x6b, 0x41, 0xd0, 0xf7, 0x82, 0xa0, 0x1f, 0x05,
	0x41, 0xdb, 0x82, 0xa0, 0x5f, 0x05, 0x41, 0xbf, 0x0b, 0x62, 0x5d, 0x17, 0x04, 0x7d, 0xdb, 0x13,
	0x6b, 0xbb, 0x27, 0xd6, 0xd5, 0x9e, 0x58, 0x1f, 0x4f, 0x56, 0xf2, 0xa6, 0x13, 0x97, 0x87, 0x1f,
	0xc1, 0xb4, 0x3a, 0x2e, 0xdb, 0xfa, 0xcf, 0x3d, 0xfd, 0x1b, 0x00, 0x00, 0xff, 0xff, 0xd2, 0x35,
	0xb9, 0xc9, 0x35, 0x03, 0x00, 0x00,
}

func (this *Field) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Field)
	if !ok {
		that2, ok := that.(Field)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if that1.Data == nil {
		if this.Data != nil {
			return false
		}
	} else if this.Data == nil {
		return false
	} else if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *Field_StringData) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Field_StringData)
	if !ok {
		that2, ok := that.(Field_StringData)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StringData != that1.StringData {
		return false
	}
	return true
}
func (this *Field_IntData) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Field_IntData)
	if !ok {
		that2, ok := that.(Field_IntData)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.IntData != that1.IntData {
		return false
	}
	return true
}
func (this *Field_BoolData) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Field_BoolData)
	if !ok {
		that2, ok := that.(Field_BoolData)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BoolData != that1.BoolData {
		return false
	}
	return true
}
func (this *Field_BinaryData) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Field_BinaryData)
	if !ok {
		that2, ok := that.(Field_BinaryData)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.BinaryData, that1.BinaryData) {
		return false
	}
	return true
}
func (this *Message) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Message)
	if !ok {
		that2, ok := that.(Message)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.MessageType != that1.MessageType {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if len(this.Fields) != len(that1.Fields) {
		return false
	}
	for i := range this.Fields {
		if !this.Fields[i].Equal(that1.Fields[i]) {
			return false
		}
	}
	return true
}
func (this *Field) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&indexer.Field{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Field_StringData) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&indexer.Field_StringData{` +
		`StringData:` + fmt.Sprintf("%#v", this.StringData) + `}`}, ", ")
	return s
}
func (this *Field_IntData) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&indexer.Field_IntData{` +
		`IntData:` + fmt.Sprintf("%#v", this.IntData) + `}`}, ", ")
	return s
}
func (this *Field_BoolData) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&indexer.Field_BoolData{` +
		`BoolData:` + fmt.Sprintf("%#v", this.BoolData) + `}`}, ", ")
	return s
}
func (this *Field_BinaryData) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&indexer.Field_BinaryData{` +
		`BinaryData:` + fmt.Sprintf("%#v", this.BinaryData) + `}`}, ", ")
	return s
}
func (this *Message) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&indexer.Message{")
	s = append(s, "MessageType: "+fmt.Sprintf("%#v", this.MessageType)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	keysForFields := make([]string, 0, len(this.Fields))
	for k, _ := range this.Fields {
		keysForFields = append(keysForFields, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForFields)
	mapStringForFields := "map[string]*Field{"
	for _, k := range keysForFields {
		mapStringForFields += fmt.Sprintf("%#v: %#v,", k, this.Fields[k])
	}
	mapStringForFields += "}"
	if this.Fields != nil {
		s = append(s, "Fields: "+mapStringForFields+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Field) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Field) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Field) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		{
			size := m.Data.Size()
			i -= size
			if _, err := m.Data.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Type != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Field_StringData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Field_StringData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.StringData)
	copy(dAtA[i:], m.StringData)
	i = encodeVarintMessage(dAtA, i, uint64(len(m.StringData)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *Field_IntData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Field_IntData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintMessage(dAtA, i, uint64(m.IntData))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *Field_BoolData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Field_BoolData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.BoolData {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x20
	return len(dAtA) - i, nil
}
func (m *Field_BinaryData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Field_BinaryData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.BinaryData != nil {
		i -= len(m.BinaryData)
		copy(dAtA[i:], m.BinaryData)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.BinaryData)))
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Message) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Message) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Fields) > 0 {
		for k := range m.Fields {
			v := m.Fields[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintMessage(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x28
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x12
	}
	if m.MessageType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.MessageType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Field) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovMessage(uint64(m.Type))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	return n
}

func (m *Field_StringData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StringData)
	n += 1 + l + sovMessage(uint64(l))
	return n
}
func (m *Field_IntData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovMessage(uint64(m.IntData))
	return n
}
func (m *Field_BoolData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *Field_BinaryData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BinaryData != nil {
		l = len(m.BinaryData)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}
func (m *Message) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MessageType != 0 {
		n += 1 + sovMessage(uint64(m.MessageType))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if len(m.Fields) > 0 {
		for k, v := range m.Fields {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovMessage(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Field) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Field{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Field_StringData) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Field_StringData{`,
		`StringData:` + fmt.Sprintf("%v", this.StringData) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Field_IntData) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Field_IntData{`,
		`IntData:` + fmt.Sprintf("%v", this.IntData) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Field_BoolData) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Field_BoolData{`,
		`BoolData:` + fmt.Sprintf("%v", this.BoolData) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Field_BinaryData) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Field_BinaryData{`,
		`BinaryData:` + fmt.Sprintf("%v", this.BinaryData) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Message) String() string {
	if this == nil {
		return "nil"
	}
	keysForFields := make([]string, 0, len(this.Fields))
	for k, _ := range this.Fields {
		keysForFields = append(keysForFields, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForFields)
	mapStringForFields := "map[string]*Field{"
	for _, k := range keysForFields {
		mapStringForFields += fmt.Sprintf("%v: %v,", k, this.Fields[k])
	}
	mapStringForFields += "}"
	s := strings.Join([]string{`&Message{`,
		`MessageType:` + fmt.Sprintf("%v", this.MessageType) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`Fields:` + mapStringForFields + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Field) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Field: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Field: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v1.FieldType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = &Field_StringData{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntData", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Data = &Field_IntData{v}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolData", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Data = &Field_BoolData{b}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinaryData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Data = &Field_BinaryData{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Message) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageType", wireType)
			}
			m.MessageType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MessageType |= v1.MessageType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fields", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Fields == nil {
				m.Fields = make(map[string]*Field)
			}
			var mapkey string
			var mapvalue *Field
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthMessage
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthMessage
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Field{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Fields[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
