// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/adminservice/v1/request_response.proto

package adminservice

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v1 "go.temporal.io/api/common/v1"
	v16 "go.temporal.io/api/enums/v1"
	_ "go.temporal.io/api/namespace/v1"
	_ "go.temporal.io/api/replication/v1"
	v19 "go.temporal.io/api/version/v1"
	v17 "go.temporal.io/api/workflow/v1"
	v18 "go.temporal.io/server/api/cluster/v1"
	v13 "go.temporal.io/server/api/enums/v1"
	v14 "go.temporal.io/server/api/history/v1"
	v12 "go.temporal.io/server/api/namespace/v1"
	v11 "go.temporal.io/server/api/persistence/v1"
	v15 "go.temporal.io/server/api/replication/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type DescribeMutableStateRequest struct {
	Namespace string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *DescribeMutableStateRequest) Reset()      { *m = DescribeMutableStateRequest{} }
func (*DescribeMutableStateRequest) ProtoMessage() {}
func (*DescribeMutableStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{0}
}
func (m *DescribeMutableStateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeMutableStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeMutableStateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeMutableStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeMutableStateRequest.Merge(m, src)
}
func (m *DescribeMutableStateRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeMutableStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeMutableStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeMutableStateRequest proto.InternalMessageInfo

func (m *DescribeMutableStateRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DescribeMutableStateRequest) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type DescribeMutableStateResponse struct {
	ShardId              string                    `protobuf:"bytes,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	HistoryAddr          string                    `protobuf:"bytes,2,opt,name=history_addr,json=historyAddr,proto3" json:"history_addr,omitempty"`
	CacheMutableState    *v11.WorkflowMutableState `protobuf:"bytes,3,opt,name=cache_mutable_state,json=cacheMutableState,proto3" json:"cache_mutable_state,omitempty"`
	DatabaseMutableState *v11.WorkflowMutableState `protobuf:"bytes,4,opt,name=database_mutable_state,json=databaseMutableState,proto3" json:"database_mutable_state,omitempty"`
}

func (m *DescribeMutableStateResponse) Reset()      { *m = DescribeMutableStateResponse{} }
func (*DescribeMutableStateResponse) ProtoMessage() {}
func (*DescribeMutableStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{1}
}
func (m *DescribeMutableStateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeMutableStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeMutableStateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeMutableStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeMutableStateResponse.Merge(m, src)
}
func (m *DescribeMutableStateResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeMutableStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeMutableStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeMutableStateResponse proto.InternalMessageInfo

func (m *DescribeMutableStateResponse) GetShardId() string {
	if m != nil {
		return m.ShardId
	}
	return ""
}

func (m *DescribeMutableStateResponse) GetHistoryAddr() string {
	if m != nil {
		return m.HistoryAddr
	}
	return ""
}

func (m *DescribeMutableStateResponse) GetCacheMutableState() *v11.WorkflowMutableState {
	if m != nil {
		return m.CacheMutableState
	}
	return nil
}

func (m *DescribeMutableStateResponse) GetDatabaseMutableState() *v11.WorkflowMutableState {
	if m != nil {
		return m.DatabaseMutableState
	}
	return nil
}

// At least one of the parameters needs to be provided.
type DescribeHistoryHostRequest struct {
	//ip:port
	HostAddress       string                `protobuf:"bytes,1,opt,name=host_address,json=hostAddress,proto3" json:"host_address,omitempty"`
	ShardId           int32                 `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Namespace         string                `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowExecution *v1.WorkflowExecution `protobuf:"bytes,4,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
}

func (m *DescribeHistoryHostRequest) Reset()      { *m = DescribeHistoryHostRequest{} }
func (*DescribeHistoryHostRequest) ProtoMessage() {}
func (*DescribeHistoryHostRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{2}
}
func (m *DescribeHistoryHostRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostRequest.Merge(m, src)
}
func (m *DescribeHistoryHostRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostRequest proto.InternalMessageInfo

func (m *DescribeHistoryHostRequest) GetHostAddress() string {
	if m != nil {
		return m.HostAddress
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *DescribeHistoryHostRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetWorkflowExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

type DescribeHistoryHostResponse struct {
	ShardsNumber          int32                   `protobuf:"varint,1,opt,name=shards_number,json=shardsNumber,proto3" json:"shards_number,omitempty"`
	ShardIds              []int32                 `protobuf:"varint,2,rep,packed,name=shard_ids,json=shardIds,proto3" json:"shard_ids,omitempty"`
	NamespaceCache        *v12.NamespaceCacheInfo `protobuf:"bytes,3,opt,name=namespace_cache,json=namespaceCache,proto3" json:"namespace_cache,omitempty"`
	ShardControllerStatus string                  `protobuf:"bytes,4,opt,name=shard_controller_status,json=shardControllerStatus,proto3" json:"shard_controller_status,omitempty"`
	Address               string                  `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
}

func (m *DescribeHistoryHostResponse) Reset()      { *m = DescribeHistoryHostResponse{} }
func (*DescribeHistoryHostResponse) ProtoMessage() {}
func (*DescribeHistoryHostResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{3}
}
func (m *DescribeHistoryHostResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostResponse.Merge(m, src)
}
func (m *DescribeHistoryHostResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostResponse proto.InternalMessageInfo

func (m *DescribeHistoryHostResponse) GetShardsNumber() int32 {
	if m != nil {
		return m.ShardsNumber
	}
	return 0
}

func (m *DescribeHistoryHostResponse) GetShardIds() []int32 {
	if m != nil {
		return m.ShardIds
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetNamespaceCache() *v12.NamespaceCacheInfo {
	if m != nil {
		return m.NamespaceCache
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetShardControllerStatus() string {
	if m != nil {
		return m.ShardControllerStatus
	}
	return ""
}

func (m *DescribeHistoryHostResponse) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

type CloseShardRequest struct {
	ShardId int32 `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
}

func (m *CloseShardRequest) Reset()      { *m = CloseShardRequest{} }
func (*CloseShardRequest) ProtoMessage() {}
func (*CloseShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{4}
}
func (m *CloseShardRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardRequest.Merge(m, src)
}
func (m *CloseShardRequest) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardRequest proto.InternalMessageInfo

func (m *CloseShardRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

type CloseShardResponse struct {
}

func (m *CloseShardResponse) Reset()      { *m = CloseShardResponse{} }
func (*CloseShardResponse) ProtoMessage() {}
func (*CloseShardResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{5}
}
func (m *CloseShardResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardResponse.Merge(m, src)
}
func (m *CloseShardResponse) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardResponse proto.InternalMessageInfo

type GetShardRequest struct {
	ShardId int32 `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
}

func (m *GetShardRequest) Reset()      { *m = GetShardRequest{} }
func (*GetShardRequest) ProtoMessage() {}
func (*GetShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{6}
}
func (m *GetShardRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetShardRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetShardRequest.Merge(m, src)
}
func (m *GetShardRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetShardRequest proto.InternalMessageInfo

func (m *GetShardRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

type GetShardResponse struct {
	ShardInfo *v11.ShardInfo `protobuf:"bytes,1,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
}

func (m *GetShardResponse) Reset()      { *m = GetShardResponse{} }
func (*GetShardResponse) ProtoMessage() {}
func (*GetShardResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{7}
}
func (m *GetShardResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetShardResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetShardResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetShardResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetShardResponse.Merge(m, src)
}
func (m *GetShardResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetShardResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetShardResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetShardResponse proto.InternalMessageInfo

func (m *GetShardResponse) GetShardInfo() *v11.ShardInfo {
	if m != nil {
		return m.ShardInfo
	}
	return nil
}

type ListTransferTasksRequest struct {
	ShardId       int32  `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	MinTaskId     int64  `protobuf:"varint,2,opt,name=min_task_id,json=minTaskId,proto3" json:"min_task_id,omitempty"`
	MaxTaskId     int64  `protobuf:"varint,4,opt,name=max_task_id,json=maxTaskId,proto3" json:"max_task_id,omitempty"`
	BatchSize     int32  `protobuf:"varint,5,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	NextPageToken []byte `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListTransferTasksRequest) Reset()      { *m = ListTransferTasksRequest{} }
func (*ListTransferTasksRequest) ProtoMessage() {}
func (*ListTransferTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{8}
}
func (m *ListTransferTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListTransferTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListTransferTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListTransferTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferTasksRequest.Merge(m, src)
}
func (m *ListTransferTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListTransferTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferTasksRequest proto.InternalMessageInfo

func (m *ListTransferTasksRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *ListTransferTasksRequest) GetMinTaskId() int64 {
	if m != nil {
		return m.MinTaskId
	}
	return 0
}

func (m *ListTransferTasksRequest) GetMaxTaskId() int64 {
	if m != nil {
		return m.MaxTaskId
	}
	return 0
}

func (m *ListTransferTasksRequest) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

func (m *ListTransferTasksRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListTransferTasksResponse struct {
	Tasks         []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
	NextPageToken []byte  `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListTransferTasksResponse) Reset()      { *m = ListTransferTasksResponse{} }
func (*ListTransferTasksResponse) ProtoMessage() {}
func (*ListTransferTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{9}
}
func (m *ListTransferTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListTransferTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListTransferTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListTransferTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferTasksResponse.Merge(m, src)
}
func (m *ListTransferTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListTransferTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferTasksResponse proto.InternalMessageInfo

func (m *ListTransferTasksResponse) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *ListTransferTasksResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListVisibilityTasksRequest struct {
	ShardId       int32  `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	ReadLevel     int64  `protobuf:"varint,2,opt,name=read_level,json=readLevel,proto3" json:"read_level,omitempty"`
	MaxReadLevel  int64  `protobuf:"varint,4,opt,name=max_read_level,json=maxReadLevel,proto3" json:"max_read_level,omitempty"`
	BatchSize     int32  `protobuf:"varint,5,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	NextPageToken []byte `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListVisibilityTasksRequest) Reset()      { *m = ListVisibilityTasksRequest{} }
func (*ListVisibilityTasksRequest) ProtoMessage() {}
func (*ListVisibilityTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{10}
}
func (m *ListVisibilityTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListVisibilityTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListVisibilityTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListVisibilityTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVisibilityTasksRequest.Merge(m, src)
}
func (m *ListVisibilityTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListVisibilityTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVisibilityTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListVisibilityTasksRequest proto.InternalMessageInfo

func (m *ListVisibilityTasksRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *ListVisibilityTasksRequest) GetReadLevel() int64 {
	if m != nil {
		return m.ReadLevel
	}
	return 0
}

func (m *ListVisibilityTasksRequest) GetMaxReadLevel() int64 {
	if m != nil {
		return m.MaxReadLevel
	}
	return 0
}

func (m *ListVisibilityTasksRequest) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

func (m *ListVisibilityTasksRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListVisibilityTasksResponse struct {
	Tasks         []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
	NextPageToken []byte  `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListVisibilityTasksResponse) Reset()      { *m = ListVisibilityTasksResponse{} }
func (*ListVisibilityTasksResponse) ProtoMessage() {}
func (*ListVisibilityTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{11}
}
func (m *ListVisibilityTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListVisibilityTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListVisibilityTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListVisibilityTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVisibilityTasksResponse.Merge(m, src)
}
func (m *ListVisibilityTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListVisibilityTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVisibilityTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListVisibilityTasksResponse proto.InternalMessageInfo

func (m *ListVisibilityTasksResponse) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *ListVisibilityTasksResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListTimerTasksRequest struct {
	ShardId       int32      `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	MinTime       *time.Time `protobuf:"bytes,2,opt,name=min_time,json=minTime,proto3,stdtime" json:"min_time,omitempty"`
	MaxTime       *time.Time `protobuf:"bytes,3,opt,name=max_time,json=maxTime,proto3,stdtime" json:"max_time,omitempty"`
	BatchSize     int32      `protobuf:"varint,4,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	NextPageToken []byte     `protobuf:"bytes,5,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListTimerTasksRequest) Reset()      { *m = ListTimerTasksRequest{} }
func (*ListTimerTasksRequest) ProtoMessage() {}
func (*ListTimerTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{12}
}
func (m *ListTimerTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListTimerTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListTimerTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListTimerTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTimerTasksRequest.Merge(m, src)
}
func (m *ListTimerTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListTimerTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTimerTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTimerTasksRequest proto.InternalMessageInfo

func (m *ListTimerTasksRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *ListTimerTasksRequest) GetMinTime() *time.Time {
	if m != nil {
		return m.MinTime
	}
	return nil
}

func (m *ListTimerTasksRequest) GetMaxTime() *time.Time {
	if m != nil {
		return m.MaxTime
	}
	return nil
}

func (m *ListTimerTasksRequest) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

func (m *ListTimerTasksRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListTimerTasksResponse struct {
	Tasks         []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
	NextPageToken []byte  `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListTimerTasksResponse) Reset()      { *m = ListTimerTasksResponse{} }
func (*ListTimerTasksResponse) ProtoMessage() {}
func (*ListTimerTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{13}
}
func (m *ListTimerTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListTimerTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListTimerTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListTimerTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTimerTasksResponse.Merge(m, src)
}
func (m *ListTimerTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListTimerTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTimerTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTimerTasksResponse proto.InternalMessageInfo

func (m *ListTimerTasksResponse) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *ListTimerTasksResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListReplicationTasksRequest struct {
	ShardId       int32  `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	MinTaskId     int64  `protobuf:"varint,2,opt,name=min_task_id,json=minTaskId,proto3" json:"min_task_id,omitempty"`
	MaxTaskId     int64  `protobuf:"varint,3,opt,name=max_task_id,json=maxTaskId,proto3" json:"max_task_id,omitempty"`
	BatchSize     int32  `protobuf:"varint,4,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	NextPageToken []byte `protobuf:"bytes,5,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListReplicationTasksRequest) Reset()      { *m = ListReplicationTasksRequest{} }
func (*ListReplicationTasksRequest) ProtoMessage() {}
func (*ListReplicationTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{14}
}
func (m *ListReplicationTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListReplicationTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListReplicationTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListReplicationTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReplicationTasksRequest.Merge(m, src)
}
func (m *ListReplicationTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListReplicationTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReplicationTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListReplicationTasksRequest proto.InternalMessageInfo

func (m *ListReplicationTasksRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *ListReplicationTasksRequest) GetMinTaskId() int64 {
	if m != nil {
		return m.MinTaskId
	}
	return 0
}

func (m *ListReplicationTasksRequest) GetMaxTaskId() int64 {
	if m != nil {
		return m.MaxTaskId
	}
	return 0
}

func (m *ListReplicationTasksRequest) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

func (m *ListReplicationTasksRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListReplicationTasksResponse struct {
	Tasks         []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
	NextPageToken []byte  `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListReplicationTasksResponse) Reset()      { *m = ListReplicationTasksResponse{} }
func (*ListReplicationTasksResponse) ProtoMessage() {}
func (*ListReplicationTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{15}
}
func (m *ListReplicationTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListReplicationTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListReplicationTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListReplicationTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListReplicationTasksResponse.Merge(m, src)
}
func (m *ListReplicationTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListReplicationTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListReplicationTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListReplicationTasksResponse proto.InternalMessageInfo

func (m *ListReplicationTasksResponse) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *ListReplicationTasksResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type Task struct {
	NamespaceId string       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId  string       `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId       string       `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskId      int64        `protobuf:"varint,4,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	TaskType    v13.TaskType `protobuf:"varint,5,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	FireTime    *time.Time   `protobuf:"bytes,6,opt,name=fire_time,json=fireTime,proto3,stdtime" json:"fire_time,omitempty"`
	Version     int64        `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
}

func (m *Task) Reset()      { *m = Task{} }
func (*Task) ProtoMessage() {}
func (*Task) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{16}
}
func (m *Task) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Task) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Task.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Task) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Task.Merge(m, src)
}
func (m *Task) XXX_Size() int {
	return m.Size()
}
func (m *Task) XXX_DiscardUnknown() {
	xxx_messageInfo_Task.DiscardUnknown(m)
}

var xxx_messageInfo_Task proto.InternalMessageInfo

func (m *Task) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *Task) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *Task) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *Task) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *Task) GetTaskType() v13.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v13.TASK_TYPE_UNSPECIFIED
}

func (m *Task) GetFireTime() *time.Time {
	if m != nil {
		return m.FireTime
	}
	return nil
}

func (m *Task) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

type RemoveTaskRequest struct {
	ShardId        int32            `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Category       v13.TaskCategory `protobuf:"varint,2,opt,name=category,proto3,enum=temporal.server.api.enums.v1.TaskCategory" json:"category,omitempty"`
	TaskId         int64            `protobuf:"varint,3,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime *time.Time       `protobuf:"bytes,4,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *RemoveTaskRequest) Reset()      { *m = RemoveTaskRequest{} }
func (*RemoveTaskRequest) ProtoMessage() {}
func (*RemoveTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{17}
}
func (m *RemoveTaskRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskRequest.Merge(m, src)
}
func (m *RemoveTaskRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskRequest proto.InternalMessageInfo

func (m *RemoveTaskRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *RemoveTaskRequest) GetCategory() v13.TaskCategory {
	if m != nil {
		return m.Category
	}
	return v13.TASK_CATEGORY_UNSPECIFIED
}

func (m *RemoveTaskRequest) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *RemoveTaskRequest) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

type RemoveTaskResponse struct {
}

func (m *RemoveTaskResponse) Reset()      { *m = RemoveTaskResponse{} }
func (*RemoveTaskResponse) ProtoMessage() {}
func (*RemoveTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{18}
}
func (m *RemoveTaskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskResponse.Merge(m, src)
}
func (m *RemoveTaskResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskResponse proto.InternalMessageInfo

//*
// StartEventId defines the beginning of the event to fetch. The first event is exclusive.
// EndEventId and EndEventVersion defines the end of the event to fetch. The end event is exclusive.
type GetWorkflowExecutionRawHistoryV2Request struct {
	Namespace         string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution         *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	StartEventId      int64                 `protobuf:"varint,3,opt,name=start_event_id,json=startEventId,proto3" json:"start_event_id,omitempty"`
	StartEventVersion int64                 `protobuf:"varint,4,opt,name=start_event_version,json=startEventVersion,proto3" json:"start_event_version,omitempty"`
	EndEventId        int64                 `protobuf:"varint,5,opt,name=end_event_id,json=endEventId,proto3" json:"end_event_id,omitempty"`
	EndEventVersion   int64                 `protobuf:"varint,6,opt,name=end_event_version,json=endEventVersion,proto3" json:"end_event_version,omitempty"`
	MaximumPageSize   int32                 `protobuf:"varint,7,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken     []byte                `protobuf:"bytes,8,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Reset() {
	*m = GetWorkflowExecutionRawHistoryV2Request{}
}
func (*GetWorkflowExecutionRawHistoryV2Request) ProtoMessage() {}
func (*GetWorkflowExecutionRawHistoryV2Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{19}
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.Merge(m, src)
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request proto.InternalMessageInfo

func (m *GetWorkflowExecutionRawHistoryV2Request) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetStartEventId() int64 {
	if m != nil {
		return m.StartEventId
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetStartEventVersion() int64 {
	if m != nil {
		return m.StartEventVersion
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetEndEventId() int64 {
	if m != nil {
		return m.EndEventId
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetEndEventVersion() int64 {
	if m != nil {
		return m.EndEventVersion
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetWorkflowExecutionRawHistoryV2Response struct {
	NextPageToken  []byte              `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	HistoryBatches []*v1.DataBlob      `protobuf:"bytes,2,rep,name=history_batches,json=historyBatches,proto3" json:"history_batches,omitempty"`
	VersionHistory *v14.VersionHistory `protobuf:"bytes,3,opt,name=version_history,json=versionHistory,proto3" json:"version_history,omitempty"`
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Reset() {
	*m = GetWorkflowExecutionRawHistoryV2Response{}
}
func (*GetWorkflowExecutionRawHistoryV2Response) ProtoMessage() {}
func (*GetWorkflowExecutionRawHistoryV2Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{20}
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.Merge(m, src)
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response proto.InternalMessageInfo

func (m *GetWorkflowExecutionRawHistoryV2Response) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) GetHistoryBatches() []*v1.DataBlob {
	if m != nil {
		return m.HistoryBatches
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) GetVersionHistory() *v14.VersionHistory {
	if m != nil {
		return m.VersionHistory
	}
	return nil
}

type GetReplicationMessagesRequest struct {
	Tokens      []*v15.ReplicationToken `protobuf:"bytes,1,rep,name=tokens,proto3" json:"tokens,omitempty"`
	ClusterName string                  `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GetReplicationMessagesRequest) Reset()      { *m = GetReplicationMessagesRequest{} }
func (*GetReplicationMessagesRequest) ProtoMessage() {}
func (*GetReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{21}
}
func (m *GetReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesRequest.Merge(m, src)
}
func (m *GetReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetReplicationMessagesRequest) GetTokens() []*v15.ReplicationToken {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *GetReplicationMessagesRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GetReplicationMessagesResponse struct {
	ShardMessages map[int32]*v15.ReplicationMessages `protobuf:"bytes,1,rep,name=shard_messages,json=shardMessages,proto3" json:"shard_messages,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *GetReplicationMessagesResponse) Reset()      { *m = GetReplicationMessagesResponse{} }
func (*GetReplicationMessagesResponse) ProtoMessage() {}
func (*GetReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{22}
}
func (m *GetReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesResponse.Merge(m, src)
}
func (m *GetReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetReplicationMessagesResponse) GetShardMessages() map[int32]*v15.ReplicationMessages {
	if m != nil {
		return m.ShardMessages
	}
	return nil
}

type GetNamespaceReplicationMessagesRequest struct {
	// lastRetrievedMessageId is where the next fetch should begin with.
	LastRetrievedMessageId int64 `protobuf:"varint,1,opt,name=last_retrieved_message_id,json=lastRetrievedMessageId,proto3" json:"last_retrieved_message_id,omitempty"`
	// lastProcessedMessageId is the last messageId that is processed on the passive side.
	// This can be different than lastRetrievedMessageId if passive side supports prefetching messages.
	LastProcessedMessageId int64 `protobuf:"varint,2,opt,name=last_processed_message_id,json=lastProcessedMessageId,proto3" json:"last_processed_message_id,omitempty"`
	// clusterName is the name of the pulling cluster.
	ClusterName string `protobuf:"bytes,3,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GetNamespaceReplicationMessagesRequest) Reset() {
	*m = GetNamespaceReplicationMessagesRequest{}
}
func (*GetNamespaceReplicationMessagesRequest) ProtoMessage() {}
func (*GetNamespaceReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{23}
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespaceReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceReplicationMessagesRequest.Merge(m, src)
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetNamespaceReplicationMessagesRequest) GetLastRetrievedMessageId() int64 {
	if m != nil {
		return m.LastRetrievedMessageId
	}
	return 0
}

func (m *GetNamespaceReplicationMessagesRequest) GetLastProcessedMessageId() int64 {
	if m != nil {
		return m.LastProcessedMessageId
	}
	return 0
}

func (m *GetNamespaceReplicationMessagesRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GetNamespaceReplicationMessagesResponse struct {
	Messages *v15.ReplicationMessages `protobuf:"bytes,1,opt,name=messages,proto3" json:"messages,omitempty"`
}

func (m *GetNamespaceReplicationMessagesResponse) Reset() {
	*m = GetNamespaceReplicationMessagesResponse{}
}
func (*GetNamespaceReplicationMessagesResponse) ProtoMessage() {}
func (*GetNamespaceReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{24}
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespaceReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceReplicationMessagesResponse.Merge(m, src)
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetNamespaceReplicationMessagesResponse) GetMessages() *v15.ReplicationMessages {
	if m != nil {
		return m.Messages
	}
	return nil
}

type GetDLQReplicationMessagesRequest struct {
	TaskInfos []*v15.ReplicationTaskInfo `protobuf:"bytes,1,rep,name=task_infos,json=taskInfos,proto3" json:"task_infos,omitempty"`
}

func (m *GetDLQReplicationMessagesRequest) Reset()      { *m = GetDLQReplicationMessagesRequest{} }
func (*GetDLQReplicationMessagesRequest) ProtoMessage() {}
func (*GetDLQReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{25}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.Merge(m, src)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesRequest) GetTaskInfos() []*v15.ReplicationTaskInfo {
	if m != nil {
		return m.TaskInfos
	}
	return nil
}

type GetDLQReplicationMessagesResponse struct {
	ReplicationTasks []*v15.ReplicationTask `protobuf:"bytes,1,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
}

func (m *GetDLQReplicationMessagesResponse) Reset()      { *m = GetDLQReplicationMessagesResponse{} }
func (*GetDLQReplicationMessagesResponse) ProtoMessage() {}
func (*GetDLQReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{26}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.Merge(m, src)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesResponse) GetReplicationTasks() []*v15.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

// ReapplyEventsRequest is the request for reapply events API.
type ReapplyEventsRequest struct {
	Namespace         string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowExecution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	Events            *v1.DataBlob          `protobuf:"bytes,3,opt,name=events,proto3" json:"events,omitempty"`
}

func (m *ReapplyEventsRequest) Reset()      { *m = ReapplyEventsRequest{} }
func (*ReapplyEventsRequest) ProtoMessage() {}
func (*ReapplyEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{27}
}
func (m *ReapplyEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsRequest.Merge(m, src)
}
func (m *ReapplyEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsRequest proto.InternalMessageInfo

func (m *ReapplyEventsRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ReapplyEventsRequest) GetWorkflowExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *ReapplyEventsRequest) GetEvents() *v1.DataBlob {
	if m != nil {
		return m.Events
	}
	return nil
}

type ReapplyEventsResponse struct {
}

func (m *ReapplyEventsResponse) Reset()      { *m = ReapplyEventsResponse{} }
func (*ReapplyEventsResponse) ProtoMessage() {}
func (*ReapplyEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{28}
}
func (m *ReapplyEventsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsResponse.Merge(m, src)
}
func (m *ReapplyEventsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsResponse proto.InternalMessageInfo

type AddSearchAttributesRequest struct {
	SearchAttributes map[string]v16.IndexedValueType `protobuf:"bytes,1,rep,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=temporal.api.enums.v1.IndexedValueType"`
	IndexName        string                          `protobuf:"bytes,2,opt,name=index_name,json=indexName,proto3" json:"index_name,omitempty"`
	SkipSchemaUpdate bool                            `protobuf:"varint,3,opt,name=skip_schema_update,json=skipSchemaUpdate,proto3" json:"skip_schema_update,omitempty"`
}

func (m *AddSearchAttributesRequest) Reset()      { *m = AddSearchAttributesRequest{} }
func (*AddSearchAttributesRequest) ProtoMessage() {}
func (*AddSearchAttributesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{29}
}
func (m *AddSearchAttributesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSearchAttributesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSearchAttributesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSearchAttributesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSearchAttributesRequest.Merge(m, src)
}
func (m *AddSearchAttributesRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddSearchAttributesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSearchAttributesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddSearchAttributesRequest proto.InternalMessageInfo

func (m *AddSearchAttributesRequest) GetSearchAttributes() map[string]v16.IndexedValueType {
	if m != nil {
		return m.SearchAttributes
	}
	return nil
}

func (m *AddSearchAttributesRequest) GetIndexName() string {
	if m != nil {
		return m.IndexName
	}
	return ""
}

func (m *AddSearchAttributesRequest) GetSkipSchemaUpdate() bool {
	if m != nil {
		return m.SkipSchemaUpdate
	}
	return false
}

type AddSearchAttributesResponse struct {
}

func (m *AddSearchAttributesResponse) Reset()      { *m = AddSearchAttributesResponse{} }
func (*AddSearchAttributesResponse) ProtoMessage() {}
func (*AddSearchAttributesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{30}
}
func (m *AddSearchAttributesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSearchAttributesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSearchAttributesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSearchAttributesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSearchAttributesResponse.Merge(m, src)
}
func (m *AddSearchAttributesResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddSearchAttributesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSearchAttributesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddSearchAttributesResponse proto.InternalMessageInfo

type RemoveSearchAttributesRequest struct {
	SearchAttributes []string `protobuf:"bytes,1,rep,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty"`
	IndexName        string   `protobuf:"bytes,2,opt,name=index_name,json=indexName,proto3" json:"index_name,omitempty"`
}

func (m *RemoveSearchAttributesRequest) Reset()      { *m = RemoveSearchAttributesRequest{} }
func (*RemoveSearchAttributesRequest) ProtoMessage() {}
func (*RemoveSearchAttributesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{31}
}
func (m *RemoveSearchAttributesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveSearchAttributesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveSearchAttributesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveSearchAttributesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveSearchAttributesRequest.Merge(m, src)
}
func (m *RemoveSearchAttributesRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveSearchAttributesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveSearchAttributesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveSearchAttributesRequest proto.InternalMessageInfo

func (m *RemoveSearchAttributesRequest) GetSearchAttributes() []string {
	if m != nil {
		return m.SearchAttributes
	}
	return nil
}

func (m *RemoveSearchAttributesRequest) GetIndexName() string {
	if m != nil {
		return m.IndexName
	}
	return ""
}

type RemoveSearchAttributesResponse struct {
}

func (m *RemoveSearchAttributesResponse) Reset()      { *m = RemoveSearchAttributesResponse{} }
func (*RemoveSearchAttributesResponse) ProtoMessage() {}
func (*RemoveSearchAttributesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{32}
}
func (m *RemoveSearchAttributesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveSearchAttributesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveSearchAttributesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveSearchAttributesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveSearchAttributesResponse.Merge(m, src)
}
func (m *RemoveSearchAttributesResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveSearchAttributesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveSearchAttributesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveSearchAttributesResponse proto.InternalMessageInfo

type GetSearchAttributesRequest struct {
	IndexName string `protobuf:"bytes,1,opt,name=index_name,json=indexName,proto3" json:"index_name,omitempty"`
}

func (m *GetSearchAttributesRequest) Reset()      { *m = GetSearchAttributesRequest{} }
func (*GetSearchAttributesRequest) ProtoMessage() {}
func (*GetSearchAttributesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{33}
}
func (m *GetSearchAttributesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetSearchAttributesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetSearchAttributesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetSearchAttributesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSearchAttributesRequest.Merge(m, src)
}
func (m *GetSearchAttributesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetSearchAttributesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSearchAttributesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSearchAttributesRequest proto.InternalMessageInfo

func (m *GetSearchAttributesRequest) GetIndexName() string {
	if m != nil {
		return m.IndexName
	}
	return ""
}

type GetSearchAttributesResponse struct {
	CustomAttributes map[string]v16.IndexedValueType `protobuf:"bytes,1,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=temporal.api.enums.v1.IndexedValueType"`
	SystemAttributes map[string]v16.IndexedValueType `protobuf:"bytes,2,rep,name=system_attributes,json=systemAttributes,proto3" json:"system_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=temporal.api.enums.v1.IndexedValueType"`
	Mapping          map[string]string               `protobuf:"bytes,3,rep,name=mapping,proto3" json:"mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// State of the workflow that adds search attributes to the system.
	AddWorkflowExecutionInfo *v17.WorkflowExecutionInfo `protobuf:"bytes,4,opt,name=add_workflow_execution_info,json=addWorkflowExecutionInfo,proto3" json:"add_workflow_execution_info,omitempty"`
}

func (m *GetSearchAttributesResponse) Reset()      { *m = GetSearchAttributesResponse{} }
func (*GetSearchAttributesResponse) ProtoMessage() {}
func (*GetSearchAttributesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{34}
}
func (m *GetSearchAttributesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetSearchAttributesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetSearchAttributesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetSearchAttributesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSearchAttributesResponse.Merge(m, src)
}
func (m *GetSearchAttributesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetSearchAttributesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSearchAttributesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetSearchAttributesResponse proto.InternalMessageInfo

func (m *GetSearchAttributesResponse) GetCustomAttributes() map[string]v16.IndexedValueType {
	if m != nil {
		return m.CustomAttributes
	}
	return nil
}

func (m *GetSearchAttributesResponse) GetSystemAttributes() map[string]v16.IndexedValueType {
	if m != nil {
		return m.SystemAttributes
	}
	return nil
}

func (m *GetSearchAttributesResponse) GetMapping() map[string]string {
	if m != nil {
		return m.Mapping
	}
	return nil
}

func (m *GetSearchAttributesResponse) GetAddWorkflowExecutionInfo() *v17.WorkflowExecutionInfo {
	if m != nil {
		return m.AddWorkflowExecutionInfo
	}
	return nil
}

type DescribeClusterRequest struct {
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *DescribeClusterRequest) Reset()      { *m = DescribeClusterRequest{} }
func (*DescribeClusterRequest) ProtoMessage() {}
func (*DescribeClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{35}
}
func (m *DescribeClusterRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeClusterRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeClusterRequest.Merge(m, src)
}
func (m *DescribeClusterRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeClusterRequest proto.InternalMessageInfo

func (m *DescribeClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type DescribeClusterResponse struct {
	SupportedClients         map[string]string   `protobuf:"bytes,1,rep,name=supported_clients,json=supportedClients,proto3" json:"supported_clients,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ServerVersion            string              `protobuf:"bytes,2,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
	MembershipInfo           *v18.MembershipInfo `protobuf:"bytes,3,opt,name=membership_info,json=membershipInfo,proto3" json:"membership_info,omitempty"`
	ClusterId                string              `protobuf:"bytes,4,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterName              string              `protobuf:"bytes,5,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	HistoryShardCount        int32               `protobuf:"varint,6,opt,name=history_shard_count,json=historyShardCount,proto3" json:"history_shard_count,omitempty"`
	PersistenceStore         string              `protobuf:"bytes,7,opt,name=persistence_store,json=persistenceStore,proto3" json:"persistence_store,omitempty"`
	VisibilityStore          string              `protobuf:"bytes,8,opt,name=visibility_store,json=visibilityStore,proto3" json:"visibility_store,omitempty"`
	VersionInfo              *v19.VersionInfo    `protobuf:"bytes,9,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	FailoverVersionIncrement int64               `protobuf:"varint,10,opt,name=failover_version_increment,json=failoverVersionIncrement,proto3" json:"failover_version_increment,omitempty"`
	InitialFailoverVersion   int64               `protobuf:"varint,11,opt,name=initial_failover_version,json=initialFailoverVersion,proto3" json:"initial_failover_version,omitempty"`
	IsGlobalNamespaceEnabled bool                `protobuf:"varint,12,opt,name=is_global_namespace_enabled,json=isGlobalNamespaceEnabled,proto3" json:"is_global_namespace_enabled,omitempty"`
}

func (m *DescribeClusterResponse) Reset()      { *m = DescribeClusterResponse{} }
func (*DescribeClusterResponse) ProtoMessage() {}
func (*DescribeClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{36}
}
func (m *DescribeClusterResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeClusterResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeClusterResponse.Merge(m, src)
}
func (m *DescribeClusterResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeClusterResponse proto.InternalMessageInfo

func (m *DescribeClusterResponse) GetSupportedClients() map[string]string {
	if m != nil {
		return m.SupportedClients
	}
	return nil
}

func (m *DescribeClusterResponse) GetServerVersion() string {
	if m != nil {
		return m.ServerVersion
	}
	return ""
}

func (m *DescribeClusterResponse) GetMembershipInfo() *v18.MembershipInfo {
	if m != nil {
		return m.MembershipInfo
	}
	return nil
}

func (m *DescribeClusterResponse) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DescribeClusterResponse) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *DescribeClusterResponse) GetHistoryShardCount() int32 {
	if m != nil {
		return m.HistoryShardCount
	}
	return 0
}

func (m *DescribeClusterResponse) GetPersistenceStore() string {
	if m != nil {
		return m.PersistenceStore
	}
	return ""
}

func (m *DescribeClusterResponse) GetVisibilityStore() string {
	if m != nil {
		return m.VisibilityStore
	}
	return ""
}

func (m *DescribeClusterResponse) GetVersionInfo() *v19.VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return nil
}

func (m *DescribeClusterResponse) GetFailoverVersionIncrement() int64 {
	if m != nil {
		return m.FailoverVersionIncrement
	}
	return 0
}

func (m *DescribeClusterResponse) GetInitialFailoverVersion() int64 {
	if m != nil {
		return m.InitialFailoverVersion
	}
	return 0
}

func (m *DescribeClusterResponse) GetIsGlobalNamespaceEnabled() bool {
	if m != nil {
		return m.IsGlobalNamespaceEnabled
	}
	return false
}

type AddOrUpdateRemoteClusterRequest struct {
	FrontendAddress               string `protobuf:"bytes,1,opt,name=frontend_address,json=frontendAddress,proto3" json:"frontend_address,omitempty"`
	EnableRemoteClusterConnection bool   `protobuf:"varint,2,opt,name=enable_remote_cluster_connection,json=enableRemoteClusterConnection,proto3" json:"enable_remote_cluster_connection,omitempty"`
}

func (m *AddOrUpdateRemoteClusterRequest) Reset()      { *m = AddOrUpdateRemoteClusterRequest{} }
func (*AddOrUpdateRemoteClusterRequest) ProtoMessage() {}
func (*AddOrUpdateRemoteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{37}
}
func (m *AddOrUpdateRemoteClusterRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddOrUpdateRemoteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddOrUpdateRemoteClusterRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddOrUpdateRemoteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddOrUpdateRemoteClusterRequest.Merge(m, src)
}
func (m *AddOrUpdateRemoteClusterRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddOrUpdateRemoteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddOrUpdateRemoteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddOrUpdateRemoteClusterRequest proto.InternalMessageInfo

func (m *AddOrUpdateRemoteClusterRequest) GetFrontendAddress() string {
	if m != nil {
		return m.FrontendAddress
	}
	return ""
}

func (m *AddOrUpdateRemoteClusterRequest) GetEnableRemoteClusterConnection() bool {
	if m != nil {
		return m.EnableRemoteClusterConnection
	}
	return false
}

type AddOrUpdateRemoteClusterResponse struct {
}

func (m *AddOrUpdateRemoteClusterResponse) Reset()      { *m = AddOrUpdateRemoteClusterResponse{} }
func (*AddOrUpdateRemoteClusterResponse) ProtoMessage() {}
func (*AddOrUpdateRemoteClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{38}
}
func (m *AddOrUpdateRemoteClusterResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddOrUpdateRemoteClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddOrUpdateRemoteClusterResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddOrUpdateRemoteClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddOrUpdateRemoteClusterResponse.Merge(m, src)
}
func (m *AddOrUpdateRemoteClusterResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddOrUpdateRemoteClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddOrUpdateRemoteClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddOrUpdateRemoteClusterResponse proto.InternalMessageInfo

type RemoveRemoteClusterRequest struct {
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *RemoveRemoteClusterRequest) Reset()      { *m = RemoveRemoteClusterRequest{} }
func (*RemoveRemoteClusterRequest) ProtoMessage() {}
func (*RemoveRemoteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{39}
}
func (m *RemoveRemoteClusterRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveRemoteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveRemoteClusterRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveRemoteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveRemoteClusterRequest.Merge(m, src)
}
func (m *RemoveRemoteClusterRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveRemoteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveRemoteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveRemoteClusterRequest proto.InternalMessageInfo

func (m *RemoveRemoteClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type RemoveRemoteClusterResponse struct {
}

func (m *RemoveRemoteClusterResponse) Reset()      { *m = RemoveRemoteClusterResponse{} }
func (*RemoveRemoteClusterResponse) ProtoMessage() {}
func (*RemoveRemoteClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{40}
}
func (m *RemoveRemoteClusterResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveRemoteClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveRemoteClusterResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveRemoteClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveRemoteClusterResponse.Merge(m, src)
}
func (m *RemoveRemoteClusterResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveRemoteClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveRemoteClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveRemoteClusterResponse proto.InternalMessageInfo

type ListClusterMembersRequest struct {
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "within" is used to indicate a time range. --)
	LastHeartbeatWithin *time.Duration        `protobuf:"bytes,1,opt,name=last_heartbeat_within,json=lastHeartbeatWithin,proto3,stdduration" json:"last_heartbeat_within,omitempty"`
	RpcAddress          string                `protobuf:"bytes,2,opt,name=rpc_address,json=rpcAddress,proto3" json:"rpc_address,omitempty"`
	HostId              string                `protobuf:"bytes,3,opt,name=host_id,json=hostId,proto3" json:"host_id,omitempty"`
	Role                v13.ClusterMemberRole `protobuf:"varint,4,opt,name=role,proto3,enum=temporal.server.api.enums.v1.ClusterMemberRole" json:"role,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "after" is used to indicate a time range. --)
	SessionStartedAfterTime *time.Time `protobuf:"bytes,5,opt,name=session_started_after_time,json=sessionStartedAfterTime,proto3,stdtime" json:"session_started_after_time,omitempty"`
	PageSize                int32      `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	NextPageToken           []byte     `protobuf:"bytes,7,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListClusterMembersRequest) Reset()      { *m = ListClusterMembersRequest{} }
func (*ListClusterMembersRequest) ProtoMessage() {}
func (*ListClusterMembersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{41}
}
func (m *ListClusterMembersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListClusterMembersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListClusterMembersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListClusterMembersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterMembersRequest.Merge(m, src)
}
func (m *ListClusterMembersRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListClusterMembersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterMembersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterMembersRequest proto.InternalMessageInfo

func (m *ListClusterMembersRequest) GetLastHeartbeatWithin() *time.Duration {
	if m != nil {
		return m.LastHeartbeatWithin
	}
	return nil
}

func (m *ListClusterMembersRequest) GetRpcAddress() string {
	if m != nil {
		return m.RpcAddress
	}
	return ""
}

func (m *ListClusterMembersRequest) GetHostId() string {
	if m != nil {
		return m.HostId
	}
	return ""
}

func (m *ListClusterMembersRequest) GetRole() v13.ClusterMemberRole {
	if m != nil {
		return m.Role
	}
	return v13.CLUSTER_MEMBER_ROLE_UNSPECIFIED
}

func (m *ListClusterMembersRequest) GetSessionStartedAfterTime() *time.Time {
	if m != nil {
		return m.SessionStartedAfterTime
	}
	return nil
}

func (m *ListClusterMembersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterMembersRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type ListClusterMembersResponse struct {
	ActiveMembers []*v18.ClusterMember `protobuf:"bytes,1,rep,name=active_members,json=activeMembers,proto3" json:"active_members,omitempty"`
	NextPageToken []byte               `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *ListClusterMembersResponse) Reset()      { *m = ListClusterMembersResponse{} }
func (*ListClusterMembersResponse) ProtoMessage() {}
func (*ListClusterMembersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{42}
}
func (m *ListClusterMembersResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListClusterMembersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListClusterMembersResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListClusterMembersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterMembersResponse.Merge(m, src)
}
func (m *ListClusterMembersResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListClusterMembersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterMembersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterMembersResponse proto.InternalMessageInfo

func (m *ListClusterMembersResponse) GetActiveMembers() []*v18.ClusterMember {
	if m != nil {
		return m.ActiveMembers
	}
	return nil
}

func (m *ListClusterMembersResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetDLQMessagesRequest struct {
	Type                  v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesRequest) Reset()      { *m = GetDLQMessagesRequest{} }
func (*GetDLQMessagesRequest) ProtoMessage() {}
func (*GetDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{43}
}
func (m *GetDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesRequest.Merge(m, src)
}
func (m *GetDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesRequest proto.InternalMessageInfo

func (m *GetDLQMessagesRequest) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *GetDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetDLQMessagesResponse struct {
	Type             v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ReplicationTasks []*v15.ReplicationTask  `protobuf:"bytes,2,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
	NextPageToken    []byte                  `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesResponse) Reset()      { *m = GetDLQMessagesResponse{} }
func (*GetDLQMessagesResponse) ProtoMessage() {}
func (*GetDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{44}
}
func (m *GetDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesResponse.Merge(m, src)
}
func (m *GetDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesResponse proto.InternalMessageInfo

func (m *GetDLQMessagesResponse) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesResponse) GetReplicationTasks() []*v15.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

func (m *GetDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type PurgeDLQMessagesRequest struct {
	Type                  v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
}

func (m *PurgeDLQMessagesRequest) Reset()      { *m = PurgeDLQMessagesRequest{} }
func (*PurgeDLQMessagesRequest) ProtoMessage() {}
func (*PurgeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{45}
}
func (m *PurgeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesRequest.Merge(m, src)
}
func (m *PurgeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesRequest proto.InternalMessageInfo

func (m *PurgeDLQMessagesRequest) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *PurgeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *PurgeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *PurgeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

type PurgeDLQMessagesResponse struct {
}

func (m *PurgeDLQMessagesResponse) Reset()      { *m = PurgeDLQMessagesResponse{} }
func (*PurgeDLQMessagesResponse) ProtoMessage() {}
func (*PurgeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{46}
}
func (m *PurgeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesResponse.Merge(m, src)
}
func (m *PurgeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesResponse proto.InternalMessageInfo

type MergeDLQMessagesRequest struct {
	Type                  v13.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesRequest) Reset()      { *m = MergeDLQMessagesRequest{} }
func (*MergeDLQMessagesRequest) ProtoMessage() {}
func (*MergeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{47}
}
func (m *MergeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesRequest.Merge(m, src)
}
func (m *MergeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesRequest proto.InternalMessageInfo

func (m *MergeDLQMessagesRequest) GetType() v13.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v13.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *MergeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *MergeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type MergeDLQMessagesResponse struct {
	NextPageToken []byte `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesResponse) Reset()      { *m = MergeDLQMessagesResponse{} }
func (*MergeDLQMessagesResponse) ProtoMessage() {}
func (*MergeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{48}
}
func (m *MergeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesResponse.Merge(m, src)
}
func (m *MergeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesResponse proto.InternalMessageInfo

func (m *MergeDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type RefreshWorkflowTasksRequest struct {
	Namespace string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *RefreshWorkflowTasksRequest) Reset()      { *m = RefreshWorkflowTasksRequest{} }
func (*RefreshWorkflowTasksRequest) ProtoMessage() {}
func (*RefreshWorkflowTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{49}
}
func (m *RefreshWorkflowTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksRequest.Merge(m, src)
}
func (m *RefreshWorkflowTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksRequest proto.InternalMessageInfo

func (m *RefreshWorkflowTasksRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *RefreshWorkflowTasksRequest) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type RefreshWorkflowTasksResponse struct {
}

func (m *RefreshWorkflowTasksResponse) Reset()      { *m = RefreshWorkflowTasksResponse{} }
func (*RefreshWorkflowTasksResponse) ProtoMessage() {}
func (*RefreshWorkflowTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{50}
}
func (m *RefreshWorkflowTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksResponse.Merge(m, src)
}
func (m *RefreshWorkflowTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksResponse proto.InternalMessageInfo

type ResendReplicationTasksRequest struct {
	NamespaceId   string `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId    string `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId         string `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	RemoteCluster string `protobuf:"bytes,4,opt,name=remote_cluster,json=remoteCluster,proto3" json:"remote_cluster,omitempty"`
	StartEventId  int64  `protobuf:"varint,5,opt,name=start_event_id,json=startEventId,proto3" json:"start_event_id,omitempty"`
	StartVersion  int64  `protobuf:"varint,6,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndEventId    int64  `protobuf:"varint,7,opt,name=end_event_id,json=endEventId,proto3" json:"end_event_id,omitempty"`
	EndVersion    int64  `protobuf:"varint,8,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
}

func (m *ResendReplicationTasksRequest) Reset()      { *m = ResendReplicationTasksRequest{} }
func (*ResendReplicationTasksRequest) ProtoMessage() {}
func (*ResendReplicationTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{51}
}
func (m *ResendReplicationTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResendReplicationTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResendReplicationTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResendReplicationTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResendReplicationTasksRequest.Merge(m, src)
}
func (m *ResendReplicationTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResendReplicationTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResendReplicationTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResendReplicationTasksRequest proto.InternalMessageInfo

func (m *ResendReplicationTasksRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetRemoteCluster() string {
	if m != nil {
		return m.RemoteCluster
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetStartEventId() int64 {
	if m != nil {
		return m.StartEventId
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetStartVersion() int64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetEndEventId() int64 {
	if m != nil {
		return m.EndEventId
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetEndVersion() int64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

type ResendReplicationTasksResponse struct {
}

func (m *ResendReplicationTasksResponse) Reset()      { *m = ResendReplicationTasksResponse{} }
func (*ResendReplicationTasksResponse) ProtoMessage() {}
func (*ResendReplicationTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{52}
}
func (m *ResendReplicationTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResendReplicationTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResendReplicationTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResendReplicationTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResendReplicationTasksResponse.Merge(m, src)
}
func (m *ResendReplicationTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResendReplicationTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResendReplicationTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResendReplicationTasksResponse proto.InternalMessageInfo

type GetTaskQueueTasksRequest struct {
	Namespace     string            `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	TaskQueue     string            `protobuf:"bytes,2,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	TaskQueueType v16.TaskQueueType `protobuf:"varint,3,opt,name=task_queue_type,json=taskQueueType,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"task_queue_type,omitempty"`
	MinTaskId     int64             `protobuf:"varint,4,opt,name=min_task_id,json=minTaskId,proto3" json:"min_task_id,omitempty"`
	MaxTaskId     int64             `protobuf:"varint,5,opt,name=max_task_id,json=maxTaskId,proto3" json:"max_task_id,omitempty"`
	BatchSize     int32             `protobuf:"varint,6,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
}

func (m *GetTaskQueueTasksRequest) Reset()      { *m = GetTaskQueueTasksRequest{} }
func (*GetTaskQueueTasksRequest) ProtoMessage() {}
func (*GetTaskQueueTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{53}
}
func (m *GetTaskQueueTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetTaskQueueTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetTaskQueueTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetTaskQueueTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTaskQueueTasksRequest.Merge(m, src)
}
func (m *GetTaskQueueTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetTaskQueueTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTaskQueueTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTaskQueueTasksRequest proto.InternalMessageInfo

func (m *GetTaskQueueTasksRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GetTaskQueueTasksRequest) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *GetTaskQueueTasksRequest) GetTaskQueueType() v16.TaskQueueType {
	if m != nil {
		return m.TaskQueueType
	}
	return v16.TASK_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetTaskQueueTasksRequest) GetMinTaskId() int64 {
	if m != nil {
		return m.MinTaskId
	}
	return 0
}

func (m *GetTaskQueueTasksRequest) GetMaxTaskId() int64 {
	if m != nil {
		return m.MaxTaskId
	}
	return 0
}

func (m *GetTaskQueueTasksRequest) GetBatchSize() int32 {
	if m != nil {
		return m.BatchSize
	}
	return 0
}

type GetTaskQueueTasksResponse struct {
	Tasks []*v11.AllocatedTaskInfo `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
}

func (m *GetTaskQueueTasksResponse) Reset()      { *m = GetTaskQueueTasksResponse{} }
func (*GetTaskQueueTasksResponse) ProtoMessage() {}
func (*GetTaskQueueTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{54}
}
func (m *GetTaskQueueTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetTaskQueueTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetTaskQueueTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetTaskQueueTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTaskQueueTasksResponse.Merge(m, src)
}
func (m *GetTaskQueueTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetTaskQueueTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTaskQueueTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetTaskQueueTasksResponse proto.InternalMessageInfo

func (m *GetTaskQueueTasksResponse) GetTasks() []*v11.AllocatedTaskInfo {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func init() {
	proto.RegisterType((*DescribeMutableStateRequest)(nil), "temporal.server.api.adminservice.v1.DescribeMutableStateRequest")
	proto.RegisterType((*DescribeMutableStateResponse)(nil), "temporal.server.api.adminservice.v1.DescribeMutableStateResponse")
	proto.RegisterType((*DescribeHistoryHostRequest)(nil), "temporal.server.api.adminservice.v1.DescribeHistoryHostRequest")
	proto.RegisterType((*DescribeHistoryHostResponse)(nil), "temporal.server.api.adminservice.v1.DescribeHistoryHostResponse")
	proto.RegisterType((*CloseShardRequest)(nil), "temporal.server.api.adminservice.v1.CloseShardRequest")
	proto.RegisterType((*CloseShardResponse)(nil), "temporal.server.api.adminservice.v1.CloseShardResponse")
	proto.RegisterType((*GetShardRequest)(nil), "temporal.server.api.adminservice.v1.GetShardRequest")
	proto.RegisterType((*GetShardResponse)(nil), "temporal.server.api.adminservice.v1.GetShardResponse")
	proto.RegisterType((*ListTransferTasksRequest)(nil), "temporal.server.api.adminservice.v1.ListTransferTasksRequest")
	proto.RegisterType((*ListTransferTasksResponse)(nil), "temporal.server.api.adminservice.v1.ListTransferTasksResponse")
	proto.RegisterType((*ListVisibilityTasksRequest)(nil), "temporal.server.api.adminservice.v1.ListVisibilityTasksRequest")
	proto.RegisterType((*ListVisibilityTasksResponse)(nil), "temporal.server.api.adminservice.v1.ListVisibilityTasksResponse")
	proto.RegisterType((*ListTimerTasksRequest)(nil), "temporal.server.api.adminservice.v1.ListTimerTasksRequest")
	proto.RegisterType((*ListTimerTasksResponse)(nil), "temporal.server.api.adminservice.v1.ListTimerTasksResponse")
	proto.RegisterType((*ListReplicationTasksRequest)(nil), "temporal.server.api.adminservice.v1.ListReplicationTasksRequest")
	proto.RegisterType((*ListReplicationTasksResponse)(nil), "temporal.server.api.adminservice.v1.ListReplicationTasksResponse")
	proto.RegisterType((*Task)(nil), "temporal.server.api.adminservice.v1.Task")
	proto.RegisterType((*RemoveTaskRequest)(nil), "temporal.server.api.adminservice.v1.RemoveTaskRequest")
	proto.RegisterType((*RemoveTaskResponse)(nil), "temporal.server.api.adminservice.v1.RemoveTaskResponse")
	proto.RegisterType((*GetWorkflowExecutionRawHistoryV2Request)(nil), "temporal.server.api.adminservice.v1.GetWorkflowExecutionRawHistoryV2Request")
	proto.RegisterType((*GetWorkflowExecutionRawHistoryV2Response)(nil), "temporal.server.api.adminservice.v1.GetWorkflowExecutionRawHistoryV2Response")
	proto.RegisterType((*GetReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesRequest")
	proto.RegisterType((*GetReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesResponse")
	proto.RegisterMapType((map[int32]*v15.ReplicationMessages)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesResponse.ShardMessagesEntry")
	proto.RegisterType((*GetNamespaceReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetNamespaceReplicationMessagesRequest")
	proto.RegisterType((*GetNamespaceReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetNamespaceReplicationMessagesResponse")
	proto.RegisterType((*GetDLQReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetDLQReplicationMessagesRequest")
	proto.RegisterType((*GetDLQReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetDLQReplicationMessagesResponse")
	proto.RegisterType((*ReapplyEventsRequest)(nil), "temporal.server.api.adminservice.v1.ReapplyEventsRequest")
	proto.RegisterType((*ReapplyEventsResponse)(nil), "temporal.server.api.adminservice.v1.ReapplyEventsResponse")
	proto.RegisterType((*AddSearchAttributesRequest)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributesRequest")
	proto.RegisterMapType((map[string]v16.IndexedValueType)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributesRequest.SearchAttributesEntry")
	proto.RegisterType((*AddSearchAttributesResponse)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributesResponse")
	proto.RegisterType((*RemoveSearchAttributesRequest)(nil), "temporal.server.api.adminservice.v1.RemoveSearchAttributesRequest")
	proto.RegisterType((*RemoveSearchAttributesResponse)(nil), "temporal.server.api.adminservice.v1.RemoveSearchAttributesResponse")
	proto.RegisterType((*GetSearchAttributesRequest)(nil), "temporal.server.api.adminservice.v1.GetSearchAttributesRequest")
	proto.RegisterType((*GetSearchAttributesResponse)(nil), "temporal.server.api.adminservice.v1.GetSearchAttributesResponse")
	proto.RegisterMapType((map[string]v16.IndexedValueType)(nil), "temporal.server.api.adminservice.v1.GetSearchAttributesResponse.CustomAttributesEntry")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.adminservice.v1.GetSearchAttributesResponse.MappingEntry")
	proto.RegisterMapType((map[string]v16.IndexedValueType)(nil), "temporal.server.api.adminservice.v1.GetSearchAttributesResponse.SystemAttributesEntry")
	proto.RegisterType((*DescribeClusterRequest)(nil), "temporal.server.api.adminservice.v1.DescribeClusterRequest")
	proto.RegisterType((*DescribeClusterResponse)(nil), "temporal.server.api.adminservice.v1.DescribeClusterResponse")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.adminservice.v1.DescribeClusterResponse.SupportedClientsEntry")
	proto.RegisterType((*AddOrUpdateRemoteClusterRequest)(nil), "temporal.server.api.adminservice.v1.AddOrUpdateRemoteClusterRequest")
	proto.RegisterType((*AddOrUpdateRemoteClusterResponse)(nil), "temporal.server.api.adminservice.v1.AddOrUpdateRemoteClusterResponse")
	proto.RegisterType((*RemoveRemoteClusterRequest)(nil), "temporal.server.api.adminservice.v1.RemoveRemoteClusterRequest")
	proto.RegisterType((*RemoveRemoteClusterResponse)(nil), "temporal.server.api.adminservice.v1.RemoveRemoteClusterResponse")
	proto.RegisterType((*ListClusterMembersRequest)(nil), "temporal.server.api.adminservice.v1.ListClusterMembersRequest")
	proto.RegisterType((*ListClusterMembersResponse)(nil), "temporal.server.api.adminservice.v1.ListClusterMembersResponse")
	proto.RegisterType((*GetDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetDLQMessagesRequest")
	proto.RegisterType((*GetDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetDLQMessagesResponse")
	proto.RegisterType((*PurgeDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.PurgeDLQMessagesRequest")
	proto.RegisterType((*PurgeDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.PurgeDLQMessagesResponse")
	proto.RegisterType((*MergeDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.MergeDLQMessagesRequest")
	proto.RegisterType((*MergeDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.MergeDLQMessagesResponse")
	proto.RegisterType((*RefreshWorkflowTasksRequest)(nil), "temporal.server.api.adminservice.v1.RefreshWorkflowTasksRequest")
	proto.RegisterType((*RefreshWorkflowTasksResponse)(nil), "temporal.server.api.adminservice.v1.RefreshWorkflowTasksResponse")
	proto.RegisterType((*ResendReplicationTasksRequest)(nil), "temporal.server.api.adminservice.v1.ResendReplicationTasksRequest")
	proto.RegisterType((*ResendReplicationTasksResponse)(nil), "temporal.server.api.adminservice.v1.ResendReplicationTasksResponse")
	proto.RegisterType((*GetTaskQueueTasksRequest)(nil), "temporal.server.api.adminservice.v1.GetTaskQueueTasksRequest")
	proto.RegisterType((*GetTaskQueueTasksResponse)(nil), "temporal.server.api.adminservice.v1.GetTaskQueueTasksResponse")
}

func init() {
	proto.RegisterFile("temporal/server/api/adminservice/v1/request_response.proto", fileDescriptor_cc07c1a2abe7cb51)
}

var fileDescriptor_cc07c1a2abe7cb51 = []byte{
	// 2980 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x5a, 0xcd, 0x6f, 0x1b, 0xc7,
	0x15, 0xf7, 0x92, 0xa2, 0x44, 0x3e, 0x49, 0x94, 0xb4, 0xb1, 0x2c, 0x9a, 0xb2, 0x68, 0x85, 0x71,
	0x1c, 0xdb, 0x4d, 0xa8, 0x5a, 0x69, 0x13, 0x37, 0x6e, 0x10, 0xc8, 0xb2, 0xa3, 0x08, 0xb5, 0xd2,
	0x64, 0xe9, 0xd8, 0x45, 0x81, 0x60, 0x33, 0xdc, 0x1d, 0x51, 0x0b, 0xef, 0x57, 0x76, 0x86, 0xb4,
	0x14, 0xa0, 0xdf, 0xe9, 0xc7, 0xd1, 0x40, 0x51, 0x20, 0xc8, 0x5f, 0xd0, 0x1e, 0x8a, 0xde, 0x7a,
	0x2a, 0x50, 0x14, 0xbd, 0xe4, 0x18, 0xf4, 0x14, 0xb4, 0x05, 0xd2, 0x28, 0x97, 0xf6, 0x16, 0xa0,
	0x40, 0xcf, 0xc5, 0x7c, 0x2d, 0x77, 0xc9, 0x25, 0x45, 0xc5, 0x1f, 0x87, 0xdc, 0xb8, 0x6f, 0xde,
	0x7b, 0xf3, 0xde, 0x6f, 0xde, 0xbc, 0x79, 0xf3, 0x86, 0xf0, 0x12, 0xc5, 0x5e, 0x18, 0x44, 0xc8,
	0x5d, 0x23, 0x38, 0xea, 0xe2, 0x68, 0x0d, 0x85, 0xce, 0x1a, 0xb2, 0x3d, 0xc7, 0x67, 0xdf, 0x8e,
	0x85, 0xd7, 0xba, 0x97, 0xd7, 0x22, 0xfc, 0x6e, 0x07, 0x13, 0x6a, 0x46, 0x98, 0x84, 0x81, 0x4f,
	0x70, 0x23, 0x8c, 0x02, 0x1a, 0xe8, 0x4f, 0x29, 0xd9, 0x86, 0x90, 0x6d, 0xa0, 0xd0, 0x69, 0x24,
	0x65, 0x1b, 0xdd, 0xcb, 0xd5, 0xb3, 0xed, 0x20, 0x68, 0xbb, 0x78, 0x8d, 0x8b, 0xb4, 0x3a, 0xbb,
	0x6b, 0xd4, 0xf1, 0x30, 0xa1, 0xc8, 0x0b, 0x85, 0x96, 0x6a, 0xad, 0x9f, 0xc1, 0xee, 0x44, 0x88,
	0x3a, 0x81, 0x2f, 0xc7, 0x9f, 0xb4, 0x71, 0x88, 0x7d, 0x1b, 0xfb, 0x96, 0x83, 0xc9, 0x5a, 0x3b,
	0x68, 0x07, 0x9c, 0xce, 0x7f, 0x49, 0x96, 0x7a, 0xec, 0x04, 0xb3, 0x1e, 0xfb, 0x1d, 0x8f, 0x30,
	0xb3, 0xad, 0xc0, 0xf3, 0x62, 0x35, 0x4f, 0x67, 0xf3, 0xf8, 0xc8, 0xc3, 0x24, 0x44, 0x96, 0xf4,
	0xa9, 0x7a, 0x3e, 0x9b, 0x8d, 0x22, 0x72, 0xd7, 0x7c, 0xb7, 0x83, 0x3b, 0x8a, 0xef, 0x5c, 0x8a,
	0x4f, 0xcc, 0xc4, 0x18, 0x3d, 0x4c, 0x08, 0x6a, 0xe3, 0xcc, 0x49, 0xbb, 0x38, 0x22, 0x4e, 0x16,
	0x5b, 0x7a, 0xd2, 0x7b, 0x41, 0x74, 0x77, 0xd7, 0x0d, 0xee, 0x0d, 0xf2, 0x5d, 0x4c, 0xf1, 0x45,
	0x38, 0x74, 0x1d, 0x8b, 0x43, 0x35, 0xc8, 0xfa, 0x4c, 0x8a, 0x35, 0xf6, 0x72, 0x90, 0xf1, 0xd9,
	0xac, 0x00, 0xb0, 0xdc, 0x0e, 0xa1, 0x38, 0x1a, 0x65, 0x41, 0x82, 0x3b, 0x1b, 0xf0, 0x4b, 0xa3,
	0x59, 0xc5, 0x0c, 0x03, 0xd6, 0x66, 0xf1, 0x32, 0xf0, 0x47, 0x59, 0xbb, 0xe7, 0x10, 0x1a, 0x44,
	0x07, 0x83, 0xd6, 0x36, 0xb2, 0xb8, 0x47, 0x60, 0xf1, 0xf5, 0x2c, 0xfe, 0x91, 0x30, 0x3f, 0x9f,
	0x25, 0x11, 0xb2, 0x75, 0x26, 0x14, 0xfb, 0x62, 0x0e, 0xbc, 0x8f, 0xad, 0x0e, 0x13, 0x27, 0xc7,
	0x10, 0x8a, 0xad, 0x54, 0x42, 0xaf, 0x8c, 0x21, 0xa4, 0x22, 0xc7, 0xf4, 0x3a, 0x14, 0xb5, 0x5c,
	0x6c, 0x12, 0x8a, 0xe8, 0x48, 0x30, 0xfa, 0x14, 0x30, 0xa4, 0xe5, 0x84, 0xf5, 0xf7, 0x35, 0x58,
	0xbe, 0x8e, 0x89, 0x15, 0x39, 0x2d, 0xbc, 0x23, 0xf4, 0x35, 0x99, 0x3a, 0x43, 0x24, 0x03, 0xfd,
	0x0c, 0x94, 0x62, 0x23, 0x2b, 0xda, 0xaa, 0x76, 0xa1, 0x64, 0xf4, 0x08, 0xfa, 0x16, 0x94, 0x62,
	0xbf, 0x2b, 0xb9, 0x55, 0xed, 0xc2, 0xf4, 0xfa, 0xc5, 0xd8, 0x02, 0x9e, 0x28, 0x64, 0xb0, 0x74,
	0x2f, 0x37, 0xee, 0x48, 0xb3, 0x6f, 0x28, 0x01, 0xa3, 0x27, 0x5b, 0xff, 0x63, 0x0e, 0xce, 0x64,
	0x9b, 0x21, 0x72, 0x91, 0x7e, 0x1a, 0x8a, 0x64, 0x0f, 0x45, 0xb6, 0xe9, 0xd8, 0xd2, 0x8c, 0x29,
	0xfe, 0xbd, 0x6d, 0xeb, 0x4f, 0xc2, 0x8c, 0x8c, 0x0d, 0x13, 0xd9, 0x76, 0xc4, 0xed, 0x28, 0x19,
	0xd3, 0x92, 0xb6, 0x61, 0xdb, 0x91, 0xbe, 0x07, 0x4f, 0x58, 0xc8, 0xda, 0xc3, 0x69, 0xc8, 0x2a,
	0x79, 0x6e, 0xf1, 0x95, 0x46, 0x56, 0x86, 0x4b, 0x60, 0x96, 0xb4, 0x3e, 0x65, 0xdc, 0x02, 0x57,
	0x9a, 0x24, 0xe9, 0x3e, 0x9c, 0xb2, 0x11, 0x45, 0x2d, 0x44, 0xfa, 0x27, 0x9b, 0x78, 0xc0, 0xc9,
	0x4e, 0x2a, 0xbd, 0x49, 0x6a, 0xfd, 0x6f, 0x1a, 0x54, 0x15, 0x70, 0xaf, 0x09, 0x8f, 0x5f, 0x0b,
	0x08, 0x55, 0xcb, 0xc7, 0xb0, 0x09, 0x08, 0xe5, 0xc0, 0x60, 0x42, 0x24, 0x74, 0xd3, 0x8c, 0xb6,
	0x21, 0x48, 0x29, 0x64, 0x19, 0x74, 0x85, 0x1e, 0xb2, 0xa9, 0xc5, 0xcf, 0xf7, 0x2f, 0xfe, 0xf7,
	0x40, 0x8f, 0x43, 0xb1, 0x17, 0x05, 0x13, 0xc7, 0x8d, 0x82, 0x85, 0x7b, 0xfd, 0xa4, 0xfa, 0xfd,
	0x5c, 0x2f, 0x28, 0x53, 0x4e, 0xc9, 0x60, 0x78, 0x0a, 0x66, 0xb9, 0x89, 0xc4, 0xf4, 0x3b, 0x5e,
	0x0b, 0x47, 0xdc, 0xad, 0x82, 0x31, 0x23, 0x88, 0xaf, 0x73, 0x9a, 0xbe, 0x0c, 0x25, 0xe5, 0x17,
	0xa9, 0xe4, 0x56, 0xf3, 0x17, 0x0a, 0x46, 0x51, 0x3a, 0x46, 0xf4, 0xb7, 0x61, 0x2e, 0x76, 0xc4,
	0xe4, 0xab, 0x28, 0x83, 0xe1, 0x1b, 0x99, 0xeb, 0xd3, 0x3b, 0x3f, 0xba, 0x97, 0x1b, 0xaf, 0xab,
	0x8f, 0x4d, 0x26, 0xb7, 0xed, 0xef, 0x06, 0x46, 0xd9, 0x4f, 0xd1, 0xf4, 0x17, 0x60, 0x49, 0xcc,
	0x6d, 0x05, 0x3e, 0x8d, 0x02, 0xd7, 0xc5, 0x11, 0x8f, 0x82, 0x0e, 0xe1, 0xf8, 0x94, 0x8c, 0x45,
	0x3e, 0xbc, 0x19, 0x8f, 0x36, 0xf9, 0xa0, 0x5e, 0x81, 0x29, 0xb5, 0x52, 0x05, 0x11, 0xe4, 0xf2,
	0xb3, 0xde, 0x80, 0x85, 0x4d, 0x37, 0x20, 0xb8, 0xc9, 0xe4, 0xd4, 0xea, 0xf6, 0x6f, 0x8a, 0xde,
	0xd2, 0xd5, 0x4f, 0x82, 0x9e, 0xe4, 0x17, 0xc0, 0xd5, 0x9f, 0x85, 0xb9, 0x2d, 0x4c, 0xc7, 0xd5,
	0xf1, 0x0e, 0xcc, 0xf7, 0xb8, 0x25, 0xf4, 0x37, 0x01, 0x24, 0xbb, 0xbf, 0x1b, 0x70, 0x81, 0xe9,
	0xf5, 0xe7, 0xc6, 0x89, 0x69, 0xae, 0x86, 0x83, 0x25, 0x96, 0x85, 0xfd, 0xac, 0xff, 0x49, 0x83,
	0xca, 0x4d, 0x87, 0xd0, 0x5b, 0x11, 0xf2, 0xc9, 0x2e, 0x8e, 0x6e, 0xb1, 0xcc, 0x74, 0xb4, 0x65,
	0x7a, 0x0d, 0xa6, 0x3d, 0xc7, 0x37, 0xf9, 0x79, 0x2d, 0xc3, 0x36, 0x6f, 0x94, 0x3c, 0xc7, 0x67,
	0x0a, 0xe4, 0x38, 0xda, 0x8f, 0xc7, 0x27, 0xe4, 0x38, 0xda, 0x97, 0xe3, 0x2b, 0x00, 0x2d, 0x44,
	0xad, 0x3d, 0x93, 0x38, 0xef, 0x61, 0x0e, 0x75, 0xc1, 0x28, 0x71, 0x4a, 0xd3, 0x79, 0x0f, 0xeb,
	0xe7, 0x61, 0xce, 0xc7, 0xfb, 0xd4, 0x0c, 0x51, 0x1b, 0x9b, 0x34, 0xb8, 0x8b, 0xfd, 0xca, 0xe4,
	0xaa, 0x76, 0x61, 0xc6, 0x98, 0x65, 0xe4, 0x37, 0x50, 0x1b, 0xdf, 0x62, 0x44, 0x96, 0x3c, 0x4f,
	0x67, 0x98, 0x2f, 0xa1, 0x7a, 0x05, 0x0a, 0x3c, 0xd3, 0x56, 0xb4, 0xd5, 0x7c, 0x7a, 0x4b, 0x0c,
	0x2f, 0xa4, 0x1a, 0x4c, 0x85, 0x21, 0xe4, 0xb2, 0xcc, 0xc8, 0x65, 0x99, 0xf1, 0x57, 0x0d, 0xaa,
	0xcc, 0x8c, 0xdb, 0x0e, 0x71, 0x5a, 0x8e, 0xeb, 0xd0, 0x83, 0x71, 0x71, 0x5c, 0x01, 0x88, 0x30,
	0xb2, 0x4d, 0x17, 0x77, 0xb1, 0xab, 0x60, 0x64, 0x94, 0x9b, 0x8c, 0xa0, 0x9f, 0x83, 0x32, 0x83,
	0x31, 0xc1, 0x22, 0x90, 0x9c, 0xf1, 0xd0, 0xbe, 0x11, 0x73, 0x3d, 0x24, 0x30, 0x7f, 0xa1, 0xc1,
	0x72, 0xa6, 0x17, 0x8f, 0x1b, 0xce, 0xff, 0x6a, 0xb0, 0xc8, 0x57, 0xd5, 0xf1, 0xc6, 0x8f, 0xc8,
	0xab, 0x50, 0xe4, 0x11, 0xe9, 0x78, 0x58, 0x1e, 0x84, 0xd5, 0x86, 0x28, 0x79, 0x1b, 0xaa, 0xe4,
	0x6d, 0xdc, 0x52, 0x35, 0xf1, 0xb5, 0x89, 0xfb, 0x9f, 0x9e, 0xd5, 0x8c, 0x29, 0x16, 0xb0, 0x8e,
	0x87, 0xb9, 0x30, 0x0b, 0x57, 0x26, 0x9c, 0x1f, 0x5b, 0x18, 0xed, 0x73, 0xe1, 0x34, 0xfc, 0x13,
	0x63, 0xc0, 0x5f, 0xc8, 0xf2, 0xfa, 0x27, 0x1a, 0x9c, 0xea, 0xf7, 0xfa, 0x71, 0x23, 0xff, 0x67,
	0x19, 0x02, 0x46, 0xaf, 0x18, 0x7b, 0x44, 0x19, 0x21, 0x3f, 0x3a, 0x23, 0x7c, 0x69, 0x14, 0x7f,
	0xa9, 0xc1, 0x99, 0x6c, 0x0f, 0x1e, 0x37, 0x96, 0x1f, 0xe4, 0x60, 0x82, 0xc9, 0xb1, 0x12, 0xa0,
	0x77, 0xd4, 0xc5, 0xd5, 0xd3, 0x74, 0x4c, 0xdb, 0xb6, 0xf5, 0xb3, 0x30, 0x1d, 0x9f, 0xe4, 0x12,
	0xbc, 0x92, 0x01, 0x8a, 0xb4, 0x6d, 0xeb, 0x8b, 0x30, 0x19, 0x75, 0x7c, 0x05, 0x5c, 0xc9, 0x28,
	0x44, 0x1d, 0x7f, 0xdb, 0xd6, 0x97, 0x60, 0x2a, 0x9d, 0x62, 0x27, 0xa9, 0x40, 0x73, 0x13, 0x4a,
	0x7c, 0x80, 0x1e, 0x84, 0x22, 0x23, 0x94, 0xd7, 0xcf, 0x67, 0x7a, 0xca, 0xab, 0x7f, 0xe5, 0xe2,
	0xad, 0x83, 0x10, 0x1b, 0x45, 0x2a, 0x7f, 0xe9, 0x2f, 0x43, 0x69, 0xd7, 0x89, 0xb0, 0xd8, 0x16,
	0x93, 0x63, 0x6e, 0x8b, 0x22, 0x13, 0xe1, 0xfb, 0xa2, 0x02, 0x53, 0xf2, 0x2a, 0x56, 0x99, 0xe2,
	0xc6, 0xa9, 0xcf, 0xfa, 0xdf, 0x35, 0x58, 0x30, 0xb0, 0x17, 0x74, 0x31, 0x07, 0xf6, 0xe8, 0xe0,
	0x7a, 0x15, 0x8a, 0x16, 0xa2, 0xb8, 0x1d, 0x44, 0x07, 0x1c, 0x9c, 0xf2, 0xfa, 0xa5, 0xa3, 0xbd,
	0xd9, 0x94, 0x12, 0x46, 0x2c, 0x9b, 0xc4, 0x2b, 0x9f, 0xc2, 0x6b, 0x1b, 0xe6, 0xba, 0x71, 0xda,
	0x13, 0x0e, 0x4f, 0x8c, 0xe9, 0x70, 0xb9, 0x27, 0xc8, 0x86, 0xd8, 0xc1, 0x9f, 0xf4, 0x4d, 0x1e,
	0xfc, 0xbf, 0xca, 0xc3, 0x33, 0x5b, 0x98, 0x0e, 0x56, 0x5f, 0xe8, 0x9e, 0x2c, 0xb0, 0x6e, 0xaf,
	0x3f, 0xde, 0x92, 0x9f, 0x1d, 0x2e, 0x84, 0xa2, 0x88, 0x9a, 0xb8, 0x8b, 0x7d, 0xda, 0xc3, 0x64,
	0x86, 0x53, 0x6f, 0x30, 0xe2, 0xb6, 0xad, 0x37, 0xe0, 0x89, 0x24, 0x97, 0x5a, 0x51, 0x11, 0x6e,
	0x0b, 0x3d, 0xd6, 0xdb, 0x62, 0x40, 0x5f, 0x85, 0x19, 0xec, 0xdb, 0x3d, 0x9d, 0x05, 0xce, 0x08,
	0xd8, 0xb7, 0x95, 0xc6, 0x4b, 0xb0, 0xd0, 0xe3, 0x50, 0xfa, 0x26, 0x39, 0xdb, 0x9c, 0x62, 0x53,
	0xda, 0x2e, 0xc1, 0x82, 0x87, 0xf6, 0x1d, 0xaf, 0xe3, 0x89, 0xfd, 0xc6, 0x93, 0xc3, 0x14, 0x0f,
	0x8e, 0x39, 0x39, 0xc0, 0x76, 0xdc, 0xb0, 0x14, 0x51, 0xcc, 0xda, 0x98, 0xff, 0xd3, 0xe0, 0xc2,
	0xd1, 0x4b, 0x21, 0xd3, 0x45, 0x86, 0x52, 0x2d, 0x43, 0x29, 0x0b, 0x20, 0x75, 0x07, 0xe2, 0x49,
	0x0b, 0x8b, 0x92, 0x77, 0x7a, 0x7d, 0x75, 0xd8, 0xda, 0x5c, 0x47, 0x14, 0x5d, 0x73, 0x83, 0x96,
	0x51, 0x96, 0x82, 0xd7, 0x84, 0x9c, 0x7e, 0x07, 0xe6, 0x24, 0x2a, 0xa6, 0x1c, 0x91, 0x67, 0x52,
	0x23, 0x33, 0xe6, 0x25, 0x0f, 0x53, 0x29, 0x51, 0x93, 0x5e, 0x18, 0xe5, 0x6e, 0xea, 0xbb, 0x7e,
	0x5f, 0x83, 0x95, 0x2d, 0x9c, 0x4c, 0x8d, 0x3b, 0xe2, 0x96, 0x1d, 0xe7, 0xf7, 0x9b, 0x30, 0xc9,
	0x7d, 0x54, 0xd9, 0x31, 0xbb, 0x18, 0x4f, 0x5c, 0xd5, 0xd9, 0xac, 0xc9, 0x54, 0xcb, 0x84, 0x0d,
	0xa9, 0x83, 0x25, 0x3e, 0xd9, 0x7f, 0x30, 0x59, 0xf8, 0xaa, 0x7b, 0xa1, 0xa4, 0xb1, 0x2a, 0xbe,
	0xfe, 0x61, 0x0e, 0x6a, 0xc3, 0x4c, 0x92, 0x2b, 0xf0, 0x03, 0x28, 0x8b, 0xb4, 0x20, 0x5b, 0x02,
	0xca, 0xb6, 0xdb, 0x63, 0x65, 0xee, 0xd1, 0xca, 0x45, 0x51, 0xac, 0xa8, 0x37, 0x7c, 0x1a, 0x1d,
	0x18, 0xe2, 0x66, 0xa3, 0x68, 0xd5, 0x03, 0xd0, 0x07, 0x99, 0xf4, 0x79, 0xc8, 0xdf, 0xc5, 0x07,
	0x32, 0x4d, 0xb1, 0x9f, 0xfa, 0x0e, 0x14, 0xba, 0xc8, 0xed, 0xa8, 0xe2, 0xe3, 0xc5, 0x63, 0x22,
	0x17, 0x5b, 0x26, 0xb4, 0xbc, 0x94, 0xbb, 0xa2, 0xd5, 0xff, 0xa2, 0xc1, 0xf9, 0x2d, 0x4c, 0xe3,
	0xeb, 0xce, 0x88, 0x85, 0xfb, 0x16, 0x9c, 0x76, 0x11, 0x6f, 0x1d, 0xd2, 0xc8, 0xc1, 0x5d, 0x1c,
	0xa3, 0xa5, 0x92, 0x69, 0xde, 0x38, 0xc5, 0x18, 0x0c, 0x35, 0x2e, 0x15, 0x6c, 0xdb, 0xb1, 0x68,
	0x18, 0x05, 0x16, 0x26, 0x24, 0x2d, 0x9a, 0xeb, 0x89, 0xbe, 0xa1, 0xc6, 0x7b, 0xa2, 0xfd, 0x0b,
	0x9c, 0x1f, 0x5c, 0xe0, 0x1f, 0xf2, 0xb4, 0x37, 0xda, 0x05, 0xb9, 0xd0, 0x4d, 0x28, 0x26, 0x96,
	0xf8, 0x81, 0x40, 0x8c, 0x15, 0xd5, 0xdf, 0x83, 0xd5, 0x2d, 0x4c, 0xaf, 0xdf, 0x7c, 0x73, 0x04,
	0x78, 0xb7, 0x01, 0xc4, 0xa9, 0xe0, 0xef, 0x06, 0x2a, 0xba, 0x8e, 0x3b, 0x35, 0xaf, 0x62, 0xf8,
	0xe5, 0x8a, 0xca, 0x5f, 0xa4, 0xfe, 0x73, 0x0d, 0x9e, 0x1c, 0x31, 0xb9, 0x74, 0xfb, 0x1d, 0x58,
	0x48, 0xa8, 0x35, 0x93, 0xc5, 0xc9, 0xf3, 0x5f, 0xc2, 0x08, 0x63, 0x3e, 0xea, 0x2b, 0x7d, 0xea,
	0x1f, 0x69, 0x70, 0xd2, 0xc0, 0x28, 0x0c, 0xdd, 0x03, 0x9e, 0x5c, 0xc9, 0x78, 0x07, 0x4d, 0x76,
	0x7b, 0x21, 0xf7, 0xe0, 0xed, 0x05, 0xfd, 0x0a, 0x4c, 0xf2, 0xec, 0x4f, 0x64, 0x62, 0x3b, 0x3a,
	0x47, 0x4a, 0xfe, 0xfa, 0x12, 0x2c, 0xf6, 0x79, 0x22, 0xcf, 0xd7, 0x7f, 0xe6, 0xa0, 0xba, 0x61,
	0xdb, 0x4d, 0x8c, 0x22, 0x6b, 0x6f, 0x83, 0xd2, 0xc8, 0x69, 0x75, 0x68, 0x6f, 0x89, 0x7f, 0xaa,
	0xc1, 0x02, 0xe1, 0x63, 0x26, 0x8a, 0x07, 0x25, 0xca, 0x6f, 0x8d, 0x95, 0x48, 0x86, 0x2b, 0x6f,
	0xf4, 0xd3, 0x45, 0x1e, 0x99, 0x27, 0x7d, 0x64, 0x56, 0xe2, 0x3a, 0xbe, 0x8d, 0xf7, 0x93, 0xd9,
	0xb0, 0xc4, 0x29, 0x6c, 0x7f, 0xe8, 0xcf, 0x82, 0x4e, 0xee, 0x3a, 0xa1, 0x49, 0xac, 0x3d, 0xec,
	0x21, 0xb3, 0x13, 0xda, 0xaa, 0x45, 0x56, 0x34, 0xe6, 0xd9, 0x48, 0x93, 0x0f, 0xbc, 0xc5, 0xe9,
	0x55, 0x17, 0x16, 0x33, 0xe7, 0x4d, 0xa6, 0xa6, 0x92, 0x48, 0x4d, 0x2f, 0x27, 0x53, 0x53, 0x79,
	0xfd, 0x99, 0x34, 0xda, 0x71, 0xcd, 0xb4, 0xcd, 0x2c, 0xc1, 0xf6, 0x6d, 0xc6, 0xca, 0x2b, 0xc1,
	0x44, 0x2a, 0x5a, 0x81, 0xe5, 0x4c, 0x00, 0x24, 0xfa, 0x77, 0x61, 0x45, 0xd4, 0x3c, 0xc3, 0xf0,
	0xff, 0xda, 0x30, 0xf8, 0x4b, 0xc7, 0xc6, 0xa9, 0xbe, 0x0a, 0xb5, 0x61, 0x93, 0x49, 0x73, 0xae,
	0x42, 0x75, 0x0b, 0xd3, 0x61, 0xb6, 0xa4, 0xd5, 0x6b, 0xfd, 0xea, 0x3f, 0x9c, 0x84, 0xe5, 0x4c,
	0x69, 0xb9, 0x5f, 0x7f, 0xa6, 0xc1, 0x82, 0xd5, 0x21, 0x34, 0xf0, 0x06, 0x43, 0x69, 0xec, 0x33,
	0x69, 0x98, 0xf6, 0xc6, 0x26, 0xd7, 0x3c, 0x10, 0x4b, 0x56, 0x1f, 0x99, 0x5b, 0x41, 0x0e, 0x08,
	0xc5, 0x29, 0x2b, 0x72, 0x0f, 0xc9, 0x8a, 0x26, 0xd7, 0x3c, 0x18, 0xd1, 0x7d, 0x64, 0xbd, 0x0d,
	0x53, 0x1e, 0x0a, 0x43, 0xc7, 0x6f, 0x57, 0xf2, 0x7c, 0xea, 0x9d, 0x07, 0x9e, 0x7a, 0x47, 0xe8,
	0x13, 0x33, 0x2a, 0xed, 0xba, 0x0f, 0xcb, 0xc8, 0xb6, 0xcd, 0xc1, 0x7c, 0x24, 0xda, 0x60, 0xa2,
	0x56, 0x5f, 0x4b, 0x07, 0xb6, 0x62, 0xce, 0x4c, 0x4b, 0x3c, 0x57, 0x57, 0x90, 0x6d, 0x67, 0x8e,
	0xb0, 0xdd, 0x95, 0xb9, 0x12, 0x8f, 0x64, 0x77, 0xf1, 0xbd, 0x9c, 0x85, 0xf8, 0xa3, 0x99, 0xed,
	0x25, 0x98, 0x49, 0x82, 0x9c, 0x31, 0xc9, 0xc9, 0xe4, 0x24, 0xa5, 0x64, 0x1e, 0xb8, 0x0a, 0xa7,
	0x54, 0x5f, 0x78, 0x53, 0x9c, 0xf2, 0x89, 0x46, 0x77, 0xaa, 0x16, 0xd0, 0x06, 0x6b, 0x81, 0xdf,
	0x4d, 0xc2, 0xd2, 0x80, 0xb4, 0xdc, 0x55, 0x3f, 0x82, 0x05, 0xd2, 0x09, 0xc3, 0x20, 0xa2, 0xd8,
	0x36, 0x2d, 0xd7, 0xe1, 0xa7, 0x83, 0xd8, 0x54, 0xc6, 0x58, 0x31, 0x35, 0x44, 0x71, 0xa3, 0xa9,
	0xb4, 0x6e, 0x0a, 0xa5, 0x2a, 0x94, 0xfb, 0xc8, 0xfa, 0xd3, 0x50, 0x16, 0xda, 0xe3, 0x2b, 0x89,
	0x70, 0x7e, 0x56, 0x50, 0xd5, 0x85, 0xe4, 0x0e, 0xcc, 0x79, 0xd8, 0x6b, 0xe1, 0x88, 0xec, 0x39,
	0xa1, 0x08, 0xbe, 0x51, 0xc5, 0xb9, 0x7a, 0x7f, 0xeb, 0x5e, 0x6e, 0xec, 0xc4, 0x62, 0xa2, 0x63,
	0xed, 0xa5, 0xbe, 0x59, 0x56, 0x52, 0xf8, 0xc9, 0xdb, 0x7c, 0xc9, 0x28, 0x49, 0x4a, 0x46, 0xa9,
	0x55, 0x18, 0x80, 0x97, 0xdd, 0xd4, 0xd4, 0x15, 0x44, 0xf5, 0xbe, 0x3b, 0x3e, 0xe5, 0x37, 0xab,
	0x82, 0xb1, 0x20, 0x87, 0x9a, 0xa2, 0xed, 0xdd, 0xf1, 0x79, 0x4e, 0x4e, 0xb4, 0x88, 0x4d, 0x36,
	0x2c, 0xee, 0x56, 0x25, 0x63, 0x3e, 0x31, 0xd0, 0x64, 0x74, 0xfd, 0x22, 0xcc, 0x27, 0x2e, 0xc8,
	0x82, 0xb7, 0xc8, 0x79, 0x13, 0x17, 0x67, 0xc1, 0xba, 0x05, 0x33, 0xea, 0xfe, 0xc2, 0xf1, 0x29,
	0x71, 0x7c, 0xce, 0xa5, 0x23, 0x55, 0x72, 0x24, 0x6e, 0x2d, 0x1c, 0x95, 0xe9, 0x6e, 0xef, 0x43,
	0xff, 0x36, 0x54, 0x77, 0x91, 0xe3, 0x06, 0x89, 0x45, 0x31, 0x1d, 0xdf, 0x8a, 0xb0, 0x87, 0x7d,
	0x5a, 0x01, 0x5e, 0x9a, 0x56, 0x14, 0x47, 0xac, 0x45, 0x8e, 0xeb, 0x57, 0xa0, 0xe2, 0xf8, 0x0e,
	0x75, 0x90, 0x6b, 0xf6, 0x6b, 0xa9, 0x4c, 0x8b, 0xb2, 0x56, 0x8e, 0xbf, 0x9a, 0x56, 0xa1, 0xbf,
	0x0c, 0xcb, 0x0e, 0x31, 0xdb, 0x6e, 0xd0, 0x42, 0xae, 0xd9, 0x6b, 0xdd, 0x60, 0x1f, 0xb5, 0x5c,
	0x6c, 0x57, 0x66, 0xf8, 0x89, 0x5c, 0x71, 0xc8, 0x16, 0xe7, 0x88, 0x6b, 0xdb, 0x1b, 0x62, 0xbc,
	0xba, 0x09, 0x8b, 0x99, 0x41, 0x77, 0xac, 0x8d, 0xf6, 0x1b, 0x0d, 0xce, 0x6e, 0xd8, 0xf6, 0x77,
	0x23, 0x71, 0xdc, 0xb3, 0x03, 0x8f, 0xf6, 0x6f, 0xb9, 0x8b, 0x30, 0xbf, 0x1b, 0x05, 0x3e, 0x65,
	0xb7, 0xe9, 0xf4, 0xfb, 0xd2, 0x9c, 0xa2, 0xab, 0x37, 0xa6, 0x2d, 0x58, 0x15, 0xe6, 0x9b, 0x11,
	0xd7, 0x64, 0xaa, 0x60, 0xb2, 0x02, 0xdf, 0xc7, 0x56, 0x5c, 0xd9, 0x15, 0x8d, 0x15, 0xc1, 0x97,
	0x9a, 0x70, 0x33, 0x66, 0xaa, 0xd7, 0x61, 0x75, 0xb8, 0x59, 0xf2, 0xf8, 0x7d, 0x05, 0xaa, 0xe2,
	0x80, 0xce, 0xb4, 0x7a, 0x8c, 0x44, 0xb1, 0x02, 0xcb, 0x99, 0x0a, 0xa4, 0xfe, 0x5f, 0xe7, 0x45,
	0xd7, 0x5f, 0xd2, 0xe5, 0xc6, 0x52, 0xfa, 0x9b, 0xb0, 0xc8, 0xef, 0x33, 0x7b, 0x18, 0x45, 0xb4,
	0x85, 0x11, 0x35, 0xef, 0x39, 0x74, 0xcf, 0xf1, 0xe5, 0x9d, 0xe2, 0xf4, 0x40, 0x43, 0xe7, 0xba,
	0xfc, 0x23, 0xc4, 0xb5, 0x89, 0x0f, 0x3e, 0x3d, 0xab, 0x19, 0x4f, 0x30, 0xe9, 0xd7, 0x94, 0xf0,
	0x1d, 0x2e, 0xab, 0x9f, 0x85, 0xe9, 0x28, 0xb4, 0x62, 0x94, 0x65, 0x83, 0x2e, 0x0a, 0x2d, 0x05,
	0xf0, 0x12, 0x4c, 0xf1, 0x77, 0xbe, 0xb8, 0x43, 0x37, 0xc9, 0x3e, 0x79, 0x27, 0x6e, 0x22, 0x0a,
	0x5c, 0xd1, 0x4e, 0x2a, 0x27, 0x8f, 0xa8, 0xac, 0xb6, 0x55, 0xca, 0x23, 0x23, 0x70, 0xb1, 0xc1,
	0x85, 0xf5, 0xb7, 0xa1, 0x4a, 0x30, 0xe1, 0x1b, 0x80, 0x77, 0x5c, 0xb0, 0x6d, 0xa2, 0x5d, 0x86,
	0x20, 0xef, 0x54, 0x15, 0xc6, 0xec, 0x54, 0x2d, 0x49, 0x1d, 0x4d, 0xa1, 0x62, 0x83, 0x69, 0xe0,
	0x9d, 0xba, 0x65, 0x28, 0xf5, 0xba, 0x2b, 0x22, 0x5f, 0x14, 0xc3, 0x11, 0x6d, 0x95, 0xa9, 0xac,
	0xb6, 0xca, 0x87, 0xf2, 0x11, 0xa4, 0x7f, 0x55, 0x64, 0x82, 0xbf, 0x05, 0x65, 0x64, 0x51, 0xa7,
	0x8b, 0x4d, 0x99, 0xf8, 0x64, 0x76, 0x7f, 0xee, 0xa8, 0xbc, 0x99, 0xc6, 0x64, 0x56, 0x28, 0x91,
	0xda, 0xc7, 0x6e, 0xc6, 0xfe, 0x3e, 0x07, 0x8b, 0xe2, 0x2a, 0xd6, 0x7f, 0xf9, 0xbb, 0x01, 0x13,
	0xbc, 0x49, 0xaa, 0xf1, 0xf5, 0xb9, 0x3c, 0x7a, 0x7d, 0xae, 0xf3, 0x37, 0x17, 0x4a, 0x71, 0xf4,
	0x66, 0x07, 0xcb, 0x93, 0x95, 0x8b, 0x8f, 0x7a, 0xc4, 0x65, 0x27, 0x4b, 0xd0, 0x89, 0xac, 0x78,
	0xd3, 0xc9, 0x08, 0x99, 0x15, 0x54, 0xe9, 0x9f, 0xfe, 0x22, 0xcb, 0x57, 0x8c, 0x83, 0x61, 0xc4,
	0xb6, 0x74, 0xe2, 0x1a, 0x2e, 0xba, 0x6d, 0x8b, 0xf1, 0xf8, 0x0d, 0x3f, 0x71, 0x0b, 0xcf, 0xec,
	0x91, 0x15, 0xc6, 0xee, 0x91, 0x65, 0xbe, 0x05, 0xfd, 0x47, 0x83, 0x53, 0xfd, 0x78, 0xc9, 0x85,
	0x7c, 0x48, 0x80, 0x65, 0x5e, 0x7b, 0x73, 0x0f, 0xf1, 0xda, 0x9b, 0xe5, 0x6b, 0x3e, 0xcb, 0xd7,
	0x7f, 0x68, 0xb0, 0xf4, 0x46, 0x27, 0x6a, 0xe3, 0xaf, 0x62, 0x74, 0xd4, 0xab, 0x50, 0x19, 0x74,
	0x4e, 0x26, 0xd2, 0x3f, 0xe4, 0x60, 0x69, 0x07, 0x7f, 0x45, 0x3d, 0x7f, 0x24, 0xfb, 0xe2, 0x1a,
	0x54, 0x06, 0x01, 0x3b, 0x5e, 0xab, 0x98, 0xff, 0xe3, 0xc7, 0xc0, 0xbb, 0x11, 0x26, 0x7b, 0xea,
	0xf2, 0x91, 0x7a, 0x64, 0x7b, 0x4c, 0xff, 0xf8, 0xa9, 0xc1, 0x99, 0x6c, 0x2b, 0x7a, 0xc1, 0xb1,
	0x62, 0x60, 0x82, 0x7d, 0x7b, 0xd8, 0x6b, 0xe0, 0x23, 0x7c, 0xd8, 0x7a, 0x1a, 0xca, 0xe9, 0x42,
	0x45, 0x56, 0xc4, 0xb3, 0x51, 0xb2, 0x22, 0xc8, 0x78, 0xc2, 0x28, 0x64, 0x3c, 0x61, 0x3c, 0x05,
	0xb3, 0x82, 0x2b, 0xfd, 0xd8, 0x20, 0x98, 0x86, 0xbd, 0x5b, 0x4c, 0x0d, 0xbc, 0x5b, 0x9c, 0x85,
	0x69, 0xc6, 0xa1, 0x94, 0x14, 0x63, 0x06, 0xa9, 0x42, 0x34, 0x26, 0xb2, 0x01, 0x93, 0x98, 0xbe,
	0x9f, 0x83, 0xca, 0x16, 0xa6, 0x8c, 0x28, 0x36, 0xca, 0xf8, 0xeb, 0xbe, 0x22, 0x9b, 0x94, 0xfc,
	0xdf, 0x91, 0xaa, 0x29, 0x42, 0x95, 0x22, 0xfd, 0x26, 0xcc, 0xf5, 0x86, 0xc5, 0xb3, 0x5f, 0x9e,
	0xef, 0xdc, 0x73, 0x43, 0x6e, 0x88, 0x3d, 0x1b, 0xd8, 0x66, 0x9d, 0xa5, 0xc9, 0xcf, 0xfe, 0xc7,
	0xdc, 0x89, 0x23, 0x1e, 0x73, 0x0b, 0xa3, 0x1f, 0x73, 0x27, 0xfb, 0x1e, 0x73, 0xeb, 0x7b, 0x70,
	0x3a, 0x03, 0x05, 0xb9, 0x8d, 0xbe, 0x93, 0x7e, 0xa0, 0xfd, 0xe6, 0x38, 0xff, 0x6d, 0xd9, 0x70,
	0xdd, 0xc0, 0x42, 0x14, 0xdb, 0x71, 0x1b, 0x56, 0xe8, 0xb8, 0xe6, 0x7e, 0xfc, 0x59, 0xed, 0xc4,
	0x27, 0x9f, 0xd5, 0x4e, 0x7c, 0xf1, 0x59, 0x4d, 0xfb, 0xf1, 0x61, 0x4d, 0xfb, 0xed, 0x61, 0x4d,
	0xfb, 0xe8, 0xb0, 0xa6, 0x7d, 0x7c, 0x58, 0xd3, 0xfe, 0x75, 0x58, 0xd3, 0xfe, 0x7d, 0x58, 0x3b,
	0xf1, 0xc5, 0x61, 0x4d, 0xbb, 0xff, 0x79, 0xed, 0xc4, 0xc7, 0x9f, 0xd7, 0x4e, 0x7c, 0xf2, 0x79,
	0xed, 0xc4, 0xf7, 0x5f, 0x68, 0x07, 0xbd, 0x59, 0x9d, 0x60, 0xc4, 0x7f, 0x76, 0xaf, 0x26, 0xbf,
	0x5b, 0x93, 0xbc, 0xf4, 0x7a, 0xfe, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0xe5, 0xc7, 0xf6, 0x99,
	0xee, 0x2b, 0x00, 0x00,
}

func (this *DescribeMutableStateRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeMutableStateRequest)
	if !ok {
		that2, ok := that.(DescribeMutableStateRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *DescribeMutableStateResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeMutableStateResponse)
	if !ok {
		that2, ok := that.(DescribeMutableStateResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.HistoryAddr != that1.HistoryAddr {
		return false
	}
	if !this.CacheMutableState.Equal(that1.CacheMutableState) {
		return false
	}
	if !this.DatabaseMutableState.Equal(that1.DatabaseMutableState) {
		return false
	}
	return true
}
func (this *DescribeHistoryHostRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostRequest)
	if !ok {
		that2, ok := that.(DescribeHistoryHostRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HostAddress != that1.HostAddress {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	return true
}
func (this *DescribeHistoryHostResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostResponse)
	if !ok {
		that2, ok := that.(DescribeHistoryHostResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardsNumber != that1.ShardsNumber {
		return false
	}
	if len(this.ShardIds) != len(that1.ShardIds) {
		return false
	}
	for i := range this.ShardIds {
		if this.ShardIds[i] != that1.ShardIds[i] {
			return false
		}
	}
	if !this.NamespaceCache.Equal(that1.NamespaceCache) {
		return false
	}
	if this.ShardControllerStatus != that1.ShardControllerStatus {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	return true
}
func (this *CloseShardRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardRequest)
	if !ok {
		that2, ok := that.(CloseShardRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	return true
}
func (this *CloseShardResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardResponse)
	if !ok {
		that2, ok := that.(CloseShardResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetShardRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetShardRequest)
	if !ok {
		that2, ok := that.(GetShardRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	return true
}
func (this *GetShardResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetShardResponse)
	if !ok {
		that2, ok := that.(GetShardResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ShardInfo.Equal(that1.ShardInfo) {
		return false
	}
	return true
}
func (this *ListTransferTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListTransferTasksRequest)
	if !ok {
		that2, ok := that.(ListTransferTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.MinTaskId != that1.MinTaskId {
		return false
	}
	if this.MaxTaskId != that1.MaxTaskId {
		return false
	}
	if this.BatchSize != that1.BatchSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListTransferTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListTransferTasksResponse)
	if !ok {
		that2, ok := that.(ListTransferTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(that1.Tasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListVisibilityTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListVisibilityTasksRequest)
	if !ok {
		that2, ok := that.(ListVisibilityTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.ReadLevel != that1.ReadLevel {
		return false
	}
	if this.MaxReadLevel != that1.MaxReadLevel {
		return false
	}
	if this.BatchSize != that1.BatchSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListVisibilityTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListVisibilityTasksResponse)
	if !ok {
		that2, ok := that.(ListVisibilityTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(that1.Tasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListTimerTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListTimerTasksRequest)
	if !ok {
		that2, ok := that.(ListTimerTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if that1.MinTime == nil {
		if this.MinTime != nil {
			return false
		}
	} else if !this.MinTime.Equal(*that1.MinTime) {
		return false
	}
	if that1.MaxTime == nil {
		if this.MaxTime != nil {
			return false
		}
	} else if !this.MaxTime.Equal(*that1.MaxTime) {
		return false
	}
	if this.BatchSize != that1.BatchSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListTimerTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListTimerTasksResponse)
	if !ok {
		that2, ok := that.(ListTimerTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(that1.Tasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListReplicationTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListReplicationTasksRequest)
	if !ok {
		that2, ok := that.(ListReplicationTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.MinTaskId != that1.MinTaskId {
		return false
	}
	if this.MaxTaskId != that1.MaxTaskId {
		return false
	}
	if this.BatchSize != that1.BatchSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListReplicationTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListReplicationTasksResponse)
	if !ok {
		that2, ok := that.(ListReplicationTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(that1.Tasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *Task) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Task)
	if !ok {
		that2, ok := that.(Task)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if that1.FireTime == nil {
		if this.FireTime != nil {
			return false
		}
	} else if !this.FireTime.Equal(*that1.FireTime) {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	return true
}
func (this *RemoveTaskRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskRequest)
	if !ok {
		that2, ok := that.(RemoveTaskRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.Category != that1.Category {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *RemoveTaskResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskResponse)
	if !ok {
		that2, ok := that.(RemoveTaskResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetWorkflowExecutionRawHistoryV2Request) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetWorkflowExecutionRawHistoryV2Request)
	if !ok {
		that2, ok := that.(GetWorkflowExecutionRawHistoryV2Request)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if this.StartEventId != that1.StartEventId {
		return false
	}
	if this.StartEventVersion != that1.StartEventVersion {
		return false
	}
	if this.EndEventId != that1.EndEventId {
		return false
	}
	if this.EndEventVersion != that1.EndEventVersion {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetWorkflowExecutionRawHistoryV2Response) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetWorkflowExecutionRawHistoryV2Response)
	if !ok {
		that2, ok := that.(GetWorkflowExecutionRawHistoryV2Response)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	if len(this.HistoryBatches) != len(that1.HistoryBatches) {
		return false
	}
	for i := range this.HistoryBatches {
		if !this.HistoryBatches[i].Equal(that1.HistoryBatches[i]) {
			return false
		}
	}
	if !this.VersionHistory.Equal(that1.VersionHistory) {
		return false
	}
	return true
}
func (this *GetReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tokens) != len(that1.Tokens) {
		return false
	}
	for i := range this.Tokens {
		if !this.Tokens[i].Equal(that1.Tokens[i]) {
			return false
		}
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GetReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ShardMessages) != len(that1.ShardMessages) {
		return false
	}
	for i := range this.ShardMessages {
		if !this.ShardMessages[i].Equal(that1.ShardMessages[i]) {
			return false
		}
	}
	return true
}
func (this *GetNamespaceReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetNamespaceReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetNamespaceReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.LastRetrievedMessageId != that1.LastRetrievedMessageId {
		return false
	}
	if this.LastProcessedMessageId != that1.LastProcessedMessageId {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GetNamespaceReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetNamespaceReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetNamespaceReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Messages.Equal(that1.Messages) {
		return false
	}
	return true
}
func (this *GetDLQReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return false
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(that1.TaskInfos[i]) {
			return false
		}
	}
	return true
}
func (this *GetDLQReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	return true
}
func (this *ReapplyEventsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsRequest)
	if !ok {
		that2, ok := that.(ReapplyEventsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if !this.Events.Equal(that1.Events) {
		return false
	}
	return true
}
func (this *ReapplyEventsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsResponse)
	if !ok {
		that2, ok := that.(ReapplyEventsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *AddSearchAttributesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSearchAttributesRequest)
	if !ok {
		that2, ok := that.(AddSearchAttributesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.SearchAttributes) != len(that1.SearchAttributes) {
		return false
	}
	for i := range this.SearchAttributes {
		if this.SearchAttributes[i] != that1.SearchAttributes[i] {
			return false
		}
	}
	if this.IndexName != that1.IndexName {
		return false
	}
	if this.SkipSchemaUpdate != that1.SkipSchemaUpdate {
		return false
	}
	return true
}
func (this *AddSearchAttributesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSearchAttributesResponse)
	if !ok {
		that2, ok := that.(AddSearchAttributesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RemoveSearchAttributesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveSearchAttributesRequest)
	if !ok {
		that2, ok := that.(RemoveSearchAttributesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.SearchAttributes) != len(that1.SearchAttributes) {
		return false
	}
	for i := range this.SearchAttributes {
		if this.SearchAttributes[i] != that1.SearchAttributes[i] {
			return false
		}
	}
	if this.IndexName != that1.IndexName {
		return false
	}
	return true
}
func (this *RemoveSearchAttributesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveSearchAttributesResponse)
	if !ok {
		that2, ok := that.(RemoveSearchAttributesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetSearchAttributesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetSearchAttributesRequest)
	if !ok {
		that2, ok := that.(GetSearchAttributesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.IndexName != that1.IndexName {
		return false
	}
	return true
}
func (this *GetSearchAttributesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetSearchAttributesResponse)
	if !ok {
		that2, ok := that.(GetSearchAttributesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.CustomAttributes) != len(that1.CustomAttributes) {
		return false
	}
	for i := range this.CustomAttributes {
		if this.CustomAttributes[i] != that1.CustomAttributes[i] {
			return false
		}
	}
	if len(this.SystemAttributes) != len(that1.SystemAttributes) {
		return false
	}
	for i := range this.SystemAttributes {
		if this.SystemAttributes[i] != that1.SystemAttributes[i] {
			return false
		}
	}
	if len(this.Mapping) != len(that1.Mapping) {
		return false
	}
	for i := range this.Mapping {
		if this.Mapping[i] != that1.Mapping[i] {
			return false
		}
	}
	if !this.AddWorkflowExecutionInfo.Equal(that1.AddWorkflowExecutionInfo) {
		return false
	}
	return true
}
func (this *DescribeClusterRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeClusterRequest)
	if !ok {
		that2, ok := that.(DescribeClusterRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *DescribeClusterResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeClusterResponse)
	if !ok {
		that2, ok := that.(DescribeClusterResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.SupportedClients) != len(that1.SupportedClients) {
		return false
	}
	for i := range this.SupportedClients {
		if this.SupportedClients[i] != that1.SupportedClients[i] {
			return false
		}
	}
	if this.ServerVersion != that1.ServerVersion {
		return false
	}
	if !this.MembershipInfo.Equal(that1.MembershipInfo) {
		return false
	}
	if this.ClusterId != that1.ClusterId {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if this.HistoryShardCount != that1.HistoryShardCount {
		return false
	}
	if this.PersistenceStore != that1.PersistenceStore {
		return false
	}
	if this.VisibilityStore != that1.VisibilityStore {
		return false
	}
	if !this.VersionInfo.Equal(that1.VersionInfo) {
		return false
	}
	if this.FailoverVersionIncrement != that1.FailoverVersionIncrement {
		return false
	}
	if this.InitialFailoverVersion != that1.InitialFailoverVersion {
		return false
	}
	if this.IsGlobalNamespaceEnabled != that1.IsGlobalNamespaceEnabled {
		return false
	}
	return true
}
func (this *AddOrUpdateRemoteClusterRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddOrUpdateRemoteClusterRequest)
	if !ok {
		that2, ok := that.(AddOrUpdateRemoteClusterRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.FrontendAddress != that1.FrontendAddress {
		return false
	}
	if this.EnableRemoteClusterConnection != that1.EnableRemoteClusterConnection {
		return false
	}
	return true
}
func (this *AddOrUpdateRemoteClusterResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddOrUpdateRemoteClusterResponse)
	if !ok {
		that2, ok := that.(AddOrUpdateRemoteClusterResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RemoveRemoteClusterRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveRemoteClusterRequest)
	if !ok {
		that2, ok := that.(RemoveRemoteClusterRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *RemoveRemoteClusterResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveRemoteClusterResponse)
	if !ok {
		that2, ok := that.(RemoveRemoteClusterResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ListClusterMembersRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListClusterMembersRequest)
	if !ok {
		that2, ok := that.(ListClusterMembersRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.LastHeartbeatWithin != nil && that1.LastHeartbeatWithin != nil {
		if *this.LastHeartbeatWithin != *that1.LastHeartbeatWithin {
			return false
		}
	} else if this.LastHeartbeatWithin != nil {
		return false
	} else if that1.LastHeartbeatWithin != nil {
		return false
	}
	if this.RpcAddress != that1.RpcAddress {
		return false
	}
	if this.HostId != that1.HostId {
		return false
	}
	if this.Role != that1.Role {
		return false
	}
	if that1.SessionStartedAfterTime == nil {
		if this.SessionStartedAfterTime != nil {
			return false
		}
	} else if !this.SessionStartedAfterTime.Equal(*that1.SessionStartedAfterTime) {
		return false
	}
	if this.PageSize != that1.PageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *ListClusterMembersResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListClusterMembersResponse)
	if !ok {
		that2, ok := that.(ListClusterMembersResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ActiveMembers) != len(that1.ActiveMembers) {
		return false
	}
	for i := range this.ActiveMembers {
		if !this.ActiveMembers[i].Equal(that1.ActiveMembers[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *MergeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(MergeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *MergeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(MergeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksRequest)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksResponse)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ResendReplicationTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResendReplicationTasksRequest)
	if !ok {
		that2, ok := that.(ResendReplicationTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.RemoteCluster != that1.RemoteCluster {
		return false
	}
	if this.StartEventId != that1.StartEventId {
		return false
	}
	if this.StartVersion != that1.StartVersion {
		return false
	}
	if this.EndEventId != that1.EndEventId {
		return false
	}
	if this.EndVersion != that1.EndVersion {
		return false
	}
	return true
}
func (this *ResendReplicationTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResendReplicationTasksResponse)
	if !ok {
		that2, ok := that.(ResendReplicationTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetTaskQueueTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetTaskQueueTasksRequest)
	if !ok {
		that2, ok := that.(GetTaskQueueTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.TaskQueueType != that1.TaskQueueType {
		return false
	}
	if this.MinTaskId != that1.MinTaskId {
		return false
	}
	if this.MaxTaskId != that1.MaxTaskId {
		return false
	}
	if this.BatchSize != that1.BatchSize {
		return false
	}
	return true
}
func (this *GetTaskQueueTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetTaskQueueTasksResponse)
	if !ok {
		that2, ok := that.(GetTaskQueueTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(that1.Tasks[i]) {
			return false
		}
	}
	return true
}
func (this *DescribeMutableStateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.DescribeMutableStateRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeMutableStateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.DescribeMutableStateResponse{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "HistoryAddr: "+fmt.Sprintf("%#v", this.HistoryAddr)+",\n")
	if this.CacheMutableState != nil {
		s = append(s, "CacheMutableState: "+fmt.Sprintf("%#v", this.CacheMutableState)+",\n")
	}
	if this.DatabaseMutableState != nil {
		s = append(s, "DatabaseMutableState: "+fmt.Sprintf("%#v", this.DatabaseMutableState)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.DescribeHistoryHostRequest{")
	s = append(s, "HostAddress: "+fmt.Sprintf("%#v", this.HostAddress)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&adminservice.DescribeHistoryHostResponse{")
	s = append(s, "ShardsNumber: "+fmt.Sprintf("%#v", this.ShardsNumber)+",\n")
	s = append(s, "ShardIds: "+fmt.Sprintf("%#v", this.ShardIds)+",\n")
	if this.NamespaceCache != nil {
		s = append(s, "NamespaceCache: "+fmt.Sprintf("%#v", this.NamespaceCache)+",\n")
	}
	s = append(s, "ShardControllerStatus: "+fmt.Sprintf("%#v", this.ShardControllerStatus)+",\n")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.CloseShardRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.CloseShardResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetShardRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetShardRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetShardResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetShardResponse{")
	if this.ShardInfo != nil {
		s = append(s, "ShardInfo: "+fmt.Sprintf("%#v", this.ShardInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTransferTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&adminservice.ListTransferTasksRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "MinTaskId: "+fmt.Sprintf("%#v", this.MinTaskId)+",\n")
	s = append(s, "MaxTaskId: "+fmt.Sprintf("%#v", this.MaxTaskId)+",\n")
	s = append(s, "BatchSize: "+fmt.Sprintf("%#v", this.BatchSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTransferTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.ListTransferTasksResponse{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListVisibilityTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&adminservice.ListVisibilityTasksRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "ReadLevel: "+fmt.Sprintf("%#v", this.ReadLevel)+",\n")
	s = append(s, "MaxReadLevel: "+fmt.Sprintf("%#v", this.MaxReadLevel)+",\n")
	s = append(s, "BatchSize: "+fmt.Sprintf("%#v", this.BatchSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListVisibilityTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.ListVisibilityTasksResponse{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTimerTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&adminservice.ListTimerTasksRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "MinTime: "+fmt.Sprintf("%#v", this.MinTime)+",\n")
	s = append(s, "MaxTime: "+fmt.Sprintf("%#v", this.MaxTime)+",\n")
	s = append(s, "BatchSize: "+fmt.Sprintf("%#v", this.BatchSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTimerTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.ListTimerTasksResponse{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListReplicationTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&adminservice.ListReplicationTasksRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "MinTaskId: "+fmt.Sprintf("%#v", this.MinTaskId)+",\n")
	s = append(s, "MaxTaskId: "+fmt.Sprintf("%#v", this.MaxTaskId)+",\n")
	s = append(s, "BatchSize: "+fmt.Sprintf("%#v", this.BatchSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListReplicationTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.ListReplicationTasksResponse{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&adminservice.Task{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "FireTime: "+fmt.Sprintf("%#v", this.FireTime)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.RemoveTaskRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "Category: "+fmt.Sprintf("%#v", this.Category)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RemoveTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetWorkflowExecutionRawHistoryV2Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&adminservice.GetWorkflowExecutionRawHistoryV2Request{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "StartEventId: "+fmt.Sprintf("%#v", this.StartEventId)+",\n")
	s = append(s, "StartEventVersion: "+fmt.Sprintf("%#v", this.StartEventVersion)+",\n")
	s = append(s, "EndEventId: "+fmt.Sprintf("%#v", this.EndEventId)+",\n")
	s = append(s, "EndEventVersion: "+fmt.Sprintf("%#v", this.EndEventVersion)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetWorkflowExecutionRawHistoryV2Response) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetWorkflowExecutionRawHistoryV2Response{")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	if this.HistoryBatches != nil {
		s = append(s, "HistoryBatches: "+fmt.Sprintf("%#v", this.HistoryBatches)+",\n")
	}
	if this.VersionHistory != nil {
		s = append(s, "VersionHistory: "+fmt.Sprintf("%#v", this.VersionHistory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.GetReplicationMessagesRequest{")
	if this.Tokens != nil {
		s = append(s, "Tokens: "+fmt.Sprintf("%#v", this.Tokens)+",\n")
	}
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetReplicationMessagesResponse{")
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v15.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%#v: %#v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	if this.ShardMessages != nil {
		s = append(s, "ShardMessages: "+mapStringForShardMessages+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNamespaceReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetNamespaceReplicationMessagesRequest{")
	s = append(s, "LastRetrievedMessageId: "+fmt.Sprintf("%#v", this.LastRetrievedMessageId)+",\n")
	s = append(s, "LastProcessedMessageId: "+fmt.Sprintf("%#v", this.LastProcessedMessageId)+",\n")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNamespaceReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetNamespaceReplicationMessagesResponse{")
	if this.Messages != nil {
		s = append(s, "Messages: "+fmt.Sprintf("%#v", this.Messages)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetDLQReplicationMessagesRequest{")
	if this.TaskInfos != nil {
		s = append(s, "TaskInfos: "+fmt.Sprintf("%#v", this.TaskInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetDLQReplicationMessagesResponse{")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.ReapplyEventsRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	if this.Events != nil {
		s = append(s, "Events: "+fmt.Sprintf("%#v", this.Events)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.ReapplyEventsResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddSearchAttributesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.AddSearchAttributesRequest{")
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]v16.IndexedValueType{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	if this.SearchAttributes != nil {
		s = append(s, "SearchAttributes: "+mapStringForSearchAttributes+",\n")
	}
	s = append(s, "IndexName: "+fmt.Sprintf("%#v", this.IndexName)+",\n")
	s = append(s, "SkipSchemaUpdate: "+fmt.Sprintf("%#v", this.SkipSchemaUpdate)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddSearchAttributesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.AddSearchAttributesResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveSearchAttributesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.RemoveSearchAttributesRequest{")
	s = append(s, "SearchAttributes: "+fmt.Sprintf("%#v", this.SearchAttributes)+",\n")
	s = append(s, "IndexName: "+fmt.Sprintf("%#v", this.IndexName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveSearchAttributesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RemoveSearchAttributesResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetSearchAttributesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetSearchAttributesRequest{")
	s = append(s, "IndexName: "+fmt.Sprintf("%#v", this.IndexName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetSearchAttributesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.GetSearchAttributesResponse{")
	keysForCustomAttributes := make([]string, 0, len(this.CustomAttributes))
	for k, _ := range this.CustomAttributes {
		keysForCustomAttributes = append(keysForCustomAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomAttributes)
	mapStringForCustomAttributes := "map[string]v16.IndexedValueType{"
	for _, k := range keysForCustomAttributes {
		mapStringForCustomAttributes += fmt.Sprintf("%#v: %#v,", k, this.CustomAttributes[k])
	}
	mapStringForCustomAttributes += "}"
	if this.CustomAttributes != nil {
		s = append(s, "CustomAttributes: "+mapStringForCustomAttributes+",\n")
	}
	keysForSystemAttributes := make([]string, 0, len(this.SystemAttributes))
	for k, _ := range this.SystemAttributes {
		keysForSystemAttributes = append(keysForSystemAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSystemAttributes)
	mapStringForSystemAttributes := "map[string]v16.IndexedValueType{"
	for _, k := range keysForSystemAttributes {
		mapStringForSystemAttributes += fmt.Sprintf("%#v: %#v,", k, this.SystemAttributes[k])
	}
	mapStringForSystemAttributes += "}"
	if this.SystemAttributes != nil {
		s = append(s, "SystemAttributes: "+mapStringForSystemAttributes+",\n")
	}
	keysForMapping := make([]string, 0, len(this.Mapping))
	for k, _ := range this.Mapping {
		keysForMapping = append(keysForMapping, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMapping)
	mapStringForMapping := "map[string]string{"
	for _, k := range keysForMapping {
		mapStringForMapping += fmt.Sprintf("%#v: %#v,", k, this.Mapping[k])
	}
	mapStringForMapping += "}"
	if this.Mapping != nil {
		s = append(s, "Mapping: "+mapStringForMapping+",\n")
	}
	if this.AddWorkflowExecutionInfo != nil {
		s = append(s, "AddWorkflowExecutionInfo: "+fmt.Sprintf("%#v", this.AddWorkflowExecutionInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeClusterRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.DescribeClusterRequest{")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeClusterResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&adminservice.DescribeClusterResponse{")
	keysForSupportedClients := make([]string, 0, len(this.SupportedClients))
	for k, _ := range this.SupportedClients {
		keysForSupportedClients = append(keysForSupportedClients, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSupportedClients)
	mapStringForSupportedClients := "map[string]string{"
	for _, k := range keysForSupportedClients {
		mapStringForSupportedClients += fmt.Sprintf("%#v: %#v,", k, this.SupportedClients[k])
	}
	mapStringForSupportedClients += "}"
	if this.SupportedClients != nil {
		s = append(s, "SupportedClients: "+mapStringForSupportedClients+",\n")
	}
	s = append(s, "ServerVersion: "+fmt.Sprintf("%#v", this.ServerVersion)+",\n")
	if this.MembershipInfo != nil {
		s = append(s, "MembershipInfo: "+fmt.Sprintf("%#v", this.MembershipInfo)+",\n")
	}
	s = append(s, "ClusterId: "+fmt.Sprintf("%#v", this.ClusterId)+",\n")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "HistoryShardCount: "+fmt.Sprintf("%#v", this.HistoryShardCount)+",\n")
	s = append(s, "PersistenceStore: "+fmt.Sprintf("%#v", this.PersistenceStore)+",\n")
	s = append(s, "VisibilityStore: "+fmt.Sprintf("%#v", this.VisibilityStore)+",\n")
	if this.VersionInfo != nil {
		s = append(s, "VersionInfo: "+fmt.Sprintf("%#v", this.VersionInfo)+",\n")
	}
	s = append(s, "FailoverVersionIncrement: "+fmt.Sprintf("%#v", this.FailoverVersionIncrement)+",\n")
	s = append(s, "InitialFailoverVersion: "+fmt.Sprintf("%#v", this.InitialFailoverVersion)+",\n")
	s = append(s, "IsGlobalNamespaceEnabled: "+fmt.Sprintf("%#v", this.IsGlobalNamespaceEnabled)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddOrUpdateRemoteClusterRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.AddOrUpdateRemoteClusterRequest{")
	s = append(s, "FrontendAddress: "+fmt.Sprintf("%#v", this.FrontendAddress)+",\n")
	s = append(s, "EnableRemoteClusterConnection: "+fmt.Sprintf("%#v", this.EnableRemoteClusterConnection)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddOrUpdateRemoteClusterResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.AddOrUpdateRemoteClusterResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveRemoteClusterRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.RemoveRemoteClusterRequest{")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveRemoteClusterResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RemoveRemoteClusterResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListClusterMembersRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&adminservice.ListClusterMembersRequest{")
	s = append(s, "LastHeartbeatWithin: "+fmt.Sprintf("%#v", this.LastHeartbeatWithin)+",\n")
	s = append(s, "RpcAddress: "+fmt.Sprintf("%#v", this.RpcAddress)+",\n")
	s = append(s, "HostId: "+fmt.Sprintf("%#v", this.HostId)+",\n")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "SessionStartedAfterTime: "+fmt.Sprintf("%#v", this.SessionStartedAfterTime)+",\n")
	s = append(s, "PageSize: "+fmt.Sprintf("%#v", this.PageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListClusterMembersResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.ListClusterMembersResponse{")
	if this.ActiveMembers != nil {
		s = append(s, "ActiveMembers: "+fmt.Sprintf("%#v", this.ActiveMembers)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.GetDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetDLQMessagesResponse{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.PurgeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.PurgeDLQMessagesResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.MergeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.MergeDLQMessagesResponse{")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.RefreshWorkflowTasksRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RefreshWorkflowTasksResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResendReplicationTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&adminservice.ResendReplicationTasksRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "RemoteCluster: "+fmt.Sprintf("%#v", this.RemoteCluster)+",\n")
	s = append(s, "StartEventId: "+fmt.Sprintf("%#v", this.StartEventId)+",\n")
	s = append(s, "StartVersion: "+fmt.Sprintf("%#v", this.StartVersion)+",\n")
	s = append(s, "EndEventId: "+fmt.Sprintf("%#v", this.EndEventId)+",\n")
	s = append(s, "EndVersion: "+fmt.Sprintf("%#v", this.EndVersion)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResendReplicationTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.ResendReplicationTasksResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetTaskQueueTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.GetTaskQueueTasksRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "TaskQueueType: "+fmt.Sprintf("%#v", this.TaskQueueType)+",\n")
	s = append(s, "MinTaskId: "+fmt.Sprintf("%#v", this.MinTaskId)+",\n")
	s = append(s, "MaxTaskId: "+fmt.Sprintf("%#v", this.MaxTaskId)+",\n")
	s = append(s, "BatchSize: "+fmt.Sprintf("%#v", this.BatchSize)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetTaskQueueTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetTaskQueueTasksResponse{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringRequestResponse(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *DescribeMutableStateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeMutableStateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeMutableStateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeMutableStateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeMutableStateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeMutableStateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DatabaseMutableState != nil {
		{
			size, err := m.DatabaseMutableState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.CacheMutableState != nil {
		{
			size, err := m.CacheMutableState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HistoryAddr) > 0 {
		i -= len(m.HistoryAddr)
		copy(dAtA[i:], m.HistoryAddr)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HistoryAddr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ShardId) > 0 {
		i -= len(m.ShardId)
		copy(dAtA[i:], m.ShardId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ShardId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.HostAddress) > 0 {
		i -= len(m.HostAddress)
		copy(dAtA[i:], m.HostAddress)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HostAddress)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ShardControllerStatus) > 0 {
		i -= len(m.ShardControllerStatus)
		copy(dAtA[i:], m.ShardControllerStatus)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ShardControllerStatus)))
		i--
		dAtA[i] = 0x22
	}
	if m.NamespaceCache != nil {
		{
			size, err := m.NamespaceCache.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ShardIds) > 0 {
		dAtA7 := make([]byte, len(m.ShardIds)*10)
		var j6 int
		for _, num1 := range m.ShardIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintRequestResponse(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x12
	}
	if m.ShardsNumber != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardsNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetShardRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetShardRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetShardRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetShardResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetShardResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetShardResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ShardInfo != nil {
		{
			size, err := m.ShardInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListTransferTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListTransferTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListTransferTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.BatchSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.BatchSize))
		i--
		dAtA[i] = 0x28
	}
	if m.MaxTaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaxTaskId))
		i--
		dAtA[i] = 0x20
	}
	if m.MinTaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MinTaskId))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ListTransferTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListTransferTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListTransferTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tasks) > 0 {
		for iNdEx := len(m.Tasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListVisibilityTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListVisibilityTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListVisibilityTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.BatchSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.BatchSize))
		i--
		dAtA[i] = 0x28
	}
	if m.MaxReadLevel != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaxReadLevel))
		i--
		dAtA[i] = 0x20
	}
	if m.ReadLevel != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ReadLevel))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ListVisibilityTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListVisibilityTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListVisibilityTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tasks) > 0 {
		for iNdEx := len(m.Tasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListTimerTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListTimerTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListTimerTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x2a
	}
	if m.BatchSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.BatchSize))
		i--
		dAtA[i] = 0x20
	}
	if m.MaxTime != nil {
		n9, err9 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.MaxTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.MaxTime):])
		if err9 != nil {
			return 0, err9
		}
		i -= n9
		i = encodeVarintRequestResponse(dAtA, i, uint64(n9))
		i--
		dAtA[i] = 0x1a
	}
	if m.MinTime != nil {
		n10, err10 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.MinTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.MinTime):])
		if err10 != nil {
			return 0, err10
		}
		i -= n10
		i = encodeVarintRequestResponse(dAtA, i, uint64(n10))
		i--
		dAtA[i] = 0x12
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ListTimerTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListTimerTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListTimerTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tasks) > 0 {
		for iNdEx := len(m.Tasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListReplicationTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListReplicationTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListReplicationTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x2a
	}
	if m.BatchSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.BatchSize))
		i--
		dAtA[i] = 0x20
	}
	if m.MaxTaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaxTaskId))
		i--
		dAtA[i] = 0x18
	}
	if m.MinTaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MinTaskId))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ListReplicationTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListReplicationTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListReplicationTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tasks) > 0 {
		for iNdEx := len(m.Tasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Task) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Task) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Task) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Version != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x38
	}
	if m.FireTime != nil {
		n11, err11 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.FireTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.FireTime):])
		if err11 != nil {
			return 0, err11
		}
		i -= n11
		i = encodeVarintRequestResponse(dAtA, i, uint64(n11))
		i--
		dAtA[i] = 0x32
	}
	if m.TaskType != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveTaskRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n12, err12 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err12 != nil {
			return 0, err12
		}
		i -= n12
		i = encodeVarintRequestResponse(dAtA, i, uint64(n12))
		i--
		dAtA[i] = 0x22
	}
	if m.TaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x18
	}
	if m.Category != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Category))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RemoveTaskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkflowExecutionRawHistoryV2Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x42
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x38
	}
	if m.EndEventVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.EndEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.StartEventVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.StartEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkflowExecutionRawHistoryV2Response) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionHistory != nil {
		{
			size, err := m.VersionHistory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HistoryBatches) > 0 {
		for iNdEx := len(m.HistoryBatches) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HistoryBatches[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tokens) > 0 {
		for iNdEx := len(m.Tokens) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tokens[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k := range m.ShardMessages {
			v := m.ShardMessages[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintRequestResponse(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintRequestResponse(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespaceReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespaceReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespaceReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LastProcessedMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastProcessedMessageId))
		i--
		dAtA[i] = 0x10
	}
	if m.LastRetrievedMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastRetrievedMessageId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespaceReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespaceReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespaceReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Messages != nil {
		{
			size, err := m.Messages.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for iNdEx := len(m.TaskInfos) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TaskInfos[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Events != nil {
		{
			size, err := m.Events.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *AddSearchAttributesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSearchAttributesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSearchAttributesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SkipSchemaUpdate {
		i--
		if m.SkipSchemaUpdate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.IndexName) > 0 {
		i -= len(m.IndexName)
		copy(dAtA[i:], m.IndexName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.IndexName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SearchAttributes) > 0 {
		for k := range m.SearchAttributes {
			v := m.SearchAttributes[k]
			baseI := i
			i = encodeVarintRequestResponse(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AddSearchAttributesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSearchAttributesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSearchAttributesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RemoveSearchAttributesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveSearchAttributesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveSearchAttributesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.IndexName) > 0 {
		i -= len(m.IndexName)
		copy(dAtA[i:], m.IndexName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.IndexName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SearchAttributes) > 0 {
		for iNdEx := len(m.SearchAttributes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SearchAttributes[iNdEx])
			copy(dAtA[i:], m.SearchAttributes[iNdEx])
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SearchAttributes[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *RemoveSearchAttributesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveSearchAttributesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveSearchAttributesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetSearchAttributesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetSearchAttributesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetSearchAttributesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.IndexName) > 0 {
		i -= len(m.IndexName)
		copy(dAtA[i:], m.IndexName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.IndexName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetSearchAttributesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetSearchAttributesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetSearchAttributesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AddWorkflowExecutionInfo != nil {
		{
			size, err := m.AddWorkflowExecutionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Mapping) > 0 {
		for k := range m.Mapping {
			v := m.Mapping[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.SystemAttributes) > 0 {
		for k := range m.SystemAttributes {
			v := m.SystemAttributes[k]
			baseI := i
			i = encodeVarintRequestResponse(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.CustomAttributes) > 0 {
		for k := range m.CustomAttributes {
			v := m.CustomAttributes[k]
			baseI := i
			i = encodeVarintRequestResponse(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DescribeClusterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeClusterRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeClusterRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeClusterResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsGlobalNamespaceEnabled {
		i--
		if m.IsGlobalNamespaceEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.InitialFailoverVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InitialFailoverVersion))
		i--
		dAtA[i] = 0x58
	}
	if m.FailoverVersionIncrement != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.FailoverVersionIncrement))
		i--
		dAtA[i] = 0x50
	}
	if m.VersionInfo != nil {
		{
			size, err := m.VersionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.VisibilityStore) > 0 {
		i -= len(m.VisibilityStore)
		copy(dAtA[i:], m.VisibilityStore)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.VisibilityStore)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.PersistenceStore) > 0 {
		i -= len(m.PersistenceStore)
		copy(dAtA[i:], m.PersistenceStore)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.PersistenceStore)))
		i--
		dAtA[i] = 0x3a
	}
	if m.HistoryShardCount != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.HistoryShardCount))
		i--
		dAtA[i] = 0x30
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x22
	}
	if m.MembershipInfo != nil {
		{
			size, err := m.MembershipInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ServerVersion) > 0 {
		i -= len(m.ServerVersion)
		copy(dAtA[i:], m.ServerVersion)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ServerVersion)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SupportedClients) > 0 {
		for k := range m.SupportedClients {
			v := m.SupportedClients[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AddOrUpdateRemoteClusterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddOrUpdateRemoteClusterRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddOrUpdateRemoteClusterRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EnableRemoteClusterConnection {
		i--
		if m.EnableRemoteClusterConnection {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.FrontendAddress) > 0 {
		i -= len(m.FrontendAddress)
		copy(dAtA[i:], m.FrontendAddress)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.FrontendAddress)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddOrUpdateRemoteClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddOrUpdateRemoteClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddOrUpdateRemoteClusterResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RemoveRemoteClusterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveRemoteClusterRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveRemoteClusterRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveRemoteClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveRemoteClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveRemoteClusterResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ListClusterMembersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListClusterMembersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListClusterMembersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x3a
	}
	if m.PageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.PageSize))
		i--
		dAtA[i] = 0x30
	}
	if m.SessionStartedAfterTime != nil {
		n22, err22 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.SessionStartedAfterTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.SessionStartedAfterTime):])
		if err22 != nil {
			return 0, err22
		}
		i -= n22
		i = encodeVarintRequestResponse(dAtA, i, uint64(n22))
		i--
		dAtA[i] = 0x2a
	}
	if m.Role != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Role))
		i--
		dAtA[i] = 0x20
	}
	if len(m.HostId) > 0 {
		i -= len(m.HostId)
		copy(dAtA[i:], m.HostId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HostId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RpcAddress) > 0 {
		i -= len(m.RpcAddress)
		copy(dAtA[i:], m.RpcAddress)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RpcAddress)))
		i--
		dAtA[i] = 0x12
	}
	if m.LastHeartbeatWithin != nil {
		n23, err23 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.LastHeartbeatWithin, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.LastHeartbeatWithin):])
		if err23 != nil {
			return 0, err23
		}
		i -= n23
		i = encodeVarintRequestResponse(dAtA, i, uint64(n23))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListClusterMembersResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListClusterMembersResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListClusterMembersResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ActiveMembers) > 0 {
		for iNdEx := len(m.ActiveMembers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ActiveMembers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ResendReplicationTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResendReplicationTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResendReplicationTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EndVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndVersion))
		i--
		dAtA[i] = 0x40
	}
	if m.EndEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.StartVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.StartEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.RemoteCluster) > 0 {
		i -= len(m.RemoteCluster)
		copy(dAtA[i:], m.RemoteCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RemoteCluster)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResendReplicationTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResendReplicationTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResendReplicationTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetTaskQueueTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetTaskQueueTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetTaskQueueTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.BatchSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.BatchSize))
		i--
		dAtA[i] = 0x30
	}
	if m.MaxTaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaxTaskId))
		i--
		dAtA[i] = 0x28
	}
	if m.MinTaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MinTaskId))
		i--
		dAtA[i] = 0x20
	}
	if m.TaskQueueType != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskQueueType))
		i--
		dAtA[i] = 0x18
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetTaskQueueTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetTaskQueueTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetTaskQueueTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for iNdEx := len(m.Tasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintRequestResponse(dAtA []byte, offset int, v uint64) int {
	offset -= sovRequestResponse(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DescribeMutableStateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeMutableStateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ShardId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.HistoryAddr)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CacheMutableState != nil {
		l = m.CacheMutableState.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.DatabaseMutableState != nil {
		l = m.DatabaseMutableState.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostAddress)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardsNumber != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardsNumber))
	}
	if len(m.ShardIds) > 0 {
		l = 0
		for _, e := range m.ShardIds {
			l += sovRequestResponse(uint64(e))
		}
		n += 1 + sovRequestResponse(uint64(l)) + l
	}
	if m.NamespaceCache != nil {
		l = m.NamespaceCache.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ShardControllerStatus)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *CloseShardRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	return n
}

func (m *CloseShardResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetShardRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	return n
}

func (m *GetShardResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardInfo != nil {
		l = m.ShardInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListTransferTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.MinTaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.MinTaskId))
	}
	if m.MaxTaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaxTaskId))
	}
	if m.BatchSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.BatchSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListTransferTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListVisibilityTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.ReadLevel != 0 {
		n += 1 + sovRequestResponse(uint64(m.ReadLevel))
	}
	if m.MaxReadLevel != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaxReadLevel))
	}
	if m.BatchSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.BatchSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListVisibilityTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListTimerTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.MinTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.MinTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.MaxTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.MaxTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.BatchSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.BatchSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListTimerTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListReplicationTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.MinTaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.MinTaskId))
	}
	if m.MaxTaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaxTaskId))
	}
	if m.BatchSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.BatchSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListReplicationTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *Task) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskId))
	}
	if m.TaskType != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskType))
	}
	if m.FireTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.FireTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovRequestResponse(uint64(m.Version))
	}
	return n
}

func (m *RemoveTaskRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.Category != 0 {
		n += 1 + sovRequestResponse(uint64(m.Category))
	}
	if m.TaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveTaskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventId))
	}
	if m.StartEventVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventVersion))
	}
	if m.EndEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventId))
	}
	if m.EndEventVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventVersion))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if len(m.HistoryBatches) > 0 {
		for _, e := range m.HistoryBatches {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	if m.VersionHistory != nil {
		l = m.VersionHistory.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tokens) > 0 {
		for _, e := range m.Tokens {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k, v := range m.ShardMessages {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRequestResponse(uint64(l))
			}
			mapEntrySize := 1 + sovRequestResponse(uint64(k)) + l
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *GetNamespaceReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastRetrievedMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastRetrievedMessageId))
	}
	if m.LastProcessedMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastProcessedMessageId))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetNamespaceReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Messages != nil {
		l = m.Messages.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for _, e := range m.TaskInfos {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *GetDLQReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *ReapplyEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Events != nil {
		l = m.Events.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ReapplyEventsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *AddSearchAttributesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SearchAttributes) > 0 {
		for k, v := range m.SearchAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + sovRequestResponse(uint64(v))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	l = len(m.IndexName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.SkipSchemaUpdate {
		n += 2
	}
	return n
}

func (m *AddSearchAttributesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RemoveSearchAttributesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SearchAttributes) > 0 {
		for _, s := range m.SearchAttributes {
			l = len(s)
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.IndexName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveSearchAttributesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetSearchAttributesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.IndexName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetSearchAttributesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.CustomAttributes) > 0 {
		for k, v := range m.CustomAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + sovRequestResponse(uint64(v))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	if len(m.SystemAttributes) > 0 {
		for k, v := range m.SystemAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + sovRequestResponse(uint64(v))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	if len(m.Mapping) > 0 {
		for k, v := range m.Mapping {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + len(v) + sovRequestResponse(uint64(len(v)))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	if m.AddWorkflowExecutionInfo != nil {
		l = m.AddWorkflowExecutionInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeClusterRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeClusterResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SupportedClients) > 0 {
		for k, v := range m.SupportedClients {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + len(v) + sovRequestResponse(uint64(len(v)))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	l = len(m.ServerVersion)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.MembershipInfo != nil {
		l = m.MembershipInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.HistoryShardCount != 0 {
		n += 1 + sovRequestResponse(uint64(m.HistoryShardCount))
	}
	l = len(m.PersistenceStore)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.VisibilityStore)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.VersionInfo != nil {
		l = m.VersionInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.FailoverVersionIncrement != 0 {
		n += 1 + sovRequestResponse(uint64(m.FailoverVersionIncrement))
	}
	if m.InitialFailoverVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.InitialFailoverVersion))
	}
	if m.IsGlobalNamespaceEnabled {
		n += 2
	}
	return n
}

func (m *AddOrUpdateRemoteClusterRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.FrontendAddress)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.EnableRemoteClusterConnection {
		n += 2
	}
	return n
}

func (m *AddOrUpdateRemoteClusterResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RemoveRemoteClusterRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveRemoteClusterResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ListClusterMembersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastHeartbeatWithin != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.LastHeartbeatWithin)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RpcAddress)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.HostId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Role != 0 {
		n += 1 + sovRequestResponse(uint64(m.Role))
	}
	if m.SessionStartedAfterTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.SessionStartedAfterTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.PageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.PageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListClusterMembersResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ActiveMembers) > 0 {
		for _, e := range m.ActiveMembers {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *PurgeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	return n
}

func (m *PurgeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *MergeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *MergeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ResendReplicationTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RemoteCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventId))
	}
	if m.StartVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartVersion))
	}
	if m.EndEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventId))
	}
	if m.EndVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndVersion))
	}
	return n
}

func (m *ResendReplicationTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetTaskQueueTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskQueueType != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskQueueType))
	}
	if m.MinTaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.MinTaskId))
	}
	if m.MaxTaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaxTaskId))
	}
	if m.BatchSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.BatchSize))
	}
	return n
}

func (m *GetTaskQueueTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func sovRequestResponse(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRequestResponse(x uint64) (n int) {
	return sovRequestResponse(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *DescribeMutableStateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeMutableStateRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeMutableStateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeMutableStateResponse{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`HistoryAddr:` + fmt.Sprintf("%v", this.HistoryAddr) + `,`,
		`CacheMutableState:` + strings.Replace(fmt.Sprintf("%v", this.CacheMutableState), "WorkflowMutableState", "v11.WorkflowMutableState", 1) + `,`,
		`DatabaseMutableState:` + strings.Replace(fmt.Sprintf("%v", this.DatabaseMutableState), "WorkflowMutableState", "v11.WorkflowMutableState", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostRequest{`,
		`HostAddress:` + fmt.Sprintf("%v", this.HostAddress) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostResponse{`,
		`ShardsNumber:` + fmt.Sprintf("%v", this.ShardsNumber) + `,`,
		`ShardIds:` + fmt.Sprintf("%v", this.ShardIds) + `,`,
		`NamespaceCache:` + strings.Replace(fmt.Sprintf("%v", this.NamespaceCache), "NamespaceCacheInfo", "v12.NamespaceCacheInfo", 1) + `,`,
		`ShardControllerStatus:` + fmt.Sprintf("%v", this.ShardControllerStatus) + `,`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetShardRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetShardRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetShardResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetShardResponse{`,
		`ShardInfo:` + strings.Replace(fmt.Sprintf("%v", this.ShardInfo), "ShardInfo", "v11.ShardInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListTransferTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListTransferTasksRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`MinTaskId:` + fmt.Sprintf("%v", this.MinTaskId) + `,`,
		`MaxTaskId:` + fmt.Sprintf("%v", this.MaxTaskId) + `,`,
		`BatchSize:` + fmt.Sprintf("%v", this.BatchSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListTransferTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTasks := "[]*Task{"
	for _, f := range this.Tasks {
		repeatedStringForTasks += strings.Replace(f.String(), "Task", "Task", 1) + ","
	}
	repeatedStringForTasks += "}"
	s := strings.Join([]string{`&ListTransferTasksResponse{`,
		`Tasks:` + repeatedStringForTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListVisibilityTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListVisibilityTasksRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`ReadLevel:` + fmt.Sprintf("%v", this.ReadLevel) + `,`,
		`MaxReadLevel:` + fmt.Sprintf("%v", this.MaxReadLevel) + `,`,
		`BatchSize:` + fmt.Sprintf("%v", this.BatchSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListVisibilityTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTasks := "[]*Task{"
	for _, f := range this.Tasks {
		repeatedStringForTasks += strings.Replace(f.String(), "Task", "Task", 1) + ","
	}
	repeatedStringForTasks += "}"
	s := strings.Join([]string{`&ListVisibilityTasksResponse{`,
		`Tasks:` + repeatedStringForTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListTimerTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListTimerTasksRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`MinTime:` + strings.Replace(fmt.Sprintf("%v", this.MinTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`MaxTime:` + strings.Replace(fmt.Sprintf("%v", this.MaxTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`BatchSize:` + fmt.Sprintf("%v", this.BatchSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListTimerTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTasks := "[]*Task{"
	for _, f := range this.Tasks {
		repeatedStringForTasks += strings.Replace(f.String(), "Task", "Task", 1) + ","
	}
	repeatedStringForTasks += "}"
	s := strings.Join([]string{`&ListTimerTasksResponse{`,
		`Tasks:` + repeatedStringForTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListReplicationTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListReplicationTasksRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`MinTaskId:` + fmt.Sprintf("%v", this.MinTaskId) + `,`,
		`MaxTaskId:` + fmt.Sprintf("%v", this.MaxTaskId) + `,`,
		`BatchSize:` + fmt.Sprintf("%v", this.BatchSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListReplicationTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTasks := "[]*Task{"
	for _, f := range this.Tasks {
		repeatedStringForTasks += strings.Replace(f.String(), "Task", "Task", 1) + ","
	}
	repeatedStringForTasks += "}"
	s := strings.Join([]string{`&ListReplicationTasksResponse{`,
		`Tasks:` + repeatedStringForTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Task{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`FireTime:` + strings.Replace(fmt.Sprintf("%v", this.FireTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`Category:` + fmt.Sprintf("%v", this.Category) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetWorkflowExecutionRawHistoryV2Request) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetWorkflowExecutionRawHistoryV2Request{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`StartEventId:` + fmt.Sprintf("%v", this.StartEventId) + `,`,
		`StartEventVersion:` + fmt.Sprintf("%v", this.StartEventVersion) + `,`,
		`EndEventId:` + fmt.Sprintf("%v", this.EndEventId) + `,`,
		`EndEventVersion:` + fmt.Sprintf("%v", this.EndEventVersion) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetWorkflowExecutionRawHistoryV2Response) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHistoryBatches := "[]*DataBlob{"
	for _, f := range this.HistoryBatches {
		repeatedStringForHistoryBatches += strings.Replace(fmt.Sprintf("%v", f), "DataBlob", "v1.DataBlob", 1) + ","
	}
	repeatedStringForHistoryBatches += "}"
	s := strings.Join([]string{`&GetWorkflowExecutionRawHistoryV2Response{`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`HistoryBatches:` + repeatedStringForHistoryBatches + `,`,
		`VersionHistory:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistory), "VersionHistory", "v14.VersionHistory", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTokens := "[]*ReplicationToken{"
	for _, f := range this.Tokens {
		repeatedStringForTokens += strings.Replace(fmt.Sprintf("%v", f), "ReplicationToken", "v15.ReplicationToken", 1) + ","
	}
	repeatedStringForTokens += "}"
	s := strings.Join([]string{`&GetReplicationMessagesRequest{`,
		`Tokens:` + repeatedStringForTokens + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v15.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%v: %v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	s := strings.Join([]string{`&GetReplicationMessagesResponse{`,
		`ShardMessages:` + mapStringForShardMessages + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNamespaceReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNamespaceReplicationMessagesRequest{`,
		`LastRetrievedMessageId:` + fmt.Sprintf("%v", this.LastRetrievedMessageId) + `,`,
		`LastProcessedMessageId:` + fmt.Sprintf("%v", this.LastProcessedMessageId) + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNamespaceReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNamespaceReplicationMessagesResponse{`,
		`Messages:` + strings.Replace(fmt.Sprintf("%v", this.Messages), "ReplicationMessages", "v15.ReplicationMessages", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTaskInfos := "[]*ReplicationTaskInfo{"
	for _, f := range this.TaskInfos {
		repeatedStringForTaskInfos += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTaskInfo", "v15.ReplicationTaskInfo", 1) + ","
	}
	repeatedStringForTaskInfos += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesRequest{`,
		`TaskInfos:` + repeatedStringForTaskInfos + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v15.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesResponse{`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`Events:` + strings.Replace(fmt.Sprintf("%v", this.Events), "DataBlob", "v1.DataBlob", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsResponse{`,
		`}`,
	}, "")
	return s
}
func (this *AddSearchAttributesRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]v16.IndexedValueType{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%v: %v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	s := strings.Join([]string{`&AddSearchAttributesRequest{`,
		`SearchAttributes:` + mapStringForSearchAttributes + `,`,
		`IndexName:` + fmt.Sprintf("%v", this.IndexName) + `,`,
		`SkipSchemaUpdate:` + fmt.Sprintf("%v", this.SkipSchemaUpdate) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddSearchAttributesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddSearchAttributesResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RemoveSearchAttributesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveSearchAttributesRequest{`,
		`SearchAttributes:` + fmt.Sprintf("%v", this.SearchAttributes) + `,`,
		`IndexName:` + fmt.Sprintf("%v", this.IndexName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveSearchAttributesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveSearchAttributesResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetSearchAttributesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetSearchAttributesRequest{`,
		`IndexName:` + fmt.Sprintf("%v", this.IndexName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetSearchAttributesResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForCustomAttributes := make([]string, 0, len(this.CustomAttributes))
	for k, _ := range this.CustomAttributes {
		keysForCustomAttributes = append(keysForCustomAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomAttributes)
	mapStringForCustomAttributes := "map[string]v16.IndexedValueType{"
	for _, k := range keysForCustomAttributes {
		mapStringForCustomAttributes += fmt.Sprintf("%v: %v,", k, this.CustomAttributes[k])
	}
	mapStringForCustomAttributes += "}"
	keysForSystemAttributes := make([]string, 0, len(this.SystemAttributes))
	for k, _ := range this.SystemAttributes {
		keysForSystemAttributes = append(keysForSystemAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSystemAttributes)
	mapStringForSystemAttributes := "map[string]v16.IndexedValueType{"
	for _, k := range keysForSystemAttributes {
		mapStringForSystemAttributes += fmt.Sprintf("%v: %v,", k, this.SystemAttributes[k])
	}
	mapStringForSystemAttributes += "}"
	keysForMapping := make([]string, 0, len(this.Mapping))
	for k, _ := range this.Mapping {
		keysForMapping = append(keysForMapping, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMapping)
	mapStringForMapping := "map[string]string{"
	for _, k := range keysForMapping {
		mapStringForMapping += fmt.Sprintf("%v: %v,", k, this.Mapping[k])
	}
	mapStringForMapping += "}"
	s := strings.Join([]string{`&GetSearchAttributesResponse{`,
		`CustomAttributes:` + mapStringForCustomAttributes + `,`,
		`SystemAttributes:` + mapStringForSystemAttributes + `,`,
		`Mapping:` + mapStringForMapping + `,`,
		`AddWorkflowExecutionInfo:` + strings.Replace(fmt.Sprintf("%v", this.AddWorkflowExecutionInfo), "WorkflowExecutionInfo", "v17.WorkflowExecutionInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeClusterRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeClusterRequest{`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeClusterResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForSupportedClients := make([]string, 0, len(this.SupportedClients))
	for k, _ := range this.SupportedClients {
		keysForSupportedClients = append(keysForSupportedClients, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSupportedClients)
	mapStringForSupportedClients := "map[string]string{"
	for _, k := range keysForSupportedClients {
		mapStringForSupportedClients += fmt.Sprintf("%v: %v,", k, this.SupportedClients[k])
	}
	mapStringForSupportedClients += "}"
	s := strings.Join([]string{`&DescribeClusterResponse{`,
		`SupportedClients:` + mapStringForSupportedClients + `,`,
		`ServerVersion:` + fmt.Sprintf("%v", this.ServerVersion) + `,`,
		`MembershipInfo:` + strings.Replace(fmt.Sprintf("%v", this.MembershipInfo), "MembershipInfo", "v18.MembershipInfo", 1) + `,`,
		`ClusterId:` + fmt.Sprintf("%v", this.ClusterId) + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`HistoryShardCount:` + fmt.Sprintf("%v", this.HistoryShardCount) + `,`,
		`PersistenceStore:` + fmt.Sprintf("%v", this.PersistenceStore) + `,`,
		`VisibilityStore:` + fmt.Sprintf("%v", this.VisibilityStore) + `,`,
		`VersionInfo:` + strings.Replace(fmt.Sprintf("%v", this.VersionInfo), "VersionInfo", "v19.VersionInfo", 1) + `,`,
		`FailoverVersionIncrement:` + fmt.Sprintf("%v", this.FailoverVersionIncrement) + `,`,
		`InitialFailoverVersion:` + fmt.Sprintf("%v", this.InitialFailoverVersion) + `,`,
		`IsGlobalNamespaceEnabled:` + fmt.Sprintf("%v", this.IsGlobalNamespaceEnabled) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddOrUpdateRemoteClusterRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddOrUpdateRemoteClusterRequest{`,
		`FrontendAddress:` + fmt.Sprintf("%v", this.FrontendAddress) + `,`,
		`EnableRemoteClusterConnection:` + fmt.Sprintf("%v", this.EnableRemoteClusterConnection) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddOrUpdateRemoteClusterResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddOrUpdateRemoteClusterResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RemoveRemoteClusterRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveRemoteClusterRequest{`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveRemoteClusterResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveRemoteClusterResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ListClusterMembersRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListClusterMembersRequest{`,
		`LastHeartbeatWithin:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatWithin), "Duration", "types.Duration", 1) + `,`,
		`RpcAddress:` + fmt.Sprintf("%v", this.RpcAddress) + `,`,
		`HostId:` + fmt.Sprintf("%v", this.HostId) + `,`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`SessionStartedAfterTime:` + strings.Replace(fmt.Sprintf("%v", this.SessionStartedAfterTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`PageSize:` + fmt.Sprintf("%v", this.PageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListClusterMembersResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForActiveMembers := "[]*ClusterMember{"
	for _, f := range this.ActiveMembers {
		repeatedStringForActiveMembers += strings.Replace(fmt.Sprintf("%v", f), "ClusterMember", "v18.ClusterMember", 1) + ","
	}
	repeatedStringForActiveMembers += "}"
	s := strings.Join([]string{`&ListClusterMembersResponse{`,
		`ActiveMembers:` + repeatedStringForActiveMembers + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v15.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQMessagesResponse{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesResponse{`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesResponse{`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ResendReplicationTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResendReplicationTasksRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`RemoteCluster:` + fmt.Sprintf("%v", this.RemoteCluster) + `,`,
		`StartEventId:` + fmt.Sprintf("%v", this.StartEventId) + `,`,
		`StartVersion:` + fmt.Sprintf("%v", this.StartVersion) + `,`,
		`EndEventId:` + fmt.Sprintf("%v", this.EndEventId) + `,`,
		`EndVersion:` + fmt.Sprintf("%v", this.EndVersion) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResendReplicationTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResendReplicationTasksResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetTaskQueueTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetTaskQueueTasksRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`TaskQueueType:` + fmt.Sprintf("%v", this.TaskQueueType) + `,`,
		`MinTaskId:` + fmt.Sprintf("%v", this.MinTaskId) + `,`,
		`MaxTaskId:` + fmt.Sprintf("%v", this.MaxTaskId) + `,`,
		`BatchSize:` + fmt.Sprintf("%v", this.BatchSize) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetTaskQueueTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTasks := "[]*AllocatedTaskInfo{"
	for _, f := range this.Tasks {
		repeatedStringForTasks += strings.Replace(fmt.Sprintf("%v", f), "AllocatedTaskInfo", "v11.AllocatedTaskInfo", 1) + ","
	}
	repeatedStringForTasks += "}"
	s := strings.Join([]string{`&GetTaskQueueTasksResponse{`,
		`Tasks:` + repeatedStringForTasks + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringRequestResponse(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *DescribeMutableStateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeMutableStateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeMutableStateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeMutableStateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeMutableStateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeMutableStateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShardId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheMutableState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CacheMutableState == nil {
				m.CacheMutableState = &v11.WorkflowMutableState{}
			}
			if err := m.CacheMutableState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseMutableState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DatabaseMutableState == nil {
				m.DatabaseMutableState = &v11.WorkflowMutableState{}
			}
			if err := m.DatabaseMutableState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v1.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardsNumber", wireType)
			}
			m.ShardsNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardsNumber |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ShardIds = append(m.ShardIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRequestResponse
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthRequestResponse
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ShardIds) == 0 {
					m.ShardIds = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ShardIds = append(m.ShardIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardIds", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceCache", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NamespaceCache == nil {
				m.NamespaceCache = &v12.NamespaceCacheInfo{}
			}
			if err := m.NamespaceCache.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardControllerStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShardControllerStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetShardRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetShardRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetShardRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetShardResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetShardResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetShardResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShardInfo == nil {
				m.ShardInfo = &v11.ShardInfo{}
			}
			if err := m.ShardInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTransferTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTransferTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTransferTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTaskId", wireType)
			}
			m.MinTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTaskId", wireType)
			}
			m.MaxTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchSize", wireType)
			}
			m.BatchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTransferTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTransferTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTransferTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListVisibilityTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListVisibilityTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListVisibilityTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadLevel", wireType)
			}
			m.ReadLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxReadLevel", wireType)
			}
			m.MaxReadLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxReadLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchSize", wireType)
			}
			m.BatchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListVisibilityTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListVisibilityTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListVisibilityTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTimerTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTimerTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTimerTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinTime == nil {
				m.MinTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.MinTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxTime == nil {
				m.MaxTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.MaxTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchSize", wireType)
			}
			m.BatchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTimerTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTimerTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTimerTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListReplicationTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListReplicationTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListReplicationTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTaskId", wireType)
			}
			m.MinTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTaskId", wireType)
			}
			m.MaxTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchSize", wireType)
			}
			m.BatchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListReplicationTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListReplicationTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListReplicationTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Task) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Task: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Task: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v13.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FireTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FireTime == nil {
				m.FireTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.FireTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			m.Category = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Category |= v13.TaskCategory(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkflowExecutionRawHistoryV2Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventId", wireType)
			}
			m.StartEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventVersion", wireType)
			}
			m.StartEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventId", wireType)
			}
			m.EndEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventVersion", wireType)
			}
			m.EndEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkflowExecutionRawHistoryV2Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryBatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryBatches = append(m.HistoryBatches, &v1.DataBlob{})
			if err := m.HistoryBatches[len(m.HistoryBatches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistory == nil {
				m.VersionHistory = &v14.VersionHistory{}
			}
			if err := m.VersionHistory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tokens = append(m.Tokens, &v15.ReplicationToken{})
			if err := m.Tokens[len(m.Tokens)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardMessages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShardMessages == nil {
				m.ShardMessages = make(map[int32]*v15.ReplicationMessages)
			}
			var mapkey int32
			var mapvalue *v15.ReplicationMessages
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v15.ReplicationMessages{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ShardMessages[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespaceReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRetrievedMessageId", wireType)
			}
			m.LastRetrievedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastRetrievedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastProcessedMessageId", wireType)
			}
			m.LastProcessedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastProcessedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespaceReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Messages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Messages == nil {
				m.Messages = &v15.ReplicationMessages{}
			}
			if err := m.Messages.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskInfos = append(m.TaskInfos, &v15.ReplicationTaskInfo{})
			if err := m.TaskInfos[len(m.TaskInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v15.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v1.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Events == nil {
				m.Events = &v1.DataBlob{}
			}
			if err := m.Events.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSearchAttributesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSearchAttributesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSearchAttributesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttributes == nil {
				m.SearchAttributes = make(map[string]v16.IndexedValueType)
			}
			var mapkey string
			var mapvalue v16.IndexedValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v16.IndexedValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IndexName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipSchemaUpdate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipSchemaUpdate = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSearchAttributesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSearchAttributesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSearchAttributesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveSearchAttributesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveSearchAttributesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveSearchAttributesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttributes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchAttributes = append(m.SearchAttributes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IndexName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveSearchAttributesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveSearchAttributesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveSearchAttributesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetSearchAttributesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetSearchAttributesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetSearchAttributesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IndexName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetSearchAttributesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetSearchAttributesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetSearchAttributesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CustomAttributes == nil {
				m.CustomAttributes = make(map[string]v16.IndexedValueType)
			}
			var mapkey string
			var mapvalue v16.IndexedValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v16.IndexedValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CustomAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SystemAttributes == nil {
				m.SystemAttributes = make(map[string]v16.IndexedValueType)
			}
			var mapkey string
			var mapvalue v16.IndexedValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v16.IndexedValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SystemAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mapping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Mapping == nil {
				m.Mapping = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Mapping[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddWorkflowExecutionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddWorkflowExecutionInfo == nil {
				m.AddWorkflowExecutionInfo = &v17.WorkflowExecutionInfo{}
			}
			if err := m.AddWorkflowExecutionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeClusterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeClusterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeClusterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportedClients", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SupportedClients == nil {
				m.SupportedClients = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SupportedClients[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MembershipInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MembershipInfo == nil {
				m.MembershipInfo = &v18.MembershipInfo{}
			}
			if err := m.MembershipInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryShardCount", wireType)
			}
			m.HistoryShardCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryShardCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PersistenceStore", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PersistenceStore = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityStore", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VisibilityStore = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionInfo == nil {
				m.VersionInfo = &v19.VersionInfo{}
			}
			if err := m.VersionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverVersionIncrement", wireType)
			}
			m.FailoverVersionIncrement = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailoverVersionIncrement |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialFailoverVersion", wireType)
			}
			m.InitialFailoverVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitialFailoverVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsGlobalNamespaceEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsGlobalNamespaceEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddOrUpdateRemoteClusterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddOrUpdateRemoteClusterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddOrUpdateRemoteClusterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrontendAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FrontendAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableRemoteClusterConnection", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableRemoteClusterConnection = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddOrUpdateRemoteClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddOrUpdateRemoteClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddOrUpdateRemoteClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveRemoteClusterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveRemoteClusterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveRemoteClusterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveRemoteClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveRemoteClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveRemoteClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListClusterMembersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListClusterMembersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListClusterMembersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatWithin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatWithin == nil {
				m.LastHeartbeatWithin = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.LastHeartbeatWithin, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RpcAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RpcAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= v13.ClusterMemberRole(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionStartedAfterTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SessionStartedAfterTime == nil {
				m.SessionStartedAfterTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.SessionStartedAfterTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PageSize", wireType)
			}
			m.PageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListClusterMembersResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListClusterMembersResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListClusterMembersResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveMembers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveMembers = append(m.ActiveMembers, &v18.ClusterMember{})
			if err := m.ActiveMembers[len(m.ActiveMembers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v15.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v13.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResendReplicationTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResendReplicationTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResendReplicationTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventId", wireType)
			}
			m.StartEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventId", wireType)
			}
			m.EndEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResendReplicationTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResendReplicationTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResendReplicationTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetTaskQueueTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetTaskQueueTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetTaskQueueTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueueType", wireType)
			}
			m.TaskQueueType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskQueueType |= v16.TaskQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTaskId", wireType)
			}
			m.MinTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTaskId", wireType)
			}
			m.MaxTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchSize", wireType)
			}
			m.BatchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetTaskQueueTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetTaskQueueTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetTaskQueueTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &v11.AllocatedTaskInfo{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRequestResponse(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRequestResponse
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRequestResponse
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRequestResponse
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRequestResponse        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRequestResponse          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRequestResponse = fmt.Errorf("proto: unexpected end of group")
)
