// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/enums/v1/task.proto

package enums

import (
	fmt "fmt"
	math "math"
	strconv "strconv"

	proto "github.com/gogo/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// TaskSource is the source from which a task was produced.
type TaskSource int32

const (
	TASK_SOURCE_UNSPECIFIED TaskSource = 0
	// Task produced by history service.
	TASK_SOURCE_HISTORY TaskSource = 1
	// Task produced from matching db backlog.
	TASK_SOURCE_DB_BACKLOG TaskSource = 2
)

var TaskSource_name = map[int32]string{
	0: "Unspecified",
	1: "History",
	2: "DbBacklog",
}

var TaskSource_value = map[string]int32{
	"Unspecified": 0,
	"History":     1,
	"DbBacklog":   2,
}

func (TaskSource) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_36a3d3674ca3cfa6, []int{0}
}

type TaskCategory int32

const (
	TASK_CATEGORY_UNSPECIFIED TaskCategory = 0
	// Transfer is the task type for transfer task.
	TASK_CATEGORY_TRANSFER TaskCategory = 1
	// Timer is the task type for timer task.
	TASK_CATEGORY_TIMER TaskCategory = 2
	// Replication is the task type for replication task.
	TASK_CATEGORY_REPLICATION TaskCategory = 3
	// Visibility is the task type for visibility task.
	TASK_CATEGORY_VISIBILITY TaskCategory = 4
)

var TaskCategory_name = map[int32]string{
	0: "Unspecified",
	1: "Transfer",
	2: "Timer",
	3: "Replication",
	4: "Visibility",
}

var TaskCategory_value = map[string]int32{
	"Unspecified": 0,
	"Transfer":    1,
	"Timer":       2,
	"Replication": 3,
	"Visibility":  4,
}

func (TaskCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_36a3d3674ca3cfa6, []int{1}
}

type TaskType int32

const (
	TASK_TYPE_UNSPECIFIED                    TaskType = 0
	TASK_TYPE_REPLICATION_HISTORY            TaskType = 1
	TASK_TYPE_REPLICATION_SYNC_ACTIVITY      TaskType = 2
	TASK_TYPE_TRANSFER_WORKFLOW_TASK         TaskType = 3
	TASK_TYPE_TRANSFER_ACTIVITY_TASK         TaskType = 4
	TASK_TYPE_TRANSFER_CLOSE_EXECUTION       TaskType = 5
	TASK_TYPE_TRANSFER_CANCEL_EXECUTION      TaskType = 6
	TASK_TYPE_TRANSFER_START_CHILD_EXECUTION TaskType = 7
	TASK_TYPE_TRANSFER_SIGNAL_EXECUTION      TaskType = 8
	TASK_TYPE_TRANSFER_RESET_WORKFLOW        TaskType = 10
	TASK_TYPE_WORKFLOW_TASK_TIMEOUT          TaskType = 12
	TASK_TYPE_ACTIVITY_TIMEOUT               TaskType = 13
	TASK_TYPE_USER_TIMER                     TaskType = 14
	TASK_TYPE_WORKFLOW_RUN_TIMEOUT           TaskType = 15
	TASK_TYPE_DELETE_HISTORY_EVENT           TaskType = 16
	TASK_TYPE_ACTIVITY_RETRY_TIMER           TaskType = 17
	TASK_TYPE_WORKFLOW_BACKOFF_TIMER         TaskType = 18
	TASK_TYPE_VISIBILITY_START_EXECUTION     TaskType = 19
	TASK_TYPE_VISIBILITY_UPSERT_EXECUTION    TaskType = 20
	TASK_TYPE_VISIBILITY_CLOSE_EXECUTION     TaskType = 21
	TASK_TYPE_VISIBILITY_DELETE_EXECUTION    TaskType = 22
)

var TaskType_name = map[int32]string{
	0:  "Unspecified",
	1:  "ReplicationHistory",
	2:  "ReplicationSyncActivity",
	3:  "TransferWorkflowTask",
	4:  "TransferActivityTask",
	5:  "TransferCloseExecution",
	6:  "TransferCancelExecution",
	7:  "TransferStartChildExecution",
	8:  "TransferSignalExecution",
	10: "TransferResetWorkflow",
	12: "WorkflowTaskTimeout",
	13: "ActivityTimeout",
	14: "UserTimer",
	15: "WorkflowRunTimeout",
	16: "DeleteHistoryEvent",
	17: "ActivityRetryTimer",
	18: "WorkflowBackoffTimer",
	19: "VisibilityStartExecution",
	20: "VisibilityUpsertExecution",
	21: "VisibilityCloseExecution",
	22: "VisibilityDeleteExecution",
}

var TaskType_value = map[string]int32{
	"Unspecified":                 0,
	"ReplicationHistory":          1,
	"ReplicationSyncActivity":     2,
	"TransferWorkflowTask":        3,
	"TransferActivityTask":        4,
	"TransferCloseExecution":      5,
	"TransferCancelExecution":     6,
	"TransferStartChildExecution": 7,
	"TransferSignalExecution":     8,
	"TransferResetWorkflow":       10,
	"WorkflowTaskTimeout":         12,
	"ActivityTimeout":             13,
	"UserTimer":                   14,
	"WorkflowRunTimeout":          15,
	"DeleteHistoryEvent":          16,
	"ActivityRetryTimer":          17,
	"WorkflowBackoffTimer":        18,
	"VisibilityStartExecution":    19,
	"VisibilityUpsertExecution":   20,
	"VisibilityCloseExecution":    21,
	"VisibilityDeleteExecution":   22,
}

func (TaskType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_36a3d3674ca3cfa6, []int{2}
}

func init() {
	proto.RegisterEnum("temporal.server.api.enums.v1.TaskSource", TaskSource_name, TaskSource_value)
	proto.RegisterEnum("temporal.server.api.enums.v1.TaskCategory", TaskCategory_name, TaskCategory_value)
	proto.RegisterEnum("temporal.server.api.enums.v1.TaskType", TaskType_name, TaskType_value)
}

func init() {
	proto.RegisterFile("temporal/server/api/enums/v1/task.proto", fileDescriptor_36a3d3674ca3cfa6)
}

var fileDescriptor_36a3d3674ca3cfa6 = []byte{
	// 596 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x94, 0xcd, 0x4e, 0xdb, 0x4e,
	0x14, 0xc5, 0x6d, 0xc8, 0x9f, 0x7f, 0xb8, 0xd0, 0x76, 0x3a, 0x7c, 0x53, 0x98, 0x96, 0x00, 0x85,
	0xa2, 0x2a, 0x11, 0xea, 0xb2, 0x2b, 0x67, 0x32, 0x81, 0x11, 0xae, 0x1d, 0xcd, 0x4c, 0xa0, 0xe9,
	0x02, 0xcb, 0xad, 0x2c, 0x84, 0x28, 0x75, 0xe4, 0x04, 0x24, 0x76, 0x7d, 0x84, 0xbe, 0x41, 0xb7,
	0xdd, 0xf7, 0x25, 0xba, 0x64, 0xc9, 0xb2, 0x98, 0x4d, 0x97, 0x3c, 0x42, 0x15, 0x93, 0xf8, 0x23,
	0x75, 0x76, 0x91, 0xce, 0x2f, 0xe7, 0xde, 0x7b, 0xe6, 0xfa, 0xc2, 0x56, 0xd7, 0x3b, 0x6f, 0xfb,
	0x81, 0xfb, 0xb9, 0xd2, 0xf1, 0x82, 0x4b, 0x2f, 0xa8, 0xb8, 0xed, 0xd3, 0x8a, 0xf7, 0xe5, 0xe2,
	0xbc, 0x53, 0xb9, 0xdc, 0xad, 0x74, 0xdd, 0xce, 0x59, 0xb9, 0x1d, 0xf8, 0x5d, 0x1f, 0xaf, 0x0c,
	0xc0, 0xf2, 0x03, 0x58, 0x76, 0xdb, 0xa7, 0xe5, 0x08, 0x2c, 0x5f, 0xee, 0xee, 0x1c, 0x03, 0x28,
	0xb7, 0x73, 0x26, 0xfd, 0x8b, 0xe0, 0x93, 0x87, 0x9f, 0xc1, 0x82, 0x32, 0xe4, 0x81, 0x23, 0xed,
	0xa6, 0xa0, 0xcc, 0x69, 0x5a, 0xb2, 0xc1, 0x28, 0xaf, 0x73, 0x56, 0x43, 0x1a, 0x5e, 0x80, 0x99,
	0xb4, 0xb8, 0xcf, 0xa5, 0xb2, 0x45, 0x0b, 0xe9, 0x78, 0x19, 0xe6, 0xd3, 0x42, 0xad, 0xea, 0x54,
	0x0d, 0x7a, 0x60, 0xda, 0x7b, 0x68, 0x6c, 0xe7, 0xbb, 0x0e, 0xd3, 0xbd, 0x02, 0xd4, 0xed, 0x7a,
	0x27, 0x7e, 0x70, 0x85, 0x57, 0x61, 0x29, 0x82, 0xa9, 0xa1, 0xd8, 0x9e, 0x2d, 0x5a, 0x43, 0x45,
	0x06, 0x5e, 0xb1, 0xac, 0x84, 0x61, 0xc9, 0x3a, 0x13, 0x48, 0x8f, 0x1b, 0x48, 0x34, 0xfe, 0x8e,
	0x09, 0x34, 0xf6, 0xaf, 0xa7, 0x60, 0x0d, 0x93, 0x53, 0x43, 0x71, 0xdb, 0x42, 0xe3, 0x78, 0x05,
	0x16, 0xb3, 0xf2, 0x21, 0x97, 0xbc, 0xca, 0x4d, 0xae, 0x5a, 0xa8, 0xb0, 0xf3, 0x73, 0x02, 0x8a,
	0xbd, 0x0e, 0xd5, 0x55, 0xdb, 0xc3, 0x4b, 0x30, 0x17, 0xa1, 0xaa, 0xd5, 0x18, 0x1e, 0x7f, 0x0d,
	0x56, 0x13, 0x29, 0x55, 0x20, 0x15, 0xc4, 0x16, 0xac, 0xe7, 0x23, 0xb2, 0x65, 0x51, 0xc7, 0xa0,
	0x8a, 0x1f, 0xf6, 0x6a, 0x8e, 0xe1, 0x0d, 0x78, 0x91, 0x80, 0x83, 0x09, 0x9d, 0x23, 0x5b, 0x1c,
	0xd4, 0x4d, 0xfb, 0xc8, 0xe9, 0x69, 0x68, 0x7c, 0x04, 0x35, 0xb0, 0x79, 0xa0, 0x0a, 0xf8, 0x25,
	0x94, 0x72, 0x28, 0x6a, 0xda, 0x92, 0x39, 0xec, 0x3d, 0xa3, 0xcd, 0x28, 0x85, 0xff, 0xb2, 0xcd,
	0x25, 0x9c, 0x61, 0x51, 0x66, 0xa6, 0xc0, 0x09, 0xfc, 0x1a, 0xb6, 0x73, 0x40, 0xa9, 0x0c, 0xa1,
	0x1c, 0xba, 0xcf, 0xcd, 0x5a, 0x8a, 0xfe, 0x7f, 0x84, 0xad, 0xe4, 0x7b, 0x96, 0x91, 0xb6, 0x2d,
	0xe2, 0x4d, 0x58, 0xcb, 0x01, 0x05, 0x93, 0x4c, 0xc5, 0x93, 0x23, 0xc0, 0xeb, 0xf0, 0x3c, 0xc1,
	0x32, 0x89, 0x44, 0xcf, 0x6d, 0x37, 0x15, 0x9a, 0xc6, 0x04, 0x96, 0x13, 0x28, 0x09, 0xa4, 0xaf,
	0x3f, 0xc2, 0x8b, 0x30, 0x9b, 0x7a, 0x46, 0xc9, 0x44, 0x7f, 0x55, 0x1e, 0xe3, 0x12, 0x90, 0x1c,
	0x7b, 0xd1, 0xb4, 0xe2, 0x7f, 0x3f, 0xc9, 0x32, 0x35, 0x66, 0x32, 0x15, 0x6f, 0xbb, 0xc3, 0x0e,
	0x99, 0xa5, 0x10, 0xca, 0x32, 0x71, 0x07, 0x82, 0xa9, 0x78, 0x2d, 0x9f, 0x66, 0xdf, 0x2f, 0xae,
	0xd5, 0xfb, 0x36, 0xec, 0x7a, 0xbd, 0x4f, 0x61, 0xbc, 0x0d, 0x1b, 0x09, 0x95, 0x6c, 0x66, 0x3f,
	0xf0, 0x24, 0xc1, 0x19, 0xfc, 0x0a, 0x36, 0x73, 0xc9, 0x66, 0x43, 0xb2, 0x0c, 0x3a, 0x3b, 0xd2,
	0x74, 0x78, 0x2d, 0xe6, 0x46, 0x9a, 0xf6, 0xe7, 0x4e, 0xd0, 0xf9, 0x52, 0xa1, 0x38, 0x89, 0x26,
	0x4b, 0x85, 0xe2, 0x14, 0x9a, 0xaa, 0x1e, 0x5f, 0xdf, 0x12, 0xed, 0xe6, 0x96, 0x68, 0xf7, 0xb7,
	0x44, 0xff, 0x1a, 0x12, 0xfd, 0x47, 0x48, 0xf4, 0x5f, 0x21, 0xd1, 0xaf, 0x43, 0xa2, 0xff, 0x0e,
	0x89, 0xfe, 0x27, 0x24, 0xda, 0x7d, 0x48, 0xf4, 0x6f, 0x77, 0x44, 0xbb, 0xbe, 0x23, 0xda, 0xcd,
	0x1d, 0xd1, 0x3e, 0x6c, 0x9f, 0xf8, 0xe5, 0xf8, 0x1c, 0x9d, 0xfa, 0x79, 0xa7, 0xeb, 0x6d, 0xf4,
	0xe3, 0xe3, 0x44, 0x74, 0xbc, 0xde, 0xfc, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x74, 0x5a, 0x6d, 0xa1,
	0xe7, 0x04, 0x00, 0x00,
}

func (x TaskSource) String() string {
	s, ok := TaskSource_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x TaskCategory) String() string {
	s, ok := TaskCategory_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x TaskType) String() string {
	s, ok := TaskType_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
