// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistence/v1/cluster_metadata.proto

package persistence

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	v11 "go.temporal.io/api/enums/v1"
	v1 "go.temporal.io/api/version/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// data column
type ClusterMetadata struct {
	ClusterName           string                            `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	HistoryShardCount     int32                             `protobuf:"varint,2,opt,name=history_shard_count,json=historyShardCount,proto3" json:"history_shard_count,omitempty"`
	ClusterId             string                            `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	VersionInfo           *v1.VersionInfo                   `protobuf:"bytes,4,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	IndexSearchAttributes map[string]*IndexSearchAttributes `protobuf:"bytes,5,rep,name=index_search_attributes,json=indexSearchAttributes,proto3" json:"index_search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *ClusterMetadata) Reset()      { *m = ClusterMetadata{} }
func (*ClusterMetadata) ProtoMessage() {}
func (*ClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f4771d63f405884, []int{0}
}
func (m *ClusterMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterMetadata.Merge(m, src)
}
func (m *ClusterMetadata) XXX_Size() int {
	return m.Size()
}
func (m *ClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterMetadata proto.InternalMessageInfo

func (m *ClusterMetadata) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ClusterMetadata) GetHistoryShardCount() int32 {
	if m != nil {
		return m.HistoryShardCount
	}
	return 0
}

func (m *ClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ClusterMetadata) GetVersionInfo() *v1.VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return nil
}

func (m *ClusterMetadata) GetIndexSearchAttributes() map[string]*IndexSearchAttributes {
	if m != nil {
		return m.IndexSearchAttributes
	}
	return nil
}

type IndexSearchAttributes struct {
	CustomSearchAttributes map[string]v11.IndexedValueType `protobuf:"bytes,1,rep,name=custom_search_attributes,json=customSearchAttributes,proto3" json:"custom_search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=temporal.api.enums.v1.IndexedValueType"`
}

func (m *IndexSearchAttributes) Reset()      { *m = IndexSearchAttributes{} }
func (*IndexSearchAttributes) ProtoMessage() {}
func (*IndexSearchAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f4771d63f405884, []int{1}
}
func (m *IndexSearchAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IndexSearchAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IndexSearchAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IndexSearchAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IndexSearchAttributes.Merge(m, src)
}
func (m *IndexSearchAttributes) XXX_Size() int {
	return m.Size()
}
func (m *IndexSearchAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_IndexSearchAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_IndexSearchAttributes proto.InternalMessageInfo

func (m *IndexSearchAttributes) GetCustomSearchAttributes() map[string]v11.IndexedValueType {
	if m != nil {
		return m.CustomSearchAttributes
	}
	return nil
}

func init() {
	proto.RegisterType((*ClusterMetadata)(nil), "temporal.server.api.persistence.v1.ClusterMetadata")
	proto.RegisterMapType((map[string]*IndexSearchAttributes)(nil), "temporal.server.api.persistence.v1.ClusterMetadata.IndexSearchAttributesEntry")
	proto.RegisterType((*IndexSearchAttributes)(nil), "temporal.server.api.persistence.v1.IndexSearchAttributes")
	proto.RegisterMapType((map[string]v11.IndexedValueType)(nil), "temporal.server.api.persistence.v1.IndexSearchAttributes.CustomSearchAttributesEntry")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistence/v1/cluster_metadata.proto", fileDescriptor_1f4771d63f405884)
}

var fileDescriptor_1f4771d63f405884 = []byte{
	// 511 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x93, 0x4f, 0x8b, 0xd3, 0x40,
	0x18, 0xc6, 0x33, 0xad, 0x15, 0x76, 0xba, 0xf8, 0x27, 0xb2, 0x1a, 0x2a, 0x0e, 0xb5, 0x28, 0xf6,
	0x34, 0xa5, 0xd5, 0x83, 0xab, 0x78, 0xd0, 0x22, 0xd2, 0x83, 0x2b, 0x64, 0x75, 0x0f, 0x5e, 0xc2,
	0x6c, 0xf2, 0xee, 0x76, 0xb4, 0x99, 0x09, 0x33, 0x93, 0x60, 0x6f, 0x82, 0xe0, 0x55, 0xbf, 0x80,
	0x77, 0x3f, 0x8a, 0xc7, 0x1e, 0x17, 0xbc, 0xd8, 0xf4, 0xe2, 0x71, 0x3f, 0x82, 0xe4, 0x4f, 0xbb,
	0x5d, 0xc9, 0xaa, 0x78, 0xcb, 0xcc, 0xfb, 0x3c, 0xcf, 0x3c, 0xfc, 0xc8, 0x8b, 0xb7, 0x0d, 0x84,
	0x91, 0x54, 0x6c, 0xd2, 0xd3, 0xa0, 0x12, 0x50, 0x3d, 0x16, 0xf1, 0x5e, 0x04, 0x4a, 0x73, 0x6d,
	0x40, 0xf8, 0xd0, 0x4b, 0xfa, 0x3d, 0x7f, 0x12, 0x6b, 0x03, 0xca, 0x0b, 0xc1, 0xb0, 0x80, 0x19,
	0x46, 0x23, 0x25, 0x8d, 0xb4, 0x3b, 0x4b, 0x2b, 0x2d, 0xac, 0x94, 0x45, 0x9c, 0xae, 0x59, 0x69,
	0xd2, 0x6f, 0xad, 0x34, 0x79, 0x2e, 0x88, 0x38, 0xd4, 0x79, 0xa2, 0x0c, 0x43, 0x29, 0x8a, 0x9c,
	0xd6, 0xed, 0x53, 0x9a, 0x24, 0x0b, 0x90, 0x22, 0x53, 0x85, 0xa0, 0x35, 0x3b, 0x84, 0x42, 0xd6,
	0xf9, 0x5e, 0xc7, 0x17, 0x87, 0x45, 0x93, 0xe7, 0x65, 0x11, 0xfb, 0x26, 0xde, 0x5c, 0x96, 0x13,
	0x2c, 0x04, 0x07, 0xb5, 0x51, 0x77, 0xc3, 0x6d, 0x96, 0x77, 0x3b, 0x2c, 0x04, 0x9b, 0xe2, 0x2b,
	0x63, 0xae, 0x8d, 0x54, 0x53, 0x4f, 0x8f, 0x99, 0x0a, 0x3c, 0x5f, 0xc6, 0xc2, 0x38, 0xb5, 0x36,
	0xea, 0x36, 0xdc, 0xcb, 0xe5, 0x68, 0x37, 0x9b, 0x0c, 0xb3, 0x81, 0x7d, 0x03, 0xe3, 0x65, 0x24,
	0x0f, 0x9c, 0x7a, 0x1e, 0xb8, 0x51, 0xde, 0x8c, 0x02, 0xfb, 0x19, 0xde, 0x2c, 0x1b, 0x7a, 0x5c,
	0x1c, 0x48, 0xe7, 0x5c, 0x1b, 0x75, 0x9b, 0x83, 0x5b, 0x74, 0xc5, 0x22, 0x83, 0x50, 0x2a, 0x68,
	0xd2, 0xa7, 0x7b, 0xc5, 0xe7, 0x48, 0x1c, 0x48, 0xb7, 0x99, 0x9c, 0x1c, 0xec, 0x8f, 0x08, 0x5f,
	0xe3, 0x22, 0x80, 0x77, 0x9e, 0x06, 0xa6, 0xfc, 0xb1, 0xc7, 0x8c, 0x51, 0x7c, 0x3f, 0x36, 0xa0,
	0x9d, 0x46, 0xbb, 0xde, 0x6d, 0x0e, 0x76, 0xe8, 0xdf, 0x01, 0xd3, 0xdf, 0x88, 0xd0, 0x51, 0x16,
	0xb9, 0x9b, 0x27, 0x3e, 0x5e, 0x05, 0x3e, 0x15, 0x46, 0x4d, 0xdd, 0x2d, 0x5e, 0x35, 0x6b, 0x7d,
	0x40, 0xb8, 0x75, 0xb6, 0xcb, 0xbe, 0x84, 0xeb, 0x6f, 0x61, 0x5a, 0x92, 0xcd, 0x3e, 0xed, 0x17,
	0xb8, 0x91, 0xb0, 0x49, 0x0c, 0x39, 0xc3, 0xe6, 0x60, 0xfb, 0x5f, 0x6a, 0x56, 0x3e, 0xe0, 0x16,
	0x39, 0x0f, 0x6a, 0xf7, 0x51, 0xe7, 0x4b, 0x0d, 0x6f, 0x55, 0x8a, 0xec, 0x4f, 0x08, 0x3b, 0x7e,
	0xac, 0x8d, 0x0c, 0x2b, 0x48, 0xa1, 0x9c, 0xd4, 0xab, 0xff, 0xae, 0x40, 0x87, 0x79, 0x72, 0x35,
	0xb0, 0xab, 0x7e, 0xe5, 0xb0, 0xa5, 0xf0, 0xf5, 0x3f, 0xd8, 0x2a, 0x88, 0x3d, 0x5a, 0x27, 0x76,
	0x61, 0x70, 0xe7, 0xf4, 0xdf, 0x92, 0x6f, 0xc5, 0xaa, 0x21, 0x04, 0x7b, 0x99, 0xf4, 0xe5, 0x34,
	0x82, 0x35, 0x3e, 0x4f, 0xde, 0xcc, 0xe6, 0xc4, 0x3a, 0x9a, 0x13, 0xeb, 0x78, 0x4e, 0xd0, 0xfb,
	0x94, 0xa0, 0xaf, 0x29, 0x41, 0xdf, 0x52, 0x82, 0x66, 0x29, 0x41, 0x3f, 0x52, 0x82, 0x7e, 0xa6,
	0xc4, 0x3a, 0x4e, 0x09, 0xfa, 0xbc, 0x20, 0xd6, 0x6c, 0x41, 0xac, 0xa3, 0x05, 0xb1, 0x5e, 0xdf,
	0x3b, 0x94, 0x27, 0x6f, 0x71, 0x79, 0xf6, 0x8e, 0x3f, 0x5c, 0x3b, 0xee, 0x9f, 0xcf, 0x17, 0xee,
	0xee, 0xaf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x5b, 0x1c, 0x47, 0x38, 0x1c, 0x04, 0x00, 0x00,
}

func (this *ClusterMetadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClusterMetadata)
	if !ok {
		that2, ok := that.(ClusterMetadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if this.HistoryShardCount != that1.HistoryShardCount {
		return false
	}
	if this.ClusterId != that1.ClusterId {
		return false
	}
	if !this.VersionInfo.Equal(that1.VersionInfo) {
		return false
	}
	if len(this.IndexSearchAttributes) != len(that1.IndexSearchAttributes) {
		return false
	}
	for i := range this.IndexSearchAttributes {
		if !this.IndexSearchAttributes[i].Equal(that1.IndexSearchAttributes[i]) {
			return false
		}
	}
	return true
}
func (this *IndexSearchAttributes) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IndexSearchAttributes)
	if !ok {
		that2, ok := that.(IndexSearchAttributes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.CustomSearchAttributes) != len(that1.CustomSearchAttributes) {
		return false
	}
	for i := range this.CustomSearchAttributes {
		if this.CustomSearchAttributes[i] != that1.CustomSearchAttributes[i] {
			return false
		}
	}
	return true
}
func (this *ClusterMetadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&persistence.ClusterMetadata{")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "HistoryShardCount: "+fmt.Sprintf("%#v", this.HistoryShardCount)+",\n")
	s = append(s, "ClusterId: "+fmt.Sprintf("%#v", this.ClusterId)+",\n")
	if this.VersionInfo != nil {
		s = append(s, "VersionInfo: "+fmt.Sprintf("%#v", this.VersionInfo)+",\n")
	}
	keysForIndexSearchAttributes := make([]string, 0, len(this.IndexSearchAttributes))
	for k, _ := range this.IndexSearchAttributes {
		keysForIndexSearchAttributes = append(keysForIndexSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexSearchAttributes)
	mapStringForIndexSearchAttributes := "map[string]*IndexSearchAttributes{"
	for _, k := range keysForIndexSearchAttributes {
		mapStringForIndexSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.IndexSearchAttributes[k])
	}
	mapStringForIndexSearchAttributes += "}"
	if this.IndexSearchAttributes != nil {
		s = append(s, "IndexSearchAttributes: "+mapStringForIndexSearchAttributes+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IndexSearchAttributes) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&persistence.IndexSearchAttributes{")
	keysForCustomSearchAttributes := make([]string, 0, len(this.CustomSearchAttributes))
	for k, _ := range this.CustomSearchAttributes {
		keysForCustomSearchAttributes = append(keysForCustomSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomSearchAttributes)
	mapStringForCustomSearchAttributes := "map[string]v11.IndexedValueType{"
	for _, k := range keysForCustomSearchAttributes {
		mapStringForCustomSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.CustomSearchAttributes[k])
	}
	mapStringForCustomSearchAttributes += "}"
	if this.CustomSearchAttributes != nil {
		s = append(s, "CustomSearchAttributes: "+mapStringForCustomSearchAttributes+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringClusterMetadata(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *ClusterMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.IndexSearchAttributes) > 0 {
		for k := range m.IndexSearchAttributes {
			v := m.IndexSearchAttributes[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintClusterMetadata(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintClusterMetadata(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintClusterMetadata(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.VersionInfo != nil {
		{
			size, err := m.VersionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClusterMetadata(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintClusterMetadata(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.HistoryShardCount != 0 {
		i = encodeVarintClusterMetadata(dAtA, i, uint64(m.HistoryShardCount))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintClusterMetadata(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IndexSearchAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IndexSearchAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IndexSearchAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CustomSearchAttributes) > 0 {
		for k := range m.CustomSearchAttributes {
			v := m.CustomSearchAttributes[k]
			baseI := i
			i = encodeVarintClusterMetadata(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintClusterMetadata(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintClusterMetadata(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintClusterMetadata(dAtA []byte, offset int, v uint64) int {
	offset -= sovClusterMetadata(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ClusterMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovClusterMetadata(uint64(l))
	}
	if m.HistoryShardCount != 0 {
		n += 1 + sovClusterMetadata(uint64(m.HistoryShardCount))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovClusterMetadata(uint64(l))
	}
	if m.VersionInfo != nil {
		l = m.VersionInfo.Size()
		n += 1 + l + sovClusterMetadata(uint64(l))
	}
	if len(m.IndexSearchAttributes) > 0 {
		for k, v := range m.IndexSearchAttributes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovClusterMetadata(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovClusterMetadata(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovClusterMetadata(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *IndexSearchAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.CustomSearchAttributes) > 0 {
		for k, v := range m.CustomSearchAttributes {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovClusterMetadata(uint64(len(k))) + 1 + sovClusterMetadata(uint64(v))
			n += mapEntrySize + 1 + sovClusterMetadata(uint64(mapEntrySize))
		}
	}
	return n
}

func sovClusterMetadata(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozClusterMetadata(x uint64) (n int) {
	return sovClusterMetadata(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ClusterMetadata) String() string {
	if this == nil {
		return "nil"
	}
	keysForIndexSearchAttributes := make([]string, 0, len(this.IndexSearchAttributes))
	for k, _ := range this.IndexSearchAttributes {
		keysForIndexSearchAttributes = append(keysForIndexSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForIndexSearchAttributes)
	mapStringForIndexSearchAttributes := "map[string]*IndexSearchAttributes{"
	for _, k := range keysForIndexSearchAttributes {
		mapStringForIndexSearchAttributes += fmt.Sprintf("%v: %v,", k, this.IndexSearchAttributes[k])
	}
	mapStringForIndexSearchAttributes += "}"
	s := strings.Join([]string{`&ClusterMetadata{`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`HistoryShardCount:` + fmt.Sprintf("%v", this.HistoryShardCount) + `,`,
		`ClusterId:` + fmt.Sprintf("%v", this.ClusterId) + `,`,
		`VersionInfo:` + strings.Replace(fmt.Sprintf("%v", this.VersionInfo), "VersionInfo", "v1.VersionInfo", 1) + `,`,
		`IndexSearchAttributes:` + mapStringForIndexSearchAttributes + `,`,
		`}`,
	}, "")
	return s
}
func (this *IndexSearchAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForCustomSearchAttributes := make([]string, 0, len(this.CustomSearchAttributes))
	for k, _ := range this.CustomSearchAttributes {
		keysForCustomSearchAttributes = append(keysForCustomSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForCustomSearchAttributes)
	mapStringForCustomSearchAttributes := "map[string]v11.IndexedValueType{"
	for _, k := range keysForCustomSearchAttributes {
		mapStringForCustomSearchAttributes += fmt.Sprintf("%v: %v,", k, this.CustomSearchAttributes[k])
	}
	mapStringForCustomSearchAttributes += "}"
	s := strings.Join([]string{`&IndexSearchAttributes{`,
		`CustomSearchAttributes:` + mapStringForCustomSearchAttributes + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringClusterMetadata(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ClusterMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryShardCount", wireType)
			}
			m.HistoryShardCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryShardCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionInfo == nil {
				m.VersionInfo = &v1.VersionInfo{}
			}
			if err := m.VersionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexSearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IndexSearchAttributes == nil {
				m.IndexSearchAttributes = make(map[string]*IndexSearchAttributes)
			}
			var mapkey string
			var mapvalue *IndexSearchAttributes
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClusterMetadata
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &IndexSearchAttributes{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClusterMetadata(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.IndexSearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClusterMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexSearchAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexSearchAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexSearchAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomSearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CustomSearchAttributes == nil {
				m.CustomSearchAttributes = make(map[string]v11.IndexedValueType)
			}
			var mapkey string
			var mapvalue v11.IndexedValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClusterMetadata
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClusterMetadata
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v11.IndexedValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClusterMetadata(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClusterMetadata
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CustomSearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClusterMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthClusterMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipClusterMetadata(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowClusterMetadata
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClusterMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthClusterMetadata
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupClusterMetadata
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthClusterMetadata
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthClusterMetadata        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowClusterMetadata          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupClusterMetadata = fmt.Errorf("proto: unexpected end of group")
)
