// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: provider.go

// Package provider is a generated GoMock package.
package provider

import (
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	archiver "go.temporal.io/server/common/archiver"
)

// MockArchiverProvider is a mock of ArchiverProvider interface.
type MockArchiverProvider struct {
	ctrl     *gomock.Controller
	recorder *MockArchiverProviderMockRecorder
}

// MockArchiverProviderMockRecorder is the mock recorder for MockArchiverProvider.
type MockArchiverProviderMockRecorder struct {
	mock *MockArchiverProvider
}

// NewMockArchiverProvider creates a new mock instance.
func NewMockArchiverProvider(ctrl *gomock.Controller) *MockArchiverProvider {
	mock := &MockArchiverProvider{ctrl: ctrl}
	mock.recorder = &MockArchiverProviderMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockArchiverProvider) EXPECT() *MockArchiverProviderMockRecorder {
	return m.recorder
}

// GetHistoryArchiver mocks base method.
func (m *MockArchiverProvider) GetHistoryArchiver(scheme, serviceName string) (archiver.HistoryArchiver, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetHistoryArchiver", scheme, serviceName)
	ret0, _ := ret[0].(archiver.HistoryArchiver)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetHistoryArchiver indicates an expected call of GetHistoryArchiver.
func (mr *MockArchiverProviderMockRecorder) GetHistoryArchiver(scheme, serviceName interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetHistoryArchiver", reflect.TypeOf((*MockArchiverProvider)(nil).GetHistoryArchiver), scheme, serviceName)
}

// GetVisibilityArchiver mocks base method.
func (m *MockArchiverProvider) GetVisibilityArchiver(scheme, serviceName string) (archiver.VisibilityArchiver, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetVisibilityArchiver", scheme, serviceName)
	ret0, _ := ret[0].(archiver.VisibilityArchiver)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetVisibilityArchiver indicates an expected call of GetVisibilityArchiver.
func (mr *MockArchiverProviderMockRecorder) GetVisibilityArchiver(scheme, serviceName interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetVisibilityArchiver", reflect.TypeOf((*MockArchiverProvider)(nil).GetVisibilityArchiver), scheme, serviceName)
}

// RegisterBootstrapContainer mocks base method.
func (m *MockArchiverProvider) RegisterBootstrapContainer(serviceName string, historyContainer *archiver.HistoryBootstrapContainer, visibilityContainter *archiver.VisibilityBootstrapContainer) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterBootstrapContainer", serviceName, historyContainer, visibilityContainter)
	ret0, _ := ret[0].(error)
	return ret0
}

// RegisterBootstrapContainer indicates an expected call of RegisterBootstrapContainer.
func (mr *MockArchiverProviderMockRecorder) RegisterBootstrapContainer(serviceName, historyContainer, visibilityContainter interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterBootstrapContainer", reflect.TypeOf((*MockArchiverProvider)(nil).RegisterBootstrapContainer), serviceName, historyContainer, visibilityContainter)
}
