// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by MockGen. DO NOT EDIT.
// Source: historyEngineInterfaces.go

// Package history is a generated GoMock package.
package history

import (
	context "context"
	reflect "reflect"
	time "time"

	gomock "github.com/golang/mock/gomock"
	enums "go.temporal.io/server/api/enums/v1"
	persistence "go.temporal.io/server/api/persistence/v1"
	repication "go.temporal.io/server/api/replication/v1"
	persistence0 "go.temporal.io/server/common/persistence"
	task "go.temporal.io/server/common/task"
	shard "go.temporal.io/server/service/history/shard"
)

// MockqueueProcessor is a mock of queueProcessor interface.
type MockqueueProcessor struct {
	ctrl     *gomock.Controller
	recorder *MockqueueProcessorMockRecorder
}

// MockqueueProcessorMockRecorder is the mock recorder for MockqueueProcessor.
type MockqueueProcessorMockRecorder struct {
	mock *MockqueueProcessor
}

// NewMockqueueProcessor creates a new mock instance.
func NewMockqueueProcessor(ctrl *gomock.Controller) *MockqueueProcessor {
	mock := &MockqueueProcessor{ctrl: ctrl}
	mock.recorder = &MockqueueProcessorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockqueueProcessor) EXPECT() *MockqueueProcessorMockRecorder {
	return m.recorder
}

// Start mocks base method.
func (m *MockqueueProcessor) Start() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Start")
}

// Start indicates an expected call of Start.
func (mr *MockqueueProcessorMockRecorder) Start() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MockqueueProcessor)(nil).Start))
}

// Stop mocks base method.
func (m *MockqueueProcessor) Stop() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Stop")
}

// Stop indicates an expected call of Stop.
func (mr *MockqueueProcessorMockRecorder) Stop() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stop", reflect.TypeOf((*MockqueueProcessor)(nil).Stop))
}

// notifyNewTask mocks base method.
func (m *MockqueueProcessor) notifyNewTask() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "notifyNewTask")
}

// notifyNewTask indicates an expected call of notifyNewTask.
func (mr *MockqueueProcessorMockRecorder) notifyNewTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "notifyNewTask", reflect.TypeOf((*MockqueueProcessor)(nil).notifyNewTask))
}

// MockReplicatorQueueProcessor is a mock of ReplicatorQueueProcessor interface.
type MockReplicatorQueueProcessor struct {
	ctrl     *gomock.Controller
	recorder *MockReplicatorQueueProcessorMockRecorder
}

// MockReplicatorQueueProcessorMockRecorder is the mock recorder for MockReplicatorQueueProcessor.
type MockReplicatorQueueProcessorMockRecorder struct {
	mock *MockReplicatorQueueProcessor
}

// NewMockReplicatorQueueProcessor creates a new mock instance.
func NewMockReplicatorQueueProcessor(ctrl *gomock.Controller) *MockReplicatorQueueProcessor {
	mock := &MockReplicatorQueueProcessor{ctrl: ctrl}
	mock.recorder = &MockReplicatorQueueProcessorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockReplicatorQueueProcessor) EXPECT() *MockReplicatorQueueProcessorMockRecorder {
	return m.recorder
}

// Start mocks base method.
func (m *MockReplicatorQueueProcessor) Start() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Start")
}

// Start indicates an expected call of Start.
func (mr *MockReplicatorQueueProcessorMockRecorder) Start() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MockReplicatorQueueProcessor)(nil).Start))
}

// Stop mocks base method.
func (m *MockReplicatorQueueProcessor) Stop() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Stop")
}

// Stop indicates an expected call of Stop.
func (mr *MockReplicatorQueueProcessorMockRecorder) Stop() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stop", reflect.TypeOf((*MockReplicatorQueueProcessor)(nil).Stop))
}

// getTask mocks base method.
func (m *MockReplicatorQueueProcessor) getTask(ctx context.Context, taskInfo *repication.ReplicationTaskInfo) (*repication.ReplicationTask, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getTask", ctx, taskInfo)
	ret0, _ := ret[0].(*repication.ReplicationTask)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// getTask indicates an expected call of getTask.
func (mr *MockReplicatorQueueProcessorMockRecorder) getTask(ctx, taskInfo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getTask", reflect.TypeOf((*MockReplicatorQueueProcessor)(nil).getTask), ctx, taskInfo)
}

// getTasks mocks base method.
func (m *MockReplicatorQueueProcessor) getTasks(ctx context.Context, pollingCluster string, lastReadTaskID int64) (*repication.ReplicationMessages, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getTasks", ctx, pollingCluster, lastReadTaskID)
	ret0, _ := ret[0].(*repication.ReplicationMessages)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// getTasks indicates an expected call of getTasks.
func (mr *MockReplicatorQueueProcessorMockRecorder) getTasks(ctx, pollingCluster, lastReadTaskID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getTasks", reflect.TypeOf((*MockReplicatorQueueProcessor)(nil).getTasks), ctx, pollingCluster, lastReadTaskID)
}

// notifyNewTask mocks base method.
func (m *MockReplicatorQueueProcessor) notifyNewTask() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "notifyNewTask")
}

// notifyNewTask indicates an expected call of notifyNewTask.
func (mr *MockReplicatorQueueProcessorMockRecorder) notifyNewTask() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "notifyNewTask", reflect.TypeOf((*MockReplicatorQueueProcessor)(nil).notifyNewTask))
}

// MockqueueAckMgr is a mock of queueAckMgr interface.
type MockqueueAckMgr struct {
	ctrl     *gomock.Controller
	recorder *MockqueueAckMgrMockRecorder
}

// MockqueueAckMgrMockRecorder is the mock recorder for MockqueueAckMgr.
type MockqueueAckMgrMockRecorder struct {
	mock *MockqueueAckMgr
}

// NewMockqueueAckMgr creates a new mock instance.
func NewMockqueueAckMgr(ctrl *gomock.Controller) *MockqueueAckMgr {
	mock := &MockqueueAckMgr{ctrl: ctrl}
	mock.recorder = &MockqueueAckMgrMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockqueueAckMgr) EXPECT() *MockqueueAckMgrMockRecorder {
	return m.recorder
}

// completeQueueTask mocks base method.
func (m *MockqueueAckMgr) completeQueueTask(taskID int64) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "completeQueueTask", taskID)
}

// completeQueueTask indicates an expected call of completeQueueTask.
func (mr *MockqueueAckMgrMockRecorder) completeQueueTask(taskID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "completeQueueTask", reflect.TypeOf((*MockqueueAckMgr)(nil).completeQueueTask), taskID)
}

// getFinishedChan mocks base method.
func (m *MockqueueAckMgr) getFinishedChan() <-chan struct{} {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getFinishedChan")
	ret0, _ := ret[0].(<-chan struct{})
	return ret0
}

// getFinishedChan indicates an expected call of getFinishedChan.
func (mr *MockqueueAckMgrMockRecorder) getFinishedChan() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getFinishedChan", reflect.TypeOf((*MockqueueAckMgr)(nil).getFinishedChan))
}

// getQueueAckLevel mocks base method.
func (m *MockqueueAckMgr) getQueueAckLevel() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getQueueAckLevel")
	ret0, _ := ret[0].(int64)
	return ret0
}

// getQueueAckLevel indicates an expected call of getQueueAckLevel.
func (mr *MockqueueAckMgrMockRecorder) getQueueAckLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getQueueAckLevel", reflect.TypeOf((*MockqueueAckMgr)(nil).getQueueAckLevel))
}

// getQueueReadLevel mocks base method.
func (m *MockqueueAckMgr) getQueueReadLevel() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getQueueReadLevel")
	ret0, _ := ret[0].(int64)
	return ret0
}

// getQueueReadLevel indicates an expected call of getQueueReadLevel.
func (mr *MockqueueAckMgrMockRecorder) getQueueReadLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getQueueReadLevel", reflect.TypeOf((*MockqueueAckMgr)(nil).getQueueReadLevel))
}

// readQueueTasks mocks base method.
func (m *MockqueueAckMgr) readQueueTasks() ([]queueTaskInfo, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "readQueueTasks")
	ret0, _ := ret[0].([]queueTaskInfo)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// readQueueTasks indicates an expected call of readQueueTasks.
func (mr *MockqueueAckMgrMockRecorder) readQueueTasks() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "readQueueTasks", reflect.TypeOf((*MockqueueAckMgr)(nil).readQueueTasks))
}

// updateQueueAckLevel mocks base method.
func (m *MockqueueAckMgr) updateQueueAckLevel() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "updateQueueAckLevel")
	ret0, _ := ret[0].(error)
	return ret0
}

// updateQueueAckLevel indicates an expected call of updateQueueAckLevel.
func (mr *MockqueueAckMgrMockRecorder) updateQueueAckLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "updateQueueAckLevel", reflect.TypeOf((*MockqueueAckMgr)(nil).updateQueueAckLevel))
}

// MockqueueTaskInfo is a mock of queueTaskInfo interface.
type MockqueueTaskInfo struct {
	ctrl     *gomock.Controller
	recorder *MockqueueTaskInfoMockRecorder
}

// MockqueueTaskInfoMockRecorder is the mock recorder for MockqueueTaskInfo.
type MockqueueTaskInfoMockRecorder struct {
	mock *MockqueueTaskInfo
}

// NewMockqueueTaskInfo creates a new mock instance.
func NewMockqueueTaskInfo(ctrl *gomock.Controller) *MockqueueTaskInfo {
	mock := &MockqueueTaskInfo{ctrl: ctrl}
	mock.recorder = &MockqueueTaskInfoMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockqueueTaskInfo) EXPECT() *MockqueueTaskInfoMockRecorder {
	return m.recorder
}

// GetNamespaceId mocks base method.
func (m *MockqueueTaskInfo) GetNamespaceId() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNamespaceId")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetNamespaceId indicates an expected call of GetNamespaceId.
func (mr *MockqueueTaskInfoMockRecorder) GetNamespaceId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNamespaceId", reflect.TypeOf((*MockqueueTaskInfo)(nil).GetNamespaceId))
}

// GetRunId mocks base method.
func (m *MockqueueTaskInfo) GetRunId() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRunId")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetRunId indicates an expected call of GetRunId.
func (mr *MockqueueTaskInfoMockRecorder) GetRunId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRunId", reflect.TypeOf((*MockqueueTaskInfo)(nil).GetRunId))
}

// GetTaskId mocks base method.
func (m *MockqueueTaskInfo) GetTaskId() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTaskId")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetTaskId indicates an expected call of GetTaskId.
func (mr *MockqueueTaskInfoMockRecorder) GetTaskId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTaskId", reflect.TypeOf((*MockqueueTaskInfo)(nil).GetTaskId))
}

// GetTaskType mocks base method.
func (m *MockqueueTaskInfo) GetTaskType() enums.TaskType {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTaskType")
	ret0, _ := ret[0].(enums.TaskType)
	return ret0
}

// GetTaskType indicates an expected call of GetTaskType.
func (mr *MockqueueTaskInfoMockRecorder) GetTaskType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTaskType", reflect.TypeOf((*MockqueueTaskInfo)(nil).GetTaskType))
}

// GetVersion mocks base method.
func (m *MockqueueTaskInfo) GetVersion() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetVersion")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetVersion indicates an expected call of GetVersion.
func (mr *MockqueueTaskInfoMockRecorder) GetVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetVersion", reflect.TypeOf((*MockqueueTaskInfo)(nil).GetVersion))
}

// GetVisibilityTime mocks base method.
func (m *MockqueueTaskInfo) GetVisibilityTime() *time.Time {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetVisibilityTime")
	ret0, _ := ret[0].(*time.Time)
	return ret0
}

// GetVisibilityTime indicates an expected call of GetVisibilityTime.
func (mr *MockqueueTaskInfoMockRecorder) GetVisibilityTime() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetVisibilityTime", reflect.TypeOf((*MockqueueTaskInfo)(nil).GetVisibilityTime))
}

// GetWorkflowId mocks base method.
func (m *MockqueueTaskInfo) GetWorkflowId() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowId")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetWorkflowId indicates an expected call of GetWorkflowId.
func (mr *MockqueueTaskInfoMockRecorder) GetWorkflowId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowId", reflect.TypeOf((*MockqueueTaskInfo)(nil).GetWorkflowId))
}

// MockqueueTask is a mock of queueTask interface.
type MockqueueTask struct {
	ctrl     *gomock.Controller
	recorder *MockqueueTaskMockRecorder
}

// MockqueueTaskMockRecorder is the mock recorder for MockqueueTask.
type MockqueueTaskMockRecorder struct {
	mock *MockqueueTask
}

// NewMockqueueTask creates a new mock instance.
func NewMockqueueTask(ctrl *gomock.Controller) *MockqueueTask {
	mock := &MockqueueTask{ctrl: ctrl}
	mock.recorder = &MockqueueTaskMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockqueueTask) EXPECT() *MockqueueTaskMockRecorder {
	return m.recorder
}

// Ack mocks base method.
func (m *MockqueueTask) Ack() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Ack")
}

// Ack indicates an expected call of Ack.
func (mr *MockqueueTaskMockRecorder) Ack() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Ack", reflect.TypeOf((*MockqueueTask)(nil).Ack))
}

// Execute mocks base method.
func (m *MockqueueTask) Execute() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Execute")
	ret0, _ := ret[0].(error)
	return ret0
}

// Execute indicates an expected call of Execute.
func (mr *MockqueueTaskMockRecorder) Execute() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Execute", reflect.TypeOf((*MockqueueTask)(nil).Execute))
}

// GetNamespaceId mocks base method.
func (m *MockqueueTask) GetNamespaceId() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetNamespaceId")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetNamespaceId indicates an expected call of GetNamespaceId.
func (mr *MockqueueTaskMockRecorder) GetNamespaceId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetNamespaceId", reflect.TypeOf((*MockqueueTask)(nil).GetNamespaceId))
}

// GetQueueType mocks base method.
func (m *MockqueueTask) GetQueueType() queueType {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetQueueType")
	ret0, _ := ret[0].(queueType)
	return ret0
}

// GetQueueType indicates an expected call of GetQueueType.
func (mr *MockqueueTaskMockRecorder) GetQueueType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetQueueType", reflect.TypeOf((*MockqueueTask)(nil).GetQueueType))
}

// GetRunId mocks base method.
func (m *MockqueueTask) GetRunId() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRunId")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetRunId indicates an expected call of GetRunId.
func (mr *MockqueueTaskMockRecorder) GetRunId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRunId", reflect.TypeOf((*MockqueueTask)(nil).GetRunId))
}

// GetShard mocks base method.
func (m *MockqueueTask) GetShard() shard.Context {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetShard")
	ret0, _ := ret[0].(shard.Context)
	return ret0
}

// GetShard indicates an expected call of GetShard.
func (mr *MockqueueTaskMockRecorder) GetShard() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetShard", reflect.TypeOf((*MockqueueTask)(nil).GetShard))
}

// GetTaskId mocks base method.
func (m *MockqueueTask) GetTaskId() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTaskId")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetTaskId indicates an expected call of GetTaskId.
func (mr *MockqueueTaskMockRecorder) GetTaskId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTaskId", reflect.TypeOf((*MockqueueTask)(nil).GetTaskId))
}

// GetTaskType mocks base method.
func (m *MockqueueTask) GetTaskType() enums.TaskType {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTaskType")
	ret0, _ := ret[0].(enums.TaskType)
	return ret0
}

// GetTaskType indicates an expected call of GetTaskType.
func (mr *MockqueueTaskMockRecorder) GetTaskType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTaskType", reflect.TypeOf((*MockqueueTask)(nil).GetTaskType))
}

// GetVersion mocks base method.
func (m *MockqueueTask) GetVersion() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetVersion")
	ret0, _ := ret[0].(int64)
	return ret0
}

// GetVersion indicates an expected call of GetVersion.
func (mr *MockqueueTaskMockRecorder) GetVersion() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetVersion", reflect.TypeOf((*MockqueueTask)(nil).GetVersion))
}

// GetVisibilityTime mocks base method.
func (m *MockqueueTask) GetVisibilityTime() *time.Time {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetVisibilityTime")
	ret0, _ := ret[0].(*time.Time)
	return ret0
}

// GetVisibilityTime indicates an expected call of GetVisibilityTime.
func (mr *MockqueueTaskMockRecorder) GetVisibilityTime() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetVisibilityTime", reflect.TypeOf((*MockqueueTask)(nil).GetVisibilityTime))
}

// GetWorkflowId mocks base method.
func (m *MockqueueTask) GetWorkflowId() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetWorkflowId")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetWorkflowId indicates an expected call of GetWorkflowId.
func (mr *MockqueueTaskMockRecorder) GetWorkflowId() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetWorkflowId", reflect.TypeOf((*MockqueueTask)(nil).GetWorkflowId))
}

// HandleErr mocks base method.
func (m *MockqueueTask) HandleErr(err error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HandleErr", err)
	ret0, _ := ret[0].(error)
	return ret0
}

// HandleErr indicates an expected call of HandleErr.
func (mr *MockqueueTaskMockRecorder) HandleErr(err interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HandleErr", reflect.TypeOf((*MockqueueTask)(nil).HandleErr), err)
}

// Nack mocks base method.
func (m *MockqueueTask) Nack() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Nack")
}

// Nack indicates an expected call of Nack.
func (mr *MockqueueTaskMockRecorder) Nack() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Nack", reflect.TypeOf((*MockqueueTask)(nil).Nack))
}

// Priority mocks base method.
func (m *MockqueueTask) Priority() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Priority")
	ret0, _ := ret[0].(int)
	return ret0
}

// Priority indicates an expected call of Priority.
func (mr *MockqueueTaskMockRecorder) Priority() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Priority", reflect.TypeOf((*MockqueueTask)(nil).Priority))
}

// RetryErr mocks base method.
func (m *MockqueueTask) RetryErr(err error) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RetryErr", err)
	ret0, _ := ret[0].(bool)
	return ret0
}

// RetryErr indicates an expected call of RetryErr.
func (mr *MockqueueTaskMockRecorder) RetryErr(err interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RetryErr", reflect.TypeOf((*MockqueueTask)(nil).RetryErr), err)
}

// SetPriority mocks base method.
func (m *MockqueueTask) SetPriority(arg0 int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetPriority", arg0)
}

// SetPriority indicates an expected call of SetPriority.
func (mr *MockqueueTaskMockRecorder) SetPriority(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPriority", reflect.TypeOf((*MockqueueTask)(nil).SetPriority), arg0)
}

// State mocks base method.
func (m *MockqueueTask) State() task.State {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "State")
	ret0, _ := ret[0].(task.State)
	return ret0
}

// State indicates an expected call of State.
func (mr *MockqueueTaskMockRecorder) State() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "State", reflect.TypeOf((*MockqueueTask)(nil).State))
}

// MockqueueTaskExecutor is a mock of queueTaskExecutor interface.
type MockqueueTaskExecutor struct {
	ctrl     *gomock.Controller
	recorder *MockqueueTaskExecutorMockRecorder
}

// MockqueueTaskExecutorMockRecorder is the mock recorder for MockqueueTaskExecutor.
type MockqueueTaskExecutorMockRecorder struct {
	mock *MockqueueTaskExecutor
}

// NewMockqueueTaskExecutor creates a new mock instance.
func NewMockqueueTaskExecutor(ctrl *gomock.Controller) *MockqueueTaskExecutor {
	mock := &MockqueueTaskExecutor{ctrl: ctrl}
	mock.recorder = &MockqueueTaskExecutorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockqueueTaskExecutor) EXPECT() *MockqueueTaskExecutorMockRecorder {
	return m.recorder
}

// execute mocks base method.
func (m *MockqueueTaskExecutor) execute(taskInfo queueTaskInfo, shouldProcessTask bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "execute", taskInfo, shouldProcessTask)
	ret0, _ := ret[0].(error)
	return ret0
}

// execute indicates an expected call of execute.
func (mr *MockqueueTaskExecutorMockRecorder) execute(taskInfo, shouldProcessTask interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "execute", reflect.TypeOf((*MockqueueTaskExecutor)(nil).execute), taskInfo, shouldProcessTask)
}

// MockqueueTaskProcessor is a mock of queueTaskProcessor interface.
type MockqueueTaskProcessor struct {
	ctrl     *gomock.Controller
	recorder *MockqueueTaskProcessorMockRecorder
}

// MockqueueTaskProcessorMockRecorder is the mock recorder for MockqueueTaskProcessor.
type MockqueueTaskProcessorMockRecorder struct {
	mock *MockqueueTaskProcessor
}

// NewMockqueueTaskProcessor creates a new mock instance.
func NewMockqueueTaskProcessor(ctrl *gomock.Controller) *MockqueueTaskProcessor {
	mock := &MockqueueTaskProcessor{ctrl: ctrl}
	mock.recorder = &MockqueueTaskProcessorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockqueueTaskProcessor) EXPECT() *MockqueueTaskProcessorMockRecorder {
	return m.recorder
}

// Start mocks base method.
func (m *MockqueueTaskProcessor) Start() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Start")
}

// Start indicates an expected call of Start.
func (mr *MockqueueTaskProcessorMockRecorder) Start() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MockqueueTaskProcessor)(nil).Start))
}

// Stop mocks base method.
func (m *MockqueueTaskProcessor) Stop() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Stop")
}

// Stop indicates an expected call of Stop.
func (mr *MockqueueTaskProcessorMockRecorder) Stop() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stop", reflect.TypeOf((*MockqueueTaskProcessor)(nil).Stop))
}

// StopShardProcessor mocks base method.
func (m *MockqueueTaskProcessor) StopShardProcessor(arg0 shard.Context) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "StopShardProcessor", arg0)
}

// StopShardProcessor indicates an expected call of StopShardProcessor.
func (mr *MockqueueTaskProcessorMockRecorder) StopShardProcessor(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StopShardProcessor", reflect.TypeOf((*MockqueueTaskProcessor)(nil).StopShardProcessor), arg0)
}

// Submit mocks base method.
func (m *MockqueueTaskProcessor) Submit(arg0 queueTask) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Submit", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// Submit indicates an expected call of Submit.
func (mr *MockqueueTaskProcessorMockRecorder) Submit(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Submit", reflect.TypeOf((*MockqueueTaskProcessor)(nil).Submit), arg0)
}

// TrySubmit mocks base method.
func (m *MockqueueTaskProcessor) TrySubmit(arg0 queueTask) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TrySubmit", arg0)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TrySubmit indicates an expected call of TrySubmit.
func (mr *MockqueueTaskProcessorMockRecorder) TrySubmit(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TrySubmit", reflect.TypeOf((*MockqueueTaskProcessor)(nil).TrySubmit), arg0)
}

// MocktaskExecutor is a mock of taskExecutor interface.
type MocktaskExecutor struct {
	ctrl     *gomock.Controller
	recorder *MocktaskExecutorMockRecorder
}

// MocktaskExecutorMockRecorder is the mock recorder for MocktaskExecutor.
type MocktaskExecutorMockRecorder struct {
	mock *MocktaskExecutor
}

// NewMocktaskExecutor creates a new mock instance.
func NewMocktaskExecutor(ctrl *gomock.Controller) *MocktaskExecutor {
	mock := &MocktaskExecutor{ctrl: ctrl}
	mock.recorder = &MocktaskExecutorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MocktaskExecutor) EXPECT() *MocktaskExecutorMockRecorder {
	return m.recorder
}

// complete mocks base method.
func (m *MocktaskExecutor) complete(taskInfo *taskInfo) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "complete", taskInfo)
}

// complete indicates an expected call of complete.
func (mr *MocktaskExecutorMockRecorder) complete(taskInfo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "complete", reflect.TypeOf((*MocktaskExecutor)(nil).complete), taskInfo)
}

// getTaskFilter mocks base method.
func (m *MocktaskExecutor) getTaskFilter() taskFilter {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getTaskFilter")
	ret0, _ := ret[0].(taskFilter)
	return ret0
}

// getTaskFilter indicates an expected call of getTaskFilter.
func (mr *MocktaskExecutorMockRecorder) getTaskFilter() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getTaskFilter", reflect.TypeOf((*MocktaskExecutor)(nil).getTaskFilter))
}

// process mocks base method.
func (m *MocktaskExecutor) process(taskInfo *taskInfo) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "process", taskInfo)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// process indicates an expected call of process.
func (mr *MocktaskExecutorMockRecorder) process(taskInfo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "process", reflect.TypeOf((*MocktaskExecutor)(nil).process), taskInfo)
}

// Mockprocessor is a mock of processor interface.
type Mockprocessor struct {
	ctrl     *gomock.Controller
	recorder *MockprocessorMockRecorder
}

// MockprocessorMockRecorder is the mock recorder for Mockprocessor.
type MockprocessorMockRecorder struct {
	mock *Mockprocessor
}

// NewMockprocessor creates a new mock instance.
func NewMockprocessor(ctrl *gomock.Controller) *Mockprocessor {
	mock := &Mockprocessor{ctrl: ctrl}
	mock.recorder = &MockprocessorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *Mockprocessor) EXPECT() *MockprocessorMockRecorder {
	return m.recorder
}

// complete mocks base method.
func (m *Mockprocessor) complete(taskInfo *taskInfo) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "complete", taskInfo)
}

// complete indicates an expected call of complete.
func (mr *MockprocessorMockRecorder) complete(taskInfo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "complete", reflect.TypeOf((*Mockprocessor)(nil).complete), taskInfo)
}

// getTaskFilter mocks base method.
func (m *Mockprocessor) getTaskFilter() taskFilter {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getTaskFilter")
	ret0, _ := ret[0].(taskFilter)
	return ret0
}

// getTaskFilter indicates an expected call of getTaskFilter.
func (mr *MockprocessorMockRecorder) getTaskFilter() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getTaskFilter", reflect.TypeOf((*Mockprocessor)(nil).getTaskFilter))
}

// process mocks base method.
func (m *Mockprocessor) process(taskInfo *taskInfo) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "process", taskInfo)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// process indicates an expected call of process.
func (mr *MockprocessorMockRecorder) process(taskInfo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "process", reflect.TypeOf((*Mockprocessor)(nil).process), taskInfo)
}

// queueShutdown mocks base method.
func (m *Mockprocessor) queueShutdown() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "queueShutdown")
	ret0, _ := ret[0].(error)
	return ret0
}

// queueShutdown indicates an expected call of queueShutdown.
func (mr *MockprocessorMockRecorder) queueShutdown() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "queueShutdown", reflect.TypeOf((*Mockprocessor)(nil).queueShutdown))
}

// readTasks mocks base method.
func (m *Mockprocessor) readTasks(readLevel int64) ([]queueTaskInfo, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "readTasks", readLevel)
	ret0, _ := ret[0].([]queueTaskInfo)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// readTasks indicates an expected call of readTasks.
func (mr *MockprocessorMockRecorder) readTasks(readLevel interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "readTasks", reflect.TypeOf((*Mockprocessor)(nil).readTasks), readLevel)
}

// updateAckLevel mocks base method.
func (m *Mockprocessor) updateAckLevel(taskID int64) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "updateAckLevel", taskID)
	ret0, _ := ret[0].(error)
	return ret0
}

// updateAckLevel indicates an expected call of updateAckLevel.
func (mr *MockprocessorMockRecorder) updateAckLevel(taskID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "updateAckLevel", reflect.TypeOf((*Mockprocessor)(nil).updateAckLevel), taskID)
}

// MocktimerProcessor is a mock of timerProcessor interface.
type MocktimerProcessor struct {
	ctrl     *gomock.Controller
	recorder *MocktimerProcessorMockRecorder
}

// MocktimerProcessorMockRecorder is the mock recorder for MocktimerProcessor.
type MocktimerProcessorMockRecorder struct {
	mock *MocktimerProcessor
}

// NewMocktimerProcessor creates a new mock instance.
func NewMocktimerProcessor(ctrl *gomock.Controller) *MocktimerProcessor {
	mock := &MocktimerProcessor{ctrl: ctrl}
	mock.recorder = &MocktimerProcessorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MocktimerProcessor) EXPECT() *MocktimerProcessorMockRecorder {
	return m.recorder
}

// complete mocks base method.
func (m *MocktimerProcessor) complete(taskInfo *taskInfo) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "complete", taskInfo)
}

// complete indicates an expected call of complete.
func (mr *MocktimerProcessorMockRecorder) complete(taskInfo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "complete", reflect.TypeOf((*MocktimerProcessor)(nil).complete), taskInfo)
}

// getTaskFilter mocks base method.
func (m *MocktimerProcessor) getTaskFilter() taskFilter {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getTaskFilter")
	ret0, _ := ret[0].(taskFilter)
	return ret0
}

// getTaskFilter indicates an expected call of getTaskFilter.
func (mr *MocktimerProcessorMockRecorder) getTaskFilter() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getTaskFilter", reflect.TypeOf((*MocktimerProcessor)(nil).getTaskFilter))
}

// notifyNewTimers mocks base method.
func (m *MocktimerProcessor) notifyNewTimers(timerTask []persistence0.Task) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "notifyNewTimers", timerTask)
}

// notifyNewTimers indicates an expected call of notifyNewTimers.
func (mr *MocktimerProcessorMockRecorder) notifyNewTimers(timerTask interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "notifyNewTimers", reflect.TypeOf((*MocktimerProcessor)(nil).notifyNewTimers), timerTask)
}

// process mocks base method.
func (m *MocktimerProcessor) process(taskInfo *taskInfo) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "process", taskInfo)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// process indicates an expected call of process.
func (mr *MocktimerProcessorMockRecorder) process(taskInfo interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "process", reflect.TypeOf((*MocktimerProcessor)(nil).process), taskInfo)
}

// MocktimerQueueAckMgr is a mock of timerQueueAckMgr interface.
type MocktimerQueueAckMgr struct {
	ctrl     *gomock.Controller
	recorder *MocktimerQueueAckMgrMockRecorder
}

// MocktimerQueueAckMgrMockRecorder is the mock recorder for MocktimerQueueAckMgr.
type MocktimerQueueAckMgrMockRecorder struct {
	mock *MocktimerQueueAckMgr
}

// NewMocktimerQueueAckMgr creates a new mock instance.
func NewMocktimerQueueAckMgr(ctrl *gomock.Controller) *MocktimerQueueAckMgr {
	mock := &MocktimerQueueAckMgr{ctrl: ctrl}
	mock.recorder = &MocktimerQueueAckMgrMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MocktimerQueueAckMgr) EXPECT() *MocktimerQueueAckMgrMockRecorder {
	return m.recorder
}

// completeTimerTask mocks base method.
func (m *MocktimerQueueAckMgr) completeTimerTask(timerTask *persistence.TimerTaskInfo) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "completeTimerTask", timerTask)
}

// completeTimerTask indicates an expected call of completeTimerTask.
func (mr *MocktimerQueueAckMgrMockRecorder) completeTimerTask(timerTask interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "completeTimerTask", reflect.TypeOf((*MocktimerQueueAckMgr)(nil).completeTimerTask), timerTask)
}

// getAckLevel mocks base method.
func (m *MocktimerQueueAckMgr) getAckLevel() timerKey {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getAckLevel")
	ret0, _ := ret[0].(timerKey)
	return ret0
}

// getAckLevel indicates an expected call of getAckLevel.
func (mr *MocktimerQueueAckMgrMockRecorder) getAckLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getAckLevel", reflect.TypeOf((*MocktimerQueueAckMgr)(nil).getAckLevel))
}

// getFinishedChan mocks base method.
func (m *MocktimerQueueAckMgr) getFinishedChan() <-chan struct{} {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getFinishedChan")
	ret0, _ := ret[0].(<-chan struct{})
	return ret0
}

// getFinishedChan indicates an expected call of getFinishedChan.
func (mr *MocktimerQueueAckMgrMockRecorder) getFinishedChan() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getFinishedChan", reflect.TypeOf((*MocktimerQueueAckMgr)(nil).getFinishedChan))
}

// getReadLevel mocks base method.
func (m *MocktimerQueueAckMgr) getReadLevel() timerKey {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "getReadLevel")
	ret0, _ := ret[0].(timerKey)
	return ret0
}

// getReadLevel indicates an expected call of getReadLevel.
func (mr *MocktimerQueueAckMgrMockRecorder) getReadLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "getReadLevel", reflect.TypeOf((*MocktimerQueueAckMgr)(nil).getReadLevel))
}

// readTimerTasks mocks base method.
func (m *MocktimerQueueAckMgr) readTimerTasks() ([]*persistence.TimerTaskInfo, *persistence.TimerTaskInfo, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "readTimerTasks")
	ret0, _ := ret[0].([]*persistence.TimerTaskInfo)
	ret1, _ := ret[1].(*persistence.TimerTaskInfo)
	ret2, _ := ret[2].(bool)
	ret3, _ := ret[3].(error)
	return ret0, ret1, ret2, ret3
}

// readTimerTasks indicates an expected call of readTimerTasks.
func (mr *MocktimerQueueAckMgrMockRecorder) readTimerTasks() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "readTimerTasks", reflect.TypeOf((*MocktimerQueueAckMgr)(nil).readTimerTasks))
}

// updateAckLevel mocks base method.
func (m *MocktimerQueueAckMgr) updateAckLevel() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "updateAckLevel")
	ret0, _ := ret[0].(error)
	return ret0
}

// updateAckLevel indicates an expected call of updateAckLevel.
func (mr *MocktimerQueueAckMgrMockRecorder) updateAckLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "updateAckLevel", reflect.TypeOf((*MocktimerQueueAckMgr)(nil).updateAckLevel))
}
