// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package history

import "github.com/stretchr/testify/mock"

// MockHistoryEngineFactory is mock implementation for HistoryEngineFactory
type MockHistoryEngineFactory struct {
	mock.Mock
}

// CreateEngine is mock implementation for CreateEngine of HistoryEngineFactory
func (_m *MockHistoryEngineFactory) CreateEngine(context ShardContext) Engine {
	ret := _m.Called(context)

	var r0 Engine
	if rf, ok := ret.Get(0).(func(ShardContext) Engine); ok {
		r0 = rf(context)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(Engine)
		}
	}

	return r0
}

var _ EngineFactory = (*MockHistoryEngineFactory)(nil)
