// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/persistenceblobs/v1/message.proto

package persistenceblobs

import (
	bytes "bytes"
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	v13 "go.temporal.io/api/common/v1"
	v15 "go.temporal.io/api/enums/v1"
	v12 "go.temporal.io/api/failure/v1"
	v11 "go.temporal.io/api/history/v1"
	v18 "go.temporal.io/api/namespace/v1"
	v1 "go.temporal.io/api/version/v1"
	v16 "go.temporal.io/api/workflow/v1"
	v14 "go.temporal.io/server/api/enums/v1"
	v17 "go.temporal.io/server/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// ExecutionStats is not persisted and is used internally and as part of mutableState
type ExecutionStats struct {
	HistorySize int64 `protobuf:"varint,1,opt,name=history_size,json=historySize,proto3" json:"history_size,omitempty"`
}

func (m *ExecutionStats) Reset()      { *m = ExecutionStats{} }
func (*ExecutionStats) ProtoMessage() {}
func (*ExecutionStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{0}
}
func (m *ExecutionStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecutionStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecutionStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecutionStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutionStats.Merge(m, src)
}
func (m *ExecutionStats) XXX_Size() int {
	return m.Size()
}
func (m *ExecutionStats) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutionStats.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutionStats proto.InternalMessageInfo

func (m *ExecutionStats) GetHistorySize() int64 {
	if m != nil {
		return m.HistorySize
	}
	return 0
}

// ClusterMetadata contains mutable cluster configuration and metadata.
type ClusterMetadata struct {
	ClusterName       string          `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	HistoryShardCount int32           `protobuf:"varint,2,opt,name=history_shard_count,json=historyShardCount,proto3" json:"history_shard_count,omitempty"`
	ClusterId         string          `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	VersionInfo       *v1.VersionInfo `protobuf:"bytes,4,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
}

func (m *ClusterMetadata) Reset()      { *m = ClusterMetadata{} }
func (*ClusterMetadata) ProtoMessage() {}
func (*ClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{1}
}
func (m *ClusterMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterMetadata.Merge(m, src)
}
func (m *ClusterMetadata) XXX_Size() int {
	return m.Size()
}
func (m *ClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterMetadata proto.InternalMessageInfo

func (m *ClusterMetadata) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ClusterMetadata) GetHistoryShardCount() int32 {
	if m != nil {
		return m.HistoryShardCount
	}
	return 0
}

func (m *ClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ClusterMetadata) GetVersionInfo() *v1.VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return nil
}

type ActivityInfo struct {
	Version               int64             `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	ScheduledEventBatchId int64             `protobuf:"varint,2,opt,name=scheduled_event_batch_id,json=scheduledEventBatchId,proto3" json:"scheduled_event_batch_id,omitempty"`
	ScheduledEvent        *v11.HistoryEvent `protobuf:"bytes,3,opt,name=scheduled_event,json=scheduledEvent,proto3" json:"scheduled_event,omitempty"`
	ScheduledTime         *time.Time        `protobuf:"bytes,4,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	StartedId             int64             `protobuf:"varint,5,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	StartedEvent          *v11.HistoryEvent `protobuf:"bytes,6,opt,name=started_event,json=startedEvent,proto3" json:"started_event,omitempty"`
	StartedTime           *time.Time        `protobuf:"bytes,7,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	ActivityId            string            `protobuf:"bytes,8,opt,name=activity_id,json=activityId,proto3" json:"activity_id,omitempty"`
	RequestId             string            `protobuf:"bytes,9,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	ScheduleToStartTimeout *time.Duration `protobuf:"bytes,10,opt,name=schedule_to_start_timeout,json=scheduleToStartTimeout,proto3,stdduration" json:"schedule_to_start_timeout,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	ScheduleToCloseTimeout *time.Duration `protobuf:"bytes,11,opt,name=schedule_to_close_timeout,json=scheduleToCloseTimeout,proto3,stdduration" json:"schedule_to_close_timeout,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	StartToCloseTimeout         *time.Duration `protobuf:"bytes,12,opt,name=start_to_close_timeout,json=startToCloseTimeout,proto3,stdduration" json:"start_to_close_timeout,omitempty"`
	HeartbeatTimeout            *time.Duration `protobuf:"bytes,13,opt,name=heartbeat_timeout,json=heartbeatTimeout,proto3,stdduration" json:"heartbeat_timeout,omitempty"`
	CancelRequested             bool           `protobuf:"varint,14,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	CancelRequestId             int64          `protobuf:"varint,15,opt,name=cancel_request_id,json=cancelRequestId,proto3" json:"cancel_request_id,omitempty"`
	TimerTaskStatus             int32          `protobuf:"varint,16,opt,name=timer_task_status,json=timerTaskStatus,proto3" json:"timer_task_status,omitempty"`
	Attempt                     int32          `protobuf:"varint,17,opt,name=attempt,proto3" json:"attempt,omitempty"`
	TaskQueue                   string         `protobuf:"bytes,18,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	StartedIdentity             string         `protobuf:"bytes,19,opt,name=started_identity,json=startedIdentity,proto3" json:"started_identity,omitempty"`
	HasRetryPolicy              bool           `protobuf:"varint,20,opt,name=has_retry_policy,json=hasRetryPolicy,proto3" json:"has_retry_policy,omitempty"`
	RetryInitialInterval        *time.Duration `protobuf:"bytes,21,opt,name=retry_initial_interval,json=retryInitialInterval,proto3,stdduration" json:"retry_initial_interval,omitempty"`
	RetryMaximumInterval        *time.Duration `protobuf:"bytes,22,opt,name=retry_maximum_interval,json=retryMaximumInterval,proto3,stdduration" json:"retry_maximum_interval,omitempty"`
	RetryMaximumAttempts        int32          `protobuf:"varint,23,opt,name=retry_maximum_attempts,json=retryMaximumAttempts,proto3" json:"retry_maximum_attempts,omitempty"`
	RetryExpirationTime         *time.Time     `protobuf:"bytes,24,opt,name=retry_expiration_time,json=retryExpirationTime,proto3,stdtime" json:"retry_expiration_time,omitempty"`
	RetryBackoffCoefficient     float64        `protobuf:"fixed64,25,opt,name=retry_backoff_coefficient,json=retryBackoffCoefficient,proto3" json:"retry_backoff_coefficient,omitempty"`
	RetryNonRetryableErrorTypes []string       `protobuf:"bytes,26,rep,name=retry_non_retryable_error_types,json=retryNonRetryableErrorTypes,proto3" json:"retry_non_retryable_error_types,omitempty"`
	RetryLastFailure            *v12.Failure   `protobuf:"bytes,27,opt,name=retry_last_failure,json=retryLastFailure,proto3" json:"retry_last_failure,omitempty"`
	RetryLastWorkerIdentity     string         `protobuf:"bytes,28,opt,name=retry_last_worker_identity,json=retryLastWorkerIdentity,proto3" json:"retry_last_worker_identity,omitempty"`
	NamespaceId                 string         `protobuf:"bytes,29,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	ScheduleId                  int64          `protobuf:"varint,30,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	LastHeartbeatDetails        *v13.Payloads  `protobuf:"bytes,31,opt,name=last_heartbeat_details,json=lastHeartbeatDetails,proto3" json:"last_heartbeat_details,omitempty"`
	LastHeartbeatUpdateTime     *time.Time     `protobuf:"bytes,32,opt,name=last_heartbeat_update_time,json=lastHeartbeatUpdateTime,proto3,stdtime" json:"last_heartbeat_update_time,omitempty"`
}

func (m *ActivityInfo) Reset()      { *m = ActivityInfo{} }
func (*ActivityInfo) ProtoMessage() {}
func (*ActivityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{2}
}
func (m *ActivityInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ActivityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ActivityInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ActivityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActivityInfo.Merge(m, src)
}
func (m *ActivityInfo) XXX_Size() int {
	return m.Size()
}
func (m *ActivityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ActivityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ActivityInfo proto.InternalMessageInfo

func (m *ActivityInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ActivityInfo) GetScheduledEventBatchId() int64 {
	if m != nil {
		return m.ScheduledEventBatchId
	}
	return 0
}

func (m *ActivityInfo) GetScheduledEvent() *v11.HistoryEvent {
	if m != nil {
		return m.ScheduledEvent
	}
	return nil
}

func (m *ActivityInfo) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *ActivityInfo) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *ActivityInfo) GetStartedEvent() *v11.HistoryEvent {
	if m != nil {
		return m.StartedEvent
	}
	return nil
}

func (m *ActivityInfo) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *ActivityInfo) GetActivityId() string {
	if m != nil {
		return m.ActivityId
	}
	return ""
}

func (m *ActivityInfo) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ActivityInfo) GetScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.ScheduleToStartTimeout
	}
	return nil
}

func (m *ActivityInfo) GetScheduleToCloseTimeout() *time.Duration {
	if m != nil {
		return m.ScheduleToCloseTimeout
	}
	return nil
}

func (m *ActivityInfo) GetStartToCloseTimeout() *time.Duration {
	if m != nil {
		return m.StartToCloseTimeout
	}
	return nil
}

func (m *ActivityInfo) GetHeartbeatTimeout() *time.Duration {
	if m != nil {
		return m.HeartbeatTimeout
	}
	return nil
}

func (m *ActivityInfo) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *ActivityInfo) GetCancelRequestId() int64 {
	if m != nil {
		return m.CancelRequestId
	}
	return 0
}

func (m *ActivityInfo) GetTimerTaskStatus() int32 {
	if m != nil {
		return m.TimerTaskStatus
	}
	return 0
}

func (m *ActivityInfo) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *ActivityInfo) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *ActivityInfo) GetStartedIdentity() string {
	if m != nil {
		return m.StartedIdentity
	}
	return ""
}

func (m *ActivityInfo) GetHasRetryPolicy() bool {
	if m != nil {
		return m.HasRetryPolicy
	}
	return false
}

func (m *ActivityInfo) GetRetryInitialInterval() *time.Duration {
	if m != nil {
		return m.RetryInitialInterval
	}
	return nil
}

func (m *ActivityInfo) GetRetryMaximumInterval() *time.Duration {
	if m != nil {
		return m.RetryMaximumInterval
	}
	return nil
}

func (m *ActivityInfo) GetRetryMaximumAttempts() int32 {
	if m != nil {
		return m.RetryMaximumAttempts
	}
	return 0
}

func (m *ActivityInfo) GetRetryExpirationTime() *time.Time {
	if m != nil {
		return m.RetryExpirationTime
	}
	return nil
}

func (m *ActivityInfo) GetRetryBackoffCoefficient() float64 {
	if m != nil {
		return m.RetryBackoffCoefficient
	}
	return 0
}

func (m *ActivityInfo) GetRetryNonRetryableErrorTypes() []string {
	if m != nil {
		return m.RetryNonRetryableErrorTypes
	}
	return nil
}

func (m *ActivityInfo) GetRetryLastFailure() *v12.Failure {
	if m != nil {
		return m.RetryLastFailure
	}
	return nil
}

func (m *ActivityInfo) GetRetryLastWorkerIdentity() string {
	if m != nil {
		return m.RetryLastWorkerIdentity
	}
	return ""
}

func (m *ActivityInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ActivityInfo) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *ActivityInfo) GetLastHeartbeatDetails() *v13.Payloads {
	if m != nil {
		return m.LastHeartbeatDetails
	}
	return nil
}

func (m *ActivityInfo) GetLastHeartbeatUpdateTime() *time.Time {
	if m != nil {
		return m.LastHeartbeatUpdateTime
	}
	return nil
}

type ShardInfo struct {
	ShardId             int32  `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	RangeId             int64  `protobuf:"varint,2,opt,name=range_id,json=rangeId,proto3" json:"range_id,omitempty"`
	Owner               string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	ReplicationAckLevel int64  `protobuf:"varint,4,opt,name=replication_ack_level,json=replicationAckLevel,proto3" json:"replication_ack_level,omitempty"`
	TransferAckLevel    int64  `protobuf:"varint,5,opt,name=transfer_ack_level,json=transferAckLevel,proto3" json:"transfer_ack_level,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "since" is needed here. --)
	StolenSinceRenew             int32                 `protobuf:"varint,6,opt,name=stolen_since_renew,json=stolenSinceRenew,proto3" json:"stolen_since_renew,omitempty"`
	UpdateTime                   *time.Time            `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3,stdtime" json:"update_time,omitempty"`
	TimerAckLevelTime            *time.Time            `protobuf:"bytes,8,opt,name=timer_ack_level_time,json=timerAckLevelTime,proto3,stdtime" json:"timer_ack_level_time,omitempty"`
	NamespaceNotificationVersion int64                 `protobuf:"varint,9,opt,name=namespace_notification_version,json=namespaceNotificationVersion,proto3" json:"namespace_notification_version,omitempty"`
	ClusterTransferAckLevel      map[string]int64      `protobuf:"bytes,10,rep,name=cluster_transfer_ack_level,json=clusterTransferAckLevel,proto3" json:"cluster_transfer_ack_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ClusterTimerAckLevel         map[string]*time.Time `protobuf:"bytes,11,rep,name=cluster_timer_ack_level,json=clusterTimerAckLevel,proto3,stdtime" json:"cluster_timer_ack_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ClusterReplicationLevel      map[string]int64      `protobuf:"bytes,12,rep,name=cluster_replication_level,json=clusterReplicationLevel,proto3" json:"cluster_replication_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ReplicationDlqAckLevel       map[string]int64      `protobuf:"bytes,13,rep,name=replication_dlq_ack_level,json=replicationDlqAckLevel,proto3" json:"replication_dlq_ack_level,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *ShardInfo) Reset()      { *m = ShardInfo{} }
func (*ShardInfo) ProtoMessage() {}
func (*ShardInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{3}
}
func (m *ShardInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ShardInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ShardInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ShardInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardInfo.Merge(m, src)
}
func (m *ShardInfo) XXX_Size() int {
	return m.Size()
}
func (m *ShardInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShardInfo proto.InternalMessageInfo

func (m *ShardInfo) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *ShardInfo) GetRangeId() int64 {
	if m != nil {
		return m.RangeId
	}
	return 0
}

func (m *ShardInfo) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *ShardInfo) GetReplicationAckLevel() int64 {
	if m != nil {
		return m.ReplicationAckLevel
	}
	return 0
}

func (m *ShardInfo) GetTransferAckLevel() int64 {
	if m != nil {
		return m.TransferAckLevel
	}
	return 0
}

func (m *ShardInfo) GetStolenSinceRenew() int32 {
	if m != nil {
		return m.StolenSinceRenew
	}
	return 0
}

func (m *ShardInfo) GetUpdateTime() *time.Time {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *ShardInfo) GetTimerAckLevelTime() *time.Time {
	if m != nil {
		return m.TimerAckLevelTime
	}
	return nil
}

func (m *ShardInfo) GetNamespaceNotificationVersion() int64 {
	if m != nil {
		return m.NamespaceNotificationVersion
	}
	return 0
}

func (m *ShardInfo) GetClusterTransferAckLevel() map[string]int64 {
	if m != nil {
		return m.ClusterTransferAckLevel
	}
	return nil
}

func (m *ShardInfo) GetClusterTimerAckLevel() map[string]*time.Time {
	if m != nil {
		return m.ClusterTimerAckLevel
	}
	return nil
}

func (m *ShardInfo) GetClusterReplicationLevel() map[string]int64 {
	if m != nil {
		return m.ClusterReplicationLevel
	}
	return nil
}

func (m *ShardInfo) GetReplicationDlqAckLevel() map[string]int64 {
	if m != nil {
		return m.ReplicationDlqAckLevel
	}
	return nil
}

type ReplicationTaskInfo struct {
	NamespaceId             string       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId              string       `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId                   string       `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType                v14.TaskType `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	Version                 int64        `protobuf:"varint,5,opt,name=version,proto3" json:"version,omitempty"`
	FirstEventId            int64        `protobuf:"varint,6,opt,name=first_event_id,json=firstEventId,proto3" json:"first_event_id,omitempty"`
	NextEventId             int64        `protobuf:"varint,7,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	ScheduledId             int64        `protobuf:"varint,8,opt,name=scheduled_id,json=scheduledId,proto3" json:"scheduled_id,omitempty"`
	EventStoreVersion       int32        `protobuf:"varint,9,opt,name=event_store_version,json=eventStoreVersion,proto3" json:"event_store_version,omitempty"`
	NewRunEventStoreVersion int32        `protobuf:"varint,10,opt,name=new_run_event_store_version,json=newRunEventStoreVersion,proto3" json:"new_run_event_store_version,omitempty"`
	BranchToken             []byte       `protobuf:"bytes,11,opt,name=branch_token,json=branchToken,proto3" json:"branch_token,omitempty"`
	NewRunBranchToken       []byte       `protobuf:"bytes,13,opt,name=new_run_branch_token,json=newRunBranchToken,proto3" json:"new_run_branch_token,omitempty"`
	TaskId                  int64        `protobuf:"varint,15,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
}

func (m *ReplicationTaskInfo) Reset()      { *m = ReplicationTaskInfo{} }
func (*ReplicationTaskInfo) ProtoMessage() {}
func (*ReplicationTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{4}
}
func (m *ReplicationTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationTaskInfo.Merge(m, src)
}
func (m *ReplicationTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationTaskInfo proto.InternalMessageInfo

func (m *ReplicationTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *ReplicationTaskInfo) GetTaskType() v14.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v14.TASK_TYPE_UNSPECIFIED
}

func (m *ReplicationTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ReplicationTaskInfo) GetFirstEventId() int64 {
	if m != nil {
		return m.FirstEventId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetScheduledId() int64 {
	if m != nil {
		return m.ScheduledId
	}
	return 0
}

func (m *ReplicationTaskInfo) GetEventStoreVersion() int32 {
	if m != nil {
		return m.EventStoreVersion
	}
	return 0
}

func (m *ReplicationTaskInfo) GetNewRunEventStoreVersion() int32 {
	if m != nil {
		return m.NewRunEventStoreVersion
	}
	return 0
}

func (m *ReplicationTaskInfo) GetBranchToken() []byte {
	if m != nil {
		return m.BranchToken
	}
	return nil
}

func (m *ReplicationTaskInfo) GetNewRunBranchToken() []byte {
	if m != nil {
		return m.NewRunBranchToken
	}
	return nil
}

func (m *ReplicationTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

type TimerTaskInfo struct {
	NamespaceId         string                  `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId          string                  `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId               string                  `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType            v14.TaskType            `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	TimeoutType         v15.TimeoutType         `protobuf:"varint,5,opt,name=timeout_type,json=timeoutType,proto3,enum=temporal.api.enums.v1.TimeoutType" json:"timeout_type,omitempty"`
	WorkflowBackoffType v14.WorkflowBackoffType `protobuf:"varint,6,opt,name=workflow_backoff_type,json=workflowBackoffType,proto3,enum=temporal.server.api.enums.v1.WorkflowBackoffType" json:"workflow_backoff_type,omitempty"`
	Version             int64                   `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
	ScheduleAttempt     int32                   `protobuf:"varint,8,opt,name=schedule_attempt,json=scheduleAttempt,proto3" json:"schedule_attempt,omitempty"`
	EventId             int64                   `protobuf:"varint,9,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	TaskId              int64                   `protobuf:"varint,10,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime      *time.Time              `protobuf:"bytes,11,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *TimerTaskInfo) Reset()      { *m = TimerTaskInfo{} }
func (*TimerTaskInfo) ProtoMessage() {}
func (*TimerTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{5}
}
func (m *TimerTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimerTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimerTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimerTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimerTaskInfo.Merge(m, src)
}
func (m *TimerTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *TimerTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TimerTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TimerTaskInfo proto.InternalMessageInfo

func (m *TimerTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TimerTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *TimerTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *TimerTaskInfo) GetTaskType() v14.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v14.TASK_TYPE_UNSPECIFIED
}

func (m *TimerTaskInfo) GetTimeoutType() v15.TimeoutType {
	if m != nil {
		return m.TimeoutType
	}
	return v15.TIMEOUT_TYPE_UNSPECIFIED
}

func (m *TimerTaskInfo) GetWorkflowBackoffType() v14.WorkflowBackoffType {
	if m != nil {
		return m.WorkflowBackoffType
	}
	return v14.WORKFLOW_BACKOFF_TYPE_UNSPECIFIED
}

func (m *TimerTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TimerTaskInfo) GetScheduleAttempt() int32 {
	if m != nil {
		return m.ScheduleAttempt
	}
	return 0
}

func (m *TimerTaskInfo) GetEventId() int64 {
	if m != nil {
		return m.EventId
	}
	return 0
}

func (m *TimerTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *TimerTaskInfo) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

type TransferTaskInfo struct {
	NamespaceId             string       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId              string       `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId                   string       `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	TaskType                v14.TaskType `protobuf:"varint,4,opt,name=task_type,json=taskType,proto3,enum=temporal.server.api.enums.v1.TaskType" json:"task_type,omitempty"`
	TargetNamespaceId       string       `protobuf:"bytes,5,opt,name=target_namespace_id,json=targetNamespaceId,proto3" json:"target_namespace_id,omitempty"`
	TargetWorkflowId        string       `protobuf:"bytes,6,opt,name=target_workflow_id,json=targetWorkflowId,proto3" json:"target_workflow_id,omitempty"`
	TargetRunId             string       `protobuf:"bytes,7,opt,name=target_run_id,json=targetRunId,proto3" json:"target_run_id,omitempty"`
	TaskQueue               string       `protobuf:"bytes,8,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	TargetChildWorkflowOnly bool         `protobuf:"varint,9,opt,name=target_child_workflow_only,json=targetChildWorkflowOnly,proto3" json:"target_child_workflow_only,omitempty"`
	ScheduleId              int64        `protobuf:"varint,10,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	Version                 int64        `protobuf:"varint,11,opt,name=version,proto3" json:"version,omitempty"`
	TaskId                  int64        `protobuf:"varint,12,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime          *time.Time   `protobuf:"bytes,13,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
	RecordVisibility        bool         `protobuf:"varint,14,opt,name=record_visibility,json=recordVisibility,proto3" json:"record_visibility,omitempty"`
}

func (m *TransferTaskInfo) Reset()      { *m = TransferTaskInfo{} }
func (*TransferTaskInfo) ProtoMessage() {}
func (*TransferTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{6}
}
func (m *TransferTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransferTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TransferTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TransferTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferTaskInfo.Merge(m, src)
}
func (m *TransferTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *TransferTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TransferTaskInfo proto.InternalMessageInfo

func (m *TransferTaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TransferTaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *TransferTaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *TransferTaskInfo) GetTaskType() v14.TaskType {
	if m != nil {
		return m.TaskType
	}
	return v14.TASK_TYPE_UNSPECIFIED
}

func (m *TransferTaskInfo) GetTargetNamespaceId() string {
	if m != nil {
		return m.TargetNamespaceId
	}
	return ""
}

func (m *TransferTaskInfo) GetTargetWorkflowId() string {
	if m != nil {
		return m.TargetWorkflowId
	}
	return ""
}

func (m *TransferTaskInfo) GetTargetRunId() string {
	if m != nil {
		return m.TargetRunId
	}
	return ""
}

func (m *TransferTaskInfo) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *TransferTaskInfo) GetTargetChildWorkflowOnly() bool {
	if m != nil {
		return m.TargetChildWorkflowOnly
	}
	return false
}

func (m *TransferTaskInfo) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *TransferTaskInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TransferTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *TransferTaskInfo) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

func (m *TransferTaskInfo) GetRecordVisibility() bool {
	if m != nil {
		return m.RecordVisibility
	}
	return false
}

// HistoryBranchRange represents a piece of range for a branch.
type HistoryBranchRange struct {
	// BranchId of original branch forked from.
	BranchId string `protobuf:"bytes,1,opt,name=branch_id,json=branchId,proto3" json:"branch_id,omitempty"`
	// Beginning node for the range, inclusive.
	BeginNodeId int64 `protobuf:"varint,2,opt,name=begin_node_id,json=beginNodeId,proto3" json:"begin_node_id,omitempty"`
	// Ending node for the range, exclusive.
	EndNodeId int64 `protobuf:"varint,3,opt,name=end_node_id,json=endNodeId,proto3" json:"end_node_id,omitempty"`
}

func (m *HistoryBranchRange) Reset()      { *m = HistoryBranchRange{} }
func (*HistoryBranchRange) ProtoMessage() {}
func (*HistoryBranchRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{7}
}
func (m *HistoryBranchRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryBranchRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryBranchRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryBranchRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryBranchRange.Merge(m, src)
}
func (m *HistoryBranchRange) XXX_Size() int {
	return m.Size()
}
func (m *HistoryBranchRange) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryBranchRange.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryBranchRange proto.InternalMessageInfo

func (m *HistoryBranchRange) GetBranchId() string {
	if m != nil {
		return m.BranchId
	}
	return ""
}

func (m *HistoryBranchRange) GetBeginNodeId() int64 {
	if m != nil {
		return m.BeginNodeId
	}
	return 0
}

func (m *HistoryBranchRange) GetEndNodeId() int64 {
	if m != nil {
		return m.EndNodeId
	}
	return 0
}

// For history persistence to serialize/deserialize branch details.
type HistoryBranch struct {
	TreeId    string                `protobuf:"bytes,1,opt,name=tree_id,json=treeId,proto3" json:"tree_id,omitempty"`
	BranchId  string                `protobuf:"bytes,2,opt,name=branch_id,json=branchId,proto3" json:"branch_id,omitempty"`
	Ancestors []*HistoryBranchRange `protobuf:"bytes,3,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
}

func (m *HistoryBranch) Reset()      { *m = HistoryBranch{} }
func (*HistoryBranch) ProtoMessage() {}
func (*HistoryBranch) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{8}
}
func (m *HistoryBranch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryBranch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryBranch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryBranch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryBranch.Merge(m, src)
}
func (m *HistoryBranch) XXX_Size() int {
	return m.Size()
}
func (m *HistoryBranch) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryBranch.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryBranch proto.InternalMessageInfo

func (m *HistoryBranch) GetTreeId() string {
	if m != nil {
		return m.TreeId
	}
	return ""
}

func (m *HistoryBranch) GetBranchId() string {
	if m != nil {
		return m.BranchId
	}
	return ""
}

func (m *HistoryBranch) GetAncestors() []*HistoryBranchRange {
	if m != nil {
		return m.Ancestors
	}
	return nil
}

type HistoryTreeInfo struct {
	BranchInfo *HistoryBranch `protobuf:"bytes,1,opt,name=branch_info,json=branchInfo,proto3" json:"branch_info,omitempty"`
	// For fork operation to prevent race condition of leaking event data when forking branches fail. Also can be used for clean up leaked data.
	ForkTime *time.Time `protobuf:"bytes,2,opt,name=fork_time,json=forkTime,proto3,stdtime" json:"fork_time,omitempty"`
	// For lookup back to workflow during debugging, also background cleanup when fork operation cannot finish self cleanup due to crash.
	Info string `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
}

func (m *HistoryTreeInfo) Reset()      { *m = HistoryTreeInfo{} }
func (*HistoryTreeInfo) ProtoMessage() {}
func (*HistoryTreeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{9}
}
func (m *HistoryTreeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistoryTreeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistoryTreeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistoryTreeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistoryTreeInfo.Merge(m, src)
}
func (m *HistoryTreeInfo) XXX_Size() int {
	return m.Size()
}
func (m *HistoryTreeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HistoryTreeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HistoryTreeInfo proto.InternalMessageInfo

func (m *HistoryTreeInfo) GetBranchInfo() *HistoryBranch {
	if m != nil {
		return m.BranchInfo
	}
	return nil
}

func (m *HistoryTreeInfo) GetForkTime() *time.Time {
	if m != nil {
		return m.ForkTime
	}
	return nil
}

func (m *HistoryTreeInfo) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

type TimerInfo struct {
	Version    int64      `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	StartedId  int64      `protobuf:"varint,2,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	ExpiryTime *time.Time `protobuf:"bytes,3,opt,name=expiry_time,json=expiryTime,proto3,stdtime" json:"expiry_time,omitempty"`
	TaskStatus int64      `protobuf:"varint,4,opt,name=task_status,json=taskStatus,proto3" json:"task_status,omitempty"`
	// timerId serves the purpose of indicating whether a timer task is generated for this timer info.
	TimerId string `protobuf:"bytes,5,opt,name=timer_id,json=timerId,proto3" json:"timer_id,omitempty"`
}

func (m *TimerInfo) Reset()      { *m = TimerInfo{} }
func (*TimerInfo) ProtoMessage() {}
func (*TimerInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{10}
}
func (m *TimerInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimerInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimerInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimerInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimerInfo.Merge(m, src)
}
func (m *TimerInfo) XXX_Size() int {
	return m.Size()
}
func (m *TimerInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TimerInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TimerInfo proto.InternalMessageInfo

func (m *TimerInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TimerInfo) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *TimerInfo) GetExpiryTime() *time.Time {
	if m != nil {
		return m.ExpiryTime
	}
	return nil
}

func (m *TimerInfo) GetTaskStatus() int64 {
	if m != nil {
		return m.TaskStatus
	}
	return 0
}

func (m *TimerInfo) GetTimerId() string {
	if m != nil {
		return m.TimerId
	}
	return ""
}

type TaskInfo struct {
	NamespaceId string     `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId  string     `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId       string     `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	ScheduleId  int64      `protobuf:"varint,4,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	CreateTime  *time.Time `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3,stdtime" json:"create_time,omitempty"`
	ExpiryTime  *time.Time `protobuf:"bytes,6,opt,name=expiry_time,json=expiryTime,proto3,stdtime" json:"expiry_time,omitempty"`
}

func (m *TaskInfo) Reset()      { *m = TaskInfo{} }
func (*TaskInfo) ProtoMessage() {}
func (*TaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{11}
}
func (m *TaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TaskInfo.Merge(m, src)
}
func (m *TaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *TaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TaskInfo proto.InternalMessageInfo

func (m *TaskInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TaskInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *TaskInfo) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *TaskInfo) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *TaskInfo) GetCreateTime() *time.Time {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *TaskInfo) GetExpiryTime() *time.Time {
	if m != nil {
		return m.ExpiryTime
	}
	return nil
}

type AllocatedTaskInfo struct {
	Data   *TaskInfo `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	TaskId int64     `protobuf:"varint,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
}

func (m *AllocatedTaskInfo) Reset()      { *m = AllocatedTaskInfo{} }
func (*AllocatedTaskInfo) ProtoMessage() {}
func (*AllocatedTaskInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{12}
}
func (m *AllocatedTaskInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AllocatedTaskInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AllocatedTaskInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AllocatedTaskInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocatedTaskInfo.Merge(m, src)
}
func (m *AllocatedTaskInfo) XXX_Size() int {
	return m.Size()
}
func (m *AllocatedTaskInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocatedTaskInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AllocatedTaskInfo proto.InternalMessageInfo

func (m *AllocatedTaskInfo) GetData() *TaskInfo {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *AllocatedTaskInfo) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

type TaskQueueInfo struct {
	NamespaceId    string            `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Name           string            `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	TaskType       v15.TaskQueueType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"task_type,omitempty"`
	Kind           v15.TaskQueueKind `protobuf:"varint,4,opt,name=kind,proto3,enum=temporal.api.enums.v1.TaskQueueKind" json:"kind,omitempty"`
	AckLevel       int64             `protobuf:"varint,5,opt,name=ack_level,json=ackLevel,proto3" json:"ack_level,omitempty"`
	ExpiryTime     *time.Time        `protobuf:"bytes,6,opt,name=expiry_time,json=expiryTime,proto3,stdtime" json:"expiry_time,omitempty"`
	LastUpdateTime *time.Time        `protobuf:"bytes,7,opt,name=last_update_time,json=lastUpdateTime,proto3,stdtime" json:"last_update_time,omitempty"`
}

func (m *TaskQueueInfo) Reset()      { *m = TaskQueueInfo{} }
func (*TaskQueueInfo) ProtoMessage() {}
func (*TaskQueueInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{13}
}
func (m *TaskQueueInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TaskQueueInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TaskQueueInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TaskQueueInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TaskQueueInfo.Merge(m, src)
}
func (m *TaskQueueInfo) XXX_Size() int {
	return m.Size()
}
func (m *TaskQueueInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TaskQueueInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TaskQueueInfo proto.InternalMessageInfo

func (m *TaskQueueInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *TaskQueueInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TaskQueueInfo) GetTaskType() v15.TaskQueueType {
	if m != nil {
		return m.TaskType
	}
	return v15.TASK_QUEUE_TYPE_UNSPECIFIED
}

func (m *TaskQueueInfo) GetKind() v15.TaskQueueKind {
	if m != nil {
		return m.Kind
	}
	return v15.TASK_QUEUE_KIND_UNSPECIFIED
}

func (m *TaskQueueInfo) GetAckLevel() int64 {
	if m != nil {
		return m.AckLevel
	}
	return 0
}

func (m *TaskQueueInfo) GetExpiryTime() *time.Time {
	if m != nil {
		return m.ExpiryTime
	}
	return nil
}

func (m *TaskQueueInfo) GetLastUpdateTime() *time.Time {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

type SignalInfo struct {
	Version               int64         `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	InitiatedEventBatchId int64         `protobuf:"varint,2,opt,name=initiated_event_batch_id,json=initiatedEventBatchId,proto3" json:"initiated_event_batch_id,omitempty"`
	RequestId             string        `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	Name                  string        `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	Input                 *v13.Payloads `protobuf:"bytes,5,opt,name=input,proto3" json:"input,omitempty"`
	Control               string        `protobuf:"bytes,6,opt,name=control,proto3" json:"control,omitempty"`
	InitiatedId           int64         `protobuf:"varint,7,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
}

func (m *SignalInfo) Reset()      { *m = SignalInfo{} }
func (*SignalInfo) ProtoMessage() {}
func (*SignalInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{14}
}
func (m *SignalInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignalInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignalInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignalInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignalInfo.Merge(m, src)
}
func (m *SignalInfo) XXX_Size() int {
	return m.Size()
}
func (m *SignalInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SignalInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SignalInfo proto.InternalMessageInfo

func (m *SignalInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *SignalInfo) GetInitiatedEventBatchId() int64 {
	if m != nil {
		return m.InitiatedEventBatchId
	}
	return 0
}

func (m *SignalInfo) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *SignalInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SignalInfo) GetInput() *v13.Payloads {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *SignalInfo) GetControl() string {
	if m != nil {
		return m.Control
	}
	return ""
}

func (m *SignalInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

type RequestCancelInfo struct {
	Version               int64  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	InitiatedEventBatchId int64  `protobuf:"varint,2,opt,name=initiated_event_batch_id,json=initiatedEventBatchId,proto3" json:"initiated_event_batch_id,omitempty"`
	CancelRequestId       string `protobuf:"bytes,3,opt,name=cancel_request_id,json=cancelRequestId,proto3" json:"cancel_request_id,omitempty"`
	InitiatedId           int64  `protobuf:"varint,4,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
}

func (m *RequestCancelInfo) Reset()      { *m = RequestCancelInfo{} }
func (*RequestCancelInfo) ProtoMessage() {}
func (*RequestCancelInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{15}
}
func (m *RequestCancelInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestCancelInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestCancelInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RequestCancelInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestCancelInfo.Merge(m, src)
}
func (m *RequestCancelInfo) XXX_Size() int {
	return m.Size()
}
func (m *RequestCancelInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestCancelInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RequestCancelInfo proto.InternalMessageInfo

func (m *RequestCancelInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *RequestCancelInfo) GetInitiatedEventBatchId() int64 {
	if m != nil {
		return m.InitiatedEventBatchId
	}
	return 0
}

func (m *RequestCancelInfo) GetCancelRequestId() string {
	if m != nil {
		return m.CancelRequestId
	}
	return ""
}

func (m *RequestCancelInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

type WorkflowExecutionState struct {
	CreateRequestId string                      `protobuf:"bytes,1,opt,name=create_request_id,json=createRequestId,proto3" json:"create_request_id,omitempty"`
	RunId           string                      `protobuf:"bytes,2,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	State           v14.WorkflowExecutionState  `protobuf:"varint,3,opt,name=state,proto3,enum=temporal.server.api.enums.v1.WorkflowExecutionState" json:"state,omitempty"`
	Status          v15.WorkflowExecutionStatus `protobuf:"varint,4,opt,name=status,proto3,enum=temporal.api.enums.v1.WorkflowExecutionStatus" json:"status,omitempty"`
}

func (m *WorkflowExecutionState) Reset()      { *m = WorkflowExecutionState{} }
func (*WorkflowExecutionState) ProtoMessage() {}
func (*WorkflowExecutionState) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{16}
}
func (m *WorkflowExecutionState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkflowExecutionState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkflowExecutionState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkflowExecutionState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowExecutionState.Merge(m, src)
}
func (m *WorkflowExecutionState) XXX_Size() int {
	return m.Size()
}
func (m *WorkflowExecutionState) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowExecutionState.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowExecutionState proto.InternalMessageInfo

func (m *WorkflowExecutionState) GetCreateRequestId() string {
	if m != nil {
		return m.CreateRequestId
	}
	return ""
}

func (m *WorkflowExecutionState) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *WorkflowExecutionState) GetState() v14.WorkflowExecutionState {
	if m != nil {
		return m.State
	}
	return v14.WORKFLOW_EXECUTION_STATE_UNSPECIFIED
}

func (m *WorkflowExecutionState) GetStatus() v15.WorkflowExecutionStatus {
	if m != nil {
		return m.Status
	}
	return v15.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED
}

type WorkflowExecutionInfo struct {
	NamespaceId                       string            `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId                        string            `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	ParentNamespaceId                 string            `protobuf:"bytes,3,opt,name=parent_namespace_id,json=parentNamespaceId,proto3" json:"parent_namespace_id,omitempty"`
	ParentWorkflowId                  string            `protobuf:"bytes,4,opt,name=parent_workflow_id,json=parentWorkflowId,proto3" json:"parent_workflow_id,omitempty"`
	ParentRunId                       string            `protobuf:"bytes,5,opt,name=parent_run_id,json=parentRunId,proto3" json:"parent_run_id,omitempty"`
	InitiatedId                       int64             `protobuf:"varint,6,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
	CompletionEventBatchId            int64             `protobuf:"varint,7,opt,name=completion_event_batch_id,json=completionEventBatchId,proto3" json:"completion_event_batch_id,omitempty"`
	CompletionEvent                   *v11.HistoryEvent `protobuf:"bytes,8,opt,name=completion_event,json=completionEvent,proto3" json:"completion_event,omitempty"`
	TaskQueue                         string            `protobuf:"bytes,9,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	WorkflowTypeName                  string            `protobuf:"bytes,10,opt,name=workflow_type_name,json=workflowTypeName,proto3" json:"workflow_type_name,omitempty"`
	WorkflowExecutionTimeout          *time.Duration    `protobuf:"bytes,11,opt,name=workflow_execution_timeout,json=workflowExecutionTimeout,proto3,stdduration" json:"workflow_execution_timeout,omitempty"`
	WorkflowRunTimeout                *time.Duration    `protobuf:"bytes,12,opt,name=workflow_run_timeout,json=workflowRunTimeout,proto3,stdduration" json:"workflow_run_timeout,omitempty"`
	DefaultWorkflowTaskTimeout        *time.Duration    `protobuf:"bytes,13,opt,name=default_workflow_task_timeout,json=defaultWorkflowTaskTimeout,proto3,stdduration" json:"default_workflow_task_timeout,omitempty"`
	StartVersion                      int64             `protobuf:"varint,14,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	LastEventTaskId                   int64             `protobuf:"varint,17,opt,name=last_event_task_id,json=lastEventTaskId,proto3" json:"last_event_task_id,omitempty"`
	LastFirstEventId                  int64             `protobuf:"varint,18,opt,name=last_first_event_id,json=lastFirstEventId,proto3" json:"last_first_event_id,omitempty"`
	LastProcessedEvent                int64             `protobuf:"varint,19,opt,name=last_processed_event,json=lastProcessedEvent,proto3" json:"last_processed_event,omitempty"`
	StartTime                         *time.Time        `protobuf:"bytes,20,opt,name=start_time,json=startTime,proto3,stdtime" json:"start_time,omitempty"`
	LastUpdateTime                    *time.Time        `protobuf:"bytes,21,opt,name=last_update_time,json=lastUpdateTime,proto3,stdtime" json:"last_update_time,omitempty"`
	WorkflowTaskVersion               int64             `protobuf:"varint,22,opt,name=workflow_task_version,json=workflowTaskVersion,proto3" json:"workflow_task_version,omitempty"`
	WorkflowTaskScheduleId            int64             `protobuf:"varint,23,opt,name=workflow_task_schedule_id,json=workflowTaskScheduleId,proto3" json:"workflow_task_schedule_id,omitempty"`
	WorkflowTaskStartedId             int64             `protobuf:"varint,24,opt,name=workflow_task_started_id,json=workflowTaskStartedId,proto3" json:"workflow_task_started_id,omitempty"`
	WorkflowTaskTimeout               *time.Duration    `protobuf:"bytes,25,opt,name=workflow_task_timeout,json=workflowTaskTimeout,proto3,stdduration" json:"workflow_task_timeout,omitempty"`
	WorkflowTaskAttempt               int32             `protobuf:"varint,26,opt,name=workflow_task_attempt,json=workflowTaskAttempt,proto3" json:"workflow_task_attempt,omitempty"`
	WorkflowTaskStartedTime           *time.Time        `protobuf:"bytes,27,opt,name=workflow_task_started_time,json=workflowTaskStartedTime,proto3,stdtime" json:"workflow_task_started_time,omitempty"`
	WorkflowTaskScheduledTime         *time.Time        `protobuf:"bytes,28,opt,name=workflow_task_scheduled_time,json=workflowTaskScheduledTime,proto3,stdtime" json:"workflow_task_scheduled_time,omitempty"`
	CancelRequested                   bool              `protobuf:"varint,29,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	WorkflowTaskOriginalScheduledTime *time.Time        `protobuf:"bytes,30,opt,name=workflow_task_original_scheduled_time,json=workflowTaskOriginalScheduledTime,proto3,stdtime" json:"workflow_task_original_scheduled_time,omitempty"`
	WorkflowTaskRequestId             string            `protobuf:"bytes,31,opt,name=workflow_task_request_id,json=workflowTaskRequestId,proto3" json:"workflow_task_request_id,omitempty"`
	CancelRequestId                   string            `protobuf:"bytes,32,opt,name=cancel_request_id,json=cancelRequestId,proto3" json:"cancel_request_id,omitempty"`
	StickyTaskQueue                   string            `protobuf:"bytes,33,opt,name=sticky_task_queue,json=stickyTaskQueue,proto3" json:"sticky_task_queue,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	StickyScheduleToStartTimeout *time.Duration          `protobuf:"bytes,34,opt,name=sticky_schedule_to_start_timeout,json=stickyScheduleToStartTimeout,proto3,stdduration" json:"sticky_schedule_to_start_timeout,omitempty"`
	Attempt                      int32                   `protobuf:"varint,35,opt,name=attempt,proto3" json:"attempt,omitempty"`
	RetryInitialInterval         *time.Duration          `protobuf:"bytes,36,opt,name=retry_initial_interval,json=retryInitialInterval,proto3,stdduration" json:"retry_initial_interval,omitempty"`
	RetryMaximumInterval         *time.Duration          `protobuf:"bytes,37,opt,name=retry_maximum_interval,json=retryMaximumInterval,proto3,stdduration" json:"retry_maximum_interval,omitempty"`
	RetryMaximumAttempts         int32                   `protobuf:"varint,38,opt,name=retry_maximum_attempts,json=retryMaximumAttempts,proto3" json:"retry_maximum_attempts,omitempty"`
	RetryBackoffCoefficient      float64                 `protobuf:"fixed64,39,opt,name=retry_backoff_coefficient,json=retryBackoffCoefficient,proto3" json:"retry_backoff_coefficient,omitempty"`
	RetryExpirationTime          *time.Time              `protobuf:"bytes,40,opt,name=retry_expiration_time,json=retryExpirationTime,proto3,stdtime" json:"retry_expiration_time,omitempty"`
	RetryNonRetryableErrorTypes  []string                `protobuf:"bytes,41,rep,name=retry_non_retryable_error_types,json=retryNonRetryableErrorTypes,proto3" json:"retry_non_retryable_error_types,omitempty"`
	HasRetryPolicy               bool                    `protobuf:"varint,42,opt,name=has_retry_policy,json=hasRetryPolicy,proto3" json:"has_retry_policy,omitempty"`
	CronSchedule                 string                  `protobuf:"bytes,43,opt,name=cron_schedule,json=cronSchedule,proto3" json:"cron_schedule,omitempty"`
	EventStoreVersion            int32                   `protobuf:"varint,44,opt,name=event_store_version,json=eventStoreVersion,proto3" json:"event_store_version,omitempty"`
	EventBranchToken             []byte                  `protobuf:"bytes,45,opt,name=event_branch_token,json=eventBranchToken,proto3" json:"event_branch_token,omitempty"`
	SignalCount                  int64                   `protobuf:"varint,46,opt,name=signal_count,json=signalCount,proto3" json:"signal_count,omitempty"`
	HistorySize                  int64                   `protobuf:"varint,47,opt,name=history_size,json=historySize,proto3" json:"history_size,omitempty"` // Deprecated: Do not use.
	AutoResetPoints              *v16.ResetPoints        `protobuf:"bytes,51,opt,name=auto_reset_points,json=autoResetPoints,proto3" json:"auto_reset_points,omitempty"`
	SearchAttributes             map[string]*v13.Payload `protobuf:"bytes,52,rep,name=search_attributes,json=searchAttributes,proto3" json:"search_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Memo                         map[string]*v13.Payload `protobuf:"bytes,53,rep,name=memo,proto3" json:"memo,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	VersionHistories             *v17.VersionHistories   `protobuf:"bytes,54,opt,name=version_histories,json=versionHistories,proto3" json:"version_histories,omitempty"`
	FirstExecutionRunId          string                  `protobuf:"bytes,55,opt,name=first_execution_run_id,json=firstExecutionRunId,proto3" json:"first_execution_run_id,omitempty"`
	ExecutionStats               *ExecutionStats         `protobuf:"bytes,56,opt,name=execution_stats,json=executionStats,proto3" json:"execution_stats,omitempty"`
}

func (m *WorkflowExecutionInfo) Reset()      { *m = WorkflowExecutionInfo{} }
func (*WorkflowExecutionInfo) ProtoMessage() {}
func (*WorkflowExecutionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{17}
}
func (m *WorkflowExecutionInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkflowExecutionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkflowExecutionInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkflowExecutionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowExecutionInfo.Merge(m, src)
}
func (m *WorkflowExecutionInfo) XXX_Size() int {
	return m.Size()
}
func (m *WorkflowExecutionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowExecutionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowExecutionInfo proto.InternalMessageInfo

func (m *WorkflowExecutionInfo) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentNamespaceId() string {
	if m != nil {
		return m.ParentNamespaceId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentWorkflowId() string {
	if m != nil {
		return m.ParentWorkflowId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetParentRunId() string {
	if m != nil {
		return m.ParentRunId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetCompletionEventBatchId() int64 {
	if m != nil {
		return m.CompletionEventBatchId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetCompletionEvent() *v11.HistoryEvent {
	if m != nil {
		return m.CompletionEvent
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetTaskQueue() string {
	if m != nil {
		return m.TaskQueue
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetWorkflowTypeName() string {
	if m != nil {
		return m.WorkflowTypeName
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetWorkflowExecutionTimeout() *time.Duration {
	if m != nil {
		return m.WorkflowExecutionTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowRunTimeout() *time.Duration {
	if m != nil {
		return m.WorkflowRunTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetDefaultWorkflowTaskTimeout() *time.Duration {
	if m != nil {
		return m.DefaultWorkflowTaskTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetStartVersion() int64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetLastEventTaskId() int64 {
	if m != nil {
		return m.LastEventTaskId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetLastFirstEventId() int64 {
	if m != nil {
		return m.LastFirstEventId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetLastProcessedEvent() int64 {
	if m != nil {
		return m.LastProcessedEvent
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetStartTime() *time.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetLastUpdateTime() *time.Time {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskVersion() int64 {
	if m != nil {
		return m.WorkflowTaskVersion
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskScheduleId() int64 {
	if m != nil {
		return m.WorkflowTaskScheduleId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskStartedId() int64 {
	if m != nil {
		return m.WorkflowTaskStartedId
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskTimeout() *time.Duration {
	if m != nil {
		return m.WorkflowTaskTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskAttempt() int32 {
	if m != nil {
		return m.WorkflowTaskAttempt
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskStartedTime() *time.Time {
	if m != nil {
		return m.WorkflowTaskStartedTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskScheduledTime() *time.Time {
	if m != nil {
		return m.WorkflowTaskScheduledTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskOriginalScheduledTime() *time.Time {
	if m != nil {
		return m.WorkflowTaskOriginalScheduledTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetWorkflowTaskRequestId() string {
	if m != nil {
		return m.WorkflowTaskRequestId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetCancelRequestId() string {
	if m != nil {
		return m.CancelRequestId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetStickyTaskQueue() string {
	if m != nil {
		return m.StickyTaskQueue
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetStickyScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.StickyScheduleToStartTimeout
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetRetryInitialInterval() *time.Duration {
	if m != nil {
		return m.RetryInitialInterval
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetRetryMaximumInterval() *time.Duration {
	if m != nil {
		return m.RetryMaximumInterval
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetRetryMaximumAttempts() int32 {
	if m != nil {
		return m.RetryMaximumAttempts
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetRetryBackoffCoefficient() float64 {
	if m != nil {
		return m.RetryBackoffCoefficient
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetRetryExpirationTime() *time.Time {
	if m != nil {
		return m.RetryExpirationTime
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetRetryNonRetryableErrorTypes() []string {
	if m != nil {
		return m.RetryNonRetryableErrorTypes
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetHasRetryPolicy() bool {
	if m != nil {
		return m.HasRetryPolicy
	}
	return false
}

func (m *WorkflowExecutionInfo) GetCronSchedule() string {
	if m != nil {
		return m.CronSchedule
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetEventStoreVersion() int32 {
	if m != nil {
		return m.EventStoreVersion
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetEventBranchToken() []byte {
	if m != nil {
		return m.EventBranchToken
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetSignalCount() int64 {
	if m != nil {
		return m.SignalCount
	}
	return 0
}

// Deprecated: Do not use.
func (m *WorkflowExecutionInfo) GetHistorySize() int64 {
	if m != nil {
		return m.HistorySize
	}
	return 0
}

func (m *WorkflowExecutionInfo) GetAutoResetPoints() *v16.ResetPoints {
	if m != nil {
		return m.AutoResetPoints
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetSearchAttributes() map[string]*v13.Payload {
	if m != nil {
		return m.SearchAttributes
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetMemo() map[string]*v13.Payload {
	if m != nil {
		return m.Memo
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetVersionHistories() *v17.VersionHistories {
	if m != nil {
		return m.VersionHistories
	}
	return nil
}

func (m *WorkflowExecutionInfo) GetFirstExecutionRunId() string {
	if m != nil {
		return m.FirstExecutionRunId
	}
	return ""
}

func (m *WorkflowExecutionInfo) GetExecutionStats() *ExecutionStats {
	if m != nil {
		return m.ExecutionStats
	}
	return nil
}

type Checksum struct {
	Version int32              `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Flavor  v14.ChecksumFlavor `protobuf:"varint,2,opt,name=flavor,proto3,enum=temporal.server.api.enums.v1.ChecksumFlavor" json:"flavor,omitempty"`
	Value   []byte             `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Checksum) Reset()      { *m = Checksum{} }
func (*Checksum) ProtoMessage() {}
func (*Checksum) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{18}
}
func (m *Checksum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Checksum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Checksum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Checksum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Checksum.Merge(m, src)
}
func (m *Checksum) XXX_Size() int {
	return m.Size()
}
func (m *Checksum) XXX_DiscardUnknown() {
	xxx_messageInfo_Checksum.DiscardUnknown(m)
}

var xxx_messageInfo_Checksum proto.InternalMessageInfo

func (m *Checksum) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *Checksum) GetFlavor() v14.ChecksumFlavor {
	if m != nil {
		return m.Flavor
	}
	return v14.CHECKSUM_FLAVOR_UNSPECIFIED
}

func (m *Checksum) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type ChildExecutionInfo struct {
	Version               int64                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	InitiatedEventBatchId int64                 `protobuf:"varint,2,opt,name=initiated_event_batch_id,json=initiatedEventBatchId,proto3" json:"initiated_event_batch_id,omitempty"`
	StartedId             int64                 `protobuf:"varint,3,opt,name=started_id,json=startedId,proto3" json:"started_id,omitempty"`
	InitiatedEvent        *v11.HistoryEvent     `protobuf:"bytes,4,opt,name=initiated_event,json=initiatedEvent,proto3" json:"initiated_event,omitempty"`
	StartedWorkflowId     string                `protobuf:"bytes,5,opt,name=started_workflow_id,json=startedWorkflowId,proto3" json:"started_workflow_id,omitempty"`
	StartedRunId          string                `protobuf:"bytes,6,opt,name=started_run_id,json=startedRunId,proto3" json:"started_run_id,omitempty"`
	StartedEvent          *v11.HistoryEvent     `protobuf:"bytes,7,opt,name=started_event,json=startedEvent,proto3" json:"started_event,omitempty"`
	CreateRequestId       string                `protobuf:"bytes,8,opt,name=create_request_id,json=createRequestId,proto3" json:"create_request_id,omitempty"`
	Namespace             string                `protobuf:"bytes,9,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowTypeName      string                `protobuf:"bytes,10,opt,name=workflow_type_name,json=workflowTypeName,proto3" json:"workflow_type_name,omitempty"`
	ParentClosePolicy     v15.ParentClosePolicy `protobuf:"varint,11,opt,name=parent_close_policy,json=parentClosePolicy,proto3,enum=temporal.api.enums.v1.ParentClosePolicy" json:"parent_close_policy,omitempty"`
	InitiatedId           int64                 `protobuf:"varint,12,opt,name=initiated_id,json=initiatedId,proto3" json:"initiated_id,omitempty"`
}

func (m *ChildExecutionInfo) Reset()      { *m = ChildExecutionInfo{} }
func (*ChildExecutionInfo) ProtoMessage() {}
func (*ChildExecutionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{19}
}
func (m *ChildExecutionInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ChildExecutionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ChildExecutionInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ChildExecutionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChildExecutionInfo.Merge(m, src)
}
func (m *ChildExecutionInfo) XXX_Size() int {
	return m.Size()
}
func (m *ChildExecutionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ChildExecutionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ChildExecutionInfo proto.InternalMessageInfo

func (m *ChildExecutionInfo) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ChildExecutionInfo) GetInitiatedEventBatchId() int64 {
	if m != nil {
		return m.InitiatedEventBatchId
	}
	return 0
}

func (m *ChildExecutionInfo) GetStartedId() int64 {
	if m != nil {
		return m.StartedId
	}
	return 0
}

func (m *ChildExecutionInfo) GetInitiatedEvent() *v11.HistoryEvent {
	if m != nil {
		return m.InitiatedEvent
	}
	return nil
}

func (m *ChildExecutionInfo) GetStartedWorkflowId() string {
	if m != nil {
		return m.StartedWorkflowId
	}
	return ""
}

func (m *ChildExecutionInfo) GetStartedRunId() string {
	if m != nil {
		return m.StartedRunId
	}
	return ""
}

func (m *ChildExecutionInfo) GetStartedEvent() *v11.HistoryEvent {
	if m != nil {
		return m.StartedEvent
	}
	return nil
}

func (m *ChildExecutionInfo) GetCreateRequestId() string {
	if m != nil {
		return m.CreateRequestId
	}
	return ""
}

func (m *ChildExecutionInfo) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ChildExecutionInfo) GetWorkflowTypeName() string {
	if m != nil {
		return m.WorkflowTypeName
	}
	return ""
}

func (m *ChildExecutionInfo) GetParentClosePolicy() v15.ParentClosePolicy {
	if m != nil {
		return m.ParentClosePolicy
	}
	return v15.PARENT_CLOSE_POLICY_UNSPECIFIED
}

func (m *ChildExecutionInfo) GetInitiatedId() int64 {
	if m != nil {
		return m.InitiatedId
	}
	return 0
}

type NamespaceDetail struct {
	Info                        *NamespaceInfo              `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	Config                      *NamespaceConfig            `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ReplicationConfig           *NamespaceReplicationConfig `protobuf:"bytes,3,opt,name=replication_config,json=replicationConfig,proto3" json:"replication_config,omitempty"`
	ConfigVersion               int64                       `protobuf:"varint,4,opt,name=config_version,json=configVersion,proto3" json:"config_version,omitempty"`
	FailoverNotificationVersion int64                       `protobuf:"varint,5,opt,name=failover_notification_version,json=failoverNotificationVersion,proto3" json:"failover_notification_version,omitempty"`
	FailoverVersion             int64                       `protobuf:"varint,6,opt,name=failover_version,json=failoverVersion,proto3" json:"failover_version,omitempty"`
	FailoverEndTime             *time.Time                  `protobuf:"bytes,7,opt,name=failover_end_time,json=failoverEndTime,proto3,stdtime" json:"failover_end_time,omitempty"`
}

func (m *NamespaceDetail) Reset()      { *m = NamespaceDetail{} }
func (*NamespaceDetail) ProtoMessage() {}
func (*NamespaceDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{20}
}
func (m *NamespaceDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceDetail.Merge(m, src)
}
func (m *NamespaceDetail) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceDetail.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceDetail proto.InternalMessageInfo

func (m *NamespaceDetail) GetInfo() *NamespaceInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *NamespaceDetail) GetConfig() *NamespaceConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *NamespaceDetail) GetReplicationConfig() *NamespaceReplicationConfig {
	if m != nil {
		return m.ReplicationConfig
	}
	return nil
}

func (m *NamespaceDetail) GetConfigVersion() int64 {
	if m != nil {
		return m.ConfigVersion
	}
	return 0
}

func (m *NamespaceDetail) GetFailoverNotificationVersion() int64 {
	if m != nil {
		return m.FailoverNotificationVersion
	}
	return 0
}

func (m *NamespaceDetail) GetFailoverVersion() int64 {
	if m != nil {
		return m.FailoverVersion
	}
	return 0
}

func (m *NamespaceDetail) GetFailoverEndTime() *time.Time {
	if m != nil {
		return m.FailoverEndTime
	}
	return nil
}

type NamespaceInfo struct {
	Id          string             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	State       v15.NamespaceState `protobuf:"varint,2,opt,name=state,proto3,enum=temporal.api.enums.v1.NamespaceState" json:"state,omitempty"`
	Name        string             `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Description string             `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	Owner       string             `protobuf:"bytes,5,opt,name=owner,proto3" json:"owner,omitempty"`
	Data        map[string]string  `protobuf:"bytes,6,rep,name=data,proto3" json:"data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *NamespaceInfo) Reset()      { *m = NamespaceInfo{} }
func (*NamespaceInfo) ProtoMessage() {}
func (*NamespaceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{21}
}
func (m *NamespaceInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceInfo.Merge(m, src)
}
func (m *NamespaceInfo) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceInfo proto.InternalMessageInfo

func (m *NamespaceInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NamespaceInfo) GetState() v15.NamespaceState {
	if m != nil {
		return m.State
	}
	return v15.NAMESPACE_STATE_UNSPECIFIED
}

func (m *NamespaceInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NamespaceInfo) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *NamespaceInfo) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *NamespaceInfo) GetData() map[string]string {
	if m != nil {
		return m.Data
	}
	return nil
}

type NamespaceReplicationConfig struct {
	ActiveClusterName string   `protobuf:"bytes,1,opt,name=active_cluster_name,json=activeClusterName,proto3" json:"active_cluster_name,omitempty"`
	Clusters          []string `protobuf:"bytes,2,rep,name=clusters,proto3" json:"clusters,omitempty"`
}

func (m *NamespaceReplicationConfig) Reset()      { *m = NamespaceReplicationConfig{} }
func (*NamespaceReplicationConfig) ProtoMessage() {}
func (*NamespaceReplicationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{22}
}
func (m *NamespaceReplicationConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceReplicationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceReplicationConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceReplicationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceReplicationConfig.Merge(m, src)
}
func (m *NamespaceReplicationConfig) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceReplicationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceReplicationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceReplicationConfig proto.InternalMessageInfo

func (m *NamespaceReplicationConfig) GetActiveClusterName() string {
	if m != nil {
		return m.ActiveClusterName
	}
	return ""
}

func (m *NamespaceReplicationConfig) GetClusters() []string {
	if m != nil {
		return m.Clusters
	}
	return nil
}

type NamespaceConfig struct {
	Retention               *time.Duration    `protobuf:"bytes,1,opt,name=retention,proto3,stdduration" json:"retention,omitempty"`
	ArchivalBucket          string            `protobuf:"bytes,2,opt,name=archival_bucket,json=archivalBucket,proto3" json:"archival_bucket,omitempty"`
	BadBinaries             *v18.BadBinaries  `protobuf:"bytes,3,opt,name=bad_binaries,json=badBinaries,proto3" json:"bad_binaries,omitempty"`
	HistoryArchivalState    v15.ArchivalState `protobuf:"varint,4,opt,name=history_archival_state,json=historyArchivalState,proto3,enum=temporal.api.enums.v1.ArchivalState" json:"history_archival_state,omitempty"`
	HistoryArchivalUri      string            `protobuf:"bytes,5,opt,name=history_archival_uri,json=historyArchivalUri,proto3" json:"history_archival_uri,omitempty"`
	VisibilityArchivalState v15.ArchivalState `protobuf:"varint,6,opt,name=visibility_archival_state,json=visibilityArchivalState,proto3,enum=temporal.api.enums.v1.ArchivalState" json:"visibility_archival_state,omitempty"`
	VisibilityArchivalUri   string            `protobuf:"bytes,7,opt,name=visibility_archival_uri,json=visibilityArchivalUri,proto3" json:"visibility_archival_uri,omitempty"`
}

func (m *NamespaceConfig) Reset()      { *m = NamespaceConfig{} }
func (*NamespaceConfig) ProtoMessage() {}
func (*NamespaceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{23}
}
func (m *NamespaceConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NamespaceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceConfig.Merge(m, src)
}
func (m *NamespaceConfig) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceConfig proto.InternalMessageInfo

func (m *NamespaceConfig) GetRetention() *time.Duration {
	if m != nil {
		return m.Retention
	}
	return nil
}

func (m *NamespaceConfig) GetArchivalBucket() string {
	if m != nil {
		return m.ArchivalBucket
	}
	return ""
}

func (m *NamespaceConfig) GetBadBinaries() *v18.BadBinaries {
	if m != nil {
		return m.BadBinaries
	}
	return nil
}

func (m *NamespaceConfig) GetHistoryArchivalState() v15.ArchivalState {
	if m != nil {
		return m.HistoryArchivalState
	}
	return v15.ARCHIVAL_STATE_UNSPECIFIED
}

func (m *NamespaceConfig) GetHistoryArchivalUri() string {
	if m != nil {
		return m.HistoryArchivalUri
	}
	return ""
}

func (m *NamespaceConfig) GetVisibilityArchivalState() v15.ArchivalState {
	if m != nil {
		return m.VisibilityArchivalState
	}
	return v15.ARCHIVAL_STATE_UNSPECIFIED
}

func (m *NamespaceConfig) GetVisibilityArchivalUri() string {
	if m != nil {
		return m.VisibilityArchivalUri
	}
	return ""
}

type ReplicationVersions struct {
	StartVersion     *types.Int64Value `protobuf:"bytes,1,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	LastWriteVersion *types.Int64Value `protobuf:"bytes,2,opt,name=last_write_version,json=lastWriteVersion,proto3" json:"last_write_version,omitempty"`
}

func (m *ReplicationVersions) Reset()      { *m = ReplicationVersions{} }
func (*ReplicationVersions) ProtoMessage() {}
func (*ReplicationVersions) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef806e155800e59a, []int{24}
}
func (m *ReplicationVersions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicationVersions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicationVersions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicationVersions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicationVersions.Merge(m, src)
}
func (m *ReplicationVersions) XXX_Size() int {
	return m.Size()
}
func (m *ReplicationVersions) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicationVersions.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicationVersions proto.InternalMessageInfo

func (m *ReplicationVersions) GetStartVersion() *types.Int64Value {
	if m != nil {
		return m.StartVersion
	}
	return nil
}

func (m *ReplicationVersions) GetLastWriteVersion() *types.Int64Value {
	if m != nil {
		return m.LastWriteVersion
	}
	return nil
}

func init() {
	proto.RegisterType((*ExecutionStats)(nil), "temporal.server.api.persistenceblobs.v1.ExecutionStats")
	proto.RegisterType((*ClusterMetadata)(nil), "temporal.server.api.persistenceblobs.v1.ClusterMetadata")
	proto.RegisterType((*ActivityInfo)(nil), "temporal.server.api.persistenceblobs.v1.ActivityInfo")
	proto.RegisterType((*ShardInfo)(nil), "temporal.server.api.persistenceblobs.v1.ShardInfo")
	proto.RegisterMapType((map[string]int64)(nil), "temporal.server.api.persistenceblobs.v1.ShardInfo.ClusterReplicationLevelEntry")
	proto.RegisterMapType((map[string]*time.Time)(nil), "temporal.server.api.persistenceblobs.v1.ShardInfo.ClusterTimerAckLevelEntry")
	proto.RegisterMapType((map[string]int64)(nil), "temporal.server.api.persistenceblobs.v1.ShardInfo.ClusterTransferAckLevelEntry")
	proto.RegisterMapType((map[string]int64)(nil), "temporal.server.api.persistenceblobs.v1.ShardInfo.ReplicationDlqAckLevelEntry")
	proto.RegisterType((*ReplicationTaskInfo)(nil), "temporal.server.api.persistenceblobs.v1.ReplicationTaskInfo")
	proto.RegisterType((*TimerTaskInfo)(nil), "temporal.server.api.persistenceblobs.v1.TimerTaskInfo")
	proto.RegisterType((*TransferTaskInfo)(nil), "temporal.server.api.persistenceblobs.v1.TransferTaskInfo")
	proto.RegisterType((*HistoryBranchRange)(nil), "temporal.server.api.persistenceblobs.v1.HistoryBranchRange")
	proto.RegisterType((*HistoryBranch)(nil), "temporal.server.api.persistenceblobs.v1.HistoryBranch")
	proto.RegisterType((*HistoryTreeInfo)(nil), "temporal.server.api.persistenceblobs.v1.HistoryTreeInfo")
	proto.RegisterType((*TimerInfo)(nil), "temporal.server.api.persistenceblobs.v1.TimerInfo")
	proto.RegisterType((*TaskInfo)(nil), "temporal.server.api.persistenceblobs.v1.TaskInfo")
	proto.RegisterType((*AllocatedTaskInfo)(nil), "temporal.server.api.persistenceblobs.v1.AllocatedTaskInfo")
	proto.RegisterType((*TaskQueueInfo)(nil), "temporal.server.api.persistenceblobs.v1.TaskQueueInfo")
	proto.RegisterType((*SignalInfo)(nil), "temporal.server.api.persistenceblobs.v1.SignalInfo")
	proto.RegisterType((*RequestCancelInfo)(nil), "temporal.server.api.persistenceblobs.v1.RequestCancelInfo")
	proto.RegisterType((*WorkflowExecutionState)(nil), "temporal.server.api.persistenceblobs.v1.WorkflowExecutionState")
	proto.RegisterType((*WorkflowExecutionInfo)(nil), "temporal.server.api.persistenceblobs.v1.WorkflowExecutionInfo")
	proto.RegisterMapType((map[string]*v13.Payload)(nil), "temporal.server.api.persistenceblobs.v1.WorkflowExecutionInfo.MemoEntry")
	proto.RegisterMapType((map[string]*v13.Payload)(nil), "temporal.server.api.persistenceblobs.v1.WorkflowExecutionInfo.SearchAttributesEntry")
	proto.RegisterType((*Checksum)(nil), "temporal.server.api.persistenceblobs.v1.Checksum")
	proto.RegisterType((*ChildExecutionInfo)(nil), "temporal.server.api.persistenceblobs.v1.ChildExecutionInfo")
	proto.RegisterType((*NamespaceDetail)(nil), "temporal.server.api.persistenceblobs.v1.NamespaceDetail")
	proto.RegisterType((*NamespaceInfo)(nil), "temporal.server.api.persistenceblobs.v1.NamespaceInfo")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.persistenceblobs.v1.NamespaceInfo.DataEntry")
	proto.RegisterType((*NamespaceReplicationConfig)(nil), "temporal.server.api.persistenceblobs.v1.NamespaceReplicationConfig")
	proto.RegisterType((*NamespaceConfig)(nil), "temporal.server.api.persistenceblobs.v1.NamespaceConfig")
	proto.RegisterType((*ReplicationVersions)(nil), "temporal.server.api.persistenceblobs.v1.ReplicationVersions")
}

func init() {
	proto.RegisterFile("temporal/server/api/persistenceblobs/v1/message.proto", fileDescriptor_ef806e155800e59a)
}

var fileDescriptor_ef806e155800e59a = []byte{
	// 4019 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x3b, 0x4d, 0x73, 0x1b, 0x47,
	0x76, 0x02, 0x09, 0x92, 0xc0, 0x03, 0x48, 0x00, 0x4d, 0x8a, 0x1c, 0x82, 0x12, 0x44, 0xc1, 0x92,
	0x45, 0xdb, 0x5a, 0x50, 0xa4, 0x6c, 0xc9, 0xbb, 0xca, 0x26, 0x4b, 0x52, 0xf4, 0x1a, 0x8c, 0x4c,
	0xcb, 0x43, 0xda, 0xda, 0xb8, 0xe2, 0x9a, 0x1d, 0xcc, 0x34, 0xc8, 0x29, 0x0e, 0x66, 0xe0, 0x99,
	0x01, 0x68, 0xee, 0x69, 0x73, 0xda, 0x4a, 0x65, 0x0f, 0x5b, 0x39, 0xa5, 0x2a, 0x97, 0x7c, 0x5c,
	0xf2, 0x07, 0x52, 0x39, 0xa5, 0x2a, 0x55, 0xb9, 0xe4, 0x90, 0x83, 0x8f, 0x7b, 0x48, 0x55, 0x62,
	0xf9, 0x92, 0x43, 0x52, 0xbb, 0x3f, 0x21, 0xd5, 0xaf, 0xbb, 0xe7, 0x0b, 0x43, 0x12, 0x94, 0xd6,
	0xa9, 0xda, 0x1b, 0xe6, 0x7d, 0xf5, 0xeb, 0xd7, 0xaf, 0xbb, 0xdf, 0x47, 0x03, 0xde, 0x0b, 0x68,
	0xaf, 0xef, 0x7a, 0xba, 0xbd, 0xee, 0x53, 0x6f, 0x48, 0xbd, 0x75, 0xbd, 0x6f, 0xad, 0xf7, 0xa9,
	0xe7, 0x5b, 0x7e, 0x40, 0x1d, 0x83, 0x76, 0x6c, 0xb7, 0xe3, 0xaf, 0x0f, 0x37, 0xd6, 0x7b, 0xd4,
	0xf7, 0xf5, 0x23, 0xda, 0xea, 0x7b, 0x6e, 0xe0, 0x92, 0x7b, 0x92, 0xad, 0xc5, 0xd9, 0x5a, 0x7a,
	0xdf, 0x6a, 0xa5, 0xd9, 0x5a, 0xc3, 0x8d, 0x7a, 0xe3, 0xc8, 0x75, 0x8f, 0x6c, 0xba, 0x8e, 0x6c,
	0x9d, 0x41, 0x77, 0xdd, 0x1c, 0x78, 0x7a, 0x60, 0xb9, 0x0e, 0x17, 0x54, 0xbf, 0x95, 0xc6, 0x07,
	0x56, 0x8f, 0xfa, 0x81, 0xde, 0xeb, 0x0b, 0x82, 0x11, 0x01, 0xa7, 0x9e, 0xde, 0x67, 0x23, 0x09,
	0xfc, 0x6d, 0x93, 0xf6, 0xa9, 0x63, 0x52, 0xc7, 0xb0, 0xa8, 0xbf, 0x7e, 0xe4, 0x1e, 0xb9, 0x08,
	0xc7, 0x5f, 0x82, 0xe4, 0x4e, 0x38, 0x47, 0x36, 0x39, 0xc3, 0xed, 0xf5, 0x5c, 0x67, 0x64, 0x4a,
	0x29, 0x2a, 0xea, 0x0c, 0x7a, 0x38, 0xef, 0x53, 0xd7, 0x3b, 0xe9, 0xda, 0xee, 0xa9, 0xa0, 0xba,
	0x9b, 0x4d, 0xe5, 0xe8, 0x3d, 0xea, 0xf7, 0x75, 0x43, 0x0a, 0xbb, 0x97, 0x20, 0x0b, 0xb1, 0xa3,
	0xa3, 0xbe, 0x99, 0x2d, 0x2f, 0xd0, 0xfd, 0x13, 0xed, 0xcb, 0x01, 0x1d, 0xd0, 0xcc, 0x71, 0xbb,
	0xba, 0x65, 0x0f, 0xbc, 0x0c, 0x71, 0x49, 0xb2, 0x63, 0xcb, 0x0f, 0x5c, 0xef, 0xec, 0xb2, 0x51,
	0xe5, 0x14, 0x2f, 0x13, 0x37, 0x64, 0xeb, 0x9b, 0x65, 0xba, 0xb7, 0xb2, 0x9c, 0x28, 0x9c, 0x0b,
	0x37, 0xb8, 0x20, 0x7d, 0xe7, 0x42, 0xd2, 0x94, 0xb1, 0xef, 0x5d, 0x48, 0xcc, 0x6c, 0x24, 0x08,
	0xef, 0x67, 0x11, 0x9e, 0x37, 0xfb, 0xe6, 0x43, 0x98, 0xdb, 0xfd, 0x8a, 0x1a, 0x03, 0xe6, 0x86,
	0x07, 0x81, 0x1e, 0xf8, 0xe4, 0x36, 0x94, 0x05, 0xb5, 0xe6, 0x5b, 0x3f, 0xa3, 0x4a, 0x6e, 0x35,
	0xb7, 0x36, 0xa9, 0x96, 0x04, 0xec, 0xc0, 0xfa, 0x19, 0x6d, 0xfe, 0x7b, 0x0e, 0x2a, 0x3b, 0xf6,
	0xc0, 0x0f, 0xa8, 0xf7, 0x11, 0x0d, 0x74, 0x53, 0x0f, 0x74, 0xc6, 0x66, 0x70, 0x90, 0xc6, 0x96,
	0x18, 0xd9, 0x8a, 0x6a, 0x49, 0xc0, 0xf6, 0xf5, 0x1e, 0x25, 0x2d, 0x98, 0x0f, 0x25, 0x1f, 0xeb,
	0x9e, 0xa9, 0x19, 0xee, 0xc0, 0x09, 0x94, 0x89, 0xd5, 0xdc, 0xda, 0x94, 0x5a, 0x93, 0x03, 0x30,
	0xcc, 0x0e, 0x43, 0x90, 0x9b, 0x00, 0x52, 0xa4, 0x65, 0x2a, 0x93, 0x28, 0xb0, 0x28, 0x20, 0x6d,
	0x93, 0xfc, 0x18, 0xca, 0x62, 0x15, 0x34, 0xcb, 0xe9, 0xba, 0x4a, 0x7e, 0x35, 0xb7, 0x56, 0xda,
	0xbc, 0xd3, 0x0a, 0xb7, 0x23, 0xdb, 0x87, 0x82, 0xa2, 0x35, 0xdc, 0x68, 0x7d, 0xc6, 0x7f, 0xb6,
	0x9d, 0xae, 0xab, 0x96, 0x86, 0xd1, 0x47, 0xf3, 0xaf, 0x2b, 0x50, 0xde, 0x32, 0x02, 0x6b, 0x68,
	0x05, 0x67, 0x0c, 0x40, 0x14, 0x98, 0x11, 0x78, 0x31, 0x7b, 0xf9, 0x49, 0x1e, 0x83, 0xe2, 0x1b,
	0xc7, 0xd4, 0x1c, 0xd8, 0xd4, 0xd4, 0xe8, 0x90, 0x3a, 0x81, 0xd6, 0xd1, 0x03, 0xe3, 0x98, 0x29,
	0x38, 0x81, 0xa4, 0xd7, 0x43, 0xfc, 0x2e, 0x43, 0x6f, 0x33, 0x6c, 0xdb, 0x24, 0xfb, 0x50, 0x49,
	0x31, 0xe2, 0x84, 0x4a, 0x9b, 0x77, 0x93, 0xfa, 0x0a, 0x2b, 0x30, 0x7d, 0x3f, 0xe4, 0x3f, 0x51,
	0x8c, 0x3a, 0x97, 0x14, 0x4b, 0x7e, 0x0c, 0x11, 0x44, 0x63, 0xe7, 0x84, 0x98, 0x7e, 0xbd, 0xc5,
	0xcf, 0x88, 0x96, 0x3c, 0x23, 0x5a, 0x87, 0xf2, 0x10, 0xd9, 0xce, 0xff, 0xea, 0x3f, 0x6f, 0xe5,
	0xd4, 0xd9, 0x90, 0x8f, 0x61, 0x98, 0x91, 0xfd, 0x40, 0xf7, 0x02, 0x6a, 0xb2, 0x39, 0x4c, 0xe1,
	0x1c, 0x8a, 0x02, 0xd2, 0x36, 0xc9, 0x1e, 0xcc, 0x4a, 0x34, 0xd7, 0x7a, 0xfa, 0x2a, 0x5a, 0x97,
	0x05, 0x2f, 0xd7, 0x79, 0x07, 0xe4, 0x37, 0xd7, 0x78, 0x66, 0x4c, 0x8d, 0x4b, 0x82, 0x0b, 0xf5,
	0xbd, 0x05, 0x25, 0x5d, 0xac, 0x15, 0x53, 0xb8, 0x80, 0x5e, 0x01, 0x12, 0xd4, 0x36, 0xd9, 0x84,
	0x3c, 0xfa, 0xe5, 0x80, 0xfa, 0x01, 0xc3, 0x17, 0xb9, 0xd7, 0x08, 0x48, 0xdb, 0x24, 0x9f, 0xc3,
	0xb2, 0x34, 0x80, 0x16, 0xb8, 0x1a, 0x8a, 0x46, 0x75, 0xdc, 0x41, 0xa0, 0x00, 0x6a, 0xb4, 0x3c,
	0xa2, 0xd1, 0x53, 0x71, 0x50, 0x6f, 0xe7, 0xff, 0x8a, 0x29, 0xb4, 0x28, 0x25, 0x1c, 0xba, 0x07,
	0x8c, 0xff, 0x90, 0xb3, 0xa7, 0x65, 0x1b, 0xb6, 0xeb, 0xd3, 0x50, 0x76, 0xe9, 0xca, 0xb2, 0x77,
	0x18, 0xbf, 0x94, 0x7d, 0x08, 0x8b, 0x42, 0xd7, 0xb4, 0xe0, 0xf2, 0x78, 0x82, 0xe7, 0x91, 0x3d,
	0x25, 0xf5, 0x19, 0xd4, 0x8e, 0xa9, 0xee, 0x05, 0x1d, 0xaa, 0x47, 0x56, 0x98, 0x1d, 0x4f, 0x60,
	0x35, 0xe4, 0x94, 0xd2, 0xde, 0x82, 0xaa, 0xa1, 0x3b, 0x06, 0xb5, 0x35, 0x61, 0x6f, 0x6a, 0x2a,
	0x73, 0xab, 0xb9, 0xb5, 0x82, 0x5a, 0xe1, 0x70, 0x55, 0x82, 0xc9, 0xdb, 0x50, 0x4b, 0x92, 0xb2,
	0xc5, 0xaa, 0xa0, 0xf7, 0x25, 0x69, 0xdb, 0x48, 0xcb, 0x54, 0xf3, 0x34, 0xbc, 0x09, 0xfc, 0x40,
	0x0f, 0x06, 0xbe, 0x52, 0xc5, 0x53, 0xa3, 0x82, 0x88, 0x43, 0xdd, 0x3f, 0x39, 0x40, 0x30, 0xdb,
	0xba, 0x7a, 0xc0, 0x7c, 0x33, 0x50, 0x6a, 0x48, 0x21, 0x3f, 0x99, 0x5f, 0x44, 0x37, 0x89, 0x42,
	0xb8, 0x5f, 0x30, 0xc8, 0x27, 0x0c, 0xc0, 0x74, 0x8f, 0xf6, 0x01, 0x75, 0x02, 0x2b, 0x38, 0x53,
	0xe6, 0x91, 0xa8, 0x12, 0xee, 0x06, 0x0e, 0x26, 0x6b, 0x50, 0x3d, 0xd6, 0x7d, 0xcd, 0xa3, 0x81,
	0x77, 0xa6, 0xf5, 0x5d, 0xdb, 0x32, 0xce, 0x94, 0x05, 0x9c, 0xe6, 0xdc, 0xb1, 0xee, 0xab, 0x0c,
	0xfc, 0x1c, 0xa1, 0xe4, 0x53, 0x58, 0xe4, 0x54, 0x96, 0x63, 0x05, 0x96, 0x6e, 0x6b, 0x96, 0x13,
	0x50, 0x6f, 0xa8, 0xdb, 0xca, 0xf5, 0xf1, 0x6c, 0xbc, 0x80, 0xec, 0x6d, 0xce, 0xdd, 0x16, 0xcc,
	0x91, 0xd8, 0x9e, 0xfe, 0x95, 0xd5, 0x1b, 0xf4, 0x22, 0xb1, 0x8b, 0x57, 0x11, 0xfb, 0x11, 0xe7,
	0x0e, 0xc5, 0xbe, 0x9b, 0x16, 0x2b, 0x4c, 0xe7, 0x2b, 0x4b, 0x68, 0xca, 0x04, 0xd7, 0x96, 0xc0,
	0x91, 0x43, 0xb8, 0xce, 0xb9, 0xe8, 0x57, 0x7d, 0x8b, 0x8f, 0xc2, 0xb7, 0xb7, 0x32, 0xe6, 0xf6,
	0x9e, 0x47, 0xf6, 0xdd, 0x90, 0x1b, 0xb7, 0xf9, 0x0f, 0x60, 0x99, 0x4b, 0xed, 0xe8, 0xc6, 0x89,
	0xdb, 0xed, 0x6a, 0x86, 0x4b, 0xbb, 0x5d, 0xcb, 0xb0, 0xd8, 0x19, 0xb4, 0xbc, 0x9a, 0x5b, 0xcb,
	0xa9, 0x4b, 0x48, 0xb0, 0xcd, 0xf1, 0x3b, 0x11, 0x9a, 0x3c, 0x85, 0x5b, 0x9c, 0xd7, 0x71, 0x1d,
	0xbe, 0x4a, 0x7a, 0xc7, 0xa6, 0x1a, 0xf5, 0x3c, 0xd7, 0xd3, 0x82, 0xb3, 0x3e, 0xf5, 0x95, 0xfa,
	0xea, 0xe4, 0x5a, 0x51, 0x5d, 0x41, 0xe4, 0xbe, 0xeb, 0xa8, 0x92, 0x68, 0x97, 0xd1, 0x1c, 0x32,
	0x12, 0xb2, 0x0f, 0x84, 0x4b, 0xb1, 0x75, 0x3f, 0xd0, 0x44, 0x94, 0xa1, 0xac, 0xe0, 0xa4, 0x56,
	0x93, 0xc7, 0x9f, 0x40, 0xb2, 0xe3, 0xef, 0x03, 0xfe, 0x53, 0xad, 0x22, 0xef, 0x33, 0xdd, 0x0f,
	0x04, 0x84, 0x3c, 0x81, 0x7a, 0x4c, 0x1e, 0xbb, 0xdd, 0xf1, 0x5e, 0x13, 0xae, 0x76, 0x03, 0x5d,
	0x6d, 0x29, 0xe4, 0x7a, 0x81, 0xf8, 0xd0, 0xe5, 0x6e, 0x43, 0x39, 0x0c, 0x9c, 0xd8, 0x4e, 0xb9,
	0xc9, 0x6f, 0xd7, 0x10, 0xd6, 0x36, 0xd9, 0xc1, 0x18, 0x1e, 0x3e, 0x96, 0xa9, 0x34, 0x70, 0x2f,
	0x81, 0x04, 0xb5, 0x4d, 0xf2, 0x19, 0x2c, 0xe2, 0xd0, 0xd1, 0x86, 0x37, 0x69, 0xa0, 0x5b, 0xb6,
	0xaf, 0xdc, 0xca, 0x9a, 0x94, 0x08, 0x55, 0x86, 0x1b, 0xad, 0xe7, 0xfa, 0x99, 0xed, 0xea, 0xa6,
	0xaf, 0x2e, 0x30, 0xfe, 0x0f, 0x25, 0xfb, 0x53, 0xce, 0x4d, 0xbe, 0x80, 0x7a, 0x4a, 0xee, 0xa0,
	0x6f, 0xea, 0x01, 0x3f, 0xa0, 0x94, 0xd5, 0x31, 0xbd, 0x60, 0x29, 0x21, 0xfb, 0x53, 0x94, 0xc0,
	0x68, 0x9a, 0xff, 0x02, 0x50, 0xc4, 0xa0, 0x00, 0xaf, 0xe6, 0x65, 0x28, 0xf0, 0xd8, 0xc1, 0x32,
	0xf1, 0x6e, 0x9e, 0x52, 0x67, 0xf0, 0xbb, 0x6d, 0x32, 0x94, 0xa7, 0x3b, 0x47, 0x34, 0xba, 0x8b,
	0x67, 0xf0, 0xbb, 0x6d, 0x92, 0x05, 0x98, 0x72, 0x4f, 0x1d, 0xea, 0x89, 0x20, 0x82, 0x7f, 0x90,
	0x4d, 0xe6, 0xb9, 0x7d, 0xdb, 0x32, 0xb8, 0xd3, 0xea, 0xc6, 0x89, 0x66, 0xd3, 0x21, 0xb5, 0xf1,
	0x2a, 0x9d, 0x64, 0x7e, 0x19, 0x22, 0xb7, 0x8c, 0x93, 0x67, 0x0c, 0x45, 0xee, 0x03, 0x09, 0x3c,
	0xdd, 0xf1, 0xbb, 0xd4, 0x8b, 0x31, 0xf0, 0x6b, 0xb3, 0x2a, 0x31, 0x71, 0x6a, 0x3f, 0x70, 0x6d,
	0xea, 0x68, 0xbe, 0xe5, 0x18, 0x54, 0xf3, 0xa8, 0x43, 0x4f, 0xf1, 0x0a, 0x9d, 0x52, 0xab, 0x1c,
	0x73, 0xc0, 0x10, 0x2a, 0x83, 0x93, 0x2d, 0x28, 0xc5, 0x2d, 0x37, 0xee, 0xf5, 0x08, 0x83, 0xd0,
	0x58, 0xe4, 0x13, 0x58, 0xe0, 0x47, 0x65, 0xa8, 0x1b, 0x97, 0x55, 0x18, 0x53, 0x16, 0x3f, 0x68,
	0xa5, 0xfe, 0x28, 0xf2, 0x29, 0x34, 0x22, 0xd7, 0x73, 0xdc, 0xc0, 0xea, 0x4a, 0x83, 0xc9, 0x18,
	0xa9, 0x88, 0xb3, 0xbf, 0x11, 0x52, 0xed, 0xc7, 0x88, 0x44, 0xd0, 0x45, 0x7e, 0x99, 0x83, 0xba,
	0x0c, 0xe6, 0x32, 0x0c, 0x08, 0xab, 0x93, 0x6b, 0xa5, 0xcd, 0x8f, 0x5b, 0x63, 0xa6, 0x52, 0xad,
	0xd0, 0x21, 0x5a, 0x22, 0x0e, 0x3d, 0x4c, 0x99, 0x7e, 0xd7, 0x09, 0xbc, 0x33, 0x75, 0xc9, 0xc8,
	0xc6, 0x92, 0x3f, 0xcf, 0xc1, 0x52, 0xa8, 0x4e, 0xd2, 0x60, 0x4a, 0x09, 0x75, 0x79, 0xf6, 0x1a,
	0xba, 0xc4, 0x6d, 0x88, 0x8a, 0x08, 0xeb, 0x2e, 0x18, 0x19, 0x04, 0xe4, 0x2f, 0x72, 0xb0, 0x2c,
	0x75, 0x89, 0xfb, 0x23, 0xd7, 0xa6, 0xfc, 0xba, 0x96, 0x51, 0x23, 0x91, 0x19, 0x96, 0x49, 0x63,
	0x99, 0x65, 0x96, 0xe3, 0x5a, 0x98, 0xf6, 0x97, 0x31, 0xdb, 0xcc, 0xa2, 0x36, 0xfb, 0xaf, 0xa0,
	0x4d, 0x6c, 0xa0, 0xa7, 0xf6, 0x97, 0xc9, 0x65, 0x5a, 0xf4, 0x32, 0x91, 0xf5, 0x3d, 0xb8, 0x71,
	0xd1, 0xf2, 0x92, 0x2a, 0x4c, 0x9e, 0xd0, 0x33, 0x91, 0x6a, 0xb0, 0x9f, 0x6c, 0xa3, 0x0f, 0x75,
	0x7b, 0x40, 0xc5, 0x01, 0xc0, 0x3f, 0x7e, 0x30, 0xf1, 0x7e, 0xae, 0x6e, 0xc0, 0xf2, 0xb9, 0xcb,
	0x93, 0x21, 0xe8, 0x41, 0x5c, 0xd0, 0x85, 0x3b, 0x27, 0x3e, 0x48, 0xa4, 0x70, 0xa6, 0xd5, 0xaf,
	0xa4, 0x70, 0x1b, 0x56, 0x2e, 0xb0, 0xd9, 0x55, 0x44, 0x35, 0xff, 0x3e, 0x0f, 0xf3, 0x31, 0x59,
	0x2c, 0x5c, 0xc2, 0xc3, 0x34, 0x7d, 0xab, 0xe4, 0x32, 0x6f, 0x15, 0x99, 0x88, 0xca, 0x73, 0xb5,
	0xa8, 0x82, 0x04, 0xb5, 0x4d, 0x72, 0x1d, 0xa6, 0xbd, 0x81, 0x13, 0x25, 0x68, 0x53, 0xde, 0xc0,
	0x69, 0x9b, 0x64, 0x07, 0x30, 0xb6, 0xc2, 0xeb, 0x16, 0xcf, 0xd3, 0xb9, 0xcd, 0x37, 0x33, 0xbd,
	0x06, 0x53, 0x58, 0xe6, 0x2a, 0x4c, 0x2b, 0x76, 0xf3, 0xaa, 0x85, 0x40, 0xfc, 0x8a, 0xe7, 0x61,
	0x53, 0xc9, 0x3c, 0xec, 0x0e, 0xcc, 0x75, 0x2d, 0xcf, 0x0f, 0x44, 0x0e, 0x66, 0x99, 0x78, 0xa8,
	0x4e, 0xaa, 0x65, 0x84, 0x62, 0xba, 0xd1, 0x36, 0x49, 0x13, 0x66, 0x1d, 0xfa, 0x55, 0x8c, 0x68,
	0x86, 0xe7, 0xb2, 0x0c, 0x28, 0x69, 0x6e, 0x43, 0x39, 0x4a, 0xa4, 0x44, 0x42, 0x31, 0xa9, 0x86,
	0x57, 0x29, 0xbb, 0x58, 0x5a, 0x30, 0xcf, 0x25, 0xb0, 0xcc, 0x86, 0x26, 0x8e, 0xbd, 0x29, 0xb5,
	0x86, 0xa8, 0x03, 0x86, 0x91, 0x67, 0xdd, 0x1f, 0xc0, 0x8a, 0x43, 0x4f, 0x35, 0x66, 0x96, 0x2c,
	0x3e, 0x40, 0xbe, 0x25, 0x87, 0x9e, 0xaa, 0x03, 0x67, 0x77, 0x84, 0xfb, 0x36, 0x94, 0x3b, 0x9e,
	0xee, 0x18, 0xc7, 0x5a, 0xe0, 0x9e, 0x50, 0x07, 0xf3, 0x86, 0xb2, 0x5a, 0xe2, 0xb0, 0x43, 0x06,
	0x22, 0xeb, 0xb0, 0x20, 0x07, 0x48, 0x90, 0xce, 0x22, 0x69, 0x8d, 0x4b, 0xde, 0x8e, 0x31, 0x2c,
	0xc1, 0x0c, 0xae, 0x46, 0x18, 0x63, 0x4f, 0xb3, 0xcf, 0xb6, 0xb9, 0x97, 0x2f, 0x94, 0xab, 0xb3,
	0x7b, 0xf9, 0xc2, 0x5c, 0xb5, 0xd2, 0xfc, 0xdb, 0x3c, 0xcc, 0x1e, 0xca, 0x70, 0xfa, 0xf7, 0xc2,
	0x3f, 0x76, 0xa1, 0x2c, 0x72, 0x16, 0x2e, 0x67, 0x0a, 0xe5, 0x34, 0x93, 0x71, 0x4c, 0x24, 0x80,
	0x93, 0xa2, 0x8c, 0x52, 0x10, 0x7d, 0x10, 0x0a, 0xd7, 0xc3, 0x39, 0xc8, 0x70, 0x13, 0xe5, 0x4d,
	0xa3, 0xbc, 0x8d, 0x8b, 0xf5, 0x7a, 0x21, 0x58, 0x45, 0x20, 0x8a, 0xe2, 0xe7, 0x4f, 0x47, 0x81,
	0x71, 0x6f, 0x9e, 0x49, 0x7a, 0x33, 0xcb, 0x3d, 0x64, 0xe8, 0x26, 0xb3, 0x97, 0x02, 0xcf, 0x6f,
	0x24, 0x5c, 0x84, 0xdb, 0x2c, 0xc8, 0x09, 0xbd, 0x99, 0xdf, 0xbb, 0x33, 0x54, 0x78, 0x72, 0x6c,
	0x91, 0x21, 0xbe, 0xc8, 0xa4, 0x0d, 0x95, 0xa1, 0xe5, 0x5b, 0x1d, 0xcb, 0x66, 0x49, 0x33, 0xc6,
	0x03, 0xa5, 0x31, 0xe3, 0x81, 0xb9, 0x88, 0x11, 0x83, 0xb1, 0xff, 0xc8, 0x43, 0x55, 0x9e, 0xc5,
	0xbf, 0x37, 0x6e, 0xd2, 0x82, 0xf9, 0x40, 0xf7, 0x8e, 0x68, 0xa0, 0x25, 0xd4, 0x9c, 0xc2, 0x81,
	0x6a, 0x1c, 0xb5, 0x1f, 0x53, 0x96, 0xc5, 0x78, 0x9c, 0x3e, 0xae, 0xf3, 0x34, 0x92, 0x57, 0x39,
	0xe6, 0x45, 0xa4, 0x79, 0x13, 0x66, 0x05, 0xb5, 0x98, 0xc0, 0x0c, 0x9f, 0x3e, 0x07, 0xaa, 0x38,
	0x8d, 0x64, 0xee, 0x59, 0x48, 0xe7, 0x9e, 0x4f, 0xa0, 0x2e, 0x44, 0x18, 0xc7, 0x96, 0x6d, 0x46,
	0xc3, 0xba, 0x8e, 0x7d, 0x86, 0xcb, 0x5c, 0x50, 0x97, 0x38, 0xc5, 0x0e, 0x23, 0x90, 0xa3, 0x7f,
	0xec, 0xd8, 0x67, 0xe9, 0xb8, 0x1f, 0x46, 0xe2, 0xfe, 0x98, 0xdf, 0x95, 0x92, 0x7e, 0x17, 0xf3,
	0x98, 0xf2, 0x65, 0x1e, 0x33, 0xfb, 0x6a, 0x1e, 0x43, 0xde, 0x81, 0x9a, 0x47, 0x0d, 0xd7, 0x33,
	0xb5, 0x08, 0x21, 0x8a, 0x02, 0x55, 0x8e, 0xf8, 0x2c, 0x84, 0x37, 0x07, 0x40, 0x44, 0xfd, 0x88,
	0x9f, 0x5e, 0x2a, 0x8b, 0xdf, 0xc9, 0x0a, 0x14, 0xc5, 0x31, 0x17, 0x3a, 0x57, 0x81, 0x03, 0xb8,
	0xf9, 0x3b, 0xf4, 0xc8, 0x72, 0x34, 0xc7, 0x35, 0x63, 0xa1, 0x7f, 0x09, 0x81, 0xfb, 0xae, 0xc9,
	0x2c, 0xd0, 0x80, 0x12, 0x75, 0xcc, 0x90, 0x62, 0x92, 0x17, 0xb9, 0xa8, 0x63, 0x72, 0x7c, 0xf3,
	0x6f, 0x72, 0x30, 0x9b, 0x18, 0x17, 0x2d, 0xe3, 0xd1, 0x98, 0x37, 0x4f, 0xb3, 0xcf, 0xb6, 0x99,
	0xd4, 0x65, 0x22, 0xa5, 0xcb, 0x9f, 0x40, 0x51, 0x77, 0x0c, 0xca, 0x04, 0xf9, 0xca, 0x24, 0x86,
	0x4a, 0x4f, 0xc6, 0x0e, 0x95, 0x46, 0x27, 0xae, 0x46, 0xd2, 0x9a, 0xff, 0x9c, 0x83, 0x8a, 0xa0,
	0x38, 0x64, 0x9a, 0xb0, 0x7d, 0xf7, 0x02, 0x4a, 0x52, 0x17, 0xa7, 0xeb, 0xa2, 0xa2, 0xa5, 0xcd,
	0x47, 0xaf, 0x38, 0x20, 0x88, 0x59, 0x30, 0xc1, 0x3f, 0x84, 0x62, 0xd7, 0xf5, 0x4e, 0xf8, 0xc2,
	0x4f, 0x8c, 0xb9, 0xf0, 0x05, 0xc6, 0x82, 0x4b, 0x4e, 0x20, 0x8f, 0x0a, 0xf1, 0x9d, 0x8c, 0xbf,
	0x9b, 0xff, 0x9a, 0x83, 0x22, 0x5e, 0x2e, 0x97, 0x14, 0x58, 0x93, 0xe5, 0xc8, 0x89, 0x74, 0x39,
	0x72, 0x0b, 0x4a, 0x58, 0x66, 0x10, 0x4e, 0x39, 0x39, 0x6e, 0x8a, 0xc4, 0x99, 0x64, 0x01, 0x31,
	0x5e, 0x47, 0xe2, 0xb9, 0x1e, 0x6e, 0x4f, 0x51, 0x42, 0x5a, 0x86, 0x02, 0x4f, 0x09, 0xc2, 0x33,
	0x62, 0x06, 0xbf, 0xdb, 0x66, 0xf3, 0x97, 0x13, 0x50, 0xf8, 0xff, 0x38, 0xf6, 0x52, 0x7b, 0x3a,
	0x3f, 0xb2, 0xa7, 0xb7, 0xa0, 0x64, 0x78, 0x34, 0x4c, 0x15, 0xa7, 0xc6, 0xb5, 0x03, 0x67, 0x42,
	0x3b, 0xa4, 0x4c, 0x39, 0x7d, 0x75, 0x53, 0x36, 0x7d, 0xa8, 0x6d, 0xd9, 0xb6, 0x6b, 0xe8, 0x01,
	0x35, 0x43, 0xb3, 0xec, 0x42, 0xde, 0xd4, 0x03, 0x5d, 0xb8, 0xe3, 0xc6, 0xd8, 0xee, 0x28, 0x05,
	0xa8, 0xc8, 0x1e, 0x3f, 0x9b, 0x26, 0xe2, 0x67, 0x53, 0xf3, 0x37, 0x13, 0x30, 0x7b, 0x28, 0x8f,
	0xce, 0x71, 0x17, 0x82, 0x40, 0x1e, 0xbb, 0x12, 0x7c, 0x05, 0xf0, 0x37, 0xd9, 0x8a, 0xdf, 0x2d,
	0x93, 0x78, 0xb7, 0xdc, 0x39, 0x2f, 0x74, 0x90, 0xe3, 0xa5, 0x6e, 0x96, 0xf7, 0x21, 0x7f, 0x62,
	0x39, 0xa6, 0xb8, 0x99, 0x2e, 0xe5, 0xfe, 0x63, 0xcb, 0x31, 0x55, 0xe4, 0x60, 0xe7, 0x48, 0xba,
	0x7c, 0x50, 0xd0, 0x65, 0x46, 0xf8, 0xfa, 0x4b, 0x43, 0xf6, 0xa0, 0x8a, 0x45, 0x99, 0x57, 0x29,
	0x28, 0xcc, 0x31, 0xce, 0x58, 0x05, 0xe6, 0x17, 0x13, 0x00, 0x07, 0xd6, 0x91, 0xa3, 0xdb, 0x97,
	0x77, 0x47, 0x78, 0xa1, 0x33, 0x38, 0xb7, 0x3b, 0x12, 0xe2, 0x13, 0xdd, 0x91, 0x64, 0xcd, 0x7e,
	0x32, 0x5d, 0xb3, 0x97, 0xab, 0x97, 0x8f, 0xad, 0xde, 0x23, 0x98, 0xb2, 0x9c, 0xfe, 0x20, 0x10,
	0xbe, 0x7f, 0x79, 0xf1, 0x8a, 0x93, 0x33, 0xed, 0x0d, 0xd7, 0x09, 0x3c, 0xd7, 0x16, 0x37, 0xba,
	0xfc, 0x64, 0x6e, 0x14, 0x69, 0x1f, 0x25, 0x0b, 0x21, 0xac, 0x6d, 0x36, 0xff, 0x31, 0x07, 0x35,
	0x51, 0x97, 0xde, 0xc1, 0x22, 0xf5, 0x77, 0x65, 0x90, 0xcc, 0xf2, 0x38, 0xb7, 0xcb, 0x48, 0x79,
	0x3c, 0xad, 0x77, 0x7e, 0x54, 0xef, 0xdf, 0xe4, 0x60, 0x51, 0x06, 0x0d, 0x89, 0x76, 0x1f, 0xc5,
	0x91, 0xf8, 0x49, 0x12, 0x1b, 0x29, 0x27, 0x46, 0x42, 0x44, 0x34, 0x52, 0x74, 0x5a, 0x4d, 0xc4,
	0x4f, 0xab, 0x3d, 0x98, 0x62, 0x87, 0xa9, 0xdc, 0x44, 0xef, 0x8e, 0x17, 0x2f, 0x27, 0xf5, 0x50,
	0xb9, 0x08, 0xf2, 0x01, 0x4c, 0xc7, 0x0e, 0xe6, 0xb9, 0xcd, 0xd6, 0x39, 0x7b, 0x2a, 0x53, 0xca,
	0xc0, 0x57, 0x05, 0x77, 0xf3, 0x2f, 0x57, 0xe0, 0xfa, 0x08, 0xcd, 0xef, 0xec, 0xd8, 0x6e, 0xc1,
	0x7c, 0x5f, 0xf7, 0xd8, 0x72, 0x26, 0x44, 0xf1, 0x05, 0xaa, 0x71, 0x54, 0x2a, 0xa2, 0x14, 0xf4,
	0x71, 0xb9, 0xdc, 0x9d, 0xab, 0x1c, 0x93, 0x8c, 0x28, 0x05, 0xb5, 0xb0, 0x36, 0xbf, 0x85, 0x4a,
	0x1c, 0xc8, 0x23, 0xca, 0xf4, 0xa2, 0x4f, 0x8f, 0x2c, 0x3a, 0xf9, 0x3e, 0x2c, 0x1b, 0x6e, 0xaf,
	0x6f, 0x53, 0xac, 0xe3, 0xa4, 0xbc, 0x8f, 0x3b, 0xf7, 0x62, 0x44, 0x90, 0x70, 0xbf, 0xe7, 0x50,
	0x4d, 0xb3, 0x8a, 0x12, 0xe2, 0x98, 0x8d, 0xbf, 0x4a, 0x4a, 0x70, 0x2a, 0x02, 0x2e, 0xa6, 0x23,
	0xe0, 0xfb, 0x40, 0x42, 0xcb, 0xb0, 0xf3, 0x98, 0xf7, 0x90, 0x81, 0x1b, 0x48, 0x62, 0xd8, 0x91,
	0x8b, 0x8d, 0xe4, 0x2f, 0xa0, 0x1e, 0x52, 0x53, 0xb9, 0xb8, 0x57, 0x6d, 0xb4, 0x29, 0xa7, 0x69,
	0xf7, 0x90, 0x6d, 0xac, 0x4f, 0x60, 0x21, 0x14, 0xcf, 0x56, 0xe0, 0x8a, 0x8d, 0xb6, 0x70, 0x26,
	0xea, 0x20, 0x14, 0xd9, 0x81, 0x9b, 0x26, 0xed, 0xea, 0x03, 0x3b, 0xe6, 0x01, 0xfc, 0xf2, 0xb9,
	0x5a, 0xcf, 0xad, 0x2e, 0xa4, 0x48, 0x6f, 0xc1, 0x6c, 0x47, 0x8c, 0xf1, 0x86, 0x68, 0xd5, 0x86,
	0x85, 0x86, 0x39, 0x5e, 0x12, 0x41, 0xa0, 0xac, 0x2e, 0xbc, 0x03, 0x04, 0xef, 0x05, 0xee, 0x0e,
	0xf2, 0x86, 0xad, 0xf1, 0xc6, 0x1b, 0xc3, 0xe0, 0x72, 0x1d, 0xf2, 0x34, 0xe0, 0x7b, 0x30, 0xcf,
	0x9b, 0x1f, 0xc9, 0x52, 0x0b, 0xe1, 0xd5, 0x6e, 0x86, 0xfa, 0x20, 0x5e, 0x6e, 0x79, 0x00, 0xd8,
	0x20, 0xd0, 0xfa, 0x9e, 0x6b, 0x50, 0xdf, 0x0f, 0x5b, 0xc6, 0xf3, 0x48, 0x8f, 0xe3, 0x3e, 0x97,
	0x28, 0xee, 0x15, 0x7f, 0x24, 0xa2, 0x3d, 0x7e, 0x3f, 0x2d, 0x8c, 0x79, 0x3f, 0xf1, 0x78, 0xf0,
	0xdc, 0x6b, 0xee, 0xfa, 0xab, 0x5d, 0x73, 0x64, 0x33, 0x56, 0x06, 0x40, 0xc3, 0x48, 0x3b, 0x2e,
	0xf2, 0x76, 0xc0, 0x69, 0xcc, 0xe6, 0xd2, 0x9c, 0xdf, 0x87, 0xe5, 0x24, 0x4f, 0x3c, 0x6c, 0x5b,
	0xe2, 0x7b, 0x2c, 0xce, 0x77, 0x10, 0x85, 0x70, 0x8f, 0x41, 0x49, 0xb1, 0x46, 0x71, 0xaf, 0xc2,
	0xef, 0x86, 0x04, 0x67, 0x18, 0x03, 0x1f, 0xa4, 0xf5, 0x94, 0x3e, 0xb4, 0x3c, 0x66, 0x23, 0xf8,
	0x34, 0xc3, 0x79, 0x46, 0x26, 0x2f, 0xeb, 0x10, 0x75, 0xac, 0x43, 0x24, 0x78, 0x64, 0x2d, 0x22,
	0xbe, 0x0d, 0x13, 0x33, 0xc0, 0x65, 0x58, 0x19, 0xb7, 0xf1, 0x93, 0x31, 0x4b, 0x5c, 0x0f, 0x1d,
	0x6e, 0x64, 0xdb, 0x56, 0x0c, 0x70, 0x63, 0xcc, 0x01, 0x96, 0xb3, 0x16, 0x80, 0x0f, 0x91, 0xd5,
	0xb0, 0xbe, 0x99, 0xdd, 0xb0, 0xf6, 0xe0, 0x6e, 0x52, 0x1b, 0xd7, 0xb3, 0x8e, 0x2c, 0x47, 0xb7,
	0xd3, 0x6a, 0x35, 0xc6, 0x54, 0xeb, 0x76, 0x5c, 0xad, 0x8f, 0x85, 0xb0, 0xa4, 0x7a, 0x23, 0x2e,
	0x12, 0xbb, 0xa2, 0x6f, 0xe1, 0xd9, 0x98, 0x70, 0x91, 0x44, 0xc7, 0x7c, 0x34, 0x7c, 0x58, 0xcd,
	0x0e, 0x1f, 0xde, 0x86, 0x9a, 0x1f, 0x58, 0xc6, 0xc9, 0x99, 0x16, 0x3b, 0xa0, 0x6f, 0xcb, 0xce,
	0x37, 0x43, 0x84, 0xf1, 0x2b, 0x39, 0x82, 0x55, 0x41, 0x7b, 0xfe, 0x1b, 0x8a, 0xe6, 0x78, 0x5e,
	0x78, 0x83, 0x0b, 0x3a, 0xc8, 0x7e, 0x49, 0x11, 0x6b, 0xe3, 0xbf, 0x91, 0x6c, 0xe3, 0x9f, 0xdf,
	0x52, 0xbf, 0xf3, 0xdd, 0xb4, 0xd4, 0xef, 0x7e, 0x37, 0x2d, 0xf5, 0x37, 0x2f, 0x68, 0xa9, 0x5f,
	0xd8, 0xfc, 0xbe, 0x77, 0x71, 0xf3, 0xfb, 0xdc, 0x76, 0xfc, 0xda, 0xeb, 0xb4, 0xe3, 0xc7, 0x68,
	0xa9, 0xbf, 0x75, 0x79, 0x4b, 0x3d, 0xeb, 0xe1, 0xc4, 0xdb, 0x99, 0x0f, 0x27, 0xde, 0x80, 0x59,
	0xc3, 0x73, 0x9d, 0xd0, 0xcd, 0x94, 0x77, 0xd0, 0x21, 0xcb, 0x0c, 0x28, 0x5d, 0xe6, 0xbc, 0xba,
	0xfc, 0xfd, 0xf3, 0xea, 0xf2, 0xf7, 0x81, 0x88, 0x28, 0x28, 0x5e, 0x34, 0xff, 0x1e, 0x16, 0xcd,
	0xab, 0x88, 0x89, 0xd7, 0xcc, 0x6f, 0x43, 0xd9, 0xc7, 0xa4, 0x47, 0x3c, 0x53, 0x6b, 0x89, 0xc6,
	0x00, 0xc2, 0xf8, 0x03, 0xb5, 0xbb, 0xa9, 0xa7, 0x72, 0xeb, 0x8c, 0x64, 0x7b, 0x42, 0xc9, 0x25,
	0x9e, 0xcb, 0x91, 0x4f, 0xa0, 0xa6, 0x0f, 0x02, 0x57, 0xf3, 0xa8, 0x4f, 0x03, 0xad, 0xef, 0x5a,
	0x4e, 0xe0, 0x2b, 0x0f, 0xb3, 0xc2, 0xa9, 0xf0, 0xcd, 0xdf, 0x70, 0xa3, 0xa5, 0x32, 0xea, 0xe7,
	0x48, 0xac, 0x56, 0x18, 0x7f, 0x0c, 0x40, 0xfe, 0x2c, 0x07, 0x35, 0x9f, 0xea, 0x9e, 0x71, 0xcc,
	0x3c, 0xca, 0xb3, 0x3a, 0x83, 0x80, 0xfa, 0xca, 0xbb, 0x58, 0x72, 0x3a, 0x1c, 0x3b, 0xe5, 0xce,
	0x0c, 0x90, 0x5b, 0x07, 0x28, 0x77, 0x2b, 0x14, 0xcb, 0x7b, 0x74, 0x55, 0x3f, 0x05, 0x26, 0x7f,
	0x0a, 0xf9, 0x1e, 0xed, 0xb9, 0xca, 0x7b, 0x38, 0xea, 0x87, 0xaf, 0x39, 0xea, 0x47, 0xb4, 0xe7,
	0xf2, 0x91, 0x50, 0x2a, 0xf9, 0x02, 0x6a, 0xf2, 0x75, 0x1f, 0xb7, 0xa5, 0x45, 0x7d, 0xe5, 0x11,
	0x1a, 0xed, 0x41, 0xe6, 0x50, 0xb1, 0x50, 0x54, 0x2c, 0xf8, 0x87, 0x92, 0x4f, 0xad, 0x0e, 0x53,
	0x10, 0xf2, 0x10, 0x16, 0x45, 0x54, 0x13, 0xc6, 0x8f, 0x22, 0xd8, 0x7e, 0x8c, 0x9e, 0x36, 0xcf,
	0x1b, 0x49, 0x12, 0xc9, 0x83, 0xee, 0x9f, 0x42, 0x25, 0x22, 0x67, 0x89, 0x86, 0xaf, 0xbc, 0x8f,
	0x1a, 0x3d, 0x1e, 0x7b, 0xf2, 0xc9, 0xc7, 0x96, 0xea, 0x1c, 0x4d, 0x7c, 0xd7, 0x4d, 0xb8, 0x9e,
	0x69, 0xfe, 0x8c, 0x76, 0xdf, 0x7b, 0xc9, 0x0e, 0xe5, 0xad, 0x4b, 0x12, 0xe0, 0x78, 0x6b, 0xf1,
	0x27, 0x50, 0x0c, 0xcd, 0xfd, 0x3b, 0x95, 0xbc, 0x97, 0x2f, 0x54, 0xaa, 0xd5, 0xbd, 0x7c, 0xa1,
	0x5a, 0xad, 0xed, 0xe5, 0x0b, 0x0f, 0xaa, 0x1b, 0x7b, 0xf9, 0xc2, 0x46, 0x75, 0x73, 0x2f, 0x5f,
	0xd8, 0xac, 0x3e, 0x6c, 0xfe, 0x3c, 0x07, 0x85, 0x9d, 0x63, 0x6a, 0x9c, 0xf8, 0x83, 0x5e, 0x3a,
	0x6b, 0x9e, 0x8a, 0xb2, 0xe6, 0xa7, 0x30, 0xdd, 0xb5, 0xf5, 0xa1, 0xeb, 0xa1, 0x02, 0x73, 0x9b,
	0xf7, 0x2f, 0x4e, 0x28, 0xa5, 0xc4, 0x0f, 0x90, 0x47, 0x15, 0xbc, 0x51, 0x3b, 0x74, 0x12, 0x37,
	0x38, 0xff, 0x68, 0xfe, 0x6f, 0x1e, 0x08, 0xd6, 0xd0, 0x93, 0x49, 0xe1, 0x77, 0x53, 0xd3, 0x88,
	0x45, 0x74, 0x93, 0xe9, 0x4a, 0xe6, 0x3e, 0x54, 0x52, 0x72, 0xc5, 0x0b, 0xce, 0x71, 0x1f, 0x84,
	0x26, 0x47, 0x65, 0x87, 0xa1, 0x1c, 0x2e, 0x9e, 0x63, 0x8a, 0x26, 0x87, 0x40, 0xc5, 0x92, 0xcc,
	0x3b, 0x30, 0x27, 0xe9, 0x85, 0xe3, 0xf3, 0x72, 0x88, 0x7c, 0xa2, 0xa9, 0x8a, 0xd4, 0x3e, 0xf5,
	0xfc, 0x73, 0xe6, 0xd5, 0x9f, 0x7f, 0x66, 0x56, 0x1a, 0x0a, 0xd9, 0x95, 0x86, 0x1b, 0x50, 0x0c,
	0x33, 0x6b, 0x99, 0x2d, 0x86, 0x80, 0x2b, 0x66, 0x8b, 0x3f, 0x09, 0x93, 0x75, 0xfe, 0x6e, 0x52,
	0x5c, 0x3c, 0x25, 0xf4, 0xad, 0xb5, 0x73, 0xea, 0x0b, 0xcf, 0x91, 0x03, 0xdf, 0x4a, 0xf2, 0x2b,
	0x49, 0xa6, 0xf5, 0x31, 0xd0, 0x48, 0x12, 0x5e, 0x1e, 0xad, 0xbc, 0xfc, 0x22, 0x0f, 0x95, 0xb0,
	0x12, 0xc0, 0x5f, 0x4c, 0x91, 0x3d, 0x51, 0x1f, 0xbf, 0x6a, 0xc1, 0x3e, 0xaa, 0x28, 0x60, 0x99,
	0x94, 0xc9, 0x20, 0xcf, 0x61, 0xda, 0x70, 0x9d, 0xae, 0x75, 0x24, 0x36, 0xeb, 0xfb, 0x57, 0x97,
	0xb6, 0x83, 0xfc, 0xaa, 0x90, 0x43, 0x3c, 0x20, 0xf1, 0xf7, 0x1f, 0x42, 0x3a, 0xaf, 0xb4, 0xef,
	0x5c, 0x5d, 0x7a, 0xec, 0xdd, 0x81, 0x18, 0xa8, 0xe6, 0xa5, 0x41, 0xe4, 0x2e, 0xcc, 0xf1, 0x71,
	0xc2, 0x4b, 0x9c, 0x17, 0xb1, 0x66, 0x39, 0x54, 0x5e, 0xe0, 0xdb, 0x70, 0xb3, 0xab, 0x5b, 0xb6,
	0x3b, 0xa4, 0x5e, 0xf6, 0x4b, 0x24, 0x5e, 0x48, 0x5d, 0x91, 0x44, 0x59, 0x0f, 0x91, 0xde, 0x82,
	0x6a, 0x28, 0x43, 0xb2, 0xf1, 0xe2, 0x49, 0x45, 0xc2, 0x25, 0xe9, 0x33, 0xa8, 0x85, 0xa4, 0xd4,
	0xb9, 0xe2, 0xa3, 0xe5, 0x50, 0xda, 0xae, 0x83, 0xc1, 0x7c, 0xf3, 0x9f, 0x26, 0x60, 0x36, 0xb1,
	0x82, 0x64, 0x0e, 0x26, 0xc2, 0xfa, 0xd3, 0x84, 0x65, 0x92, 0x27, 0xb2, 0x8e, 0xc6, 0x8f, 0xbd,
	0xbb, 0xe7, 0xb8, 0x66, 0x28, 0x24, 0x51, 0x38, 0x93, 0x35, 0xd2, 0xc9, 0x58, 0x8d, 0x74, 0x15,
	0x4a, 0x26, 0xf5, 0x0d, 0xcf, 0xea, 0x07, 0xd2, 0xa6, 0x45, 0x35, 0x0e, 0x8a, 0x1e, 0xc6, 0x4d,
	0xc5, 0x1f, 0xc6, 0x1d, 0x8a, 0x12, 0xfe, 0x34, 0xde, 0xec, 0x3f, 0x7a, 0x35, 0x07, 0x6d, 0x3d,
	0xd5, 0x03, 0x5d, 0xdc, 0xe8, 0x4c, 0x5a, 0xfd, 0x31, 0x14, 0x43, 0xd0, 0x65, 0xcf, 0x57, 0x8a,
	0xf1, 0xe7, 0x2b, 0xc7, 0x50, 0x3f, 0xdf, 0x9d, 0xd8, 0xc1, 0x87, 0xaf, 0xbf, 0xa9, 0x96, 0xf1,
	0xff, 0x83, 0x1a, 0x47, 0xed, 0xc4, 0xfe, 0x85, 0x50, 0x87, 0x82, 0x20, 0xf4, 0x95, 0x09, 0x8c,
	0x59, 0xc3, 0xef, 0xe6, 0xff, 0x4c, 0xc6, 0x76, 0xab, 0x90, 0xff, 0x43, 0x28, 0x7a, 0x34, 0xa0,
	0x4e, 0x20, 0x2f, 0x87, 0x31, 0x92, 0x81, 0x88, 0x83, 0xdc, 0x83, 0x0a, 0xbb, 0xcf, 0xad, 0xa1,
	0x6e, 0x6b, 0x9d, 0x81, 0x71, 0x42, 0x03, 0x31, 0xc1, 0x39, 0x09, 0xde, 0x46, 0x28, 0x69, 0x43,
	0xb9, 0xa3, 0x9b, 0x5a, 0xc7, 0x72, 0x74, 0x8c, 0x75, 0xf8, 0x8e, 0x7b, 0x33, 0xe9, 0x04, 0xd1,
	0x7f, 0x6b, 0x86, 0x1b, 0xad, 0x6d, 0xdd, 0xdc, 0x16, 0xd4, 0x6a, 0xa9, 0x13, 0x7d, 0x90, 0xcf,
	0x61, 0x51, 0xc6, 0xa5, 0xe1, 0xd8, 0xdc, 0xb3, 0x2e, 0x6e, 0x54, 0x6c, 0x09, 0x62, 0xee, 0x58,
	0x0b, 0x42, 0x46, 0x02, 0x4a, 0x1e, 0xc0, 0xc2, 0x88, 0xec, 0x81, 0x67, 0x09, 0x07, 0x22, 0x29,
	0x9e, 0x4f, 0x3d, 0x8b, 0xfc, 0x14, 0x96, 0x63, 0xcd, 0xe4, 0x94, 0x42, 0xd3, 0x57, 0x50, 0x68,
	0x29, 0x12, 0x93, 0xd4, 0xe9, 0x11, 0x2c, 0x65, 0x8d, 0xc0, 0xd4, 0xe2, 0xcd, 0xf8, 0xeb, 0xa3,
	0x9c, 0x9f, 0x7a, 0x56, 0xf3, 0xef, 0x72, 0x89, 0x77, 0x51, 0x62, 0xdf, 0xfb, 0xe4, 0x47, 0xe9,
	0x4a, 0x1a, 0x5f, 0xf6, 0x95, 0x91, 0x65, 0x6f, 0x3b, 0xc1, 0xa3, 0x77, 0x3f, 0x63, 0x8e, 0x9a,
	0x2a, 0xb3, 0xb5, 0x45, 0x99, 0xed, 0xd4, 0xb3, 0x82, 0x28, 0x33, 0x99, 0xb8, 0x5c, 0x0c, 0x96,
	0xb3, 0x5e, 0x30, 0x2e, 0x21, 0x6a, 0x3b, 0xf8, 0xfa, 0x9b, 0xc6, 0xb5, 0x5f, 0x7f, 0xd3, 0xb8,
	0xf6, 0xdb, 0x6f, 0x1a, 0xb9, 0x9f, 0xbf, 0x6c, 0xe4, 0xfe, 0xe1, 0x65, 0x23, 0xf7, 0x6f, 0x2f,
	0x1b, 0xb9, 0xaf, 0x5f, 0x36, 0x72, 0xff, 0xf5, 0xb2, 0x91, 0xfb, 0xef, 0x97, 0x8d, 0x6b, 0xbf,
	0x7d, 0xd9, 0xc8, 0xfd, 0xea, 0xdb, 0xc6, 0xb5, 0xaf, 0xbf, 0x6d, 0x5c, 0xfb, 0xf5, 0xb7, 0x8d,
	0x6b, 0x9f, 0xff, 0xe1, 0x91, 0x1b, 0xd9, 0xd4, 0x72, 0x2f, 0xf9, 0x47, 0xdb, 0x93, 0x34, 0xac,
	0x33, 0x8d, 0xca, 0x3d, 0xfc, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xee, 0x3d, 0x54, 0x31, 0x14,
	0x37, 0x00, 0x00,
}

func (this *ExecutionStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExecutionStats)
	if !ok {
		that2, ok := that.(ExecutionStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HistorySize != that1.HistorySize {
		return false
	}
	return true
}
func (this *ClusterMetadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClusterMetadata)
	if !ok {
		that2, ok := that.(ClusterMetadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	if this.HistoryShardCount != that1.HistoryShardCount {
		return false
	}
	if this.ClusterId != that1.ClusterId {
		return false
	}
	if !this.VersionInfo.Equal(that1.VersionInfo) {
		return false
	}
	return true
}
func (this *ActivityInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ActivityInfo)
	if !ok {
		that2, ok := that.(ActivityInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.ScheduledEventBatchId != that1.ScheduledEventBatchId {
		return false
	}
	if !this.ScheduledEvent.Equal(that1.ScheduledEvent) {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if !this.StartedEvent.Equal(that1.StartedEvent) {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if this.ActivityId != that1.ActivityId {
		return false
	}
	if this.RequestId != that1.RequestId {
		return false
	}
	if this.ScheduleToStartTimeout != nil && that1.ScheduleToStartTimeout != nil {
		if *this.ScheduleToStartTimeout != *that1.ScheduleToStartTimeout {
			return false
		}
	} else if this.ScheduleToStartTimeout != nil {
		return false
	} else if that1.ScheduleToStartTimeout != nil {
		return false
	}
	if this.ScheduleToCloseTimeout != nil && that1.ScheduleToCloseTimeout != nil {
		if *this.ScheduleToCloseTimeout != *that1.ScheduleToCloseTimeout {
			return false
		}
	} else if this.ScheduleToCloseTimeout != nil {
		return false
	} else if that1.ScheduleToCloseTimeout != nil {
		return false
	}
	if this.StartToCloseTimeout != nil && that1.StartToCloseTimeout != nil {
		if *this.StartToCloseTimeout != *that1.StartToCloseTimeout {
			return false
		}
	} else if this.StartToCloseTimeout != nil {
		return false
	} else if that1.StartToCloseTimeout != nil {
		return false
	}
	if this.HeartbeatTimeout != nil && that1.HeartbeatTimeout != nil {
		if *this.HeartbeatTimeout != *that1.HeartbeatTimeout {
			return false
		}
	} else if this.HeartbeatTimeout != nil {
		return false
	} else if that1.HeartbeatTimeout != nil {
		return false
	}
	if this.CancelRequested != that1.CancelRequested {
		return false
	}
	if this.CancelRequestId != that1.CancelRequestId {
		return false
	}
	if this.TimerTaskStatus != that1.TimerTaskStatus {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.StartedIdentity != that1.StartedIdentity {
		return false
	}
	if this.HasRetryPolicy != that1.HasRetryPolicy {
		return false
	}
	if this.RetryInitialInterval != nil && that1.RetryInitialInterval != nil {
		if *this.RetryInitialInterval != *that1.RetryInitialInterval {
			return false
		}
	} else if this.RetryInitialInterval != nil {
		return false
	} else if that1.RetryInitialInterval != nil {
		return false
	}
	if this.RetryMaximumInterval != nil && that1.RetryMaximumInterval != nil {
		if *this.RetryMaximumInterval != *that1.RetryMaximumInterval {
			return false
		}
	} else if this.RetryMaximumInterval != nil {
		return false
	} else if that1.RetryMaximumInterval != nil {
		return false
	}
	if this.RetryMaximumAttempts != that1.RetryMaximumAttempts {
		return false
	}
	if that1.RetryExpirationTime == nil {
		if this.RetryExpirationTime != nil {
			return false
		}
	} else if !this.RetryExpirationTime.Equal(*that1.RetryExpirationTime) {
		return false
	}
	if this.RetryBackoffCoefficient != that1.RetryBackoffCoefficient {
		return false
	}
	if len(this.RetryNonRetryableErrorTypes) != len(that1.RetryNonRetryableErrorTypes) {
		return false
	}
	for i := range this.RetryNonRetryableErrorTypes {
		if this.RetryNonRetryableErrorTypes[i] != that1.RetryNonRetryableErrorTypes[i] {
			return false
		}
	}
	if !this.RetryLastFailure.Equal(that1.RetryLastFailure) {
		return false
	}
	if this.RetryLastWorkerIdentity != that1.RetryLastWorkerIdentity {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if !this.LastHeartbeatDetails.Equal(that1.LastHeartbeatDetails) {
		return false
	}
	if that1.LastHeartbeatUpdateTime == nil {
		if this.LastHeartbeatUpdateTime != nil {
			return false
		}
	} else if !this.LastHeartbeatUpdateTime.Equal(*that1.LastHeartbeatUpdateTime) {
		return false
	}
	return true
}
func (this *ShardInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ShardInfo)
	if !ok {
		that2, ok := that.(ShardInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.RangeId != that1.RangeId {
		return false
	}
	if this.Owner != that1.Owner {
		return false
	}
	if this.ReplicationAckLevel != that1.ReplicationAckLevel {
		return false
	}
	if this.TransferAckLevel != that1.TransferAckLevel {
		return false
	}
	if this.StolenSinceRenew != that1.StolenSinceRenew {
		return false
	}
	if that1.UpdateTime == nil {
		if this.UpdateTime != nil {
			return false
		}
	} else if !this.UpdateTime.Equal(*that1.UpdateTime) {
		return false
	}
	if that1.TimerAckLevelTime == nil {
		if this.TimerAckLevelTime != nil {
			return false
		}
	} else if !this.TimerAckLevelTime.Equal(*that1.TimerAckLevelTime) {
		return false
	}
	if this.NamespaceNotificationVersion != that1.NamespaceNotificationVersion {
		return false
	}
	if len(this.ClusterTransferAckLevel) != len(that1.ClusterTransferAckLevel) {
		return false
	}
	for i := range this.ClusterTransferAckLevel {
		if this.ClusterTransferAckLevel[i] != that1.ClusterTransferAckLevel[i] {
			return false
		}
	}
	if len(this.ClusterTimerAckLevel) != len(that1.ClusterTimerAckLevel) {
		return false
	}
	for i := range this.ClusterTimerAckLevel {
		if !this.ClusterTimerAckLevel[i].Equal(*that1.ClusterTimerAckLevel[i]) {
			return false
		}
	}
	if len(this.ClusterReplicationLevel) != len(that1.ClusterReplicationLevel) {
		return false
	}
	for i := range this.ClusterReplicationLevel {
		if this.ClusterReplicationLevel[i] != that1.ClusterReplicationLevel[i] {
			return false
		}
	}
	if len(this.ReplicationDlqAckLevel) != len(that1.ReplicationDlqAckLevel) {
		return false
	}
	for i := range this.ReplicationDlqAckLevel {
		if this.ReplicationDlqAckLevel[i] != that1.ReplicationDlqAckLevel[i] {
			return false
		}
	}
	return true
}
func (this *ReplicationTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTaskInfo)
	if !ok {
		that2, ok := that.(ReplicationTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.FirstEventId != that1.FirstEventId {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.ScheduledId != that1.ScheduledId {
		return false
	}
	if this.EventStoreVersion != that1.EventStoreVersion {
		return false
	}
	if this.NewRunEventStoreVersion != that1.NewRunEventStoreVersion {
		return false
	}
	if !bytes.Equal(this.BranchToken, that1.BranchToken) {
		return false
	}
	if !bytes.Equal(this.NewRunBranchToken, that1.NewRunBranchToken) {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	return true
}
func (this *TimerTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TimerTaskInfo)
	if !ok {
		that2, ok := that.(TimerTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.TimeoutType != that1.TimeoutType {
		return false
	}
	if this.WorkflowBackoffType != that1.WorkflowBackoffType {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.ScheduleAttempt != that1.ScheduleAttempt {
		return false
	}
	if this.EventId != that1.EventId {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *TransferTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransferTaskInfo)
	if !ok {
		that2, ok := that.(TransferTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.TargetNamespaceId != that1.TargetNamespaceId {
		return false
	}
	if this.TargetWorkflowId != that1.TargetWorkflowId {
		return false
	}
	if this.TargetRunId != that1.TargetRunId {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.TargetChildWorkflowOnly != that1.TargetChildWorkflowOnly {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	if this.RecordVisibility != that1.RecordVisibility {
		return false
	}
	return true
}
func (this *HistoryBranchRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryBranchRange)
	if !ok {
		that2, ok := that.(HistoryBranchRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BranchId != that1.BranchId {
		return false
	}
	if this.BeginNodeId != that1.BeginNodeId {
		return false
	}
	if this.EndNodeId != that1.EndNodeId {
		return false
	}
	return true
}
func (this *HistoryBranch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryBranch)
	if !ok {
		that2, ok := that.(HistoryBranch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TreeId != that1.TreeId {
		return false
	}
	if this.BranchId != that1.BranchId {
		return false
	}
	if len(this.Ancestors) != len(that1.Ancestors) {
		return false
	}
	for i := range this.Ancestors {
		if !this.Ancestors[i].Equal(that1.Ancestors[i]) {
			return false
		}
	}
	return true
}
func (this *HistoryTreeInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryTreeInfo)
	if !ok {
		that2, ok := that.(HistoryTreeInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.BranchInfo.Equal(that1.BranchInfo) {
		return false
	}
	if that1.ForkTime == nil {
		if this.ForkTime != nil {
			return false
		}
	} else if !this.ForkTime.Equal(*that1.ForkTime) {
		return false
	}
	if this.Info != that1.Info {
		return false
	}
	return true
}
func (this *TimerInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TimerInfo)
	if !ok {
		that2, ok := that.(TimerInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if that1.ExpiryTime == nil {
		if this.ExpiryTime != nil {
			return false
		}
	} else if !this.ExpiryTime.Equal(*that1.ExpiryTime) {
		return false
	}
	if this.TaskStatus != that1.TaskStatus {
		return false
	}
	if this.TimerId != that1.TimerId {
		return false
	}
	return true
}
func (this *TaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TaskInfo)
	if !ok {
		that2, ok := that.(TaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if that1.CreateTime == nil {
		if this.CreateTime != nil {
			return false
		}
	} else if !this.CreateTime.Equal(*that1.CreateTime) {
		return false
	}
	if that1.ExpiryTime == nil {
		if this.ExpiryTime != nil {
			return false
		}
	} else if !this.ExpiryTime.Equal(*that1.ExpiryTime) {
		return false
	}
	return true
}
func (this *AllocatedTaskInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AllocatedTaskInfo)
	if !ok {
		that2, ok := that.(AllocatedTaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	return true
}
func (this *TaskQueueInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TaskQueueInfo)
	if !ok {
		that2, ok := that.(TaskQueueInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.TaskType != that1.TaskType {
		return false
	}
	if this.Kind != that1.Kind {
		return false
	}
	if this.AckLevel != that1.AckLevel {
		return false
	}
	if that1.ExpiryTime == nil {
		if this.ExpiryTime != nil {
			return false
		}
	} else if !this.ExpiryTime.Equal(*that1.ExpiryTime) {
		return false
	}
	if that1.LastUpdateTime == nil {
		if this.LastUpdateTime != nil {
			return false
		}
	} else if !this.LastUpdateTime.Equal(*that1.LastUpdateTime) {
		return false
	}
	return true
}
func (this *SignalInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SignalInfo)
	if !ok {
		that2, ok := that.(SignalInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.InitiatedEventBatchId != that1.InitiatedEventBatchId {
		return false
	}
	if this.RequestId != that1.RequestId {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Input.Equal(that1.Input) {
		return false
	}
	if this.Control != that1.Control {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	return true
}
func (this *RequestCancelInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestCancelInfo)
	if !ok {
		that2, ok := that.(RequestCancelInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.InitiatedEventBatchId != that1.InitiatedEventBatchId {
		return false
	}
	if this.CancelRequestId != that1.CancelRequestId {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	return true
}
func (this *WorkflowExecutionState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WorkflowExecutionState)
	if !ok {
		that2, ok := that.(WorkflowExecutionState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CreateRequestId != that1.CreateRequestId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	return true
}
func (this *WorkflowExecutionInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WorkflowExecutionInfo)
	if !ok {
		that2, ok := that.(WorkflowExecutionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.ParentNamespaceId != that1.ParentNamespaceId {
		return false
	}
	if this.ParentWorkflowId != that1.ParentWorkflowId {
		return false
	}
	if this.ParentRunId != that1.ParentRunId {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	if this.CompletionEventBatchId != that1.CompletionEventBatchId {
		return false
	}
	if !this.CompletionEvent.Equal(that1.CompletionEvent) {
		return false
	}
	if this.TaskQueue != that1.TaskQueue {
		return false
	}
	if this.WorkflowTypeName != that1.WorkflowTypeName {
		return false
	}
	if this.WorkflowExecutionTimeout != nil && that1.WorkflowExecutionTimeout != nil {
		if *this.WorkflowExecutionTimeout != *that1.WorkflowExecutionTimeout {
			return false
		}
	} else if this.WorkflowExecutionTimeout != nil {
		return false
	} else if that1.WorkflowExecutionTimeout != nil {
		return false
	}
	if this.WorkflowRunTimeout != nil && that1.WorkflowRunTimeout != nil {
		if *this.WorkflowRunTimeout != *that1.WorkflowRunTimeout {
			return false
		}
	} else if this.WorkflowRunTimeout != nil {
		return false
	} else if that1.WorkflowRunTimeout != nil {
		return false
	}
	if this.DefaultWorkflowTaskTimeout != nil && that1.DefaultWorkflowTaskTimeout != nil {
		if *this.DefaultWorkflowTaskTimeout != *that1.DefaultWorkflowTaskTimeout {
			return false
		}
	} else if this.DefaultWorkflowTaskTimeout != nil {
		return false
	} else if that1.DefaultWorkflowTaskTimeout != nil {
		return false
	}
	if this.StartVersion != that1.StartVersion {
		return false
	}
	if this.LastEventTaskId != that1.LastEventTaskId {
		return false
	}
	if this.LastFirstEventId != that1.LastFirstEventId {
		return false
	}
	if this.LastProcessedEvent != that1.LastProcessedEvent {
		return false
	}
	if that1.StartTime == nil {
		if this.StartTime != nil {
			return false
		}
	} else if !this.StartTime.Equal(*that1.StartTime) {
		return false
	}
	if that1.LastUpdateTime == nil {
		if this.LastUpdateTime != nil {
			return false
		}
	} else if !this.LastUpdateTime.Equal(*that1.LastUpdateTime) {
		return false
	}
	if this.WorkflowTaskVersion != that1.WorkflowTaskVersion {
		return false
	}
	if this.WorkflowTaskScheduleId != that1.WorkflowTaskScheduleId {
		return false
	}
	if this.WorkflowTaskStartedId != that1.WorkflowTaskStartedId {
		return false
	}
	if this.WorkflowTaskTimeout != nil && that1.WorkflowTaskTimeout != nil {
		if *this.WorkflowTaskTimeout != *that1.WorkflowTaskTimeout {
			return false
		}
	} else if this.WorkflowTaskTimeout != nil {
		return false
	} else if that1.WorkflowTaskTimeout != nil {
		return false
	}
	if this.WorkflowTaskAttempt != that1.WorkflowTaskAttempt {
		return false
	}
	if that1.WorkflowTaskStartedTime == nil {
		if this.WorkflowTaskStartedTime != nil {
			return false
		}
	} else if !this.WorkflowTaskStartedTime.Equal(*that1.WorkflowTaskStartedTime) {
		return false
	}
	if that1.WorkflowTaskScheduledTime == nil {
		if this.WorkflowTaskScheduledTime != nil {
			return false
		}
	} else if !this.WorkflowTaskScheduledTime.Equal(*that1.WorkflowTaskScheduledTime) {
		return false
	}
	if this.CancelRequested != that1.CancelRequested {
		return false
	}
	if that1.WorkflowTaskOriginalScheduledTime == nil {
		if this.WorkflowTaskOriginalScheduledTime != nil {
			return false
		}
	} else if !this.WorkflowTaskOriginalScheduledTime.Equal(*that1.WorkflowTaskOriginalScheduledTime) {
		return false
	}
	if this.WorkflowTaskRequestId != that1.WorkflowTaskRequestId {
		return false
	}
	if this.CancelRequestId != that1.CancelRequestId {
		return false
	}
	if this.StickyTaskQueue != that1.StickyTaskQueue {
		return false
	}
	if this.StickyScheduleToStartTimeout != nil && that1.StickyScheduleToStartTimeout != nil {
		if *this.StickyScheduleToStartTimeout != *that1.StickyScheduleToStartTimeout {
			return false
		}
	} else if this.StickyScheduleToStartTimeout != nil {
		return false
	} else if that1.StickyScheduleToStartTimeout != nil {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.RetryInitialInterval != nil && that1.RetryInitialInterval != nil {
		if *this.RetryInitialInterval != *that1.RetryInitialInterval {
			return false
		}
	} else if this.RetryInitialInterval != nil {
		return false
	} else if that1.RetryInitialInterval != nil {
		return false
	}
	if this.RetryMaximumInterval != nil && that1.RetryMaximumInterval != nil {
		if *this.RetryMaximumInterval != *that1.RetryMaximumInterval {
			return false
		}
	} else if this.RetryMaximumInterval != nil {
		return false
	} else if that1.RetryMaximumInterval != nil {
		return false
	}
	if this.RetryMaximumAttempts != that1.RetryMaximumAttempts {
		return false
	}
	if this.RetryBackoffCoefficient != that1.RetryBackoffCoefficient {
		return false
	}
	if that1.RetryExpirationTime == nil {
		if this.RetryExpirationTime != nil {
			return false
		}
	} else if !this.RetryExpirationTime.Equal(*that1.RetryExpirationTime) {
		return false
	}
	if len(this.RetryNonRetryableErrorTypes) != len(that1.RetryNonRetryableErrorTypes) {
		return false
	}
	for i := range this.RetryNonRetryableErrorTypes {
		if this.RetryNonRetryableErrorTypes[i] != that1.RetryNonRetryableErrorTypes[i] {
			return false
		}
	}
	if this.HasRetryPolicy != that1.HasRetryPolicy {
		return false
	}
	if this.CronSchedule != that1.CronSchedule {
		return false
	}
	if this.EventStoreVersion != that1.EventStoreVersion {
		return false
	}
	if !bytes.Equal(this.EventBranchToken, that1.EventBranchToken) {
		return false
	}
	if this.SignalCount != that1.SignalCount {
		return false
	}
	if this.HistorySize != that1.HistorySize {
		return false
	}
	if !this.AutoResetPoints.Equal(that1.AutoResetPoints) {
		return false
	}
	if len(this.SearchAttributes) != len(that1.SearchAttributes) {
		return false
	}
	for i := range this.SearchAttributes {
		if !this.SearchAttributes[i].Equal(that1.SearchAttributes[i]) {
			return false
		}
	}
	if len(this.Memo) != len(that1.Memo) {
		return false
	}
	for i := range this.Memo {
		if !this.Memo[i].Equal(that1.Memo[i]) {
			return false
		}
	}
	if !this.VersionHistories.Equal(that1.VersionHistories) {
		return false
	}
	if this.FirstExecutionRunId != that1.FirstExecutionRunId {
		return false
	}
	if !this.ExecutionStats.Equal(that1.ExecutionStats) {
		return false
	}
	return true
}
func (this *Checksum) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Checksum)
	if !ok {
		that2, ok := that.(Checksum)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.Flavor != that1.Flavor {
		return false
	}
	if !bytes.Equal(this.Value, that1.Value) {
		return false
	}
	return true
}
func (this *ChildExecutionInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ChildExecutionInfo)
	if !ok {
		that2, ok := that.(ChildExecutionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.InitiatedEventBatchId != that1.InitiatedEventBatchId {
		return false
	}
	if this.StartedId != that1.StartedId {
		return false
	}
	if !this.InitiatedEvent.Equal(that1.InitiatedEvent) {
		return false
	}
	if this.StartedWorkflowId != that1.StartedWorkflowId {
		return false
	}
	if this.StartedRunId != that1.StartedRunId {
		return false
	}
	if !this.StartedEvent.Equal(that1.StartedEvent) {
		return false
	}
	if this.CreateRequestId != that1.CreateRequestId {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if this.WorkflowTypeName != that1.WorkflowTypeName {
		return false
	}
	if this.ParentClosePolicy != that1.ParentClosePolicy {
		return false
	}
	if this.InitiatedId != that1.InitiatedId {
		return false
	}
	return true
}
func (this *NamespaceDetail) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceDetail)
	if !ok {
		that2, ok := that.(NamespaceDetail)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Info.Equal(that1.Info) {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	if !this.ReplicationConfig.Equal(that1.ReplicationConfig) {
		return false
	}
	if this.ConfigVersion != that1.ConfigVersion {
		return false
	}
	if this.FailoverNotificationVersion != that1.FailoverNotificationVersion {
		return false
	}
	if this.FailoverVersion != that1.FailoverVersion {
		return false
	}
	if that1.FailoverEndTime == nil {
		if this.FailoverEndTime != nil {
			return false
		}
	} else if !this.FailoverEndTime.Equal(*that1.FailoverEndTime) {
		return false
	}
	return true
}
func (this *NamespaceInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceInfo)
	if !ok {
		that2, ok := that.(NamespaceInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Description != that1.Description {
		return false
	}
	if this.Owner != that1.Owner {
		return false
	}
	if len(this.Data) != len(that1.Data) {
		return false
	}
	for i := range this.Data {
		if this.Data[i] != that1.Data[i] {
			return false
		}
	}
	return true
}
func (this *NamespaceReplicationConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceReplicationConfig)
	if !ok {
		that2, ok := that.(NamespaceReplicationConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ActiveClusterName != that1.ActiveClusterName {
		return false
	}
	if len(this.Clusters) != len(that1.Clusters) {
		return false
	}
	for i := range this.Clusters {
		if this.Clusters[i] != that1.Clusters[i] {
			return false
		}
	}
	return true
}
func (this *NamespaceConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NamespaceConfig)
	if !ok {
		that2, ok := that.(NamespaceConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Retention != nil && that1.Retention != nil {
		if *this.Retention != *that1.Retention {
			return false
		}
	} else if this.Retention != nil {
		return false
	} else if that1.Retention != nil {
		return false
	}
	if this.ArchivalBucket != that1.ArchivalBucket {
		return false
	}
	if !this.BadBinaries.Equal(that1.BadBinaries) {
		return false
	}
	if this.HistoryArchivalState != that1.HistoryArchivalState {
		return false
	}
	if this.HistoryArchivalUri != that1.HistoryArchivalUri {
		return false
	}
	if this.VisibilityArchivalState != that1.VisibilityArchivalState {
		return false
	}
	if this.VisibilityArchivalUri != that1.VisibilityArchivalUri {
		return false
	}
	return true
}
func (this *ReplicationVersions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationVersions)
	if !ok {
		that2, ok := that.(ReplicationVersions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.StartVersion.Equal(that1.StartVersion) {
		return false
	}
	if !this.LastWriteVersion.Equal(that1.LastWriteVersion) {
		return false
	}
	return true
}
func (this *ExecutionStats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&persistenceblobs.ExecutionStats{")
	s = append(s, "HistorySize: "+fmt.Sprintf("%#v", this.HistorySize)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ClusterMetadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&persistenceblobs.ClusterMetadata{")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "HistoryShardCount: "+fmt.Sprintf("%#v", this.HistoryShardCount)+",\n")
	s = append(s, "ClusterId: "+fmt.Sprintf("%#v", this.ClusterId)+",\n")
	if this.VersionInfo != nil {
		s = append(s, "VersionInfo: "+fmt.Sprintf("%#v", this.VersionInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ActivityInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 36)
	s = append(s, "&persistenceblobs.ActivityInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "ScheduledEventBatchId: "+fmt.Sprintf("%#v", this.ScheduledEventBatchId)+",\n")
	if this.ScheduledEvent != nil {
		s = append(s, "ScheduledEvent: "+fmt.Sprintf("%#v", this.ScheduledEvent)+",\n")
	}
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	if this.StartedEvent != nil {
		s = append(s, "StartedEvent: "+fmt.Sprintf("%#v", this.StartedEvent)+",\n")
	}
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	s = append(s, "ActivityId: "+fmt.Sprintf("%#v", this.ActivityId)+",\n")
	s = append(s, "RequestId: "+fmt.Sprintf("%#v", this.RequestId)+",\n")
	s = append(s, "ScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.ScheduleToStartTimeout)+",\n")
	s = append(s, "ScheduleToCloseTimeout: "+fmt.Sprintf("%#v", this.ScheduleToCloseTimeout)+",\n")
	s = append(s, "StartToCloseTimeout: "+fmt.Sprintf("%#v", this.StartToCloseTimeout)+",\n")
	s = append(s, "HeartbeatTimeout: "+fmt.Sprintf("%#v", this.HeartbeatTimeout)+",\n")
	s = append(s, "CancelRequested: "+fmt.Sprintf("%#v", this.CancelRequested)+",\n")
	s = append(s, "CancelRequestId: "+fmt.Sprintf("%#v", this.CancelRequestId)+",\n")
	s = append(s, "TimerTaskStatus: "+fmt.Sprintf("%#v", this.TimerTaskStatus)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "StartedIdentity: "+fmt.Sprintf("%#v", this.StartedIdentity)+",\n")
	s = append(s, "HasRetryPolicy: "+fmt.Sprintf("%#v", this.HasRetryPolicy)+",\n")
	s = append(s, "RetryInitialInterval: "+fmt.Sprintf("%#v", this.RetryInitialInterval)+",\n")
	s = append(s, "RetryMaximumInterval: "+fmt.Sprintf("%#v", this.RetryMaximumInterval)+",\n")
	s = append(s, "RetryMaximumAttempts: "+fmt.Sprintf("%#v", this.RetryMaximumAttempts)+",\n")
	s = append(s, "RetryExpirationTime: "+fmt.Sprintf("%#v", this.RetryExpirationTime)+",\n")
	s = append(s, "RetryBackoffCoefficient: "+fmt.Sprintf("%#v", this.RetryBackoffCoefficient)+",\n")
	s = append(s, "RetryNonRetryableErrorTypes: "+fmt.Sprintf("%#v", this.RetryNonRetryableErrorTypes)+",\n")
	if this.RetryLastFailure != nil {
		s = append(s, "RetryLastFailure: "+fmt.Sprintf("%#v", this.RetryLastFailure)+",\n")
	}
	s = append(s, "RetryLastWorkerIdentity: "+fmt.Sprintf("%#v", this.RetryLastWorkerIdentity)+",\n")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	if this.LastHeartbeatDetails != nil {
		s = append(s, "LastHeartbeatDetails: "+fmt.Sprintf("%#v", this.LastHeartbeatDetails)+",\n")
	}
	s = append(s, "LastHeartbeatUpdateTime: "+fmt.Sprintf("%#v", this.LastHeartbeatUpdateTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ShardInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&persistenceblobs.ShardInfo{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "RangeId: "+fmt.Sprintf("%#v", this.RangeId)+",\n")
	s = append(s, "Owner: "+fmt.Sprintf("%#v", this.Owner)+",\n")
	s = append(s, "ReplicationAckLevel: "+fmt.Sprintf("%#v", this.ReplicationAckLevel)+",\n")
	s = append(s, "TransferAckLevel: "+fmt.Sprintf("%#v", this.TransferAckLevel)+",\n")
	s = append(s, "StolenSinceRenew: "+fmt.Sprintf("%#v", this.StolenSinceRenew)+",\n")
	s = append(s, "UpdateTime: "+fmt.Sprintf("%#v", this.UpdateTime)+",\n")
	s = append(s, "TimerAckLevelTime: "+fmt.Sprintf("%#v", this.TimerAckLevelTime)+",\n")
	s = append(s, "NamespaceNotificationVersion: "+fmt.Sprintf("%#v", this.NamespaceNotificationVersion)+",\n")
	keysForClusterTransferAckLevel := make([]string, 0, len(this.ClusterTransferAckLevel))
	for k, _ := range this.ClusterTransferAckLevel {
		keysForClusterTransferAckLevel = append(keysForClusterTransferAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTransferAckLevel)
	mapStringForClusterTransferAckLevel := "map[string]int64{"
	for _, k := range keysForClusterTransferAckLevel {
		mapStringForClusterTransferAckLevel += fmt.Sprintf("%#v: %#v,", k, this.ClusterTransferAckLevel[k])
	}
	mapStringForClusterTransferAckLevel += "}"
	if this.ClusterTransferAckLevel != nil {
		s = append(s, "ClusterTransferAckLevel: "+mapStringForClusterTransferAckLevel+",\n")
	}
	keysForClusterTimerAckLevel := make([]string, 0, len(this.ClusterTimerAckLevel))
	for k, _ := range this.ClusterTimerAckLevel {
		keysForClusterTimerAckLevel = append(keysForClusterTimerAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTimerAckLevel)
	mapStringForClusterTimerAckLevel := "map[string]*time.Time{"
	for _, k := range keysForClusterTimerAckLevel {
		mapStringForClusterTimerAckLevel += fmt.Sprintf("%#v: %#v,", k, this.ClusterTimerAckLevel[k])
	}
	mapStringForClusterTimerAckLevel += "}"
	if this.ClusterTimerAckLevel != nil {
		s = append(s, "ClusterTimerAckLevel: "+mapStringForClusterTimerAckLevel+",\n")
	}
	keysForClusterReplicationLevel := make([]string, 0, len(this.ClusterReplicationLevel))
	for k, _ := range this.ClusterReplicationLevel {
		keysForClusterReplicationLevel = append(keysForClusterReplicationLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterReplicationLevel)
	mapStringForClusterReplicationLevel := "map[string]int64{"
	for _, k := range keysForClusterReplicationLevel {
		mapStringForClusterReplicationLevel += fmt.Sprintf("%#v: %#v,", k, this.ClusterReplicationLevel[k])
	}
	mapStringForClusterReplicationLevel += "}"
	if this.ClusterReplicationLevel != nil {
		s = append(s, "ClusterReplicationLevel: "+mapStringForClusterReplicationLevel+",\n")
	}
	keysForReplicationDlqAckLevel := make([]string, 0, len(this.ReplicationDlqAckLevel))
	for k, _ := range this.ReplicationDlqAckLevel {
		keysForReplicationDlqAckLevel = append(keysForReplicationDlqAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReplicationDlqAckLevel)
	mapStringForReplicationDlqAckLevel := "map[string]int64{"
	for _, k := range keysForReplicationDlqAckLevel {
		mapStringForReplicationDlqAckLevel += fmt.Sprintf("%#v: %#v,", k, this.ReplicationDlqAckLevel[k])
	}
	mapStringForReplicationDlqAckLevel += "}"
	if this.ReplicationDlqAckLevel != nil {
		s = append(s, "ReplicationDlqAckLevel: "+mapStringForReplicationDlqAckLevel+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&persistenceblobs.ReplicationTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "FirstEventId: "+fmt.Sprintf("%#v", this.FirstEventId)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "ScheduledId: "+fmt.Sprintf("%#v", this.ScheduledId)+",\n")
	s = append(s, "EventStoreVersion: "+fmt.Sprintf("%#v", this.EventStoreVersion)+",\n")
	s = append(s, "NewRunEventStoreVersion: "+fmt.Sprintf("%#v", this.NewRunEventStoreVersion)+",\n")
	s = append(s, "BranchToken: "+fmt.Sprintf("%#v", this.BranchToken)+",\n")
	s = append(s, "NewRunBranchToken: "+fmt.Sprintf("%#v", this.NewRunBranchToken)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TimerTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&persistenceblobs.TimerTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "TimeoutType: "+fmt.Sprintf("%#v", this.TimeoutType)+",\n")
	s = append(s, "WorkflowBackoffType: "+fmt.Sprintf("%#v", this.WorkflowBackoffType)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "ScheduleAttempt: "+fmt.Sprintf("%#v", this.ScheduleAttempt)+",\n")
	s = append(s, "EventId: "+fmt.Sprintf("%#v", this.EventId)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TransferTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 18)
	s = append(s, "&persistenceblobs.TransferTaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "TargetNamespaceId: "+fmt.Sprintf("%#v", this.TargetNamespaceId)+",\n")
	s = append(s, "TargetWorkflowId: "+fmt.Sprintf("%#v", this.TargetWorkflowId)+",\n")
	s = append(s, "TargetRunId: "+fmt.Sprintf("%#v", this.TargetRunId)+",\n")
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "TargetChildWorkflowOnly: "+fmt.Sprintf("%#v", this.TargetChildWorkflowOnly)+",\n")
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "RecordVisibility: "+fmt.Sprintf("%#v", this.RecordVisibility)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryBranchRange) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistenceblobs.HistoryBranchRange{")
	s = append(s, "BranchId: "+fmt.Sprintf("%#v", this.BranchId)+",\n")
	s = append(s, "BeginNodeId: "+fmt.Sprintf("%#v", this.BeginNodeId)+",\n")
	s = append(s, "EndNodeId: "+fmt.Sprintf("%#v", this.EndNodeId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryBranch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistenceblobs.HistoryBranch{")
	s = append(s, "TreeId: "+fmt.Sprintf("%#v", this.TreeId)+",\n")
	s = append(s, "BranchId: "+fmt.Sprintf("%#v", this.BranchId)+",\n")
	if this.Ancestors != nil {
		s = append(s, "Ancestors: "+fmt.Sprintf("%#v", this.Ancestors)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HistoryTreeInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistenceblobs.HistoryTreeInfo{")
	if this.BranchInfo != nil {
		s = append(s, "BranchInfo: "+fmt.Sprintf("%#v", this.BranchInfo)+",\n")
	}
	s = append(s, "ForkTime: "+fmt.Sprintf("%#v", this.ForkTime)+",\n")
	s = append(s, "Info: "+fmt.Sprintf("%#v", this.Info)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TimerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&persistenceblobs.TimerInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	s = append(s, "ExpiryTime: "+fmt.Sprintf("%#v", this.ExpiryTime)+",\n")
	s = append(s, "TaskStatus: "+fmt.Sprintf("%#v", this.TaskStatus)+",\n")
	s = append(s, "TimerId: "+fmt.Sprintf("%#v", this.TimerId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&persistenceblobs.TaskInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "CreateTime: "+fmt.Sprintf("%#v", this.CreateTime)+",\n")
	s = append(s, "ExpiryTime: "+fmt.Sprintf("%#v", this.ExpiryTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AllocatedTaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&persistenceblobs.AllocatedTaskInfo{")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskQueueInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistenceblobs.TaskQueueInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "TaskType: "+fmt.Sprintf("%#v", this.TaskType)+",\n")
	s = append(s, "Kind: "+fmt.Sprintf("%#v", this.Kind)+",\n")
	s = append(s, "AckLevel: "+fmt.Sprintf("%#v", this.AckLevel)+",\n")
	s = append(s, "ExpiryTime: "+fmt.Sprintf("%#v", this.ExpiryTime)+",\n")
	s = append(s, "LastUpdateTime: "+fmt.Sprintf("%#v", this.LastUpdateTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SignalInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistenceblobs.SignalInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "InitiatedEventBatchId: "+fmt.Sprintf("%#v", this.InitiatedEventBatchId)+",\n")
	s = append(s, "RequestId: "+fmt.Sprintf("%#v", this.RequestId)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Input != nil {
		s = append(s, "Input: "+fmt.Sprintf("%#v", this.Input)+",\n")
	}
	s = append(s, "Control: "+fmt.Sprintf("%#v", this.Control)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RequestCancelInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&persistenceblobs.RequestCancelInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "InitiatedEventBatchId: "+fmt.Sprintf("%#v", this.InitiatedEventBatchId)+",\n")
	s = append(s, "CancelRequestId: "+fmt.Sprintf("%#v", this.CancelRequestId)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WorkflowExecutionState) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&persistenceblobs.WorkflowExecutionState{")
	s = append(s, "CreateRequestId: "+fmt.Sprintf("%#v", this.CreateRequestId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WorkflowExecutionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 55)
	s = append(s, "&persistenceblobs.WorkflowExecutionInfo{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "ParentNamespaceId: "+fmt.Sprintf("%#v", this.ParentNamespaceId)+",\n")
	s = append(s, "ParentWorkflowId: "+fmt.Sprintf("%#v", this.ParentWorkflowId)+",\n")
	s = append(s, "ParentRunId: "+fmt.Sprintf("%#v", this.ParentRunId)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	s = append(s, "CompletionEventBatchId: "+fmt.Sprintf("%#v", this.CompletionEventBatchId)+",\n")
	if this.CompletionEvent != nil {
		s = append(s, "CompletionEvent: "+fmt.Sprintf("%#v", this.CompletionEvent)+",\n")
	}
	s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	s = append(s, "WorkflowTypeName: "+fmt.Sprintf("%#v", this.WorkflowTypeName)+",\n")
	s = append(s, "WorkflowExecutionTimeout: "+fmt.Sprintf("%#v", this.WorkflowExecutionTimeout)+",\n")
	s = append(s, "WorkflowRunTimeout: "+fmt.Sprintf("%#v", this.WorkflowRunTimeout)+",\n")
	s = append(s, "DefaultWorkflowTaskTimeout: "+fmt.Sprintf("%#v", this.DefaultWorkflowTaskTimeout)+",\n")
	s = append(s, "StartVersion: "+fmt.Sprintf("%#v", this.StartVersion)+",\n")
	s = append(s, "LastEventTaskId: "+fmt.Sprintf("%#v", this.LastEventTaskId)+",\n")
	s = append(s, "LastFirstEventId: "+fmt.Sprintf("%#v", this.LastFirstEventId)+",\n")
	s = append(s, "LastProcessedEvent: "+fmt.Sprintf("%#v", this.LastProcessedEvent)+",\n")
	s = append(s, "StartTime: "+fmt.Sprintf("%#v", this.StartTime)+",\n")
	s = append(s, "LastUpdateTime: "+fmt.Sprintf("%#v", this.LastUpdateTime)+",\n")
	s = append(s, "WorkflowTaskVersion: "+fmt.Sprintf("%#v", this.WorkflowTaskVersion)+",\n")
	s = append(s, "WorkflowTaskScheduleId: "+fmt.Sprintf("%#v", this.WorkflowTaskScheduleId)+",\n")
	s = append(s, "WorkflowTaskStartedId: "+fmt.Sprintf("%#v", this.WorkflowTaskStartedId)+",\n")
	s = append(s, "WorkflowTaskTimeout: "+fmt.Sprintf("%#v", this.WorkflowTaskTimeout)+",\n")
	s = append(s, "WorkflowTaskAttempt: "+fmt.Sprintf("%#v", this.WorkflowTaskAttempt)+",\n")
	s = append(s, "WorkflowTaskStartedTime: "+fmt.Sprintf("%#v", this.WorkflowTaskStartedTime)+",\n")
	s = append(s, "WorkflowTaskScheduledTime: "+fmt.Sprintf("%#v", this.WorkflowTaskScheduledTime)+",\n")
	s = append(s, "CancelRequested: "+fmt.Sprintf("%#v", this.CancelRequested)+",\n")
	s = append(s, "WorkflowTaskOriginalScheduledTime: "+fmt.Sprintf("%#v", this.WorkflowTaskOriginalScheduledTime)+",\n")
	s = append(s, "WorkflowTaskRequestId: "+fmt.Sprintf("%#v", this.WorkflowTaskRequestId)+",\n")
	s = append(s, "CancelRequestId: "+fmt.Sprintf("%#v", this.CancelRequestId)+",\n")
	s = append(s, "StickyTaskQueue: "+fmt.Sprintf("%#v", this.StickyTaskQueue)+",\n")
	s = append(s, "StickyScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.StickyScheduleToStartTimeout)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "RetryInitialInterval: "+fmt.Sprintf("%#v", this.RetryInitialInterval)+",\n")
	s = append(s, "RetryMaximumInterval: "+fmt.Sprintf("%#v", this.RetryMaximumInterval)+",\n")
	s = append(s, "RetryMaximumAttempts: "+fmt.Sprintf("%#v", this.RetryMaximumAttempts)+",\n")
	s = append(s, "RetryBackoffCoefficient: "+fmt.Sprintf("%#v", this.RetryBackoffCoefficient)+",\n")
	s = append(s, "RetryExpirationTime: "+fmt.Sprintf("%#v", this.RetryExpirationTime)+",\n")
	s = append(s, "RetryNonRetryableErrorTypes: "+fmt.Sprintf("%#v", this.RetryNonRetryableErrorTypes)+",\n")
	s = append(s, "HasRetryPolicy: "+fmt.Sprintf("%#v", this.HasRetryPolicy)+",\n")
	s = append(s, "CronSchedule: "+fmt.Sprintf("%#v", this.CronSchedule)+",\n")
	s = append(s, "EventStoreVersion: "+fmt.Sprintf("%#v", this.EventStoreVersion)+",\n")
	s = append(s, "EventBranchToken: "+fmt.Sprintf("%#v", this.EventBranchToken)+",\n")
	s = append(s, "SignalCount: "+fmt.Sprintf("%#v", this.SignalCount)+",\n")
	s = append(s, "HistorySize: "+fmt.Sprintf("%#v", this.HistorySize)+",\n")
	if this.AutoResetPoints != nil {
		s = append(s, "AutoResetPoints: "+fmt.Sprintf("%#v", this.AutoResetPoints)+",\n")
	}
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]*v13.Payload{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%#v: %#v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	if this.SearchAttributes != nil {
		s = append(s, "SearchAttributes: "+mapStringForSearchAttributes+",\n")
	}
	keysForMemo := make([]string, 0, len(this.Memo))
	for k, _ := range this.Memo {
		keysForMemo = append(keysForMemo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMemo)
	mapStringForMemo := "map[string]*v13.Payload{"
	for _, k := range keysForMemo {
		mapStringForMemo += fmt.Sprintf("%#v: %#v,", k, this.Memo[k])
	}
	mapStringForMemo += "}"
	if this.Memo != nil {
		s = append(s, "Memo: "+mapStringForMemo+",\n")
	}
	if this.VersionHistories != nil {
		s = append(s, "VersionHistories: "+fmt.Sprintf("%#v", this.VersionHistories)+",\n")
	}
	s = append(s, "FirstExecutionRunId: "+fmt.Sprintf("%#v", this.FirstExecutionRunId)+",\n")
	if this.ExecutionStats != nil {
		s = append(s, "ExecutionStats: "+fmt.Sprintf("%#v", this.ExecutionStats)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Checksum) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&persistenceblobs.Checksum{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "Flavor: "+fmt.Sprintf("%#v", this.Flavor)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ChildExecutionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&persistenceblobs.ChildExecutionInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	s = append(s, "InitiatedEventBatchId: "+fmt.Sprintf("%#v", this.InitiatedEventBatchId)+",\n")
	s = append(s, "StartedId: "+fmt.Sprintf("%#v", this.StartedId)+",\n")
	if this.InitiatedEvent != nil {
		s = append(s, "InitiatedEvent: "+fmt.Sprintf("%#v", this.InitiatedEvent)+",\n")
	}
	s = append(s, "StartedWorkflowId: "+fmt.Sprintf("%#v", this.StartedWorkflowId)+",\n")
	s = append(s, "StartedRunId: "+fmt.Sprintf("%#v", this.StartedRunId)+",\n")
	if this.StartedEvent != nil {
		s = append(s, "StartedEvent: "+fmt.Sprintf("%#v", this.StartedEvent)+",\n")
	}
	s = append(s, "CreateRequestId: "+fmt.Sprintf("%#v", this.CreateRequestId)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	s = append(s, "WorkflowTypeName: "+fmt.Sprintf("%#v", this.WorkflowTypeName)+",\n")
	s = append(s, "ParentClosePolicy: "+fmt.Sprintf("%#v", this.ParentClosePolicy)+",\n")
	s = append(s, "InitiatedId: "+fmt.Sprintf("%#v", this.InitiatedId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceDetail) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistenceblobs.NamespaceDetail{")
	if this.Info != nil {
		s = append(s, "Info: "+fmt.Sprintf("%#v", this.Info)+",\n")
	}
	if this.Config != nil {
		s = append(s, "Config: "+fmt.Sprintf("%#v", this.Config)+",\n")
	}
	if this.ReplicationConfig != nil {
		s = append(s, "ReplicationConfig: "+fmt.Sprintf("%#v", this.ReplicationConfig)+",\n")
	}
	s = append(s, "ConfigVersion: "+fmt.Sprintf("%#v", this.ConfigVersion)+",\n")
	s = append(s, "FailoverNotificationVersion: "+fmt.Sprintf("%#v", this.FailoverNotificationVersion)+",\n")
	s = append(s, "FailoverVersion: "+fmt.Sprintf("%#v", this.FailoverVersion)+",\n")
	s = append(s, "FailoverEndTime: "+fmt.Sprintf("%#v", this.FailoverEndTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&persistenceblobs.NamespaceInfo{")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	s = append(s, "Owner: "+fmt.Sprintf("%#v", this.Owner)+",\n")
	keysForData := make([]string, 0, len(this.Data))
	for k, _ := range this.Data {
		keysForData = append(keysForData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForData)
	mapStringForData := "map[string]string{"
	for _, k := range keysForData {
		mapStringForData += fmt.Sprintf("%#v: %#v,", k, this.Data[k])
	}
	mapStringForData += "}"
	if this.Data != nil {
		s = append(s, "Data: "+mapStringForData+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceReplicationConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&persistenceblobs.NamespaceReplicationConfig{")
	s = append(s, "ActiveClusterName: "+fmt.Sprintf("%#v", this.ActiveClusterName)+",\n")
	s = append(s, "Clusters: "+fmt.Sprintf("%#v", this.Clusters)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NamespaceConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&persistenceblobs.NamespaceConfig{")
	s = append(s, "Retention: "+fmt.Sprintf("%#v", this.Retention)+",\n")
	s = append(s, "ArchivalBucket: "+fmt.Sprintf("%#v", this.ArchivalBucket)+",\n")
	if this.BadBinaries != nil {
		s = append(s, "BadBinaries: "+fmt.Sprintf("%#v", this.BadBinaries)+",\n")
	}
	s = append(s, "HistoryArchivalState: "+fmt.Sprintf("%#v", this.HistoryArchivalState)+",\n")
	s = append(s, "HistoryArchivalUri: "+fmt.Sprintf("%#v", this.HistoryArchivalUri)+",\n")
	s = append(s, "VisibilityArchivalState: "+fmt.Sprintf("%#v", this.VisibilityArchivalState)+",\n")
	s = append(s, "VisibilityArchivalUri: "+fmt.Sprintf("%#v", this.VisibilityArchivalUri)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReplicationVersions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&persistenceblobs.ReplicationVersions{")
	if this.StartVersion != nil {
		s = append(s, "StartVersion: "+fmt.Sprintf("%#v", this.StartVersion)+",\n")
	}
	if this.LastWriteVersion != nil {
		s = append(s, "LastWriteVersion: "+fmt.Sprintf("%#v", this.LastWriteVersion)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMessage(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *ExecutionStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecutionStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecutionStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HistorySize != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.HistorySize))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ClusterMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionInfo != nil {
		{
			size, err := m.VersionInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.HistoryShardCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.HistoryShardCount))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ActivityInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActivityInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ActivityInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastHeartbeatUpdateTime != nil {
		n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastHeartbeatUpdateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatUpdateTime):])
		if err2 != nil {
			return 0, err2
		}
		i -= n2
		i = encodeVarintMessage(dAtA, i, uint64(n2))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if m.LastHeartbeatDetails != nil {
		{
			size, err := m.LastHeartbeatDetails.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if m.ScheduleId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf0
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xea
	}
	if len(m.RetryLastWorkerIdentity) > 0 {
		i -= len(m.RetryLastWorkerIdentity)
		copy(dAtA[i:], m.RetryLastWorkerIdentity)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RetryLastWorkerIdentity)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if m.RetryLastFailure != nil {
		{
			size, err := m.RetryLastFailure.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for iNdEx := len(m.RetryNonRetryableErrorTypes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RetryNonRetryableErrorTypes[iNdEx])
			copy(dAtA[i:], m.RetryNonRetryableErrorTypes[iNdEx])
			i = encodeVarintMessage(dAtA, i, uint64(len(m.RetryNonRetryableErrorTypes[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xd2
		}
	}
	if m.RetryBackoffCoefficient != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.RetryBackoffCoefficient))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc9
	}
	if m.RetryExpirationTime != nil {
		n5, err5 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.RetryExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.RetryExpirationTime):])
		if err5 != nil {
			return 0, err5
		}
		i -= n5
		i = encodeVarintMessage(dAtA, i, uint64(n5))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if m.RetryMaximumAttempts != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.RetryMaximumAttempts))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.RetryMaximumInterval != nil {
		n6, err6 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryMaximumInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval):])
		if err6 != nil {
			return 0, err6
		}
		i -= n6
		i = encodeVarintMessage(dAtA, i, uint64(n6))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.RetryInitialInterval != nil {
		n7, err7 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryInitialInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval):])
		if err7 != nil {
			return 0, err7
		}
		i -= n7
		i = encodeVarintMessage(dAtA, i, uint64(n7))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.HasRetryPolicy {
		i--
		if m.HasRetryPolicy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.StartedIdentity) > 0 {
		i -= len(m.StartedIdentity)
		copy(dAtA[i:], m.StartedIdentity)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.StartedIdentity)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.Attempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.TimerTaskStatus != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TimerTaskStatus))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.CancelRequestId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.CancelRequestId))
		i--
		dAtA[i] = 0x78
	}
	if m.CancelRequested {
		i--
		if m.CancelRequested {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.HeartbeatTimeout != nil {
		n8, err8 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.HeartbeatTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.HeartbeatTimeout):])
		if err8 != nil {
			return 0, err8
		}
		i -= n8
		i = encodeVarintMessage(dAtA, i, uint64(n8))
		i--
		dAtA[i] = 0x6a
	}
	if m.StartToCloseTimeout != nil {
		n9, err9 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StartToCloseTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StartToCloseTimeout):])
		if err9 != nil {
			return 0, err9
		}
		i -= n9
		i = encodeVarintMessage(dAtA, i, uint64(n9))
		i--
		dAtA[i] = 0x62
	}
	if m.ScheduleToCloseTimeout != nil {
		n10, err10 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ScheduleToCloseTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToCloseTimeout):])
		if err10 != nil {
			return 0, err10
		}
		i -= n10
		i = encodeVarintMessage(dAtA, i, uint64(n10))
		i--
		dAtA[i] = 0x5a
	}
	if m.ScheduleToStartTimeout != nil {
		n11, err11 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout):])
		if err11 != nil {
			return 0, err11
		}
		i -= n11
		i = encodeVarintMessage(dAtA, i, uint64(n11))
		i--
		dAtA[i] = 0x52
	}
	if len(m.RequestId) > 0 {
		i -= len(m.RequestId)
		copy(dAtA[i:], m.RequestId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RequestId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.ActivityId) > 0 {
		i -= len(m.ActivityId)
		copy(dAtA[i:], m.ActivityId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ActivityId)))
		i--
		dAtA[i] = 0x42
	}
	if m.StartedTime != nil {
		n12, err12 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err12 != nil {
			return 0, err12
		}
		i -= n12
		i = encodeVarintMessage(dAtA, i, uint64(n12))
		i--
		dAtA[i] = 0x3a
	}
	if m.StartedEvent != nil {
		{
			size, err := m.StartedEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.StartedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x28
	}
	if m.ScheduledTime != nil {
		n14, err14 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err14 != nil {
			return 0, err14
		}
		i -= n14
		i = encodeVarintMessage(dAtA, i, uint64(n14))
		i--
		dAtA[i] = 0x22
	}
	if m.ScheduledEvent != nil {
		{
			size, err := m.ScheduledEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ScheduledEventBatchId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduledEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ShardInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ShardInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ShardInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ReplicationDlqAckLevel) > 0 {
		for k := range m.ReplicationDlqAckLevel {
			v := m.ReplicationDlqAckLevel[k]
			baseI := i
			i = encodeVarintMessage(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x6a
		}
	}
	if len(m.ClusterReplicationLevel) > 0 {
		for k := range m.ClusterReplicationLevel {
			v := m.ClusterReplicationLevel[k]
			baseI := i
			i = encodeVarintMessage(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.ClusterTimerAckLevel) > 0 {
		for k := range m.ClusterTimerAckLevel {
			v := m.ClusterTimerAckLevel[k]
			baseI := i
			if v != nil {
				n16, err16 := github_com_gogo_protobuf_types.StdTimeMarshalTo((*v), dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime((*v)):])
				if err16 != nil {
					return 0, err16
				}
				i -= n16
				i = encodeVarintMessage(dAtA, i, uint64(n16))
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.ClusterTransferAckLevel) > 0 {
		for k := range m.ClusterTransferAckLevel {
			v := m.ClusterTransferAckLevel[k]
			baseI := i
			i = encodeVarintMessage(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if m.NamespaceNotificationVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NamespaceNotificationVersion))
		i--
		dAtA[i] = 0x48
	}
	if m.TimerAckLevelTime != nil {
		n17, err17 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.TimerAckLevelTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.TimerAckLevelTime):])
		if err17 != nil {
			return 0, err17
		}
		i -= n17
		i = encodeVarintMessage(dAtA, i, uint64(n17))
		i--
		dAtA[i] = 0x42
	}
	if m.UpdateTime != nil {
		n18, err18 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.UpdateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.UpdateTime):])
		if err18 != nil {
			return 0, err18
		}
		i -= n18
		i = encodeVarintMessage(dAtA, i, uint64(n18))
		i--
		dAtA[i] = 0x3a
	}
	if m.StolenSinceRenew != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StolenSinceRenew))
		i--
		dAtA[i] = 0x30
	}
	if m.TransferAckLevel != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TransferAckLevel))
		i--
		dAtA[i] = 0x28
	}
	if m.ReplicationAckLevel != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ReplicationAckLevel))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Owner) > 0 {
		i -= len(m.Owner)
		copy(dAtA[i:], m.Owner)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Owner)))
		i--
		dAtA[i] = 0x1a
	}
	if m.RangeId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.RangeId))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x78
	}
	if len(m.NewRunBranchToken) > 0 {
		i -= len(m.NewRunBranchToken)
		copy(dAtA[i:], m.NewRunBranchToken)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NewRunBranchToken)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.BranchToken) > 0 {
		i -= len(m.BranchToken)
		copy(dAtA[i:], m.BranchToken)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.BranchToken)))
		i--
		dAtA[i] = 0x5a
	}
	if m.NewRunEventStoreVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NewRunEventStoreVersion))
		i--
		dAtA[i] = 0x50
	}
	if m.EventStoreVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.EventStoreVersion))
		i--
		dAtA[i] = 0x48
	}
	if m.ScheduledId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduledId))
		i--
		dAtA[i] = 0x40
	}
	if m.NextEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.FirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FirstEventId))
		i--
		dAtA[i] = 0x30
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TimerTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimerTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimerTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n19, err19 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err19 != nil {
			return 0, err19
		}
		i -= n19
		i = encodeVarintMessage(dAtA, i, uint64(n19))
		i--
		dAtA[i] = 0x5a
	}
	if m.TaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x50
	}
	if m.EventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.EventId))
		i--
		dAtA[i] = 0x48
	}
	if m.ScheduleAttempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduleAttempt))
		i--
		dAtA[i] = 0x40
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x38
	}
	if m.WorkflowBackoffType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowBackoffType))
		i--
		dAtA[i] = 0x30
	}
	if m.TimeoutType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TimeoutType))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TransferTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransferTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TransferTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RecordVisibility {
		i--
		if m.RecordVisibility {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.VisibilityTime != nil {
		n20, err20 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err20 != nil {
			return 0, err20
		}
		i -= n20
		i = encodeVarintMessage(dAtA, i, uint64(n20))
		i--
		dAtA[i] = 0x6a
	}
	if m.TaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x60
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x58
	}
	if m.ScheduleId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x50
	}
	if m.TargetChildWorkflowOnly {
		i--
		if m.TargetChildWorkflowOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.TargetRunId) > 0 {
		i -= len(m.TargetRunId)
		copy(dAtA[i:], m.TargetRunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TargetRunId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.TargetWorkflowId) > 0 {
		i -= len(m.TargetWorkflowId)
		copy(dAtA[i:], m.TargetWorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TargetWorkflowId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.TargetNamespaceId) > 0 {
		i -= len(m.TargetNamespaceId)
		copy(dAtA[i:], m.TargetNamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TargetNamespaceId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.TaskType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HistoryBranchRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryBranchRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryBranchRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EndNodeId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.EndNodeId))
		i--
		dAtA[i] = 0x18
	}
	if m.BeginNodeId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.BeginNodeId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.BranchId) > 0 {
		i -= len(m.BranchId)
		copy(dAtA[i:], m.BranchId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.BranchId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HistoryBranch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryBranch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryBranch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Ancestors) > 0 {
		for iNdEx := len(m.Ancestors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ancestors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMessage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.BranchId) > 0 {
		i -= len(m.BranchId)
		copy(dAtA[i:], m.BranchId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.BranchId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TreeId) > 0 {
		i -= len(m.TreeId)
		copy(dAtA[i:], m.TreeId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TreeId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HistoryTreeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryTreeInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistoryTreeInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Info) > 0 {
		i -= len(m.Info)
		copy(dAtA[i:], m.Info)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Info)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ForkTime != nil {
		n21, err21 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ForkTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ForkTime):])
		if err21 != nil {
			return 0, err21
		}
		i -= n21
		i = encodeVarintMessage(dAtA, i, uint64(n21))
		i--
		dAtA[i] = 0x12
	}
	if m.BranchInfo != nil {
		{
			size, err := m.BranchInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TimerInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimerInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimerInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TimerId) > 0 {
		i -= len(m.TimerId)
		copy(dAtA[i:], m.TimerId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TimerId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.TaskStatus != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskStatus))
		i--
		dAtA[i] = 0x20
	}
	if m.ExpiryTime != nil {
		n23, err23 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExpiryTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime):])
		if err23 != nil {
			return 0, err23
		}
		i -= n23
		i = encodeVarintMessage(dAtA, i, uint64(n23))
		i--
		dAtA[i] = 0x1a
	}
	if m.StartedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExpiryTime != nil {
		n24, err24 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExpiryTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime):])
		if err24 != nil {
			return 0, err24
		}
		i -= n24
		i = encodeVarintMessage(dAtA, i, uint64(n24))
		i--
		dAtA[i] = 0x32
	}
	if m.CreateTime != nil {
		n25, err25 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CreateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CreateTime):])
		if err25 != nil {
			return 0, err25
		}
		i -= n25
		i = encodeVarintMessage(dAtA, i, uint64(n25))
		i--
		dAtA[i] = 0x2a
	}
	if m.ScheduleId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AllocatedTaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AllocatedTaskInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AllocatedTaskInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x10
	}
	if m.Data != nil {
		{
			size, err := m.Data.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TaskQueueInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskQueueInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TaskQueueInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastUpdateTime != nil {
		n27, err27 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastUpdateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUpdateTime):])
		if err27 != nil {
			return 0, err27
		}
		i -= n27
		i = encodeVarintMessage(dAtA, i, uint64(n27))
		i--
		dAtA[i] = 0x3a
	}
	if m.ExpiryTime != nil {
		n28, err28 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ExpiryTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime):])
		if err28 != nil {
			return 0, err28
		}
		i -= n28
		i = encodeVarintMessage(dAtA, i, uint64(n28))
		i--
		dAtA[i] = 0x32
	}
	if m.AckLevel != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.AckLevel))
		i--
		dAtA[i] = 0x28
	}
	if m.Kind != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Kind))
		i--
		dAtA[i] = 0x20
	}
	if m.TaskType != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.TaskType))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SignalInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignalInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignalInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InitiatedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Control) > 0 {
		i -= len(m.Control)
		copy(dAtA[i:], m.Control)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Control)))
		i--
		dAtA[i] = 0x32
	}
	if m.Input != nil {
		{
			size, err := m.Input.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RequestId) > 0 {
		i -= len(m.RequestId)
		copy(dAtA[i:], m.RequestId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RequestId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.InitiatedEventBatchId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.InitiatedEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RequestCancelInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestCancelInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RequestCancelInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InitiatedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.CancelRequestId) > 0 {
		i -= len(m.CancelRequestId)
		copy(dAtA[i:], m.CancelRequestId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.CancelRequestId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.InitiatedEventBatchId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.InitiatedEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WorkflowExecutionState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkflowExecutionState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkflowExecutionState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x20
	}
	if m.State != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CreateRequestId) > 0 {
		i -= len(m.CreateRequestId)
		copy(dAtA[i:], m.CreateRequestId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.CreateRequestId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WorkflowExecutionInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkflowExecutionInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkflowExecutionInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExecutionStats != nil {
		{
			size, err := m.ExecutionStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xc2
	}
	if len(m.FirstExecutionRunId) > 0 {
		i -= len(m.FirstExecutionRunId)
		copy(dAtA[i:], m.FirstExecutionRunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.FirstExecutionRunId)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xba
	}
	if m.VersionHistories != nil {
		{
			size, err := m.VersionHistories.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xb2
	}
	if len(m.Memo) > 0 {
		for k := range m.Memo {
			v := m.Memo[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintMessage(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xaa
		}
	}
	if len(m.SearchAttributes) > 0 {
		for k := range m.SearchAttributes {
			v := m.SearchAttributes[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintMessage(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.AutoResetPoints != nil {
		{
			size, err := m.AutoResetPoints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x9a
	}
	if m.HistorySize != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.HistorySize))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf8
	}
	if m.SignalCount != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.SignalCount))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf0
	}
	if len(m.EventBranchToken) > 0 {
		i -= len(m.EventBranchToken)
		copy(dAtA[i:], m.EventBranchToken)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.EventBranchToken)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xea
	}
	if m.EventStoreVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.EventStoreVersion))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xe0
	}
	if len(m.CronSchedule) > 0 {
		i -= len(m.CronSchedule)
		copy(dAtA[i:], m.CronSchedule)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.CronSchedule)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xda
	}
	if m.HasRetryPolicy {
		i--
		if m.HasRetryPolicy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xd0
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for iNdEx := len(m.RetryNonRetryableErrorTypes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RetryNonRetryableErrorTypes[iNdEx])
			copy(dAtA[i:], m.RetryNonRetryableErrorTypes[iNdEx])
			i = encodeVarintMessage(dAtA, i, uint64(len(m.RetryNonRetryableErrorTypes[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xca
		}
	}
	if m.RetryExpirationTime != nil {
		n35, err35 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.RetryExpirationTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.RetryExpirationTime):])
		if err35 != nil {
			return 0, err35
		}
		i -= n35
		i = encodeVarintMessage(dAtA, i, uint64(n35))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc2
	}
	if m.RetryBackoffCoefficient != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.RetryBackoffCoefficient))))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb9
	}
	if m.RetryMaximumAttempts != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.RetryMaximumAttempts))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb0
	}
	if m.RetryMaximumInterval != nil {
		n36, err36 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryMaximumInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval):])
		if err36 != nil {
			return 0, err36
		}
		i -= n36
		i = encodeVarintMessage(dAtA, i, uint64(n36))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if m.RetryInitialInterval != nil {
		n37, err37 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RetryInitialInterval, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval):])
		if err37 != nil {
			return 0, err37
		}
		i -= n37
		i = encodeVarintMessage(dAtA, i, uint64(n37))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if m.Attempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x98
	}
	if m.StickyScheduleToStartTimeout != nil {
		n38, err38 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StickyScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyScheduleToStartTimeout):])
		if err38 != nil {
			return 0, err38
		}
		i -= n38
		i = encodeVarintMessage(dAtA, i, uint64(n38))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x92
	}
	if len(m.StickyTaskQueue) > 0 {
		i -= len(m.StickyTaskQueue)
		copy(dAtA[i:], m.StickyTaskQueue)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.StickyTaskQueue)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x8a
	}
	if len(m.CancelRequestId) > 0 {
		i -= len(m.CancelRequestId)
		copy(dAtA[i:], m.CancelRequestId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.CancelRequestId)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if len(m.WorkflowTaskRequestId) > 0 {
		i -= len(m.WorkflowTaskRequestId)
		copy(dAtA[i:], m.WorkflowTaskRequestId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowTaskRequestId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if m.WorkflowTaskOriginalScheduledTime != nil {
		n39, err39 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowTaskOriginalScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskOriginalScheduledTime):])
		if err39 != nil {
			return 0, err39
		}
		i -= n39
		i = encodeVarintMessage(dAtA, i, uint64(n39))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if m.CancelRequested {
		i--
		if m.CancelRequested {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe8
	}
	if m.WorkflowTaskScheduledTime != nil {
		n40, err40 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowTaskScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskScheduledTime):])
		if err40 != nil {
			return 0, err40
		}
		i -= n40
		i = encodeVarintMessage(dAtA, i, uint64(n40))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if m.WorkflowTaskStartedTime != nil {
		n41, err41 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.WorkflowTaskStartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskStartedTime):])
		if err41 != nil {
			return 0, err41
		}
		i -= n41
		i = encodeVarintMessage(dAtA, i, uint64(n41))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if m.WorkflowTaskAttempt != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskAttempt))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.WorkflowTaskTimeout != nil {
		n42, err42 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.WorkflowTaskTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowTaskTimeout):])
		if err42 != nil {
			return 0, err42
		}
		i -= n42
		i = encodeVarintMessage(dAtA, i, uint64(n42))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if m.WorkflowTaskStartedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskStartedId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.WorkflowTaskScheduleId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskScheduleId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.WorkflowTaskVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.WorkflowTaskVersion))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.LastUpdateTime != nil {
		n43, err43 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.LastUpdateTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUpdateTime):])
		if err43 != nil {
			return 0, err43
		}
		i -= n43
		i = encodeVarintMessage(dAtA, i, uint64(n43))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.StartTime != nil {
		n44, err44 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime):])
		if err44 != nil {
			return 0, err44
		}
		i -= n44
		i = encodeVarintMessage(dAtA, i, uint64(n44))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.LastProcessedEvent != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastProcessedEvent))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.LastFirstEventId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastFirstEventId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.LastEventTaskId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.LastEventTaskId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.StartVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x70
	}
	if m.DefaultWorkflowTaskTimeout != nil {
		n45, err45 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.DefaultWorkflowTaskTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DefaultWorkflowTaskTimeout):])
		if err45 != nil {
			return 0, err45
		}
		i -= n45
		i = encodeVarintMessage(dAtA, i, uint64(n45))
		i--
		dAtA[i] = 0x6a
	}
	if m.WorkflowRunTimeout != nil {
		n46, err46 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.WorkflowRunTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowRunTimeout):])
		if err46 != nil {
			return 0, err46
		}
		i -= n46
		i = encodeVarintMessage(dAtA, i, uint64(n46))
		i--
		dAtA[i] = 0x62
	}
	if m.WorkflowExecutionTimeout != nil {
		n47, err47 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.WorkflowExecutionTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowExecutionTimeout):])
		if err47 != nil {
			return 0, err47
		}
		i -= n47
		i = encodeVarintMessage(dAtA, i, uint64(n47))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.WorkflowTypeName) > 0 {
		i -= len(m.WorkflowTypeName)
		copy(dAtA[i:], m.WorkflowTypeName)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowTypeName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.TaskQueue) > 0 {
		i -= len(m.TaskQueue)
		copy(dAtA[i:], m.TaskQueue)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.TaskQueue)))
		i--
		dAtA[i] = 0x4a
	}
	if m.CompletionEvent != nil {
		{
			size, err := m.CompletionEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CompletionEventBatchId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.CompletionEventBatchId))
		i--
		dAtA[i] = 0x38
	}
	if m.InitiatedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x30
	}
	if len(m.ParentRunId) > 0 {
		i -= len(m.ParentRunId)
		copy(dAtA[i:], m.ParentRunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ParentRunId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ParentWorkflowId) > 0 {
		i -= len(m.ParentWorkflowId)
		copy(dAtA[i:], m.ParentWorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ParentWorkflowId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ParentNamespaceId) > 0 {
		i -= len(m.ParentNamespaceId)
		copy(dAtA[i:], m.ParentNamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ParentNamespaceId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Checksum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Checksum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Checksum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Flavor != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Flavor))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ChildExecutionInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChildExecutionInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ChildExecutionInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InitiatedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.InitiatedId))
		i--
		dAtA[i] = 0x60
	}
	if m.ParentClosePolicy != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ParentClosePolicy))
		i--
		dAtA[i] = 0x58
	}
	if len(m.WorkflowTypeName) > 0 {
		i -= len(m.WorkflowTypeName)
		copy(dAtA[i:], m.WorkflowTypeName)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.WorkflowTypeName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.CreateRequestId) > 0 {
		i -= len(m.CreateRequestId)
		copy(dAtA[i:], m.CreateRequestId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.CreateRequestId)))
		i--
		dAtA[i] = 0x42
	}
	if m.StartedEvent != nil {
		{
			size, err := m.StartedEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.StartedRunId) > 0 {
		i -= len(m.StartedRunId)
		copy(dAtA[i:], m.StartedRunId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.StartedRunId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.StartedWorkflowId) > 0 {
		i -= len(m.StartedWorkflowId)
		copy(dAtA[i:], m.StartedWorkflowId)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.StartedWorkflowId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.InitiatedEvent != nil {
		{
			size, err := m.InitiatedEvent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.StartedId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.StartedId))
		i--
		dAtA[i] = 0x18
	}
	if m.InitiatedEventBatchId != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.InitiatedEventBatchId))
		i--
		dAtA[i] = 0x10
	}
	if m.Version != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FailoverEndTime != nil {
		n51, err51 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.FailoverEndTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.FailoverEndTime):])
		if err51 != nil {
			return 0, err51
		}
		i -= n51
		i = encodeVarintMessage(dAtA, i, uint64(n51))
		i--
		dAtA[i] = 0x3a
	}
	if m.FailoverVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FailoverVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.FailoverNotificationVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.FailoverNotificationVersion))
		i--
		dAtA[i] = 0x28
	}
	if m.ConfigVersion != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.ConfigVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.ReplicationConfig != nil {
		{
			size, err := m.ReplicationConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		for k := range m.Data {
			v := m.Data[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintMessage(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMessage(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMessage(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Owner) > 0 {
		i -= len(m.Owner)
		copy(dAtA[i:], m.Owner)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Owner)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if m.State != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceReplicationConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceReplicationConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceReplicationConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for iNdEx := len(m.Clusters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Clusters[iNdEx])
			copy(dAtA[i:], m.Clusters[iNdEx])
			i = encodeVarintMessage(dAtA, i, uint64(len(m.Clusters[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ActiveClusterName) > 0 {
		i -= len(m.ActiveClusterName)
		copy(dAtA[i:], m.ActiveClusterName)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ActiveClusterName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NamespaceConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NamespaceConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.VisibilityArchivalUri) > 0 {
		i -= len(m.VisibilityArchivalUri)
		copy(dAtA[i:], m.VisibilityArchivalUri)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.VisibilityArchivalUri)))
		i--
		dAtA[i] = 0x3a
	}
	if m.VisibilityArchivalState != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.VisibilityArchivalState))
		i--
		dAtA[i] = 0x30
	}
	if len(m.HistoryArchivalUri) > 0 {
		i -= len(m.HistoryArchivalUri)
		copy(dAtA[i:], m.HistoryArchivalUri)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.HistoryArchivalUri)))
		i--
		dAtA[i] = 0x2a
	}
	if m.HistoryArchivalState != 0 {
		i = encodeVarintMessage(dAtA, i, uint64(m.HistoryArchivalState))
		i--
		dAtA[i] = 0x20
	}
	if m.BadBinaries != nil {
		{
			size, err := m.BadBinaries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ArchivalBucket) > 0 {
		i -= len(m.ArchivalBucket)
		copy(dAtA[i:], m.ArchivalBucket)
		i = encodeVarintMessage(dAtA, i, uint64(len(m.ArchivalBucket)))
		i--
		dAtA[i] = 0x12
	}
	if m.Retention != nil {
		n56, err56 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Retention, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Retention):])
		if err56 != nil {
			return 0, err56
		}
		i -= n56
		i = encodeVarintMessage(dAtA, i, uint64(n56))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplicationVersions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationVersions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicationVersions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastWriteVersion != nil {
		{
			size, err := m.LastWriteVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.StartVersion != nil {
		{
			size, err := m.StartVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMessage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMessage(dAtA []byte, offset int, v uint64) int {
	offset -= sovMessage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ExecutionStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HistorySize != 0 {
		n += 1 + sovMessage(uint64(m.HistorySize))
	}
	return n
}

func (m *ClusterMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.HistoryShardCount != 0 {
		n += 1 + sovMessage(uint64(m.HistoryShardCount))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.VersionInfo != nil {
		l = m.VersionInfo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *ActivityInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.ScheduledEventBatchId != 0 {
		n += 1 + sovMessage(uint64(m.ScheduledEventBatchId))
	}
	if m.ScheduledEvent != nil {
		l = m.ScheduledEvent.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartedId != 0 {
		n += 1 + sovMessage(uint64(m.StartedId))
	}
	if m.StartedEvent != nil {
		l = m.StartedEvent.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.ActivityId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ScheduleToCloseTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToCloseTimeout)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartToCloseTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StartToCloseTimeout)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.HeartbeatTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.HeartbeatTimeout)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.CancelRequested {
		n += 2
	}
	if m.CancelRequestId != 0 {
		n += 1 + sovMessage(uint64(m.CancelRequestId))
	}
	if m.TimerTaskStatus != 0 {
		n += 2 + sovMessage(uint64(m.TimerTaskStatus))
	}
	if m.Attempt != 0 {
		n += 2 + sovMessage(uint64(m.Attempt))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	l = len(m.StartedIdentity)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.HasRetryPolicy {
		n += 3
	}
	if m.RetryInitialInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.RetryMaximumInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.RetryMaximumAttempts != 0 {
		n += 2 + sovMessage(uint64(m.RetryMaximumAttempts))
	}
	if m.RetryExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.RetryExpirationTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.RetryBackoffCoefficient != 0 {
		n += 10
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for _, s := range m.RetryNonRetryableErrorTypes {
			l = len(s)
			n += 2 + l + sovMessage(uint64(l))
		}
	}
	if m.RetryLastFailure != nil {
		l = m.RetryLastFailure.Size()
		n += 2 + l + sovMessage(uint64(l))
	}
	l = len(m.RetryLastWorkerIdentity)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	l = len(m.NamespaceId)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 2 + sovMessage(uint64(m.ScheduleId))
	}
	if m.LastHeartbeatDetails != nil {
		l = m.LastHeartbeatDetails.Size()
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.LastHeartbeatUpdateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastHeartbeatUpdateTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *ShardInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovMessage(uint64(m.ShardId))
	}
	if m.RangeId != 0 {
		n += 1 + sovMessage(uint64(m.RangeId))
	}
	l = len(m.Owner)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ReplicationAckLevel != 0 {
		n += 1 + sovMessage(uint64(m.ReplicationAckLevel))
	}
	if m.TransferAckLevel != 0 {
		n += 1 + sovMessage(uint64(m.TransferAckLevel))
	}
	if m.StolenSinceRenew != 0 {
		n += 1 + sovMessage(uint64(m.StolenSinceRenew))
	}
	if m.UpdateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.UpdateTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TimerAckLevelTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.TimerAckLevelTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.NamespaceNotificationVersion != 0 {
		n += 1 + sovMessage(uint64(m.NamespaceNotificationVersion))
	}
	if len(m.ClusterTransferAckLevel) > 0 {
		for k, v := range m.ClusterTransferAckLevel {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + sovMessage(uint64(v))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	if len(m.ClusterTimerAckLevel) > 0 {
		for k, v := range m.ClusterTimerAckLevel {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = github_com_gogo_protobuf_types.SizeOfStdTime(*v)
				l += 1 + sovMessage(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	if len(m.ClusterReplicationLevel) > 0 {
		for k, v := range m.ClusterReplicationLevel {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + sovMessage(uint64(v))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	if len(m.ReplicationDlqAckLevel) > 0 {
		for k, v := range m.ReplicationDlqAckLevel {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + sovMessage(uint64(v))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ReplicationTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovMessage(uint64(m.TaskType))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.FirstEventId != 0 {
		n += 1 + sovMessage(uint64(m.FirstEventId))
	}
	if m.NextEventId != 0 {
		n += 1 + sovMessage(uint64(m.NextEventId))
	}
	if m.ScheduledId != 0 {
		n += 1 + sovMessage(uint64(m.ScheduledId))
	}
	if m.EventStoreVersion != 0 {
		n += 1 + sovMessage(uint64(m.EventStoreVersion))
	}
	if m.NewRunEventStoreVersion != 0 {
		n += 1 + sovMessage(uint64(m.NewRunEventStoreVersion))
	}
	l = len(m.BranchToken)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.NewRunBranchToken)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskId != 0 {
		n += 1 + sovMessage(uint64(m.TaskId))
	}
	return n
}

func (m *TimerTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovMessage(uint64(m.TaskType))
	}
	if m.TimeoutType != 0 {
		n += 1 + sovMessage(uint64(m.TimeoutType))
	}
	if m.WorkflowBackoffType != 0 {
		n += 1 + sovMessage(uint64(m.WorkflowBackoffType))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.ScheduleAttempt != 0 {
		n += 1 + sovMessage(uint64(m.ScheduleAttempt))
	}
	if m.EventId != 0 {
		n += 1 + sovMessage(uint64(m.EventId))
	}
	if m.TaskId != 0 {
		n += 1 + sovMessage(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *TransferTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovMessage(uint64(m.TaskType))
	}
	l = len(m.TargetNamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.TargetWorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.TargetRunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TargetChildWorkflowOnly {
		n += 2
	}
	if m.ScheduleId != 0 {
		n += 1 + sovMessage(uint64(m.ScheduleId))
	}
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.TaskId != 0 {
		n += 1 + sovMessage(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.RecordVisibility {
		n += 2
	}
	return n
}

func (m *HistoryBranchRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.BranchId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.BeginNodeId != 0 {
		n += 1 + sovMessage(uint64(m.BeginNodeId))
	}
	if m.EndNodeId != 0 {
		n += 1 + sovMessage(uint64(m.EndNodeId))
	}
	return n
}

func (m *HistoryBranch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TreeId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.BranchId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.Ancestors) > 0 {
		for _, e := range m.Ancestors {
			l = e.Size()
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	return n
}

func (m *HistoryTreeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BranchInfo != nil {
		l = m.BranchInfo.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ForkTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ForkTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *TimerInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.StartedId != 0 {
		n += 1 + sovMessage(uint64(m.StartedId))
	}
	if m.ExpiryTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskStatus != 0 {
		n += 1 + sovMessage(uint64(m.TaskStatus))
	}
	l = len(m.TimerId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *TaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 1 + sovMessage(uint64(m.ScheduleId))
	}
	if m.CreateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CreateTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ExpiryTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *AllocatedTaskInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Data != nil {
		l = m.Data.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskId != 0 {
		n += 1 + sovMessage(uint64(m.TaskId))
	}
	return n
}

func (m *TaskQueueInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.TaskType != 0 {
		n += 1 + sovMessage(uint64(m.TaskType))
	}
	if m.Kind != 0 {
		n += 1 + sovMessage(uint64(m.Kind))
	}
	if m.AckLevel != 0 {
		n += 1 + sovMessage(uint64(m.AckLevel))
	}
	if m.ExpiryTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ExpiryTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastUpdateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUpdateTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *SignalInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.InitiatedEventBatchId != 0 {
		n += 1 + sovMessage(uint64(m.InitiatedEventBatchId))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Input != nil {
		l = m.Input.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Control)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovMessage(uint64(m.InitiatedId))
	}
	return n
}

func (m *RequestCancelInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.InitiatedEventBatchId != 0 {
		n += 1 + sovMessage(uint64(m.InitiatedEventBatchId))
	}
	l = len(m.CancelRequestId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovMessage(uint64(m.InitiatedId))
	}
	return n
}

func (m *WorkflowExecutionState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CreateRequestId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovMessage(uint64(m.State))
	}
	if m.Status != 0 {
		n += 1 + sovMessage(uint64(m.Status))
	}
	return n
}

func (m *WorkflowExecutionInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.ParentNamespaceId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.ParentWorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.ParentRunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovMessage(uint64(m.InitiatedId))
	}
	if m.CompletionEventBatchId != 0 {
		n += 1 + sovMessage(uint64(m.CompletionEventBatchId))
	}
	if m.CompletionEvent != nil {
		l = m.CompletionEvent.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.TaskQueue)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowTypeName)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.WorkflowExecutionTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowExecutionTimeout)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.WorkflowRunTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowRunTimeout)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.DefaultWorkflowTaskTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DefaultWorkflowTaskTimeout)
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovMessage(uint64(m.StartVersion))
	}
	if m.LastEventTaskId != 0 {
		n += 2 + sovMessage(uint64(m.LastEventTaskId))
	}
	if m.LastFirstEventId != 0 {
		n += 2 + sovMessage(uint64(m.LastFirstEventId))
	}
	if m.LastProcessedEvent != 0 {
		n += 2 + sovMessage(uint64(m.LastProcessedEvent))
	}
	if m.StartTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.LastUpdateTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.LastUpdateTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.WorkflowTaskVersion != 0 {
		n += 2 + sovMessage(uint64(m.WorkflowTaskVersion))
	}
	if m.WorkflowTaskScheduleId != 0 {
		n += 2 + sovMessage(uint64(m.WorkflowTaskScheduleId))
	}
	if m.WorkflowTaskStartedId != 0 {
		n += 2 + sovMessage(uint64(m.WorkflowTaskStartedId))
	}
	if m.WorkflowTaskTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.WorkflowTaskTimeout)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.WorkflowTaskAttempt != 0 {
		n += 2 + sovMessage(uint64(m.WorkflowTaskAttempt))
	}
	if m.WorkflowTaskStartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskStartedTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.WorkflowTaskScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskScheduledTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.CancelRequested {
		n += 3
	}
	if m.WorkflowTaskOriginalScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.WorkflowTaskOriginalScheduledTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowTaskRequestId)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	l = len(m.CancelRequestId)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	l = len(m.StickyTaskQueue)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.StickyScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StickyScheduleToStartTimeout)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.Attempt != 0 {
		n += 2 + sovMessage(uint64(m.Attempt))
	}
	if m.RetryInitialInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryInitialInterval)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.RetryMaximumInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RetryMaximumInterval)
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.RetryMaximumAttempts != 0 {
		n += 2 + sovMessage(uint64(m.RetryMaximumAttempts))
	}
	if m.RetryBackoffCoefficient != 0 {
		n += 10
	}
	if m.RetryExpirationTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.RetryExpirationTime)
		n += 2 + l + sovMessage(uint64(l))
	}
	if len(m.RetryNonRetryableErrorTypes) > 0 {
		for _, s := range m.RetryNonRetryableErrorTypes {
			l = len(s)
			n += 2 + l + sovMessage(uint64(l))
		}
	}
	if m.HasRetryPolicy {
		n += 3
	}
	l = len(m.CronSchedule)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.EventStoreVersion != 0 {
		n += 2 + sovMessage(uint64(m.EventStoreVersion))
	}
	l = len(m.EventBranchToken)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.SignalCount != 0 {
		n += 2 + sovMessage(uint64(m.SignalCount))
	}
	if m.HistorySize != 0 {
		n += 2 + sovMessage(uint64(m.HistorySize))
	}
	if m.AutoResetPoints != nil {
		l = m.AutoResetPoints.Size()
		n += 2 + l + sovMessage(uint64(l))
	}
	if len(m.SearchAttributes) > 0 {
		for k, v := range m.SearchAttributes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovMessage(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovMessage(uint64(mapEntrySize))
		}
	}
	if len(m.Memo) > 0 {
		for k, v := range m.Memo {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovMessage(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovMessage(uint64(mapEntrySize))
		}
	}
	if m.VersionHistories != nil {
		l = m.VersionHistories.Size()
		n += 2 + l + sovMessage(uint64(l))
	}
	l = len(m.FirstExecutionRunId)
	if l > 0 {
		n += 2 + l + sovMessage(uint64(l))
	}
	if m.ExecutionStats != nil {
		l = m.ExecutionStats.Size()
		n += 2 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *Checksum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.Flavor != 0 {
		n += 1 + sovMessage(uint64(m.Flavor))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *ChildExecutionInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Version != 0 {
		n += 1 + sovMessage(uint64(m.Version))
	}
	if m.InitiatedEventBatchId != 0 {
		n += 1 + sovMessage(uint64(m.InitiatedEventBatchId))
	}
	if m.StartedId != 0 {
		n += 1 + sovMessage(uint64(m.StartedId))
	}
	if m.InitiatedEvent != nil {
		l = m.InitiatedEvent.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.StartedWorkflowId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.StartedRunId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.StartedEvent != nil {
		l = m.StartedEvent.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.CreateRequestId)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.WorkflowTypeName)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ParentClosePolicy != 0 {
		n += 1 + sovMessage(uint64(m.ParentClosePolicy))
	}
	if m.InitiatedId != 0 {
		n += 1 + sovMessage(uint64(m.InitiatedId))
	}
	return n
}

func (m *NamespaceDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ReplicationConfig != nil {
		l = m.ReplicationConfig.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.ConfigVersion != 0 {
		n += 1 + sovMessage(uint64(m.ConfigVersion))
	}
	if m.FailoverNotificationVersion != 0 {
		n += 1 + sovMessage(uint64(m.FailoverNotificationVersion))
	}
	if m.FailoverVersion != 0 {
		n += 1 + sovMessage(uint64(m.FailoverVersion))
	}
	if m.FailoverEndTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.FailoverEndTime)
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *NamespaceInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovMessage(uint64(m.State))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.Owner)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.Data) > 0 {
		for k, v := range m.Data {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovMessage(uint64(len(k))) + 1 + len(v) + sovMessage(uint64(len(v)))
			n += mapEntrySize + 1 + sovMessage(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *NamespaceReplicationConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ActiveClusterName)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if len(m.Clusters) > 0 {
		for _, s := range m.Clusters {
			l = len(s)
			n += 1 + l + sovMessage(uint64(l))
		}
	}
	return n
}

func (m *NamespaceConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Retention != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Retention)
		n += 1 + l + sovMessage(uint64(l))
	}
	l = len(m.ArchivalBucket)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.BadBinaries != nil {
		l = m.BadBinaries.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.HistoryArchivalState != 0 {
		n += 1 + sovMessage(uint64(m.HistoryArchivalState))
	}
	l = len(m.HistoryArchivalUri)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.VisibilityArchivalState != 0 {
		n += 1 + sovMessage(uint64(m.VisibilityArchivalState))
	}
	l = len(m.VisibilityArchivalUri)
	if l > 0 {
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func (m *ReplicationVersions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartVersion != nil {
		l = m.StartVersion.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	if m.LastWriteVersion != nil {
		l = m.LastWriteVersion.Size()
		n += 1 + l + sovMessage(uint64(l))
	}
	return n
}

func sovMessage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMessage(x uint64) (n int) {
	return sovMessage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ExecutionStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecutionStats{`,
		`HistorySize:` + fmt.Sprintf("%v", this.HistorySize) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClusterMetadata) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClusterMetadata{`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`HistoryShardCount:` + fmt.Sprintf("%v", this.HistoryShardCount) + `,`,
		`ClusterId:` + fmt.Sprintf("%v", this.ClusterId) + `,`,
		`VersionInfo:` + strings.Replace(fmt.Sprintf("%v", this.VersionInfo), "VersionInfo", "v1.VersionInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ActivityInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ActivityInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`ScheduledEventBatchId:` + fmt.Sprintf("%v", this.ScheduledEventBatchId) + `,`,
		`ScheduledEvent:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledEvent), "HistoryEvent", "v11.HistoryEvent", 1) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`StartedEvent:` + strings.Replace(fmt.Sprintf("%v", this.StartedEvent), "HistoryEvent", "v11.HistoryEvent", 1) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ActivityId:` + fmt.Sprintf("%v", this.ActivityId) + `,`,
		`RequestId:` + fmt.Sprintf("%v", this.RequestId) + `,`,
		`ScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.ScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`ScheduleToCloseTimeout:` + strings.Replace(fmt.Sprintf("%v", this.ScheduleToCloseTimeout), "Duration", "types.Duration", 1) + `,`,
		`StartToCloseTimeout:` + strings.Replace(fmt.Sprintf("%v", this.StartToCloseTimeout), "Duration", "types.Duration", 1) + `,`,
		`HeartbeatTimeout:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatTimeout), "Duration", "types.Duration", 1) + `,`,
		`CancelRequested:` + fmt.Sprintf("%v", this.CancelRequested) + `,`,
		`CancelRequestId:` + fmt.Sprintf("%v", this.CancelRequestId) + `,`,
		`TimerTaskStatus:` + fmt.Sprintf("%v", this.TimerTaskStatus) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`StartedIdentity:` + fmt.Sprintf("%v", this.StartedIdentity) + `,`,
		`HasRetryPolicy:` + fmt.Sprintf("%v", this.HasRetryPolicy) + `,`,
		`RetryInitialInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryInitialInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryMaximumInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumAttempts:` + fmt.Sprintf("%v", this.RetryMaximumAttempts) + `,`,
		`RetryExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.RetryExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`RetryBackoffCoefficient:` + fmt.Sprintf("%v", this.RetryBackoffCoefficient) + `,`,
		`RetryNonRetryableErrorTypes:` + fmt.Sprintf("%v", this.RetryNonRetryableErrorTypes) + `,`,
		`RetryLastFailure:` + strings.Replace(fmt.Sprintf("%v", this.RetryLastFailure), "Failure", "v12.Failure", 1) + `,`,
		`RetryLastWorkerIdentity:` + fmt.Sprintf("%v", this.RetryLastWorkerIdentity) + `,`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`LastHeartbeatDetails:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatDetails), "Payloads", "v13.Payloads", 1) + `,`,
		`LastHeartbeatUpdateTime:` + strings.Replace(fmt.Sprintf("%v", this.LastHeartbeatUpdateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ShardInfo) String() string {
	if this == nil {
		return "nil"
	}
	keysForClusterTransferAckLevel := make([]string, 0, len(this.ClusterTransferAckLevel))
	for k, _ := range this.ClusterTransferAckLevel {
		keysForClusterTransferAckLevel = append(keysForClusterTransferAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTransferAckLevel)
	mapStringForClusterTransferAckLevel := "map[string]int64{"
	for _, k := range keysForClusterTransferAckLevel {
		mapStringForClusterTransferAckLevel += fmt.Sprintf("%v: %v,", k, this.ClusterTransferAckLevel[k])
	}
	mapStringForClusterTransferAckLevel += "}"
	keysForClusterTimerAckLevel := make([]string, 0, len(this.ClusterTimerAckLevel))
	for k, _ := range this.ClusterTimerAckLevel {
		keysForClusterTimerAckLevel = append(keysForClusterTimerAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterTimerAckLevel)
	mapStringForClusterTimerAckLevel := "map[string]*time.Time{"
	for _, k := range keysForClusterTimerAckLevel {
		mapStringForClusterTimerAckLevel += fmt.Sprintf("%v: %v,", k, this.ClusterTimerAckLevel[k])
	}
	mapStringForClusterTimerAckLevel += "}"
	keysForClusterReplicationLevel := make([]string, 0, len(this.ClusterReplicationLevel))
	for k, _ := range this.ClusterReplicationLevel {
		keysForClusterReplicationLevel = append(keysForClusterReplicationLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForClusterReplicationLevel)
	mapStringForClusterReplicationLevel := "map[string]int64{"
	for _, k := range keysForClusterReplicationLevel {
		mapStringForClusterReplicationLevel += fmt.Sprintf("%v: %v,", k, this.ClusterReplicationLevel[k])
	}
	mapStringForClusterReplicationLevel += "}"
	keysForReplicationDlqAckLevel := make([]string, 0, len(this.ReplicationDlqAckLevel))
	for k, _ := range this.ReplicationDlqAckLevel {
		keysForReplicationDlqAckLevel = append(keysForReplicationDlqAckLevel, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReplicationDlqAckLevel)
	mapStringForReplicationDlqAckLevel := "map[string]int64{"
	for _, k := range keysForReplicationDlqAckLevel {
		mapStringForReplicationDlqAckLevel += fmt.Sprintf("%v: %v,", k, this.ReplicationDlqAckLevel[k])
	}
	mapStringForReplicationDlqAckLevel += "}"
	s := strings.Join([]string{`&ShardInfo{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`RangeId:` + fmt.Sprintf("%v", this.RangeId) + `,`,
		`Owner:` + fmt.Sprintf("%v", this.Owner) + `,`,
		`ReplicationAckLevel:` + fmt.Sprintf("%v", this.ReplicationAckLevel) + `,`,
		`TransferAckLevel:` + fmt.Sprintf("%v", this.TransferAckLevel) + `,`,
		`StolenSinceRenew:` + fmt.Sprintf("%v", this.StolenSinceRenew) + `,`,
		`UpdateTime:` + strings.Replace(fmt.Sprintf("%v", this.UpdateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`TimerAckLevelTime:` + strings.Replace(fmt.Sprintf("%v", this.TimerAckLevelTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`NamespaceNotificationVersion:` + fmt.Sprintf("%v", this.NamespaceNotificationVersion) + `,`,
		`ClusterTransferAckLevel:` + mapStringForClusterTransferAckLevel + `,`,
		`ClusterTimerAckLevel:` + mapStringForClusterTimerAckLevel + `,`,
		`ClusterReplicationLevel:` + mapStringForClusterReplicationLevel + `,`,
		`ReplicationDlqAckLevel:` + mapStringForReplicationDlqAckLevel + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`FirstEventId:` + fmt.Sprintf("%v", this.FirstEventId) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`ScheduledId:` + fmt.Sprintf("%v", this.ScheduledId) + `,`,
		`EventStoreVersion:` + fmt.Sprintf("%v", this.EventStoreVersion) + `,`,
		`NewRunEventStoreVersion:` + fmt.Sprintf("%v", this.NewRunEventStoreVersion) + `,`,
		`BranchToken:` + fmt.Sprintf("%v", this.BranchToken) + `,`,
		`NewRunBranchToken:` + fmt.Sprintf("%v", this.NewRunBranchToken) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TimerTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TimerTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`TimeoutType:` + fmt.Sprintf("%v", this.TimeoutType) + `,`,
		`WorkflowBackoffType:` + fmt.Sprintf("%v", this.WorkflowBackoffType) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`ScheduleAttempt:` + fmt.Sprintf("%v", this.ScheduleAttempt) + `,`,
		`EventId:` + fmt.Sprintf("%v", this.EventId) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TransferTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TransferTaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`TargetNamespaceId:` + fmt.Sprintf("%v", this.TargetNamespaceId) + `,`,
		`TargetWorkflowId:` + fmt.Sprintf("%v", this.TargetWorkflowId) + `,`,
		`TargetRunId:` + fmt.Sprintf("%v", this.TargetRunId) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`TargetChildWorkflowOnly:` + fmt.Sprintf("%v", this.TargetChildWorkflowOnly) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`RecordVisibility:` + fmt.Sprintf("%v", this.RecordVisibility) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryBranchRange) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryBranchRange{`,
		`BranchId:` + fmt.Sprintf("%v", this.BranchId) + `,`,
		`BeginNodeId:` + fmt.Sprintf("%v", this.BeginNodeId) + `,`,
		`EndNodeId:` + fmt.Sprintf("%v", this.EndNodeId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryBranch) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAncestors := "[]*HistoryBranchRange{"
	for _, f := range this.Ancestors {
		repeatedStringForAncestors += strings.Replace(f.String(), "HistoryBranchRange", "HistoryBranchRange", 1) + ","
	}
	repeatedStringForAncestors += "}"
	s := strings.Join([]string{`&HistoryBranch{`,
		`TreeId:` + fmt.Sprintf("%v", this.TreeId) + `,`,
		`BranchId:` + fmt.Sprintf("%v", this.BranchId) + `,`,
		`Ancestors:` + repeatedStringForAncestors + `,`,
		`}`,
	}, "")
	return s
}
func (this *HistoryTreeInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HistoryTreeInfo{`,
		`BranchInfo:` + strings.Replace(this.BranchInfo.String(), "HistoryBranch", "HistoryBranch", 1) + `,`,
		`ForkTime:` + strings.Replace(fmt.Sprintf("%v", this.ForkTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Info:` + fmt.Sprintf("%v", this.Info) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TimerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TimerInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`ExpiryTime:` + strings.Replace(fmt.Sprintf("%v", this.ExpiryTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`TaskStatus:` + fmt.Sprintf("%v", this.TaskStatus) + `,`,
		`TimerId:` + fmt.Sprintf("%v", this.TimerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`CreateTime:` + strings.Replace(fmt.Sprintf("%v", this.CreateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ExpiryTime:` + strings.Replace(fmt.Sprintf("%v", this.ExpiryTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AllocatedTaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AllocatedTaskInfo{`,
		`Data:` + strings.Replace(this.Data.String(), "TaskInfo", "TaskInfo", 1) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskQueueInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskQueueInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`TaskType:` + fmt.Sprintf("%v", this.TaskType) + `,`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`AckLevel:` + fmt.Sprintf("%v", this.AckLevel) + `,`,
		`ExpiryTime:` + strings.Replace(fmt.Sprintf("%v", this.ExpiryTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastUpdateTime:` + strings.Replace(fmt.Sprintf("%v", this.LastUpdateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SignalInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SignalInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`InitiatedEventBatchId:` + fmt.Sprintf("%v", this.InitiatedEventBatchId) + `,`,
		`RequestId:` + fmt.Sprintf("%v", this.RequestId) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Input:` + strings.Replace(fmt.Sprintf("%v", this.Input), "Payloads", "v13.Payloads", 1) + `,`,
		`Control:` + fmt.Sprintf("%v", this.Control) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RequestCancelInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RequestCancelInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`InitiatedEventBatchId:` + fmt.Sprintf("%v", this.InitiatedEventBatchId) + `,`,
		`CancelRequestId:` + fmt.Sprintf("%v", this.CancelRequestId) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WorkflowExecutionState) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WorkflowExecutionState{`,
		`CreateRequestId:` + fmt.Sprintf("%v", this.CreateRequestId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WorkflowExecutionInfo) String() string {
	if this == nil {
		return "nil"
	}
	keysForSearchAttributes := make([]string, 0, len(this.SearchAttributes))
	for k, _ := range this.SearchAttributes {
		keysForSearchAttributes = append(keysForSearchAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttributes)
	mapStringForSearchAttributes := "map[string]*v13.Payload{"
	for _, k := range keysForSearchAttributes {
		mapStringForSearchAttributes += fmt.Sprintf("%v: %v,", k, this.SearchAttributes[k])
	}
	mapStringForSearchAttributes += "}"
	keysForMemo := make([]string, 0, len(this.Memo))
	for k, _ := range this.Memo {
		keysForMemo = append(keysForMemo, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMemo)
	mapStringForMemo := "map[string]*v13.Payload{"
	for _, k := range keysForMemo {
		mapStringForMemo += fmt.Sprintf("%v: %v,", k, this.Memo[k])
	}
	mapStringForMemo += "}"
	s := strings.Join([]string{`&WorkflowExecutionInfo{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`ParentNamespaceId:` + fmt.Sprintf("%v", this.ParentNamespaceId) + `,`,
		`ParentWorkflowId:` + fmt.Sprintf("%v", this.ParentWorkflowId) + `,`,
		`ParentRunId:` + fmt.Sprintf("%v", this.ParentRunId) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`CompletionEventBatchId:` + fmt.Sprintf("%v", this.CompletionEventBatchId) + `,`,
		`CompletionEvent:` + strings.Replace(fmt.Sprintf("%v", this.CompletionEvent), "HistoryEvent", "v11.HistoryEvent", 1) + `,`,
		`TaskQueue:` + fmt.Sprintf("%v", this.TaskQueue) + `,`,
		`WorkflowTypeName:` + fmt.Sprintf("%v", this.WorkflowTypeName) + `,`,
		`WorkflowExecutionTimeout:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecutionTimeout), "Duration", "types.Duration", 1) + `,`,
		`WorkflowRunTimeout:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowRunTimeout), "Duration", "types.Duration", 1) + `,`,
		`DefaultWorkflowTaskTimeout:` + strings.Replace(fmt.Sprintf("%v", this.DefaultWorkflowTaskTimeout), "Duration", "types.Duration", 1) + `,`,
		`StartVersion:` + fmt.Sprintf("%v", this.StartVersion) + `,`,
		`LastEventTaskId:` + fmt.Sprintf("%v", this.LastEventTaskId) + `,`,
		`LastFirstEventId:` + fmt.Sprintf("%v", this.LastFirstEventId) + `,`,
		`LastProcessedEvent:` + fmt.Sprintf("%v", this.LastProcessedEvent) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`LastUpdateTime:` + strings.Replace(fmt.Sprintf("%v", this.LastUpdateTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`WorkflowTaskVersion:` + fmt.Sprintf("%v", this.WorkflowTaskVersion) + `,`,
		`WorkflowTaskScheduleId:` + fmt.Sprintf("%v", this.WorkflowTaskScheduleId) + `,`,
		`WorkflowTaskStartedId:` + fmt.Sprintf("%v", this.WorkflowTaskStartedId) + `,`,
		`WorkflowTaskTimeout:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskTimeout), "Duration", "types.Duration", 1) + `,`,
		`WorkflowTaskAttempt:` + fmt.Sprintf("%v", this.WorkflowTaskAttempt) + `,`,
		`WorkflowTaskStartedTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskStartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`WorkflowTaskScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`CancelRequested:` + fmt.Sprintf("%v", this.CancelRequested) + `,`,
		`WorkflowTaskOriginalScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskOriginalScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`WorkflowTaskRequestId:` + fmt.Sprintf("%v", this.WorkflowTaskRequestId) + `,`,
		`CancelRequestId:` + fmt.Sprintf("%v", this.CancelRequestId) + `,`,
		`StickyTaskQueue:` + fmt.Sprintf("%v", this.StickyTaskQueue) + `,`,
		`StickyScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.StickyScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`RetryInitialInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryInitialInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumInterval:` + strings.Replace(fmt.Sprintf("%v", this.RetryMaximumInterval), "Duration", "types.Duration", 1) + `,`,
		`RetryMaximumAttempts:` + fmt.Sprintf("%v", this.RetryMaximumAttempts) + `,`,
		`RetryBackoffCoefficient:` + fmt.Sprintf("%v", this.RetryBackoffCoefficient) + `,`,
		`RetryExpirationTime:` + strings.Replace(fmt.Sprintf("%v", this.RetryExpirationTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`RetryNonRetryableErrorTypes:` + fmt.Sprintf("%v", this.RetryNonRetryableErrorTypes) + `,`,
		`HasRetryPolicy:` + fmt.Sprintf("%v", this.HasRetryPolicy) + `,`,
		`CronSchedule:` + fmt.Sprintf("%v", this.CronSchedule) + `,`,
		`EventStoreVersion:` + fmt.Sprintf("%v", this.EventStoreVersion) + `,`,
		`EventBranchToken:` + fmt.Sprintf("%v", this.EventBranchToken) + `,`,
		`SignalCount:` + fmt.Sprintf("%v", this.SignalCount) + `,`,
		`HistorySize:` + fmt.Sprintf("%v", this.HistorySize) + `,`,
		`AutoResetPoints:` + strings.Replace(fmt.Sprintf("%v", this.AutoResetPoints), "ResetPoints", "v16.ResetPoints", 1) + `,`,
		`SearchAttributes:` + mapStringForSearchAttributes + `,`,
		`Memo:` + mapStringForMemo + `,`,
		`VersionHistories:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistories), "VersionHistories", "v17.VersionHistories", 1) + `,`,
		`FirstExecutionRunId:` + fmt.Sprintf("%v", this.FirstExecutionRunId) + `,`,
		`ExecutionStats:` + strings.Replace(this.ExecutionStats.String(), "ExecutionStats", "ExecutionStats", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Checksum) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Checksum{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`Flavor:` + fmt.Sprintf("%v", this.Flavor) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ChildExecutionInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ChildExecutionInfo{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`InitiatedEventBatchId:` + fmt.Sprintf("%v", this.InitiatedEventBatchId) + `,`,
		`StartedId:` + fmt.Sprintf("%v", this.StartedId) + `,`,
		`InitiatedEvent:` + strings.Replace(fmt.Sprintf("%v", this.InitiatedEvent), "HistoryEvent", "v11.HistoryEvent", 1) + `,`,
		`StartedWorkflowId:` + fmt.Sprintf("%v", this.StartedWorkflowId) + `,`,
		`StartedRunId:` + fmt.Sprintf("%v", this.StartedRunId) + `,`,
		`StartedEvent:` + strings.Replace(fmt.Sprintf("%v", this.StartedEvent), "HistoryEvent", "v11.HistoryEvent", 1) + `,`,
		`CreateRequestId:` + fmt.Sprintf("%v", this.CreateRequestId) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowTypeName:` + fmt.Sprintf("%v", this.WorkflowTypeName) + `,`,
		`ParentClosePolicy:` + fmt.Sprintf("%v", this.ParentClosePolicy) + `,`,
		`InitiatedId:` + fmt.Sprintf("%v", this.InitiatedId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceDetail) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceDetail{`,
		`Info:` + strings.Replace(this.Info.String(), "NamespaceInfo", "NamespaceInfo", 1) + `,`,
		`Config:` + strings.Replace(this.Config.String(), "NamespaceConfig", "NamespaceConfig", 1) + `,`,
		`ReplicationConfig:` + strings.Replace(this.ReplicationConfig.String(), "NamespaceReplicationConfig", "NamespaceReplicationConfig", 1) + `,`,
		`ConfigVersion:` + fmt.Sprintf("%v", this.ConfigVersion) + `,`,
		`FailoverNotificationVersion:` + fmt.Sprintf("%v", this.FailoverNotificationVersion) + `,`,
		`FailoverVersion:` + fmt.Sprintf("%v", this.FailoverVersion) + `,`,
		`FailoverEndTime:` + strings.Replace(fmt.Sprintf("%v", this.FailoverEndTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceInfo) String() string {
	if this == nil {
		return "nil"
	}
	keysForData := make([]string, 0, len(this.Data))
	for k, _ := range this.Data {
		keysForData = append(keysForData, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForData)
	mapStringForData := "map[string]string{"
	for _, k := range keysForData {
		mapStringForData += fmt.Sprintf("%v: %v,", k, this.Data[k])
	}
	mapStringForData += "}"
	s := strings.Join([]string{`&NamespaceInfo{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Description:` + fmt.Sprintf("%v", this.Description) + `,`,
		`Owner:` + fmt.Sprintf("%v", this.Owner) + `,`,
		`Data:` + mapStringForData + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceReplicationConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceReplicationConfig{`,
		`ActiveClusterName:` + fmt.Sprintf("%v", this.ActiveClusterName) + `,`,
		`Clusters:` + fmt.Sprintf("%v", this.Clusters) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NamespaceConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NamespaceConfig{`,
		`Retention:` + strings.Replace(fmt.Sprintf("%v", this.Retention), "Duration", "types.Duration", 1) + `,`,
		`ArchivalBucket:` + fmt.Sprintf("%v", this.ArchivalBucket) + `,`,
		`BadBinaries:` + strings.Replace(fmt.Sprintf("%v", this.BadBinaries), "BadBinaries", "v18.BadBinaries", 1) + `,`,
		`HistoryArchivalState:` + fmt.Sprintf("%v", this.HistoryArchivalState) + `,`,
		`HistoryArchivalUri:` + fmt.Sprintf("%v", this.HistoryArchivalUri) + `,`,
		`VisibilityArchivalState:` + fmt.Sprintf("%v", this.VisibilityArchivalState) + `,`,
		`VisibilityArchivalUri:` + fmt.Sprintf("%v", this.VisibilityArchivalUri) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReplicationVersions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReplicationVersions{`,
		`StartVersion:` + strings.Replace(fmt.Sprintf("%v", this.StartVersion), "Int64Value", "types.Int64Value", 1) + `,`,
		`LastWriteVersion:` + strings.Replace(fmt.Sprintf("%v", this.LastWriteVersion), "Int64Value", "types.Int64Value", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMessage(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ExecutionStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecutionStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecutionStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistorySize", wireType)
			}
			m.HistorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistorySize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryShardCount", wireType)
			}
			m.HistoryShardCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryShardCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionInfo == nil {
				m.VersionInfo = &v1.VersionInfo{}
			}
			if err := m.VersionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActivityInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActivityInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActivityInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledEventBatchId", wireType)
			}
			m.ScheduledEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledEvent == nil {
				m.ScheduledEvent = &v11.HistoryEvent{}
			}
			if err := m.ScheduledEvent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedEvent == nil {
				m.StartedEvent = &v11.HistoryEvent{}
			}
			if err := m.StartedEvent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleToStartTimeout == nil {
				m.ScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleToCloseTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleToCloseTimeout == nil {
				m.ScheduleToCloseTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ScheduleToCloseTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartToCloseTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartToCloseTimeout == nil {
				m.StartToCloseTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StartToCloseTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatTimeout == nil {
				m.HeartbeatTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.HeartbeatTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequested", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CancelRequested = bool(v != 0)
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequestId", wireType)
			}
			m.CancelRequestId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CancelRequestId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimerTaskStatus", wireType)
			}
			m.TimerTaskStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimerTaskStatus |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartedIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasRetryPolicy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasRetryPolicy = bool(v != 0)
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryInitialInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryInitialInterval == nil {
				m.RetryInitialInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryInitialInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryMaximumInterval == nil {
				m.RetryMaximumInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryMaximumInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumAttempts", wireType)
			}
			m.RetryMaximumAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RetryMaximumAttempts |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryExpirationTime == nil {
				m.RetryExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.RetryExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryBackoffCoefficient", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.RetryBackoffCoefficient = float64(math.Float64frombits(v))
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryNonRetryableErrorTypes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryNonRetryableErrorTypes = append(m.RetryNonRetryableErrorTypes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryLastFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryLastFailure == nil {
				m.RetryLastFailure = &v12.Failure{}
			}
			if err := m.RetryLastFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryLastWorkerIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryLastWorkerIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatDetails", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatDetails == nil {
				m.LastHeartbeatDetails = &v13.Payloads{}
			}
			if err := m.LastHeartbeatDetails.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeatUpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastHeartbeatUpdateTime == nil {
				m.LastHeartbeatUpdateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastHeartbeatUpdateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ShardInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ShardInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ShardInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeId", wireType)
			}
			m.RangeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Owner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationAckLevel", wireType)
			}
			m.ReplicationAckLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicationAckLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransferAckLevel", wireType)
			}
			m.TransferAckLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TransferAckLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StolenSinceRenew", wireType)
			}
			m.StolenSinceRenew = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StolenSinceRenew |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateTime == nil {
				m.UpdateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.UpdateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimerAckLevelTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimerAckLevelTime == nil {
				m.TimerAckLevelTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.TimerAckLevelTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceNotificationVersion", wireType)
			}
			m.NamespaceNotificationVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NamespaceNotificationVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterTransferAckLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterTransferAckLevel == nil {
				m.ClusterTransferAckLevel = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ClusterTransferAckLevel[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterTimerAckLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterTimerAckLevel == nil {
				m.ClusterTimerAckLevel = make(map[string]*time.Time)
			}
			var mapkey string
			mapvalue := new(time.Time)
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthMessage
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthMessage
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(mapvalue, dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ClusterTimerAckLevel[mapkey] = mapvalue
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterReplicationLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterReplicationLevel == nil {
				m.ClusterReplicationLevel = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ClusterReplicationLevel[mapkey] = mapvalue
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationDlqAckLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicationDlqAckLevel == nil {
				m.ReplicationDlqAckLevel = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ReplicationDlqAckLevel[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v14.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstEventId", wireType)
			}
			m.FirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledId", wireType)
			}
			m.ScheduledId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduledId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventStoreVersion", wireType)
			}
			m.EventStoreVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventStoreVersion |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewRunEventStoreVersion", wireType)
			}
			m.NewRunEventStoreVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NewRunEventStoreVersion |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchToken = append(m.BranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.BranchToken == nil {
				m.BranchToken = []byte{}
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewRunBranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewRunBranchToken = append(m.NewRunBranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NewRunBranchToken == nil {
				m.NewRunBranchToken = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimerTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimerTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimerTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v14.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutType", wireType)
			}
			m.TimeoutType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeoutType |= v15.TimeoutType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowBackoffType", wireType)
			}
			m.WorkflowBackoffType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowBackoffType |= v14.WorkflowBackoffType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleAttempt", wireType)
			}
			m.ScheduleAttempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleAttempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventId", wireType)
			}
			m.EventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransferTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransferTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransferTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v14.TaskType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetWorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetWorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetChildWorkflowOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TargetChildWorkflowOnly = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordVisibility", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RecordVisibility = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryBranchRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryBranchRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryBranchRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginNodeId", wireType)
			}
			m.BeginNodeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BeginNodeId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndNodeId", wireType)
			}
			m.EndNodeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndNodeId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryBranch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryBranch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryBranch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TreeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TreeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ancestors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ancestors = append(m.Ancestors, &HistoryBranchRange{})
			if err := m.Ancestors[len(m.Ancestors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryTreeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryTreeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryTreeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BranchInfo == nil {
				m.BranchInfo = &HistoryBranch{}
			}
			if err := m.BranchInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForkTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ForkTime == nil {
				m.ForkTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ForkTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimerInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimerInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimerInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiryTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiryTime == nil {
				m.ExpiryTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExpiryTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskStatus", wireType)
			}
			m.TaskStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskStatus |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreateTime == nil {
				m.CreateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CreateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiryTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiryTime == nil {
				m.ExpiryTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExpiryTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AllocatedTaskInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AllocatedTaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AllocatedTaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = &TaskInfo{}
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskQueueInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskQueueInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskQueueInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskType", wireType)
			}
			m.TaskType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskType |= v15.TaskQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= v15.TaskQueueKind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AckLevel", wireType)
			}
			m.AckLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AckLevel |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiryTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiryTime == nil {
				m.ExpiryTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ExpiryTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdateTime == nil {
				m.LastUpdateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastUpdateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignalInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignalInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignalInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedEventBatchId", wireType)
			}
			m.InitiatedEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Input", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Input == nil {
				m.Input = &v13.Payloads{}
			}
			if err := m.Input.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Control", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Control = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestCancelInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestCancelInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestCancelInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedEventBatchId", wireType)
			}
			m.InitiatedEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CancelRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WorkflowExecutionState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkflowExecutionState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkflowExecutionState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreateRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= v14.WorkflowExecutionState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= v15.WorkflowExecutionStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WorkflowExecutionInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkflowExecutionInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentWorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentWorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletionEventBatchId", wireType)
			}
			m.CompletionEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompletionEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletionEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletionEvent == nil {
				m.CompletionEvent = &v11.HistoryEvent{}
			}
			if err := m.CompletionEvent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTypeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTypeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionTimeout == nil {
				m.WorkflowExecutionTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.WorkflowExecutionTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowRunTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowRunTimeout == nil {
				m.WorkflowRunTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.WorkflowRunTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultWorkflowTaskTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultWorkflowTaskTimeout == nil {
				m.DefaultWorkflowTaskTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.DefaultWorkflowTaskTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastEventTaskId", wireType)
			}
			m.LastEventTaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastEventTaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastFirstEventId", wireType)
			}
			m.LastFirstEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastFirstEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastProcessedEvent", wireType)
			}
			m.LastProcessedEvent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastProcessedEvent |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdateTime == nil {
				m.LastUpdateTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.LastUpdateTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskVersion", wireType)
			}
			m.WorkflowTaskVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskScheduleId", wireType)
			}
			m.WorkflowTaskScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskStartedId", wireType)
			}
			m.WorkflowTaskStartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskStartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskTimeout == nil {
				m.WorkflowTaskTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.WorkflowTaskTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskAttempt", wireType)
			}
			m.WorkflowTaskAttempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WorkflowTaskAttempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskStartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskStartedTime == nil {
				m.WorkflowTaskStartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowTaskStartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskScheduledTime == nil {
				m.WorkflowTaskScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowTaskScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequested", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CancelRequested = bool(v != 0)
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskOriginalScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskOriginalScheduledTime == nil {
				m.WorkflowTaskOriginalScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.WorkflowTaskOriginalScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTaskRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CancelRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CancelRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyTaskQueue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StickyTaskQueue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StickyScheduleToStartTimeout == nil {
				m.StickyScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StickyScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryInitialInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryInitialInterval == nil {
				m.RetryInitialInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryInitialInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryMaximumInterval == nil {
				m.RetryMaximumInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RetryMaximumInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 38:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryMaximumAttempts", wireType)
			}
			m.RetryMaximumAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RetryMaximumAttempts |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 39:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryBackoffCoefficient", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.RetryBackoffCoefficient = float64(math.Float64frombits(v))
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryExpirationTime == nil {
				m.RetryExpirationTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.RetryExpirationTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryNonRetryableErrorTypes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryNonRetryableErrorTypes = append(m.RetryNonRetryableErrorTypes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 42:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasRetryPolicy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasRetryPolicy = bool(v != 0)
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CronSchedule", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CronSchedule = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 44:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventStoreVersion", wireType)
			}
			m.EventStoreVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventStoreVersion |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventBranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventBranchToken = append(m.EventBranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.EventBranchToken == nil {
				m.EventBranchToken = []byte{}
			}
			iNdEx = postIndex
		case 46:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignalCount", wireType)
			}
			m.SignalCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SignalCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 47:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistorySize", wireType)
			}
			m.HistorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistorySize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 51:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoResetPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AutoResetPoints == nil {
				m.AutoResetPoints = &v16.ResetPoints{}
			}
			if err := m.AutoResetPoints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 52:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttributes == nil {
				m.SearchAttributes = make(map[string]*v13.Payload)
			}
			var mapkey string
			var mapvalue *v13.Payload
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthMessage
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthMessage
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v13.Payload{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SearchAttributes[mapkey] = mapvalue
			iNdEx = postIndex
		case 53:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Memo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Memo == nil {
				m.Memo = make(map[string]*v13.Payload)
			}
			var mapkey string
			var mapvalue *v13.Payload
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthMessage
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthMessage
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v13.Payload{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Memo[mapkey] = mapvalue
			iNdEx = postIndex
		case 54:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistories", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistories == nil {
				m.VersionHistories = &v17.VersionHistories{}
			}
			if err := m.VersionHistories.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 55:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstExecutionRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FirstExecutionRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 56:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutionStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutionStats == nil {
				m.ExecutionStats = &ExecutionStats{}
			}
			if err := m.ExecutionStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Checksum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Checksum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Checksum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flavor", wireType)
			}
			m.Flavor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flavor |= v14.ChecksumFlavor(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChildExecutionInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChildExecutionInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChildExecutionInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedEventBatchId", wireType)
			}
			m.InitiatedEventBatchId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedEventBatchId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedId", wireType)
			}
			m.StartedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InitiatedEvent == nil {
				m.InitiatedEvent = &v11.HistoryEvent{}
			}
			if err := m.InitiatedEvent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedWorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartedWorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedRunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartedRunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedEvent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedEvent == nil {
				m.StartedEvent = &v11.HistoryEvent{}
			}
			if err := m.StartedEvent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateRequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreateRequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTypeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTypeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentClosePolicy", wireType)
			}
			m.ParentClosePolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentClosePolicy |= v15.ParentClosePolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatedId", wireType)
			}
			m.InitiatedId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InitiatedId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &NamespaceInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &NamespaceConfig{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicationConfig == nil {
				m.ReplicationConfig = &NamespaceReplicationConfig{}
			}
			if err := m.ReplicationConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigVersion", wireType)
			}
			m.ConfigVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConfigVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverNotificationVersion", wireType)
			}
			m.FailoverNotificationVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailoverNotificationVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverVersion", wireType)
			}
			m.FailoverVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FailoverVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverEndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FailoverEndTime == nil {
				m.FailoverEndTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.FailoverEndTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= v15.NamespaceState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Owner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMessage
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMessage
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthMessage
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMessage(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMessage
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Data[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceReplicationConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceReplicationConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceReplicationConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retention", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Retention == nil {
				m.Retention = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Retention, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ArchivalBucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ArchivalBucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BadBinaries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BadBinaries == nil {
				m.BadBinaries = &v18.BadBinaries{}
			}
			if err := m.BadBinaries.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryArchivalState", wireType)
			}
			m.HistoryArchivalState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HistoryArchivalState |= v15.ArchivalState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryArchivalUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryArchivalUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityArchivalState", wireType)
			}
			m.VisibilityArchivalState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VisibilityArchivalState |= v15.ArchivalState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityArchivalUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VisibilityArchivalUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationVersions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationVersions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationVersions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartVersion == nil {
				m.StartVersion = &types.Int64Value{}
			}
			if err := m.StartVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWriteVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMessage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMessage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastWriteVersion == nil {
				m.LastWriteVersion = &types.Int64Value{}
			}
			if err := m.LastWriteVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMessage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMessage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMessage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMessage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMessage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMessage
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMessage
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMessage
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMessage        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMessage          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMessage = fmt.Errorf("proto: unexpected end of group")
)
