// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/matchingservice/v1/request_response.proto

package matchingservice

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v11 "go.temporal.io/api/common/v1"
	v16 "go.temporal.io/api/enums/v1"
	v12 "go.temporal.io/api/query/v1"
	v14 "go.temporal.io/api/taskqueue/v1"
	v1 "go.temporal.io/api/workflowservice/v1"
	v15 "go.temporal.io/server/api/enums/v1"
	v13 "go.temporal.io/server/api/history/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type PollWorkflowTaskQueueRequest struct {
	NamespaceId     string                           `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	PollerId        string                           `protobuf:"bytes,2,opt,name=poller_id,json=pollerId,proto3" json:"poller_id,omitempty"`
	PollRequest     *v1.PollWorkflowTaskQueueRequest `protobuf:"bytes,3,opt,name=poll_request,json=pollRequest,proto3" json:"poll_request,omitempty"`
	ForwardedSource string                           `protobuf:"bytes,4,opt,name=forwarded_source,json=forwardedSource,proto3" json:"forwarded_source,omitempty"`
}

func (m *PollWorkflowTaskQueueRequest) Reset()      { *m = PollWorkflowTaskQueueRequest{} }
func (*PollWorkflowTaskQueueRequest) ProtoMessage() {}
func (*PollWorkflowTaskQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{0}
}
func (m *PollWorkflowTaskQueueRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PollWorkflowTaskQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PollWorkflowTaskQueueRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PollWorkflowTaskQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollWorkflowTaskQueueRequest.Merge(m, src)
}
func (m *PollWorkflowTaskQueueRequest) XXX_Size() int {
	return m.Size()
}
func (m *PollWorkflowTaskQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PollWorkflowTaskQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PollWorkflowTaskQueueRequest proto.InternalMessageInfo

func (m *PollWorkflowTaskQueueRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *PollWorkflowTaskQueueRequest) GetPollerId() string {
	if m != nil {
		return m.PollerId
	}
	return ""
}

func (m *PollWorkflowTaskQueueRequest) GetPollRequest() *v1.PollWorkflowTaskQueueRequest {
	if m != nil {
		return m.PollRequest
	}
	return nil
}

func (m *PollWorkflowTaskQueueRequest) GetForwardedSource() string {
	if m != nil {
		return m.ForwardedSource
	}
	return ""
}

type PollWorkflowTaskQueueResponse struct {
	TaskToken                  []byte                         `protobuf:"bytes,1,opt,name=task_token,json=taskToken,proto3" json:"task_token,omitempty"`
	WorkflowExecution          *v11.WorkflowExecution         `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	WorkflowType               *v11.WorkflowType              `protobuf:"bytes,3,opt,name=workflow_type,json=workflowType,proto3" json:"workflow_type,omitempty"`
	PreviousStartedEventId     int64                          `protobuf:"varint,4,opt,name=previous_started_event_id,json=previousStartedEventId,proto3" json:"previous_started_event_id,omitempty"`
	StartedEventId             int64                          `protobuf:"varint,5,opt,name=started_event_id,json=startedEventId,proto3" json:"started_event_id,omitempty"`
	Attempt                    int32                          `protobuf:"varint,6,opt,name=attempt,proto3" json:"attempt,omitempty"`
	NextEventId                int64                          `protobuf:"varint,7,opt,name=next_event_id,json=nextEventId,proto3" json:"next_event_id,omitempty"`
	BacklogCountHint           int64                          `protobuf:"varint,8,opt,name=backlog_count_hint,json=backlogCountHint,proto3" json:"backlog_count_hint,omitempty"`
	StickyExecutionEnabled     bool                           `protobuf:"varint,9,opt,name=sticky_execution_enabled,json=stickyExecutionEnabled,proto3" json:"sticky_execution_enabled,omitempty"`
	Query                      *v12.WorkflowQuery             `protobuf:"bytes,10,opt,name=query,proto3" json:"query,omitempty"`
	WorkflowTaskInfo           *v13.TransientWorkflowTaskInfo `protobuf:"bytes,11,opt,name=workflow_task_info,json=workflowTaskInfo,proto3" json:"workflow_task_info,omitempty"`
	WorkflowExecutionTaskQueue *v14.TaskQueue                 `protobuf:"bytes,12,opt,name=workflow_execution_task_queue,json=workflowExecutionTaskQueue,proto3" json:"workflow_execution_task_queue,omitempty"`
	EventStoreVersion          int32                          `protobuf:"varint,13,opt,name=event_store_version,json=eventStoreVersion,proto3" json:"event_store_version,omitempty"`
	BranchToken                []byte                         `protobuf:"bytes,14,opt,name=branch_token,json=branchToken,proto3" json:"branch_token,omitempty"`
	ScheduledTime              *time.Time                     `protobuf:"bytes,15,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	StartedTime                *time.Time                     `protobuf:"bytes,16,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	Queries                    map[string]*v12.WorkflowQuery  `protobuf:"bytes,17,rep,name=queries,proto3" json:"queries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *PollWorkflowTaskQueueResponse) Reset()      { *m = PollWorkflowTaskQueueResponse{} }
func (*PollWorkflowTaskQueueResponse) ProtoMessage() {}
func (*PollWorkflowTaskQueueResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{1}
}
func (m *PollWorkflowTaskQueueResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PollWorkflowTaskQueueResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PollWorkflowTaskQueueResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PollWorkflowTaskQueueResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollWorkflowTaskQueueResponse.Merge(m, src)
}
func (m *PollWorkflowTaskQueueResponse) XXX_Size() int {
	return m.Size()
}
func (m *PollWorkflowTaskQueueResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PollWorkflowTaskQueueResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PollWorkflowTaskQueueResponse proto.InternalMessageInfo

func (m *PollWorkflowTaskQueueResponse) GetTaskToken() []byte {
	if m != nil {
		return m.TaskToken
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetWorkflowExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetWorkflowType() *v11.WorkflowType {
	if m != nil {
		return m.WorkflowType
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetPreviousStartedEventId() int64 {
	if m != nil {
		return m.PreviousStartedEventId
	}
	return 0
}

func (m *PollWorkflowTaskQueueResponse) GetStartedEventId() int64 {
	if m != nil {
		return m.StartedEventId
	}
	return 0
}

func (m *PollWorkflowTaskQueueResponse) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *PollWorkflowTaskQueueResponse) GetNextEventId() int64 {
	if m != nil {
		return m.NextEventId
	}
	return 0
}

func (m *PollWorkflowTaskQueueResponse) GetBacklogCountHint() int64 {
	if m != nil {
		return m.BacklogCountHint
	}
	return 0
}

func (m *PollWorkflowTaskQueueResponse) GetStickyExecutionEnabled() bool {
	if m != nil {
		return m.StickyExecutionEnabled
	}
	return false
}

func (m *PollWorkflowTaskQueueResponse) GetQuery() *v12.WorkflowQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetWorkflowTaskInfo() *v13.TransientWorkflowTaskInfo {
	if m != nil {
		return m.WorkflowTaskInfo
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetWorkflowExecutionTaskQueue() *v14.TaskQueue {
	if m != nil {
		return m.WorkflowExecutionTaskQueue
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetEventStoreVersion() int32 {
	if m != nil {
		return m.EventStoreVersion
	}
	return 0
}

func (m *PollWorkflowTaskQueueResponse) GetBranchToken() []byte {
	if m != nil {
		return m.BranchToken
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *PollWorkflowTaskQueueResponse) GetQueries() map[string]*v12.WorkflowQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

type PollActivityTaskQueueRequest struct {
	NamespaceId     string                           `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	PollerId        string                           `protobuf:"bytes,2,opt,name=poller_id,json=pollerId,proto3" json:"poller_id,omitempty"`
	PollRequest     *v1.PollActivityTaskQueueRequest `protobuf:"bytes,3,opt,name=poll_request,json=pollRequest,proto3" json:"poll_request,omitempty"`
	ForwardedSource string                           `protobuf:"bytes,4,opt,name=forwarded_source,json=forwardedSource,proto3" json:"forwarded_source,omitempty"`
}

func (m *PollActivityTaskQueueRequest) Reset()      { *m = PollActivityTaskQueueRequest{} }
func (*PollActivityTaskQueueRequest) ProtoMessage() {}
func (*PollActivityTaskQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{2}
}
func (m *PollActivityTaskQueueRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PollActivityTaskQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PollActivityTaskQueueRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PollActivityTaskQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollActivityTaskQueueRequest.Merge(m, src)
}
func (m *PollActivityTaskQueueRequest) XXX_Size() int {
	return m.Size()
}
func (m *PollActivityTaskQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PollActivityTaskQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PollActivityTaskQueueRequest proto.InternalMessageInfo

func (m *PollActivityTaskQueueRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *PollActivityTaskQueueRequest) GetPollerId() string {
	if m != nil {
		return m.PollerId
	}
	return ""
}

func (m *PollActivityTaskQueueRequest) GetPollRequest() *v1.PollActivityTaskQueueRequest {
	if m != nil {
		return m.PollRequest
	}
	return nil
}

func (m *PollActivityTaskQueueRequest) GetForwardedSource() string {
	if m != nil {
		return m.ForwardedSource
	}
	return ""
}

type PollActivityTaskQueueResponse struct {
	TaskToken         []byte                 `protobuf:"bytes,1,opt,name=task_token,json=taskToken,proto3" json:"task_token,omitempty"`
	WorkflowExecution *v11.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	ActivityId        string                 `protobuf:"bytes,3,opt,name=activity_id,json=activityId,proto3" json:"activity_id,omitempty"`
	ActivityType      *v11.ActivityType      `protobuf:"bytes,4,opt,name=activity_type,json=activityType,proto3" json:"activity_type,omitempty"`
	Input             *v11.Payloads          `protobuf:"bytes,5,opt,name=input,proto3" json:"input,omitempty"`
	ScheduledTime     *time.Time             `protobuf:"bytes,6,opt,name=scheduled_time,json=scheduledTime,proto3,stdtime" json:"scheduled_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	ScheduleToCloseTimeout *time.Duration `protobuf:"bytes,7,opt,name=schedule_to_close_timeout,json=scheduleToCloseTimeout,proto3,stdduration" json:"schedule_to_close_timeout,omitempty"`
	StartedTime            *time.Time     `protobuf:"bytes,8,opt,name=started_time,json=startedTime,proto3,stdtime" json:"started_time,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	StartToCloseTimeout         *time.Duration    `protobuf:"bytes,9,opt,name=start_to_close_timeout,json=startToCloseTimeout,proto3,stdduration" json:"start_to_close_timeout,omitempty"`
	HeartbeatTimeout            *time.Duration    `protobuf:"bytes,10,opt,name=heartbeat_timeout,json=heartbeatTimeout,proto3,stdduration" json:"heartbeat_timeout,omitempty"`
	Attempt                     int32             `protobuf:"varint,11,opt,name=attempt,proto3" json:"attempt,omitempty"`
	CurrentAttemptScheduledTime *time.Time        `protobuf:"bytes,12,opt,name=current_attempt_scheduled_time,json=currentAttemptScheduledTime,proto3,stdtime" json:"current_attempt_scheduled_time,omitempty"`
	HeartbeatDetails            *v11.Payloads     `protobuf:"bytes,13,opt,name=heartbeat_details,json=heartbeatDetails,proto3" json:"heartbeat_details,omitempty"`
	WorkflowType                *v11.WorkflowType `protobuf:"bytes,14,opt,name=workflow_type,json=workflowType,proto3" json:"workflow_type,omitempty"`
	WorkflowNamespace           string            `protobuf:"bytes,15,opt,name=workflow_namespace,json=workflowNamespace,proto3" json:"workflow_namespace,omitempty"`
	Header                      *v11.Header       `protobuf:"bytes,16,opt,name=header,proto3" json:"header,omitempty"`
}

func (m *PollActivityTaskQueueResponse) Reset()      { *m = PollActivityTaskQueueResponse{} }
func (*PollActivityTaskQueueResponse) ProtoMessage() {}
func (*PollActivityTaskQueueResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{3}
}
func (m *PollActivityTaskQueueResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PollActivityTaskQueueResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PollActivityTaskQueueResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PollActivityTaskQueueResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollActivityTaskQueueResponse.Merge(m, src)
}
func (m *PollActivityTaskQueueResponse) XXX_Size() int {
	return m.Size()
}
func (m *PollActivityTaskQueueResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PollActivityTaskQueueResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PollActivityTaskQueueResponse proto.InternalMessageInfo

func (m *PollActivityTaskQueueResponse) GetTaskToken() []byte {
	if m != nil {
		return m.TaskToken
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetWorkflowExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetActivityId() string {
	if m != nil {
		return m.ActivityId
	}
	return ""
}

func (m *PollActivityTaskQueueResponse) GetActivityType() *v11.ActivityType {
	if m != nil {
		return m.ActivityType
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetInput() *v11.Payloads {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetScheduledTime() *time.Time {
	if m != nil {
		return m.ScheduledTime
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetScheduleToCloseTimeout() *time.Duration {
	if m != nil {
		return m.ScheduleToCloseTimeout
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetStartedTime() *time.Time {
	if m != nil {
		return m.StartedTime
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetStartToCloseTimeout() *time.Duration {
	if m != nil {
		return m.StartToCloseTimeout
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetHeartbeatTimeout() *time.Duration {
	if m != nil {
		return m.HeartbeatTimeout
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetAttempt() int32 {
	if m != nil {
		return m.Attempt
	}
	return 0
}

func (m *PollActivityTaskQueueResponse) GetCurrentAttemptScheduledTime() *time.Time {
	if m != nil {
		return m.CurrentAttemptScheduledTime
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetHeartbeatDetails() *v11.Payloads {
	if m != nil {
		return m.HeartbeatDetails
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetWorkflowType() *v11.WorkflowType {
	if m != nil {
		return m.WorkflowType
	}
	return nil
}

func (m *PollActivityTaskQueueResponse) GetWorkflowNamespace() string {
	if m != nil {
		return m.WorkflowNamespace
	}
	return ""
}

func (m *PollActivityTaskQueueResponse) GetHeader() *v11.Header {
	if m != nil {
		return m.Header
	}
	return nil
}

type AddWorkflowTaskRequest struct {
	NamespaceId string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Execution   *v11.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	TaskQueue   *v14.TaskQueue         `protobuf:"bytes,3,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	ScheduleId  int64                  `protobuf:"varint,4,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	ScheduleToStartTimeout *time.Duration `protobuf:"bytes,5,opt,name=schedule_to_start_timeout,json=scheduleToStartTimeout,proto3,stdduration" json:"schedule_to_start_timeout,omitempty"`
	ForwardedSource        string         `protobuf:"bytes,6,opt,name=forwarded_source,json=forwardedSource,proto3" json:"forwarded_source,omitempty"`
	Source                 v15.TaskSource `protobuf:"varint,7,opt,name=source,proto3,enum=temporal.server.api.enums.v1.TaskSource" json:"source,omitempty"`
}

func (m *AddWorkflowTaskRequest) Reset()      { *m = AddWorkflowTaskRequest{} }
func (*AddWorkflowTaskRequest) ProtoMessage() {}
func (*AddWorkflowTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{4}
}
func (m *AddWorkflowTaskRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddWorkflowTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddWorkflowTaskRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddWorkflowTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddWorkflowTaskRequest.Merge(m, src)
}
func (m *AddWorkflowTaskRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddWorkflowTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddWorkflowTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddWorkflowTaskRequest proto.InternalMessageInfo

func (m *AddWorkflowTaskRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *AddWorkflowTaskRequest) GetExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *AddWorkflowTaskRequest) GetTaskQueue() *v14.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

func (m *AddWorkflowTaskRequest) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *AddWorkflowTaskRequest) GetScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.ScheduleToStartTimeout
	}
	return nil
}

func (m *AddWorkflowTaskRequest) GetForwardedSource() string {
	if m != nil {
		return m.ForwardedSource
	}
	return ""
}

func (m *AddWorkflowTaskRequest) GetSource() v15.TaskSource {
	if m != nil {
		return m.Source
	}
	return v15.TASK_SOURCE_UNSPECIFIED
}

type AddWorkflowTaskResponse struct {
}

func (m *AddWorkflowTaskResponse) Reset()      { *m = AddWorkflowTaskResponse{} }
func (*AddWorkflowTaskResponse) ProtoMessage() {}
func (*AddWorkflowTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{5}
}
func (m *AddWorkflowTaskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddWorkflowTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddWorkflowTaskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddWorkflowTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddWorkflowTaskResponse.Merge(m, src)
}
func (m *AddWorkflowTaskResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddWorkflowTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddWorkflowTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddWorkflowTaskResponse proto.InternalMessageInfo

type AddActivityTaskRequest struct {
	NamespaceId       string                 `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	Execution         *v11.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	SourceNamespaceId string                 `protobuf:"bytes,3,opt,name=source_namespace_id,json=sourceNamespaceId,proto3" json:"source_namespace_id,omitempty"`
	TaskQueue         *v14.TaskQueue         `protobuf:"bytes,4,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	ScheduleId        int64                  `protobuf:"varint,5,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	// (-- api-linter: core::0140::prepositions=disabled
	//     aip.dev/not-precedent: "to" is used to indicate interval. --)
	ScheduleToStartTimeout *time.Duration `protobuf:"bytes,6,opt,name=schedule_to_start_timeout,json=scheduleToStartTimeout,proto3,stdduration" json:"schedule_to_start_timeout,omitempty"`
	ForwardedSource        string         `protobuf:"bytes,7,opt,name=forwarded_source,json=forwardedSource,proto3" json:"forwarded_source,omitempty"`
	Source                 v15.TaskSource `protobuf:"varint,8,opt,name=source,proto3,enum=temporal.server.api.enums.v1.TaskSource" json:"source,omitempty"`
}

func (m *AddActivityTaskRequest) Reset()      { *m = AddActivityTaskRequest{} }
func (*AddActivityTaskRequest) ProtoMessage() {}
func (*AddActivityTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{6}
}
func (m *AddActivityTaskRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddActivityTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddActivityTaskRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddActivityTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddActivityTaskRequest.Merge(m, src)
}
func (m *AddActivityTaskRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddActivityTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddActivityTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddActivityTaskRequest proto.InternalMessageInfo

func (m *AddActivityTaskRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *AddActivityTaskRequest) GetExecution() *v11.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *AddActivityTaskRequest) GetSourceNamespaceId() string {
	if m != nil {
		return m.SourceNamespaceId
	}
	return ""
}

func (m *AddActivityTaskRequest) GetTaskQueue() *v14.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

func (m *AddActivityTaskRequest) GetScheduleId() int64 {
	if m != nil {
		return m.ScheduleId
	}
	return 0
}

func (m *AddActivityTaskRequest) GetScheduleToStartTimeout() *time.Duration {
	if m != nil {
		return m.ScheduleToStartTimeout
	}
	return nil
}

func (m *AddActivityTaskRequest) GetForwardedSource() string {
	if m != nil {
		return m.ForwardedSource
	}
	return ""
}

func (m *AddActivityTaskRequest) GetSource() v15.TaskSource {
	if m != nil {
		return m.Source
	}
	return v15.TASK_SOURCE_UNSPECIFIED
}

type AddActivityTaskResponse struct {
}

func (m *AddActivityTaskResponse) Reset()      { *m = AddActivityTaskResponse{} }
func (*AddActivityTaskResponse) ProtoMessage() {}
func (*AddActivityTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{7}
}
func (m *AddActivityTaskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddActivityTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddActivityTaskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddActivityTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddActivityTaskResponse.Merge(m, src)
}
func (m *AddActivityTaskResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddActivityTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddActivityTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddActivityTaskResponse proto.InternalMessageInfo

type QueryWorkflowRequest struct {
	NamespaceId     string                   `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	TaskQueue       *v14.TaskQueue           `protobuf:"bytes,2,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	QueryRequest    *v1.QueryWorkflowRequest `protobuf:"bytes,3,opt,name=query_request,json=queryRequest,proto3" json:"query_request,omitempty"`
	ForwardedSource string                   `protobuf:"bytes,4,opt,name=forwarded_source,json=forwardedSource,proto3" json:"forwarded_source,omitempty"`
}

func (m *QueryWorkflowRequest) Reset()      { *m = QueryWorkflowRequest{} }
func (*QueryWorkflowRequest) ProtoMessage() {}
func (*QueryWorkflowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{8}
}
func (m *QueryWorkflowRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryWorkflowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryWorkflowRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryWorkflowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryWorkflowRequest.Merge(m, src)
}
func (m *QueryWorkflowRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryWorkflowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryWorkflowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryWorkflowRequest proto.InternalMessageInfo

func (m *QueryWorkflowRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *QueryWorkflowRequest) GetTaskQueue() *v14.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

func (m *QueryWorkflowRequest) GetQueryRequest() *v1.QueryWorkflowRequest {
	if m != nil {
		return m.QueryRequest
	}
	return nil
}

func (m *QueryWorkflowRequest) GetForwardedSource() string {
	if m != nil {
		return m.ForwardedSource
	}
	return ""
}

type QueryWorkflowResponse struct {
	QueryResult   *v11.Payloads      `protobuf:"bytes,1,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	QueryRejected *v12.QueryRejected `protobuf:"bytes,2,opt,name=query_rejected,json=queryRejected,proto3" json:"query_rejected,omitempty"`
}

func (m *QueryWorkflowResponse) Reset()      { *m = QueryWorkflowResponse{} }
func (*QueryWorkflowResponse) ProtoMessage() {}
func (*QueryWorkflowResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{9}
}
func (m *QueryWorkflowResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryWorkflowResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryWorkflowResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryWorkflowResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryWorkflowResponse.Merge(m, src)
}
func (m *QueryWorkflowResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryWorkflowResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryWorkflowResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryWorkflowResponse proto.InternalMessageInfo

func (m *QueryWorkflowResponse) GetQueryResult() *v11.Payloads {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *QueryWorkflowResponse) GetQueryRejected() *v12.QueryRejected {
	if m != nil {
		return m.QueryRejected
	}
	return nil
}

type RespondQueryTaskCompletedRequest struct {
	NamespaceId      string                               `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	TaskQueue        *v14.TaskQueue                       `protobuf:"bytes,2,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	TaskId           string                               `protobuf:"bytes,3,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	CompletedRequest *v1.RespondQueryTaskCompletedRequest `protobuf:"bytes,4,opt,name=completed_request,json=completedRequest,proto3" json:"completed_request,omitempty"`
}

func (m *RespondQueryTaskCompletedRequest) Reset()      { *m = RespondQueryTaskCompletedRequest{} }
func (*RespondQueryTaskCompletedRequest) ProtoMessage() {}
func (*RespondQueryTaskCompletedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{10}
}
func (m *RespondQueryTaskCompletedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondQueryTaskCompletedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondQueryTaskCompletedRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondQueryTaskCompletedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondQueryTaskCompletedRequest.Merge(m, src)
}
func (m *RespondQueryTaskCompletedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RespondQueryTaskCompletedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondQueryTaskCompletedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RespondQueryTaskCompletedRequest proto.InternalMessageInfo

func (m *RespondQueryTaskCompletedRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *RespondQueryTaskCompletedRequest) GetTaskQueue() *v14.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

func (m *RespondQueryTaskCompletedRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *RespondQueryTaskCompletedRequest) GetCompletedRequest() *v1.RespondQueryTaskCompletedRequest {
	if m != nil {
		return m.CompletedRequest
	}
	return nil
}

type RespondQueryTaskCompletedResponse struct {
}

func (m *RespondQueryTaskCompletedResponse) Reset()      { *m = RespondQueryTaskCompletedResponse{} }
func (*RespondQueryTaskCompletedResponse) ProtoMessage() {}
func (*RespondQueryTaskCompletedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{11}
}
func (m *RespondQueryTaskCompletedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RespondQueryTaskCompletedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RespondQueryTaskCompletedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RespondQueryTaskCompletedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RespondQueryTaskCompletedResponse.Merge(m, src)
}
func (m *RespondQueryTaskCompletedResponse) XXX_Size() int {
	return m.Size()
}
func (m *RespondQueryTaskCompletedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RespondQueryTaskCompletedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RespondQueryTaskCompletedResponse proto.InternalMessageInfo

type CancelOutstandingPollRequest struct {
	NamespaceId   string            `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	TaskQueueType v16.TaskQueueType `protobuf:"varint,2,opt,name=task_queue_type,json=taskQueueType,proto3,enum=temporal.api.enums.v1.TaskQueueType" json:"task_queue_type,omitempty"`
	TaskQueue     *v14.TaskQueue    `protobuf:"bytes,3,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
	PollerId      string            `protobuf:"bytes,4,opt,name=poller_id,json=pollerId,proto3" json:"poller_id,omitempty"`
}

func (m *CancelOutstandingPollRequest) Reset()      { *m = CancelOutstandingPollRequest{} }
func (*CancelOutstandingPollRequest) ProtoMessage() {}
func (*CancelOutstandingPollRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{12}
}
func (m *CancelOutstandingPollRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CancelOutstandingPollRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CancelOutstandingPollRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CancelOutstandingPollRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelOutstandingPollRequest.Merge(m, src)
}
func (m *CancelOutstandingPollRequest) XXX_Size() int {
	return m.Size()
}
func (m *CancelOutstandingPollRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelOutstandingPollRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelOutstandingPollRequest proto.InternalMessageInfo

func (m *CancelOutstandingPollRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *CancelOutstandingPollRequest) GetTaskQueueType() v16.TaskQueueType {
	if m != nil {
		return m.TaskQueueType
	}
	return v16.TASK_QUEUE_TYPE_UNSPECIFIED
}

func (m *CancelOutstandingPollRequest) GetTaskQueue() *v14.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

func (m *CancelOutstandingPollRequest) GetPollerId() string {
	if m != nil {
		return m.PollerId
	}
	return ""
}

type CancelOutstandingPollResponse struct {
}

func (m *CancelOutstandingPollResponse) Reset()      { *m = CancelOutstandingPollResponse{} }
func (*CancelOutstandingPollResponse) ProtoMessage() {}
func (*CancelOutstandingPollResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{13}
}
func (m *CancelOutstandingPollResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CancelOutstandingPollResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CancelOutstandingPollResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CancelOutstandingPollResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelOutstandingPollResponse.Merge(m, src)
}
func (m *CancelOutstandingPollResponse) XXX_Size() int {
	return m.Size()
}
func (m *CancelOutstandingPollResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelOutstandingPollResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CancelOutstandingPollResponse proto.InternalMessageInfo

type DescribeTaskQueueRequest struct {
	NamespaceId string                       `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	DescRequest *v1.DescribeTaskQueueRequest `protobuf:"bytes,2,opt,name=desc_request,json=descRequest,proto3" json:"desc_request,omitempty"`
}

func (m *DescribeTaskQueueRequest) Reset()      { *m = DescribeTaskQueueRequest{} }
func (*DescribeTaskQueueRequest) ProtoMessage() {}
func (*DescribeTaskQueueRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{14}
}
func (m *DescribeTaskQueueRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeTaskQueueRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeTaskQueueRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeTaskQueueRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeTaskQueueRequest.Merge(m, src)
}
func (m *DescribeTaskQueueRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeTaskQueueRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeTaskQueueRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeTaskQueueRequest proto.InternalMessageInfo

func (m *DescribeTaskQueueRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *DescribeTaskQueueRequest) GetDescRequest() *v1.DescribeTaskQueueRequest {
	if m != nil {
		return m.DescRequest
	}
	return nil
}

type DescribeTaskQueueResponse struct {
	Pollers         []*v14.PollerInfo    `protobuf:"bytes,1,rep,name=pollers,proto3" json:"pollers,omitempty"`
	TaskQueueStatus *v14.TaskQueueStatus `protobuf:"bytes,2,opt,name=task_queue_status,json=taskQueueStatus,proto3" json:"task_queue_status,omitempty"`
}

func (m *DescribeTaskQueueResponse) Reset()      { *m = DescribeTaskQueueResponse{} }
func (*DescribeTaskQueueResponse) ProtoMessage() {}
func (*DescribeTaskQueueResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{15}
}
func (m *DescribeTaskQueueResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeTaskQueueResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeTaskQueueResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeTaskQueueResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeTaskQueueResponse.Merge(m, src)
}
func (m *DescribeTaskQueueResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeTaskQueueResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeTaskQueueResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeTaskQueueResponse proto.InternalMessageInfo

func (m *DescribeTaskQueueResponse) GetPollers() []*v14.PollerInfo {
	if m != nil {
		return m.Pollers
	}
	return nil
}

func (m *DescribeTaskQueueResponse) GetTaskQueueStatus() *v14.TaskQueueStatus {
	if m != nil {
		return m.TaskQueueStatus
	}
	return nil
}

type ListTaskQueuePartitionsRequest struct {
	Namespace string         `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	TaskQueue *v14.TaskQueue `protobuf:"bytes,2,opt,name=task_queue,json=taskQueue,proto3" json:"task_queue,omitempty"`
}

func (m *ListTaskQueuePartitionsRequest) Reset()      { *m = ListTaskQueuePartitionsRequest{} }
func (*ListTaskQueuePartitionsRequest) ProtoMessage() {}
func (*ListTaskQueuePartitionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{16}
}
func (m *ListTaskQueuePartitionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListTaskQueuePartitionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListTaskQueuePartitionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListTaskQueuePartitionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTaskQueuePartitionsRequest.Merge(m, src)
}
func (m *ListTaskQueuePartitionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListTaskQueuePartitionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTaskQueuePartitionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTaskQueuePartitionsRequest proto.InternalMessageInfo

func (m *ListTaskQueuePartitionsRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ListTaskQueuePartitionsRequest) GetTaskQueue() *v14.TaskQueue {
	if m != nil {
		return m.TaskQueue
	}
	return nil
}

type ListTaskQueuePartitionsResponse struct {
	ActivityTaskQueuePartitions []*v14.TaskQueuePartitionMetadata `protobuf:"bytes,1,rep,name=activity_task_queue_partitions,json=activityTaskQueuePartitions,proto3" json:"activity_task_queue_partitions,omitempty"`
	WorkflowTaskQueuePartitions []*v14.TaskQueuePartitionMetadata `protobuf:"bytes,2,rep,name=workflow_task_queue_partitions,json=workflowTaskQueuePartitions,proto3" json:"workflow_task_queue_partitions,omitempty"`
}

func (m *ListTaskQueuePartitionsResponse) Reset()      { *m = ListTaskQueuePartitionsResponse{} }
func (*ListTaskQueuePartitionsResponse) ProtoMessage() {}
func (*ListTaskQueuePartitionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a429a3813476c583, []int{17}
}
func (m *ListTaskQueuePartitionsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListTaskQueuePartitionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListTaskQueuePartitionsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListTaskQueuePartitionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTaskQueuePartitionsResponse.Merge(m, src)
}
func (m *ListTaskQueuePartitionsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListTaskQueuePartitionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTaskQueuePartitionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTaskQueuePartitionsResponse proto.InternalMessageInfo

func (m *ListTaskQueuePartitionsResponse) GetActivityTaskQueuePartitions() []*v14.TaskQueuePartitionMetadata {
	if m != nil {
		return m.ActivityTaskQueuePartitions
	}
	return nil
}

func (m *ListTaskQueuePartitionsResponse) GetWorkflowTaskQueuePartitions() []*v14.TaskQueuePartitionMetadata {
	if m != nil {
		return m.WorkflowTaskQueuePartitions
	}
	return nil
}

func init() {
	proto.RegisterType((*PollWorkflowTaskQueueRequest)(nil), "temporal.server.api.matchingservice.v1.PollWorkflowTaskQueueRequest")
	proto.RegisterType((*PollWorkflowTaskQueueResponse)(nil), "temporal.server.api.matchingservice.v1.PollWorkflowTaskQueueResponse")
	proto.RegisterMapType((map[string]*v12.WorkflowQuery)(nil), "temporal.server.api.matchingservice.v1.PollWorkflowTaskQueueResponse.QueriesEntry")
	proto.RegisterType((*PollActivityTaskQueueRequest)(nil), "temporal.server.api.matchingservice.v1.PollActivityTaskQueueRequest")
	proto.RegisterType((*PollActivityTaskQueueResponse)(nil), "temporal.server.api.matchingservice.v1.PollActivityTaskQueueResponse")
	proto.RegisterType((*AddWorkflowTaskRequest)(nil), "temporal.server.api.matchingservice.v1.AddWorkflowTaskRequest")
	proto.RegisterType((*AddWorkflowTaskResponse)(nil), "temporal.server.api.matchingservice.v1.AddWorkflowTaskResponse")
	proto.RegisterType((*AddActivityTaskRequest)(nil), "temporal.server.api.matchingservice.v1.AddActivityTaskRequest")
	proto.RegisterType((*AddActivityTaskResponse)(nil), "temporal.server.api.matchingservice.v1.AddActivityTaskResponse")
	proto.RegisterType((*QueryWorkflowRequest)(nil), "temporal.server.api.matchingservice.v1.QueryWorkflowRequest")
	proto.RegisterType((*QueryWorkflowResponse)(nil), "temporal.server.api.matchingservice.v1.QueryWorkflowResponse")
	proto.RegisterType((*RespondQueryTaskCompletedRequest)(nil), "temporal.server.api.matchingservice.v1.RespondQueryTaskCompletedRequest")
	proto.RegisterType((*RespondQueryTaskCompletedResponse)(nil), "temporal.server.api.matchingservice.v1.RespondQueryTaskCompletedResponse")
	proto.RegisterType((*CancelOutstandingPollRequest)(nil), "temporal.server.api.matchingservice.v1.CancelOutstandingPollRequest")
	proto.RegisterType((*CancelOutstandingPollResponse)(nil), "temporal.server.api.matchingservice.v1.CancelOutstandingPollResponse")
	proto.RegisterType((*DescribeTaskQueueRequest)(nil), "temporal.server.api.matchingservice.v1.DescribeTaskQueueRequest")
	proto.RegisterType((*DescribeTaskQueueResponse)(nil), "temporal.server.api.matchingservice.v1.DescribeTaskQueueResponse")
	proto.RegisterType((*ListTaskQueuePartitionsRequest)(nil), "temporal.server.api.matchingservice.v1.ListTaskQueuePartitionsRequest")
	proto.RegisterType((*ListTaskQueuePartitionsResponse)(nil), "temporal.server.api.matchingservice.v1.ListTaskQueuePartitionsResponse")
}

func init() {
	proto.RegisterFile("temporal/server/api/matchingservice/v1/request_response.proto", fileDescriptor_a429a3813476c583)
}

var fileDescriptor_a429a3813476c583 = []byte{
	// 1733 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x4d, 0x6f, 0x13, 0xcd,
	0x1d, 0xcf, 0x3a, 0x89, 0x13, 0xcf, 0x3a, 0x89, 0xb3, 0xb4, 0xc1, 0x09, 0x64, 0x13, 0x0c, 0x85,
	0x50, 0xd1, 0xb5, 0x48, 0x05, 0x02, 0x5a, 0xd4, 0x86, 0x10, 0x81, 0x55, 0xa0, 0x61, 0x63, 0xd1,
	0x0a, 0x55, 0x5a, 0x26, 0xbb, 0x13, 0x67, 0x9b, 0xf5, 0x8e, 0xb3, 0x33, 0xeb, 0xe0, 0x9e, 0x2a,
	0x55, 0xbd, 0x23, 0xf5, 0xd2, 0xaa, 0x5f, 0xa0, 0x3d, 0xf4, 0xd4, 0x7e, 0x88, 0x1e, 0x7a, 0xe0,
	0xc8, 0xad, 0x25, 0xb9, 0x54, 0x7a, 0x2e, 0x3c, 0xdf, 0xe0, 0xd1, 0xbc, 0xec, 0x7a, 0x77, 0x6d,
	0x27, 0x4e, 0x88, 0x1e, 0x9e, 0x9b, 0xf7, 0xff, 0x36, 0xff, 0xd7, 0xdf, 0xfc, 0xc7, 0xe0, 0x21,
	0x45, 0xcd, 0x16, 0x0e, 0xa0, 0x57, 0x25, 0x28, 0x68, 0xa3, 0xa0, 0x0a, 0x5b, 0x6e, 0xb5, 0x09,
	0xa9, 0xbd, 0xeb, 0xfa, 0x0d, 0x46, 0x72, 0x6d, 0x54, 0x6d, 0xdf, 0xae, 0x06, 0x68, 0x3f, 0x44,
	0x84, 0x5a, 0x01, 0x22, 0x2d, 0xec, 0x13, 0x64, 0xb4, 0x02, 0x4c, 0xb1, 0x76, 0x3d, 0x52, 0x37,
	0x84, 0xba, 0x01, 0x5b, 0xae, 0x91, 0x51, 0x37, 0xda, 0xb7, 0x17, 0xf4, 0x06, 0xc6, 0x0d, 0x0f,
	0x55, 0xb9, 0xd6, 0x76, 0xb8, 0x53, 0x75, 0xc2, 0x00, 0x52, 0x17, 0xfb, 0xc2, 0xce, 0xc2, 0x52,
	0x96, 0x4f, 0xdd, 0x26, 0x22, 0x14, 0x36, 0x5b, 0x52, 0xe0, 0x8a, 0x83, 0x5a, 0xc8, 0x77, 0x90,
	0x6f, 0xbb, 0x88, 0x54, 0x1b, 0xb8, 0x81, 0x39, 0x9d, 0xff, 0x92, 0x22, 0xd7, 0xe2, 0x50, 0x58,
	0x0c, 0x36, 0x6e, 0x36, 0xb1, 0xcf, 0x5c, 0x6f, 0x22, 0x42, 0x60, 0x43, 0x7a, 0xbc, 0x70, 0x3d,
	0x25, 0x85, 0xfc, 0xb0, 0x49, 0x98, 0x10, 0x85, 0x64, 0xcf, 0xda, 0x0f, 0x51, 0x18, 0xc9, 0xdd,
	0x48, 0xc9, 0x31, 0x36, 0xe7, 0xf6, 0x1a, 0xbc, 0x9a, 0x12, 0xdc, 0x0f, 0x51, 0xd0, 0xe9, 0x15,
	0xba, 0xd1, 0x2f, 0xcd, 0xa9, 0xc3, 0xa5, 0xe0, 0xad, 0x7e, 0x82, 0xbb, 0x2e, 0xa1, 0xb8, 0x9f,
	0xd9, 0xbb, 0xa9, 0xb3, 0x0f, 0x70, 0xb0, 0xb7, 0xe3, 0xe1, 0x83, 0x13, 0xcb, 0x56, 0xf9, 0x4a,
	0x01, 0x97, 0x37, 0xb1, 0xe7, 0xfd, 0x4a, 0x6a, 0xd4, 0x21, 0xd9, 0x7b, 0xc9, 0xc2, 0x33, 0x85,
	0xbc, 0x76, 0x05, 0x14, 0x7d, 0xd8, 0x44, 0xa4, 0x05, 0x6d, 0x64, 0xb9, 0x4e, 0x59, 0x59, 0x56,
	0x56, 0x0a, 0xa6, 0x1a, 0xd3, 0x6a, 0x8e, 0x76, 0x09, 0x14, 0x5a, 0xd8, 0xf3, 0x50, 0xc0, 0xf8,
	0x39, 0xce, 0x9f, 0x14, 0x84, 0x9a, 0xa3, 0xbd, 0x01, 0x45, 0xf6, 0xdb, 0x92, 0xe7, 0x97, 0x47,
	0x97, 0x95, 0x15, 0x75, 0xf5, 0xa1, 0x11, 0xb7, 0x0b, 0xeb, 0x93, 0x8c, 0xbf, 0x46, 0xfb, 0xb6,
	0x71, 0x9c, 0x53, 0xa6, 0xca, 0x4c, 0x46, 0x1e, 0xde, 0x04, 0xa5, 0x1d, 0x1c, 0x1c, 0xc0, 0xc0,
	0x41, 0x8e, 0x45, 0x70, 0x18, 0xd8, 0xa8, 0x3c, 0xc6, 0xbd, 0x98, 0x89, 0xe9, 0x5b, 0x9c, 0x5c,
	0xf9, 0x47, 0x01, 0x2c, 0x0e, 0x30, 0x2c, 0xb2, 0xa2, 0x2d, 0x02, 0xc0, 0x1b, 0x80, 0xe2, 0x3d,
	0xe4, 0xf3, 0x60, 0x8b, 0x66, 0x81, 0x51, 0xea, 0x8c, 0xa0, 0xfd, 0x1a, 0x68, 0x91, 0xaf, 0x16,
	0x7a, 0x8b, 0xec, 0x90, 0x75, 0x2e, 0x8f, 0x59, 0x5d, 0xbd, 0x99, 0x8e, 0x49, 0xb4, 0x1d, 0x0b,
	0x25, 0x3a, 0x6d, 0x23, 0x52, 0x30, 0x67, 0x0f, 0xb2, 0x24, 0xad, 0x06, 0xa6, 0x62, 0xcb, 0xb4,
	0xd3, 0x42, 0x32, 0x51, 0xd7, 0x4e, 0x32, 0x5a, 0xef, 0xb4, 0x90, 0x59, 0x3c, 0x48, 0x7c, 0x69,
	0xf7, 0xc1, 0x7c, 0x2b, 0x40, 0x6d, 0x17, 0x87, 0xc4, 0x22, 0x14, 0x06, 0x14, 0x39, 0x16, 0x6a,
	0x23, 0x9f, 0xb2, 0xfa, 0xb0, 0xcc, 0x8c, 0x9a, 0x73, 0x91, 0xc0, 0x96, 0xe0, 0x6f, 0x30, 0x76,
	0xcd, 0xd1, 0x56, 0x40, 0xa9, 0x47, 0x63, 0x9c, 0x6b, 0x4c, 0x93, 0xb4, 0x64, 0x19, 0x4c, 0x40,
	0xca, 0x7c, 0xa3, 0xe5, 0xfc, 0xb2, 0xb2, 0x32, 0x6e, 0x46, 0x9f, 0x5a, 0x05, 0x4c, 0xf9, 0xe8,
	0x2d, 0xed, 0x1a, 0x98, 0xe0, 0x06, 0x54, 0x46, 0x8c, 0xb4, 0x6f, 0x01, 0x6d, 0x1b, 0xda, 0x7b,
	0x1e, 0x6e, 0x58, 0x36, 0x0e, 0x7d, 0x6a, 0xed, 0xba, 0x3e, 0x2d, 0x4f, 0x72, 0xc1, 0x92, 0xe4,
	0xac, 0x33, 0xc6, 0x53, 0xd7, 0xa7, 0xda, 0x3d, 0x50, 0x26, 0xd4, 0xb5, 0xf7, 0x3a, 0xdd, 0x9c,
	0x5b, 0xc8, 0x87, 0xdb, 0x1e, 0x72, 0xca, 0x85, 0x65, 0x65, 0x65, 0xd2, 0x9c, 0x13, 0xfc, 0x38,
	0x9d, 0x1b, 0x82, 0xab, 0x3d, 0x00, 0xe3, 0x7c, 0x0e, 0xcb, 0xa0, 0x5f, 0x36, 0x39, 0x2b, 0x99,
	0xcc, 0x97, 0x8c, 0x60, 0x0a, 0x15, 0xad, 0x91, 0xa8, 0x35, 0xef, 0x09, 0xd7, 0xdf, 0xc1, 0x65,
	0x95, 0x1b, 0xba, 0x6f, 0xf4, 0x83, 0x3b, 0x39, 0x9d, 0xcc, 0x62, 0x3d, 0x80, 0x3e, 0x71, 0x91,
	0x4f, 0x93, 0xad, 0x56, 0xf3, 0x77, 0xb0, 0x59, 0x3a, 0xc8, 0x50, 0xb4, 0x06, 0x58, 0xec, 0x6d,
	0x2a, 0xab, 0x8b, 0x43, 0xe5, 0x62, 0x3f, 0xe7, 0x63, 0x20, 0xe2, 0xc7, 0xc5, 0x8d, 0xbc, 0xd0,
	0xd3, 0x5a, 0x31, 0x4f, 0x33, 0xc0, 0x05, 0x51, 0x14, 0xe6, 0x26, 0xb2, 0xda, 0x28, 0x20, 0xac,
	0x7d, 0xa7, 0x78, 0xfd, 0x66, 0x39, 0x6b, 0x8b, 0x71, 0x5e, 0x09, 0x06, 0x9b, 0xfd, 0xed, 0x00,
	0xfa, 0xf6, 0xae, 0x1c, 0x87, 0x69, 0x3e, 0x0e, 0xaa, 0xa0, 0x89, 0x81, 0x78, 0x02, 0xa6, 0x89,
	0xbd, 0x8b, 0x9c, 0xd0, 0x43, 0x8e, 0xc5, 0xa0, 0xba, 0x3c, 0xc3, 0x9d, 0x5d, 0x30, 0x04, 0x8e,
	0x1b, 0x11, 0x8e, 0x1b, 0xf5, 0x08, 0xc7, 0x1f, 0x8d, 0xbd, 0xfb, 0xef, 0x92, 0x62, 0x4e, 0xc5,
	0x7a, 0x8c, 0xa3, 0xad, 0x83, 0x62, 0xd4, 0x79, 0xdc, 0x4c, 0x69, 0x48, 0x33, 0xaa, 0xd4, 0xe2,
	0x46, 0x3c, 0x30, 0xc1, 0x6a, 0xe7, 0x22, 0x52, 0x9e, 0x5d, 0x1e, 0x5d, 0x51, 0x57, 0x4d, 0x63,
	0xb8, 0x6b, 0xc9, 0x38, 0x16, 0x15, 0x8c, 0x97, 0xc2, 0xe8, 0x86, 0x4f, 0x83, 0x8e, 0x19, 0x1d,
	0xb1, 0xf0, 0x06, 0x14, 0x93, 0x0c, 0xad, 0x04, 0x46, 0xf7, 0x50, 0x47, 0x22, 0x24, 0xfb, 0xc9,
	0xda, 0xaf, 0x0d, 0xbd, 0x10, 0x49, 0x84, 0x18, 0xb2, 0xfd, 0xb8, 0xca, 0x83, 0xdc, 0x3d, 0x25,
	0x46, 0xe7, 0x35, 0x9b, 0xba, 0x6d, 0x97, 0x76, 0xbe, 0x53, 0xe8, 0x3c, 0xc8, 0xa9, 0x33, 0xa3,
	0xf3, 0x7f, 0x26, 0x05, 0x3a, 0xf7, 0x31, 0xfc, 0xa5, 0xd1, 0x79, 0x09, 0xa8, 0x50, 0x7a, 0xc5,
	0xd2, 0x38, 0xca, 0x03, 0x00, 0x11, 0xa9, 0xe6, 0x30, 0xf8, 0x8e, 0x05, 0x38, 0x7c, 0x8f, 0x1d,
	0x0f, 0xdf, 0x71, 0x8c, 0x1c, 0xbe, 0x61, 0xe2, 0x4b, 0xbb, 0x0b, 0xc6, 0x5d, 0xbf, 0x15, 0x52,
	0x0e, 0xbc, 0xea, 0xea, 0xf2, 0x20, 0x13, 0x9b, 0xb0, 0xe3, 0x61, 0xe8, 0x10, 0x53, 0x88, 0xf7,
	0x19, 0xc5, 0xfc, 0xd9, 0x46, 0xf1, 0x35, 0x98, 0x8f, 0x08, 0x16, 0xc5, 0x96, 0xed, 0x61, 0x82,
	0xb8, 0x41, 0x1c, 0x52, 0x0e, 0xe6, 0xea, 0xea, 0x7c, 0x8f, 0xcd, 0xc7, 0x72, 0x8d, 0x7b, 0x34,
	0xf6, 0x67, 0x66, 0x72, 0x2e, 0xb2, 0x50, 0xc7, 0xeb, 0x4c, 0xbf, 0x2e, 0xd4, 0x7b, 0xc6, 0x7c,
	0xf2, 0x2c, 0x63, 0x5e, 0x07, 0x73, 0xfc, 0xb3, 0xd7, 0xbb, 0xc2, 0x70, 0xde, 0x5d, 0xe0, 0xea,
	0x19, 0xd7, 0x9e, 0x81, 0xd9, 0x5d, 0x04, 0x03, 0xba, 0x8d, 0x20, 0x8d, 0x0d, 0x82, 0xe1, 0x0c,
	0x96, 0x62, 0xcd, 0xc8, 0x5a, 0xe2, 0x7e, 0x54, 0xd3, 0xf7, 0x23, 0x02, 0xba, 0x1d, 0x06, 0x01,
	0xc3, 0x61, 0x49, 0xb2, 0x32, 0x75, 0x2b, 0x0e, 0x99, 0x94, 0x4b, 0xd2, 0xce, 0x9a, 0x30, 0xb3,
	0x95, 0xaa, 0xe2, 0xf3, 0x64, 0x38, 0x0e, 0xa2, 0xd0, 0xf5, 0x08, 0x87, 0xfa, 0x61, 0x5a, 0xaa,
	0x1b, 0xcf, 0x63, 0xa1, 0xd9, 0xbb, 0x9f, 0x4c, 0x9f, 0x79, 0x3f, 0xf9, 0x51, 0x62, 0x4c, 0x63,
	0xa4, 0xe2, 0xf7, 0x46, 0xa1, 0x3b, 0x7b, 0x2f, 0x22, 0x86, 0x76, 0x17, 0xe4, 0x77, 0x11, 0x74,
	0x50, 0x20, 0xef, 0x04, 0x7d, 0xd0, 0x91, 0x4f, 0xb9, 0x94, 0x29, 0xa5, 0x2b, 0xff, 0x1c, 0x05,
	0x73, 0x6b, 0x8e, 0x93, 0x44, 0xf5, 0x53, 0xc0, 0xe6, 0x13, 0x50, 0xf8, 0x0c, 0x08, 0xe9, 0xea,
	0x6a, 0xeb, 0x12, 0xb3, 0xc4, 0x55, 0x3e, 0x7a, 0x8a, 0xab, 0x9c, 0x23, 0x9b, 0xb8, 0xb9, 0x97,
	0x80, 0x1a, 0x8f, 0x64, 0xbc, 0xc4, 0x81, 0x88, 0x54, 0x73, 0xb2, 0x33, 0x2b, 0xc7, 0x43, 0x36,
	0xf1, 0xf8, 0xa9, 0x67, 0x96, 0xaf, 0x85, 0x51, 0x2b, 0xf7, 0x83, 0xf0, 0x7c, 0x5f, 0x08, 0xd7,
	0x7e, 0x0e, 0xf2, 0x52, 0x80, 0xe1, 0xc4, 0xf4, 0xea, 0x4a, 0xdf, 0xfb, 0x97, 0x3f, 0x77, 0xa2,
	0x58, 0x85, 0xa6, 0x29, 0xf5, 0x2a, 0xf3, 0xe0, 0x62, 0x4f, 0xd1, 0x04, 0xfa, 0x57, 0x8e, 0x44,
	0x41, 0x93, 0xd7, 0xc3, 0x97, 0x28, 0xa8, 0x01, 0x2e, 0x08, 0x5f, 0xad, 0xd4, 0x91, 0xe2, 0x4e,
	0x98, 0x15, 0xac, 0x17, 0x89, 0x83, 0xd3, 0x0d, 0x30, 0x76, 0x2e, 0x0d, 0x30, 0x7e, 0xba, 0x06,
	0xc8, 0x9f, 0x7f, 0x03, 0x4c, 0x9c, 0xd4, 0x00, 0x93, 0x9f, 0xd5, 0x00, 0xe9, 0x22, 0xcb, 0x06,
	0xf8, 0x63, 0x0e, 0x7c, 0x8f, 0xef, 0x48, 0x51, 0x7d, 0x4e, 0x51, 0xfe, 0x74, 0x15, 0x72, 0x67,
	0xab, 0xc2, 0x6b, 0x30, 0xc5, 0x97, 0xb6, 0xcc, 0xbe, 0x74, 0xe7, 0xc4, 0x7d, 0xa9, 0x9f, 0xd7,
	0x66, 0x91, 0xdb, 0x3a, 0xc3, 0xa2, 0xf4, 0x77, 0x05, 0x7c, 0x3f, 0x63, 0x51, 0x2e, 0x48, 0xeb,
	0xa0, 0x18, 0x39, 0x48, 0x42, 0x8f, 0xf2, 0x44, 0x0c, 0x83, 0xf7, 0xaa, 0x74, 0x85, 0x29, 0x69,
	0xbf, 0x00, 0xd3, 0x91, 0x91, 0xdf, 0x22, 0x9b, 0x22, 0xe7, 0x84, 0xf5, 0x55, 0xac, 0xad, 0x52,
	0xd6, 0x9c, 0xda, 0x4f, 0x7e, 0x56, 0xfe, 0x94, 0x03, 0xcb, 0xc2, 0x3d, 0x87, 0xcb, 0xb1, 0xbc,
	0xae, 0xe3, 0x66, 0xcb, 0x43, 0x4c, 0xf8, 0x5b, 0xae, 0xdf, 0x45, 0x30, 0x21, 0x5e, 0x72, 0xd1,
	0xb8, 0xe6, 0xd9, 0x67, 0xcd, 0xd1, 0x7c, 0x30, 0x6b, 0x47, 0x4e, 0xc5, 0xc5, 0x15, 0xa3, 0xba,
	0x76, 0x62, 0x71, 0x4f, 0x0a, 0xcf, 0x2c, 0xd9, 0x19, 0x4a, 0xe5, 0x2a, 0xb8, 0x72, 0x8c, 0x96,
	0x6c, 0xf7, 0xaf, 0x15, 0x70, 0x79, 0x1d, 0xfa, 0x36, 0xf2, 0x7e, 0x19, 0x52, 0x42, 0xa1, 0xef,
	0xb8, 0x7e, 0x63, 0x33, 0xb1, 0x5b, 0x0f, 0x91, 0xb6, 0x67, 0x60, 0xa6, 0x9b, 0x36, 0x71, 0x71,
	0xe7, 0xf8, 0x60, 0x66, 0x72, 0x97, 0x9a, 0x48, 0x9e, 0x2c, 0x7e, 0x71, 0x4f, 0xd1, 0xe4, 0xe7,
	0xf9, 0xdc, 0x65, 0xa9, 0x07, 0xc9, 0x58, 0xfa, 0x41, 0x52, 0x59, 0x02, 0x8b, 0x03, 0x42, 0x96,
	0x49, 0xf9, 0xab, 0x02, 0xca, 0x8f, 0x11, 0xb1, 0x03, 0x77, 0x1b, 0x9d, 0xe5, 0x39, 0xf4, 0x1b,
	0x50, 0x74, 0x10, 0xb1, 0xe3, 0x22, 0xe7, 0xb2, 0xef, 0xf9, 0x01, 0x45, 0x1e, 0x74, 0xa6, 0xa9,
	0x32, 0x73, 0x51, 0x5d, 0xff, 0xa5, 0x80, 0xf9, 0x3e, 0x92, 0x72, 0x3a, 0x7f, 0x06, 0x26, 0x44,
	0xa0, 0xa4, 0xac, 0xf0, 0xe7, 0xe9, 0x0f, 0x8e, 0xc9, 0xdd, 0xa6, 0x48, 0x89, 0xbf, 0x83, 0xcd,
	0x48, 0x4b, 0x7b, 0x05, 0x66, 0x13, 0xd5, 0x24, 0x14, 0xd2, 0x90, 0xc8, 0x08, 0x7e, 0x38, 0x4c,
	0x19, 0xb6, 0xb8, 0x86, 0x39, 0x43, 0xd3, 0x84, 0xca, 0x1f, 0x14, 0xa0, 0x3f, 0x73, 0x09, 0x8d,
	0x05, 0x37, 0x61, 0x40, 0x5d, 0x76, 0x33, 0x90, 0x28, 0xb5, 0x97, 0x41, 0xa1, 0xbb, 0xab, 0x89,
	0xbc, 0x76, 0x09, 0xe7, 0x32, 0x9d, 0x95, 0xbf, 0xe4, 0xc0, 0xd2, 0x40, 0x2f, 0x64, 0x0a, 0x7f,
	0x07, 0xf4, 0xee, 0x3b, 0xab, 0x9b, 0x8a, 0x56, 0x2c, 0x29, 0x33, 0x7b, 0x67, 0x98, 0xc3, 0x63,
	0xfb, 0xcf, 0x11, 0x85, 0x0e, 0xa4, 0xd0, 0xbc, 0x04, 0xb3, 0x6f, 0xcf, 0xae, 0x0f, 0xec, 0xec,
	0xf4, 0x1f, 0x42, 0x3d, 0x67, 0xe7, 0x3e, 0xeb, 0xec, 0x83, 0xec, 0xff, 0x0f, 0xdd, 0xb3, 0x1f,
	0x05, 0xef, 0x3f, 0xea, 0x23, 0x1f, 0x3e, 0xea, 0x23, 0x9f, 0x3e, 0xea, 0xca, 0xef, 0x0f, 0x75,
	0xe5, 0x6f, 0x87, 0xba, 0xf2, 0xef, 0x43, 0x5d, 0x79, 0x7f, 0xa8, 0x2b, 0xff, 0x3b, 0xd4, 0x95,
	0xff, 0x1f, 0xea, 0x23, 0x9f, 0x0e, 0x75, 0xe5, 0xdd, 0x91, 0x3e, 0xf2, 0xfe, 0x48, 0x1f, 0xf9,
	0x70, 0xa4, 0x8f, 0xbc, 0xfe, 0x69, 0x03, 0x77, 0x7d, 0x71, 0xf1, 0xf1, 0xff, 0xec, 0xff, 0x24,
	0x43, 0xda, 0xce, 0xf3, 0x3d, 0xe1, 0xc7, 0xdf, 0x04, 0x00, 0x00, 0xff, 0xff, 0x04, 0x68, 0xa1,
	0xe5, 0x1a, 0x18, 0x00, 0x00,
}

func (this *PollWorkflowTaskQueueRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PollWorkflowTaskQueueRequest)
	if !ok {
		that2, ok := that.(PollWorkflowTaskQueueRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.PollerId != that1.PollerId {
		return false
	}
	if !this.PollRequest.Equal(that1.PollRequest) {
		return false
	}
	if this.ForwardedSource != that1.ForwardedSource {
		return false
	}
	return true
}
func (this *PollWorkflowTaskQueueResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PollWorkflowTaskQueueResponse)
	if !ok {
		that2, ok := that.(PollWorkflowTaskQueueResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.TaskToken, that1.TaskToken) {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if !this.WorkflowType.Equal(that1.WorkflowType) {
		return false
	}
	if this.PreviousStartedEventId != that1.PreviousStartedEventId {
		return false
	}
	if this.StartedEventId != that1.StartedEventId {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if this.NextEventId != that1.NextEventId {
		return false
	}
	if this.BacklogCountHint != that1.BacklogCountHint {
		return false
	}
	if this.StickyExecutionEnabled != that1.StickyExecutionEnabled {
		return false
	}
	if !this.Query.Equal(that1.Query) {
		return false
	}
	if !this.WorkflowTaskInfo.Equal(that1.WorkflowTaskInfo) {
		return false
	}
	if !this.WorkflowExecutionTaskQueue.Equal(that1.WorkflowExecutionTaskQueue) {
		return false
	}
	if this.EventStoreVersion != that1.EventStoreVersion {
		return false
	}
	if !bytes.Equal(this.BranchToken, that1.BranchToken) {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if len(this.Queries) != len(that1.Queries) {
		return false
	}
	for i := range this.Queries {
		if !this.Queries[i].Equal(that1.Queries[i]) {
			return false
		}
	}
	return true
}
func (this *PollActivityTaskQueueRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PollActivityTaskQueueRequest)
	if !ok {
		that2, ok := that.(PollActivityTaskQueueRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.PollerId != that1.PollerId {
		return false
	}
	if !this.PollRequest.Equal(that1.PollRequest) {
		return false
	}
	if this.ForwardedSource != that1.ForwardedSource {
		return false
	}
	return true
}
func (this *PollActivityTaskQueueResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PollActivityTaskQueueResponse)
	if !ok {
		that2, ok := that.(PollActivityTaskQueueResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.TaskToken, that1.TaskToken) {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if this.ActivityId != that1.ActivityId {
		return false
	}
	if !this.ActivityType.Equal(that1.ActivityType) {
		return false
	}
	if !this.Input.Equal(that1.Input) {
		return false
	}
	if that1.ScheduledTime == nil {
		if this.ScheduledTime != nil {
			return false
		}
	} else if !this.ScheduledTime.Equal(*that1.ScheduledTime) {
		return false
	}
	if this.ScheduleToCloseTimeout != nil && that1.ScheduleToCloseTimeout != nil {
		if *this.ScheduleToCloseTimeout != *that1.ScheduleToCloseTimeout {
			return false
		}
	} else if this.ScheduleToCloseTimeout != nil {
		return false
	} else if that1.ScheduleToCloseTimeout != nil {
		return false
	}
	if that1.StartedTime == nil {
		if this.StartedTime != nil {
			return false
		}
	} else if !this.StartedTime.Equal(*that1.StartedTime) {
		return false
	}
	if this.StartToCloseTimeout != nil && that1.StartToCloseTimeout != nil {
		if *this.StartToCloseTimeout != *that1.StartToCloseTimeout {
			return false
		}
	} else if this.StartToCloseTimeout != nil {
		return false
	} else if that1.StartToCloseTimeout != nil {
		return false
	}
	if this.HeartbeatTimeout != nil && that1.HeartbeatTimeout != nil {
		if *this.HeartbeatTimeout != *that1.HeartbeatTimeout {
			return false
		}
	} else if this.HeartbeatTimeout != nil {
		return false
	} else if that1.HeartbeatTimeout != nil {
		return false
	}
	if this.Attempt != that1.Attempt {
		return false
	}
	if that1.CurrentAttemptScheduledTime == nil {
		if this.CurrentAttemptScheduledTime != nil {
			return false
		}
	} else if !this.CurrentAttemptScheduledTime.Equal(*that1.CurrentAttemptScheduledTime) {
		return false
	}
	if !this.HeartbeatDetails.Equal(that1.HeartbeatDetails) {
		return false
	}
	if !this.WorkflowType.Equal(that1.WorkflowType) {
		return false
	}
	if this.WorkflowNamespace != that1.WorkflowNamespace {
		return false
	}
	if !this.Header.Equal(that1.Header) {
		return false
	}
	return true
}
func (this *AddWorkflowTaskRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddWorkflowTaskRequest)
	if !ok {
		that2, ok := that.(AddWorkflowTaskRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if this.ScheduleToStartTimeout != nil && that1.ScheduleToStartTimeout != nil {
		if *this.ScheduleToStartTimeout != *that1.ScheduleToStartTimeout {
			return false
		}
	} else if this.ScheduleToStartTimeout != nil {
		return false
	} else if that1.ScheduleToStartTimeout != nil {
		return false
	}
	if this.ForwardedSource != that1.ForwardedSource {
		return false
	}
	if this.Source != that1.Source {
		return false
	}
	return true
}
func (this *AddWorkflowTaskResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddWorkflowTaskResponse)
	if !ok {
		that2, ok := that.(AddWorkflowTaskResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *AddActivityTaskRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddActivityTaskRequest)
	if !ok {
		that2, ok := that.(AddActivityTaskRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if this.SourceNamespaceId != that1.SourceNamespaceId {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	if this.ScheduleId != that1.ScheduleId {
		return false
	}
	if this.ScheduleToStartTimeout != nil && that1.ScheduleToStartTimeout != nil {
		if *this.ScheduleToStartTimeout != *that1.ScheduleToStartTimeout {
			return false
		}
	} else if this.ScheduleToStartTimeout != nil {
		return false
	} else if that1.ScheduleToStartTimeout != nil {
		return false
	}
	if this.ForwardedSource != that1.ForwardedSource {
		return false
	}
	if this.Source != that1.Source {
		return false
	}
	return true
}
func (this *AddActivityTaskResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddActivityTaskResponse)
	if !ok {
		that2, ok := that.(AddActivityTaskResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *QueryWorkflowRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryWorkflowRequest)
	if !ok {
		that2, ok := that.(QueryWorkflowRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	if !this.QueryRequest.Equal(that1.QueryRequest) {
		return false
	}
	if this.ForwardedSource != that1.ForwardedSource {
		return false
	}
	return true
}
func (this *QueryWorkflowResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryWorkflowResponse)
	if !ok {
		that2, ok := that.(QueryWorkflowResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.QueryResult.Equal(that1.QueryResult) {
		return false
	}
	if !this.QueryRejected.Equal(that1.QueryRejected) {
		return false
	}
	return true
}
func (this *RespondQueryTaskCompletedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondQueryTaskCompletedRequest)
	if !ok {
		that2, ok := that.(RespondQueryTaskCompletedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if !this.CompletedRequest.Equal(that1.CompletedRequest) {
		return false
	}
	return true
}
func (this *RespondQueryTaskCompletedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RespondQueryTaskCompletedResponse)
	if !ok {
		that2, ok := that.(RespondQueryTaskCompletedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *CancelOutstandingPollRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CancelOutstandingPollRequest)
	if !ok {
		that2, ok := that.(CancelOutstandingPollRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.TaskQueueType != that1.TaskQueueType {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	if this.PollerId != that1.PollerId {
		return false
	}
	return true
}
func (this *CancelOutstandingPollResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CancelOutstandingPollResponse)
	if !ok {
		that2, ok := that.(CancelOutstandingPollResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeTaskQueueRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeTaskQueueRequest)
	if !ok {
		that2, ok := that.(DescribeTaskQueueRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if !this.DescRequest.Equal(that1.DescRequest) {
		return false
	}
	return true
}
func (this *DescribeTaskQueueResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeTaskQueueResponse)
	if !ok {
		that2, ok := that.(DescribeTaskQueueResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Pollers) != len(that1.Pollers) {
		return false
	}
	for i := range this.Pollers {
		if !this.Pollers[i].Equal(that1.Pollers[i]) {
			return false
		}
	}
	if !this.TaskQueueStatus.Equal(that1.TaskQueueStatus) {
		return false
	}
	return true
}
func (this *ListTaskQueuePartitionsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListTaskQueuePartitionsRequest)
	if !ok {
		that2, ok := that.(ListTaskQueuePartitionsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.TaskQueue.Equal(that1.TaskQueue) {
		return false
	}
	return true
}
func (this *ListTaskQueuePartitionsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListTaskQueuePartitionsResponse)
	if !ok {
		that2, ok := that.(ListTaskQueuePartitionsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ActivityTaskQueuePartitions) != len(that1.ActivityTaskQueuePartitions) {
		return false
	}
	for i := range this.ActivityTaskQueuePartitions {
		if !this.ActivityTaskQueuePartitions[i].Equal(that1.ActivityTaskQueuePartitions[i]) {
			return false
		}
	}
	if len(this.WorkflowTaskQueuePartitions) != len(that1.WorkflowTaskQueuePartitions) {
		return false
	}
	for i := range this.WorkflowTaskQueuePartitions {
		if !this.WorkflowTaskQueuePartitions[i].Equal(that1.WorkflowTaskQueuePartitions[i]) {
			return false
		}
	}
	return true
}
func (this *PollWorkflowTaskQueueRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&matchingservice.PollWorkflowTaskQueueRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "PollerId: "+fmt.Sprintf("%#v", this.PollerId)+",\n")
	if this.PollRequest != nil {
		s = append(s, "PollRequest: "+fmt.Sprintf("%#v", this.PollRequest)+",\n")
	}
	s = append(s, "ForwardedSource: "+fmt.Sprintf("%#v", this.ForwardedSource)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PollWorkflowTaskQueueResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 21)
	s = append(s, "&matchingservice.PollWorkflowTaskQueueResponse{")
	s = append(s, "TaskToken: "+fmt.Sprintf("%#v", this.TaskToken)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	if this.WorkflowType != nil {
		s = append(s, "WorkflowType: "+fmt.Sprintf("%#v", this.WorkflowType)+",\n")
	}
	s = append(s, "PreviousStartedEventId: "+fmt.Sprintf("%#v", this.PreviousStartedEventId)+",\n")
	s = append(s, "StartedEventId: "+fmt.Sprintf("%#v", this.StartedEventId)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "NextEventId: "+fmt.Sprintf("%#v", this.NextEventId)+",\n")
	s = append(s, "BacklogCountHint: "+fmt.Sprintf("%#v", this.BacklogCountHint)+",\n")
	s = append(s, "StickyExecutionEnabled: "+fmt.Sprintf("%#v", this.StickyExecutionEnabled)+",\n")
	if this.Query != nil {
		s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	}
	if this.WorkflowTaskInfo != nil {
		s = append(s, "WorkflowTaskInfo: "+fmt.Sprintf("%#v", this.WorkflowTaskInfo)+",\n")
	}
	if this.WorkflowExecutionTaskQueue != nil {
		s = append(s, "WorkflowExecutionTaskQueue: "+fmt.Sprintf("%#v", this.WorkflowExecutionTaskQueue)+",\n")
	}
	s = append(s, "EventStoreVersion: "+fmt.Sprintf("%#v", this.EventStoreVersion)+",\n")
	s = append(s, "BranchToken: "+fmt.Sprintf("%#v", this.BranchToken)+",\n")
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	keysForQueries := make([]string, 0, len(this.Queries))
	for k, _ := range this.Queries {
		keysForQueries = append(keysForQueries, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForQueries)
	mapStringForQueries := "map[string]*v12.WorkflowQuery{"
	for _, k := range keysForQueries {
		mapStringForQueries += fmt.Sprintf("%#v: %#v,", k, this.Queries[k])
	}
	mapStringForQueries += "}"
	if this.Queries != nil {
		s = append(s, "Queries: "+mapStringForQueries+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PollActivityTaskQueueRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&matchingservice.PollActivityTaskQueueRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "PollerId: "+fmt.Sprintf("%#v", this.PollerId)+",\n")
	if this.PollRequest != nil {
		s = append(s, "PollRequest: "+fmt.Sprintf("%#v", this.PollRequest)+",\n")
	}
	s = append(s, "ForwardedSource: "+fmt.Sprintf("%#v", this.ForwardedSource)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PollActivityTaskQueueResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 20)
	s = append(s, "&matchingservice.PollActivityTaskQueueResponse{")
	s = append(s, "TaskToken: "+fmt.Sprintf("%#v", this.TaskToken)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "ActivityId: "+fmt.Sprintf("%#v", this.ActivityId)+",\n")
	if this.ActivityType != nil {
		s = append(s, "ActivityType: "+fmt.Sprintf("%#v", this.ActivityType)+",\n")
	}
	if this.Input != nil {
		s = append(s, "Input: "+fmt.Sprintf("%#v", this.Input)+",\n")
	}
	s = append(s, "ScheduledTime: "+fmt.Sprintf("%#v", this.ScheduledTime)+",\n")
	s = append(s, "ScheduleToCloseTimeout: "+fmt.Sprintf("%#v", this.ScheduleToCloseTimeout)+",\n")
	s = append(s, "StartedTime: "+fmt.Sprintf("%#v", this.StartedTime)+",\n")
	s = append(s, "StartToCloseTimeout: "+fmt.Sprintf("%#v", this.StartToCloseTimeout)+",\n")
	s = append(s, "HeartbeatTimeout: "+fmt.Sprintf("%#v", this.HeartbeatTimeout)+",\n")
	s = append(s, "Attempt: "+fmt.Sprintf("%#v", this.Attempt)+",\n")
	s = append(s, "CurrentAttemptScheduledTime: "+fmt.Sprintf("%#v", this.CurrentAttemptScheduledTime)+",\n")
	if this.HeartbeatDetails != nil {
		s = append(s, "HeartbeatDetails: "+fmt.Sprintf("%#v", this.HeartbeatDetails)+",\n")
	}
	if this.WorkflowType != nil {
		s = append(s, "WorkflowType: "+fmt.Sprintf("%#v", this.WorkflowType)+",\n")
	}
	s = append(s, "WorkflowNamespace: "+fmt.Sprintf("%#v", this.WorkflowNamespace)+",\n")
	if this.Header != nil {
		s = append(s, "Header: "+fmt.Sprintf("%#v", this.Header)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddWorkflowTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&matchingservice.AddWorkflowTaskRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "ScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.ScheduleToStartTimeout)+",\n")
	s = append(s, "ForwardedSource: "+fmt.Sprintf("%#v", this.ForwardedSource)+",\n")
	s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddWorkflowTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&matchingservice.AddWorkflowTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddActivityTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&matchingservice.AddActivityTaskRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "SourceNamespaceId: "+fmt.Sprintf("%#v", this.SourceNamespaceId)+",\n")
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	s = append(s, "ScheduleId: "+fmt.Sprintf("%#v", this.ScheduleId)+",\n")
	s = append(s, "ScheduleToStartTimeout: "+fmt.Sprintf("%#v", this.ScheduleToStartTimeout)+",\n")
	s = append(s, "ForwardedSource: "+fmt.Sprintf("%#v", this.ForwardedSource)+",\n")
	s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddActivityTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&matchingservice.AddActivityTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryWorkflowRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&matchingservice.QueryWorkflowRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	if this.QueryRequest != nil {
		s = append(s, "QueryRequest: "+fmt.Sprintf("%#v", this.QueryRequest)+",\n")
	}
	s = append(s, "ForwardedSource: "+fmt.Sprintf("%#v", this.ForwardedSource)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryWorkflowResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&matchingservice.QueryWorkflowResponse{")
	if this.QueryResult != nil {
		s = append(s, "QueryResult: "+fmt.Sprintf("%#v", this.QueryResult)+",\n")
	}
	if this.QueryRejected != nil {
		s = append(s, "QueryRejected: "+fmt.Sprintf("%#v", this.QueryRejected)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondQueryTaskCompletedRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&matchingservice.RespondQueryTaskCompletedRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	if this.CompletedRequest != nil {
		s = append(s, "CompletedRequest: "+fmt.Sprintf("%#v", this.CompletedRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RespondQueryTaskCompletedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&matchingservice.RespondQueryTaskCompletedResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CancelOutstandingPollRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&matchingservice.CancelOutstandingPollRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "TaskQueueType: "+fmt.Sprintf("%#v", this.TaskQueueType)+",\n")
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	s = append(s, "PollerId: "+fmt.Sprintf("%#v", this.PollerId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CancelOutstandingPollResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&matchingservice.CancelOutstandingPollResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeTaskQueueRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&matchingservice.DescribeTaskQueueRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	if this.DescRequest != nil {
		s = append(s, "DescRequest: "+fmt.Sprintf("%#v", this.DescRequest)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeTaskQueueResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&matchingservice.DescribeTaskQueueResponse{")
	if this.Pollers != nil {
		s = append(s, "Pollers: "+fmt.Sprintf("%#v", this.Pollers)+",\n")
	}
	if this.TaskQueueStatus != nil {
		s = append(s, "TaskQueueStatus: "+fmt.Sprintf("%#v", this.TaskQueueStatus)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTaskQueuePartitionsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&matchingservice.ListTaskQueuePartitionsRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.TaskQueue != nil {
		s = append(s, "TaskQueue: "+fmt.Sprintf("%#v", this.TaskQueue)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTaskQueuePartitionsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&matchingservice.ListTaskQueuePartitionsResponse{")
	if this.ActivityTaskQueuePartitions != nil {
		s = append(s, "ActivityTaskQueuePartitions: "+fmt.Sprintf("%#v", this.ActivityTaskQueuePartitions)+",\n")
	}
	if this.WorkflowTaskQueuePartitions != nil {
		s = append(s, "WorkflowTaskQueuePartitions: "+fmt.Sprintf("%#v", this.WorkflowTaskQueuePartitions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringRequestResponse(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PollWorkflowTaskQueueRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PollWorkflowTaskQueueRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PollWorkflowTaskQueueRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ForwardedSource) > 0 {
		i -= len(m.ForwardedSource)
		copy(dAtA[i:], m.ForwardedSource)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ForwardedSource)))
		i--
		dAtA[i] = 0x22
	}
	if m.PollRequest != nil {
		{
			size, err := m.PollRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PollerId) > 0 {
		i -= len(m.PollerId)
		copy(dAtA[i:], m.PollerId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.PollerId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PollWorkflowTaskQueueResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PollWorkflowTaskQueueResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PollWorkflowTaskQueueResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Queries) > 0 {
		for k := range m.Queries {
			v := m.Queries[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintRequestResponse(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x8a
		}
	}
	if m.StartedTime != nil {
		n3, err3 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err3 != nil {
			return 0, err3
		}
		i -= n3
		i = encodeVarintRequestResponse(dAtA, i, uint64(n3))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.ScheduledTime != nil {
		n4, err4 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err4 != nil {
			return 0, err4
		}
		i -= n4
		i = encodeVarintRequestResponse(dAtA, i, uint64(n4))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.BranchToken) > 0 {
		i -= len(m.BranchToken)
		copy(dAtA[i:], m.BranchToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.BranchToken)))
		i--
		dAtA[i] = 0x72
	}
	if m.EventStoreVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EventStoreVersion))
		i--
		dAtA[i] = 0x68
	}
	if m.WorkflowExecutionTaskQueue != nil {
		{
			size, err := m.WorkflowExecutionTaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.WorkflowTaskInfo != nil {
		{
			size, err := m.WorkflowTaskInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Query != nil {
		{
			size, err := m.Query.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.StickyExecutionEnabled {
		i--
		if m.StickyExecutionEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.BacklogCountHint != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.BacklogCountHint))
		i--
		dAtA[i] = 0x40
	}
	if m.NextEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.NextEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.Attempt != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x30
	}
	if m.StartedEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartedEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.PreviousStartedEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.PreviousStartedEventId))
		i--
		dAtA[i] = 0x20
	}
	if m.WorkflowType != nil {
		{
			size, err := m.WorkflowType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.TaskToken) > 0 {
		i -= len(m.TaskToken)
		copy(dAtA[i:], m.TaskToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.TaskToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PollActivityTaskQueueRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PollActivityTaskQueueRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PollActivityTaskQueueRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ForwardedSource) > 0 {
		i -= len(m.ForwardedSource)
		copy(dAtA[i:], m.ForwardedSource)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ForwardedSource)))
		i--
		dAtA[i] = 0x22
	}
	if m.PollRequest != nil {
		{
			size, err := m.PollRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PollerId) > 0 {
		i -= len(m.PollerId)
		copy(dAtA[i:], m.PollerId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.PollerId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PollActivityTaskQueueResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PollActivityTaskQueueResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PollActivityTaskQueueResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.WorkflowNamespace) > 0 {
		i -= len(m.WorkflowNamespace)
		copy(dAtA[i:], m.WorkflowNamespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.WorkflowNamespace)))
		i--
		dAtA[i] = 0x7a
	}
	if m.WorkflowType != nil {
		{
			size, err := m.WorkflowType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if m.HeartbeatDetails != nil {
		{
			size, err := m.HeartbeatDetails.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.CurrentAttemptScheduledTime != nil {
		n14, err14 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.CurrentAttemptScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.CurrentAttemptScheduledTime):])
		if err14 != nil {
			return 0, err14
		}
		i -= n14
		i = encodeVarintRequestResponse(dAtA, i, uint64(n14))
		i--
		dAtA[i] = 0x62
	}
	if m.Attempt != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Attempt))
		i--
		dAtA[i] = 0x58
	}
	if m.HeartbeatTimeout != nil {
		n15, err15 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.HeartbeatTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.HeartbeatTimeout):])
		if err15 != nil {
			return 0, err15
		}
		i -= n15
		i = encodeVarintRequestResponse(dAtA, i, uint64(n15))
		i--
		dAtA[i] = 0x52
	}
	if m.StartToCloseTimeout != nil {
		n16, err16 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StartToCloseTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StartToCloseTimeout):])
		if err16 != nil {
			return 0, err16
		}
		i -= n16
		i = encodeVarintRequestResponse(dAtA, i, uint64(n16))
		i--
		dAtA[i] = 0x4a
	}
	if m.StartedTime != nil {
		n17, err17 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartedTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime):])
		if err17 != nil {
			return 0, err17
		}
		i -= n17
		i = encodeVarintRequestResponse(dAtA, i, uint64(n17))
		i--
		dAtA[i] = 0x42
	}
	if m.ScheduleToCloseTimeout != nil {
		n18, err18 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ScheduleToCloseTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToCloseTimeout):])
		if err18 != nil {
			return 0, err18
		}
		i -= n18
		i = encodeVarintRequestResponse(dAtA, i, uint64(n18))
		i--
		dAtA[i] = 0x3a
	}
	if m.ScheduledTime != nil {
		n19, err19 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.ScheduledTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime):])
		if err19 != nil {
			return 0, err19
		}
		i -= n19
		i = encodeVarintRequestResponse(dAtA, i, uint64(n19))
		i--
		dAtA[i] = 0x32
	}
	if m.Input != nil {
		{
			size, err := m.Input.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.ActivityType != nil {
		{
			size, err := m.ActivityType.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.ActivityId) > 0 {
		i -= len(m.ActivityId)
		copy(dAtA[i:], m.ActivityId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ActivityId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.TaskToken) > 0 {
		i -= len(m.TaskToken)
		copy(dAtA[i:], m.TaskToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.TaskToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddWorkflowTaskRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddWorkflowTaskRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddWorkflowTaskRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Source != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Source))
		i--
		dAtA[i] = 0x38
	}
	if len(m.ForwardedSource) > 0 {
		i -= len(m.ForwardedSource)
		copy(dAtA[i:], m.ForwardedSource)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ForwardedSource)))
		i--
		dAtA[i] = 0x32
	}
	if m.ScheduleToStartTimeout != nil {
		n23, err23 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout):])
		if err23 != nil {
			return 0, err23
		}
		i -= n23
		i = encodeVarintRequestResponse(dAtA, i, uint64(n23))
		i--
		dAtA[i] = 0x2a
	}
	if m.ScheduleId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x20
	}
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddWorkflowTaskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddWorkflowTaskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddWorkflowTaskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *AddActivityTaskRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddActivityTaskRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddActivityTaskRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Source != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Source))
		i--
		dAtA[i] = 0x40
	}
	if len(m.ForwardedSource) > 0 {
		i -= len(m.ForwardedSource)
		copy(dAtA[i:], m.ForwardedSource)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ForwardedSource)))
		i--
		dAtA[i] = 0x3a
	}
	if m.ScheduleToStartTimeout != nil {
		n26, err26 := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.ScheduleToStartTimeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout):])
		if err26 != nil {
			return 0, err26
		}
		i -= n26
		i = encodeVarintRequestResponse(dAtA, i, uint64(n26))
		i--
		dAtA[i] = 0x32
	}
	if m.ScheduleId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ScheduleId))
		i--
		dAtA[i] = 0x28
	}
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.SourceNamespaceId) > 0 {
		i -= len(m.SourceNamespaceId)
		copy(dAtA[i:], m.SourceNamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceNamespaceId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddActivityTaskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddActivityTaskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddActivityTaskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *QueryWorkflowRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryWorkflowRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryWorkflowRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ForwardedSource) > 0 {
		i -= len(m.ForwardedSource)
		copy(dAtA[i:], m.ForwardedSource)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ForwardedSource)))
		i--
		dAtA[i] = 0x22
	}
	if m.QueryRequest != nil {
		{
			size, err := m.QueryRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryWorkflowResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryWorkflowResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryWorkflowResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.QueryRejected != nil {
		{
			size, err := m.QueryRejected.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.QueryResult != nil {
		{
			size, err := m.QueryResult.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondQueryTaskCompletedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondQueryTaskCompletedRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondQueryTaskCompletedRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CompletedRequest != nil {
		{
			size, err := m.CompletedRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.TaskId) > 0 {
		i -= len(m.TaskId)
		copy(dAtA[i:], m.TaskId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.TaskId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RespondQueryTaskCompletedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RespondQueryTaskCompletedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RespondQueryTaskCompletedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *CancelOutstandingPollRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CancelOutstandingPollRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CancelOutstandingPollRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PollerId) > 0 {
		i -= len(m.PollerId)
		copy(dAtA[i:], m.PollerId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.PollerId)))
		i--
		dAtA[i] = 0x22
	}
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.TaskQueueType != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskQueueType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CancelOutstandingPollResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CancelOutstandingPollResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CancelOutstandingPollResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DescribeTaskQueueRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeTaskQueueRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeTaskQueueRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DescRequest != nil {
		{
			size, err := m.DescRequest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeTaskQueueResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeTaskQueueResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeTaskQueueResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TaskQueueStatus != nil {
		{
			size, err := m.TaskQueueStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Pollers) > 0 {
		for iNdEx := len(m.Pollers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Pollers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListTaskQueuePartitionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListTaskQueuePartitionsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListTaskQueuePartitionsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TaskQueue != nil {
		{
			size, err := m.TaskQueue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListTaskQueuePartitionsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListTaskQueuePartitionsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListTaskQueuePartitionsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.WorkflowTaskQueuePartitions) > 0 {
		for iNdEx := len(m.WorkflowTaskQueuePartitions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.WorkflowTaskQueuePartitions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ActivityTaskQueuePartitions) > 0 {
		for iNdEx := len(m.ActivityTaskQueuePartitions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ActivityTaskQueuePartitions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintRequestResponse(dAtA []byte, offset int, v uint64) int {
	offset -= sovRequestResponse(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PollWorkflowTaskQueueRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.PollerId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.PollRequest != nil {
		l = m.PollRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ForwardedSource)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *PollWorkflowTaskQueueResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TaskToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowType != nil {
		l = m.WorkflowType.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.PreviousStartedEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.PreviousStartedEventId))
	}
	if m.StartedEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartedEventId))
	}
	if m.Attempt != 0 {
		n += 1 + sovRequestResponse(uint64(m.Attempt))
	}
	if m.NextEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.NextEventId))
	}
	if m.BacklogCountHint != 0 {
		n += 1 + sovRequestResponse(uint64(m.BacklogCountHint))
	}
	if m.StickyExecutionEnabled {
		n += 2
	}
	if m.Query != nil {
		l = m.Query.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowTaskInfo != nil {
		l = m.WorkflowTaskInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecutionTaskQueue != nil {
		l = m.WorkflowExecutionTaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.EventStoreVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.EventStoreVersion))
	}
	l = len(m.BranchToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 2 + l + sovRequestResponse(uint64(l))
	}
	if len(m.Queries) > 0 {
		for k, v := range m.Queries {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRequestResponse(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *PollActivityTaskQueueRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.PollerId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.PollRequest != nil {
		l = m.PollRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ForwardedSource)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *PollActivityTaskQueueResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TaskToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ActivityId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ActivityType != nil {
		l = m.ActivityType.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Input != nil {
		l = m.Input.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.ScheduledTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduleToCloseTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToCloseTimeout)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartedTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartedTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartToCloseTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StartToCloseTimeout)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.HeartbeatTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.HeartbeatTimeout)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Attempt != 0 {
		n += 1 + sovRequestResponse(uint64(m.Attempt))
	}
	if m.CurrentAttemptScheduledTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.CurrentAttemptScheduledTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.HeartbeatDetails != nil {
		l = m.HeartbeatDetails.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowType != nil {
		l = m.WorkflowType.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.WorkflowNamespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Header != nil {
		l = m.Header.Size()
		n += 2 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *AddWorkflowTaskRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ScheduleId))
	}
	if m.ScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ForwardedSource)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Source != 0 {
		n += 1 + sovRequestResponse(uint64(m.Source))
	}
	return n
}

func (m *AddWorkflowTaskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *AddActivityTaskRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.SourceNamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ScheduleId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ScheduleId))
	}
	if m.ScheduleToStartTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.ScheduleToStartTimeout)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ForwardedSource)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Source != 0 {
		n += 1 + sovRequestResponse(uint64(m.Source))
	}
	return n
}

func (m *AddActivityTaskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *QueryWorkflowRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.QueryRequest != nil {
		l = m.QueryRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ForwardedSource)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *QueryWorkflowResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryResult != nil {
		l = m.QueryResult.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.QueryRejected != nil {
		l = m.QueryRejected.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondQueryTaskCompletedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.TaskId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.CompletedRequest != nil {
		l = m.CompletedRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RespondQueryTaskCompletedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *CancelOutstandingPollRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskQueueType != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskQueueType))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.PollerId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *CancelOutstandingPollResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DescribeTaskQueueRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.DescRequest != nil {
		l = m.DescRequest.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeTaskQueueResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Pollers) > 0 {
		for _, e := range m.Pollers {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	if m.TaskQueueStatus != nil {
		l = m.TaskQueueStatus.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListTaskQueuePartitionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.TaskQueue != nil {
		l = m.TaskQueue.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ListTaskQueuePartitionsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ActivityTaskQueuePartitions) > 0 {
		for _, e := range m.ActivityTaskQueuePartitions {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	if len(m.WorkflowTaskQueuePartitions) > 0 {
		for _, e := range m.WorkflowTaskQueuePartitions {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func sovRequestResponse(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRequestResponse(x uint64) (n int) {
	return sovRequestResponse(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PollWorkflowTaskQueueRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PollWorkflowTaskQueueRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`PollerId:` + fmt.Sprintf("%v", this.PollerId) + `,`,
		`PollRequest:` + strings.Replace(fmt.Sprintf("%v", this.PollRequest), "PollWorkflowTaskQueueRequest", "v1.PollWorkflowTaskQueueRequest", 1) + `,`,
		`ForwardedSource:` + fmt.Sprintf("%v", this.ForwardedSource) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PollWorkflowTaskQueueResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForQueries := make([]string, 0, len(this.Queries))
	for k, _ := range this.Queries {
		keysForQueries = append(keysForQueries, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForQueries)
	mapStringForQueries := "map[string]*v12.WorkflowQuery{"
	for _, k := range keysForQueries {
		mapStringForQueries += fmt.Sprintf("%v: %v,", k, this.Queries[k])
	}
	mapStringForQueries += "}"
	s := strings.Join([]string{`&PollWorkflowTaskQueueResponse{`,
		`TaskToken:` + fmt.Sprintf("%v", this.TaskToken) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`WorkflowType:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowType), "WorkflowType", "v11.WorkflowType", 1) + `,`,
		`PreviousStartedEventId:` + fmt.Sprintf("%v", this.PreviousStartedEventId) + `,`,
		`StartedEventId:` + fmt.Sprintf("%v", this.StartedEventId) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`NextEventId:` + fmt.Sprintf("%v", this.NextEventId) + `,`,
		`BacklogCountHint:` + fmt.Sprintf("%v", this.BacklogCountHint) + `,`,
		`StickyExecutionEnabled:` + fmt.Sprintf("%v", this.StickyExecutionEnabled) + `,`,
		`Query:` + strings.Replace(fmt.Sprintf("%v", this.Query), "WorkflowQuery", "v12.WorkflowQuery", 1) + `,`,
		`WorkflowTaskInfo:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowTaskInfo), "TransientWorkflowTaskInfo", "v13.TransientWorkflowTaskInfo", 1) + `,`,
		`WorkflowExecutionTaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecutionTaskQueue), "TaskQueue", "v14.TaskQueue", 1) + `,`,
		`EventStoreVersion:` + fmt.Sprintf("%v", this.EventStoreVersion) + `,`,
		`BranchToken:` + fmt.Sprintf("%v", this.BranchToken) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`Queries:` + mapStringForQueries + `,`,
		`}`,
	}, "")
	return s
}
func (this *PollActivityTaskQueueRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PollActivityTaskQueueRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`PollerId:` + fmt.Sprintf("%v", this.PollerId) + `,`,
		`PollRequest:` + strings.Replace(fmt.Sprintf("%v", this.PollRequest), "PollActivityTaskQueueRequest", "v1.PollActivityTaskQueueRequest", 1) + `,`,
		`ForwardedSource:` + fmt.Sprintf("%v", this.ForwardedSource) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PollActivityTaskQueueResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PollActivityTaskQueueResponse{`,
		`TaskToken:` + fmt.Sprintf("%v", this.TaskToken) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`ActivityId:` + fmt.Sprintf("%v", this.ActivityId) + `,`,
		`ActivityType:` + strings.Replace(fmt.Sprintf("%v", this.ActivityType), "ActivityType", "v11.ActivityType", 1) + `,`,
		`Input:` + strings.Replace(fmt.Sprintf("%v", this.Input), "Payloads", "v11.Payloads", 1) + `,`,
		`ScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.ScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`ScheduleToCloseTimeout:` + strings.Replace(fmt.Sprintf("%v", this.ScheduleToCloseTimeout), "Duration", "types.Duration", 1) + `,`,
		`StartedTime:` + strings.Replace(fmt.Sprintf("%v", this.StartedTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`StartToCloseTimeout:` + strings.Replace(fmt.Sprintf("%v", this.StartToCloseTimeout), "Duration", "types.Duration", 1) + `,`,
		`HeartbeatTimeout:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatTimeout), "Duration", "types.Duration", 1) + `,`,
		`Attempt:` + fmt.Sprintf("%v", this.Attempt) + `,`,
		`CurrentAttemptScheduledTime:` + strings.Replace(fmt.Sprintf("%v", this.CurrentAttemptScheduledTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`HeartbeatDetails:` + strings.Replace(fmt.Sprintf("%v", this.HeartbeatDetails), "Payloads", "v11.Payloads", 1) + `,`,
		`WorkflowType:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowType), "WorkflowType", "v11.WorkflowType", 1) + `,`,
		`WorkflowNamespace:` + fmt.Sprintf("%v", this.WorkflowNamespace) + `,`,
		`Header:` + strings.Replace(fmt.Sprintf("%v", this.Header), "Header", "v11.Header", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddWorkflowTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddWorkflowTaskRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v14.TaskQueue", 1) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`ScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.ScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`ForwardedSource:` + fmt.Sprintf("%v", this.ForwardedSource) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddWorkflowTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddWorkflowTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *AddActivityTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddActivityTaskRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v11.WorkflowExecution", 1) + `,`,
		`SourceNamespaceId:` + fmt.Sprintf("%v", this.SourceNamespaceId) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v14.TaskQueue", 1) + `,`,
		`ScheduleId:` + fmt.Sprintf("%v", this.ScheduleId) + `,`,
		`ScheduleToStartTimeout:` + strings.Replace(fmt.Sprintf("%v", this.ScheduleToStartTimeout), "Duration", "types.Duration", 1) + `,`,
		`ForwardedSource:` + fmt.Sprintf("%v", this.ForwardedSource) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddActivityTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddActivityTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *QueryWorkflowRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryWorkflowRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v14.TaskQueue", 1) + `,`,
		`QueryRequest:` + strings.Replace(fmt.Sprintf("%v", this.QueryRequest), "QueryWorkflowRequest", "v1.QueryWorkflowRequest", 1) + `,`,
		`ForwardedSource:` + fmt.Sprintf("%v", this.ForwardedSource) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryWorkflowResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryWorkflowResponse{`,
		`QueryResult:` + strings.Replace(fmt.Sprintf("%v", this.QueryResult), "Payloads", "v11.Payloads", 1) + `,`,
		`QueryRejected:` + strings.Replace(fmt.Sprintf("%v", this.QueryRejected), "QueryRejected", "v12.QueryRejected", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondQueryTaskCompletedRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondQueryTaskCompletedRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v14.TaskQueue", 1) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`CompletedRequest:` + strings.Replace(fmt.Sprintf("%v", this.CompletedRequest), "RespondQueryTaskCompletedRequest", "v1.RespondQueryTaskCompletedRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RespondQueryTaskCompletedResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RespondQueryTaskCompletedResponse{`,
		`}`,
	}, "")
	return s
}
func (this *CancelOutstandingPollRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CancelOutstandingPollRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`TaskQueueType:` + fmt.Sprintf("%v", this.TaskQueueType) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v14.TaskQueue", 1) + `,`,
		`PollerId:` + fmt.Sprintf("%v", this.PollerId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CancelOutstandingPollResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CancelOutstandingPollResponse{`,
		`}`,
	}, "")
	return s
}
func (this *DescribeTaskQueueRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeTaskQueueRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`DescRequest:` + strings.Replace(fmt.Sprintf("%v", this.DescRequest), "DescribeTaskQueueRequest", "v1.DescribeTaskQueueRequest", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeTaskQueueResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForPollers := "[]*PollerInfo{"
	for _, f := range this.Pollers {
		repeatedStringForPollers += strings.Replace(fmt.Sprintf("%v", f), "PollerInfo", "v14.PollerInfo", 1) + ","
	}
	repeatedStringForPollers += "}"
	s := strings.Join([]string{`&DescribeTaskQueueResponse{`,
		`Pollers:` + repeatedStringForPollers + `,`,
		`TaskQueueStatus:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueueStatus), "TaskQueueStatus", "v14.TaskQueueStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListTaskQueuePartitionsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListTaskQueuePartitionsRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`TaskQueue:` + strings.Replace(fmt.Sprintf("%v", this.TaskQueue), "TaskQueue", "v14.TaskQueue", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListTaskQueuePartitionsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForActivityTaskQueuePartitions := "[]*TaskQueuePartitionMetadata{"
	for _, f := range this.ActivityTaskQueuePartitions {
		repeatedStringForActivityTaskQueuePartitions += strings.Replace(fmt.Sprintf("%v", f), "TaskQueuePartitionMetadata", "v14.TaskQueuePartitionMetadata", 1) + ","
	}
	repeatedStringForActivityTaskQueuePartitions += "}"
	repeatedStringForWorkflowTaskQueuePartitions := "[]*TaskQueuePartitionMetadata{"
	for _, f := range this.WorkflowTaskQueuePartitions {
		repeatedStringForWorkflowTaskQueuePartitions += strings.Replace(fmt.Sprintf("%v", f), "TaskQueuePartitionMetadata", "v14.TaskQueuePartitionMetadata", 1) + ","
	}
	repeatedStringForWorkflowTaskQueuePartitions += "}"
	s := strings.Join([]string{`&ListTaskQueuePartitionsResponse{`,
		`ActivityTaskQueuePartitions:` + repeatedStringForActivityTaskQueuePartitions + `,`,
		`WorkflowTaskQueuePartitions:` + repeatedStringForWorkflowTaskQueuePartitions + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringRequestResponse(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PollWorkflowTaskQueueRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PollWorkflowTaskQueueRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PollWorkflowTaskQueueRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PollerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PollerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PollRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PollRequest == nil {
				m.PollRequest = &v1.PollWorkflowTaskQueueRequest{}
			}
			if err := m.PollRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardedSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardedSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PollWorkflowTaskQueueResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PollWorkflowTaskQueueResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PollWorkflowTaskQueueResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskToken = append(m.TaskToken[:0], dAtA[iNdEx:postIndex]...)
			if m.TaskToken == nil {
				m.TaskToken = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v11.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowType == nil {
				m.WorkflowType = &v11.WorkflowType{}
			}
			if err := m.WorkflowType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousStartedEventId", wireType)
			}
			m.PreviousStartedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PreviousStartedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedEventId", wireType)
			}
			m.StartedEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextEventId", wireType)
			}
			m.NextEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BacklogCountHint", wireType)
			}
			m.BacklogCountHint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BacklogCountHint |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StickyExecutionEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StickyExecutionEnabled = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Query == nil {
				m.Query = &v12.WorkflowQuery{}
			}
			if err := m.Query.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowTaskInfo == nil {
				m.WorkflowTaskInfo = &v13.TransientWorkflowTaskInfo{}
			}
			if err := m.WorkflowTaskInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecutionTaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecutionTaskQueue == nil {
				m.WorkflowExecutionTaskQueue = &v14.TaskQueue{}
			}
			if err := m.WorkflowExecutionTaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventStoreVersion", wireType)
			}
			m.EventStoreVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventStoreVersion |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchToken = append(m.BranchToken[:0], dAtA[iNdEx:postIndex]...)
			if m.BranchToken == nil {
				m.BranchToken = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Queries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Queries == nil {
				m.Queries = make(map[string]*v12.WorkflowQuery)
			}
			var mapkey string
			var mapvalue *v12.WorkflowQuery
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v12.WorkflowQuery{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Queries[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PollActivityTaskQueueRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PollActivityTaskQueueRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PollActivityTaskQueueRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PollerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PollerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PollRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PollRequest == nil {
				m.PollRequest = &v1.PollActivityTaskQueueRequest{}
			}
			if err := m.PollRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardedSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardedSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PollActivityTaskQueueResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PollActivityTaskQueueResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PollActivityTaskQueueResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskToken = append(m.TaskToken[:0], dAtA[iNdEx:postIndex]...)
			if m.TaskToken == nil {
				m.TaskToken = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v11.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActivityType == nil {
				m.ActivityType = &v11.ActivityType{}
			}
			if err := m.ActivityType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Input", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Input == nil {
				m.Input = &v11.Payloads{}
			}
			if err := m.Input.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduledTime == nil {
				m.ScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.ScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleToCloseTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleToCloseTimeout == nil {
				m.ScheduleToCloseTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ScheduleToCloseTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedTime == nil {
				m.StartedTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartToCloseTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartToCloseTimeout == nil {
				m.StartToCloseTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StartToCloseTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatTimeout == nil {
				m.HeartbeatTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.HeartbeatTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempt", wireType)
			}
			m.Attempt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempt |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentAttemptScheduledTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CurrentAttemptScheduledTime == nil {
				m.CurrentAttemptScheduledTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.CurrentAttemptScheduledTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatDetails", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatDetails == nil {
				m.HeartbeatDetails = &v11.Payloads{}
			}
			if err := m.HeartbeatDetails.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowType == nil {
				m.WorkflowType = &v11.WorkflowType{}
			}
			if err := m.WorkflowType.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &v11.Header{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddWorkflowTaskRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddWorkflowTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddWorkflowTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v11.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v14.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleToStartTimeout == nil {
				m.ScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardedSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardedSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			m.Source = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Source |= v15.TaskSource(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddWorkflowTaskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddWorkflowTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddWorkflowTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddActivityTaskRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddActivityTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddActivityTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v11.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v14.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			m.ScheduleId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleToStartTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleToStartTimeout == nil {
				m.ScheduleToStartTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.ScheduleToStartTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardedSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardedSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			m.Source = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Source |= v15.TaskSource(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddActivityTaskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddActivityTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddActivityTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryWorkflowRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryWorkflowRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryWorkflowRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v14.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.QueryRequest == nil {
				m.QueryRequest = &v1.QueryWorkflowRequest{}
			}
			if err := m.QueryRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardedSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardedSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryWorkflowResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryWorkflowResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryWorkflowResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryResult", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.QueryResult == nil {
				m.QueryResult = &v11.Payloads{}
			}
			if err := m.QueryResult.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryRejected", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.QueryRejected == nil {
				m.QueryRejected = &v12.QueryRejected{}
			}
			if err := m.QueryRejected.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondQueryTaskCompletedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondQueryTaskCompletedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondQueryTaskCompletedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v14.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletedRequest == nil {
				m.CompletedRequest = &v1.RespondQueryTaskCompletedRequest{}
			}
			if err := m.CompletedRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RespondQueryTaskCompletedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RespondQueryTaskCompletedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RespondQueryTaskCompletedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CancelOutstandingPollRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CancelOutstandingPollRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CancelOutstandingPollRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueueType", wireType)
			}
			m.TaskQueueType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskQueueType |= v16.TaskQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v14.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PollerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PollerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CancelOutstandingPollResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CancelOutstandingPollResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CancelOutstandingPollResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeTaskQueueRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeTaskQueueRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeTaskQueueRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DescRequest == nil {
				m.DescRequest = &v1.DescribeTaskQueueRequest{}
			}
			if err := m.DescRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeTaskQueueResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeTaskQueueResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeTaskQueueResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pollers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pollers = append(m.Pollers, &v14.PollerInfo{})
			if err := m.Pollers[len(m.Pollers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueueStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueueStatus == nil {
				m.TaskQueueStatus = &v14.TaskQueueStatus{}
			}
			if err := m.TaskQueueStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTaskQueuePartitionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTaskQueuePartitionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTaskQueuePartitionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskQueue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskQueue == nil {
				m.TaskQueue = &v14.TaskQueue{}
			}
			if err := m.TaskQueue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTaskQueuePartitionsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTaskQueuePartitionsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTaskQueuePartitionsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActivityTaskQueuePartitions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActivityTaskQueuePartitions = append(m.ActivityTaskQueuePartitions, &v14.TaskQueuePartitionMetadata{})
			if err := m.ActivityTaskQueuePartitions[len(m.ActivityTaskQueuePartitions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowTaskQueuePartitions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowTaskQueuePartitions = append(m.WorkflowTaskQueuePartitions, &v14.TaskQueuePartitionMetadata{})
			if err := m.WorkflowTaskQueuePartitions[len(m.WorkflowTaskQueuePartitions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRequestResponse(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRequestResponse
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRequestResponse
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRequestResponse
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRequestResponse        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRequestResponse          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRequestResponse = fmt.Errorf("proto: unexpected end of group")
)
