// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/enums/v1/task.proto

package enums

import (
	fmt "fmt"
	math "math"
	strconv "strconv"

	proto "github.com/gogo/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// TaskSource is the source from which a task was produced.
type TaskSource int32

const (
	TASK_SOURCE_UNSPECIFIED TaskSource = 0
	// Task produced by history service.
	TASK_SOURCE_HISTORY TaskSource = 1
	// Task produced from matching db backlog.
	TASK_SOURCE_DB_BACKLOG TaskSource = 2
)

var TaskSource_name = map[int32]string{
	0: "Unspecified",
	1: "History",
	2: "DbBacklog",
}

var TaskSource_value = map[string]int32{
	"Unspecified": 0,
	"History":     1,
	"DbBacklog":   2,
}

func (TaskSource) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_36a3d3674ca3cfa6, []int{0}
}

type TaskCategory int32

const (
	TASK_CATEGORY_UNSPECIFIED TaskCategory = 0
	// Transfer is the task type for transfer task.
	TASK_CATEGORY_TRANSFER TaskCategory = 1
	// Timer is the task type for timer task.
	TASK_CATEGORY_TIMER TaskCategory = 2
	// Replication is the task type for replication task.
	TASK_CATEGORY_REPLICATION TaskCategory = 3
)

var TaskCategory_name = map[int32]string{
	0: "Unspecified",
	1: "Transfer",
	2: "Timer",
	3: "Replication",
}

var TaskCategory_value = map[string]int32{
	"Unspecified": 0,
	"Transfer":    1,
	"Timer":       2,
	"Replication": 3,
}

func (TaskCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_36a3d3674ca3cfa6, []int{1}
}

type TaskType int32

const (
	TASK_TYPE_UNSPECIFIED                                TaskType = 0
	TASK_TYPE_REPLICATION_HISTORY                        TaskType = 1
	TASK_TYPE_REPLICATION_SYNC_ACTIVITY                  TaskType = 2
	TASK_TYPE_TRANSFER_WORKFLOW_TASK                     TaskType = 3
	TASK_TYPE_TRANSFER_ACTIVITY_TASK                     TaskType = 4
	TASK_TYPE_TRANSFER_CLOSE_EXECUTION                   TaskType = 5
	TASK_TYPE_TRANSFER_CANCEL_EXECUTION                  TaskType = 6
	TASK_TYPE_TRANSFER_START_CHILD_EXECUTION             TaskType = 7
	TASK_TYPE_TRANSFER_SIGNAL_EXECUTION                  TaskType = 8
	TASK_TYPE_TRANSFER_RECORD_WORKFLOW_STARTED           TaskType = 9
	TASK_TYPE_TRANSFER_RESET_WORKFLOW                    TaskType = 10
	TASK_TYPE_TRANSFER_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES TaskType = 11
	TASK_TYPE_WORKFLOW_TASK_TIMEOUT                      TaskType = 12
	TASK_TYPE_ACTIVITY_TIMEOUT                           TaskType = 13
	TASK_TYPE_USER_TIMER                                 TaskType = 14
	TASK_TYPE_WORKFLOW_RUN_TIMEOUT                       TaskType = 15
	TASK_TYPE_DELETE_HISTORY_EVENT                       TaskType = 16
	TASK_TYPE_ACTIVITY_RETRY_TIMER                       TaskType = 17
	TASK_TYPE_WORKFLOW_BACKOFF_TIMER                     TaskType = 18
)

var TaskType_name = map[int32]string{
	0:  "Unspecified",
	1:  "ReplicationHistory",
	2:  "ReplicationSyncActivity",
	3:  "TransferWorkflowTask",
	4:  "TransferActivityTask",
	5:  "TransferCloseExecution",
	6:  "TransferCancelExecution",
	7:  "TransferStartChildExecution",
	8:  "TransferSignalExecution",
	9:  "TransferRecordWorkflowStarted",
	10: "TransferResetWorkflow",
	11: "TransferUpsertWorkflowSearchAttributes",
	12: "WorkflowTaskTimeout",
	13: "ActivityTimeout",
	14: "UserTimer",
	15: "WorkflowRunTimeout",
	16: "DeleteHistoryEvent",
	17: "ActivityRetryTimer",
	18: "WorkflowBackoffTimer",
}

var TaskType_value = map[string]int32{
	"Unspecified":                            0,
	"ReplicationHistory":                     1,
	"ReplicationSyncActivity":                2,
	"TransferWorkflowTask":                   3,
	"TransferActivityTask":                   4,
	"TransferCloseExecution":                 5,
	"TransferCancelExecution":                6,
	"TransferStartChildExecution":            7,
	"TransferSignalExecution":                8,
	"TransferRecordWorkflowStarted":          9,
	"TransferResetWorkflow":                  10,
	"TransferUpsertWorkflowSearchAttributes": 11,
	"WorkflowTaskTimeout":                    12,
	"ActivityTimeout":                        13,
	"UserTimer":                              14,
	"WorkflowRunTimeout":                     15,
	"DeleteHistoryEvent":                     16,
	"ActivityRetryTimer":                     17,
	"WorkflowBackoffTimer":                   18,
}

func (TaskType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_36a3d3674ca3cfa6, []int{2}
}

func init() {
	proto.RegisterEnum("temporal.server.api.enums.v1.TaskSource", TaskSource_name, TaskSource_value)
	proto.RegisterEnum("temporal.server.api.enums.v1.TaskCategory", TaskCategory_name, TaskCategory_value)
	proto.RegisterEnum("temporal.server.api.enums.v1.TaskType", TaskType_name, TaskType_value)
}

func init() {
	proto.RegisterFile("temporal/server/api/enums/v1/task.proto", fileDescriptor_36a3d3674ca3cfa6)
}

var fileDescriptor_36a3d3674ca3cfa6 = []byte{
	// 574 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x94, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xed, 0x96, 0x96, 0xb2, 0x14, 0x58, 0x96, 0x3f, 0xa5, 0x85, 0x2e, 0xb4, 0x05, 0x5a,
	0x45, 0xc8, 0x51, 0x05, 0x07, 0x24, 0x4e, 0xce, 0x7a, 0x92, 0x58, 0x31, 0x76, 0xb4, 0xbb, 0x6e,
	0x09, 0x87, 0x5a, 0x06, 0x59, 0x55, 0x54, 0x8a, 0x23, 0x27, 0x8d, 0xd4, 0x1b, 0xbc, 0x01, 0x8f,
	0xc1, 0xa3, 0x70, 0xcc, 0xb1, 0x47, 0xe2, 0x1c, 0xe0, 0xd8, 0x47, 0x40, 0x71, 0x13, 0xdb, 0x29,
	0xee, 0x6d, 0xa5, 0xef, 0xb7, 0xdf, 0xcc, 0xac, 0xbe, 0x1d, 0xb4, 0xdd, 0x0b, 0x8e, 0x3b, 0x61,
	0xe4, 0x7f, 0x29, 0x77, 0x83, 0xa8, 0x1f, 0x44, 0x65, 0xbf, 0xd3, 0x2e, 0x07, 0x5f, 0x4f, 0x8e,
	0xbb, 0xe5, 0xfe, 0x6e, 0xb9, 0xe7, 0x77, 0x8f, 0xb4, 0x4e, 0x14, 0xf6, 0x42, 0xf2, 0x64, 0x0a,
	0x6a, 0x17, 0xa0, 0xe6, 0x77, 0xda, 0x5a, 0x02, 0x6a, 0xfd, 0xdd, 0xd2, 0x01, 0x42, 0xd2, 0xef,
	0x1e, 0x89, 0xf0, 0x24, 0xfa, 0x1c, 0x90, 0xc7, 0x68, 0x45, 0xea, 0xa2, 0xe1, 0x09, 0xc7, 0xe5,
	0x0c, 0x3c, 0xd7, 0x16, 0x4d, 0x60, 0x66, 0xd5, 0x04, 0x03, 0x2b, 0x64, 0x05, 0xdd, 0xcb, 0x8b,
	0x75, 0x53, 0x48, 0x87, 0xb7, 0xb0, 0x4a, 0xd6, 0xd0, 0xc3, 0xbc, 0x60, 0x54, 0xbc, 0x8a, 0xce,
	0x1a, 0x96, 0x53, 0xc3, 0x73, 0xa5, 0xef, 0x2a, 0x5a, 0x1e, 0x17, 0x60, 0x7e, 0x2f, 0x38, 0x0c,
	0xa3, 0x53, 0xb2, 0x8e, 0x56, 0x13, 0x98, 0xe9, 0x12, 0x6a, 0x0e, 0x6f, 0x5d, 0x2a, 0x32, 0xf5,
	0x4a, 0x65, 0xc9, 0x75, 0x5b, 0x54, 0x81, 0x63, 0x35, 0x6d, 0x20, 0xd3, 0xcc, 0xf7, 0xc0, 0xf1,
	0xdc, 0xff, 0x9e, 0x1c, 0x9a, 0x96, 0xc9, 0x74, 0x69, 0x3a, 0x36, 0x9e, 0x2f, 0xfd, 0x59, 0x40,
	0x4b, 0xe3, 0x1e, 0xe4, 0x69, 0x27, 0x20, 0xab, 0xe8, 0x41, 0xc2, 0xca, 0x56, 0xf3, 0xf2, 0x80,
	0x1b, 0x68, 0x3d, 0x93, 0x72, 0x16, 0xb9, 0x51, 0xb7, 0xd1, 0x56, 0x31, 0x22, 0x5a, 0x36, 0xf3,
	0x74, 0x26, 0xcd, 0x3d, 0x53, 0xb6, 0xf0, 0x1c, 0x79, 0x8e, 0x9e, 0x65, 0xe0, 0x74, 0x06, 0x6f,
	0xdf, 0xe1, 0x8d, 0xaa, 0xe5, 0xec, 0x7b, 0x63, 0x0d, 0xcf, 0x5f, 0x41, 0x4d, 0x6d, 0x2e, 0xa8,
	0x6b, 0xe4, 0x25, 0xda, 0x2c, 0xa0, 0x98, 0xe5, 0x08, 0xf0, 0xe0, 0x03, 0x30, 0x37, 0x99, 0x73,
	0x61, 0xb6, 0xb9, 0x8c, 0xd3, 0x6d, 0x06, 0x56, 0x0e, 0x5c, 0x24, 0xaf, 0xd0, 0x4e, 0x01, 0x28,
	0xa4, 0xce, 0xa5, 0xc7, 0xea, 0xa6, 0x65, 0xe4, 0xe8, 0xeb, 0x57, 0xd8, 0x0a, 0xb3, 0x66, 0xeb,
	0x79, 0xdb, 0x25, 0xa2, 0xa1, 0x52, 0x01, 0xc8, 0x81, 0x39, 0xdc, 0xc8, 0x46, 0x4f, 0xca, 0x80,
	0x81, 0x6f, 0x90, 0x17, 0x68, 0xa3, 0x90, 0x17, 0x20, 0x53, 0x1c, 0x23, 0xf2, 0x16, 0xbd, 0x29,
	0xc0, 0xdc, 0xa6, 0x00, 0x2e, 0x73, 0xb6, 0xa0, 0x73, 0x56, 0xf7, 0x74, 0x29, 0xb9, 0x59, 0x71,
	0x25, 0x08, 0x7c, 0x93, 0x6c, 0xa1, 0xa7, 0xd9, 0xcd, 0x99, 0xb7, 0x4f, 0xa2, 0xe3, 0xb8, 0x12,
	0x2f, 0x13, 0x8a, 0xd6, 0x32, 0x28, 0x7b, 0xfa, 0x89, 0x7e, 0x8b, 0x3c, 0x42, 0xf7, 0x73, 0x81,
	0x11, 0xc0, 0x27, 0xb1, 0xbb, 0x4d, 0x36, 0x11, 0x2d, 0xb0, 0xe7, 0xae, 0x9d, 0xde, 0xbe, 0x33,
	0xcb, 0x18, 0x60, 0x81, 0x4c, 0x7f, 0x8e, 0x07, 0x7b, 0x60, 0x4b, 0x8c, 0x67, 0x99, 0xb4, 0x03,
	0x0e, 0x32, 0x8d, 0xf8, 0xdd, 0xd9, 0xa4, 0xa4, 0xb5, 0xc6, 0xff, 0xcc, 0xa9, 0x56, 0x27, 0x14,
	0xa9, 0x1c, 0x0c, 0x86, 0x54, 0x39, 0x1b, 0x52, 0xe5, 0x7c, 0x48, 0xd5, 0x6f, 0x31, 0x55, 0x7f,
	0xc6, 0x54, 0xfd, 0x15, 0x53, 0x75, 0x10, 0x53, 0xf5, 0x77, 0x4c, 0xd5, 0xbf, 0x31, 0x55, 0xce,
	0x63, 0xaa, 0xfe, 0x18, 0x51, 0x65, 0x30, 0xa2, 0xca, 0xd9, 0x88, 0x2a, 0x1f, 0x77, 0x0e, 0x43,
	0x2d, 0x5d, 0x12, 0xed, 0xb0, 0x68, 0xa1, 0xbc, 0x4b, 0x0e, 0x9f, 0x16, 0x93, 0x95, 0xf2, 0xfa,
	0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf5, 0x18, 0x0d, 0x76, 0x7d, 0x04, 0x00, 0x00,
}

func (x TaskSource) String() string {
	s, ok := TaskSource_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x TaskCategory) String() string {
	s, ok := TaskCategory_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x TaskType) String() string {
	s, ok := TaskType_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
