// The MIT License
//
// Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.
//
// Copyright (c) 2020 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: temporal/server/api/adminservice/v1/request_response.proto

package adminservice

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	v1 "go.temporal.io/api/common/v1"
	v15 "go.temporal.io/api/enums/v1"
	v16 "go.temporal.io/server/api/cluster/v1"
	v12 "go.temporal.io/server/api/enums/v1"
	v13 "go.temporal.io/server/api/history/v1"
	v11 "go.temporal.io/server/api/namespace/v1"
	v14 "go.temporal.io/server/api/replication/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type DescribeWorkflowExecutionRequest struct {
	Namespace string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *DescribeWorkflowExecutionRequest) Reset()      { *m = DescribeWorkflowExecutionRequest{} }
func (*DescribeWorkflowExecutionRequest) ProtoMessage() {}
func (*DescribeWorkflowExecutionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{0}
}
func (m *DescribeWorkflowExecutionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeWorkflowExecutionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeWorkflowExecutionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeWorkflowExecutionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeWorkflowExecutionRequest.Merge(m, src)
}
func (m *DescribeWorkflowExecutionRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeWorkflowExecutionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeWorkflowExecutionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeWorkflowExecutionRequest proto.InternalMessageInfo

func (m *DescribeWorkflowExecutionRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DescribeWorkflowExecutionRequest) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type DescribeWorkflowExecutionResponse struct {
	ShardId              string `protobuf:"bytes,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	HistoryAddr          string `protobuf:"bytes,2,opt,name=history_addr,json=historyAddr,proto3" json:"history_addr,omitempty"`
	CacheMutableState    string `protobuf:"bytes,3,opt,name=cache_mutable_state,json=cacheMutableState,proto3" json:"cache_mutable_state,omitempty"`
	DatabaseMutableState string `protobuf:"bytes,4,opt,name=database_mutable_state,json=databaseMutableState,proto3" json:"database_mutable_state,omitempty"`
	TreeId               string `protobuf:"bytes,5,opt,name=tree_id,json=treeId,proto3" json:"tree_id,omitempty"`
	BranchId             string `protobuf:"bytes,6,opt,name=branch_id,json=branchId,proto3" json:"branch_id,omitempty"`
}

func (m *DescribeWorkflowExecutionResponse) Reset()      { *m = DescribeWorkflowExecutionResponse{} }
func (*DescribeWorkflowExecutionResponse) ProtoMessage() {}
func (*DescribeWorkflowExecutionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{1}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeWorkflowExecutionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeWorkflowExecutionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.Merge(m, src)
}
func (m *DescribeWorkflowExecutionResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeWorkflowExecutionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeWorkflowExecutionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeWorkflowExecutionResponse proto.InternalMessageInfo

func (m *DescribeWorkflowExecutionResponse) GetShardId() string {
	if m != nil {
		return m.ShardId
	}
	return ""
}

func (m *DescribeWorkflowExecutionResponse) GetHistoryAddr() string {
	if m != nil {
		return m.HistoryAddr
	}
	return ""
}

func (m *DescribeWorkflowExecutionResponse) GetCacheMutableState() string {
	if m != nil {
		return m.CacheMutableState
	}
	return ""
}

func (m *DescribeWorkflowExecutionResponse) GetDatabaseMutableState() string {
	if m != nil {
		return m.DatabaseMutableState
	}
	return ""
}

func (m *DescribeWorkflowExecutionResponse) GetTreeId() string {
	if m != nil {
		return m.TreeId
	}
	return ""
}

func (m *DescribeWorkflowExecutionResponse) GetBranchId() string {
	if m != nil {
		return m.BranchId
	}
	return ""
}

//At least one of the parameters needs to be provided
type DescribeHistoryHostRequest struct {
	//ip:port
	HostAddress       string                `protobuf:"bytes,1,opt,name=host_address,json=hostAddress,proto3" json:"host_address,omitempty"`
	ShardId           int32                 `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Namespace         string                `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowExecution *v1.WorkflowExecution `protobuf:"bytes,4,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
}

func (m *DescribeHistoryHostRequest) Reset()      { *m = DescribeHistoryHostRequest{} }
func (*DescribeHistoryHostRequest) ProtoMessage() {}
func (*DescribeHistoryHostRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{2}
}
func (m *DescribeHistoryHostRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostRequest.Merge(m, src)
}
func (m *DescribeHistoryHostRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostRequest proto.InternalMessageInfo

func (m *DescribeHistoryHostRequest) GetHostAddress() string {
	if m != nil {
		return m.HostAddress
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *DescribeHistoryHostRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DescribeHistoryHostRequest) GetWorkflowExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

type DescribeHistoryHostResponse struct {
	ShardsNumber          int32                   `protobuf:"varint,1,opt,name=shards_number,json=shardsNumber,proto3" json:"shards_number,omitempty"`
	ShardIds              []int32                 `protobuf:"varint,2,rep,packed,name=shard_ids,json=shardIds,proto3" json:"shard_ids,omitempty"`
	NamespaceCache        *v11.NamespaceCacheInfo `protobuf:"bytes,3,opt,name=namespace_cache,json=namespaceCache,proto3" json:"namespace_cache,omitempty"`
	ShardControllerStatus string                  `protobuf:"bytes,4,opt,name=shard_controller_status,json=shardControllerStatus,proto3" json:"shard_controller_status,omitempty"`
	Address               string                  `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
}

func (m *DescribeHistoryHostResponse) Reset()      { *m = DescribeHistoryHostResponse{} }
func (*DescribeHistoryHostResponse) ProtoMessage() {}
func (*DescribeHistoryHostResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{3}
}
func (m *DescribeHistoryHostResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeHistoryHostResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeHistoryHostResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeHistoryHostResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeHistoryHostResponse.Merge(m, src)
}
func (m *DescribeHistoryHostResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeHistoryHostResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeHistoryHostResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeHistoryHostResponse proto.InternalMessageInfo

func (m *DescribeHistoryHostResponse) GetShardsNumber() int32 {
	if m != nil {
		return m.ShardsNumber
	}
	return 0
}

func (m *DescribeHistoryHostResponse) GetShardIds() []int32 {
	if m != nil {
		return m.ShardIds
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetNamespaceCache() *v11.NamespaceCacheInfo {
	if m != nil {
		return m.NamespaceCache
	}
	return nil
}

func (m *DescribeHistoryHostResponse) GetShardControllerStatus() string {
	if m != nil {
		return m.ShardControllerStatus
	}
	return ""
}

func (m *DescribeHistoryHostResponse) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

type CloseShardRequest struct {
	ShardId int32 `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
}

func (m *CloseShardRequest) Reset()      { *m = CloseShardRequest{} }
func (*CloseShardRequest) ProtoMessage() {}
func (*CloseShardRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{4}
}
func (m *CloseShardRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardRequest.Merge(m, src)
}
func (m *CloseShardRequest) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardRequest proto.InternalMessageInfo

func (m *CloseShardRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

type CloseShardResponse struct {
}

func (m *CloseShardResponse) Reset()      { *m = CloseShardResponse{} }
func (*CloseShardResponse) ProtoMessage() {}
func (*CloseShardResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{5}
}
func (m *CloseShardResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseShardResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseShardResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseShardResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseShardResponse.Merge(m, src)
}
func (m *CloseShardResponse) XXX_Size() int {
	return m.Size()
}
func (m *CloseShardResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseShardResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloseShardResponse proto.InternalMessageInfo

type RemoveTaskRequest struct {
	ShardId        int32            `protobuf:"varint,1,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	Category       v12.TaskCategory `protobuf:"varint,2,opt,name=category,proto3,enum=temporal.server.api.enums.v1.TaskCategory" json:"category,omitempty"`
	TaskId         int64            `protobuf:"varint,3,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	VisibilityTime *time.Time       `protobuf:"bytes,4,opt,name=visibility_time,json=visibilityTime,proto3,stdtime" json:"visibility_time,omitempty"`
}

func (m *RemoveTaskRequest) Reset()      { *m = RemoveTaskRequest{} }
func (*RemoveTaskRequest) ProtoMessage() {}
func (*RemoveTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{6}
}
func (m *RemoveTaskRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskRequest.Merge(m, src)
}
func (m *RemoveTaskRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskRequest proto.InternalMessageInfo

func (m *RemoveTaskRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *RemoveTaskRequest) GetCategory() v12.TaskCategory {
	if m != nil {
		return m.Category
	}
	return v12.TASK_CATEGORY_UNSPECIFIED
}

func (m *RemoveTaskRequest) GetTaskId() int64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *RemoveTaskRequest) GetVisibilityTime() *time.Time {
	if m != nil {
		return m.VisibilityTime
	}
	return nil
}

type RemoveTaskResponse struct {
}

func (m *RemoveTaskResponse) Reset()      { *m = RemoveTaskResponse{} }
func (*RemoveTaskResponse) ProtoMessage() {}
func (*RemoveTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{7}
}
func (m *RemoveTaskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveTaskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTaskResponse.Merge(m, src)
}
func (m *RemoveTaskResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTaskResponse proto.InternalMessageInfo

//*
// StartEventId defines the beginning of the event to fetch. The first event is exclusive.
// EndEventId and EndEventVersion defines the end of the event to fetch. The end event is exclusive.
type GetWorkflowExecutionRawHistoryV2Request struct {
	Namespace         string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution         *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	StartEventId      int64                 `protobuf:"varint,3,opt,name=start_event_id,json=startEventId,proto3" json:"start_event_id,omitempty"`
	StartEventVersion int64                 `protobuf:"varint,4,opt,name=start_event_version,json=startEventVersion,proto3" json:"start_event_version,omitempty"`
	EndEventId        int64                 `protobuf:"varint,5,opt,name=end_event_id,json=endEventId,proto3" json:"end_event_id,omitempty"`
	EndEventVersion   int64                 `protobuf:"varint,6,opt,name=end_event_version,json=endEventVersion,proto3" json:"end_event_version,omitempty"`
	MaximumPageSize   int32                 `protobuf:"varint,7,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken     []byte                `protobuf:"bytes,8,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Reset() {
	*m = GetWorkflowExecutionRawHistoryV2Request{}
}
func (*GetWorkflowExecutionRawHistoryV2Request) ProtoMessage() {}
func (*GetWorkflowExecutionRawHistoryV2Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{8}
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.Merge(m, src)
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkflowExecutionRawHistoryV2Request) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Request proto.InternalMessageInfo

func (m *GetWorkflowExecutionRawHistoryV2Request) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetStartEventId() int64 {
	if m != nil {
		return m.StartEventId
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetStartEventVersion() int64 {
	if m != nil {
		return m.StartEventVersion
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetEndEventId() int64 {
	if m != nil {
		return m.EndEventId
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetEndEventVersion() int64 {
	if m != nil {
		return m.EndEventVersion
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *GetWorkflowExecutionRawHistoryV2Request) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetWorkflowExecutionRawHistoryV2Response struct {
	NextPageToken  []byte              `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	HistoryBatches []*v1.DataBlob      `protobuf:"bytes,2,rep,name=history_batches,json=historyBatches,proto3" json:"history_batches,omitempty"`
	VersionHistory *v13.VersionHistory `protobuf:"bytes,3,opt,name=version_history,json=versionHistory,proto3" json:"version_history,omitempty"`
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Reset() {
	*m = GetWorkflowExecutionRawHistoryV2Response{}
}
func (*GetWorkflowExecutionRawHistoryV2Response) ProtoMessage() {}
func (*GetWorkflowExecutionRawHistoryV2Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{9}
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.Merge(m, src)
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkflowExecutionRawHistoryV2Response) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowExecutionRawHistoryV2Response proto.InternalMessageInfo

func (m *GetWorkflowExecutionRawHistoryV2Response) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) GetHistoryBatches() []*v1.DataBlob {
	if m != nil {
		return m.HistoryBatches
	}
	return nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) GetVersionHistory() *v13.VersionHistory {
	if m != nil {
		return m.VersionHistory
	}
	return nil
}

type GetReplicationMessagesRequest struct {
	Tokens      []*v14.ReplicationToken `protobuf:"bytes,1,rep,name=tokens,proto3" json:"tokens,omitempty"`
	ClusterName string                  `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GetReplicationMessagesRequest) Reset()      { *m = GetReplicationMessagesRequest{} }
func (*GetReplicationMessagesRequest) ProtoMessage() {}
func (*GetReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{10}
}
func (m *GetReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesRequest.Merge(m, src)
}
func (m *GetReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetReplicationMessagesRequest) GetTokens() []*v14.ReplicationToken {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *GetReplicationMessagesRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GetReplicationMessagesResponse struct {
	ShardMessages map[int32]*v14.ReplicationMessages `protobuf:"bytes,1,rep,name=shard_messages,json=shardMessages,proto3" json:"shard_messages,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *GetReplicationMessagesResponse) Reset()      { *m = GetReplicationMessagesResponse{} }
func (*GetReplicationMessagesResponse) ProtoMessage() {}
func (*GetReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{11}
}
func (m *GetReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReplicationMessagesResponse.Merge(m, src)
}
func (m *GetReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetReplicationMessagesResponse) GetShardMessages() map[int32]*v14.ReplicationMessages {
	if m != nil {
		return m.ShardMessages
	}
	return nil
}

type GetNamespaceReplicationMessagesRequest struct {
	// lastRetrievedMessageId is where the next fetch should begin with.
	LastRetrievedMessageId int64 `protobuf:"varint,1,opt,name=last_retrieved_message_id,json=lastRetrievedMessageId,proto3" json:"last_retrieved_message_id,omitempty"`
	// lastProcessedMessageId is the last messageId that is processed on the passive side.
	// This can be different than lastRetrievedMessageId if passive side supports prefetching messages.
	LastProcessedMessageId int64 `protobuf:"varint,2,opt,name=last_processed_message_id,json=lastProcessedMessageId,proto3" json:"last_processed_message_id,omitempty"`
	// clusterName is the name of the pulling cluster.
	ClusterName string `protobuf:"bytes,3,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GetNamespaceReplicationMessagesRequest) Reset() {
	*m = GetNamespaceReplicationMessagesRequest{}
}
func (*GetNamespaceReplicationMessagesRequest) ProtoMessage() {}
func (*GetNamespaceReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{12}
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespaceReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceReplicationMessagesRequest.Merge(m, src)
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespaceReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetNamespaceReplicationMessagesRequest) GetLastRetrievedMessageId() int64 {
	if m != nil {
		return m.LastRetrievedMessageId
	}
	return 0
}

func (m *GetNamespaceReplicationMessagesRequest) GetLastProcessedMessageId() int64 {
	if m != nil {
		return m.LastProcessedMessageId
	}
	return 0
}

func (m *GetNamespaceReplicationMessagesRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GetNamespaceReplicationMessagesResponse struct {
	Messages *v14.ReplicationMessages `protobuf:"bytes,1,opt,name=messages,proto3" json:"messages,omitempty"`
}

func (m *GetNamespaceReplicationMessagesResponse) Reset() {
	*m = GetNamespaceReplicationMessagesResponse{}
}
func (*GetNamespaceReplicationMessagesResponse) ProtoMessage() {}
func (*GetNamespaceReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{13}
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespaceReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceReplicationMessagesResponse.Merge(m, src)
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespaceReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetNamespaceReplicationMessagesResponse) GetMessages() *v14.ReplicationMessages {
	if m != nil {
		return m.Messages
	}
	return nil
}

type GetDLQReplicationMessagesRequest struct {
	TaskInfos []*v14.ReplicationTaskInfo `protobuf:"bytes,1,rep,name=task_infos,json=taskInfos,proto3" json:"task_infos,omitempty"`
}

func (m *GetDLQReplicationMessagesRequest) Reset()      { *m = GetDLQReplicationMessagesRequest{} }
func (*GetDLQReplicationMessagesRequest) ProtoMessage() {}
func (*GetDLQReplicationMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{14}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.Merge(m, src)
}
func (m *GetDLQReplicationMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesRequest proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesRequest) GetTaskInfos() []*v14.ReplicationTaskInfo {
	if m != nil {
		return m.TaskInfos
	}
	return nil
}

type GetDLQReplicationMessagesResponse struct {
	ReplicationTasks []*v14.ReplicationTask `protobuf:"bytes,1,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
}

func (m *GetDLQReplicationMessagesResponse) Reset()      { *m = GetDLQReplicationMessagesResponse{} }
func (*GetDLQReplicationMessagesResponse) ProtoMessage() {}
func (*GetDLQReplicationMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{15}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQReplicationMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQReplicationMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.Merge(m, src)
}
func (m *GetDLQReplicationMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQReplicationMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQReplicationMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQReplicationMessagesResponse proto.InternalMessageInfo

func (m *GetDLQReplicationMessagesResponse) GetReplicationTasks() []*v14.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

// ReapplyEventsRequest is the request for reapply events API.
type ReapplyEventsRequest struct {
	Namespace         string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	WorkflowExecution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=workflow_execution,json=workflowExecution,proto3" json:"workflow_execution,omitempty"`
	Events            *v1.DataBlob          `protobuf:"bytes,3,opt,name=events,proto3" json:"events,omitempty"`
}

func (m *ReapplyEventsRequest) Reset()      { *m = ReapplyEventsRequest{} }
func (*ReapplyEventsRequest) ProtoMessage() {}
func (*ReapplyEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{16}
}
func (m *ReapplyEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsRequest.Merge(m, src)
}
func (m *ReapplyEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsRequest proto.InternalMessageInfo

func (m *ReapplyEventsRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ReapplyEventsRequest) GetWorkflowExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.WorkflowExecution
	}
	return nil
}

func (m *ReapplyEventsRequest) GetEvents() *v1.DataBlob {
	if m != nil {
		return m.Events
	}
	return nil
}

type ReapplyEventsResponse struct {
}

func (m *ReapplyEventsResponse) Reset()      { *m = ReapplyEventsResponse{} }
func (*ReapplyEventsResponse) ProtoMessage() {}
func (*ReapplyEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{17}
}
func (m *ReapplyEventsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReapplyEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReapplyEventsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReapplyEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReapplyEventsResponse.Merge(m, src)
}
func (m *ReapplyEventsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReapplyEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReapplyEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReapplyEventsResponse proto.InternalMessageInfo

type AddSearchAttributeRequest struct {
	SearchAttribute map[string]v15.IndexedValueType `protobuf:"bytes,1,rep,name=search_attribute,json=searchAttribute,proto3" json:"search_attribute,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=temporal.api.enums.v1.IndexedValueType"`
	SecurityToken   string                          `protobuf:"bytes,2,opt,name=security_token,json=securityToken,proto3" json:"security_token,omitempty"`
}

func (m *AddSearchAttributeRequest) Reset()      { *m = AddSearchAttributeRequest{} }
func (*AddSearchAttributeRequest) ProtoMessage() {}
func (*AddSearchAttributeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{18}
}
func (m *AddSearchAttributeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSearchAttributeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSearchAttributeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSearchAttributeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSearchAttributeRequest.Merge(m, src)
}
func (m *AddSearchAttributeRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddSearchAttributeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSearchAttributeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddSearchAttributeRequest proto.InternalMessageInfo

func (m *AddSearchAttributeRequest) GetSearchAttribute() map[string]v15.IndexedValueType {
	if m != nil {
		return m.SearchAttribute
	}
	return nil
}

func (m *AddSearchAttributeRequest) GetSecurityToken() string {
	if m != nil {
		return m.SecurityToken
	}
	return ""
}

type AddSearchAttributeResponse struct {
}

func (m *AddSearchAttributeResponse) Reset()      { *m = AddSearchAttributeResponse{} }
func (*AddSearchAttributeResponse) ProtoMessage() {}
func (*AddSearchAttributeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{19}
}
func (m *AddSearchAttributeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSearchAttributeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSearchAttributeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSearchAttributeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSearchAttributeResponse.Merge(m, src)
}
func (m *AddSearchAttributeResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddSearchAttributeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSearchAttributeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddSearchAttributeResponse proto.InternalMessageInfo

type DescribeClusterRequest struct {
}

func (m *DescribeClusterRequest) Reset()      { *m = DescribeClusterRequest{} }
func (*DescribeClusterRequest) ProtoMessage() {}
func (*DescribeClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{20}
}
func (m *DescribeClusterRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeClusterRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeClusterRequest.Merge(m, src)
}
func (m *DescribeClusterRequest) XXX_Size() int {
	return m.Size()
}
func (m *DescribeClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeClusterRequest proto.InternalMessageInfo

type DescribeClusterResponse struct {
	SupportedClients map[string]string   `protobuf:"bytes,1,rep,name=supported_clients,json=supportedClients,proto3" json:"supported_clients,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ServerVersion    string              `protobuf:"bytes,2,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
	MembershipInfo   *v16.MembershipInfo `protobuf:"bytes,3,opt,name=membership_info,json=membershipInfo,proto3" json:"membership_info,omitempty"`
}

func (m *DescribeClusterResponse) Reset()      { *m = DescribeClusterResponse{} }
func (*DescribeClusterResponse) ProtoMessage() {}
func (*DescribeClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{21}
}
func (m *DescribeClusterResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DescribeClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DescribeClusterResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DescribeClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribeClusterResponse.Merge(m, src)
}
func (m *DescribeClusterResponse) XXX_Size() int {
	return m.Size()
}
func (m *DescribeClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribeClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribeClusterResponse proto.InternalMessageInfo

func (m *DescribeClusterResponse) GetSupportedClients() map[string]string {
	if m != nil {
		return m.SupportedClients
	}
	return nil
}

func (m *DescribeClusterResponse) GetServerVersion() string {
	if m != nil {
		return m.ServerVersion
	}
	return ""
}

func (m *DescribeClusterResponse) GetMembershipInfo() *v16.MembershipInfo {
	if m != nil {
		return m.MembershipInfo
	}
	return nil
}

type GetDLQMessagesRequest struct {
	Type                  v12.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesRequest) Reset()      { *m = GetDLQMessagesRequest{} }
func (*GetDLQMessagesRequest) ProtoMessage() {}
func (*GetDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{22}
}
func (m *GetDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesRequest.Merge(m, src)
}
func (m *GetDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesRequest proto.InternalMessageInfo

func (m *GetDLQMessagesRequest) GetType() v12.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v12.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *GetDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *GetDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type GetDLQMessagesResponse struct {
	Type             v12.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ReplicationTasks []*v14.ReplicationTask  `protobuf:"bytes,2,rep,name=replication_tasks,json=replicationTasks,proto3" json:"replication_tasks,omitempty"`
	NextPageToken    []byte                  `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *GetDLQMessagesResponse) Reset()      { *m = GetDLQMessagesResponse{} }
func (*GetDLQMessagesResponse) ProtoMessage() {}
func (*GetDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{23}
}
func (m *GetDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDLQMessagesResponse.Merge(m, src)
}
func (m *GetDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDLQMessagesResponse proto.InternalMessageInfo

func (m *GetDLQMessagesResponse) GetType() v12.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v12.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *GetDLQMessagesResponse) GetReplicationTasks() []*v14.ReplicationTask {
	if m != nil {
		return m.ReplicationTasks
	}
	return nil
}

func (m *GetDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type PurgeDLQMessagesRequest struct {
	Type                  v12.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
}

func (m *PurgeDLQMessagesRequest) Reset()      { *m = PurgeDLQMessagesRequest{} }
func (*PurgeDLQMessagesRequest) ProtoMessage() {}
func (*PurgeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{24}
}
func (m *PurgeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesRequest.Merge(m, src)
}
func (m *PurgeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesRequest proto.InternalMessageInfo

func (m *PurgeDLQMessagesRequest) GetType() v12.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v12.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *PurgeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *PurgeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *PurgeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

type PurgeDLQMessagesResponse struct {
}

func (m *PurgeDLQMessagesResponse) Reset()      { *m = PurgeDLQMessagesResponse{} }
func (*PurgeDLQMessagesResponse) ProtoMessage() {}
func (*PurgeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{25}
}
func (m *PurgeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeDLQMessagesResponse.Merge(m, src)
}
func (m *PurgeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *PurgeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeDLQMessagesResponse proto.InternalMessageInfo

type MergeDLQMessagesRequest struct {
	Type                  v12.DeadLetterQueueType `protobuf:"varint,1,opt,name=type,proto3,enum=temporal.server.api.enums.v1.DeadLetterQueueType" json:"type,omitempty"`
	ShardId               int32                   `protobuf:"varint,2,opt,name=shard_id,json=shardId,proto3" json:"shard_id,omitempty"`
	SourceCluster         string                  `protobuf:"bytes,3,opt,name=source_cluster,json=sourceCluster,proto3" json:"source_cluster,omitempty"`
	InclusiveEndMessageId int64                   `protobuf:"varint,4,opt,name=inclusive_end_message_id,json=inclusiveEndMessageId,proto3" json:"inclusive_end_message_id,omitempty"`
	MaximumPageSize       int32                   `protobuf:"varint,5,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty"`
	NextPageToken         []byte                  `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesRequest) Reset()      { *m = MergeDLQMessagesRequest{} }
func (*MergeDLQMessagesRequest) ProtoMessage() {}
func (*MergeDLQMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{26}
}
func (m *MergeDLQMessagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesRequest.Merge(m, src)
}
func (m *MergeDLQMessagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesRequest proto.InternalMessageInfo

func (m *MergeDLQMessagesRequest) GetType() v12.DeadLetterQueueType {
	if m != nil {
		return m.Type
	}
	return v12.DEAD_LETTER_QUEUE_TYPE_UNSPECIFIED
}

func (m *MergeDLQMessagesRequest) GetShardId() int32 {
	if m != nil {
		return m.ShardId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetSourceCluster() string {
	if m != nil {
		return m.SourceCluster
	}
	return ""
}

func (m *MergeDLQMessagesRequest) GetInclusiveEndMessageId() int64 {
	if m != nil {
		return m.InclusiveEndMessageId
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetMaximumPageSize() int32 {
	if m != nil {
		return m.MaximumPageSize
	}
	return 0
}

func (m *MergeDLQMessagesRequest) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type MergeDLQMessagesResponse struct {
	NextPageToken []byte `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (m *MergeDLQMessagesResponse) Reset()      { *m = MergeDLQMessagesResponse{} }
func (*MergeDLQMessagesResponse) ProtoMessage() {}
func (*MergeDLQMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{27}
}
func (m *MergeDLQMessagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeDLQMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeDLQMessagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeDLQMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeDLQMessagesResponse.Merge(m, src)
}
func (m *MergeDLQMessagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *MergeDLQMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeDLQMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MergeDLQMessagesResponse proto.InternalMessageInfo

func (m *MergeDLQMessagesResponse) GetNextPageToken() []byte {
	if m != nil {
		return m.NextPageToken
	}
	return nil
}

type RefreshWorkflowTasksRequest struct {
	Namespace string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Execution *v1.WorkflowExecution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (m *RefreshWorkflowTasksRequest) Reset()      { *m = RefreshWorkflowTasksRequest{} }
func (*RefreshWorkflowTasksRequest) ProtoMessage() {}
func (*RefreshWorkflowTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{28}
}
func (m *RefreshWorkflowTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksRequest.Merge(m, src)
}
func (m *RefreshWorkflowTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksRequest proto.InternalMessageInfo

func (m *RefreshWorkflowTasksRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *RefreshWorkflowTasksRequest) GetExecution() *v1.WorkflowExecution {
	if m != nil {
		return m.Execution
	}
	return nil
}

type RefreshWorkflowTasksResponse struct {
}

func (m *RefreshWorkflowTasksResponse) Reset()      { *m = RefreshWorkflowTasksResponse{} }
func (*RefreshWorkflowTasksResponse) ProtoMessage() {}
func (*RefreshWorkflowTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{29}
}
func (m *RefreshWorkflowTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshWorkflowTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RefreshWorkflowTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RefreshWorkflowTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshWorkflowTasksResponse.Merge(m, src)
}
func (m *RefreshWorkflowTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *RefreshWorkflowTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshWorkflowTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshWorkflowTasksResponse proto.InternalMessageInfo

type ResendReplicationTasksRequest struct {
	NamespaceId   string `protobuf:"bytes,1,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	WorkflowId    string `protobuf:"bytes,2,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	RunId         string `protobuf:"bytes,3,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	RemoteCluster string `protobuf:"bytes,4,opt,name=remote_cluster,json=remoteCluster,proto3" json:"remote_cluster,omitempty"`
	StartEventId  int64  `protobuf:"varint,5,opt,name=start_event_id,json=startEventId,proto3" json:"start_event_id,omitempty"`
	StartVersion  int64  `protobuf:"varint,6,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndEventId    int64  `protobuf:"varint,7,opt,name=end_event_id,json=endEventId,proto3" json:"end_event_id,omitempty"`
	EndVersion    int64  `protobuf:"varint,8,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
}

func (m *ResendReplicationTasksRequest) Reset()      { *m = ResendReplicationTasksRequest{} }
func (*ResendReplicationTasksRequest) ProtoMessage() {}
func (*ResendReplicationTasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{30}
}
func (m *ResendReplicationTasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResendReplicationTasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResendReplicationTasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResendReplicationTasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResendReplicationTasksRequest.Merge(m, src)
}
func (m *ResendReplicationTasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResendReplicationTasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResendReplicationTasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResendReplicationTasksRequest proto.InternalMessageInfo

func (m *ResendReplicationTasksRequest) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetWorkflowId() string {
	if m != nil {
		return m.WorkflowId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetRunId() string {
	if m != nil {
		return m.RunId
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetRemoteCluster() string {
	if m != nil {
		return m.RemoteCluster
	}
	return ""
}

func (m *ResendReplicationTasksRequest) GetStartEventId() int64 {
	if m != nil {
		return m.StartEventId
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetStartVersion() int64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetEndEventId() int64 {
	if m != nil {
		return m.EndEventId
	}
	return 0
}

func (m *ResendReplicationTasksRequest) GetEndVersion() int64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

type ResendReplicationTasksResponse struct {
}

func (m *ResendReplicationTasksResponse) Reset()      { *m = ResendReplicationTasksResponse{} }
func (*ResendReplicationTasksResponse) ProtoMessage() {}
func (*ResendReplicationTasksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cc07c1a2abe7cb51, []int{31}
}
func (m *ResendReplicationTasksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResendReplicationTasksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResendReplicationTasksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResendReplicationTasksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResendReplicationTasksResponse.Merge(m, src)
}
func (m *ResendReplicationTasksResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResendReplicationTasksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResendReplicationTasksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResendReplicationTasksResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*DescribeWorkflowExecutionRequest)(nil), "temporal.server.api.adminservice.v1.DescribeWorkflowExecutionRequest")
	proto.RegisterType((*DescribeWorkflowExecutionResponse)(nil), "temporal.server.api.adminservice.v1.DescribeWorkflowExecutionResponse")
	proto.RegisterType((*DescribeHistoryHostRequest)(nil), "temporal.server.api.adminservice.v1.DescribeHistoryHostRequest")
	proto.RegisterType((*DescribeHistoryHostResponse)(nil), "temporal.server.api.adminservice.v1.DescribeHistoryHostResponse")
	proto.RegisterType((*CloseShardRequest)(nil), "temporal.server.api.adminservice.v1.CloseShardRequest")
	proto.RegisterType((*CloseShardResponse)(nil), "temporal.server.api.adminservice.v1.CloseShardResponse")
	proto.RegisterType((*RemoveTaskRequest)(nil), "temporal.server.api.adminservice.v1.RemoveTaskRequest")
	proto.RegisterType((*RemoveTaskResponse)(nil), "temporal.server.api.adminservice.v1.RemoveTaskResponse")
	proto.RegisterType((*GetWorkflowExecutionRawHistoryV2Request)(nil), "temporal.server.api.adminservice.v1.GetWorkflowExecutionRawHistoryV2Request")
	proto.RegisterType((*GetWorkflowExecutionRawHistoryV2Response)(nil), "temporal.server.api.adminservice.v1.GetWorkflowExecutionRawHistoryV2Response")
	proto.RegisterType((*GetReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesRequest")
	proto.RegisterType((*GetReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesResponse")
	proto.RegisterMapType((map[int32]*v14.ReplicationMessages)(nil), "temporal.server.api.adminservice.v1.GetReplicationMessagesResponse.ShardMessagesEntry")
	proto.RegisterType((*GetNamespaceReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetNamespaceReplicationMessagesRequest")
	proto.RegisterType((*GetNamespaceReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetNamespaceReplicationMessagesResponse")
	proto.RegisterType((*GetDLQReplicationMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetDLQReplicationMessagesRequest")
	proto.RegisterType((*GetDLQReplicationMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetDLQReplicationMessagesResponse")
	proto.RegisterType((*ReapplyEventsRequest)(nil), "temporal.server.api.adminservice.v1.ReapplyEventsRequest")
	proto.RegisterType((*ReapplyEventsResponse)(nil), "temporal.server.api.adminservice.v1.ReapplyEventsResponse")
	proto.RegisterType((*AddSearchAttributeRequest)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributeRequest")
	proto.RegisterMapType((map[string]v15.IndexedValueType)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributeRequest.SearchAttributeEntry")
	proto.RegisterType((*AddSearchAttributeResponse)(nil), "temporal.server.api.adminservice.v1.AddSearchAttributeResponse")
	proto.RegisterType((*DescribeClusterRequest)(nil), "temporal.server.api.adminservice.v1.DescribeClusterRequest")
	proto.RegisterType((*DescribeClusterResponse)(nil), "temporal.server.api.adminservice.v1.DescribeClusterResponse")
	proto.RegisterMapType((map[string]string)(nil), "temporal.server.api.adminservice.v1.DescribeClusterResponse.SupportedClientsEntry")
	proto.RegisterType((*GetDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.GetDLQMessagesRequest")
	proto.RegisterType((*GetDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.GetDLQMessagesResponse")
	proto.RegisterType((*PurgeDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.PurgeDLQMessagesRequest")
	proto.RegisterType((*PurgeDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.PurgeDLQMessagesResponse")
	proto.RegisterType((*MergeDLQMessagesRequest)(nil), "temporal.server.api.adminservice.v1.MergeDLQMessagesRequest")
	proto.RegisterType((*MergeDLQMessagesResponse)(nil), "temporal.server.api.adminservice.v1.MergeDLQMessagesResponse")
	proto.RegisterType((*RefreshWorkflowTasksRequest)(nil), "temporal.server.api.adminservice.v1.RefreshWorkflowTasksRequest")
	proto.RegisterType((*RefreshWorkflowTasksResponse)(nil), "temporal.server.api.adminservice.v1.RefreshWorkflowTasksResponse")
	proto.RegisterType((*ResendReplicationTasksRequest)(nil), "temporal.server.api.adminservice.v1.ResendReplicationTasksRequest")
	proto.RegisterType((*ResendReplicationTasksResponse)(nil), "temporal.server.api.adminservice.v1.ResendReplicationTasksResponse")
}

func init() {
	proto.RegisterFile("temporal/server/api/adminservice/v1/request_response.proto", fileDescriptor_cc07c1a2abe7cb51)
}

var fileDescriptor_cc07c1a2abe7cb51 = []byte{
	// 1849 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0x4b, 0x6f, 0x1b, 0xd7,
	0x15, 0xd6, 0x90, 0x96, 0x2c, 0x1e, 0x49, 0x94, 0x35, 0x95, 0x2c, 0x9a, 0x76, 0x68, 0x79, 0x9c,
	0xc6, 0x8a, 0x51, 0x8c, 0x6a, 0x25, 0x48, 0xd2, 0x14, 0x5d, 0x58, 0xb2, 0xaa, 0x10, 0xb0, 0x02,
	0x67, 0x64, 0xc8, 0x45, 0x81, 0x82, 0xbd, 0xe4, 0x1c, 0x51, 0x03, 0x71, 0x1e, 0xbd, 0xf7, 0x0e,
	0x6d, 0x19, 0x68, 0xda, 0x45, 0x0b, 0xb4, 0x3b, 0xaf, 0xfb, 0x0b, 0xba, 0x29, 0xfa, 0x1b, 0xba,
	0xcb, 0xd2, 0xe8, 0x2a, 0x68, 0x17, 0xa9, 0xe5, 0x4d, 0xbb, 0xcb, 0xaa, 0xbb, 0x02, 0xc5, 0x7d,
	0xcd, 0xf0, 0x31, 0xa2, 0xe5, 0x26, 0xcd, 0x22, 0xbb, 0x99, 0xf3, 0x9a, 0xf3, 0xba, 0xdf, 0x39,
	0x77, 0xe0, 0x43, 0x8e, 0x61, 0x12, 0x53, 0xd2, 0xdb, 0x60, 0x48, 0xfb, 0x48, 0x37, 0x48, 0x12,
	0x6c, 0x10, 0x3f, 0x0c, 0x22, 0xf1, 0x1e, 0x74, 0x70, 0xa3, 0x7f, 0x67, 0x83, 0xe2, 0x2f, 0x52,
	0x64, 0xbc, 0x45, 0x91, 0x25, 0x71, 0xc4, 0xd0, 0x4d, 0x68, 0xcc, 0x63, 0xfb, 0xa6, 0xd1, 0x75,
	0x95, 0xae, 0x4b, 0x92, 0xc0, 0x1d, 0xd4, 0x75, 0xfb, 0x77, 0xea, 0xd7, 0xbb, 0x71, 0xdc, 0xed,
	0xe1, 0x86, 0x54, 0x69, 0xa7, 0x87, 0x1b, 0x3c, 0x08, 0x91, 0x71, 0x12, 0x26, 0xca, 0x4a, 0xfd,
	0x86, 0x8f, 0x09, 0x46, 0x3e, 0x46, 0x9d, 0x00, 0xd9, 0x46, 0x37, 0xee, 0xc6, 0x92, 0x2e, 0x9f,
	0xb4, 0x88, 0x93, 0x39, 0x29, 0xbc, 0xc3, 0x28, 0x0d, 0x99, 0x70, 0xab, 0x13, 0x87, 0x61, 0x1c,
	0x69, 0x99, 0x37, 0x87, 0x64, 0x14, 0x4b, 0x08, 0x85, 0xc8, 0x18, 0xe9, 0x6a, 0x97, 0xeb, 0xdf,
	0x2b, 0x0a, 0xb7, 0xd3, 0x4b, 0x19, 0x47, 0x3a, 0x2e, 0xfd, 0x76, 0x91, 0x74, 0xf1, 0xe7, 0x6f,
	0x4d, 0x14, 0xe5, 0x84, 0x1d, 0x6b, 0x41, 0xb7, 0x48, 0x30, 0x22, 0x21, 0xb2, 0x84, 0xa8, 0x6c,
	0x9f, 0xc3, 0xe3, 0xa3, 0x80, 0xf1, 0x98, 0x9e, 0x8c, 0x4b, 0x7f, 0xbf, 0x48, 0x9a, 0x62, 0xd2,
	0x0b, 0x3a, 0x84, 0x07, 0x05, 0x19, 0x71, 0x7e, 0x6f, 0xc1, 0xda, 0x3d, 0x64, 0x1d, 0x1a, 0xb4,
	0xf1, 0x51, 0x4c, 0x8f, 0x0f, 0x7b, 0xf1, 0xe3, 0x9d, 0x27, 0xd8, 0x49, 0x85, 0xb8, 0xa7, 0x0a,
	0x6f, 0x5f, 0x83, 0x4a, 0xe6, 0x62, 0xcd, 0x5a, 0xb3, 0xd6, 0x2b, 0x5e, 0x4e, 0xb0, 0x77, 0xa1,
	0x82, 0x46, 0xa3, 0x56, 0x5a, 0xb3, 0xd6, 0xe7, 0x36, 0xdf, 0xce, 0xc2, 0x94, 0x4d, 0xa1, 0x53,
	0xd5, 0xbf, 0xe3, 0x8e, 0x7f, 0x22, 0xd7, 0x75, 0xfe, 0x63, 0xc1, 0x8d, 0x09, 0xbe, 0xa8, 0xe6,
	0xb3, 0xaf, 0xc0, 0x2c, 0x3b, 0x22, 0xd4, 0x6f, 0x05, 0xbe, 0xf6, 0xe5, 0xa2, 0x7c, 0x6f, 0xfa,
	0xf6, 0x0d, 0x98, 0xd7, 0xa9, 0x69, 0x11, 0xdf, 0xa7, 0xd2, 0x99, 0x8a, 0x37, 0xa7, 0x69, 0x77,
	0x7d, 0x9f, 0xda, 0x2e, 0x7c, 0xa7, 0x43, 0x3a, 0x47, 0xd8, 0x0a, 0x53, 0x4e, 0xda, 0x3d, 0x6c,
	0x31, 0x4e, 0x38, 0xd6, 0xca, 0x52, 0x72, 0x49, 0xb2, 0xf6, 0x14, 0x67, 0x5f, 0x30, 0xec, 0x77,
	0xe1, 0xb2, 0x4f, 0x38, 0x69, 0x13, 0x36, 0xaa, 0x72, 0x41, 0xaa, 0x2c, 0x1b, 0xee, 0x90, 0xd6,
	0x2a, 0x5c, 0xe4, 0x14, 0x51, 0xb8, 0x38, 0x2d, 0xc5, 0x66, 0xc4, 0x6b, 0xd3, 0xb7, 0xaf, 0x42,
	0xa5, 0x4d, 0x49, 0xd4, 0x39, 0x12, 0xac, 0x19, 0xc9, 0x9a, 0x55, 0x84, 0xa6, 0xef, 0xfc, 0xd5,
	0x82, 0xba, 0x89, 0xff, 0x23, 0xe5, 0xf3, 0x47, 0x31, 0xe3, 0xa6, 0x0a, 0x22, 0xba, 0x98, 0x71,
	0x19, 0x1a, 0x32, 0xa6, 0x83, 0x9f, 0x13, 0xb4, 0xbb, 0x8a, 0x34, 0x94, 0x1b, 0x11, 0xfc, 0x74,
	0x9e, 0x9b, 0xa1, 0x1a, 0x96, 0x47, 0x6b, 0xf8, 0x13, 0xb0, 0x1f, 0xeb, 0x8c, 0xb7, 0xf2, 0x62,
	0x5e, 0x78, 0xdd, 0x62, 0x2e, 0x3d, 0x1e, 0x25, 0x39, 0xcf, 0x4a, 0x70, 0xb5, 0x30, 0x28, 0x5d,
	0xce, 0x9b, 0xb0, 0x20, 0x5d, 0x64, 0xad, 0x28, 0x0d, 0xdb, 0x48, 0x65, 0x58, 0xd3, 0xde, 0xbc,
	0x22, 0x7e, 0x2c, 0x69, 0x22, 0x6d, 0x26, 0x2e, 0x56, 0x2b, 0xad, 0x95, 0xd7, 0xa7, 0xbd, 0x59,
	0x1d, 0x18, 0xb3, 0x7f, 0x06, 0x8b, 0x59, 0x20, 0x2d, 0x59, 0x41, 0x19, 0xdf, 0xdc, 0xe6, 0xbb,
	0x6e, 0x11, 0x42, 0x65, 0xb2, 0x22, 0x84, 0x8f, 0xcd, 0xcb, 0xb6, 0xd0, 0x6b, 0x46, 0x87, 0xb1,
	0x57, 0x8d, 0x86, 0x68, 0xf6, 0x7b, 0xb0, 0xaa, 0xbe, 0xdd, 0x89, 0x23, 0x4e, 0xe3, 0x5e, 0x0f,
	0xa9, 0xec, 0x80, 0x94, 0xe9, 0x16, 0x58, 0x91, 0xec, 0xed, 0x8c, 0xbb, 0x2f, 0x99, 0x76, 0x0d,
	0x2e, 0x9a, 0x4a, 0xa9, 0x1e, 0x30, 0xaf, 0x8e, 0x0b, 0x4b, 0xdb, 0xbd, 0x98, 0xe1, 0xbe, 0xd0,
	0x33, 0xd5, 0x1d, 0x6d, 0xeb, 0xbc, 0x74, 0xce, 0x32, 0xd8, 0x83, 0xf2, 0x2a, 0x71, 0xce, 0xdf,
	0x2c, 0x58, 0xf2, 0x30, 0x8c, 0xfb, 0xf8, 0x90, 0xb0, 0xe3, 0x57, 0x9b, 0xb1, 0x7f, 0x0c, 0xb3,
	0x1d, 0xc2, 0xb1, 0x1b, 0xd3, 0x13, 0xd9, 0x1c, 0xd5, 0xcd, 0xdb, 0x85, 0x09, 0x92, 0xb0, 0x25,
	0x92, 0x23, 0xec, 0x6e, 0x6b, 0x0d, 0x2f, 0xd3, 0x95, 0xcd, 0x4d, 0xd8, 0xb1, 0xf8, 0x82, 0xc8,
	0x73, 0xd9, 0x9b, 0x11, 0xaf, 0x4d, 0xdf, 0x6e, 0xc2, 0x62, 0x3f, 0x60, 0x41, 0x3b, 0xe8, 0x05,
	0xfc, 0xa4, 0x25, 0x80, 0x5e, 0x77, 0x50, 0xdd, 0x55, 0x53, 0xc0, 0x35, 0x53, 0xc0, 0x7d, 0x68,
	0xa6, 0xc0, 0xd6, 0x85, 0x67, 0x5f, 0x5c, 0xb7, 0xbc, 0x6a, 0xae, 0x28, 0x58, 0x22, 0xe4, 0xc1,
	0xd8, 0x74, 0xc8, 0xbf, 0x2b, 0xc3, 0xad, 0x5d, 0xe4, 0xe3, 0x7d, 0x47, 0x1e, 0xeb, 0xd6, 0x3a,
	0xd8, 0xfc, 0x66, 0x31, 0xcb, 0x7e, 0x13, 0xaa, 0x8c, 0x13, 0xca, 0x5b, 0xd8, 0xc7, 0x88, 0xe7,
	0x39, 0x99, 0x97, 0xd4, 0x1d, 0x41, 0x6c, 0xfa, 0x02, 0x75, 0x06, 0xa5, 0xfa, 0x48, 0x99, 0x39,
	0x5f, 0x65, 0x6f, 0x29, 0x17, 0x3d, 0x50, 0x0c, 0x7b, 0x0d, 0xe6, 0x31, 0xf2, 0x73, 0x9b, 0xd3,
	0x52, 0x10, 0x30, 0xf2, 0x8d, 0xc5, 0xdb, 0xb0, 0x94, 0x4b, 0x18, 0x7b, 0x33, 0x52, 0x6c, 0xd1,
	0x88, 0x19, 0x6b, 0xb7, 0x61, 0x29, 0x24, 0x4f, 0x82, 0x30, 0x0d, 0x5b, 0x09, 0xe9, 0x62, 0x8b,
	0x05, 0x4f, 0xb1, 0x76, 0x51, 0x36, 0xc7, 0xa2, 0x66, 0x3c, 0x20, 0x5d, 0xdc, 0x0f, 0x9e, 0xa2,
	0xfd, 0x16, 0x2c, 0x46, 0xf8, 0x84, 0x2b, 0x41, 0x1e, 0x1f, 0x63, 0x54, 0x9b, 0x5d, 0xb3, 0xd6,
	0xe7, 0xbd, 0x05, 0x41, 0x16, 0x62, 0x0f, 0x05, 0xd1, 0xf9, 0xb7, 0x05, 0xeb, 0xaf, 0x2e, 0x85,
	0x3e, 0xe3, 0x05, 0x46, 0xad, 0x02, 0xa3, 0xa2, 0x81, 0x0c, 0x7e, 0xb7, 0x09, 0xef, 0x1c, 0xa1,
	0x3a, 0xec, 0x73, 0x9b, 0x6b, 0x67, 0xd5, 0xe6, 0x1e, 0xe1, 0x64, 0xab, 0x17, 0xb7, 0xbd, 0xaa,
	0x56, 0xdc, 0x52, 0x7a, 0xf6, 0x23, 0x58, 0xd4, 0x59, 0x69, 0x69, 0x8e, 0x06, 0x05, 0xb7, 0xb0,
	0xe7, 0xb5, 0x8c, 0x30, 0xa9, 0xb3, 0xa6, 0xa3, 0xf0, 0xaa, 0xfd, 0xa1, 0x77, 0xe7, 0x99, 0x05,
	0x6f, 0xec, 0x22, 0xf7, 0xf2, 0xa1, 0xba, 0xa7, 0x06, 0x2a, 0x33, 0x9d, 0x77, 0x1f, 0x66, 0x64,
	0x8c, 0x02, 0xa1, 0xcb, 0x67, 0xc2, 0xd0, 0xc0, 0x54, 0x16, 0x5f, 0x1d, 0xb0, 0x27, 0x73, 0xe1,
	0x69, 0x1b, 0x02, 0xf5, 0xf5, 0x82, 0xd2, 0x12, 0xed, 0x6b, 0x66, 0x9a, 0xa6, 0x09, 0xfc, 0x72,
	0xfe, 0x50, 0x82, 0xc6, 0x59, 0x2e, 0xe9, 0x0a, 0xfc, 0x12, 0xaa, 0x0a, 0x16, 0xf4, 0xf4, 0x37,
	0xbe, 0x1d, 0xb8, 0xe7, 0x58, 0xe2, 0xdc, 0xc9, 0xc6, 0x5d, 0x89, 0x4b, 0x86, 0xba, 0x13, 0x71,
	0x7a, 0xe2, 0x29, 0x4c, 0x37, 0xb4, 0xfa, 0x09, 0xd8, 0xe3, 0x42, 0xf6, 0x25, 0x28, 0x1f, 0xe3,
	0x89, 0x86, 0x29, 0xf1, 0x68, 0xef, 0xc1, 0x74, 0x9f, 0xf4, 0x52, 0xd4, 0x47, 0xf2, 0xfd, 0xd7,
	0xcc, 0x5c, 0xe6, 0x99, 0xb2, 0xf2, 0x61, 0xe9, 0x03, 0xcb, 0xf9, 0x8b, 0x05, 0x6f, 0xed, 0x22,
	0xcf, 0x80, 0x7e, 0x42, 0xe1, 0x7e, 0x00, 0x57, 0x7a, 0x44, 0xee, 0xb9, 0x9c, 0x06, 0xd8, 0xc7,
	0x2c, 0x5b, 0x06, 0x4c, 0xcb, 0xde, 0x65, 0x21, 0xe0, 0x19, 0xbe, 0x36, 0xd0, 0xf4, 0x33, 0xd5,
	0x84, 0xc6, 0x1d, 0x64, 0x6c, 0x58, 0xb5, 0x94, 0xab, 0x3e, 0x30, 0xfc, 0x5c, 0x75, 0xb4, 0xc0,
	0xe5, 0xf1, 0x02, 0x7f, 0x2a, 0x61, 0x6f, 0x72, 0x08, 0xba, 0xd0, 0xfb, 0x30, 0x3b, 0x50, 0xe2,
	0xaf, 0x94, 0xc4, 0xcc, 0x90, 0xf3, 0x14, 0xd6, 0x76, 0x91, 0xdf, 0xbb, 0xff, 0xc9, 0x84, 0xe4,
	0x1d, 0x00, 0xa8, 0xa9, 0x10, 0x1d, 0xc6, 0xa6, 0xbb, 0x5e, 0xf7, 0xd3, 0x02, 0xec, 0xe5, 0x0c,
	0xae, 0x70, 0xfd, 0xc4, 0x9c, 0xdf, 0x5a, 0x70, 0x63, 0xc2, 0xc7, 0x75, 0xd8, 0x3f, 0x87, 0xa5,
	0x01, 0xb3, 0x2d, 0xa1, 0x6e, 0x9c, 0x78, 0xe7, 0x7f, 0x70, 0xc2, 0xbb, 0x44, 0x87, 0x09, 0xcc,
	0xf9, 0xcc, 0x82, 0x65, 0x0f, 0x49, 0x92, 0xf4, 0x4e, 0x24, 0xb8, 0xb2, 0xf3, 0x0d, 0x9a, 0xe2,
	0xc5, 0xaa, 0xf4, 0xd5, 0x17, 0x2b, 0xfb, 0x03, 0x98, 0x91, 0xe8, 0xcf, 0x34, 0xb0, 0xbd, 0x1a,
	0x23, 0xb5, 0xbc, 0xb3, 0x0a, 0x2b, 0x23, 0x91, 0xe8, 0xf9, 0xfa, 0xe7, 0x12, 0x5c, 0xb9, 0xeb,
	0xfb, 0xfb, 0x48, 0x68, 0xe7, 0xe8, 0x2e, 0xe7, 0x34, 0x68, 0xa7, 0x1c, 0x4d, 0xa0, 0x9f, 0xc2,
	0x25, 0x26, 0x39, 0x2d, 0x62, 0x58, 0x3a, 0xc5, 0xfb, 0xe7, 0x42, 0x91, 0x33, 0x2d, 0xbb, 0x23,
	0x64, 0x05, 0x21, 0x8b, 0x6c, 0x98, 0x6a, 0x7f, 0x17, 0xaa, 0x0c, 0x3b, 0x29, 0x95, 0xcb, 0x85,
	0x1c, 0x22, 0x0a, 0x0b, 0x17, 0x0c, 0x55, 0x02, 0x67, 0xfd, 0x18, 0x96, 0x8b, 0xec, 0x0d, 0xa2,
	0x4d, 0x45, 0xa1, 0xcd, 0x8f, 0x06, 0xd1, 0xa6, 0xba, 0x79, 0x6b, 0x38, 0x81, 0xd9, 0x1a, 0xd4,
	0x8c, 0x7c, 0x7c, 0x82, 0xfe, 0x81, 0x10, 0x7d, 0x78, 0x92, 0xe0, 0x20, 0xba, 0x5c, 0x83, 0x7a,
	0x51, 0x58, 0x3a, 0x9f, 0x35, 0xb8, 0x6c, 0x56, 0xdf, 0x6d, 0x75, 0x9c, 0x75, 0xc4, 0xce, 0x17,
	0x25, 0x58, 0x1d, 0x63, 0xe9, 0x5e, 0xfe, 0x15, 0x2c, 0xb1, 0x34, 0x49, 0x62, 0xca, 0xd1, 0x6f,
	0x75, 0x7a, 0x81, 0xac, 0xb1, 0x4a, 0xb4, 0x77, 0xae, 0x44, 0x9f, 0x61, 0xd8, 0xdd, 0x37, 0x56,
	0xb7, 0x95, 0x51, 0x95, 0xe7, 0x4b, 0x6c, 0x84, 0xac, 0x12, 0x2d, 0xac, 0x67, 0x8b, 0x45, 0x96,
	0x68, 0x41, 0x35, 0x6b, 0xc5, 0x23, 0x58, 0x0c, 0x51, 0xac, 0xe7, 0xec, 0x28, 0x48, 0xe4, 0xb9,
	0x9f, 0x38, 0x62, 0x35, 0xa0, 0x09, 0x07, 0xf7, 0x32, 0x35, 0xb5, 0x71, 0x87, 0x43, 0xef, 0xf5,
	0x6d, 0x58, 0x29, 0x74, 0xb5, 0xa0, 0x84, 0xcb, 0x83, 0x25, 0xac, 0x0c, 0x56, 0xe6, 0x4f, 0x25,
	0x58, 0x51, 0xb8, 0x31, 0x8a, 0x54, 0x3b, 0x70, 0x81, 0x9f, 0x24, 0xea, 0xac, 0x56, 0x37, 0xef,
	0x4c, 0xde, 0x81, 0xef, 0x21, 0xf1, 0xef, 0x23, 0xe7, 0x48, 0x3f, 0x49, 0x51, 0xd7, 0x5f, 0xaa,
	0x4f, 0xba, 0x6b, 0x89, 0x04, 0xc6, 0x29, 0x15, 0xd7, 0x11, 0x15, 0xb4, 0x06, 0xf5, 0x05, 0x45,
	0xd5, 0x75, 0xb1, 0xdf, 0x87, 0x5a, 0x10, 0x09, 0x89, 0xa0, 0x8f, 0x2d, 0xb1, 0xcd, 0x0d, 0xcc,
	0x0c, 0xb5, 0x1a, 0xae, 0x64, 0xfc, 0x9d, 0x68, 0x60, 0x64, 0x14, 0x2e, 0x74, 0xd3, 0xe7, 0x5e,
	0xe8, 0x66, 0x8a, 0x16, 0xba, 0x7f, 0x59, 0x70, 0x79, 0x34, 0x5f, 0xba, 0x21, 0xbf, 0xa6, 0x84,
	0x15, 0x62, 0x74, 0xe9, 0x6b, 0xc4, 0xe8, 0xa2, 0x58, 0xcb, 0x45, 0xb1, 0xfe, 0xdd, 0x82, 0xd5,
	0x07, 0x29, 0xed, 0xe2, 0xb7, 0xb1, 0x3b, 0x9c, 0x3a, 0xd4, 0xc6, 0x83, 0xcb, 0x11, 0x7e, 0x75,
	0x0f, 0xbf, 0xa5, 0x91, 0xff, 0x5f, 0xce, 0xc5, 0x16, 0xd4, 0xc6, 0x13, 0xf6, 0x7a, 0xf7, 0x1a,
	0xe7, 0x37, 0x16, 0x5c, 0xf5, 0xf0, 0x90, 0x22, 0x3b, 0x32, 0xa3, 0x5d, 0x36, 0xec, 0x37, 0xfc,
	0x7f, 0xad, 0x01, 0xd7, 0x8a, 0xbd, 0xc8, 0x9b, 0xe3, 0x0d, 0x0f, 0x19, 0x46, 0xfe, 0xc8, 0x51,
	0x63, 0x03, 0xbf, 0xa0, 0xf2, 0x5f, 0x2d, 0xd9, 0xff, 0xb7, 0xb9, 0x8c, 0xd6, 0xf4, 0xed, 0xeb,
	0x30, 0x97, 0x2d, 0x3c, 0xba, 0x03, 0x2a, 0x1e, 0x18, 0x52, 0xd3, 0xb7, 0x57, 0x60, 0x86, 0xa6,
	0x91, 0xb9, 0x29, 0x57, 0xbc, 0x69, 0x9a, 0x46, 0xaa, 0x37, 0x28, 0x86, 0x31, 0xcf, 0x7b, 0x43,
	0xfd, 0x5d, 0x59, 0x50, 0x54, 0xd3, 0x1b, 0xe3, 0xf7, 0xed, 0xe9, 0x82, 0xfb, 0xf6, 0x4d, 0x58,
	0x50, 0x52, 0xc3, 0x37, 0x63, 0x25, 0x74, 0xd6, 0x25, 0xfb, 0xe2, 0xd8, 0x25, 0xfb, 0x3a, 0xcc,
	0x09, 0x09, 0x63, 0x64, 0x36, 0x13, 0xd0, 0x26, 0x9c, 0x35, 0x68, 0x9c, 0x95, 0x30, 0x95, 0xd3,
	0xad, 0xde, 0xf3, 0x17, 0x8d, 0xa9, 0xcf, 0x5f, 0x34, 0xa6, 0xbe, 0x7c, 0xd1, 0xb0, 0x7e, 0x7d,
	0xda, 0xb0, 0xfe, 0x78, 0xda, 0xb0, 0x3e, 0x3b, 0x6d, 0x58, 0xcf, 0x4f, 0x1b, 0xd6, 0x3f, 0x4e,
	0x1b, 0xd6, 0x3f, 0x4f, 0x1b, 0x53, 0x5f, 0x9e, 0x36, 0xac, 0x67, 0x2f, 0x1b, 0x53, 0xcf, 0x5f,
	0x36, 0xa6, 0x3e, 0x7f, 0xd9, 0x98, 0xfa, 0xe9, 0x7b, 0xdd, 0x38, 0xaf, 0x70, 0x10, 0x4f, 0xf8,
	0x39, 0xff, 0xc3, 0xc1, 0xf7, 0xf6, 0x8c, 0xfc, 0xc1, 0xf2, 0xce, 0x7f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0x4c, 0x79, 0x62, 0x54, 0xd7, 0x17, 0x00, 0x00,
}

func (this *DescribeWorkflowExecutionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeWorkflowExecutionRequest)
	if !ok {
		that2, ok := that.(DescribeWorkflowExecutionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *DescribeWorkflowExecutionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeWorkflowExecutionResponse)
	if !ok {
		that2, ok := that.(DescribeWorkflowExecutionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.HistoryAddr != that1.HistoryAddr {
		return false
	}
	if this.CacheMutableState != that1.CacheMutableState {
		return false
	}
	if this.DatabaseMutableState != that1.DatabaseMutableState {
		return false
	}
	if this.TreeId != that1.TreeId {
		return false
	}
	if this.BranchId != that1.BranchId {
		return false
	}
	return true
}
func (this *DescribeHistoryHostRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostRequest)
	if !ok {
		that2, ok := that.(DescribeHistoryHostRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HostAddress != that1.HostAddress {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	return true
}
func (this *DescribeHistoryHostResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeHistoryHostResponse)
	if !ok {
		that2, ok := that.(DescribeHistoryHostResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardsNumber != that1.ShardsNumber {
		return false
	}
	if len(this.ShardIds) != len(that1.ShardIds) {
		return false
	}
	for i := range this.ShardIds {
		if this.ShardIds[i] != that1.ShardIds[i] {
			return false
		}
	}
	if !this.NamespaceCache.Equal(that1.NamespaceCache) {
		return false
	}
	if this.ShardControllerStatus != that1.ShardControllerStatus {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	return true
}
func (this *CloseShardRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardRequest)
	if !ok {
		that2, ok := that.(CloseShardRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	return true
}
func (this *CloseShardResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CloseShardResponse)
	if !ok {
		that2, ok := that.(CloseShardResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RemoveTaskRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskRequest)
	if !ok {
		that2, ok := that.(RemoveTaskRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.Category != that1.Category {
		return false
	}
	if this.TaskId != that1.TaskId {
		return false
	}
	if that1.VisibilityTime == nil {
		if this.VisibilityTime != nil {
			return false
		}
	} else if !this.VisibilityTime.Equal(*that1.VisibilityTime) {
		return false
	}
	return true
}
func (this *RemoveTaskResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RemoveTaskResponse)
	if !ok {
		that2, ok := that.(RemoveTaskResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GetWorkflowExecutionRawHistoryV2Request) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetWorkflowExecutionRawHistoryV2Request)
	if !ok {
		that2, ok := that.(GetWorkflowExecutionRawHistoryV2Request)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	if this.StartEventId != that1.StartEventId {
		return false
	}
	if this.StartEventVersion != that1.StartEventVersion {
		return false
	}
	if this.EndEventId != that1.EndEventId {
		return false
	}
	if this.EndEventVersion != that1.EndEventVersion {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetWorkflowExecutionRawHistoryV2Response) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetWorkflowExecutionRawHistoryV2Response)
	if !ok {
		that2, ok := that.(GetWorkflowExecutionRawHistoryV2Response)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	if len(this.HistoryBatches) != len(that1.HistoryBatches) {
		return false
	}
	for i := range this.HistoryBatches {
		if !this.HistoryBatches[i].Equal(that1.HistoryBatches[i]) {
			return false
		}
	}
	if !this.VersionHistory.Equal(that1.VersionHistory) {
		return false
	}
	return true
}
func (this *GetReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Tokens) != len(that1.Tokens) {
		return false
	}
	for i := range this.Tokens {
		if !this.Tokens[i].Equal(that1.Tokens[i]) {
			return false
		}
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GetReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ShardMessages) != len(that1.ShardMessages) {
		return false
	}
	for i := range this.ShardMessages {
		if !this.ShardMessages[i].Equal(that1.ShardMessages[i]) {
			return false
		}
	}
	return true
}
func (this *GetNamespaceReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetNamespaceReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetNamespaceReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.LastRetrievedMessageId != that1.LastRetrievedMessageId {
		return false
	}
	if this.LastProcessedMessageId != that1.LastProcessedMessageId {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GetNamespaceReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetNamespaceReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetNamespaceReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Messages.Equal(that1.Messages) {
		return false
	}
	return true
}
func (this *GetDLQReplicationMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return false
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(that1.TaskInfos[i]) {
			return false
		}
	}
	return true
}
func (this *GetDLQReplicationMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQReplicationMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQReplicationMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	return true
}
func (this *ReapplyEventsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsRequest)
	if !ok {
		that2, ok := that.(ReapplyEventsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.WorkflowExecution.Equal(that1.WorkflowExecution) {
		return false
	}
	if !this.Events.Equal(that1.Events) {
		return false
	}
	return true
}
func (this *ReapplyEventsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReapplyEventsResponse)
	if !ok {
		that2, ok := that.(ReapplyEventsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *AddSearchAttributeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSearchAttributeRequest)
	if !ok {
		that2, ok := that.(AddSearchAttributeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.SearchAttribute) != len(that1.SearchAttribute) {
		return false
	}
	for i := range this.SearchAttribute {
		if this.SearchAttribute[i] != that1.SearchAttribute[i] {
			return false
		}
	}
	if this.SecurityToken != that1.SecurityToken {
		return false
	}
	return true
}
func (this *AddSearchAttributeResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSearchAttributeResponse)
	if !ok {
		that2, ok := that.(AddSearchAttributeResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeClusterRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeClusterRequest)
	if !ok {
		that2, ok := that.(DescribeClusterRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeClusterResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DescribeClusterResponse)
	if !ok {
		that2, ok := that.(DescribeClusterResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.SupportedClients) != len(that1.SupportedClients) {
		return false
	}
	for i := range this.SupportedClients {
		if this.SupportedClients[i] != that1.SupportedClients[i] {
			return false
		}
	}
	if this.ServerVersion != that1.ServerVersion {
		return false
	}
	if !this.MembershipInfo.Equal(that1.MembershipInfo) {
		return false
	}
	return true
}
func (this *GetDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesRequest)
	if !ok {
		that2, ok := that.(GetDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *GetDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetDLQMessagesResponse)
	if !ok {
		that2, ok := that.(GetDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if len(this.ReplicationTasks) != len(that1.ReplicationTasks) {
		return false
	}
	for i := range this.ReplicationTasks {
		if !this.ReplicationTasks[i].Equal(that1.ReplicationTasks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	return true
}
func (this *PurgeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PurgeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(PurgeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *MergeDLQMessagesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesRequest)
	if !ok {
		that2, ok := that.(MergeDLQMessagesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.ShardId != that1.ShardId {
		return false
	}
	if this.SourceCluster != that1.SourceCluster {
		return false
	}
	if this.InclusiveEndMessageId != that1.InclusiveEndMessageId {
		return false
	}
	if this.MaximumPageSize != that1.MaximumPageSize {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *MergeDLQMessagesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeDLQMessagesResponse)
	if !ok {
		that2, ok := that.(MergeDLQMessagesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.NextPageToken, that1.NextPageToken) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksRequest)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Namespace != that1.Namespace {
		return false
	}
	if !this.Execution.Equal(that1.Execution) {
		return false
	}
	return true
}
func (this *RefreshWorkflowTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshWorkflowTasksResponse)
	if !ok {
		that2, ok := that.(RefreshWorkflowTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ResendReplicationTasksRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResendReplicationTasksRequest)
	if !ok {
		that2, ok := that.(ResendReplicationTasksRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NamespaceId != that1.NamespaceId {
		return false
	}
	if this.WorkflowId != that1.WorkflowId {
		return false
	}
	if this.RunId != that1.RunId {
		return false
	}
	if this.RemoteCluster != that1.RemoteCluster {
		return false
	}
	if this.StartEventId != that1.StartEventId {
		return false
	}
	if this.StartVersion != that1.StartVersion {
		return false
	}
	if this.EndEventId != that1.EndEventId {
		return false
	}
	if this.EndVersion != that1.EndVersion {
		return false
	}
	return true
}
func (this *ResendReplicationTasksResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResendReplicationTasksResponse)
	if !ok {
		that2, ok := that.(ResendReplicationTasksResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *DescribeWorkflowExecutionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.DescribeWorkflowExecutionRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeWorkflowExecutionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.DescribeWorkflowExecutionResponse{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "HistoryAddr: "+fmt.Sprintf("%#v", this.HistoryAddr)+",\n")
	s = append(s, "CacheMutableState: "+fmt.Sprintf("%#v", this.CacheMutableState)+",\n")
	s = append(s, "DatabaseMutableState: "+fmt.Sprintf("%#v", this.DatabaseMutableState)+",\n")
	s = append(s, "TreeId: "+fmt.Sprintf("%#v", this.TreeId)+",\n")
	s = append(s, "BranchId: "+fmt.Sprintf("%#v", this.BranchId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.DescribeHistoryHostRequest{")
	s = append(s, "HostAddress: "+fmt.Sprintf("%#v", this.HostAddress)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeHistoryHostResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&adminservice.DescribeHistoryHostResponse{")
	s = append(s, "ShardsNumber: "+fmt.Sprintf("%#v", this.ShardsNumber)+",\n")
	s = append(s, "ShardIds: "+fmt.Sprintf("%#v", this.ShardIds)+",\n")
	if this.NamespaceCache != nil {
		s = append(s, "NamespaceCache: "+fmt.Sprintf("%#v", this.NamespaceCache)+",\n")
	}
	s = append(s, "ShardControllerStatus: "+fmt.Sprintf("%#v", this.ShardControllerStatus)+",\n")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.CloseShardRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CloseShardResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.CloseShardResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.RemoveTaskRequest{")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "Category: "+fmt.Sprintf("%#v", this.Category)+",\n")
	s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	s = append(s, "VisibilityTime: "+fmt.Sprintf("%#v", this.VisibilityTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RemoveTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetWorkflowExecutionRawHistoryV2Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&adminservice.GetWorkflowExecutionRawHistoryV2Request{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "StartEventId: "+fmt.Sprintf("%#v", this.StartEventId)+",\n")
	s = append(s, "StartEventVersion: "+fmt.Sprintf("%#v", this.StartEventVersion)+",\n")
	s = append(s, "EndEventId: "+fmt.Sprintf("%#v", this.EndEventId)+",\n")
	s = append(s, "EndEventVersion: "+fmt.Sprintf("%#v", this.EndEventVersion)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetWorkflowExecutionRawHistoryV2Response) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetWorkflowExecutionRawHistoryV2Response{")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	if this.HistoryBatches != nil {
		s = append(s, "HistoryBatches: "+fmt.Sprintf("%#v", this.HistoryBatches)+",\n")
	}
	if this.VersionHistory != nil {
		s = append(s, "VersionHistory: "+fmt.Sprintf("%#v", this.VersionHistory)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.GetReplicationMessagesRequest{")
	if this.Tokens != nil {
		s = append(s, "Tokens: "+fmt.Sprintf("%#v", this.Tokens)+",\n")
	}
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetReplicationMessagesResponse{")
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v14.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%#v: %#v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	if this.ShardMessages != nil {
		s = append(s, "ShardMessages: "+mapStringForShardMessages+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNamespaceReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetNamespaceReplicationMessagesRequest{")
	s = append(s, "LastRetrievedMessageId: "+fmt.Sprintf("%#v", this.LastRetrievedMessageId)+",\n")
	s = append(s, "LastProcessedMessageId: "+fmt.Sprintf("%#v", this.LastProcessedMessageId)+",\n")
	s = append(s, "ClusterName: "+fmt.Sprintf("%#v", this.ClusterName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNamespaceReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetNamespaceReplicationMessagesResponse{")
	if this.Messages != nil {
		s = append(s, "Messages: "+fmt.Sprintf("%#v", this.Messages)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetDLQReplicationMessagesRequest{")
	if this.TaskInfos != nil {
		s = append(s, "TaskInfos: "+fmt.Sprintf("%#v", this.TaskInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQReplicationMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.GetDLQReplicationMessagesResponse{")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.ReapplyEventsRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.WorkflowExecution != nil {
		s = append(s, "WorkflowExecution: "+fmt.Sprintf("%#v", this.WorkflowExecution)+",\n")
	}
	if this.Events != nil {
		s = append(s, "Events: "+fmt.Sprintf("%#v", this.Events)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ReapplyEventsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.ReapplyEventsResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddSearchAttributeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.AddSearchAttributeRequest{")
	keysForSearchAttribute := make([]string, 0, len(this.SearchAttribute))
	for k, _ := range this.SearchAttribute {
		keysForSearchAttribute = append(keysForSearchAttribute, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttribute)
	mapStringForSearchAttribute := "map[string]v15.IndexedValueType{"
	for _, k := range keysForSearchAttribute {
		mapStringForSearchAttribute += fmt.Sprintf("%#v: %#v,", k, this.SearchAttribute[k])
	}
	mapStringForSearchAttribute += "}"
	if this.SearchAttribute != nil {
		s = append(s, "SearchAttribute: "+mapStringForSearchAttribute+",\n")
	}
	s = append(s, "SecurityToken: "+fmt.Sprintf("%#v", this.SecurityToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AddSearchAttributeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.AddSearchAttributeResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeClusterRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.DescribeClusterRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DescribeClusterResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.DescribeClusterResponse{")
	keysForSupportedClients := make([]string, 0, len(this.SupportedClients))
	for k, _ := range this.SupportedClients {
		keysForSupportedClients = append(keysForSupportedClients, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSupportedClients)
	mapStringForSupportedClients := "map[string]string{"
	for _, k := range keysForSupportedClients {
		mapStringForSupportedClients += fmt.Sprintf("%#v: %#v,", k, this.SupportedClients[k])
	}
	mapStringForSupportedClients += "}"
	if this.SupportedClients != nil {
		s = append(s, "SupportedClients: "+mapStringForSupportedClients+",\n")
	}
	s = append(s, "ServerVersion: "+fmt.Sprintf("%#v", this.ServerVersion)+",\n")
	if this.MembershipInfo != nil {
		s = append(s, "MembershipInfo: "+fmt.Sprintf("%#v", this.MembershipInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.GetDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&adminservice.GetDLQMessagesResponse{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ReplicationTasks != nil {
		s = append(s, "ReplicationTasks: "+fmt.Sprintf("%#v", this.ReplicationTasks)+",\n")
	}
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&adminservice.PurgeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PurgeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.PurgeDLQMessagesResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&adminservice.MergeDLQMessagesRequest{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ShardId: "+fmt.Sprintf("%#v", this.ShardId)+",\n")
	s = append(s, "SourceCluster: "+fmt.Sprintf("%#v", this.SourceCluster)+",\n")
	s = append(s, "InclusiveEndMessageId: "+fmt.Sprintf("%#v", this.InclusiveEndMessageId)+",\n")
	s = append(s, "MaximumPageSize: "+fmt.Sprintf("%#v", this.MaximumPageSize)+",\n")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MergeDLQMessagesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&adminservice.MergeDLQMessagesResponse{")
	s = append(s, "NextPageToken: "+fmt.Sprintf("%#v", this.NextPageToken)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&adminservice.RefreshWorkflowTasksRequest{")
	s = append(s, "Namespace: "+fmt.Sprintf("%#v", this.Namespace)+",\n")
	if this.Execution != nil {
		s = append(s, "Execution: "+fmt.Sprintf("%#v", this.Execution)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RefreshWorkflowTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.RefreshWorkflowTasksResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResendReplicationTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&adminservice.ResendReplicationTasksRequest{")
	s = append(s, "NamespaceId: "+fmt.Sprintf("%#v", this.NamespaceId)+",\n")
	s = append(s, "WorkflowId: "+fmt.Sprintf("%#v", this.WorkflowId)+",\n")
	s = append(s, "RunId: "+fmt.Sprintf("%#v", this.RunId)+",\n")
	s = append(s, "RemoteCluster: "+fmt.Sprintf("%#v", this.RemoteCluster)+",\n")
	s = append(s, "StartEventId: "+fmt.Sprintf("%#v", this.StartEventId)+",\n")
	s = append(s, "StartVersion: "+fmt.Sprintf("%#v", this.StartVersion)+",\n")
	s = append(s, "EndEventId: "+fmt.Sprintf("%#v", this.EndEventId)+",\n")
	s = append(s, "EndVersion: "+fmt.Sprintf("%#v", this.EndVersion)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResendReplicationTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&adminservice.ResendReplicationTasksResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringRequestResponse(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *DescribeWorkflowExecutionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeWorkflowExecutionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeWorkflowExecutionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeWorkflowExecutionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeWorkflowExecutionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeWorkflowExecutionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.BranchId) > 0 {
		i -= len(m.BranchId)
		copy(dAtA[i:], m.BranchId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.BranchId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.TreeId) > 0 {
		i -= len(m.TreeId)
		copy(dAtA[i:], m.TreeId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.TreeId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.DatabaseMutableState) > 0 {
		i -= len(m.DatabaseMutableState)
		copy(dAtA[i:], m.DatabaseMutableState)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.DatabaseMutableState)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.CacheMutableState) > 0 {
		i -= len(m.CacheMutableState)
		copy(dAtA[i:], m.CacheMutableState)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.CacheMutableState)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HistoryAddr) > 0 {
		i -= len(m.HistoryAddr)
		copy(dAtA[i:], m.HistoryAddr)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HistoryAddr)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ShardId) > 0 {
		i -= len(m.ShardId)
		copy(dAtA[i:], m.ShardId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ShardId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.HostAddress) > 0 {
		i -= len(m.HostAddress)
		copy(dAtA[i:], m.HostAddress)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.HostAddress)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DescribeHistoryHostResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeHistoryHostResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeHistoryHostResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ShardControllerStatus) > 0 {
		i -= len(m.ShardControllerStatus)
		copy(dAtA[i:], m.ShardControllerStatus)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ShardControllerStatus)))
		i--
		dAtA[i] = 0x22
	}
	if m.NamespaceCache != nil {
		{
			size, err := m.NamespaceCache.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ShardIds) > 0 {
		dAtA5 := make([]byte, len(m.ShardIds)*10)
		var j4 int
		for _, num1 := range m.ShardIds {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		i -= j4
		copy(dAtA[i:], dAtA5[:j4])
		i = encodeVarintRequestResponse(dAtA, i, uint64(j4))
		i--
		dAtA[i] = 0x12
	}
	if m.ShardsNumber != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardsNumber))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CloseShardResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseShardResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseShardResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *RemoveTaskRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VisibilityTime != nil {
		n6, err6 := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.VisibilityTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime):])
		if err6 != nil {
			return 0, err6
		}
		i -= n6
		i = encodeVarintRequestResponse(dAtA, i, uint64(n6))
		i--
		dAtA[i] = 0x22
	}
	if m.TaskId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x18
	}
	if m.Category != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Category))
		i--
		dAtA[i] = 0x10
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RemoveTaskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveTaskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveTaskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkflowExecutionRawHistoryV2Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkflowExecutionRawHistoryV2Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x42
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x38
	}
	if m.EndEventVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.EndEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventId))
		i--
		dAtA[i] = 0x28
	}
	if m.StartEventVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.StartEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventId))
		i--
		dAtA[i] = 0x18
	}
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkflowExecutionRawHistoryV2Response) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkflowExecutionRawHistoryV2Response) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.VersionHistory != nil {
		{
			size, err := m.VersionHistory.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.HistoryBatches) > 0 {
		for iNdEx := len(m.HistoryBatches) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HistoryBatches[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Tokens) > 0 {
		for iNdEx := len(m.Tokens) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tokens[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k := range m.ShardMessages {
			v := m.ShardMessages[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintRequestResponse(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintRequestResponse(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespaceReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespaceReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespaceReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LastProcessedMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastProcessedMessageId))
		i--
		dAtA[i] = 0x10
	}
	if m.LastRetrievedMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.LastRetrievedMessageId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespaceReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespaceReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespaceReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Messages != nil {
		{
			size, err := m.Messages.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for iNdEx := len(m.TaskInfos) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TaskInfos[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQReplicationMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQReplicationMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQReplicationMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Events != nil {
		{
			size, err := m.Events.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.WorkflowExecution != nil {
		{
			size, err := m.WorkflowExecution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReapplyEventsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReapplyEventsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReapplyEventsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *AddSearchAttributeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSearchAttributeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSearchAttributeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SecurityToken) > 0 {
		i -= len(m.SecurityToken)
		copy(dAtA[i:], m.SecurityToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SecurityToken)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SearchAttribute) > 0 {
		for k := range m.SearchAttribute {
			v := m.SearchAttribute[k]
			baseI := i
			i = encodeVarintRequestResponse(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AddSearchAttributeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSearchAttributeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSearchAttributeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DescribeClusterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeClusterRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeClusterRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *DescribeClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescribeClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DescribeClusterResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MembershipInfo != nil {
		{
			size, err := m.MembershipInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ServerVersion) > 0 {
		i -= len(m.ServerVersion)
		copy(dAtA[i:], m.ServerVersion)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.ServerVersion)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.SupportedClients) > 0 {
		for k := range m.SupportedClients {
			v := m.SupportedClients[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRequestResponse(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRequestResponse(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ReplicationTasks) > 0 {
		for iNdEx := len(m.ReplicationTasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReplicationTasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRequestResponse(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaximumPageSize != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.MaximumPageSize))
		i--
		dAtA[i] = 0x28
	}
	if m.InclusiveEndMessageId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.InclusiveEndMessageId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.SourceCluster) > 0 {
		i -= len(m.SourceCluster)
		copy(dAtA[i:], m.SourceCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.SourceCluster)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ShardId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.ShardId))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MergeDLQMessagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeDLQMessagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeDLQMessagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NextPageToken) > 0 {
		i -= len(m.NextPageToken)
		copy(dAtA[i:], m.NextPageToken)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NextPageToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Execution != nil {
		{
			size, err := m.Execution.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRequestResponse(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RefreshWorkflowTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshWorkflowTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RefreshWorkflowTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ResendReplicationTasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResendReplicationTasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResendReplicationTasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.EndVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndVersion))
		i--
		dAtA[i] = 0x40
	}
	if m.EndEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.EndEventId))
		i--
		dAtA[i] = 0x38
	}
	if m.StartVersion != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x30
	}
	if m.StartEventId != 0 {
		i = encodeVarintRequestResponse(dAtA, i, uint64(m.StartEventId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.RemoteCluster) > 0 {
		i -= len(m.RemoteCluster)
		copy(dAtA[i:], m.RemoteCluster)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RemoteCluster)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RunId) > 0 {
		i -= len(m.RunId)
		copy(dAtA[i:], m.RunId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.RunId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.WorkflowId) > 0 {
		i -= len(m.WorkflowId)
		copy(dAtA[i:], m.WorkflowId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.WorkflowId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.NamespaceId) > 0 {
		i -= len(m.NamespaceId)
		copy(dAtA[i:], m.NamespaceId)
		i = encodeVarintRequestResponse(dAtA, i, uint64(len(m.NamespaceId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResendReplicationTasksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResendReplicationTasksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResendReplicationTasksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func encodeVarintRequestResponse(dAtA []byte, offset int, v uint64) int {
	offset -= sovRequestResponse(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DescribeWorkflowExecutionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeWorkflowExecutionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ShardId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.HistoryAddr)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.CacheMutableState)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.DatabaseMutableState)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.TreeId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.BranchId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostAddress)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *DescribeHistoryHostResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardsNumber != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardsNumber))
	}
	if len(m.ShardIds) > 0 {
		l = 0
		for _, e := range m.ShardIds {
			l += sovRequestResponse(uint64(e))
		}
		n += 1 + sovRequestResponse(uint64(l)) + l
	}
	if m.NamespaceCache != nil {
		l = m.NamespaceCache.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.ShardControllerStatus)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *CloseShardRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	return n
}

func (m *CloseShardResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RemoveTaskRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	if m.Category != 0 {
		n += 1 + sovRequestResponse(uint64(m.Category))
	}
	if m.TaskId != 0 {
		n += 1 + sovRequestResponse(uint64(m.TaskId))
	}
	if m.VisibilityTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.VisibilityTime)
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RemoveTaskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetWorkflowExecutionRawHistoryV2Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventId))
	}
	if m.StartEventVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventVersion))
	}
	if m.EndEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventId))
	}
	if m.EndEventVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventVersion))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetWorkflowExecutionRawHistoryV2Response) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if len(m.HistoryBatches) > 0 {
		for _, e := range m.HistoryBatches {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	if m.VersionHistory != nil {
		l = m.VersionHistory.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tokens) > 0 {
		for _, e := range m.Tokens {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ShardMessages) > 0 {
		for k, v := range m.ShardMessages {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRequestResponse(uint64(l))
			}
			mapEntrySize := 1 + sovRequestResponse(uint64(k)) + l
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *GetNamespaceReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastRetrievedMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastRetrievedMessageId))
	}
	if m.LastProcessedMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.LastProcessedMessageId))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetNamespaceReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Messages != nil {
		l = m.Messages.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQReplicationMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for _, e := range m.TaskInfos {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *GetDLQReplicationMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	return n
}

func (m *ReapplyEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.WorkflowExecution != nil {
		l = m.WorkflowExecution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Events != nil {
		l = m.Events.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *ReapplyEventsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *AddSearchAttributeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SearchAttribute) > 0 {
		for k, v := range m.SearchAttribute {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + sovRequestResponse(uint64(v))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	l = len(m.SecurityToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *AddSearchAttributeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DescribeClusterRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *DescribeClusterResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SupportedClients) > 0 {
		for k, v := range m.SupportedClients {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRequestResponse(uint64(len(k))) + 1 + len(v) + sovRequestResponse(uint64(len(v)))
			n += mapEntrySize + 1 + sovRequestResponse(uint64(mapEntrySize))
		}
	}
	l = len(m.ServerVersion)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.MembershipInfo != nil {
		l = m.MembershipInfo.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *GetDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if len(m.ReplicationTasks) > 0 {
		for _, e := range m.ReplicationTasks {
			l = e.Size()
			n += 1 + l + sovRequestResponse(uint64(l))
		}
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *PurgeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	return n
}

func (m *PurgeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *MergeDLQMessagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRequestResponse(uint64(m.Type))
	}
	if m.ShardId != 0 {
		n += 1 + sovRequestResponse(uint64(m.ShardId))
	}
	l = len(m.SourceCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.InclusiveEndMessageId != 0 {
		n += 1 + sovRequestResponse(uint64(m.InclusiveEndMessageId))
	}
	if m.MaximumPageSize != 0 {
		n += 1 + sovRequestResponse(uint64(m.MaximumPageSize))
	}
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *MergeDLQMessagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NextPageToken)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.Execution != nil {
		l = m.Execution.Size()
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	return n
}

func (m *RefreshWorkflowTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ResendReplicationTasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamespaceId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.WorkflowId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RunId)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	l = len(m.RemoteCluster)
	if l > 0 {
		n += 1 + l + sovRequestResponse(uint64(l))
	}
	if m.StartEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartEventId))
	}
	if m.StartVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.StartVersion))
	}
	if m.EndEventId != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndEventId))
	}
	if m.EndVersion != 0 {
		n += 1 + sovRequestResponse(uint64(m.EndVersion))
	}
	return n
}

func (m *ResendReplicationTasksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovRequestResponse(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRequestResponse(x uint64) (n int) {
	return sovRequestResponse(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *DescribeWorkflowExecutionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeWorkflowExecutionRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeWorkflowExecutionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeWorkflowExecutionResponse{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`HistoryAddr:` + fmt.Sprintf("%v", this.HistoryAddr) + `,`,
		`CacheMutableState:` + fmt.Sprintf("%v", this.CacheMutableState) + `,`,
		`DatabaseMutableState:` + fmt.Sprintf("%v", this.DatabaseMutableState) + `,`,
		`TreeId:` + fmt.Sprintf("%v", this.TreeId) + `,`,
		`BranchId:` + fmt.Sprintf("%v", this.BranchId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostRequest{`,
		`HostAddress:` + fmt.Sprintf("%v", this.HostAddress) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DescribeHistoryHostResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeHistoryHostResponse{`,
		`ShardsNumber:` + fmt.Sprintf("%v", this.ShardsNumber) + `,`,
		`ShardIds:` + fmt.Sprintf("%v", this.ShardIds) + `,`,
		`NamespaceCache:` + strings.Replace(fmt.Sprintf("%v", this.NamespaceCache), "NamespaceCacheInfo", "v11.NamespaceCacheInfo", 1) + `,`,
		`ShardControllerStatus:` + fmt.Sprintf("%v", this.ShardControllerStatus) + `,`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseShardResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseShardResponse{`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskRequest{`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`Category:` + fmt.Sprintf("%v", this.Category) + `,`,
		`TaskId:` + fmt.Sprintf("%v", this.TaskId) + `,`,
		`VisibilityTime:` + strings.Replace(fmt.Sprintf("%v", this.VisibilityTime), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *GetWorkflowExecutionRawHistoryV2Request) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetWorkflowExecutionRawHistoryV2Request{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`StartEventId:` + fmt.Sprintf("%v", this.StartEventId) + `,`,
		`StartEventVersion:` + fmt.Sprintf("%v", this.StartEventVersion) + `,`,
		`EndEventId:` + fmt.Sprintf("%v", this.EndEventId) + `,`,
		`EndEventVersion:` + fmt.Sprintf("%v", this.EndEventVersion) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetWorkflowExecutionRawHistoryV2Response) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHistoryBatches := "[]*DataBlob{"
	for _, f := range this.HistoryBatches {
		repeatedStringForHistoryBatches += strings.Replace(fmt.Sprintf("%v", f), "DataBlob", "v1.DataBlob", 1) + ","
	}
	repeatedStringForHistoryBatches += "}"
	s := strings.Join([]string{`&GetWorkflowExecutionRawHistoryV2Response{`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`HistoryBatches:` + repeatedStringForHistoryBatches + `,`,
		`VersionHistory:` + strings.Replace(fmt.Sprintf("%v", this.VersionHistory), "VersionHistory", "v13.VersionHistory", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTokens := "[]*ReplicationToken{"
	for _, f := range this.Tokens {
		repeatedStringForTokens += strings.Replace(fmt.Sprintf("%v", f), "ReplicationToken", "v14.ReplicationToken", 1) + ","
	}
	repeatedStringForTokens += "}"
	s := strings.Join([]string{`&GetReplicationMessagesRequest{`,
		`Tokens:` + repeatedStringForTokens + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForShardMessages := make([]int32, 0, len(this.ShardMessages))
	for k, _ := range this.ShardMessages {
		keysForShardMessages = append(keysForShardMessages, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForShardMessages)
	mapStringForShardMessages := "map[int32]*v14.ReplicationMessages{"
	for _, k := range keysForShardMessages {
		mapStringForShardMessages += fmt.Sprintf("%v: %v,", k, this.ShardMessages[k])
	}
	mapStringForShardMessages += "}"
	s := strings.Join([]string{`&GetReplicationMessagesResponse{`,
		`ShardMessages:` + mapStringForShardMessages + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNamespaceReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNamespaceReplicationMessagesRequest{`,
		`LastRetrievedMessageId:` + fmt.Sprintf("%v", this.LastRetrievedMessageId) + `,`,
		`LastProcessedMessageId:` + fmt.Sprintf("%v", this.LastProcessedMessageId) + `,`,
		`ClusterName:` + fmt.Sprintf("%v", this.ClusterName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNamespaceReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNamespaceReplicationMessagesResponse{`,
		`Messages:` + strings.Replace(fmt.Sprintf("%v", this.Messages), "ReplicationMessages", "v14.ReplicationMessages", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTaskInfos := "[]*ReplicationTaskInfo{"
	for _, f := range this.TaskInfos {
		repeatedStringForTaskInfos += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTaskInfo", "v14.ReplicationTaskInfo", 1) + ","
	}
	repeatedStringForTaskInfos += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesRequest{`,
		`TaskInfos:` + repeatedStringForTaskInfos + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQReplicationMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v14.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQReplicationMessagesResponse{`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`WorkflowExecution:` + strings.Replace(fmt.Sprintf("%v", this.WorkflowExecution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`Events:` + strings.Replace(fmt.Sprintf("%v", this.Events), "DataBlob", "v1.DataBlob", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReapplyEventsResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReapplyEventsResponse{`,
		`}`,
	}, "")
	return s
}
func (this *AddSearchAttributeRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForSearchAttribute := make([]string, 0, len(this.SearchAttribute))
	for k, _ := range this.SearchAttribute {
		keysForSearchAttribute = append(keysForSearchAttribute, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSearchAttribute)
	mapStringForSearchAttribute := "map[string]v15.IndexedValueType{"
	for _, k := range keysForSearchAttribute {
		mapStringForSearchAttribute += fmt.Sprintf("%v: %v,", k, this.SearchAttribute[k])
	}
	mapStringForSearchAttribute += "}"
	s := strings.Join([]string{`&AddSearchAttributeRequest{`,
		`SearchAttribute:` + mapStringForSearchAttribute + `,`,
		`SecurityToken:` + fmt.Sprintf("%v", this.SecurityToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddSearchAttributeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddSearchAttributeResponse{`,
		`}`,
	}, "")
	return s
}
func (this *DescribeClusterRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DescribeClusterRequest{`,
		`}`,
	}, "")
	return s
}
func (this *DescribeClusterResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForSupportedClients := make([]string, 0, len(this.SupportedClients))
	for k, _ := range this.SupportedClients {
		keysForSupportedClients = append(keysForSupportedClients, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSupportedClients)
	mapStringForSupportedClients := "map[string]string{"
	for _, k := range keysForSupportedClients {
		mapStringForSupportedClients += fmt.Sprintf("%v: %v,", k, this.SupportedClients[k])
	}
	mapStringForSupportedClients += "}"
	s := strings.Join([]string{`&DescribeClusterResponse{`,
		`SupportedClients:` + mapStringForSupportedClients + `,`,
		`ServerVersion:` + fmt.Sprintf("%v", this.ServerVersion) + `,`,
		`MembershipInfo:` + strings.Replace(fmt.Sprintf("%v", this.MembershipInfo), "MembershipInfo", "v16.MembershipInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForReplicationTasks := "[]*ReplicationTask{"
	for _, f := range this.ReplicationTasks {
		repeatedStringForReplicationTasks += strings.Replace(fmt.Sprintf("%v", f), "ReplicationTask", "v14.ReplicationTask", 1) + ","
	}
	repeatedStringForReplicationTasks += "}"
	s := strings.Join([]string{`&GetDLQMessagesResponse{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ReplicationTasks:` + repeatedStringForReplicationTasks + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PurgeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PurgeDLQMessagesResponse{`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesRequest{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ShardId:` + fmt.Sprintf("%v", this.ShardId) + `,`,
		`SourceCluster:` + fmt.Sprintf("%v", this.SourceCluster) + `,`,
		`InclusiveEndMessageId:` + fmt.Sprintf("%v", this.InclusiveEndMessageId) + `,`,
		`MaximumPageSize:` + fmt.Sprintf("%v", this.MaximumPageSize) + `,`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MergeDLQMessagesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MergeDLQMessagesResponse{`,
		`NextPageToken:` + fmt.Sprintf("%v", this.NextPageToken) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksRequest{`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`Execution:` + strings.Replace(fmt.Sprintf("%v", this.Execution), "WorkflowExecution", "v1.WorkflowExecution", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RefreshWorkflowTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RefreshWorkflowTasksResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ResendReplicationTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResendReplicationTasksRequest{`,
		`NamespaceId:` + fmt.Sprintf("%v", this.NamespaceId) + `,`,
		`WorkflowId:` + fmt.Sprintf("%v", this.WorkflowId) + `,`,
		`RunId:` + fmt.Sprintf("%v", this.RunId) + `,`,
		`RemoteCluster:` + fmt.Sprintf("%v", this.RemoteCluster) + `,`,
		`StartEventId:` + fmt.Sprintf("%v", this.StartEventId) + `,`,
		`StartVersion:` + fmt.Sprintf("%v", this.StartVersion) + `,`,
		`EndEventId:` + fmt.Sprintf("%v", this.EndEventId) + `,`,
		`EndVersion:` + fmt.Sprintf("%v", this.EndVersion) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResendReplicationTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResendReplicationTasksResponse{`,
		`}`,
	}, "")
	return s
}
func valueToStringRequestResponse(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *DescribeWorkflowExecutionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeWorkflowExecutionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeWorkflowExecutionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShardId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheMutableState", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CacheMutableState = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseMutableState", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DatabaseMutableState = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TreeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TreeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BranchId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v1.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeHistoryHostResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeHistoryHostResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardsNumber", wireType)
			}
			m.ShardsNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardsNumber |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ShardIds = append(m.ShardIds, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRequestResponse
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthRequestResponse
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ShardIds) == 0 {
					m.ShardIds = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ShardIds = append(m.ShardIds, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardIds", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceCache", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NamespaceCache == nil {
				m.NamespaceCache = &v11.NamespaceCacheInfo{}
			}
			if err := m.NamespaceCache.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardControllerStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShardControllerStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseShardResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseShardResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseShardResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			m.Category = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Category |= v12.TaskCategory(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VisibilityTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VisibilityTime == nil {
				m.VisibilityTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.VisibilityTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkflowExecutionRawHistoryV2Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventId", wireType)
			}
			m.StartEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventVersion", wireType)
			}
			m.StartEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventId", wireType)
			}
			m.EndEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventVersion", wireType)
			}
			m.EndEventVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkflowExecutionRawHistoryV2Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkflowExecutionRawHistoryV2Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistoryBatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistoryBatches = append(m.HistoryBatches, &v1.DataBlob{})
			if err := m.HistoryBatches[len(m.HistoryBatches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.VersionHistory == nil {
				m.VersionHistory = &v13.VersionHistory{}
			}
			if err := m.VersionHistory.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tokens = append(m.Tokens, &v14.ReplicationToken{})
			if err := m.Tokens[len(m.Tokens)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardMessages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShardMessages == nil {
				m.ShardMessages = make(map[int32]*v14.ReplicationMessages)
			}
			var mapkey int32
			var mapvalue *v14.ReplicationMessages
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v14.ReplicationMessages{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ShardMessages[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespaceReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRetrievedMessageId", wireType)
			}
			m.LastRetrievedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastRetrievedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastProcessedMessageId", wireType)
			}
			m.LastProcessedMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastProcessedMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespaceReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespaceReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Messages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Messages == nil {
				m.Messages = &v14.ReplicationMessages{}
			}
			if err := m.Messages.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskInfos = append(m.TaskInfos, &v14.ReplicationTaskInfo{})
			if err := m.TaskInfos[len(m.TaskInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQReplicationMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQReplicationMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v14.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowExecution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkflowExecution == nil {
				m.WorkflowExecution = &v1.WorkflowExecution{}
			}
			if err := m.WorkflowExecution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Events == nil {
				m.Events = &v1.DataBlob{}
			}
			if err := m.Events.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReapplyEventsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReapplyEventsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReapplyEventsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSearchAttributeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSearchAttributeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSearchAttributeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttribute", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SearchAttribute == nil {
				m.SearchAttribute = make(map[string]v15.IndexedValueType)
			}
			var mapkey string
			var mapvalue v15.IndexedValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v15.IndexedValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SearchAttribute[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecurityToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecurityToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSearchAttributeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSearchAttributeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSearchAttributeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeClusterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeClusterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeClusterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescribeClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescribeClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescribeClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportedClients", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SupportedClients == nil {
				m.SupportedClients = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRequestResponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRequestResponse
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRequestResponse(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRequestResponse
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SupportedClients[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MembershipInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MembershipInfo == nil {
				m.MembershipInfo = &v16.MembershipInfo{}
			}
			if err := m.MembershipInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v12.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v12.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicationTasks = append(m.ReplicationTasks, &v14.ReplicationTask{})
			if err := m.ReplicationTasks[len(m.ReplicationTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v12.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= v12.DeadLetterQueueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardId", wireType)
			}
			m.ShardId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusiveEndMessageId", wireType)
			}
			m.InclusiveEndMessageId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InclusiveEndMessageId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumPageSize", wireType)
			}
			m.MaximumPageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaximumPageSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeDLQMessagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeDLQMessagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextPageToken", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NextPageToken = append(m.NextPageToken[:0], dAtA[iNdEx:postIndex]...)
			if m.NextPageToken == nil {
				m.NextPageToken = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Execution", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Execution == nil {
				m.Execution = &v1.WorkflowExecution{}
			}
			if err := m.Execution.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshWorkflowTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshWorkflowTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResendReplicationTasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResendReplicationTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResendReplicationTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkflowId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WorkflowId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRequestResponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartEventId", wireType)
			}
			m.StartEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndEventId", wireType)
			}
			m.EndEventId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndEventId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResendReplicationTasksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResendReplicationTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResendReplicationTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRequestResponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRequestResponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRequestResponse(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRequestResponse
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRequestResponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRequestResponse
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRequestResponse
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRequestResponse
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRequestResponse        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRequestResponse          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRequestResponse = fmt.Errorf("proto: unexpected end of group")
)
