// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: auth.proto

package proto

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import services "github.com/gravitational/teleport/lib/services"

import time "time"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Operation identifies type of operation
type Operation int32

const (
	// INIT is sent as a first sentinel event
	// on the watch channel
	Operation_INIT Operation = 0
	// PUT identifies created or updated object
	Operation_PUT Operation = 1
	// DELETE identifies deleted object
	Operation_DELETE Operation = 2
)

var Operation_name = map[int32]string{
	0: "INIT",
	1: "PUT",
	2: "DELETE",
}
var Operation_value = map[string]int32{
	"INIT":   0,
	"PUT":    1,
	"DELETE": 2,
}

func (x Operation) String() string {
	return proto.EnumName(Operation_name, int32(x))
}
func (Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{0}
}

// Event returns cluster event
type Event struct {
	// Operation identifies operation
	Type Operation `protobuf:"varint,1,opt,name=Type,proto3,enum=proto.Operation" json:"type,omitempty"`
	// Resource contains the updated resource
	//
	// Types that are valid to be assigned to Resource:
	//	*Event_ResourceHeader
	//	*Event_CertAuthority
	//	*Event_StaticTokens
	//	*Event_ProvisionToken
	//	*Event_ClusterName
	//	*Event_ClusterConfig
	//	*Event_User
	//	*Event_Role
	//	*Event_Namespace
	//	*Event_Server
	//	*Event_ReverseTunnel
	//	*Event_TunnelConnection
	//	*Event_AccessRequest
	Resource             isEvent_Resource `protobuf_oneof:"Resource"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{0}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(dst, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

type isEvent_Resource interface {
	isEvent_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Event_ResourceHeader struct {
	ResourceHeader *services.ResourceHeader `protobuf:"bytes,2,opt,name=ResourceHeader,oneof"`
}
type Event_CertAuthority struct {
	CertAuthority *services.CertAuthorityV2 `protobuf:"bytes,3,opt,name=CertAuthority,oneof"`
}
type Event_StaticTokens struct {
	StaticTokens *services.StaticTokensV2 `protobuf:"bytes,4,opt,name=StaticTokens,oneof"`
}
type Event_ProvisionToken struct {
	ProvisionToken *services.ProvisionTokenV2 `protobuf:"bytes,5,opt,name=ProvisionToken,oneof"`
}
type Event_ClusterName struct {
	ClusterName *services.ClusterNameV2 `protobuf:"bytes,6,opt,name=ClusterName,oneof"`
}
type Event_ClusterConfig struct {
	ClusterConfig *services.ClusterConfigV3 `protobuf:"bytes,7,opt,name=ClusterConfig,oneof"`
}
type Event_User struct {
	User *services.UserV2 `protobuf:"bytes,8,opt,name=User,oneof"`
}
type Event_Role struct {
	Role *services.RoleV3 `protobuf:"bytes,9,opt,name=Role,oneof"`
}
type Event_Namespace struct {
	Namespace *services.Namespace `protobuf:"bytes,10,opt,name=Namespace,oneof"`
}
type Event_Server struct {
	Server *services.ServerV2 `protobuf:"bytes,11,opt,name=Server,oneof"`
}
type Event_ReverseTunnel struct {
	ReverseTunnel *services.ReverseTunnelV2 `protobuf:"bytes,12,opt,name=ReverseTunnel,oneof"`
}
type Event_TunnelConnection struct {
	TunnelConnection *services.TunnelConnectionV2 `protobuf:"bytes,13,opt,name=TunnelConnection,oneof"`
}
type Event_AccessRequest struct {
	AccessRequest *services.AccessRequestV3 `protobuf:"bytes,14,opt,name=AccessRequest,oneof"`
}

func (*Event_ResourceHeader) isEvent_Resource()   {}
func (*Event_CertAuthority) isEvent_Resource()    {}
func (*Event_StaticTokens) isEvent_Resource()     {}
func (*Event_ProvisionToken) isEvent_Resource()   {}
func (*Event_ClusterName) isEvent_Resource()      {}
func (*Event_ClusterConfig) isEvent_Resource()    {}
func (*Event_User) isEvent_Resource()             {}
func (*Event_Role) isEvent_Resource()             {}
func (*Event_Namespace) isEvent_Resource()        {}
func (*Event_Server) isEvent_Resource()           {}
func (*Event_ReverseTunnel) isEvent_Resource()    {}
func (*Event_TunnelConnection) isEvent_Resource() {}
func (*Event_AccessRequest) isEvent_Resource()    {}

func (m *Event) GetResource() isEvent_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *Event) GetType() Operation {
	if m != nil {
		return m.Type
	}
	return Operation_INIT
}

func (m *Event) GetResourceHeader() *services.ResourceHeader {
	if x, ok := m.GetResource().(*Event_ResourceHeader); ok {
		return x.ResourceHeader
	}
	return nil
}

func (m *Event) GetCertAuthority() *services.CertAuthorityV2 {
	if x, ok := m.GetResource().(*Event_CertAuthority); ok {
		return x.CertAuthority
	}
	return nil
}

func (m *Event) GetStaticTokens() *services.StaticTokensV2 {
	if x, ok := m.GetResource().(*Event_StaticTokens); ok {
		return x.StaticTokens
	}
	return nil
}

func (m *Event) GetProvisionToken() *services.ProvisionTokenV2 {
	if x, ok := m.GetResource().(*Event_ProvisionToken); ok {
		return x.ProvisionToken
	}
	return nil
}

func (m *Event) GetClusterName() *services.ClusterNameV2 {
	if x, ok := m.GetResource().(*Event_ClusterName); ok {
		return x.ClusterName
	}
	return nil
}

func (m *Event) GetClusterConfig() *services.ClusterConfigV3 {
	if x, ok := m.GetResource().(*Event_ClusterConfig); ok {
		return x.ClusterConfig
	}
	return nil
}

func (m *Event) GetUser() *services.UserV2 {
	if x, ok := m.GetResource().(*Event_User); ok {
		return x.User
	}
	return nil
}

func (m *Event) GetRole() *services.RoleV3 {
	if x, ok := m.GetResource().(*Event_Role); ok {
		return x.Role
	}
	return nil
}

func (m *Event) GetNamespace() *services.Namespace {
	if x, ok := m.GetResource().(*Event_Namespace); ok {
		return x.Namespace
	}
	return nil
}

func (m *Event) GetServer() *services.ServerV2 {
	if x, ok := m.GetResource().(*Event_Server); ok {
		return x.Server
	}
	return nil
}

func (m *Event) GetReverseTunnel() *services.ReverseTunnelV2 {
	if x, ok := m.GetResource().(*Event_ReverseTunnel); ok {
		return x.ReverseTunnel
	}
	return nil
}

func (m *Event) GetTunnelConnection() *services.TunnelConnectionV2 {
	if x, ok := m.GetResource().(*Event_TunnelConnection); ok {
		return x.TunnelConnection
	}
	return nil
}

func (m *Event) GetAccessRequest() *services.AccessRequestV3 {
	if x, ok := m.GetResource().(*Event_AccessRequest); ok {
		return x.AccessRequest
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Event) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Event_OneofMarshaler, _Event_OneofUnmarshaler, _Event_OneofSizer, []interface{}{
		(*Event_ResourceHeader)(nil),
		(*Event_CertAuthority)(nil),
		(*Event_StaticTokens)(nil),
		(*Event_ProvisionToken)(nil),
		(*Event_ClusterName)(nil),
		(*Event_ClusterConfig)(nil),
		(*Event_User)(nil),
		(*Event_Role)(nil),
		(*Event_Namespace)(nil),
		(*Event_Server)(nil),
		(*Event_ReverseTunnel)(nil),
		(*Event_TunnelConnection)(nil),
		(*Event_AccessRequest)(nil),
	}
}

func _Event_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Event)
	// Resource
	switch x := m.Resource.(type) {
	case *Event_ResourceHeader:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResourceHeader); err != nil {
			return err
		}
	case *Event_CertAuthority:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CertAuthority); err != nil {
			return err
		}
	case *Event_StaticTokens:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StaticTokens); err != nil {
			return err
		}
	case *Event_ProvisionToken:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProvisionToken); err != nil {
			return err
		}
	case *Event_ClusterName:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterName); err != nil {
			return err
		}
	case *Event_ClusterConfig:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterConfig); err != nil {
			return err
		}
	case *Event_User:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.User); err != nil {
			return err
		}
	case *Event_Role:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Role); err != nil {
			return err
		}
	case *Event_Namespace:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Namespace); err != nil {
			return err
		}
	case *Event_Server:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Server); err != nil {
			return err
		}
	case *Event_ReverseTunnel:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReverseTunnel); err != nil {
			return err
		}
	case *Event_TunnelConnection:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TunnelConnection); err != nil {
			return err
		}
	case *Event_AccessRequest:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AccessRequest); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Event.Resource has unexpected type %T", x)
	}
	return nil
}

func _Event_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Event)
	switch tag {
	case 2: // Resource.ResourceHeader
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ResourceHeader)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ResourceHeader{msg}
		return true, err
	case 3: // Resource.CertAuthority
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.CertAuthorityV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_CertAuthority{msg}
		return true, err
	case 4: // Resource.StaticTokens
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.StaticTokensV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_StaticTokens{msg}
		return true, err
	case 5: // Resource.ProvisionToken
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ProvisionTokenV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ProvisionToken{msg}
		return true, err
	case 6: // Resource.ClusterName
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ClusterNameV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ClusterName{msg}
		return true, err
	case 7: // Resource.ClusterConfig
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ClusterConfigV3)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ClusterConfig{msg}
		return true, err
	case 8: // Resource.User
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.UserV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_User{msg}
		return true, err
	case 9: // Resource.Role
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.RoleV3)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_Role{msg}
		return true, err
	case 10: // Resource.Namespace
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.Namespace)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_Namespace{msg}
		return true, err
	case 11: // Resource.Server
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ServerV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_Server{msg}
		return true, err
	case 12: // Resource.ReverseTunnel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.ReverseTunnelV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_ReverseTunnel{msg}
		return true, err
	case 13: // Resource.TunnelConnection
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.TunnelConnectionV2)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_TunnelConnection{msg}
		return true, err
	case 14: // Resource.AccessRequest
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(services.AccessRequestV3)
		err := b.DecodeMessage(msg)
		m.Resource = &Event_AccessRequest{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Event_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Event)
	// Resource
	switch x := m.Resource.(type) {
	case *Event_ResourceHeader:
		s := proto.Size(x.ResourceHeader)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_CertAuthority:
		s := proto.Size(x.CertAuthority)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_StaticTokens:
		s := proto.Size(x.StaticTokens)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ProvisionToken:
		s := proto.Size(x.ProvisionToken)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ClusterName:
		s := proto.Size(x.ClusterName)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ClusterConfig:
		s := proto.Size(x.ClusterConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_User:
		s := proto.Size(x.User)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_Role:
		s := proto.Size(x.Role)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_Namespace:
		s := proto.Size(x.Namespace)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_Server:
		s := proto.Size(x.Server)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_ReverseTunnel:
		s := proto.Size(x.ReverseTunnel)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_TunnelConnection:
		s := proto.Size(x.TunnelConnection)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Event_AccessRequest:
		s := proto.Size(x.AccessRequest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Watch specifies watch parameters
type Watch struct {
	// Kinds specifies object kinds to watch
	Kinds                []WatchKind `protobuf:"bytes,1,rep,name=Kinds" json:"kinds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Watch) Reset()         { *m = Watch{} }
func (m *Watch) String() string { return proto.CompactTextString(m) }
func (*Watch) ProtoMessage()    {}
func (*Watch) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{1}
}
func (m *Watch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Watch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Watch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Watch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Watch.Merge(dst, src)
}
func (m *Watch) XXX_Size() int {
	return m.Size()
}
func (m *Watch) XXX_DiscardUnknown() {
	xxx_messageInfo_Watch.DiscardUnknown(m)
}

var xxx_messageInfo_Watch proto.InternalMessageInfo

func (m *Watch) GetKinds() []WatchKind {
	if m != nil {
		return m.Kinds
	}
	return nil
}

// WatchKind specifies resource kind to watch
type WatchKind struct {
	// Kind is a resource kind to watch
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// LoadSecrets specifies whether to load secrets
	LoadSecrets bool `protobuf:"varint,2,opt,name=LoadSecrets,proto3" json:"load_secrets"`
	// Name is an optional specific resource type to watch,
	// if specified only the events with a specific resource
	// name will be sent
	Name string `protobuf:"bytes,3,opt,name=Name,proto3" json:"name"`
	// Filter is an optional mapping of custom filter parameters.
	// Valid values vary by resource kind.
	Filter               map[string]string `protobuf:"bytes,4,rep,name=Filter" json:"filter,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *WatchKind) Reset()         { *m = WatchKind{} }
func (m *WatchKind) String() string { return proto.CompactTextString(m) }
func (*WatchKind) ProtoMessage()    {}
func (*WatchKind) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{2}
}
func (m *WatchKind) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchKind) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchKind.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *WatchKind) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchKind.Merge(dst, src)
}
func (m *WatchKind) XXX_Size() int {
	return m.Size()
}
func (m *WatchKind) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchKind.DiscardUnknown(m)
}

var xxx_messageInfo_WatchKind proto.InternalMessageInfo

func (m *WatchKind) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *WatchKind) GetLoadSecrets() bool {
	if m != nil {
		return m.LoadSecrets
	}
	return false
}

func (m *WatchKind) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WatchKind) GetFilter() map[string]string {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Set of certificates corresponding to a single public key.
type Certs struct {
	// SSH X509 cert (PEM-encoded).
	SSH []byte `protobuf:"bytes,1,opt,name=SSH,proto3" json:"ssh,omitempty"`
	// TLS X509 cert (PEM-encoded).
	TLS                  []byte   `protobuf:"bytes,2,opt,name=TLS,proto3" json:"tls,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Certs) Reset()         { *m = Certs{} }
func (m *Certs) String() string { return proto.CompactTextString(m) }
func (*Certs) ProtoMessage()    {}
func (*Certs) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{3}
}
func (m *Certs) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Certs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Certs.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Certs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Certs.Merge(dst, src)
}
func (m *Certs) XXX_Size() int {
	return m.Size()
}
func (m *Certs) XXX_DiscardUnknown() {
	xxx_messageInfo_Certs.DiscardUnknown(m)
}

var xxx_messageInfo_Certs proto.InternalMessageInfo

func (m *Certs) GetSSH() []byte {
	if m != nil {
		return m.SSH
	}
	return nil
}

func (m *Certs) GetTLS() []byte {
	if m != nil {
		return m.TLS
	}
	return nil
}

// UserCertRequest specifies certificate-generation parameters
// for a user.
type UserCertsRequest struct {
	// PublicKey is a public key to be signed.
	PublicKey []byte `protobuf:"bytes,1,opt,name=PublicKey,proto3" json:"public_key"`
	// Username of key owner.
	Username string `protobuf:"bytes,2,opt,name=Username,proto3" json:"username"`
	// Expires is a desired time of the expiry of the certificate, could
	// be adjusted based on the permissions
	Expires time.Time `protobuf:"bytes,3,opt,name=Expires,stdtime" json:"expires,omitempty"`
	// Format encodes the desired SSH Certificate format (either old ssh compatibility
	// format to remove some metadata causing trouble with old SSH servers)
	// or standard SSH cert format with custom extensions
	Format string `protobuf:"bytes,4,opt,name=Format,proto3" json:"format,omitempty"`
	// RouteToCluster is an optional cluster name to add to the certificate,
	// so that requests originating with this certificate will be redirected
	// to this cluster
	RouteToCluster string `protobuf:"bytes,5,opt,name=RouteToCluster,proto3" json:"route_to_cluster,omitempty"`
	// AccessRequests is an optional list of request IDs indicating requests whose
	// escalated privileges should be added to the certificate.
	AccessRequests       []string `protobuf:"bytes,6,rep,name=AccessRequests" json:"access_requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserCertsRequest) Reset()         { *m = UserCertsRequest{} }
func (m *UserCertsRequest) String() string { return proto.CompactTextString(m) }
func (*UserCertsRequest) ProtoMessage()    {}
func (*UserCertsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{4}
}
func (m *UserCertsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UserCertsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UserCertsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *UserCertsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserCertsRequest.Merge(dst, src)
}
func (m *UserCertsRequest) XXX_Size() int {
	return m.Size()
}
func (m *UserCertsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UserCertsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UserCertsRequest proto.InternalMessageInfo

func (m *UserCertsRequest) GetPublicKey() []byte {
	if m != nil {
		return m.PublicKey
	}
	return nil
}

func (m *UserCertsRequest) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *UserCertsRequest) GetExpires() time.Time {
	if m != nil {
		return m.Expires
	}
	return time.Time{}
}

func (m *UserCertsRequest) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *UserCertsRequest) GetRouteToCluster() string {
	if m != nil {
		return m.RouteToCluster
	}
	return ""
}

func (m *UserCertsRequest) GetAccessRequests() []string {
	if m != nil {
		return m.AccessRequests
	}
	return nil
}

// GetUserRequest specifies paramters for the GetUser method.
type GetUserRequest struct {
	// Name is the name of the desired user.
	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"name"`
	// WithSecrets specifies whether to load associated secrets.
	WithSecrets          bool     `protobuf:"varint,2,opt,name=WithSecrets,proto3" json:"with_secrets,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetUserRequest) Reset()         { *m = GetUserRequest{} }
func (m *GetUserRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserRequest) ProtoMessage()    {}
func (*GetUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{5}
}
func (m *GetUserRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetUserRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *GetUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUserRequest.Merge(dst, src)
}
func (m *GetUserRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetUserRequest proto.InternalMessageInfo

func (m *GetUserRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetUserRequest) GetWithSecrets() bool {
	if m != nil {
		return m.WithSecrets
	}
	return false
}

// GetUsersRequest specifies parameters for the GetUsers method.
type GetUsersRequest struct {
	// WithSecrets specifies whether to load associated secrets.
	WithSecrets          bool     `protobuf:"varint,1,opt,name=WithSecrets,proto3" json:"with_secrets"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetUsersRequest) Reset()         { *m = GetUsersRequest{} }
func (m *GetUsersRequest) String() string { return proto.CompactTextString(m) }
func (*GetUsersRequest) ProtoMessage()    {}
func (*GetUsersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{6}
}
func (m *GetUsersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetUsersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetUsersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *GetUsersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUsersRequest.Merge(dst, src)
}
func (m *GetUsersRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetUsersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUsersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetUsersRequest proto.InternalMessageInfo

func (m *GetUsersRequest) GetWithSecrets() bool {
	if m != nil {
		return m.WithSecrets
	}
	return false
}

// AccessRequests is a collection of AccessRequest values.
type AccessRequests struct {
	AccessRequests       []*services.AccessRequestV3 `protobuf:"bytes,1,rep,name=AccessRequests" json:"access_requests"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *AccessRequests) Reset()         { *m = AccessRequests{} }
func (m *AccessRequests) String() string { return proto.CompactTextString(m) }
func (*AccessRequests) ProtoMessage()    {}
func (*AccessRequests) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{7}
}
func (m *AccessRequests) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessRequests) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessRequests.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *AccessRequests) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessRequests.Merge(dst, src)
}
func (m *AccessRequests) XXX_Size() int {
	return m.Size()
}
func (m *AccessRequests) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessRequests.DiscardUnknown(m)
}

var xxx_messageInfo_AccessRequests proto.InternalMessageInfo

func (m *AccessRequests) GetAccessRequests() []*services.AccessRequestV3 {
	if m != nil {
		return m.AccessRequests
	}
	return nil
}

// PluginDataSeq is a sequence of plugin data.
type PluginDataSeq struct {
	PluginData           []*services.PluginDataV3 `protobuf:"bytes,1,rep,name=PluginData" json:"plugin_data"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PluginDataSeq) Reset()         { *m = PluginDataSeq{} }
func (m *PluginDataSeq) String() string { return proto.CompactTextString(m) }
func (*PluginDataSeq) ProtoMessage()    {}
func (*PluginDataSeq) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{8}
}
func (m *PluginDataSeq) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PluginDataSeq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PluginDataSeq.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *PluginDataSeq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PluginDataSeq.Merge(dst, src)
}
func (m *PluginDataSeq) XXX_Size() int {
	return m.Size()
}
func (m *PluginDataSeq) XXX_DiscardUnknown() {
	xxx_messageInfo_PluginDataSeq.DiscardUnknown(m)
}

var xxx_messageInfo_PluginDataSeq proto.InternalMessageInfo

func (m *PluginDataSeq) GetPluginData() []*services.PluginDataV3 {
	if m != nil {
		return m.PluginData
	}
	return nil
}

// RequestStateSetter encodes the paramters necessary to update the
// state of a privilege escalation request.
type RequestStateSetter struct {
	ID                   string                `protobuf:"bytes,1,opt,name=ID,proto3" json:"id"`
	State                services.RequestState `protobuf:"varint,2,opt,name=State,proto3,enum=services.RequestState" json:"state"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *RequestStateSetter) Reset()         { *m = RequestStateSetter{} }
func (m *RequestStateSetter) String() string { return proto.CompactTextString(m) }
func (*RequestStateSetter) ProtoMessage()    {}
func (*RequestStateSetter) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{9}
}
func (m *RequestStateSetter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestStateSetter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestStateSetter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RequestStateSetter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestStateSetter.Merge(dst, src)
}
func (m *RequestStateSetter) XXX_Size() int {
	return m.Size()
}
func (m *RequestStateSetter) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestStateSetter.DiscardUnknown(m)
}

var xxx_messageInfo_RequestStateSetter proto.InternalMessageInfo

func (m *RequestStateSetter) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *RequestStateSetter) GetState() services.RequestState {
	if m != nil {
		return m.State
	}
	return services.RequestState_NONE
}

// RequestID is the unique identifier of an access request.
type RequestID struct {
	ID                   string   `protobuf:"bytes,1,opt,name=ID,proto3" json:"id"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestID) Reset()         { *m = RequestID{} }
func (m *RequestID) String() string { return proto.CompactTextString(m) }
func (*RequestID) ProtoMessage()    {}
func (*RequestID) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{10}
}
func (m *RequestID) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestID) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RequestID.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RequestID) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestID.Merge(dst, src)
}
func (m *RequestID) XXX_Size() int {
	return m.Size()
}
func (m *RequestID) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestID.DiscardUnknown(m)
}

var xxx_messageInfo_RequestID proto.InternalMessageInfo

func (m *RequestID) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

// PingRequest is the input value for the Ping method.
type PingRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PingRequest) Reset()         { *m = PingRequest{} }
func (m *PingRequest) String() string { return proto.CompactTextString(m) }
func (*PingRequest) ProtoMessage()    {}
func (*PingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{11}
}
func (m *PingRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PingRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *PingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingRequest.Merge(dst, src)
}
func (m *PingRequest) XXX_Size() int {
	return m.Size()
}
func (m *PingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PingRequest proto.InternalMessageInfo

// PingResponse contains data about the teleport auth server.
type PingResponse struct {
	// ClusterName is the name of the teleport cluster.
	ClusterName string `protobuf:"bytes,1,opt,name=ClusterName,proto3" json:"cluster_name"`
	// ServerVersion is the version of the auth server.
	ServerVersion        string   `protobuf:"bytes,2,opt,name=ServerVersion,proto3" json:"server_version"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PingResponse) Reset()         { *m = PingResponse{} }
func (m *PingResponse) String() string { return proto.CompactTextString(m) }
func (*PingResponse) ProtoMessage()    {}
func (*PingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_auth_a21c5411562892bf, []int{12}
}
func (m *PingResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PingResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *PingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingResponse.Merge(dst, src)
}
func (m *PingResponse) XXX_Size() int {
	return m.Size()
}
func (m *PingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PingResponse proto.InternalMessageInfo

func (m *PingResponse) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *PingResponse) GetServerVersion() string {
	if m != nil {
		return m.ServerVersion
	}
	return ""
}

func init() {
	proto.RegisterType((*Event)(nil), "proto.Event")
	proto.RegisterType((*Watch)(nil), "proto.Watch")
	proto.RegisterType((*WatchKind)(nil), "proto.WatchKind")
	proto.RegisterMapType((map[string]string)(nil), "proto.WatchKind.FilterEntry")
	proto.RegisterType((*Certs)(nil), "proto.Certs")
	proto.RegisterType((*UserCertsRequest)(nil), "proto.UserCertsRequest")
	proto.RegisterType((*GetUserRequest)(nil), "proto.GetUserRequest")
	proto.RegisterType((*GetUsersRequest)(nil), "proto.GetUsersRequest")
	proto.RegisterType((*AccessRequests)(nil), "proto.AccessRequests")
	proto.RegisterType((*PluginDataSeq)(nil), "proto.PluginDataSeq")
	proto.RegisterType((*RequestStateSetter)(nil), "proto.RequestStateSetter")
	proto.RegisterType((*RequestID)(nil), "proto.RequestID")
	proto.RegisterType((*PingRequest)(nil), "proto.PingRequest")
	proto.RegisterType((*PingResponse)(nil), "proto.PingResponse")
	proto.RegisterEnum("proto.Operation", Operation_name, Operation_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for AuthService service

type AuthServiceClient interface {
	// SendKeepAlives allows node to send a stream of keep alive requests
	SendKeepAlives(ctx context.Context, opts ...grpc.CallOption) (AuthService_SendKeepAlivesClient, error)
	// WatchEvents returns a new stream of cluster events
	WatchEvents(ctx context.Context, in *Watch, opts ...grpc.CallOption) (AuthService_WatchEventsClient, error)
	// UpsertNode upserts node
	UpsertNode(ctx context.Context, in *services.ServerV2, opts ...grpc.CallOption) (*services.KeepAlive, error)
	// GenerateUserCerts generates a set of user certificates for use by `tctl auth sign`.
	GenerateUserCerts(ctx context.Context, in *UserCertsRequest, opts ...grpc.CallOption) (*Certs, error)
	// GetUser gets a user resource by name.
	GetUser(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*services.UserV2, error)
	// GetUsers gets all current user resources.
	GetUsers(ctx context.Context, in *GetUsersRequest, opts ...grpc.CallOption) (AuthService_GetUsersClient, error)
	// GetAccessRequests gets all pending access requests.
	GetAccessRequests(ctx context.Context, in *services.AccessRequestFilter, opts ...grpc.CallOption) (*AccessRequests, error)
	// CreateAccessRequest creates a new access request.
	CreateAccessRequest(ctx context.Context, in *services.AccessRequestV3, opts ...grpc.CallOption) (*empty.Empty, error)
	// DeleteAccessRequest deletes an access request.
	DeleteAccessRequest(ctx context.Context, in *RequestID, opts ...grpc.CallOption) (*empty.Empty, error)
	// SetAccessRequestState sets the state of an access request.
	SetAccessRequestState(ctx context.Context, in *RequestStateSetter, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetPluginData gets all plugin data matching the supplied filter.
	GetPluginData(ctx context.Context, in *services.PluginDataFilter, opts ...grpc.CallOption) (*PluginDataSeq, error)
	// UpdatePluginData updates a plugin's resource-specific datastore.
	UpdatePluginData(ctx context.Context, in *services.PluginDataUpdateParams, opts ...grpc.CallOption) (*empty.Empty, error)
	// Ping gets basic info about the auth server. This method is intended
	// to mimic the behavior of the proxy's Ping method, and may be used by
	// clients for verification or configuration on startup.
	Ping(ctx context.Context, in *PingRequest, opts ...grpc.CallOption) (*PingResponse, error)
}

type authServiceClient struct {
	cc *grpc.ClientConn
}

func NewAuthServiceClient(cc *grpc.ClientConn) AuthServiceClient {
	return &authServiceClient{cc}
}

func (c *authServiceClient) SendKeepAlives(ctx context.Context, opts ...grpc.CallOption) (AuthService_SendKeepAlivesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuthService_serviceDesc.Streams[0], "/proto.AuthService/SendKeepAlives", opts...)
	if err != nil {
		return nil, err
	}
	x := &authServiceSendKeepAlivesClient{stream}
	return x, nil
}

type AuthService_SendKeepAlivesClient interface {
	Send(*services.KeepAlive) error
	CloseAndRecv() (*empty.Empty, error)
	grpc.ClientStream
}

type authServiceSendKeepAlivesClient struct {
	grpc.ClientStream
}

func (x *authServiceSendKeepAlivesClient) Send(m *services.KeepAlive) error {
	return x.ClientStream.SendMsg(m)
}

func (x *authServiceSendKeepAlivesClient) CloseAndRecv() (*empty.Empty, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(empty.Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *authServiceClient) WatchEvents(ctx context.Context, in *Watch, opts ...grpc.CallOption) (AuthService_WatchEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuthService_serviceDesc.Streams[1], "/proto.AuthService/WatchEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &authServiceWatchEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AuthService_WatchEventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type authServiceWatchEventsClient struct {
	grpc.ClientStream
}

func (x *authServiceWatchEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *authServiceClient) UpsertNode(ctx context.Context, in *services.ServerV2, opts ...grpc.CallOption) (*services.KeepAlive, error) {
	out := new(services.KeepAlive)
	err := c.cc.Invoke(ctx, "/proto.AuthService/UpsertNode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) GenerateUserCerts(ctx context.Context, in *UserCertsRequest, opts ...grpc.CallOption) (*Certs, error) {
	out := new(Certs)
	err := c.cc.Invoke(ctx, "/proto.AuthService/GenerateUserCerts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) GetUser(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*services.UserV2, error) {
	out := new(services.UserV2)
	err := c.cc.Invoke(ctx, "/proto.AuthService/GetUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) GetUsers(ctx context.Context, in *GetUsersRequest, opts ...grpc.CallOption) (AuthService_GetUsersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuthService_serviceDesc.Streams[2], "/proto.AuthService/GetUsers", opts...)
	if err != nil {
		return nil, err
	}
	x := &authServiceGetUsersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AuthService_GetUsersClient interface {
	Recv() (*services.UserV2, error)
	grpc.ClientStream
}

type authServiceGetUsersClient struct {
	grpc.ClientStream
}

func (x *authServiceGetUsersClient) Recv() (*services.UserV2, error) {
	m := new(services.UserV2)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *authServiceClient) GetAccessRequests(ctx context.Context, in *services.AccessRequestFilter, opts ...grpc.CallOption) (*AccessRequests, error) {
	out := new(AccessRequests)
	err := c.cc.Invoke(ctx, "/proto.AuthService/GetAccessRequests", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) CreateAccessRequest(ctx context.Context, in *services.AccessRequestV3, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.AuthService/CreateAccessRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) DeleteAccessRequest(ctx context.Context, in *RequestID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.AuthService/DeleteAccessRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) SetAccessRequestState(ctx context.Context, in *RequestStateSetter, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.AuthService/SetAccessRequestState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) GetPluginData(ctx context.Context, in *services.PluginDataFilter, opts ...grpc.CallOption) (*PluginDataSeq, error) {
	out := new(PluginDataSeq)
	err := c.cc.Invoke(ctx, "/proto.AuthService/GetPluginData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) UpdatePluginData(ctx context.Context, in *services.PluginDataUpdateParams, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.AuthService/UpdatePluginData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authServiceClient) Ping(ctx context.Context, in *PingRequest, opts ...grpc.CallOption) (*PingResponse, error) {
	out := new(PingResponse)
	err := c.cc.Invoke(ctx, "/proto.AuthService/Ping", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for AuthService service

type AuthServiceServer interface {
	// SendKeepAlives allows node to send a stream of keep alive requests
	SendKeepAlives(AuthService_SendKeepAlivesServer) error
	// WatchEvents returns a new stream of cluster events
	WatchEvents(*Watch, AuthService_WatchEventsServer) error
	// UpsertNode upserts node
	UpsertNode(context.Context, *services.ServerV2) (*services.KeepAlive, error)
	// GenerateUserCerts generates a set of user certificates for use by `tctl auth sign`.
	GenerateUserCerts(context.Context, *UserCertsRequest) (*Certs, error)
	// GetUser gets a user resource by name.
	GetUser(context.Context, *GetUserRequest) (*services.UserV2, error)
	// GetUsers gets all current user resources.
	GetUsers(*GetUsersRequest, AuthService_GetUsersServer) error
	// GetAccessRequests gets all pending access requests.
	GetAccessRequests(context.Context, *services.AccessRequestFilter) (*AccessRequests, error)
	// CreateAccessRequest creates a new access request.
	CreateAccessRequest(context.Context, *services.AccessRequestV3) (*empty.Empty, error)
	// DeleteAccessRequest deletes an access request.
	DeleteAccessRequest(context.Context, *RequestID) (*empty.Empty, error)
	// SetAccessRequestState sets the state of an access request.
	SetAccessRequestState(context.Context, *RequestStateSetter) (*empty.Empty, error)
	// GetPluginData gets all plugin data matching the supplied filter.
	GetPluginData(context.Context, *services.PluginDataFilter) (*PluginDataSeq, error)
	// UpdatePluginData updates a plugin's resource-specific datastore.
	UpdatePluginData(context.Context, *services.PluginDataUpdateParams) (*empty.Empty, error)
	// Ping gets basic info about the auth server. This method is intended
	// to mimic the behavior of the proxy's Ping method, and may be used by
	// clients for verification or configuration on startup.
	Ping(context.Context, *PingRequest) (*PingResponse, error)
}

func RegisterAuthServiceServer(s *grpc.Server, srv AuthServiceServer) {
	s.RegisterService(&_AuthService_serviceDesc, srv)
}

func _AuthService_SendKeepAlives_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(AuthServiceServer).SendKeepAlives(&authServiceSendKeepAlivesServer{stream})
}

type AuthService_SendKeepAlivesServer interface {
	SendAndClose(*empty.Empty) error
	Recv() (*services.KeepAlive, error)
	grpc.ServerStream
}

type authServiceSendKeepAlivesServer struct {
	grpc.ServerStream
}

func (x *authServiceSendKeepAlivesServer) SendAndClose(m *empty.Empty) error {
	return x.ServerStream.SendMsg(m)
}

func (x *authServiceSendKeepAlivesServer) Recv() (*services.KeepAlive, error) {
	m := new(services.KeepAlive)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _AuthService_WatchEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Watch)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AuthServiceServer).WatchEvents(m, &authServiceWatchEventsServer{stream})
}

type AuthService_WatchEventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type authServiceWatchEventsServer struct {
	grpc.ServerStream
}

func (x *authServiceWatchEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _AuthService_UpsertNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(services.ServerV2)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).UpsertNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/UpsertNode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).UpsertNode(ctx, req.(*services.ServerV2))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_GenerateUserCerts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCertsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).GenerateUserCerts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/GenerateUserCerts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).GenerateUserCerts(ctx, req.(*UserCertsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_GetUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).GetUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/GetUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).GetUser(ctx, req.(*GetUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_GetUsers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetUsersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AuthServiceServer).GetUsers(m, &authServiceGetUsersServer{stream})
}

type AuthService_GetUsersServer interface {
	Send(*services.UserV2) error
	grpc.ServerStream
}

type authServiceGetUsersServer struct {
	grpc.ServerStream
}

func (x *authServiceGetUsersServer) Send(m *services.UserV2) error {
	return x.ServerStream.SendMsg(m)
}

func _AuthService_GetAccessRequests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(services.AccessRequestFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).GetAccessRequests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/GetAccessRequests",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).GetAccessRequests(ctx, req.(*services.AccessRequestFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_CreateAccessRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(services.AccessRequestV3)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).CreateAccessRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/CreateAccessRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).CreateAccessRequest(ctx, req.(*services.AccessRequestV3))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_DeleteAccessRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).DeleteAccessRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/DeleteAccessRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).DeleteAccessRequest(ctx, req.(*RequestID))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_SetAccessRequestState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestStateSetter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).SetAccessRequestState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/SetAccessRequestState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).SetAccessRequestState(ctx, req.(*RequestStateSetter))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_GetPluginData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(services.PluginDataFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).GetPluginData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/GetPluginData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).GetPluginData(ctx, req.(*services.PluginDataFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_UpdatePluginData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(services.PluginDataUpdateParams)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).UpdatePluginData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/UpdatePluginData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).UpdatePluginData(ctx, req.(*services.PluginDataUpdateParams))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthService_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthServiceServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.AuthService/Ping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthServiceServer).Ping(ctx, req.(*PingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AuthService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.AuthService",
	HandlerType: (*AuthServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpsertNode",
			Handler:    _AuthService_UpsertNode_Handler,
		},
		{
			MethodName: "GenerateUserCerts",
			Handler:    _AuthService_GenerateUserCerts_Handler,
		},
		{
			MethodName: "GetUser",
			Handler:    _AuthService_GetUser_Handler,
		},
		{
			MethodName: "GetAccessRequests",
			Handler:    _AuthService_GetAccessRequests_Handler,
		},
		{
			MethodName: "CreateAccessRequest",
			Handler:    _AuthService_CreateAccessRequest_Handler,
		},
		{
			MethodName: "DeleteAccessRequest",
			Handler:    _AuthService_DeleteAccessRequest_Handler,
		},
		{
			MethodName: "SetAccessRequestState",
			Handler:    _AuthService_SetAccessRequestState_Handler,
		},
		{
			MethodName: "GetPluginData",
			Handler:    _AuthService_GetPluginData_Handler,
		},
		{
			MethodName: "UpdatePluginData",
			Handler:    _AuthService_UpdatePluginData_Handler,
		},
		{
			MethodName: "Ping",
			Handler:    _AuthService_Ping_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SendKeepAlives",
			Handler:       _AuthService_SendKeepAlives_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "WatchEvents",
			Handler:       _AuthService_WatchEvents_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetUsers",
			Handler:       _AuthService_GetUsers_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "auth.proto",
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Type))
	}
	if m.Resource != nil {
		nn1, err := m.Resource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Event_ResourceHeader) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResourceHeader != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ResourceHeader.Size()))
		n2, err := m.ResourceHeader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *Event_CertAuthority) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CertAuthority != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.CertAuthority.Size()))
		n3, err := m.CertAuthority.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Event_StaticTokens) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StaticTokens != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.StaticTokens.Size()))
		n4, err := m.StaticTokens.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Event_ProvisionToken) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ProvisionToken != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ProvisionToken.Size()))
		n5, err := m.ProvisionToken.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Event_ClusterName) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterName != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ClusterName.Size()))
		n6, err := m.ClusterName.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Event_ClusterConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterConfig != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ClusterConfig.Size()))
		n7, err := m.ClusterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Event_User) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.User != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.User.Size()))
		n8, err := m.User.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *Event_Role) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Role != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Role.Size()))
		n9, err := m.Role.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *Event_Namespace) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Namespace != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Namespace.Size()))
		n10, err := m.Namespace.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *Event_Server) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Server != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.Server.Size()))
		n11, err := m.Server.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *Event_ReverseTunnel) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReverseTunnel != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.ReverseTunnel.Size()))
		n12, err := m.ReverseTunnel.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *Event_TunnelConnection) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TunnelConnection != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.TunnelConnection.Size()))
		n13, err := m.TunnelConnection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *Event_AccessRequest) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AccessRequest != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.AccessRequest.Size()))
		n14, err := m.AccessRequest.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *Watch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Watch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kinds) > 0 {
		for _, msg := range m.Kinds {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAuth(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WatchKind) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchKind) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if m.LoadSecrets {
		dAtA[i] = 0x10
		i++
		if m.LoadSecrets {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Filter) > 0 {
		for k, _ := range m.Filter {
			dAtA[i] = 0x22
			i++
			v := m.Filter[k]
			mapSize := 1 + len(k) + sovAuth(uint64(len(k))) + 1 + len(v) + sovAuth(uint64(len(v)))
			i = encodeVarintAuth(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAuth(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAuth(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Certs) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Certs) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SSH) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.SSH)))
		i += copy(dAtA[i:], m.SSH)
	}
	if len(m.TLS) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.TLS)))
		i += copy(dAtA[i:], m.TLS)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UserCertsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UserCertsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PublicKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.PublicKey)))
		i += copy(dAtA[i:], m.PublicKey)
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintAuth(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)))
	n15, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Expires, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	if len(m.Format) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.Format)))
		i += copy(dAtA[i:], m.Format)
	}
	if len(m.RouteToCluster) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.RouteToCluster)))
		i += copy(dAtA[i:], m.RouteToCluster)
	}
	if len(m.AccessRequests) > 0 {
		for _, s := range m.AccessRequests {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GetUserRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUserRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.WithSecrets {
		dAtA[i] = 0x10
		i++
		if m.WithSecrets {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GetUsersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUsersRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.WithSecrets {
		dAtA[i] = 0x8
		i++
		if m.WithSecrets {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AccessRequests) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessRequests) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AccessRequests) > 0 {
		for _, msg := range m.AccessRequests {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAuth(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PluginDataSeq) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PluginDataSeq) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PluginData) > 0 {
		for _, msg := range m.PluginData {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAuth(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RequestStateSetter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestStateSetter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.ID)))
		i += copy(dAtA[i:], m.ID)
	}
	if m.State != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAuth(dAtA, i, uint64(m.State))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RequestID) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.ID)))
		i += copy(dAtA[i:], m.ID)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PingRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PingResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if len(m.ServerVersion) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAuth(dAtA, i, uint64(len(m.ServerVersion)))
		i += copy(dAtA[i:], m.ServerVersion)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintAuth(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Event) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovAuth(uint64(m.Type))
	}
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event_ResourceHeader) Size() (n int) {
	var l int
	_ = l
	if m.ResourceHeader != nil {
		l = m.ResourceHeader.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_CertAuthority) Size() (n int) {
	var l int
	_ = l
	if m.CertAuthority != nil {
		l = m.CertAuthority.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_StaticTokens) Size() (n int) {
	var l int
	_ = l
	if m.StaticTokens != nil {
		l = m.StaticTokens.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ProvisionToken) Size() (n int) {
	var l int
	_ = l
	if m.ProvisionToken != nil {
		l = m.ProvisionToken.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ClusterName) Size() (n int) {
	var l int
	_ = l
	if m.ClusterName != nil {
		l = m.ClusterName.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ClusterConfig) Size() (n int) {
	var l int
	_ = l
	if m.ClusterConfig != nil {
		l = m.ClusterConfig.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_User) Size() (n int) {
	var l int
	_ = l
	if m.User != nil {
		l = m.User.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_Role) Size() (n int) {
	var l int
	_ = l
	if m.Role != nil {
		l = m.Role.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_Namespace) Size() (n int) {
	var l int
	_ = l
	if m.Namespace != nil {
		l = m.Namespace.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_Server) Size() (n int) {
	var l int
	_ = l
	if m.Server != nil {
		l = m.Server.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_ReverseTunnel) Size() (n int) {
	var l int
	_ = l
	if m.ReverseTunnel != nil {
		l = m.ReverseTunnel.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_TunnelConnection) Size() (n int) {
	var l int
	_ = l
	if m.TunnelConnection != nil {
		l = m.TunnelConnection.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Event_AccessRequest) Size() (n int) {
	var l int
	_ = l
	if m.AccessRequest != nil {
		l = m.AccessRequest.Size()
		n += 1 + l + sovAuth(uint64(l))
	}
	return n
}
func (m *Watch) Size() (n int) {
	var l int
	_ = l
	if len(m.Kinds) > 0 {
		for _, e := range m.Kinds {
			l = e.Size()
			n += 1 + l + sovAuth(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WatchKind) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.LoadSecrets {
		n += 2
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if len(m.Filter) > 0 {
		for k, v := range m.Filter {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAuth(uint64(len(k))) + 1 + len(v) + sovAuth(uint64(len(v)))
			n += mapEntrySize + 1 + sovAuth(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Certs) Size() (n int) {
	var l int
	_ = l
	l = len(m.SSH)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	l = len(m.TLS)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UserCertsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.PublicKey)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)
	n += 1 + l + sovAuth(uint64(l))
	l = len(m.Format)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	l = len(m.RouteToCluster)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if len(m.AccessRequests) > 0 {
		for _, s := range m.AccessRequests {
			l = len(s)
			n += 1 + l + sovAuth(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetUserRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.WithSecrets {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetUsersRequest) Size() (n int) {
	var l int
	_ = l
	if m.WithSecrets {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccessRequests) Size() (n int) {
	var l int
	_ = l
	if len(m.AccessRequests) > 0 {
		for _, e := range m.AccessRequests {
			l = e.Size()
			n += 1 + l + sovAuth(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PluginDataSeq) Size() (n int) {
	var l int
	_ = l
	if len(m.PluginData) > 0 {
		for _, e := range m.PluginData {
			l = e.Size()
			n += 1 + l + sovAuth(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RequestStateSetter) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovAuth(uint64(m.State))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RequestID) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PingRequest) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PingResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	l = len(m.ServerVersion)
	if l > 0 {
		n += 1 + l + sovAuth(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAuth(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAuth(x uint64) (n int) {
	return sovAuth(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Operation(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ResourceHeader{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ResourceHeader{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertAuthority", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.CertAuthorityV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_CertAuthority{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticTokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.StaticTokensV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_StaticTokens{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProvisionToken", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ProvisionTokenV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ProvisionToken{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ClusterNameV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ClusterName{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ClusterConfigV3{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ClusterConfig{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.UserV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_User{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.RoleV3{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_Role{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.Namespace{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_Namespace{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ServerV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_Server{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseTunnel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.ReverseTunnelV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_ReverseTunnel{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TunnelConnection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.TunnelConnectionV2{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_TunnelConnection{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &services.AccessRequestV3{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &Event_AccessRequest{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Watch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Watch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Watch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kinds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kinds = append(m.Kinds, WatchKind{})
			if err := m.Kinds[len(m.Kinds)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchKind) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchKind: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchKind: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadSecrets", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LoadSecrets = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filter == nil {
				m.Filter = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAuth
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAuth
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAuth
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAuth
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAuth
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAuth(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAuth
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Filter[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Certs) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Certs: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Certs: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SSH", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SSH = append(m.SSH[:0], dAtA[iNdEx:postIndex]...)
			if m.SSH == nil {
				m.SSH = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TLS", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TLS = append(m.TLS[:0], dAtA[iNdEx:postIndex]...)
			if m.TLS == nil {
				m.TLS = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UserCertsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UserCertsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UserCertsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicKey = append(m.PublicKey[:0], dAtA[iNdEx:postIndex]...)
			if m.PublicKey == nil {
				m.PublicKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Expires, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Format = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteToCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RouteToCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessRequests", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessRequests = append(m.AccessRequests, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUserRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUserRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUserRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithSecrets", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WithSecrets = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUsersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUsersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUsersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithSecrets", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WithSecrets = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessRequests) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessRequests: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessRequests: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessRequests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessRequests = append(m.AccessRequests, &services.AccessRequestV3{})
			if err := m.AccessRequests[len(m.AccessRequests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PluginDataSeq) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PluginDataSeq: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PluginDataSeq: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PluginData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PluginData = append(m.PluginData, &services.PluginDataV3{})
			if err := m.PluginData[len(m.PluginData)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestStateSetter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestStateSetter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestStateSetter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (services.RequestState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestID) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuth
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAuth(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuth
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAuth(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAuth
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAuth
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAuth
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAuth
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAuth(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAuth = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAuth   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("auth.proto", fileDescriptor_auth_a21c5411562892bf) }

var fileDescriptor_auth_a21c5411562892bf = []byte{
	// 1536 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x56, 0x4f, 0x6f, 0xdb, 0xca,
	0x11, 0x0f, 0x6d, 0x4b, 0xb1, 0x46, 0xb6, 0xa2, 0xac, 0xfd, 0x6c, 0x46, 0x49, 0x4c, 0x43, 0xef,
	0x62, 0xbc, 0x06, 0xd2, 0x83, 0x82, 0xb6, 0x69, 0x50, 0x20, 0x08, 0x6d, 0x25, 0xf6, 0x8b, 0x91,
	0xba, 0x94, 0xac, 0x14, 0xed, 0x41, 0xa0, 0xa5, 0x89, 0x4c, 0x98, 0x22, 0xf9, 0xb8, 0x2b, 0xb5,
	0x06, 0x7a, 0xea, 0x27, 0xe8, 0xb1, 0x9f, 0xa6, 0xbd, 0xe6, 0xd8, 0x4f, 0xc0, 0xb6, 0xe9, 0x8d,
	0x9f, 0xa1, 0x87, 0x62, 0xff, 0x50, 0xe2, 0xd2, 0xd6, 0x3b, 0x91, 0xfb, 0x9b, 0x99, 0xdf, 0xec,
	0xce, 0xce, 0x9f, 0x05, 0x70, 0x67, 0xec, 0xba, 0x15, 0xc5, 0x21, 0x0b, 0x49, 0x49, 0x7c, 0x1a,
	0xbb, 0x93, 0x70, 0x12, 0x8a, 0xdf, 0x36, 0xff, 0x93, 0xc2, 0xc6, 0xd3, 0x49, 0x18, 0x4e, 0x7c,
	0x6c, 0x8b, 0xd5, 0xd5, 0xec, 0x73, 0x1b, 0xa7, 0x11, 0xbb, 0x55, 0x42, 0xab, 0x28, 0x64, 0xde,
	0x14, 0x29, 0x73, 0xa7, 0x91, 0x52, 0x78, 0x3d, 0xf1, 0xd8, 0xf5, 0xec, 0xaa, 0x35, 0x0a, 0xa7,
	0xed, 0x49, 0xec, 0xce, 0x3d, 0xe6, 0x32, 0x2f, 0x0c, 0x5c, 0xbf, 0xcd, 0xd0, 0xc7, 0x28, 0x8c,
	0x59, 0xdb, 0xf7, 0xae, 0xda, 0x14, 0xe3, 0xb9, 0x37, 0x42, 0xda, 0x66, 0xb7, 0x11, 0x52, 0x69,
	0xdb, 0xfc, 0x47, 0x05, 0x4a, 0xdd, 0x39, 0x06, 0x8c, 0xbc, 0x82, 0x8d, 0xfe, 0x6d, 0x84, 0xa6,
	0x71, 0x68, 0x1c, 0xd5, 0x3a, 0x75, 0x29, 0x6f, 0xfd, 0x26, 0xc2, 0x58, 0xb0, 0xd9, 0x24, 0x4d,
	0xac, 0x1a, 0x37, 0x7d, 0x11, 0x4e, 0x3d, 0x26, 0x36, 0xe8, 0x08, 0x0b, 0xf2, 0x7b, 0xa8, 0x39,
	0x48, 0xc3, 0x59, 0x3c, 0xc2, 0x53, 0x74, 0xc7, 0x18, 0x9b, 0x6b, 0x87, 0xc6, 0x51, 0xb5, 0x63,
	0xb6, 0x32, 0x97, 0x2d, 0x5d, 0x6e, 0xef, 0xa5, 0x89, 0x45, 0x62, 0x85, 0x2d, 0xf9, 0x4e, 0x1f,
	0x38, 0x05, 0x26, 0x32, 0x84, 0xed, 0x63, 0x8c, 0xd9, 0xdb, 0x19, 0xbb, 0x0e, 0x63, 0x8f, 0xdd,
	0x9a, 0xeb, 0x82, 0xfa, 0xc9, 0x92, 0x5a, 0x13, 0x0f, 0x3a, 0xf6, 0xb3, 0x34, 0xb1, 0xcc, 0x11,
	0xc6, 0x6c, 0xe8, 0x66, 0xa8, 0xe6, 0x41, 0xe7, 0x23, 0x7f, 0x80, 0xad, 0x1e, 0x8f, 0xd7, 0xa8,
	0x1f, 0xde, 0x60, 0x40, 0xcd, 0x8d, 0xe2, 0xd6, 0xf3, 0xd2, 0x41, 0xc7, 0x7e, 0x9a, 0x26, 0xd6,
	0x3e, 0x15, 0xd8, 0x90, 0x09, 0x50, 0x63, 0xd7, 0xc8, 0xc8, 0x08, 0x6a, 0x17, 0x71, 0x38, 0xf7,
	0xa8, 0x17, 0x06, 0x02, 0x32, 0x4b, 0x82, 0xbe, 0xb1, 0xa4, 0xd7, 0xe5, 0x83, 0x8e, 0xfd, 0x3c,
	0x4d, 0xac, 0x27, 0x51, 0x86, 0x4a, 0x1f, 0x7a, 0x88, 0x74, 0x13, 0xf2, 0x09, 0xaa, 0xc7, 0xfe,
	0x8c, 0x32, 0x8c, 0x3f, 0xba, 0x53, 0x34, 0xcb, 0xc2, 0xc3, 0x7e, 0x2e, 0x40, 0x4b, 0xe1, 0xa0,
	0x63, 0x37, 0xd2, 0xc4, 0xda, 0x1b, 0x49, 0x68, 0x18, 0xb8, 0x53, 0x3d, 0xfc, 0x79, 0x26, 0x11,
	0x7b, 0xb9, 0x3c, 0x0e, 0x83, 0xcf, 0xde, 0xc4, 0x7c, 0x78, 0x27, 0xf6, 0x79, 0xf1, 0xe0, 0xa5,
	0x8a, 0xbd, 0x22, 0x1f, 0x09, 0xb4, 0x10, 0xfb, 0xbc, 0x01, 0x79, 0x0d, 0x1b, 0x97, 0x14, 0x63,
	0x73, 0x53, 0xf0, 0xd6, 0x97, 0xbc, 0x1c, 0x1d, 0x74, 0x64, 0xca, 0xcd, 0x28, 0xc6, 0x1a, 0x89,
	0xb0, 0xe1, 0xb6, 0x4e, 0xe8, 0xa3, 0x59, 0x29, 0xda, 0x72, 0x74, 0xf0, 0x52, 0xda, 0xc6, 0xa1,
	0xaf, 0x9f, 0x4f, 0xd8, 0x90, 0x73, 0xa8, 0xf0, 0x03, 0xd2, 0xc8, 0x1d, 0xa1, 0x09, 0x82, 0x60,
	0x67, 0x49, 0xb0, 0x10, 0xd9, 0xfb, 0x69, 0x62, 0xed, 0x04, 0xd9, 0x52, 0x23, 0x5a, 0x12, 0x10,
	0x1b, 0xca, 0x3d, 0x8c, 0xe7, 0x18, 0x9b, 0x55, 0x41, 0x45, 0x72, 0xb9, 0x23, 0xf0, 0x41, 0xc7,
	0xde, 0x4d, 0x13, 0xab, 0x4e, 0xc5, 0x4a, 0xa3, 0x51, 0x96, 0x3c, 0xd4, 0x0e, 0xce, 0x31, 0xa6,
	0xd8, 0x9f, 0x05, 0x01, 0xfa, 0xe6, 0x56, 0x31, 0xd4, 0x9a, 0x38, 0x4b, 0xf3, 0x58, 0x82, 0x43,
	0x26, 0x50, 0x3d, 0xd4, 0x9a, 0x01, 0xb9, 0x81, 0xba, 0xfc, 0x3b, 0x0e, 0x83, 0x00, 0x47, 0xbc,
	0xa2, 0xcd, 0x6d, 0xe1, 0xe3, 0xd9, 0xd2, 0x47, 0x51, 0x63, 0xd0, 0xb1, 0xad, 0x34, 0xb1, 0x9e,
	0x4a, 0x7a, 0x7e, 0xa1, 0x4a, 0xa0, 0x79, 0xba, 0x43, 0xcc, 0x4f, 0xf3, 0x76, 0x34, 0x42, 0x4a,
	0x1d, 0xfc, 0x71, 0x86, 0x94, 0x99, 0xb5, 0xe2, 0x69, 0x34, 0x71, 0x96, 0x38, 0xae, 0x00, 0x87,
	0xb1, 0x44, 0xf5, 0xd3, 0x68, 0x06, 0x36, 0xc0, 0x66, 0xd6, 0x27, 0x9a, 0xa7, 0x50, 0xfa, 0xe4,
	0xb2, 0xd1, 0x35, 0x79, 0x03, 0xa5, 0x0f, 0x5e, 0x30, 0xa6, 0xa6, 0x71, 0xb8, 0x2e, 0x52, 0x42,
	0x76, 0x30, 0x21, 0xe4, 0x02, 0x7b, 0xff, 0x4b, 0x62, 0x3d, 0x48, 0x13, 0xeb, 0xd1, 0x0d, 0x57,
	0xcb, 0xb5, 0x31, 0x69, 0xd7, 0xfc, 0xcb, 0x1a, 0x54, 0x16, 0xda, 0xe4, 0x19, 0x6c, 0xf0, 0xaf,
	0xe8, 0x87, 0x15, 0x7b, 0x33, 0x4d, 0xac, 0x0d, 0x6e, 0xe7, 0x08, 0x94, 0x74, 0xa0, 0x7a, 0x1e,
	0xba, 0xe3, 0x1e, 0x8e, 0x62, 0x64, 0x54, 0x34, 0xbc, 0x4d, 0xbb, 0x9e, 0x26, 0xd6, 0x96, 0x1f,
	0xba, 0xe3, 0x21, 0x95, 0xb8, 0x93, 0x57, 0xe2, 0x8c, 0xa2, 0x42, 0xd7, 0x97, 0x8c, 0x3c, 0xb9,
	0x1c, 0x81, 0x92, 0x1f, 0xa0, 0xfc, 0xce, 0xf3, 0x19, 0xc6, 0xe6, 0x86, 0xd8, 0xff, 0xb3, 0xe2,
	0xfe, 0x5b, 0x52, 0xdc, 0x0d, 0x58, 0x7c, 0x2b, 0x13, 0xea, 0xb3, 0x00, 0x72, 0x07, 0x51, 0x0c,
	0x8d, 0x5f, 0x41, 0x35, 0xa7, 0x4c, 0xea, 0xb0, 0x7e, 0x83, 0xb7, 0xf2, 0x24, 0x0e, 0xff, 0x25,
	0xbb, 0x50, 0x9a, 0xbb, 0xfe, 0x0c, 0xc5, 0xc6, 0x2b, 0x8e, 0x5c, 0xbc, 0x5e, 0x7b, 0x65, 0x34,
	0x7f, 0x0b, 0x25, 0xde, 0x20, 0x29, 0xf9, 0x16, 0xd6, 0x7b, 0xbd, 0x53, 0x61, 0xb4, 0x65, 0x3f,
	0x4e, 0x13, 0x6b, 0x9b, 0xd2, 0xeb, 0x9c, 0x2f, 0x2e, 0xe5, 0x4a, 0xfd, 0xf3, 0x9e, 0x60, 0x51,
	0x4a, 0xcc, 0xcf, 0x47, 0x96, 0x4b, 0x9b, 0xff, 0x5b, 0x83, 0x3a, 0xaf, 0x59, 0xc1, 0xab, 0xae,
	0x90, 0xbc, 0x80, 0xca, 0xc5, 0xec, 0xca, 0xf7, 0x46, 0x1f, 0xd4, 0xce, 0xb6, 0xec, 0x5a, 0x9a,
	0x58, 0x10, 0x09, 0x70, 0x78, 0x83, 0xb7, 0xce, 0x52, 0x81, 0x1c, 0xc1, 0x26, 0x67, 0xe0, 0xe1,
	0x92, 0x5b, 0xb6, 0xb7, 0xd2, 0xc4, 0xda, 0x9c, 0x29, 0xcc, 0x59, 0x48, 0x49, 0x0f, 0x1e, 0x76,
	0xff, 0x14, 0x79, 0x31, 0x52, 0x35, 0x2a, 0x1a, 0x2d, 0x39, 0x3f, 0x5b, 0xd9, 0xfc, 0x6c, 0xf5,
	0xb3, 0xf9, 0x69, 0x3f, 0x57, 0x19, 0xf1, 0x18, 0xa5, 0xc9, 0x72, 0xe7, 0x7f, 0xfd, 0x97, 0x65,
	0x38, 0x19, 0x13, 0x79, 0x01, 0xe5, 0x77, 0x61, 0x3c, 0x75, 0x99, 0x18, 0x0f, 0x15, 0x15, 0x7d,
	0x81, 0x68, 0xd1, 0x17, 0x08, 0x79, 0x07, 0x35, 0x27, 0x9c, 0x31, 0xec, 0x87, 0xaa, 0xdd, 0x89,
	0xae, 0x5f, 0xb1, 0x0f, 0xd2, 0xc4, 0x6a, 0xc4, 0x5c, 0x32, 0x64, 0xe1, 0x50, 0xb5, 0xc9, 0x9c,
	0x7d, 0xc1, 0x8a, 0x74, 0xa1, 0xa6, 0xa5, 0x3d, 0x35, 0xcb, 0x87, 0xeb, 0x47, 0x15, 0x39, 0x21,
	0xf4, 0x62, 0xc9, 0xc7, 0xbc, 0x60, 0xd4, 0xf4, 0xa1, 0xf6, 0x1e, 0x19, 0x0f, 0x50, 0x16, 0xfb,
	0x2c, 0x11, 0x8d, 0x7b, 0x13, 0xf1, 0xd7, 0x50, 0xfd, 0xe4, 0xb1, 0x6b, 0x3d, 0xb5, 0xc5, 0xd8,
	0xf8, 0xa3, 0xc7, 0xae, 0xb3, 0xd4, 0xce, 0x39, 0xcc, 0xab, 0x37, 0xbb, 0xf0, 0x48, 0x79, 0x5b,
	0x5c, 0x75, 0x47, 0x27, 0x34, 0x96, 0xb5, 0x92, 0x27, 0xd4, 0x69, 0xae, 0x8b, 0x67, 0x27, 0x83,
	0x3b, 0xd1, 0x90, 0x75, 0xfe, 0x13, 0x5d, 0x65, 0x87, 0x17, 0x7b, 0x21, 0x50, 0x77, 0xc2, 0xf3,
	0x3b, 0xd8, 0xbe, 0xf0, 0x67, 0x13, 0x2f, 0x38, 0x71, 0x99, 0xdb, 0xc3, 0x1f, 0xc9, 0x7b, 0x80,
	0x25, 0xa0, 0x9c, 0xec, 0xe5, 0x06, 0xf6, 0x42, 0x36, 0x78, 0x69, 0x3f, 0x4a, 0x13, 0xab, 0x1a,
	0x09, 0x64, 0x38, 0x76, 0x99, 0xeb, 0xe4, 0x4c, 0x9b, 0x08, 0x44, 0x79, 0xe1, 0x8f, 0x02, 0xec,
	0x21, 0xe3, 0xb7, 0xba, 0x07, 0x6b, 0x67, 0x27, 0x2a, 0xf4, 0xe5, 0x34, 0xb1, 0xd6, 0xbc, 0xb1,
	0xb3, 0x76, 0x76, 0x42, 0x7e, 0x09, 0x25, 0xa1, 0x26, 0x02, 0x5e, 0xcb, 0x7b, 0xcc, 0x93, 0xd8,
	0x95, 0x34, 0xb1, 0x4a, 0xfc, 0xfd, 0x81, 0x8e, 0xd4, 0x6f, 0x7e, 0x0b, 0x15, 0xa5, 0x71, 0x76,
	0xb2, 0x8a, 0xbd, 0xb9, 0x0d, 0xd5, 0x0b, 0x2f, 0x98, 0x28, 0xc5, 0xe6, 0x9f, 0x61, 0x4b, 0x2e,
	0x69, 0x14, 0x06, 0x14, 0xf9, 0x15, 0xe5, 0xdf, 0x10, 0xd2, 0x5e, 0x5c, 0x51, 0xfe, 0xa9, 0xa0,
	0x3f, 0x0f, 0x5e, 0xc1, 0xb6, 0x9a, 0x6f, 0x18, 0xf3, 0xd7, 0x88, 0x2a, 0x4c, 0x31, 0x78, 0xe5,
	0xa8, 0x1b, 0xce, 0xa5, 0xc4, 0xd1, 0x15, 0xbf, 0xfb, 0x0e, 0x2a, 0x8b, 0x77, 0x25, 0xd9, 0x84,
	0x8d, 0xb3, 0x8f, 0x67, 0xfd, 0xfa, 0x03, 0xf2, 0x10, 0xd6, 0x2f, 0x2e, 0xfb, 0x75, 0x83, 0x00,
	0x94, 0x4f, 0xba, 0xe7, 0xdd, 0x7e, 0xb7, 0xbe, 0xd6, 0xf9, 0x7b, 0x19, 0xaa, 0xfc, 0xb5, 0xd6,
	0x93, 0xd1, 0x20, 0x6f, 0xa0, 0xd6, 0xc3, 0x60, 0xfc, 0x01, 0x31, 0x7a, 0xeb, 0x7b, 0x73, 0xa4,
	0x24, 0x37, 0xba, 0x17, 0x68, 0x63, 0xef, 0x4e, 0xd5, 0x77, 0x79, 0xae, 0x1e, 0x19, 0xe4, 0x67,
	0x50, 0x15, 0x2d, 0x55, 0xbc, 0x7a, 0x29, 0xd9, 0xca, 0xb7, 0xd9, 0x46, 0xb6, 0x12, 0xc2, 0xef,
	0x0d, 0xf2, 0x73, 0x80, 0xcb, 0x88, 0x62, 0xcc, 0x3e, 0x86, 0x63, 0x24, 0xf7, 0x4c, 0xf6, 0xc6,
	0x7d, 0xde, 0xc9, 0x6b, 0x78, 0xfc, 0x1e, 0x03, 0x7e, 0x42, 0x5c, 0x34, 0x3e, 0xb2, 0xaf, 0xb8,
	0x8b, 0xad, 0x70, 0xe1, 0x54, 0xaa, 0x75, 0xe0, 0xa1, 0x2a, 0x20, 0xf2, 0x8d, 0x12, 0xe8, 0xe5,
	0xdb, 0xb8, 0xf3, 0x50, 0x22, 0xbf, 0x80, 0xcd, 0xac, 0xe8, 0xc8, 0x9e, 0x6e, 0x44, 0x57, 0x5a,
	0x7d, 0x6f, 0x90, 0x33, 0xbe, 0x4f, 0x56, 0x28, 0xb4, 0xe7, 0x2b, 0x0a, 0x4a, 0xcd, 0x96, 0x6c,
	0x53, 0x05, 0xab, 0x53, 0xd8, 0x39, 0x8e, 0xd1, 0x65, 0xa8, 0xe1, 0x64, 0x75, 0x75, 0xae, 0xba,
	0x22, 0xf2, 0x06, 0x76, 0x4e, 0xd0, 0xc7, 0x22, 0x53, 0x36, 0xcf, 0x17, 0xb9, 0xbe, 0x92, 0xe0,
	0x07, 0xf8, 0xa6, 0x57, 0x38, 0x95, 0xa8, 0x14, 0xf2, 0x44, 0xa7, 0xc8, 0x55, 0xe5, 0x4a, 0xae,
	0xb7, 0xb0, 0xfd, 0x1e, 0xd9, 0xb2, 0xa8, 0x49, 0xe3, 0xbe, 0x4e, 0xa0, 0x42, 0xb3, 0xab, 0xf8,
	0xf5, 0x7e, 0x72, 0x0e, 0xf5, 0xcb, 0x68, 0xec, 0x32, 0xcc, 0xb1, 0x1c, 0xde, 0xc7, 0xa2, 0xb4,
	0xdc, 0xd8, 0x9d, 0xd2, 0x95, 0x1b, 0x6a, 0xc3, 0x06, 0xaf, 0x5c, 0x42, 0x32, 0x5f, 0xcb, 0xaa,
	0x6e, 0xec, 0x68, 0x98, 0x2c, 0x6d, 0x7b, 0xf7, 0xcb, 0x7f, 0x0e, 0x8c, 0x2f, 0x5f, 0x0f, 0x8c,
	0x7f, 0x7e, 0x3d, 0x30, 0xfe, 0xfd, 0xf5, 0xc0, 0xf8, 0xdb, 0x7f, 0x0f, 0x1e, 0x5c, 0x95, 0x85,
	0xe6, 0xcb, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x91, 0x3f, 0x90, 0x81, 0xa3, 0x0e, 0x00, 0x00,
}
