# CLI Docs

## teleport

The Teleport daemon is called `teleport` . It can be configured to run one or
more "roles" with the `--roles` flags. The arguments to `--roles` correspond to
the following services.

| Service | Role Name | Description
| ------- | --------- | ----------- |
| [Node](architecture/teleport_nodes.md) | `node` | Runs a daemon on a node which allows SSH connections from authenticated clients.
| [Auth](architecture/teleport_auth.md) | `auth` | Authenticates nodes and users who want access to Teleport Nodes or information about the cluster
| [Proxy](architecture/teleport_proxy.md) | `proxy` | The gateway that clients use to connect to the Auth or Node Services

## teleport start

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `-d, --debug` | none | none | enable verbose logging to stderr
| `--insecure-no-tls` | `false` | `true` or `false` | Tells proxy to not generate default self-signed TLS certificates. This is useful when running Teleport on kubernetes (behind reverse proxy) or behind things like AWS ELBs, GCP LBs or Azure Load Balancers where SSL termination is provided externally.
| `-r, --roles` | `proxy,node,auth` | **string** comma-separated list of `proxy, node` or `auth` | start listed services/roles. These roles are explained in the [Teleport Architecture](architecture/teleport_architecture_overview.md) document.
| `--pid-file` | none | **string** filepath | create a PID file at the path
| `--advertise-ip` | none | **string** IP | advertise IP to clients, often used behind NAT
| `-l, --listen-ip` | `0.0.0.0` | [**net. IP**](https://golang.org/pkg/net/#IP) | binds services to IP
| `--auth-server` | none | **string** IP | proxy attempts to connect to a specified auth server instead of local auth, disables `--roles=auth` if set
| `--token` | none | **string** | set invitation token to register with an auth server on start, used once and ignored afterwards. Obtain it by running `tctl nodes add` on the auth server._We recommend to use tools like `pwgen` to generate sufficiently random tokens of 32+ byte length._
| `--ca-pin` | none | **string** `sha256:<hash>` | set CA pin to validate the Auth Server. Generated by `tctl status`
| `--nodename` | `hostname` command on the machine | **string** | assigns an alternative name for the node which can be used by clients to login. By default it's equal to the value returned by
| `-c, --config` | `/etc/teleport.yaml` | **string** `.yaml` filepath | starts services with config specified in the YAML file, overrides CLI flags if set
| `--bootstrap` | none | **string** `.yaml` filepath | bootstrap configured YAML resources <!--TODO link how to configure this file-->
| `--labels` | none | **string** comma-separated list | assigns a set of labels to a node. See the explanation of labeling mechanism in the [Labeling Nodes](admin-guide.md#labeling-nodes) section.
| `--insecure` | none | none | disable certificate validation on Proxy Service, validation still occurs on Auth Service.
| `--fips` | none | none | start Teleport in FedRAMP/FIPS 140-2 mode.
| `--diag-addr` | none | none | Enable diagnostic endpoints
| `--permit-user-env` | none | none | flag reads in environment variables from `~/.tsh/environment` when creating a session.

!!! warning "Token Generation"
    
    We recommend the use of tools like `pwgen` to generate sufficiently random tokens of 32+ byte length.

## teleport status

`teleport status` shows the status of a Teleport connection. This command is
only available from inside of a recorded SSH session.

## teleport configure

`teleport configure` dumps a **sample** configuration file in YAML format into
standard output.

**Caution**: This sample config is _not_ the default config and should be used
for reference only.<!--TODO Link to Config Doc-->

## teleport version

`teleport version` show the release version

## teleport help

`teleport help` shows help `teleport` and its subcommands like this `teleport
help <subcommand>`

# tsh

`tsh` is a CLI client used by Teleport Users. It allows users to interact with
current and past sessions on the cluster, copy files to and from nodes, and list
information about the cluster.

## tsh Global Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `-l, --login` | none | an identity name | the login identity that the Teleport User should use
| `--proxy` | none | `host:https_port[,ssh_proxy_port]` | set SSH proxy address
| `--user` | `$USER` | none | the Teleport User name
| `--ttl` | none | relative duration like 5s, 2m, or 3h | set time to live for a SSH session, session ttl unrestricted if unset <!--TODO Check this-->
| `-i, --identity` | none | **string** filepath | Identity file
| `--cert-format` | `file` | `file` or `openssh` | SSH certificate format
| `--insecure` | none | none | Do not verify server's certificate and host name. Use only in test environments
| `--auth` | `local` | any defined [authentication connector](admin-guide.md#authentication) |  Specify the type of authentication connector to use.
| `--skip-version` | none | none | Skip version checking between server and client.
| `-d, --debug` | none | none | Verbose logging to stdout
| `-J, --jumphost` | none | A jump host | SSH jumphost

## tsh help

Prints help

**Usage** `tsh help`

## tsh version

Prints client version

**Usage** `tsh version`

## tsh ssh

Run shell or execute a command on a remote SSH node

**Usage**: `tsh ssh [<flags>] <[user@]host> [<command>...]`

### Arguments

`<[user@]host> [<command>...]`

* `user` The login identity to use on the remote host. If `[user]` is not specified 
   the user defaults to `$USER` or can be set with `--user` . If the flag `--user` 
   and positional argument `[user]` are specified the arg `[user]` takes precedence.

* `host` A `nodename` of a cluster node or a
* `command` The command to execute on a remote host.

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `-p, --port` | none | port | SSH port on a remote host
| `-A, --forward-agent` | none | none | Forward agent to target node like `ssh -A`
| `-L, --forward` | none | none | Forward localhost connections to remote server
| `-D, --dynamic-forward ` | none | none | Forward localhost connections to remote server using SOCKS5
| `--local` | none |  | Execute command on localhost after connecting to SSH node
| `-t, --tty` | `file` |  | Allocate TTY
| `--cluster` | none |  | Specify the cluster to connect
| `-o, --option` | `local` |  |  OpenSSH options in the format used in the configuration file

### [Global Flags](#tsh-global-flags)

These flags are available for all commands `--login, --proxy, --user, --ttl,
--identity, --cert-format, --insecure, --auth, --skip-version, --debug,
--jumphost `. Run ` tsh help <subcommand>` or see the [Global Flags
Section](#tsh-global-flags)

### Examples

```
# Log in to node `grav-00` as OS User `root` with Teleport User `teleport`
$ tsh ssh --proxy proxy.example.com --user teleport -d root@grav-00
# `tsh ssh` takes the same arguments as OpenSSH client:
$ tsh ssh -o ForwardAgent=yes root@grav-00
$ tsh ssh -o AddKeysToAgent=yes root@grav-00
```

## tsh join

Joins an active session

**Usage**: `tsh join [<flags>] <session-id>`

### Arguments

`<session-id>`

* `session-id` The UUID of the an active Teleport Session obtained by `teleport status` within 
    the session.

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--cluster` | none | a cluster_name | Specify the cluster to connect

### [Global Flags](#tsh-global-flags)

These flags are available for all commands `--login, --proxy, --user, --ttl,
--identity, --cert-format, --insecure, --auth, --skip-version, --debug,
--jumphost `. Run ` tsh help <subcommand>` or see the [Global Flags
Section](#tsh-global-flags)

### Examples

```
tsh --proxy proxy.example.com join <session-id>
```

## tsh play

Plays back a prior session

**Usage**: `tsh play [<flags>] <session-id>`

### Arguments

`<session-id>`

* `session-id` The UUID of the a past Teleport Session obtained by `teleport status` within
     the session or from the Web UI.

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--cluster` | none | a cluster_name | Specify the cluster to connect

### [Global Flags](#tsh-global-flags)

These flags are available for all commands `--login, --proxy, --user, --ttl,
--identity, --cert-format, --insecure, --auth, --skip-version, --debug,
--jumphost `. Run ` tsh help <subcommand>` or see the [Global Flags
Section](#tsh-global-flags)

### Examples

```
tsh --proxy proxy.example.com play <session-id>
```

## tsh scp

Copies files from source to dest

**Usage** `usage: tsh scp [<flags>] <source>... <dest>`
<!--TODO Confirm which flags are supported, and whether supports multiple sources-->

### Arguments

* `<source>` - filepath to copy
* `<dest>` - target destination

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--cluster` | none | a cluster_name | Specify the cluster to connect
| `-r, --recursive` | none | none | Recursive copy of subdirectories
| `-P, --port` | none | port number | Port to connect to on the remote host
| `-q, --quiet` | none | none | Quiet mode

### [Global Flags](#tsh-global-flags)

These flags are available for all commands `--login, --proxy, --user, --ttl,
--identity, --cert-format, --insecure, --auth, --skip-version, --debug,
--jumphost `. Run ` tsh help <subcommand>` or see the [Global Flags
Section](#tsh-global-flags)

### Examples

``` bsh
$ tsh --proxy=proxy.example.com scp -P example.txt user@host/destination/dir
```

## tsh ls

List cluster nodes

**Usage** `usage: tsh ls [<flags>] [<label>]` <!--TODO: label? or labels? seems
like it only supports one label at a time-->

### Arguments

* `<label>` - `key=value` label to filer nodes by

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `-v, --verbose` | none | none | also print Node ID

### [Global Flags](#tsh-global-flags)

These flags are available for all commands `--login, --proxy, --user, --ttl,
--identity, --cert-format, --insecure, --auth, --skip-version, --debug,
--jumphost `. Run ` tsh help <subcommand>` or see the [Global Flags
Section](#tsh-global-flags)

### Examples

``` bsh
$ tsh ls
Node Name Address            Labels
--------- ------------------ ------
grav-00   10.164.0.0:3022    os:linux
grav-01   10.156.0.2:3022    os:linux
grav-02   10.156.0.7:3022    os:osx
$ tsh ls -v
Node Name Node ID                              Address            Labels
--------- ------------------------------------ ------------------ ------
grav-00   52e3e46a-372f-494b-bdd9-a1d25b9d6dec 10.164.0.0:3022    os:linux
grav-01   73d86fc7-7c4b-42e3-9a5f-c46e177a29e8 10.156.0.2:3022    os:linux
grav-02  24503590-e8ae-4a0a-ad7a-dd1865c04e30 10.156.0.7:3022     os:osx

# only show nodes with os label set to 'osx':
$ tsh ls os=osx
Node Name Address            Labels
--------- ------------------ ------
grav-02      10.156.0.7:3022    os:osx
```

## tsh clusters

**Usage**: `tsh clusters [<flags>]`

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `-q, --quiet` | none | none | no headers in output

### [Global Flags](#tsh-global-flags)

These flags are available for all commands `--login, --proxy, --user, --ttl,
--identity, --cert-format, --insecure, --auth, --skip-version, --debug,
--jumphost `. Run ` tsh help <subcommand>` or see the [Global Flags
Section](#tsh-global-flags)

### Examples

``` bsh
$ tsh clusters
Cluster Name Status
------------ ------
staging          online
production       offline
$ tsh clusters --quiet
staging online
production offline
```

## tsh login

Logs in to the cluster. When `tsh` logs in, the auto-expiring key is stored in
`~/.tsh` and is valid for 12 hours by default, unless you specify another
interval via `--ttl` flag (capped by the server-side configuration).

**Usage**: `tsh login [<flags>] [<cluster>]`

### Arguments

* `<cluster>` - the name of the cluster,  see [Trusted Cluster](trustedclusters.md#introduction ) for more information. 

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--bind-addr` | none | host:port | Address in the form of host:port to bind to for login command webhook
| `-o, --out` | none | filepath | Identity output filepath
| `--format` | `file` | `file` or `openssh` | Identity format

### [Global Flags](#tsh-global-flags)

These flags are available for all commands `--login, --proxy, --user, --ttl,
--identity, --cert-format, --insecure, --auth, --skip-version, --debug,
--jumphost `. Run ` tsh help <subcommand>` or see the [Global Flags
Section](#tsh-global-flags)

### Examples

_The proxy endpoint can take a https and ssh port in this format
`host:https_port[,ssh_proxy_port]` _

``` bsh
# Use ports 8080 and 8023 for https and SSH proxy:
$ tsh --proxy=proxy.example.com:8080,8023 login

# Use port 8080 and 3023 (default) for SSH proxy:
$ tsh --proxy=proxy.example.com:8080 login

# Use port 23 as custom SSH port, keep HTTPS proxy port as default
$ tsh --proxy=work.example.com:,23 login

# Login and select cluster "two":
$ tsh --proxy=proxy.example.com login two

# Select cluster "two" using existing credentials and proxy:
$ tsh login two

# Login to the  cluster with a very short-lived certificate
$ tsh --ttl=1 login

# Login using the local Teleport 'admin' user:
$ tsh --proxy=proxy.example.com --auth=local --user=admin login

# Login using Github as an SSO provider, assuming the Github connector is called "github"
$ tsh --proxy=proxy.example.com --auth=github --user=admin login
```

## tsh logout

Deletes the client's cluster certificate

**Usage**: `tsh logout`

## tsh status

Display the list of proxy servers and retrieved certificates

**Usage**: `tsh status`

### Examples

``` bash
$ tsh status

> Profile URL:  https://proxy.example.com:3080
  Logged in as: johndoe
  Roles:        admin*
  Logins:       root, admin, guest
  Valid until:  2017-04-25 15:02:30 -0700 PDT [valid for 1h0m0s]
  Extensions:   permit-agent-forwarding, permit-port-forwarding, permit-pty
```

# tctl

`tctl` is an admin CLI tool used to administer a Teleport cluster. It connects
to an Auth Server, meaning that it must be run on the same host with the role
`auth` . If you run `tctl` on a non- `auth` node it will show an error.

`tctl` allows a cluster administrator to manage all resources in a cluster
including nodes, users, tokens, and certificates.

`tctl` can also be used to modify the dynamic configuration of the cluster, like
creating new user roles or connecting trusted clusters.

## tctl Global Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `-d, --debug` | none | none | Enable verbose logging to stderr
`-c, --config` | `/etc/teleport.yaml` | **string** filepath | Path to a configuration file

## tctl  help

Shows help.

**Usage** `tctl help`

## tctl users add

Generates a user invitation token.

**Usage:** `tctl users add [<flags>] <account> [<local-logins>]`

### Arguments

* `<account>` - The Teleport user account name.
* `<local-logins>` - A comma-separated list of local UNIX users this account can
  log in as. If unspecified the account will be mapped to an OS user of the same
  name. See examples below.

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--k8s-groups` | none | a kubernetes group | Kubernetes groups to assign to a user.e.g. `system:masters`
| `--ttl` | 1h | relative duration like 5s, 2m, or 3h, **maximum 48h** | Set expiration time for token

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help
<subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

``` bsh
# Adds teleport user "joe" with mappings to
# OS users "joe" and "root"
tctl users add joe joe,root
# Adds teleport user "joe" with mappings to
# OS users "joe" only
tctl users add joe
```

## tctl users ls

Lists all user accounts **Usage:** `tctl users ls [<flags>]`

## tctl users rm

Deletes user accounts **Usage**: `tctl users rm <logins>`

### Arguments

* `<logins>` - comma-separated list of Teleport users

### Examples

``` bsh
tctl users rm sally,tim
# Removes users sally and tim
```

## tctl nodes add

Generate a node invitation token

**Usage**: `tctl nodes add [<flags>]`

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--roles` | `node` | `node,auth` or ` proxy` | Comma-separated list of roles for the new node to assume
| `--ttl` | 30m | relative duration like 5s, 2m, or 3h | Time to live for a generated token
| `--token` | none | **string** token value | A custom token to use, auto-generated if not provided. Should match token set with `teleport start --token`

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help
<subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

``` bsh
# Generates a token which can be used by a node to join the cluster, default ttl is 30 minutes
$ tctl nodes add
# Generates a token which can be used to add an SSH node to the cluster
# The node will run the proxy service in addition is the node (ssh) service.
# This token can be used within an hour.
$ tctl nodes add --roles=node,proxy --ttl=1h
```

## tctl nodes ls

List all active SSH nodes within the cluster

**Usage**: `tctl nodes ls [<flags>]`

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--namespace` | none | **string** namespace | Namespace of the nodes

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help
<subcommand>` or see the [Global Flags Section](#tctl-global-flags)

## tctl tokens add

Create an invitation token

**Usage**: `tctl tokens add --type=TYPE [<flags>]`

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
| `--type` | none | `trusted_cluster` , `node` , `signup` <!--TODO Confirm this.are any other types valid in /Users/heather/teleport/roles.go--> | Type of token to add
| `--value` | none | **string** token value | Value of token to add
| `--ttl` | 1h | relative duration like 5s, 2m, or 3h, **maximum 48h** | Set expiration time for token

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help
<subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

``` bash
# Generate an invite token for a trusted_cluster
$ tctl tokens add --type=trusted_cluster --ttl=5m
# Generate an invite token for a node
# This is equivalent to `tctl nodes add`
$ tctl tokens add --type node
```

## tctl tokens rm

Delete/revoke an invitation token

**Usage**: `tctl tokens rm [<token>]`

### Arguments

* `<token>` The full-length token string to delete

## tctl tokens ls

List node and user invitation tokens

**Usage**: `tctl tokens ls [<flags>]`

### Example

``` bsh
$ tctl tokens ls
Token                            Type            Expiry Time (UTC)
-------------------------------- --------------- -------------------
ecce46d19bb4144716e5984269db1ac0 Node            11 Oct 19 22:17 UTC
fcbf269ca26440f35865ec29994f0fb4 trusted_cluster 11 Oct 19 22:19 UTC
6fd001d4200348deec9b50c4479ba07d User signup     11 Oct 19 22:20 UTC
```

## tctl auth export

Export public cluster (CA) keys to stdout

**Usage**: `tctl auth export [<flags>]`

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
`--keys` | none | none | if set, will print private keys
`--fingerprint` | none | **string** e.g. `SHA265:<fingerprint>` |  filter authority by fingerprint
`--compat` | none | version number | export certificates compatible with specific version of Teleport
`--type` | none | `user, host` or `tls` | certificate type

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help
<subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

``` bsh
# Export all keys
$ tctl auth export
# Filter by fingerprint
$ tctl auth export --fingerprint=SHA256:8xu5kh1CbHCZRrGuitbQd4hM+d9V+I7YA1mUwA/2tAo
# Export tls certs only
$ tctl auth export --type tls
```

## tctl auth sign

Create an identity file(s) for a given user

**Usage**: `tctl auth sign -o <filepath> [--user <user> | --host
<host>][--format] [<flags>]`

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
`--user` | none | existing user | Teleport user name
`--host` | none | auth host | Teleport host name
`-o, --out` | none | filepath | identity output
`--format` | `file` | `file` or `openssh` |  identity format
`--ttl` | none | relative duration like 5s, 2m, or 3h | TTL (time to live) for the generated certificate
`--compat` | `""` | `standard` or `oldssh` | OpenSSH compatibility flag

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help
<subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

``` bash
# Export identity file to teleport_id.pem
# for user `teleport` with a ttl set to 5m
$ tctl auth sign --format file --ttl=5m --user teleport -o teleport_id.pem
# Export identity formatted for openssh to teleport_id.pem
$ tctl auth sign --format openssh --user teleport -o teleport_id.pem
# Export host identity, `--format openssh` must be set with `--host`
# Generates grav-01 (private key) and grav-01-cert.pub in the current directory
$ tctl auth sign --format openssh --host grav-00
# Invalid command, only one of --user or --host should be set
$ tctl auth sign --format openssh --host grav-00 --user teleport -o grav_host
error: --user or --host must be specified
# create a certificate with a TTL of 10 years for the jenkins user
# the jenkins.pem file can later be used with `tsh`
$ tctl auth sign --ttl=87600h --user=jenkins --out=jenkins.pem
```


## tctl auth rotate

Rotate certificate authorities in the cluster

**Usage**: `tctl auth rotate [<flags>]`

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
`--grace-period` | none | relative duration like 5s, 2m, or 3h |  Grace period keeps previous certificate authorities signatures valid, if set to 0 will force users to login again and nodes to re-register.
`--manual` | none | none | Activate manual rotation, set rotation phases manually
`--type` | `user,host` | `user` or `host` | Certificate authority to rotate
`--phase` | | `init, standby, update_clients, update_servers, rollback` | Target rotation phase to set, used in manual rotation

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help <subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

```bsh
# rotate only user certificates with a grace period of 200 hours:
$ tctl auth rotate --type=user --grace-period=200h

# rotate only host certificates with a grace period of 8 hours:
$ tctl auth rotate --type=host --grace-period=8h
```

## tctl create

Create or update a Teleport resource from a YAML file.

The supported resource types are: user, node, cluster, role, connector.
See the [Resource Guide](admin-guide.md#resources) for complete docs on how to build these yaml files.

**Usage**: `tctl create [<flags>] <filename>`

### Arguments

* `<filename>` resource definition file

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
`-f, --force` | none | none | Overwrite the resource if already exists

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help <subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

``` bsh
# Update a user record
$ tctl create -f joe.yaml
# Add a trusted cluster
$ tctl create cluster.yaml $ Update a trusted cluster $ tctl create -f
cluster.yaml
```

## tctl rm

Delete a resource

**Usage**: `tctl rm [<resource-type/resource-name>]`

### Arguments

* `[<resource-type/resource-name>]` Resource to delete
    - `<resource type>` Type of a resource [for example: `connector,user,cluster,token` ]
    - `<resource name>` Resource name to delete

### Examples

``` bsh
# delete a connector called "okta":
$ tctl rm connectors/okta

# delete a local user called "admin":
$ tctl rm users/admin
```

## tctl get

Print a YAML declaration of various Teleport resources

**Usage**: `tctl get [<flags>] [<resource-type/resource-name>],...`

### Arguments

* `[<resource-type/resource-name>]` Resource to delete
    - `<resource type>` Type of a resource [for example: `user,cluster,token` ]
    - `<resource name>` Resource name to delete

### Flags

| Name | Default Value(s) | Allowed Value(s) | Description
|------|---------|----------------|----------------------------|
`--format` | | `yaml, json` or `text` | Output format
`--with-secrets` | none | none |  Include secrets in resources like certificate authorities or OIDC connectors

### [Global Flags](#tctl-global-flags)

These flags are available for all commands `--debug, --config` . Run `tctl help <subcommand>` or see the [Global Flags Section](#tctl-global-flags)

### Examples

``` bsh
$ tctl get users
# dump the user definition into a file:
$ tctl get user/joe > joe.yaml
# prints the trusted cluster 'east'
$ tctl get cluster/east
# prints all trusted clusters and all users
$ tctl get clusters,users
# Dump all resources for backup into state.yaml
$ tctl get all > state.yaml
```

## tctl status

Report cluster status

**Usage** `tctl status`

### Examples

```
$ tctl status Cluster  grav-00 User CA  never updated Host CA  never updated CA
pin   sha256:1146cdd2b887772dcc2e879232c8f60012a839f7958724ce5744005474b15b9d
```

## tctl top

Reports diagnostic information.

The diagnostic metrics endpoint must be enabled with `teleport start --diag-addr=<bind-addr>` for `tctl top` to work.

**Usage** `tctl top [<diag-addr>] [<refresh>]`

### Argument

* `[<diag-addr>]` Diagnostic HTTP URL (HTTPS not supported)
* `[<refresh>]` Refresh period e.g.5s, 2m, or 3h

### Example

``` bsh
$ teleport start --diag-addr=127.0.0.1:3434
# View stats with refresh period of 5 seconds
$ tctl top http://127.0.0.1:3434 5s
```

## tctl version

Print cluster version

**Usage:** `tctl version`

