# logs

## Description

Auditログ

<details>
<summary><strong>Table Definition</strong></summary>

```sql
CREATE TABLE `logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `post_id` bigint DEFAULT NULL,
  `comment_id` bigint DEFAULT NULL,
  `comment_star_id` bigint DEFAULT NULL,
  `payload` text,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Auditログ'
```

</details>

## Columns

| Name | Type | Default | Nullable | Extra Definition | Children | Parents | Comment |
| ---- | ---- | ------- | -------- | ---------------- | -------- | ------- | ------- |
| id | bigint |  | false | auto_increment |  |  |  |
| user_id | int |  | false |  |  | [users](users.md) |  |
| post_id | bigint |  | true |  |  | [posts](posts.md) |  |
| comment_id | bigint |  | true |  |  | [comments](comments.md) |  |
| comment_star_id | bigint |  | true |  |  | [comment_stars](comment_stars.md) |  |
| payload | text |  | true |  |  |  |  |
| created | datetime |  | false |  |  |  |  |

## Constraints

| Name | Type | Definition |
| ---- | ---- | ---------- |
| PRIMARY | PRIMARY KEY | PRIMARY KEY (id) |

## Indexes

| Name | Definition |
| ---- | ---------- |
| PRIMARY | PRIMARY KEY (id) USING BTREE |

## Relations

```mermaid
erDiagram

"logs" }o--|| "users" : "logs-&gt;users"
"logs" }o--o| "posts" : "Additional Relation"
"logs" }o--o| "comments" : "Additional Relation"
"logs" }o--o| "comment_stars" : "Additional Relation"

"logs" {
  bigint id PK
  int user_id
  bigint post_id
  bigint comment_id
  bigint comment_star_id
  text payload
  datetime created
}
"users" {
  int id PK
  varchar_50_ username
  varchar_50_ password
  varchar_355_ email
  timestamp created
  timestamp updated
}
"posts" {
  bigint id PK
  int user_id FK
  varchar_255_ title
  text body
  enum__public___private___draft__ post_type
  datetime created
  datetime updated
}
"comments" {
  bigint id PK
  bigint post_id FK
  int user_id FK
  text comment
  bigint post_id_desc
  datetime created
  datetime updated
}
"comment_stars" {
  bigint id PK
  int user_id
  bigint comment_post_id FK
  int comment_user_id FK
  timestamp created
  timestamp updated
}
```

---

> Generated by [tbls](https://github.com/k1LoW/tbls)
