// Copyright (c) 2022 Tailscale Inc & AUTHORS All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by tailscale/cmd/viewer; DO NOT EDIT.

package ipn

import (
	"encoding/json"
	"errors"
	"net/netip"

	"tailscale.com/tailcfg"
	"tailscale.com/types/persist"
	"tailscale.com/types/preftype"
	"tailscale.com/types/views"
)

//go:generate go run tailscale.com/cmd/cloner  -clonefunc=false -type=Prefs

// View returns a readonly view of Prefs.
func (p *Prefs) View() PrefsView {
	return PrefsView{ж: p}
}

// PrefsView provides a read-only view over Prefs.
//
// Its methods should only be called if `Valid()` returns true.
type PrefsView struct {
	// ж is the underlying mutable value, named with a hard-to-type
	// character that looks pointy like a pointer.
	// It is named distinctively to make you think of how dangerous it is to escape
	// to callers. You must not let callers be able to mutate it.
	ж *Prefs
}

// Valid reports whether underlying value is non-nil.
func (v PrefsView) Valid() bool { return v.ж != nil }

// AsStruct returns a clone of the underlying value which aliases no memory with
// the original.
func (v PrefsView) AsStruct() *Prefs {
	if v.ж == nil {
		return nil
	}
	return v.ж.Clone()
}

func (v PrefsView) MarshalJSON() ([]byte, error) { return json.Marshal(v.ж) }

func (v *PrefsView) UnmarshalJSON(b []byte) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	if len(b) == 0 {
		return nil
	}
	var x Prefs
	if err := json.Unmarshal(b, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

func (v PrefsView) ControlURL() string                 { return v.ж.ControlURL }
func (v PrefsView) RouteAll() bool                     { return v.ж.RouteAll }
func (v PrefsView) AllowSingleHosts() bool             { return v.ж.AllowSingleHosts }
func (v PrefsView) ExitNodeID() tailcfg.StableNodeID   { return v.ж.ExitNodeID }
func (v PrefsView) ExitNodeIP() netip.Addr             { return v.ж.ExitNodeIP }
func (v PrefsView) ExitNodeAllowLANAccess() bool       { return v.ж.ExitNodeAllowLANAccess }
func (v PrefsView) CorpDNS() bool                      { return v.ж.CorpDNS }
func (v PrefsView) RunSSH() bool                       { return v.ж.RunSSH }
func (v PrefsView) WantRunning() bool                  { return v.ж.WantRunning }
func (v PrefsView) LoggedOut() bool                    { return v.ж.LoggedOut }
func (v PrefsView) ShieldsUp() bool                    { return v.ж.ShieldsUp }
func (v PrefsView) AdvertiseTags() views.Slice[string] { return views.SliceOf(v.ж.AdvertiseTags) }
func (v PrefsView) Hostname() string                   { return v.ж.Hostname }
func (v PrefsView) NotepadURLs() bool                  { return v.ж.NotepadURLs }
func (v PrefsView) ForceDaemon() bool                  { return v.ж.ForceDaemon }
func (v PrefsView) Egg() bool                          { return v.ж.Egg }
func (v PrefsView) AdvertiseRoutes() views.IPPrefixSlice {
	return views.IPPrefixSliceOf(v.ж.AdvertiseRoutes)
}
func (v PrefsView) NoSNAT() bool                          { return v.ж.NoSNAT }
func (v PrefsView) NetfilterMode() preftype.NetfilterMode { return v.ж.NetfilterMode }
func (v PrefsView) OperatorUser() string                  { return v.ж.OperatorUser }
func (v PrefsView) Persist() *persist.Persist {
	if v.ж.Persist == nil {
		return nil
	}
	x := *v.ж.Persist
	return &x
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _PrefsViewNeedsRegeneration = Prefs(struct {
	ControlURL             string
	RouteAll               bool
	AllowSingleHosts       bool
	ExitNodeID             tailcfg.StableNodeID
	ExitNodeIP             netip.Addr
	ExitNodeAllowLANAccess bool
	CorpDNS                bool
	RunSSH                 bool
	WantRunning            bool
	LoggedOut              bool
	ShieldsUp              bool
	AdvertiseTags          []string
	Hostname               string
	NotepadURLs            bool
	ForceDaemon            bool
	Egg                    bool
	AdvertiseRoutes        []netip.Prefix
	NoSNAT                 bool
	NetfilterMode          preftype.NetfilterMode
	OperatorUser           string
	Persist                *persist.Persist
}{})
