// Copyright (c) 2022 Tailscale Inc & AUTHORS All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by tailscale.com/cmd/cloner; DO NOT EDIT.

package ipn

import (
	"net/netip"

	"tailscale.com/tailcfg"
	"tailscale.com/types/persist"
	"tailscale.com/types/preftype"
)

// Clone makes a deep copy of Prefs.
// The result aliases no memory with the original.
func (src *Prefs) Clone() *Prefs {
	if src == nil {
		return nil
	}
	dst := new(Prefs)
	*dst = *src
	dst.AdvertiseTags = append(src.AdvertiseTags[:0:0], src.AdvertiseTags...)
	dst.AdvertiseRoutes = append(src.AdvertiseRoutes[:0:0], src.AdvertiseRoutes...)
	if dst.Persist != nil {
		dst.Persist = new(persist.Persist)
		*dst.Persist = *src.Persist
	}
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _PrefsCloneNeedsRegeneration = Prefs(struct {
	ControlURL             string
	RouteAll               bool
	AllowSingleHosts       bool
	ExitNodeID             tailcfg.StableNodeID
	ExitNodeIP             netip.Addr
	ExitNodeAllowLANAccess bool
	CorpDNS                bool
	RunSSH                 bool
	WantRunning            bool
	LoggedOut              bool
	ShieldsUp              bool
	AdvertiseTags          []string
	Hostname               string
	NotepadURLs            bool
	ForceDaemon            bool
	AdvertiseRoutes        []netip.Prefix
	NoSNAT                 bool
	NetfilterMode          preftype.NetfilterMode
	OperatorUser           string
	Persist                *persist.Persist
}{})
