/*
 * Copyright (c) 2021-present Fabien Potencier <fabien@symfony.com>
 *
 * This file is part of Symfony CLI project
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package html

import (
	"fmt"
	"strings"
)

func CreateAction(url, text string, args ...interface{}) string {
	text = strings.Replace(text, "\n", "<br>", -1)
	text = fmt.Sprintf(text, args...)
	return fmt.Sprintf(`<div style="text-align: center"><span class="button"><a href="%s">%s</a></span></div>`, url, text)
}

func CreateErrorTerminal(text string, args ...interface{}) string {
	return doCreateTerminal(text, "#dc322f", args...)
}

func CreateSuccessTerminal(text string, args ...interface{}) string {
	return doCreateTerminal(text, "#859900", args...)
}

func CreateTerminal(text string, args ...interface{}) string {
	return doCreateTerminal(text, "#073642", args...)
}

func doCreateTerminal(text string, color string, args ...interface{}) string {
	text = strings.Replace(text, "\n", "<br>", -1)
	text = fmt.Sprintf(text, args...)
	return fmt.Sprintf(`
<div style="background-color:%s;padding:20px" class="terminal">
	<div id="prompt">
		<code>%s</code>
	</div>
</div>`,
		color, text)
}

func WrapHTML(title, html, redirect string) string {
	if redirect != "" {
		redirect = fmt.Sprintf(`<meta http-equiv="refresh" content="3; url=%s" />`, redirect)
	}
	return fmt.Sprintf(`<html><head><title>Symfony Local Web Server: %s</title><style>%s</style>%s</head><body>
<div style="margin: 30px 0 15px 0">
	<svg width="200px" viewBox="0 0 78 15" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
		<g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
			<g id="sf-localserver_logo_positif">
				<g id="Group" transform="translate(0.791075, 0.107030)">
					<path d="M12.9191653,0.0188808494 C13.7105316,0.0188808494 14.3530236,0.661372832 14.3530236,1.45270725 L14.3530236,12.923574 C14.3530236,13.7149404 13.7105316,14.3574004 12.9191653,14.3574004 L1.44833047,14.3574004 C0.656964106,14.3574004 0.0144721231,13.7149404 0.0144721231,12.923574 L0.0144721231,1.45270725 C0.0144721231,0.661372832 0.656964106,0.0188808494 1.44833047,0.0188808494 L12.9191653,0.0188808494 Z M23.2995751,8.52353742 C23.2995751,10.2337718 24.5412705,11.6511773 26.3452382,11.6511773 C28.1374813,11.6511773 29.3791447,10.2337718 29.3791447,8.52353742 C29.3791447,6.70787699 28.1608987,5.39589756 26.3452382,5.39589756 C24.5178531,5.39589756 23.2995751,6.70787699 23.2995751,8.52353742 Z M34.318196,5.63016705 C34.0019178,5.50132363 33.4279528,5.39589756 32.9827992,5.39589756 C31.1554141,5.39589756 29.9371681,6.70787699 29.9371681,8.52353742 C29.9371681,10.2337718 31.1788635,11.6511773 32.9827992,11.6511773 C33.3810861,11.6511773 33.9082164,11.6160353 34.3650627,11.4051831 C34.3650627,11.4051831 34.355798,11.2941024 34.3435302,11.1466017 C34.3305277,10.9908587 34.2492538,10.848853 34.1215285,10.7587936 C33.9938032,10.6687342 33.8327569,10.6398219 33.6816782,10.6798838 C33.4827424,10.7337469 33.2804841,10.7609021 33.0999499,10.7609021 C31.6825445,10.7609021 31.1085794,9.5895227 31.1085794,8.52353742 C31.1085794,7.38726809 31.7996952,6.28617274 33.0296659,6.28617274 C33.1567522,6.28617274 33.4058453,6.33393394 33.6446513,6.38881939 C33.7921519,6.42245989 33.9470324,6.39127933 34.0699656,6.3031048 C34.1929307,6.21493028 34.27216,6.07825977 34.2875905,5.92775607 C34.3045545,5.76322752 34.318196,5.63016705 34.318196,5.63016705 Z M35.5645557,6.20317368 C35.5731176,6.34016366 35.6488646,6.46405526 35.766846,6.53411567 C35.8848593,6.60420803 36.029868,6.61146006 36.1542388,6.55344378 C36.5212813,6.38358003 36.9411326,6.28617274 37.341496,6.28617274 C38.4425914,6.28617274 38.8174609,6.81330305 38.8174609,7.84411436 C38.384032,7.820697 38.0794785,7.820697 37.6460496,7.820697 C36.5097802,7.820697 34.8698299,8.28926793 34.8698299,9.78865017 C34.8698299,11.0889049 35.7717978,11.6511773 37.0603599,11.6511773 C38.0677538,11.6511773 38.6534435,11.1006296 38.9111623,10.7374847 L38.9345797,10.7374847 L38.9345797,11.5106092 C38.9345797,11.5106092 39.1599359,11.5106092 39.399892,11.5106092 C39.5445493,11.5106092 39.6828811,11.4512831 39.7825886,11.346464 C39.882328,11.2416769 39.9346896,11.1005338 39.9275015,10.9560681 C39.9217829,10.7927535 39.9185563,10.5909106 39.9185563,10.3391978 L39.9185563,7.86756368 C39.9185563,6.23930606 39.2274405,5.39589756 37.5172061,5.39589756 C36.7557744,5.39589756 36.0998006,5.63016705 35.549253,5.9581699 C35.549253,5.9581699 35.5558341,6.06330843 35.5645557,6.20317368 Z M50.1364822,3.48650378 C49.5742098,3.28737631 48.929833,3.19367491 48.3908822,3.19367491 C46.9150131,3.19367491 45.7670511,3.96679936 45.7670511,5.41931493 C45.7670511,7.96126508 49.2812532,7.45755214 49.2812532,9.28493722 C49.2812532,10.2454964 48.3442391,10.620334 47.6765407,10.620334 C47.3206479,10.620334 46.927185,10.5372072 46.5831447,10.4352953 C46.4328007,10.3903455 46.2702529,10.4145935 46.1395565,10.5014581 C46.0088921,10.5882909 45.9235928,10.7287951 45.9068205,10.8847937 C45.8821572,11.1125779 45.8607525,11.3114817 45.8607525,11.3114817 C46.3996075,11.4871918 46.9618798,11.6511773 47.5359726,11.6511773 C49.1758271,11.6511773 50.5230444,10.9600615 50.5230444,9.21465318 C50.5230444,6.52044223 47.0087465,6.88358709 47.0087465,5.31388886 C47.0087465,4.45878766 47.7819668,4.22448622 48.4378447,4.22448622 C48.8221706,4.22448622 49.094681,4.26649691 49.3937076,4.35639659 C49.5403457,4.40073943 49.6988043,4.3792389 49.8285103,4.29748578 C49.9578968,4.21570071 50.0457519,4.08174572 50.0687539,3.9303475 C50.1045349,3.69607801 50.1364822,3.48650378 50.1364822,3.48650378 Z M56.3246726,11.0267036 C56.3246726,10.8533576 56.2393733,10.6910653 56.0968884,10.5923801 C55.9544035,10.4936949 55.7726234,10.471236 55.6103311,10.5322553 C55.2681756,10.6606515 54.8611671,10.7609021 54.485467,10.7609021 C53.4430269,10.7609021 52.5175138,9.95263561 52.5175138,8.76953156 L56.7815188,8.76953156 C56.7815188,6.84844507 56.137142,5.39589756 54.1458673,5.39589756 C52.4590503,5.39589756 51.3460066,6.64928566 51.3460066,8.41811135 C51.3460066,10.3626472 52.3184822,11.6511773 54.4385045,11.6511773 C55.4224811,11.6511773 55.9029683,11.4169078 56.3246726,11.264615 C56.3246726,11.264615 56.3246726,11.1654826 56.3246726,11.0267036 Z M71.9095199,11.0267036 C71.9095199,10.8533576 71.8245401,10.6910653 71.6820551,10.5923801 C71.5395702,10.4936949 71.3574707,10.471236 71.1954979,10.5322553 C70.8530229,10.6606515 70.4460144,10.7609021 70.0703143,10.7609021 C69.0278742,10.7609021 68.1023611,9.95263561 68.1023611,8.76953156 L72.3663661,8.76953156 C72.3663661,6.84844507 71.7219893,5.39589756 69.7307146,5.39589756 C68.0438976,5.39589756 66.9311734,6.64928566 66.9311734,8.41811135 C66.9311734,10.3626472 67.9033295,11.6511773 70.0236712,11.6511773 C71.0076478,11.6511773 71.4878156,11.4169078 71.9095199,11.264615 C71.9095199,11.264615 71.9095199,11.1654826 71.9095199,11.0267036 Z M18.5202603,11.5106092 C18.5202603,11.5106092 21.3768913,11.5106092 22.5838919,11.5106092 C22.7240127,11.5106092 22.858383,11.454957 22.9574516,11.3558885 C23.0565201,11.2568199 23.1121723,11.1224496 23.1121723,10.9823607 C23.1121723,10.7289867 23.1121723,10.4797659 23.1121723,10.4797659 L19.6916716,10.4797659 C19.6916716,10.4797659 19.6916716,5.51550822 19.6916716,3.86249146 C19.6916716,3.57074879 19.4551658,3.33424299 19.1634232,3.33424299 C18.8527358,3.33424299 18.5202603,3.33424299 18.5202603,3.33424299 L18.5202603,11.5106092 Z M42.0537215,2.72510398 L42.0537215,10.9823607 C42.0537215,11.1224496 41.9980694,11.2568199 41.8990008,11.3558885 C41.7999323,11.454957 41.6655619,11.5106092 41.5254411,11.5106092 C41.2429312,11.5106092 40.9525942,11.5106092 40.9525942,11.5106092 L40.9525942,2.72510398 L42.0537215,2.72510398 Z M58.5660946,6.46188284 C58.8590512,5.84101918 59.4916076,5.39589756 60.124164,5.39589756 C60.4522627,5.39589756 60.6161523,5.43103958 60.8503259,5.47790626 C60.8503259,5.47790626 60.8503259,5.63831361 60.8503259,5.82958205 C60.8503259,5.9722267 60.7925013,6.10880138 60.69027,6.20822135 C60.5880386,6.30764132 60.4497069,6.36147251 60.307222,6.3574152 C60.2848588,6.35674431 60.2628152,6.35645678 60.2414105,6.35645678 C59.2574339,6.35645678 58.6130571,7.29356669 58.6130571,8.79294893 C58.6130571,8.79294893 58.6130571,10.1918569 58.6130571,10.9823607 C58.6130571,11.1224496 58.5574688,11.2568199 58.4584322,11.3558885 C58.3593956,11.454957 58.2248975,11.5106092 58.0846489,11.5106092 C57.8022348,11.5106092 57.5118339,11.5106092 57.5118339,11.5106092 L57.5118339,5.53646565 C57.5118339,5.53646565 57.7610228,5.53646565 58.0143648,5.53646565 C58.1546134,5.53646565 58.2891115,5.59211783 58.3881481,5.69118638 C58.4871847,5.79025493 58.542773,5.92462524 58.542773,6.06471411 C58.542773,6.27227567 58.542773,6.46188284 58.542773,6.46188284 L58.5660946,6.46188284 Z M64.1600653,10.4094819 L65.6903406,5.89513789 C65.762861,5.68073962 65.9641289,5.53646565 66.1906352,5.53646565 C66.5091497,5.53646565 66.9129634,5.53646565 66.9129634,5.53646565 L64.7693002,11.5106092 L63.4572249,11.5106092 L61.3135616,5.53646565 C61.3135616,5.53646565 61.7854231,5.53646565 62.1387602,5.53646565 C62.3665444,5.53646565 62.5687707,5.68230503 62.6403327,5.89839651 C63.0147549,7.02738185 64.1367438,10.4094819 64.1367438,10.4094819 L64.1600653,10.4094819 Z M74.119314,6.46188284 C74.4119512,5.84101918 75.0445076,5.39589756 75.677064,5.39589756 C76.0051627,5.39589756 76.1690523,5.43103958 76.4035454,5.47790626 C76.4035454,5.47790626 76.4035454,5.63831361 76.4032259,5.82958205 C76.4032259,5.9722267 76.3454013,6.10880138 76.24317,6.20822135 C76.1409386,6.30764132 76.0029263,6.36147251 75.860122,6.3574152 C75.8377588,6.35674431 75.8157152,6.35645678 75.7943105,6.35645678 C74.8103339,6.35645678 74.1659571,7.29356669 74.1659571,8.79294893 C74.1659571,8.79294893 74.1659571,10.1918569 74.1659571,10.9823607 C74.1659571,11.1224496 74.1103688,11.2568199 74.0113322,11.3558885 C73.9122956,11.454957 73.7777975,11.5106092 73.6378683,11.5106092 C73.3551348,11.5106092 73.0650534,11.5106092 73.0650534,11.5106092 L73.0650534,5.53646565 C73.0650534,5.53646565 73.3142423,5.53646565 73.5675843,5.53646565 C73.7075134,5.53646565 73.8420115,5.59211783 73.9410481,5.69118638 C74.0400847,5.79025493 74.095673,5.92462524 74.095673,6.06471411 C74.095673,6.27227567 74.095673,6.46188284 74.095673,6.46188284 L74.119314,6.46188284 Z M24.4709865,8.52353742 C24.4709865,7.38726809 25.1621022,6.28617274 26.3452382,6.28617274 C27.5166176,6.28617274 28.2077653,7.38726809 28.2077653,8.52353742 C28.2077653,9.5895227 27.6337683,10.7609021 26.3452382,10.7609021 C25.0449835,10.7609021 24.4709865,9.5895227 24.4709865,8.52353742 Z M38.8174609,9.19123581 C38.8174609,10.081511 38.2434639,10.7609021 37.1540613,10.7609021 C36.6503483,10.7609021 36.0412413,10.4212065 36.0412413,9.78865017 C36.0412413,8.73438954 37.5172061,8.64068814 38.1146205,8.64068814 C38.34889,8.64068814 38.5831595,8.6641055 38.8174609,8.6641055 L38.8174609,9.19123581 Z M55.6100117,7.94954043 C55.6100117,7.03584789 55.0710608,6.28617274 54.1222263,6.28617274 C53.0446441,6.28617274 52.5996184,7.17641597 52.5175138,7.94954043 L55.6100117,7.94954043 Z M71.194859,7.94954043 C71.194859,7.03584789 70.6562276,6.28617274 69.7073931,6.28617274 C68.6294914,6.28617274 68.1844657,7.17641597 68.1023611,7.94954043 L71.194859,7.94954043 Z" id="Shape" fill="#FFFFFF"></path>
					<g transform="translate(2.129318, 1.791591)" fill="#000000" id="Path">
						<path d="M8.68556719,0.0859776912 C7.88782304,0.11328331 7.19131972,0.553673927 6.67293306,1.16125895 C6.09895495,1.82849624 5.71723641,2.61923895 5.44179973,3.42692514 C4.94987851,3.0233621 4.57054046,2.50119466 3.78063792,2.27406792 C3.17039236,2.09861182 2.52948048,2.17072666 1.93995918,2.60999705 C1.66074172,2.81849995 1.46834213,3.13342475 1.37690332,3.43042586 C1.13997457,4.20044431 1.62573452,4.8861654 1.84655996,5.132056 L2.32937931,5.64890235 C2.42865973,5.75042324 2.66838906,6.01493766 2.55104492,6.39385563 C2.42487896,6.80652054 1.92777667,7.07285535 1.41793176,6.91630313 C1.19010488,6.84642876 0.862997575,6.67685386 0.936372673,6.4383848 C0.966338839,6.34050465 1.03635325,6.2668495 1.07416102,6.18339233 C1.10832806,6.11043732 1.12499148,6.05624616 1.13535362,6.02375948 C1.22847278,5.72003698 1.10104656,5.32445559 0.775479567,5.22377487 C0.471477014,5.13051568 0.160613049,5.20445089 0.0400482405,5.59555137 C-0.096619881,6.04000282 0.116083886,6.84670881 1.25563837,7.19776105 C2.59067307,7.60860559 3.71972539,6.88143596 3.87991835,5.93372095 C3.98087913,5.34013881 3.71258392,4.898768 3.2216429,4.3316513 L2.82130053,3.88874017 C2.57905068,3.64663035 2.49573353,3.23382541 2.74652514,2.91666015 C2.95838873,2.64878503 3.25959071,2.5349416 3.75375239,2.66908921 C4.47476075,2.86456943 4.79584682,3.36489238 5.33187711,3.76845542 C5.11091165,4.49464484 4.96598183,5.22349481 4.83519491,5.87700928 L4.75481838,6.36458961 C4.37169954,8.37414311 4.07903932,9.47813027 3.3188229,10.1117606 C3.16549135,10.2208431 2.94662631,10.3839767 2.61671843,10.3955991 C2.44336276,10.4009201 2.38749126,10.2816156 2.38511077,10.2295249 C2.38118997,10.1084 2.483411,10.0526685 2.55132497,9.99819728 C2.65312592,9.94260584 2.80673753,9.85074694 2.79623537,9.55626635 C2.78517309,9.20829475 2.49699379,8.90667268 2.08026805,8.92053554 C1.76828385,8.9310377 1.29260597,9.22439806 1.31066969,9.7621087 C1.32901346,10.317603 1.84655996,10.7337686 2.62708056,10.7073032 C3.0442264,10.6933003 3.97597812,10.5235854 4.89386699,9.43248088 C5.96242686,8.1811834 6.26124835,6.74728836 6.48599459,5.69763237 L6.73706625,4.31162718 C6.87625489,4.32843064 7.02538558,4.33977297 7.18753895,4.34355375 C8.51851281,4.37169954 9.1837897,3.68261775 9.19415184,3.18103455 C9.20087322,2.87759211 8.99517089,2.57863059 8.7069916,2.58577206 C8.50114924,2.59151324 8.24209594,2.72902154 8.1802032,3.01384014 C8.11915064,3.29319763 8.6035103,3.54566958 8.22501242,3.79142014 C7.9561571,3.96533593 7.47417793,4.08772111 6.79531824,3.98844068 L6.91868362,3.3062203 C7.17059546,2.01263413 7.48131939,0.421626756 8.66022197,0.382698746 C8.74619966,0.37863791 9.06028429,0.386339495 9.06756579,0.594422311 C9.06966622,0.663456516 9.05230265,0.681660262 8.97122597,0.840312907 C8.88832891,0.964098378 8.85710248,1.06996016 8.86116332,1.19094505 C8.87250565,1.52099297 9.12357731,1.73831769 9.48723214,1.72571509 C9.97341218,1.70933172 10.1130209,1.23617436 10.1050393,0.992804285 C10.0851552,0.420926612 9.48261119,0.0596522744 8.68556719,0.0859776912 Z"></path>
					</g>
				</g>
			</g>
		</g>
	</svg>
</div>
%s`, title, resetStyles(), redirect, html)
}
func resetStyles() string {
	return `
	/* http://meyerweb.com/eric/tools/css/reset/ 
	v2.0 | 20110126
	License: none (public domain)
 */
 
 html, body, div, span, applet, object, iframe,
 h1, h2, h3, h4, h5, h6, p, blockquote, pre,
 a, abbr, acronym, address, big, cite, code,
 del, dfn, em, img, ins, kbd, q, s, samp,
 small, strike, strong, sub, sup, tt, var,
 b, u, i, center,
 dl, dt, dd, ol, ul, li,
 fieldset, form, label, legend,
 table, caption, tbody, tfoot, thead, tr, th, td,
 article, aside, canvas, details, embed, 
 figure, figcaption, footer, header, hgroup, 
 menu, nav, output, ruby, section, summary,
 time, mark, audio, video {
	 margin: 0;
	 padding: 0;
	 border: 0;
	 font-size: 100%;
	 font: inherit;
	 vertical-align: baseline;
 }
 /* HTML5 display-role reset for older browsers */
 article, aside, details, figcaption, figure, 
 footer, header, hgroup, menu, nav, section {
	 display: block;
 }
 body {
	 line-height: 1;
 }
 ol, ul {
	 list-style: none;
 }
 blockquote, q {
	 quotes: none;
 }
 blockquote:before, blockquote:after,
 q:before, q:after {
	 content: '';
	 content: none;
 }
 table {
	 border-collapse: collapse;
	 border-spacing: 0;
 }` +
		// add some default styles for us
		`
body {
	background-color: #062531;
	color: #eee8d5;
	font-size: 16px;
	margin: 20px 50px;
	line-height: 18px;
}
table > tr td, table th {
	border-top: 1px solid #eee8d5;
}
tr > th {
	border-bottom: 1px solid #eee8d5;
}
table tr:last-child td, table tr:last-child th {
	padding-bottom: 10px;
	border-bottom: 1px solid #eee8d5;
}
table > th td:last-child {
	border-right: 1px solid #eee8d5;
}
tr > td, tr > th {
	border-left: 1px solid #eee8d5;
	border-right: 1px solid #eee8d5;
}
td {
	padding: 5px 10px;
}
th {
	color: #268bd2;
	padding: 10px;
}
code {
	font-family: monospace;
}
a, a.link, a:visited, a:hover {
	color: #eee8d5;
}
.terminal {
    left: 50px;
    right: 50px;
    background: #073642;
    border: solid #073642;
    border-width: 30px 5px 8px 5px;
    border-radius: 4px;
	padding-left: 3px;
	margin-bottom: 30px;
}
.terminal #prompt:before {
    background-color: #FC2230;
    border-radius: 50%;
    box-shadow: 0 0 0 2px #FC2230, 20px 0 0 2px #FD9332, 40px 0 0 2px #7CC74C;
    content: '';
    display: block;
    position: relative;
    left: -9px;
    top: -38px;
    width: 7px;
    height: 7px;
}
.button {
	font-family: monospace;
	background-color: #42a7ff;
	padding: 10px;
	border-radius: 4px;
	text-align: center;
	font-size: 14px;
}
.button a {
	text-decoration: none;
}
`
}
