// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: query.sql

package authors

import (
	"context"
	"fmt"

	"github.com/jackc/pgx/v5/pgconn"
	"github.com/jackc/pgx/v5/pgtype"
)

const createAuthor = `-- name: CreateAuthor :one
INSERT INTO authors (
          name, bio
) VALUES (
  $1, $2
)
RETURNING id, name, bio
`

type CreateAuthorParams struct {
	Name string
	Bio  pgtype.Text
}

func (q *Queries) CreateAuthor(ctx context.Context, arg CreateAuthorParams) (Author, error) {
	row := q.db.QueryRow(ctx, createAuthor, arg.Name, arg.Bio)
	var i Author
	err := row.Scan(&i.ID, &i.Name, &i.Bio)
	if err != nil {
		err = fmt.Errorf("query CreateAuthor: %w", err)
	}
	return i, err
}

const deleteAuthorExec = `-- name: DeleteAuthorExec :exec
DELETE FROM authors
WHERE id = $1
`

func (q *Queries) DeleteAuthorExec(ctx context.Context, id int64) error {
	_, err := q.db.Exec(ctx, deleteAuthorExec, id)
	if err != nil {
		return fmt.Errorf("query DeleteAuthorExec: %w", err)
	}
	return nil
}

const deleteAuthorExecLastID = `-- name: DeleteAuthorExecLastID :execlastid
DELETE FROM authors
WHERE id = $1
`

const deleteAuthorExecResult = `-- name: DeleteAuthorExecResult :execresult
DELETE FROM authors
WHERE id = $1
`

func (q *Queries) DeleteAuthorExecResult(ctx context.Context, id int64) (pgconn.CommandTag, error) {
	result, err := q.db.Exec(ctx, deleteAuthorExecResult, id)
	if err != nil {
		err = fmt.Errorf("query DeleteAuthorExecResult: %w", err)
	}
	return result, err
}

const deleteAuthorExecRows = `-- name: DeleteAuthorExecRows :execrows
DELETE FROM authors
WHERE id = $1
`

func (q *Queries) DeleteAuthorExecRows(ctx context.Context, id int64) (int64, error) {
	result, err := q.db.Exec(ctx, deleteAuthorExecRows, id)
	if err != nil {
		return 0, fmt.Errorf("query DeleteAuthorExecRows: %w", err)
	}
	return result.RowsAffected(), nil
}

const getAuthor = `-- name: GetAuthor :one
SELECT id, name, bio FROM authors
WHERE id = $1 LIMIT 1
`

func (q *Queries) GetAuthor(ctx context.Context, id int64) (Author, error) {
	row := q.db.QueryRow(ctx, getAuthor, id)
	var i Author
	err := row.Scan(&i.ID, &i.Name, &i.Bio)
	if err != nil {
		err = fmt.Errorf("query GetAuthor: %w", err)
	}
	return i, err
}

const listAuthors = `-- name: ListAuthors :many
SELECT id, name, bio FROM authors
ORDER BY name
`

func (q *Queries) ListAuthors(ctx context.Context) ([]Author, error) {
	rows, err := q.db.Query(ctx, listAuthors)
	if err != nil {
		return nil, fmt.Errorf("query ListAuthors: %w", err)
	}
	defer rows.Close()
	var items []Author
	for rows.Next() {
		var i Author
		if err := rows.Scan(&i.ID, &i.Name, &i.Bio); err != nil {
			return nil, fmt.Errorf("query ListAuthors: %w", err)
		}
		items = append(items, i)
	}
	if err := rows.Err(); err != nil {
		return nil, fmt.Errorf("query ListAuthors: %w", err)
	}
	return items, nil
}
