// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/bitnami-labs/sealed-secrets/pkg/apis/sealedsecrets/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SealedSecretLister helps list SealedSecrets.
// All objects returned here must be treated as read-only.
type SealedSecretLister interface {
	// List lists all SealedSecrets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.SealedSecret, err error)
	// SealedSecrets returns an object that can list and get SealedSecrets.
	SealedSecrets(namespace string) SealedSecretNamespaceLister
	SealedSecretListerExpansion
}

// sealedSecretLister implements the SealedSecretLister interface.
type sealedSecretLister struct {
	indexer cache.Indexer
}

// NewSealedSecretLister returns a new SealedSecretLister.
func NewSealedSecretLister(indexer cache.Indexer) SealedSecretLister {
	return &sealedSecretLister{indexer: indexer}
}

// List lists all SealedSecrets in the indexer.
func (s *sealedSecretLister) List(selector labels.Selector) (ret []*v1alpha1.SealedSecret, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.SealedSecret))
	})
	return ret, err
}

// SealedSecrets returns an object that can list and get SealedSecrets.
func (s *sealedSecretLister) SealedSecrets(namespace string) SealedSecretNamespaceLister {
	return sealedSecretNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SealedSecretNamespaceLister helps list and get SealedSecrets.
// All objects returned here must be treated as read-only.
type SealedSecretNamespaceLister interface {
	// List lists all SealedSecrets in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.SealedSecret, err error)
	// Get retrieves the SealedSecret from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.SealedSecret, error)
	SealedSecretNamespaceListerExpansion
}

// sealedSecretNamespaceLister implements the SealedSecretNamespaceLister
// interface.
type sealedSecretNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SealedSecrets in the indexer for a given namespace.
func (s sealedSecretNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.SealedSecret, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.SealedSecret))
	})
	return ret, err
}

// Get retrieves the SealedSecret from the indexer for a given namespace and name.
func (s sealedSecretNamespaceLister) Get(name string) (*v1alpha1.SealedSecret, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("sealedsecret"), name)
	}
	return obj.(*v1alpha1.SealedSecret), nil
}
