<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw jobs`
This API allows you to manage your Serverless Jobs.
  
- [](#)
  - [Create a new job definition in a specified Project](#create-a-new-job-definition-in-a-specified-project)
  - [Delete an exsisting job definition by its unique identifier](#delete-an-exsisting-job-definition-by-its-unique-identifier)
  - [Get a job definition by its unique identifier](#get-a-job-definition-by-its-unique-identifier)
  - [List all your job definitions with filters](#list-all-your-job-definitions-with-filters)
  - [Run an existing job definition by its unique identifier. This will create a new job run](#run-an-existing-job-definition-by-its-unique-identifier.-this-will-create-a-new-job-run)
  - [Update an existing job definition associated with the specified unique identifier](#update-an-existing-job-definition-associated-with-the-specified-unique-identifier)
- [](#)
  - [Get a job run by its unique identifier](#get-a-job-run-by-its-unique-identifier)
  - [List all job runs with filters](#list-all-job-runs-with-filters)
  - [Stop a job run by its unique identifier](#stop-a-job-run-by-its-unique-identifier)
  - [Wait for a job run to reach a stable state](#wait-for-a-job-run-to-reach-a-stable-state)

  
## 




### Create a new job definition in a specified Project

Create a new job definition in a specified Project.

**Usage:**

```
scw jobs definition create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name of the job definition |
| cpu-limit | Required | CPU limit of the job |
| memory-limit | Required | Memory limit of the job (in MiB) |
| local-storage-capacity |  | Local storage capacity of the job (in MiB) |
| image-uri | Required | Image to use for the job |
| command |  | Startup command. If empty or not defined, the image's default command is used. |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| environment-variables.{key} |  | Environment variables of the job |
| description |  | Description of the job |
| job-timeout |  | Timeout of the job in seconds |
| cron-schedule.schedule |  |  |
| cron-schedule.timezone |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an exsisting job definition by its unique identifier

Delete an exsisting job definition by its unique identifier.

**Usage:**

```
scw jobs definition delete <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required | UUID of the job definition to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a job definition by its unique identifier

Get a job definition by its unique identifier.

**Usage:**

```
scw jobs definition get <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required | UUID of the job definition to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your job definitions with filters

List all your job definitions with filters.

**Usage:**

```
scw jobs definition list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| project-id |  |  |
| organization-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Run an existing job definition by its unique identifier. This will create a new job run

Run an existing job definition by its unique identifier. This will create a new job run.

**Usage:**

```
scw jobs definition start <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required | UUID of the job definition to start |
| command |  | Contextual startup command for this specific job run |
| environment-variables.{key} |  | Contextual environment variables for this specific job run |
| replicas |  | Number of jobs to run |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update an existing job definition associated with the specified unique identifier

Update an existing job definition associated with the specified unique identifier.

**Usage:**

```
scw jobs definition update <job-definition-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-definition-id | Required | UUID of the job definition to update |
| name |  | Name of the job definition |
| cpu-limit |  | CPU limit of the job |
| memory-limit |  | Memory limit of the job (in MiB) |
| local-storage-capacity |  | Local storage capacity of the job (in MiB) |
| image-uri |  | Image to use for the job |
| command |  | Startup command |
| environment-variables.{key} |  | Environment variables of the job |
| description |  | Description of the job |
| job-timeout |  | Timeout of the job in seconds |
| cron-schedule.schedule |  |  |
| cron-schedule.timezone |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## 




### Get a job run by its unique identifier

Get a job run by its unique identifier.

**Usage:**

```
scw jobs run get <job-run-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-run-id | Required | UUID of the job run to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all job runs with filters

List all job runs with filters.

**Usage:**

```
scw jobs run list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| job-definition-id |  |  |
| project-id |  |  |
| organization-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Stop a job run by its unique identifier

Stop a job run by its unique identifier.

**Usage:**

```
scw jobs run stop <job-run-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-run-id | Required | UUID of the job run to stop |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Wait for a job run to reach a stable state

Wait for a job run to reach a stable state. This is similar to using --wait flag.

**Usage:**

```
scw jobs run wait <job-run-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| job-run-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



