<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw vpc`
VPC API.
  
- [Private network management command](#private-network-management-command)
  - [Create a private network](#create-a-private-network)
  - [Delete a private network](#delete-a-private-network)
  - [Get a private network](#get-a-private-network)
  - [List private networks](#list-private-networks)
  - [Update private network](#update-private-network)

  
## Private network management command

A private network allows interconnecting your instances in an
isolated and private network. The network reachability is limited
to the instances that are on the same private network.  Network
Interface Controllers (NICs) are available on the instance and can
be freely managed (adding IP addresses, shutdown interface...)

Note that an instance can be a part of multiple private networks.



### Create a private network

Create a private network.

**Usage:**

```
scw vpc private-network create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | The name of the private network |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | The private networks tags |
| subnets.{index} |  | Private network subnets CIDR |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Delete a private network

Delete a private network.

**Usage:**

```
scw vpc private-network delete <private-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network-id | Required | The private network ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### Get a private network

Get a private network.

**Usage:**

```
scw vpc private-network get <private-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network-id | Required | The private network id |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



### List private networks

List private networks.

**Usage:**

```
scw vpc private-network list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | The sort order of the returned private networks |
| name |  | Filter private networks with names containing this string |
| tags.{index} |  | Filter private networks with one or more matching tags |
| project-id |  | The project ID on which to filter the returned private networks |
| private-network-ids.{index} |  | The PrivateNetwork IDs on which to filter the returned private networks |
| include-regional |  | Include regional Private Networks |
| organization-id |  | The organization ID on which to filter the returned private networks |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `pl-waw-1`, `pl-waw-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update private network

Update private network.

**Usage:**

```
scw vpc private-network update <private-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network-id | Required | The private network ID |
| name |  | The name of the private network |
| tags.{index} |  | The private networks tags |
| ~~subnets.{index}~~ | Deprecated | Private network subnets CIDR (deprecated) |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `pl-waw-1`, `pl-waw-2` | Zone to target. If none is passed will use default zone from the config |



