<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw mnq`
MnQ API (beta).
  
- [MnQ Credentials commands](#mnq-credentials-commands)
  - [Create a set of credentials](#create-a-set-of-credentials)
  - [Delete credentials](#delete-credentials)
  - [Get a set of credentials](#get-a-set-of-credentials)
  - [List credentials](#list-credentials)
  - [Update a set of credentials](#update-a-set-of-credentials)
- [MnQ Namespace commands](#mnq-namespace-commands)
  - [Create a namespace](#create-a-namespace)
  - [Delete a namespace](#delete-a-namespace)
  - [Get a namespace](#get-a-namespace)
  - [List namespaces](#list-namespaces)
  - [Update the name of a namespace](#update-the-name-of-a-namespace)

  
## MnQ Credentials commands

MnQ Credentials commands.


### Create a set of credentials

Create a set of credentials for a specific namespace.

**Usage:**

```
scw mnq credential create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | Namespace containing the Credential |
| name | Default: `<generated>` | Credential name |
| permissions.can-publish |  | Defines if user can publish messages to the service |
| permissions.can-receive |  | Defines if user can receive messages from the service |
| permissions.can-manage |  | Defines if user can manage the associated resource(s) |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete credentials

Delete credentials.

**Usage:**

```
scw mnq credential delete <credential-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| credential-id | Required | ID of the Credential to delete |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get a set of credentials

Get a set of credentials.

**Usage:**

```
scw mnq credential get <credential-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| credential-id | Required | ID of the Credential to get |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List credentials

List credentials.

**Usage:**

```
scw mnq credential list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id |  | Namespace containing the Credential |
| order-by | One of: `id_asc`, `id_desc`, `name_asc`, `name_desc` | Field used for sorting results |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Update a set of credentials

Update a set of credentials.

**Usage:**

```
scw mnq credential update <credential-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| credential-id | Required | ID of the Credential to update |
| name |  | Credential name |
| permissions.can-publish |  | Defines if user can publish messages to the service |
| permissions.can-receive |  | Defines if user can receive messages from the service |
| permissions.can-manage |  | Defines if user can manage the associated resource(s) |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



## MnQ Namespace commands

MnQ Namespace commands.


### Create a namespace

Create a namespace.

**Usage:**

```
scw mnq namespace create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Namespace name |
| protocol | Required<br />One of: `unknown`, `nats`, `sqs_sns` | Namespace protocol |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Delete a namespace

Delete a namespace.

**Usage:**

```
scw mnq namespace delete <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | ID of the Namespace to delete |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### Get a namespace

Get a namespace.

**Usage:**

```
scw mnq namespace get <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | ID of the Namespace to get |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



### List namespaces

List namespaces.

**Usage:**

```
scw mnq namespace list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Will list only the Namespaces contained into the specified project |
| order-by | One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc`, `id_asc`, `id_desc`, `name_asc`, `name_desc`, `project_id_asc`, `project_id_desc` | Field used for sorting results |
| organization-id |  | Will list only the Namespaces owned by the specified organization |
| region | Default: `fr-par`<br />One of: `fr-par`, `all` | Region to target. If none is passed will use default region from the config |



### Update the name of a namespace

Update the name of a namespace.

**Usage:**

```
scw mnq namespace update <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | ID of the Namespace to update |
| name |  | Namespace name |
| region | Default: `fr-par`<br />One of: `fr-par` | Region to target. If none is passed will use default region from the config |



