<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw container`
Containers API.
  
- [Container management commands](#container-management-commands)
  - [Create a new container](#create-a-new-container)
  - [Delete a container](#delete-a-container)
  - [Deploy a container](#deploy-a-container)
  - [Get a container](#get-a-container)
  - [List your container logs](#list-your-container-logs)
  - [List all your containers](#list-all-your-containers)
  - [Update an existing container](#update-an-existing-container)
- [Cron management commands](#cron-management-commands)
  - [Create a new cron](#create-a-new-cron)
  - [Delete an existing cron](#delete-an-existing-cron)
  - [Get a cron](#get-a-cron)
  - [List all your crons](#list-all-your-crons)
  - [Update an existing cron](#update-an-existing-cron)
- [Deploy a container](#deploy-a-container)
- [Domain management commands](#domain-management-commands)
  - [Create a domain name binding](#create-a-domain-name-binding)
  - [Delete a domain name binding](#delete-a-domain-name-binding)
  - [Get a domain name binding](#get-a-domain-name-binding)
  - [List all domain name bindings](#list-all-domain-name-bindings)
- [Namespace management commands](#namespace-management-commands)
  - [Create a new namespace](#create-a-new-namespace)
  - [Delete an existing namespace](#delete-an-existing-namespace)
  - [Get a namespace](#get-a-namespace)
  - [List all your namespaces](#list-all-your-namespaces)
  - [Update an existing namespace](#update-an-existing-namespace)
- [Token management commands](#token-management-commands)
  - [Create a new revocable token](#create-a-new-revocable-token)
  - [Delete a token](#delete-a-token)
  - [Get a token](#get-a-token)
  - [List all tokens](#list-all-tokens)

  
## Container management commands

Container management commands.


### Create a new container

Create a new container.

**Usage:**

```
scw container container create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id |  |  |
| name | Default: `<generated>` |  |
| environment-variables.{key} |  |  |
| min-scale |  |  |
| max-scale |  |  |
| memory-limit |  |  |
| timeout.seconds |  |  |
| timeout.nanos |  |  |
| privacy | One of: `unknown_privacy`, `public`, `private` |  |
| description |  |  |
| registry-image |  |  |
| max-concurrency |  |  |
| protocol | One of: `unknown_protocol`, `http1`, `h2c` |  |
| port |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| http-option | Default: `enabled`<br />One of: `unknown_http_option`, `enabled`, `redirected` | Configure how HTTP and HTTPS requests are handled |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a container

Delete the container associated with the given id.

**Usage:**

```
scw container container delete <container-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| container-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Deploy a container

Deploy a container associated with the given id.

**Usage:**

```
scw container container deploy <container-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| container-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a container

Get the container associated with the given id.

**Usage:**

```
scw container container get <container-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| container-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List your container logs

List your container logs.

**Usage:**

```
scw container container get-logs <container-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| container-id | Required |  |
| order-by | One of: `timestamp_desc`, `timestamp_asc` |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### List all your containers

List all your containers.

**Usage:**

```
scw container container list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` |  |
| namespace-id |  |  |
| name |  |  |
| project-id |  |  |
| organization-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing container

Update the container associated with the given id.

**Usage:**

```
scw container container update <container-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| container-id | Required |  |
| environment-variables.{key} |  |  |
| min-scale |  |  |
| max-scale |  |  |
| memory-limit |  |  |
| timeout.seconds |  |  |
| timeout.nanos |  |  |
| redeploy |  |  |
| privacy | One of: `unknown_privacy`, `public`, `private` |  |
| description |  |  |
| registry-image |  |  |
| max-concurrency |  |  |
| protocol | One of: `unknown_protocol`, `http1`, `h2c` |  |
| port |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| http-option | Default: `enabled`<br />One of: `unknown_http_option`, `enabled`, `redirected` | Configure how HTTP and HTTPS requests are handled |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Cron management commands

Cron management commands.


### Create a new cron

Create a new cron.

**Usage:**

```
scw container cron create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| container-id |  |  |
| schedule |  |  |
| args |  |  |
| name |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing cron

Delete the cron associated with the given id.

**Usage:**

```
scw container cron delete <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a cron

Get the cron associated with the given id.

**Usage:**

```
scw container cron get <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your crons

List all your crons.

**Usage:**

```
scw container cron list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| container-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing cron

Update the cron associated with the given id.

**Usage:**

```
scw container cron update <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required |  |
| container-id |  |  |
| schedule |  |  |
| args |  |  |
| name |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Deploy a container

Automatically build and deploy a container.

Automatically build and deploy a container.

**Usage:**

```
scw container deploy [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the application (defaults to build-source's directory name) |
| dockerfile | Default: `Dockerfile` | Path to the Dockerfile |
| build-source | Default: `.` | Path to the build context |
| cache | Default: `true` | Use cache when building the image |
| build-args.{key} |  | Build-time variables |
| port | Default: `8080` | Port to expose |
| namespace-id |  | Container Namespace ID to deploy to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Domain management commands

Domain management commands.


### Create a domain name binding

Create a domain name binding.

**Usage:**

```
scw container domain create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hostname |  |  |
| container-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a domain name binding

Delete a domain name binding.

**Usage:**

```
scw container domain delete <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a domain name binding

Get a domain name binding.

**Usage:**

```
scw container domain get <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all domain name bindings

List all domain name bindings.

**Usage:**

```
scw container domain list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `hostname_asc`, `hostname_desc` |  |
| container-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Namespace management commands

Namespace management commands.


### Create a new namespace

Create a new namespace.

**Usage:**

```
scw container namespace create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` |  |
| environment-variables.{key} |  |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| description |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing namespace

Delete the namespace associated with the given id.

**Usage:**

```
scw container namespace delete <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a namespace

Get the namespace associated with the given id.

**Usage:**

```
scw container namespace get <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your namespaces

List all your namespaces.

**Usage:**

```
scw container namespace list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` |  |
| name |  |  |
| project-id |  |  |
| organization-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing namespace

Update the space associated with the given id.

**Usage:**

```
scw container namespace update <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required |  |
| environment-variables.{key} |  |  |
| description |  |  |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Token management commands

Token management commands.


### Create a new revocable token

Create a new revocable token.

**Usage:**

```
scw container token create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| container-id |  |  |
| namespace-id |  |  |
| description |  |  |
| expires-at |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a token

Delete a token.

**Usage:**

```
scw container token delete <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a token

Get a token.

**Usage:**

```
scw container token get <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all tokens

List all tokens.

**Usage:**

```
scw container token list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` |  |
| container-id |  |  |
| namespace-id |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



