<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw baremetal`
Elastic Metal API.
  
- [Baseboard Management Controller (BMC) management commands](#baseboard-management-controller-(bmc)-management-commands)
  - [Get BMC access](#get-bmc-access)
  - [Start BMC access](#start-bmc-access)
  - [Stop BMC access](#stop-bmc-access)
- [Server offer management commands](#server-offer-management-commands)
  - [Get offer](#get-offer)
  - [List offers](#list-offers)
- [Server options management commands](#server-options-management-commands)
  - [Add server option](#add-server-option)
  - [Delete server option](#delete-server-option)
  - [Get option](#get-option)
  - [List options](#list-options)
- [Operating System (OS) management commands](#operating-system-(os)-management-commands)
  - [Get an OS with an ID](#get-an-os-with-an-id)
  - [List available OSes](#list-available-oses)
- [Private Network management command](#private-network-management-command)
  - [Add a server to a Private Network](#add-a-server-to-a-private-network)
  - [Delete a Private Network](#delete-a-private-network)
  - [List the Private Networks of a server](#list-the-private-networks-of-a-server)
  - [Set multiple Private Networks on a server](#set-multiple-private-networks-on-a-server)
- [Server management commands](#server-management-commands)
  - [Create an Elastic Metal server](#create-an-elastic-metal-server)
  - [Delete an Elastic Metal server](#delete-an-elastic-metal-server)
  - [Get a specific Elastic Metal server](#get-a-specific-elastic-metal-server)
  - [Return server metrics](#return-server-metrics)
  - [Install an Elastic Metal server](#install-an-elastic-metal-server)
  - [List Elastic Metal servers for an organization](#list-elastic-metal-servers-for-an-organization)
  - [List server events](#list-server-events)
  - [Reboot an Elastic Metal server](#reboot-an-elastic-metal-server)
  - [Start an Elastic Metal server](#start-an-elastic-metal-server)
  - [Stop an Elastic Metal server](#stop-an-elastic-metal-server)
  - [Update an Elastic Metal server](#update-an-elastic-metal-server)
  - [Update IP](#update-ip)
  - [Wait for a server to reach a stable state (delivery and installation)](#wait-for-a-server-to-reach-a-stable-state-(delivery-and-installation))
- [Settings management commands](#settings-management-commands)
  - [List all settings](#list-all-settings)
  - [Update setting](#update-setting)

  
## Baseboard Management Controller (BMC) management commands

A Baseboard Management Controller (BMC) allows you to remotely access the low-level parameters of your dedicated server.
For instance, your KVM-IP management console could be accessed with it.
You need first to create an Remote Access option. You will find the ID and the price with a call to listOffers (https://developers.scaleway.com/en/products/baremetal/api/#get-78db92). Then you can add the option https://developers.scaleway.com/en/products/baremetal/api/#post-b14abd. Do not forget to delete the Option.
Then you need to create Remote Access https://developers.scaleway.com/en/products/baremetal/api/#post-1af723.
And finally Get Remote Access to get the login/password https://developers.scaleway.com/en/products/baremetal/api/#get-cefc0f.



### Get BMC access

Get the BMC (Baseboard Management Controller) access associated with the ID, including the URL and login information needed to connect.

**Usage:**

```
scw baremetal bmc get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Start BMC access

Start BMC (Baseboard Management Controller) access associated with the ID.
The BMC (Baseboard Management Controller) access is available one hour after the installation of the server.
You need first to create an option Remote Access. You will find the ID and the price with a call to listOffers (https://developers.scaleway.com/en/products/baremetal/api/#get-78db92). Then add the option https://developers.scaleway.com/en/products/baremetal/api/#post-b14abd.
After adding the BMC option, you need to Get Remote Access to get the login/password https://developers.scaleway.com/en/products/baremetal/api/#get-cefc0f. Do not forget to delete the Option after use.

**Usage:**

```
scw baremetal bmc start [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| ip | Required | The IP authorized to connect to the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Stop BMC access

Stop BMC (Baseboard Management Controller) access associated with the ID.

**Usage:**

```
scw baremetal bmc stop [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



## Server offer management commands

Server offers will answer with all different Elastic Metal server ranges available in a  zone.
Each of them will contain all the features of the server (CPUs, memory, disks) with their associated pricing.



### Get offer

Get details of an offer identified by its offer ID.

**Usage:**

```
scw baremetal offer get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id | Required | ID of the researched Offer |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a server offer with the ID
```
scw baremetal offer get zone=fr-par-1 offer-id=11111111-1111-1111-1111-111111111111
```




### List offers

List all available Elastic Metal server configurations.

**Usage:**

```
scw baremetal offer list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| subscription-period | One of: `unknown_subscription_period`, `hourly`, `monthly` | Subscription period type to filter offers by |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all server offers in the default zone
```
scw baremetal offer list
```

List all server offers in fr-par-1 zone
```
scw baremetal offer list zone=fr-par-1
```




## Server options management commands

A Server has additional options that let you personalize it to better fit your needs.



### Add server option

Add an option, such as Private Networks, to a specific server.

**Usage:**

```
scw baremetal options add [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| option-id | Required | ID of the option to add |
| expires-at |  | Auto expire the option after this date |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Add an option, such as Private Networks, to a server
```
scw baremetal options add server-id=11111111-1111-1111-1111-111111111111 option-id=11111111-1111-1111-1111-111111111111
```




### Delete server option

Delete an option from a specific server.

**Usage:**

```
scw baremetal options delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| option-id | Required | ID of the option to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete an option from a server
```
scw baremetal options delete server-id=11111111-1111-1111-1111-111111111111 option-id=11111111-1111-1111-1111-111111111111
```




### Get option

Return specific option for the ID.

**Usage:**

```
scw baremetal options get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| option-id | Required | ID of the option |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a server option with the ID
```
scw baremetal options get zone=fr-par-1 option-id=11111111-1111-1111-1111-111111111111
```




### List options

List all options matching with filters.

**Usage:**

```
scw baremetal options list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id |  | Offer ID to filter options for |
| name |  | Name to filter options for |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all server options in the default zone
```
scw baremetal options list
```

List all server options in fr-par-1 zone
```
scw baremetal options list zone=fr-par-1
```




## Operating System (OS) management commands

An Operating System (OS) is the underlying software installed on your server


### Get an OS with an ID

Return specific OS for the ID.

**Usage:**

```
scw baremetal os get <os-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| os-id | Required | ID of the OS |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a specific OS ID
```
scw baremetal os get
```




### List available OSes

List all OSes that are available for installation on Elastic Metal servers.

**Usage:**

```
scw baremetal os list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| offer-id |  | Offer IDs to filter OSes for |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



## Private Network management command

A Private Network allows you to interconnect your resources
(servers, instances, ...) in an isolated and private
network. The network reachability is limited to the
resources that are on the same Private Network .  A VLAN
interface is available on the server and can be freely
managed (adding IP addresses, shutdown interface...).

Note that a resource can be a part of multiple Private Networks.



### Add a server to a Private Network

Add a server to a Private Network.

**Usage:**

```
scw baremetal private-network add [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | The ID of the server |
| private-network-id | Required | The ID of the Private Network |
| zone | Default: `fr-par-1`<br />One of: `fr-par-2` | Zone to target. If none is passed will use default zone from the config |



### Delete a Private Network

Delete a Private Network.

**Usage:**

```
scw baremetal private-network delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | The ID of the server |
| private-network-id | Required | The ID of the Private Network |
| zone | Default: `fr-par-1`<br />One of: `fr-par-2` | Zone to target. If none is passed will use default zone from the config |



### List the Private Networks of a server

List the Private Networks of a server.

**Usage:**

```
scw baremetal private-network list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `updated_at_asc`, `updated_at_desc` | The sort order for the returned Private Networks |
| server-id |  | Filter Private Networks by server ID |
| private-network-id |  | Filter Private Networks by Private Network ID |
| project-id |  | Filter Private Networks by Project ID |
| organization-id |  | Filter Private Networks by Organization ID |
| zone | Default: `fr-par-1`<br />One of: `fr-par-2`, `all` | Zone to target. If none is passed will use default zone from the config |



### Set multiple Private Networks on a server

Set multiple Private Networks on a server.

**Usage:**

```
scw baremetal private-network set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | The ID of the server |
| private-network-ids.{index} | Required | The IDs of the Private Networks |
| zone | Default: `fr-par-1`<br />One of: `fr-par-2` | Zone to target. If none is passed will use default zone from the config |



## Server management commands

A server is a denomination of a type of instances provided by Scaleway


### Create an Elastic Metal server

Create a new Elastic Metal server. Once the server is created, proceed with the [installation of an OS](#post-3e949e).

**Usage:**

```
scw baremetal server create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required<br />Default: `<generated>` | Name of the server (≠hostname) |
| description |  | Description associated with the server, max 255 characters |
| type |  | Server commercial type |
| tags.{index} |  | Tags to associate to the server |
| install.os-id |  | ID of the OS to installation on the server |
| install.hostname |  | Hostname of the server |
| install.ssh-key-ids.{index} |  | SSH key IDs authorized on the server |
| install.user |  | User for the installation |
| install.password |  | Password for the installation |
| install.service-user |  | Regular user that runs the service to be installed on the server |
| install.service-password |  | Password used for the service to install |
| option-ids.{index} |  | IDs of options to enable on server |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Create instance
```
scw baremetal server create
```




### Delete an Elastic Metal server

Delete the server associated with the ID.

**Usage:**

```
scw baremetal server delete <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to delete |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Delete an Elastic Metal server
```
scw baremetal server delete 11111111-1111-1111-1111-111111111111
```




### Get a specific Elastic Metal server

Get full details of an existing Elastic Metal server associated with the ID.

**Usage:**

```
scw baremetal server get <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Get a specific server
```
scw baremetal server get 11111111-1111-1111-1111-111111111111
```




### Return server metrics

Get the ping status of the server associated with the ID.

**Usage:**

```
scw baremetal server get-metrics [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to get the metrics |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Install an Elastic Metal server

Install an Operating System (OS) on the Elastic Metal server with a specific ID.

**Usage:**

```
scw baremetal server install <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | Server ID to install |
| os-id | Required | ID of the OS to installation on the server |
| hostname | Required | Hostname of the server |
| all-ssh-keys |  | Add all SSH keys on your baremetal instance (cannot be used with ssh-key-ids) |
| ssh-key-ids.{index} | Required | SSH key IDs authorized on the server (cannot be used with all-ssh-keys) |
| user |  | User used for the installation |
| password |  | Password used for the installation |
| service-user |  | User used for the service to install |
| service-password |  | Password used for the service to install |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Install an OS on a  server with a particular SSH key ID
```
scw baremetal server install 11111111-1111-1111-1111-111111111111 os-id=11111111-1111-1111-1111-111111111111 ssh-key-ids.0=11111111-1111-1111-1111-111111111111
```




### List Elastic Metal servers for an organization

List Elastic Metal servers for a specific organization.

**Usage:**

```
scw baremetal server list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the servers |
| tags.{index} |  | Tags to filter for |
| status.{index} |  | Status to filter for |
| name |  | Names to filter for |
| project-id |  | Project ID to filter for |
| option-id |  | Option ID to filter for |
| organization-id |  | Organization ID to filter for |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


List all servers in your default zone
```
scw baremetal server list
```




### List server events

List event (i.e. start/stop/reboot) associated to the server ID.

**Usage:**

```
scw baremetal server list-events [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server events searched |
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the server events |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### Reboot an Elastic Metal server

Reboot the Elastic Metal server associated with the ID, use the `boot_type` `rescue` to reboot the server in rescue mode.

**Usage:**

```
scw baremetal server reboot <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to reboot |
| boot-type | Default: `normal`<br />One of: `unknown_boot_type`, `normal`, `rescue` | The type of boot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Reboot a server using the same os
```
scw baremetal server reboot 11111111-1111-1111-1111-111111111111
```

Reboot a server in rescue mode
```
scw baremetal server reboot 11111111-1111-1111-1111-111111111111 boot-type=rescue
```




### Start an Elastic Metal server

Start the server associated with the ID.

**Usage:**

```
scw baremetal server start <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to start |
| boot-type | One of: `unknown_boot_type`, `normal`, `rescue` | The type of boot |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Start an Elastic Metalx server
```
scw baremetal server start 11111111-1111-1111-1111-111111111111
```

Start a server in rescue mode
```
scw baremetal server start 11111111-1111-1111-1111-111111111111 boot-type=rescue
```




### Stop an Elastic Metal server

Stop the server associated with the ID. The server remains allocated to your account and all data remains on the local storage of the server.

**Usage:**

```
scw baremetal server stop <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to stop |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Stop an Elastic Metal server
```
scw baremetal server stop 11111111-1111-1111-1111-111111111111
```




### Update an Elastic Metal server

Update the server associated with the ID. You can update parameters such as the server's name, tags and description. Any parameters left null in the request body are not updated.

**Usage:**

```
scw baremetal server update <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server to update |
| name |  | Name of the server (≠hostname), not updated if null |
| description |  | Description associated with the server, max 255 characters, not updated if null |
| tags.{index} |  | Tags associated with the server, not updated if null |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Update IP

Configure the IP address associated with the server ID and IP ID. You can use this method to set a reverse DNS for an IP address.

**Usage:**

```
scw baremetal server update-ip [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server |
| ip-id | Required | ID of the IP to update |
| reverse |  | New reverse IP to update, not updated if null |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



### Wait for a server to reach a stable state (delivery and installation)

Wait for a server to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the server.

**Usage:**

```
scw baremetal server wait <server-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| server-id | Required | ID of the server affected by the action. |
| zone | Default: `fr-par-1` | Zone to target. If none is passed will use default zone from the config |


**Examples:**


Wait for a server to reach a stable state
```
scw baremetal server wait 11111111-1111-1111-1111-111111111111
```




## Settings management commands

Allows to configure the general settings for your Elastic Metal server.



### List all settings

Return all settings for a project ID.

**Usage:**

```
scw baremetal settings list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order for items in the response |
| project-id | Required | ID of the project |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1`, `all` | Zone to target. If none is passed will use default zone from the config |



### Update setting

Update a setting for a project ID (enable or disable).

**Usage:**

```
scw baremetal settings update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| setting-id | Required | ID of the setting |
| enabled |  | Defines whether the setting is enabled |
| zone | Default: `fr-par-1`<br />One of: `fr-par-1`, `fr-par-2`, `nl-ams-1` | Zone to target. If none is passed will use default zone from the config |



