.SH CONFIG

The sake.yaml config is based on the following concepts:

.RS 2
.IP "\(bu" 2
\fBservers\fR are servers, local or remote, that have a host
.IP "\(bu" 2
\fBtasks\fR are shell commands that you write and then run for selected \fBservers\fR
.IP "\(bu" 2
\fBspecs\fR are configs that alter \fBtask\fR execution and output
.IP "\(bu" 2
\fBtargets\fR are configs that provide shorthand filtering of \fBservers\fR when executing tasks
.IP "\(bu" 2
\fBthemes\fR are used to modify the output of \fBsake\fR commands
.IP "" 0
.RE

\fBSpecs\fR, \fBtargets\fR and \fBthemes\fR come with a default setting that the user can override.

Check the files and environment section to see how the config file is loaded.

Below is a config file detailing all of the available options and their defaults.

.RS 4
 # Import servers/tasks/env/specs/themes/targets from other configs [optional]
 import:
   - ./some-dir/sake.yaml

 # Verify SSH host connections. Set this to true if you wish to circumvent verify host [optional]
 disable_verify_host: false

 # Set known_hosts_file path. Default is users ssh home directory [optional]
 # known_hosts_file: $HOME/.ssh/known_hosts

 # Shell used for commands [optional]
 # If you use any other program than bash, zsh, sh, node, or python
 # then you have to provide the command flag if you want the command-line string evaluted
 # For instance: bash -c
 shell: bash

 # List of Servers
 servers:
   # Server name [required]
   media:
     # Server description [optional]
     desc: media server

     # Host [required]
     host: media.lan
     # one-line for setting user and port
     # host: samir@media.lan:22

     # Specify multiple hosts:
     # hosts:
     # - samir@192.168.0.1:22
     # - samir@l92.168.1.1:22

     # or use a host range generator
     # hosts: samir@192.168.[0:1].1:22

     # generate hosts by local command
     # inventory: echo samir@192.168.0.1:22 samir@192.168.1.1:22

     # Bastion [optional]
     bastion: samir@192.168.1.1:2222

     # User to connect as. It defaults to the current user [optional]
     user: samir

     # Port for ssh [optional]
     port: 22

     # Shell used for commands [optional]
     shell: bash

     # Run on localhost [optional]
     local: false

     # Set default working directory for task execution [optional]
     work_dir: ""

     # Set identity file. By default it will attempt to establish a connection using a SSH auth agent [optional]
     # sake respects users ssh config, so you can set auth credentials in the users ssh config
     identity_file: ./id_rsa

     # Set password. Accepts either a string or a shell command [optional]
     password: $(echo $MY_SECRET_PASSWORD)

     # List of tags [optional]
     tags: [remote]

     # List of server specific environment variables [optional]
     env:
       # Simple string value
       key: value

       # Shell command substitution (evaluated on localhost)
       date: $(date -u +"%Y-%m-%dT%H:%M:%S%Z")

 # List of environment variables that are available to all tasks
 env:
   # Simple string value
   AUTHOR: "alajmo"

   # Shell command substitution (evaluated on localhost)
   DATE: $(date -u +"%Y-%m-%dT%H:%M:%S%Z")

 # List of themes
 themes:
   # Theme name
   default:
     # Text options [optional]
     text:
       # Include server name prefix for each line [optional]
       prefix: true

       # Colors to alternate between for each server prefix [optional]
       # Available options: green, blue, red, yellow, magenta, cyan
       prefix_colors: ["green", "blue", "red", "yellow", "magenta", "cyan"]

       # Customize the task header that is printed before each task when output is set to text (to opt out, set it to empty string) [optional]
       # Available variables: `.Name`, `.Desc`, `.Index`, `.NumTasks`
       # Available methods: `.Style`, which takes in 1 or more parameters, first is the string to be styled, and the rest are styling options
       # Available styling options:
       #   Colors (prefix with `fg_` for foreground, and `bg_` for background): black, red, green, yellow, blue, magenta, cyan, white, hi_black, hi_red, hi_green, hi_yellow, hi_blue, hi_magenta, hi_cyan, hi_white
       #   Attributes: normal, bold, faint, italic, underline crossed_out
       header: '{{ .Style "TASK" "bold" }}{{ if ne .NumTasks 1 }} ({{ .Index }}/{{ .NumTasks }}){{end}}{{ if and .Name .Desc }} [{{.Style .Name "bold"}}: {{ .Desc }}] {{ else if .Name }} [{{ .Name }}] {{ else if .Desc }} [{{ .Desc }}] {{end}}'

       # Fill remaining spaces with a character after the header, if set to empty string, no filler characters will be displayed [optional]
       header_filler: "*"

     # Table options [optional]
     table:
       # Table style [optional]
       # Available options: ascii, connected-light
       style: ascii

       # Border options for table output [optional]
       options:
         draw_border: false
         separate_columns: true
         separate_header: true
         separate_rows: false
         separate_footer: false

       # Color, attr, align, and format options [optional]
       # Available options for fg/bg: green, blue, red, yellow, magenta, cyan, hi_green, hi_blue, hi_red, hi_yellow, hi_magenta, hi_cyan
       # Available options for align: left, center, justify, right
       # Available options for attr: normal, bold, faint, italic, underline, crossed_out
       # Available options for format: default, lower, title, upper
       title:
         fg:
         bg:
         align:
         attr:
         format:

       header:
         fg:
         bg:
         align:
         attr:
         format:

       row:
         fg:
         bg:
         align:
         attr:
         format:

       footer:
         fg:
         bg:
         align:
         attr:
         format:

       border:
         header:
           fg:
           bg:
           align:
           attr:

         row:
           fg:
           bg:
           align:
           attr:

         row_alt:
           fg:
           bg:
           align:
           attr:

         footer:
           fg:
           bg:
           align:
           attr:

 # List of Specs [optional]
 specs:
   default:
     # Set task output [text|table|html|markdown]
     output: text

     # Run server tasks in parallel
     parallel: false

     # Continue task execution on errors
     ignore_errors: true

     # Stop task execution on all servers on error
     any_errors_fatal: false

     # Ignore unreachable hosts
     ignore_unreachable: false

     # Omit empty results for table output
     omit_empty: false

 # List of targets [optional]
 targets:
   default:
     # Target all servers
     all: false

     # Specify servers via server name
     servers: []

     # Specify servers via server tags
     tags: []

     # Limit of servers to target
     limit: 0

     # Limit of servers to target in percentage
     limit_p: 0

 # List of tasks
 tasks:
   # Command ID [required]
   simple-1:
     # The name that will be displayed when executing or listing tasks. Defaults to task ID [optional]
     name: Simple

     # Script to run
     cmd: |
       echo "hello world"
     desc: simple command 1

   # Short-form for a command
   simple-2: echo "hello world"

   # Command ID [required]
   advanced-command:
     # The name that will be displayed when executing or listing tasks. Defaults to task ID [optional]
     name: Advanced Command

     # Task description [optional]
     desc: Advanced task

     # Specify theme [optional]
     theme: default

     # Spec reference [optional]
     # spec: default

     # Or specify specs inline
     spec:
       output: table
       parallel: true
       ignore_errors: true
       ignore_unreachable: true
       any_errors_fatal: false
       omit_empty: true

     # Target reference [optional]
     # target: default

     # Or specify targets inline
     target:
       all: true
       servers: [media]
       tags: [remote]
       limit: 1
       limit_p: 100

     # List of environment variables [optional]
     env:
       # Simple string value
       release: v1.0.0

       # Shell command substitution
       num_lines: $(ls -1 | wc -l)

       # The following variables are available by default:
       #   SAKE_DIR
       #   SAKE_PATH
       #
       #   SAKE_TASK_ID
       #   SAKE_TASK_NAME
       #   SAKE_TASK_DESC
       #   SAKE_TASK_LOCAL
       #
       #   SAKE_SERVER_NAME
       #   SAKE_SERVER_DESC
       #   SAKE_SERVER_TAGS
       #   SAKE_SERVER_HOST
       #   SAKE_SERVER_USER
       #   SAKE_SERVER_PORT
       #   SAKE_SERVER_BASTION
       #   SAKE_SERVER_LOCAL

     # Run on localhost [optional]
     local: false

     # Set default working directory for task [optional]
     work_dir: ""

     # Shell used for commands [optional]
     shell: bash

     # Each task can only define:
     # - a single cmd
     # - or a single task reference
     # - or a list of task references or commands

     # Single command
     cmd: |
       echo complex
       echo command

     # Task reference. work_dir and env variables are passed down
     task: simple-1

     # List of task references or commands
     tasks:
       # Command
       - name: inline-command
         cmd: echo "Hello World"
         work_dir: /tmp
         shell: bash
         env:
           foo: bar

       # Task reference. work_dir and env variables are passed down.
       # Nested task referencing is supported and will result in a
       # flat list of commands
       - task: simple-1
         work_dir: /tmp
         env:
           foo: bar
.RE

.SH EXAMPLES

.TP
Initialize sake
.B ~ $ sake init

.nf
Initialized sake in /tmp
- Created sake.yaml

Following servers were added to sake.yaml

 Server    | Host
-----------+---------
 localhost | 0.0.0.0
.fi

.TP
List all servers
.B ~ $ sake list servers

.nf
 Server    | Host
-----------+---------
 localhost | 0.0.0.0
.fi

.TP
List all tasks
.B ~ $ sake list tasks

.nf
 Task | Description
------+-------------
 ping | Pong
.fi

.TP
Describe a task
.B ~ $ sake describe task ping

.nf
Task: ping
Name: ping
Desc: ping server
Local: false
WorkDir:
Theme: default
Target:
    All: true
    Servers:
    Tags:
Spec:
    Output: text
    Parallel: false
    AnyErrorsFatal: false
    IgnoreErrors: false
    IgnoreUnreachable: false
    OmitEmpty: false
Env:
    SAKE_TASK_ID: ping
    SAKE_TASK_NAME:
    SAKE_TASK_DESC: ping server
    SAKE_TASK_LOCAL: false
Cmd:
    echo pong
.fi

.TP
Run a task for all servers with tag 'local'
.B ~ $ sake run many --tags local

.nf
TASK [ping: Pong] ********************

0.0.0.0 | pong
.fi

.TP
Run ad-hoc command for all servers
.B ~ $ sake exec --all --output table 'echo 123'

.nf
 Server    | Output
-----------+--------
 localhost | 123
.fi

.SH FILES

When running a command,
.B sake
will check the current directory and all parent directories for the following files: sake.yaml, sake.yml, .sake.yaml, .sake.yml.

Additionally, it will import (if found) a config file from:

.RS 2
.IP "\(bu" 2
Linux: \fB$XDG_CONFIG_HOME/sake/config.yaml\fR or \fB$HOME/.config/sake/config.yaml\fR if \fB$XDG_CONFIG_HOME\fR is not set.
.IP "\(bu" 2
Darwin: \fB$HOME/Library/Application/sake\fR
.RE

Both the config and user config can be specified via flags or environments variables.

.SH
ENVIRONMENT

.TP
.B SAKE_CONFIG
Override config file path

.TP
.B SAKE_USER_CONFIG
Override user config file path

.TP
.B SAKE_SSH_CONFIG
Override ssh config file path

.TP
.B SAKE_KNOWN_HOSTS_FILE
Override known_hosts file path

.TP
.B NO_COLOR
If this env variable is set (regardless of value) then all colors will be disabled

.SH BUGS

See GitHub Issues:
.UR https://github.com/alajmo/sake/issues
.ME .

.SH AUTHOR

.B sake
was written by Samir Alajmovic
.MT alajmovic.samir@gmail.com
.ME .
For updates and more information go to
.UR https://\:www.sakecli.com
sakecli.com
.UE .
