package rke

import v3 "github.com/rancher/types/apis/management.cattle.io/v3"

func loadK8sRKESystemImages() map[string]v3.RKESystemImages {
	return map[string]v3.RKESystemImages{
		// removed bad versions because panics, hyperkube image doesn't match.
		"v1.8.11-rancher2-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.0.17"),
			Kubernetes:                m("rancher/hyperkube:v1.8.11-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.8"),
			NginxProxy:                m("rancher/rke-tools:v0.1.8"),
			CertDownloader:            m("rancher/rke-tools:v0.1.8"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.8"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.5"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.5"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.5"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.0"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.10.2-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
		},
		"v1.9.5-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.9.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.4"),
			NginxProxy:                m("rancher/rke-tools:v0.1.4"),
			CertDownloader:            m("rancher/rke-tools:v0.1.4"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.4"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.7"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.7"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.7"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.0"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.10.2-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
		},
		"v1.9.7-rancher2-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.9.7-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.8"),
			NginxProxy:                m("rancher/rke-tools:v0.1.8"),
			CertDownloader:            m("rancher/rke-tools:v0.1.8"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.8"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.7"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.7"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.7"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.0"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.10.2-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
		},
		"v1.9.7-rancher2-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.9.7-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.13"),
			NginxProxy:                m("rancher/rke-tools:v0.1.13"),
			CertDownloader:            m("rancher/rke-tools:v0.1.13"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.13"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.7"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.7"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.7"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.0"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.10.0-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.10.0-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.4"),
			NginxProxy:                m("rancher/rke-tools:v0.1.4"),
			CertDownloader:            m("rancher/rke-tools:v0.1.4"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.4"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.8"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.8"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.8"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.10.2-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
		},
		"v1.10.1-rancher2-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.10.1-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.8"),
			NginxProxy:                m("rancher/rke-tools:v0.1.8"),
			CertDownloader:            m("rancher/rke-tools:v0.1.8"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.8"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.8"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.8"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.8"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.10.2-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
		},
		"v1.10.3-rancher2-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.10.3-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.10"),
			NginxProxy:                m("rancher/rke-tools:v0.1.10"),
			CertDownloader:            m("rancher/rke-tools:v0.1.10"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.10"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.8"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.8"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.8"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.10.2-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
		},
		"v1.10.5-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.10.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.10"),
			NginxProxy:                m("rancher/rke-tools:v0.1.10"),
			CertDownloader:            m("rancher/rke-tools:v0.1.10"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.10"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.8"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.8"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.8"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.10.2-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
		},
		"v1.10.5-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.10.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.13"),
			NginxProxy:                m("rancher/rke-tools:v0.1.13"),
			CertDownloader:            m("rancher/rke-tools:v0.1.13"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.13"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.8"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.8"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.8"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.10.11-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.10.11-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.13"),
			NginxProxy:                m("rancher/rke-tools:v0.1.13"),
			CertDownloader:            m("rancher/rke-tools:v0.1.13"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.13"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.8"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.8"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.8"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.10.12-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.1.12"),
			Kubernetes:                m("rancher/hyperkube:v1.10.12-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.13"),
			NginxProxy:                m("rancher/rke-tools:v0.1.13"),
			CertDownloader:            m("rancher/rke-tools:v0.1.13"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.13"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.8"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.8"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.8"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.1-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.1-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.13"),
			NginxProxy:                m("rancher/rke-tools:v0.1.13"),
			CertDownloader:            m("rancher/rke-tools:v0.1.13"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.13"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.2-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.2-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.13"),
			NginxProxy:                m("rancher/rke-tools:v0.1.13"),
			CertDownloader:            m("rancher/rke-tools:v0.1.13"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.13"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.9.1"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.2.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.1"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.9.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.2-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.2-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.3-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.3-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.5-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.8-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.8-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.15"),
			NginxProxy:                m("rancher/rke-tools:v0.1.15"),
			CertDownloader:            m("rancher/rke-tools:v0.1.15"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.15"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.6-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.6-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.15"),
			NginxProxy:                m("rancher/rke-tools:v0.1.15"),
			CertDownloader:            m("rancher/rke-tools:v0.1.15"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.15"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.11.9-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.15"),
			NginxProxy:                m("rancher/rke-tools:v0.1.15"),
			CertDownloader:            m("rancher/rke-tools:v0.1.15"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.15"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		// Enabled in Rancher v2.2.3
		"v1.11.9-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.28"),
			NginxProxy:                m("rancher/rke-tools:v0.1.28"),
			CertDownloader:            m("rancher/rke-tools:v0.1.28"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.28"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		"v1.12.0-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.0-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.2",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
		},
		"v1.12.1-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.1-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.2",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
		},
		"v1.12.3-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.3-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.18"),
			NginxProxy:                m("rancher/rke-tools:v0.1.18"),
			CertDownloader:            m("rancher/rke-tools:v0.1.18"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.18"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.2",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
		},
		"v1.12.4-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.4-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.27"),
			NginxProxy:                m("rancher/rke-tools:v0.1.27"),
			CertDownloader:            m("rancher/rke-tools:v0.1.27"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.27"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.2",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
		},
		"v1.12.5-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.27"),
			NginxProxy:                m("rancher/rke-tools:v0.1.27"),
			CertDownloader:            m("rancher/rke-tools:v0.1.27"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.27"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.2",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
		},
		"v1.12.6-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.12.6-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.27"),
			NginxProxy:                m("rancher/rke-tools:v0.1.27"),
			CertDownloader:            m("rancher/rke-tools:v0.1.27"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.27"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.2",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		"v1.12.7-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.12.7-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.27"),
			NginxProxy:                m("rancher/rke-tools:v0.1.27"),
			CertDownloader:            m("rancher/rke-tools:v0.1.27"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.27"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.2",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.3
		"v1.12.7-rancher1-3": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.12.7-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.28"),
			NginxProxy:                m("rancher/rke-tools:v0.1.28"),
			CertDownloader:            m("rancher/rke-tools:v0.1.28"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.28"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.5
		"v1.12.9-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.12.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.34"),
			NginxProxy:                m("rancher/rke-tools:v0.1.34"),
			CertDownloader:            m("rancher/rke-tools:v0.1.34"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.34"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.7
		"v1.12.10-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.12.10-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.40"),
			NginxProxy:                m("rancher/rke-tools:v0.1.40"),
			CertDownloader:            m("rancher/rke-tools:v0.1.40"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.40"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.8
		// Added to bump rke-tools v0.1.42 which is compiled using Go 1.12.9
		"v1.12.10-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.12.10-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.42"),
			NginxProxy:                m("rancher/rke-tools:v0.1.42"),
			CertDownloader:            m("rancher/rke-tools:v0.1.42"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.42"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		"v1.13.1-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.13.1-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.27"),
			NginxProxy:                m("rancher/rke-tools:v0.1.27"),
			CertDownloader:            m("rancher/rke-tools:v0.1.27"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.27"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.6",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
		},
		"v1.13.4-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.4-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.27"),
			NginxProxy:                m("rancher/rke-tools:v0.1.27"),
			CertDownloader:            m("rancher/rke-tools:v0.1.27"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.27"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.6",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		"v1.13.5-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.27"),
			NginxProxy:                m("rancher/rke-tools:v0.1.27"),
			CertDownloader:            m("rancher/rke-tools:v0.1.27"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.27"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.2.6",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.3
		"v1.13.5-rancher1-3": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.28"),
			NginxProxy:                m("rancher/rke-tools:v0.1.28"),
			CertDownloader:            m("rancher/rke-tools:v0.1.28"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.28"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.6"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.5
		"v1.13.7-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.7-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.34"),
			NginxProxy:                m("rancher/rke-tools:v0.1.34"),
			CertDownloader:            m("rancher/rke-tools:v0.1.34"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.34"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.6"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.7
		// v1.13.9-rancher1-1 is the backported version made available due to older rke-tools (see line #1321)
		"v1.13.9-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.40"),
			NginxProxy:                m("rancher/rke-tools:v0.1.40"),
			CertDownloader:            m("rancher/rke-tools:v0.1.40"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.40"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.6"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.8
		// v1.13.10-rancher1-1 is the backported version made available due to older rke-tools
		"v1.13.10-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.10-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.42"),
			NginxProxy:                m("rancher/rke-tools:v0.1.42"),
			CertDownloader:            m("rancher/rke-tools:v0.1.42"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.42"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.6"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.3.0
		"v1.13.11-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.11-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.6"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.3.1
		"v1.13.12-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.12-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.6"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.3.2
		"v1.13.12-rancher2-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.13.12-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.2.6"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.0.0"),
		},
		// Enabled in Rancher v2.2.2
		"v1.14.1-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.1-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.28"),
			NginxProxy:                m("rancher/rke-tools:v0.1.28"),
			CertDownloader:            m("rancher/rke-tools:v0.1.28"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.28"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   "coredns/coredns:1.3.1",
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.2.3
		"v1.14.1-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.1-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.28"),
			NginxProxy:                m("rancher/rke-tools:v0.1.28"),
			CertDownloader:            m("rancher/rke-tools:v0.1.28"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.28"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.2.5
		"v1.14.3-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.3-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.34"),
			NginxProxy:                m("rancher/rke-tools:v0.1.34"),
			CertDownloader:            m("rancher/rke-tools:v0.1.34"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.34"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.2.7
		"v1.14.5-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.40"),
			NginxProxy:                m("rancher/rke-tools:v0.1.40"),
			CertDownloader:            m("rancher/rke-tools:v0.1.40"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.40"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.2.8
		"v1.14.6-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.6-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.42"),
			NginxProxy:                m("rancher/rke-tools:v0.1.42"),
			CertDownloader:            m("rancher/rke-tools:v0.1.42"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.42"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.3.0
		"v1.14.7-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.7-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.3.0
		"v1.14.8-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.8-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.3.0
		"v1.14.8-rancher2-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.8-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.51"),
			NginxProxy:                m("rancher/rke-tools:v0.1.51"),
			CertDownloader:            m("rancher/rke-tools:v0.1.51"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.51"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.3.3
		"v1.14.9-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.51"),
			NginxProxy:                m("rancher/rke-tools:v0.1.51"),
			CertDownloader:            m("rancher/rke-tools:v0.1.51"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.51"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.3.4
		"v1.14.9-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.14.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.1"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Experimental in Rancher v2.2.5
		"v1.15.0-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.0-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.34"),
			NginxProxy:                m("rancher/rke-tools:v0.1.34"),
			CertDownloader:            m("rancher/rke-tools:v0.1.34"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.34"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		"v1.15.2-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.2-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.40"),
			NginxProxy:                m("rancher/rke-tools:v0.1.40"),
			CertDownloader:            m("rancher/rke-tools:v0.1.40"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.40"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Experimental in Rancher v2.2.8
		"v1.15.3-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.3-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.42"),
			NginxProxy:                m("rancher/rke-tools:v0.1.42"),
			CertDownloader:            m("rancher/rke-tools:v0.1.42"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.42"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher1"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher3"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.2.9
		"v1.15.4-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.4-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.3.0
		"v1.15.4-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.4-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Enabled in Rancher v2.2.9
		"v1.15.5-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
		},
		// Enabled in Rancher v2.3.0
		"v1.15.5-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Enabled in Rancher v2.3.0
		"v1.15.5-rancher2-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.5-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.51"),
			NginxProxy:                m("rancher/rke-tools:v0.1.51"),
			CertDownloader:            m("rancher/rke-tools:v0.1.51"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.51"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Enabled in Rancher v2.3.3
		"v1.15.6-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.6-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.51"),
			NginxProxy:                m("rancher/rke-tools:v0.1.51"),
			CertDownloader:            m("rancher/rke-tools:v0.1.51"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.51"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Enabled in Rancher v2.3.4
		"v1.15.7-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.7-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Out of band post v2.3.4
		"v1.15.9-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.10-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.15.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.7.4"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.7.4"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.7.4"),
			CanalNode:                 m("quay.io/calico/node:v3.7.4"),
			CanalCNI:                  m("quay.io/calico/cni:v3.7.4"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.3"),
			CoreDNS:                   m("coredns/coredns:1.3.1"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.3.0"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Experimental in Rancher v2.3.0
		"v1.16.1-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.15-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.16.1-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.8.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.8.1"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.8.1"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			CanalNode:                 m("quay.io/calico/node:v3.8.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.8.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.4"),
			CoreDNS:                   m("coredns/coredns:1.6.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Experimental in Rancher v2.3.0
		"v1.16.2-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.15-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.16.2-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.50"),
			NginxProxy:                m("rancher/rke-tools:v0.1.50"),
			CertDownloader:            m("rancher/rke-tools:v0.1.50"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.50"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.8.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.8.1"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.8.1"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			CanalNode:                 m("quay.io/calico/node:v3.8.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.8.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.4"),
			CoreDNS:                   m("coredns/coredns:1.6.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Experimental in Rancher v2.3.0
		"v1.16.2-rancher2-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.15-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.16.2-rancher2"),
			Alpine:                    m("rancher/rke-tools:v0.1.51"),
			NginxProxy:                m("rancher/rke-tools:v0.1.51"),
			CertDownloader:            m("rancher/rke-tools:v0.1.51"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.51"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.8.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.8.1"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.8.1"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			CanalNode:                 m("quay.io/calico/node:v3.8.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.8.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.4"),
			CoreDNS:                   m("coredns/coredns:1.6.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Enabled in Rancher v2.3.3
		"v1.16.3-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.15-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.16.3-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.51"),
			NginxProxy:                m("rancher/rke-tools:v0.1.51"),
			CertDownloader:            m("rancher/rke-tools:v0.1.51"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.51"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.8.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.8.1"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.8.1"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			CanalNode:                 m("quay.io/calico/node:v3.8.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.8.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.4"),
			CoreDNS:                   m("coredns/coredns:1.6.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Enabled in Rancher v2.3.4
		"v1.16.4-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.15-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.16.4-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.10.2"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.10.2"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.10.2"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			CanalNode:                 m("quay.io/calico/node:v3.10.2"),
			CanalCNI:                  m("quay.io/calico/cni:v3.10.2"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.4"),
			CoreDNS:                   m("coredns/coredns:1.6.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Out of band post v2.3.4
		"v1.16.6-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.15-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.16.6-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.10.2"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.10.2"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.10.2"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			CanalNode:                 m("quay.io/calico/node:v3.10.2"),
			CanalCNI:                  m("quay.io/calico/cni:v3.10.2"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.4"),
			CoreDNS:                   m("coredns/coredns:1.6.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Out of band post v2.3.4 for calicoCtl
		"v1.16.6-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.3.15-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.16.6-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.10.2"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.10.2"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.10.2"),
			CalicoCtl:                 m("rancher/calico-ctl:v2.0.0"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			CanalNode:                 m("quay.io/calico/node:v3.10.2"),
			CanalCNI:                  m("quay.io/calico/cni:v3.10.2"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.4"),
			CoreDNS:                   m("coredns/coredns:1.6.2"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		//Experimental out of band
		"v1.17.0-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.4.3-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.17.0-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.51"),
			NginxProxy:                m("rancher/rke-tools:v0.1.51"),
			CertDownloader:            m("rancher/rke-tools:v0.1.51"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.51"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.8.1"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.8.1"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.8.1"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			CanalNode:                 m("quay.io/calico/node:v3.8.1"),
			CanalCNI:                  m("quay.io/calico/cni:v3.8.1"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.8.1"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.6"),
			CoreDNS:                   m("coredns/coredns:1.6.5"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		//Enabled in Rancher v2.3.4
		"v1.17.0-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.4.3-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.17.0-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.10.2"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.10.2"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.10.2"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			CanalNode:                 m("quay.io/calico/node:v3.10.2"),
			CanalCNI:                  m("quay.io/calico/cni:v3.10.2"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.6"),
			CoreDNS:                   m("coredns/coredns:1.6.5"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Out of band post v2.3.4
		"v1.17.2-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.4.3-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.17.2-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.10.2"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.10.2"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.10.2"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			CanalNode:                 m("quay.io/calico/node:v3.10.2"),
			CanalCNI:                  m("quay.io/calico/cni:v3.10.2"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.6"),
			CoreDNS:                   m("coredns/coredns:1.6.5"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// Out of band post v2.3.4 for calicoCtl
		"v1.17.2-rancher1-2": {
			Etcd:                      m("quay.io/coreos/etcd:v3.4.3-rancher1"),
			Kubernetes:                m("rancher/hyperkube:v1.17.2-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.52"),
			NginxProxy:                m("rancher/rke-tools:v0.1.52"),
			CertDownloader:            m("rancher/rke-tools:v0.1.52"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.52"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			Flannel:                   m("quay.io/coreos/flannel:v0.11.0-rancher1"),
			FlannelCNI:                m("rancher/flannel-cni:v0.3.0-rancher5"),
			CalicoNode:                m("quay.io/calico/node:v3.10.2"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.10.2"),
			CalicoControllers:         m("quay.io/calico/kube-controllers:v3.10.2"),
			CalicoCtl:                 m("rancher/calico-ctl:v2.0.0"),
			CalicoFlexVol:             m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			CanalNode:                 m("quay.io/calico/node:v3.10.2"),
			CanalCNI:                  m("quay.io/calico/cni:v3.10.2"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.11.0"),
			CanalFlexVol:              m("quay.io/calico/pod2daemon-flexvol:v3.10.2"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:nginx-0.25.1-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.5-rancher1"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server:v0.3.6"),
			CoreDNS:                   m("coredns/coredns:1.6.5"),
			CoreDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler:1.7.1"),
			WindowsPodInfraContainer:  m("rancher/kubelet-pause:v0.1.3"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.11.9-rancher1-3": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.18"),
			Kubernetes:                m("rancher/hyperkube:v1.11.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16-2"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16-2"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16-2"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16-2"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.10"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.10"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.10"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.1.2"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.1.2"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.16.2-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.2.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.12.5-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.12.6-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.6-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.12.7-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.7-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.12.7-rancher1-4": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.12.7-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16-2"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16-2"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16-2"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16-2"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.14.13"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.14.13"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.14.13"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.1.3"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.1.3"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.1.3"),
			CanalCNI:                  m("quay.io/calico/cni:v3.1.3"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.13.1-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.13.1-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.13.4-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.13.4-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.13.5-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.13.5-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.13.9-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.13.9-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
		// k8s version from 2.1.x release with old rke-tools to allow upgrade from 2.1.x clusters
		// without all clusters being restarted
		"v1.13.10-rancher1-1": {
			Etcd:                      m("quay.io/coreos/etcd:v3.2.24"),
			Kubernetes:                m("rancher/hyperkube:v1.13.10-rancher1"),
			Alpine:                    m("rancher/rke-tools:v0.1.16-2"),
			NginxProxy:                m("rancher/rke-tools:v0.1.16-2"),
			CertDownloader:            m("rancher/rke-tools:v0.1.16-2"),
			KubernetesServicesSidecar: m("rancher/rke-tools:v0.1.16-2"),
			KubeDNS:                   m("gcr.io/google_containers/k8s-dns-kube-dns-amd64:1.15.0"),
			DNSmasq:                   m("gcr.io/google_containers/k8s-dns-dnsmasq-nanny-amd64:1.15.0"),
			KubeDNSSidecar:            m("gcr.io/google_containers/k8s-dns-sidecar-amd64:1.15.0"),
			KubeDNSAutoscaler:         m("gcr.io/google_containers/cluster-proportional-autoscaler-amd64:1.0.0"),
			Flannel:                   m("quay.io/coreos/flannel:v0.10.0"),
			FlannelCNI:                m("quay.io/coreos/flannel-cni:v0.3.0"),
			CalicoNode:                m("quay.io/calico/node:v3.4.0"),
			CalicoCNI:                 m("quay.io/calico/cni:v3.4.0"),
			CalicoCtl:                 m("quay.io/calico/ctl:v2.0.0"),
			CanalNode:                 m("quay.io/calico/node:v3.4.0"),
			CanalCNI:                  m("quay.io/calico/cni:v3.4.0"),
			CanalFlannel:              m("quay.io/coreos/flannel:v0.10.0"),
			WeaveNode:                 m("weaveworks/weave-kube:2.5.0"),
			WeaveCNI:                  m("weaveworks/weave-npc:2.5.0"),
			PodInfraContainer:         m("gcr.io/google_containers/pause-amd64:3.1"),
			Ingress:                   m("rancher/nginx-ingress-controller:0.21.0-rancher1"),
			IngressBackend:            m("k8s.gcr.io/defaultbackend:1.4"),
			MetricsServer:             m("gcr.io/google_containers/metrics-server-amd64:v0.3.1"),
		},
	}
}
