---
title: "Gofile"
description: "Rclone docs for Gofile"
versionIntroduced: "v1.68"
---

# {{< icon "fa fa-folder" >}} Gofile

[Gofile](https://gofile.io) is a content storage and distribution
platform. Its aim is to provide as much service as possible for free
or at a very low price.

The initial setup for Gofile involves logging in to the web interface
and going to the "My Profile" section. Copy the "Account API token"
for use in the config file.

Note that if you wish to connect rclone to Gofile you will need a
premium account.

## Configuration

Here is an example of how to make a remote called `remote`.  First run:

     rclone config

This will guide you through an interactive setup process:

```
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n

Enter name for new remote.
name> remote

Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
XX / Gofile
   \ (gofile)
Storage> gofile

Option access_token.
API Access token
You can get this from the web control panel.
Enter a value. Press Enter to leave empty.
access_token> YOURACCESSTOKEN

Edit advanced config?
y) Yes
n) No (default)
y/n> n

Configuration complete.
Options:
- type: gofile
- access_token: YOURACCESSTOKEN
Keep this "remote" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

Once configured you can then use `rclone` like this,

List directories and files in the top level of your Gofile

    rclone lsf remote:

To copy a local directory to an Gofile directory called backup

    rclone copy /home/source remote:backup

### Modification times and hashes

Gofile supports modification times with a resolution of 1 second.

Gofile supports MD5 hashes, so you can use the `--checksum` flag.

### Restricted filename characters

In addition to the [default restricted characters set](/overview/#restricted-characters)
the following characters are also replaced:

| Character | Value | Replacement |
| --------- |:-----:|:-----------:|
| !         | 0x21  | ！           |
| "         | 0x22  | ＂           |
| *         | 0x2A  | ＊           |
| :         | 0x3A  | ：           |
| <         | 0x3C  | ＜           |
| >         | 0x3E  | ＞           |
| ?         | 0x3F  | ？           |
| \         | 0x5C  | ＼           |
| \|        | 0x7C  | ｜           |


File names can also not start or end with the following characters.
These only get replaced if they are the first or last character in the
name:

| Character | Value | Replacement |
| --------- |:-----:|:-----------:|
| .         | 0x2E  | ．           |

Invalid UTF-8 bytes will also be [replaced](/overview/#invalid-utf8),
as they can't be used in JSON strings.

### Public Links

Gofile supports `rclone link` to make public links to files or
directories. If you specify a directory it will download as a `zip`
file. You can use the `--expire` flag to specify the time the link
should be valid. Note that `rclone link --unlink` removes all the
public links for a file.

### Root folder ID

You can set the `root_folder_id` for rclone.  This is the directory
(identified by its `Folder ID`) that rclone considers to be the root
of your Gofile drive.

Normally you will leave this blank and rclone will determine the
correct root to use itself and fill in the value in the config file.

However you can set this to restrict rclone to a specific folder
hierarchy.

In order to do this you will have to find the `Folder ID` of the
directory you wish rclone to display.

You can do this with rclone

```
$ rclone lsf -Fip --dirs-only remote:
d6341f53-ee65-4f29-9f59-d11e8070b2a0;Files/
f4f5c9b8-6ece-478b-b03e-4538edfe5a1c;Photos/
d50e356c-29ca-4b27-a3a7-494d91026e04;Videos/
```

The ID to use is the part before the `;` so you could set

```
root_folder_id = d6341f53-ee65-4f29-9f59-d11e8070b2a0
```

To restrict rclone to the `Files` directory.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/gofile/gofile.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to gofile (Gofile).

#### --gofile-access-token

API Access token

You can get this from the web control panel.

Properties:

- Config:      access_token
- Env Var:     RCLONE_GOFILE_ACCESS_TOKEN
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to gofile (Gofile).

#### --gofile-root-folder-id

ID of the root folder

Leave this blank normally, rclone will fill it in automatically.

If you want rclone to be restricted to a particular folder you can
fill it in - see the docs for more info.


Properties:

- Config:      root_folder_id
- Env Var:     RCLONE_GOFILE_ROOT_FOLDER_ID
- Type:        string
- Required:    false

#### --gofile-account-id

Account ID

Leave this blank normally, rclone will fill it in automatically.


Properties:

- Config:      account_id
- Env Var:     RCLONE_GOFILE_ACCOUNT_ID
- Type:        string
- Required:    false

#### --gofile-list-chunk

Number of items to list in each call

Properties:

- Config:      list_chunk
- Env Var:     RCLONE_GOFILE_LIST_CHUNK
- Type:        int
- Default:     1000

#### --gofile-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_GOFILE_ENCODING
- Type:        Encoding
- Default:     Slash,LtGt,DoubleQuote,Colon,Question,Asterisk,Pipe,BackSlash,Del,Ctl,LeftPeriod,RightPeriod,InvalidUtf8,Dot,Exclamation

#### --gofile-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_GOFILE_DESCRIPTION
- Type:        string
- Required:    false

{{< rem autogenerated options stop >}}

## Limitations

Gofile only supports filenames up to 255 characters in length, where a
character is a unicode character.

Directories should not be cached for more than 24h otherwise files in
the directory may not be downloadable. In practice this means when
using a VFS based rclone command such as `rclone mount` you should
make sure `--dir-cache-time` is less than `24h`.

Note that Gofile is currently limited to a total of 100,000 items. If
you attempt to upload more than that you will get
`error-limit-100000`. This limit may be lifted in the future.

### Duplicated files

Gofile is capable of having files with duplicated file names. For
instance two files called `hello.txt` in the same directory.

Rclone cannot sync that to a normal file system but it can be fixed
with the `rclone dedupe` command.

Duplicated files cause problems with the syncing and you will see
messages in the log about duplicates.

Use `rclone dedupe` to fix duplicated files.
