// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: piecestore2.proto

package pb

import (
	context "context"
	fmt "fmt"
	math "math"
	time "time"

	proto "github.com/gogo/protobuf/proto"

	drpc "storj.io/drpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type PieceHeader_FormatVersion int32

const (
	PieceHeader_FORMAT_V0 PieceHeader_FormatVersion = 0
	PieceHeader_FORMAT_V1 PieceHeader_FormatVersion = 1
)

var PieceHeader_FormatVersion_name = map[int32]string{
	0: "FORMAT_V0",
	1: "FORMAT_V1",
}

var PieceHeader_FormatVersion_value = map[string]int32{
	"FORMAT_V0": 0,
	"FORMAT_V1": 1,
}

func (x PieceHeader_FormatVersion) String() string {
	return proto.EnumName(PieceHeader_FormatVersion_name, int32(x))
}

func (PieceHeader_FormatVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{12, 0}
}

// Expected order of messages from uplink:
//   OrderLimit ->
//   repeated
//      Order ->
//      Chunk ->
//   PieceHash signed by uplink ->
//      <- PieceHash signed by storage node
type PieceUploadRequest struct {
	// first message to show that we are allowed to upload
	Limit *OrderLimit `protobuf:"bytes,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// order for uploading
	Order *Order                    `protobuf:"bytes,2,opt,name=order,proto3" json:"order,omitempty"`
	Chunk *PieceUploadRequest_Chunk `protobuf:"bytes,3,opt,name=chunk,proto3" json:"chunk,omitempty"`
	// final message
	Done                 *PieceHash `protobuf:"bytes,4,opt,name=done,proto3" json:"done,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *PieceUploadRequest) Reset()         { *m = PieceUploadRequest{} }
func (m *PieceUploadRequest) String() string { return proto.CompactTextString(m) }
func (*PieceUploadRequest) ProtoMessage()    {}
func (*PieceUploadRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{0}
}
func (m *PieceUploadRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceUploadRequest.Unmarshal(m, b)
}
func (m *PieceUploadRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceUploadRequest.Marshal(b, m, deterministic)
}
func (m *PieceUploadRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceUploadRequest.Merge(m, src)
}
func (m *PieceUploadRequest) XXX_Size() int {
	return xxx_messageInfo_PieceUploadRequest.Size(m)
}
func (m *PieceUploadRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceUploadRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PieceUploadRequest proto.InternalMessageInfo

func (m *PieceUploadRequest) GetLimit() *OrderLimit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *PieceUploadRequest) GetOrder() *Order {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *PieceUploadRequest) GetChunk() *PieceUploadRequest_Chunk {
	if m != nil {
		return m.Chunk
	}
	return nil
}

func (m *PieceUploadRequest) GetDone() *PieceHash {
	if m != nil {
		return m.Done
	}
	return nil
}

// data message
type PieceUploadRequest_Chunk struct {
	Offset               int64    `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PieceUploadRequest_Chunk) Reset()         { *m = PieceUploadRequest_Chunk{} }
func (m *PieceUploadRequest_Chunk) String() string { return proto.CompactTextString(m) }
func (*PieceUploadRequest_Chunk) ProtoMessage()    {}
func (*PieceUploadRequest_Chunk) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{0, 0}
}
func (m *PieceUploadRequest_Chunk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceUploadRequest_Chunk.Unmarshal(m, b)
}
func (m *PieceUploadRequest_Chunk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceUploadRequest_Chunk.Marshal(b, m, deterministic)
}
func (m *PieceUploadRequest_Chunk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceUploadRequest_Chunk.Merge(m, src)
}
func (m *PieceUploadRequest_Chunk) XXX_Size() int {
	return xxx_messageInfo_PieceUploadRequest_Chunk.Size(m)
}
func (m *PieceUploadRequest_Chunk) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceUploadRequest_Chunk.DiscardUnknown(m)
}

var xxx_messageInfo_PieceUploadRequest_Chunk proto.InternalMessageInfo

func (m *PieceUploadRequest_Chunk) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *PieceUploadRequest_Chunk) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type PieceUploadResponse struct {
	Done                 *PieceHash `protobuf:"bytes,1,opt,name=done,proto3" json:"done,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *PieceUploadResponse) Reset()         { *m = PieceUploadResponse{} }
func (m *PieceUploadResponse) String() string { return proto.CompactTextString(m) }
func (*PieceUploadResponse) ProtoMessage()    {}
func (*PieceUploadResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{1}
}
func (m *PieceUploadResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceUploadResponse.Unmarshal(m, b)
}
func (m *PieceUploadResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceUploadResponse.Marshal(b, m, deterministic)
}
func (m *PieceUploadResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceUploadResponse.Merge(m, src)
}
func (m *PieceUploadResponse) XXX_Size() int {
	return xxx_messageInfo_PieceUploadResponse.Size(m)
}
func (m *PieceUploadResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceUploadResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PieceUploadResponse proto.InternalMessageInfo

func (m *PieceUploadResponse) GetDone() *PieceHash {
	if m != nil {
		return m.Done
	}
	return nil
}

// Expected order of messages from uplink:
//   {OrderLimit, Chunk} ->
//   go repeated
//      Order -> (async)
//   go repeated
//      <- PieceDownloadResponse.Chunk
type PieceDownloadRequest struct {
	// first message to show that we are allowed to upload
	Limit *OrderLimit `protobuf:"bytes,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// order for downloading
	Order *Order `protobuf:"bytes,2,opt,name=order,proto3" json:"order,omitempty"`
	// request for the chunk
	Chunk                *PieceDownloadRequest_Chunk `protobuf:"bytes,3,opt,name=chunk,proto3" json:"chunk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *PieceDownloadRequest) Reset()         { *m = PieceDownloadRequest{} }
func (m *PieceDownloadRequest) String() string { return proto.CompactTextString(m) }
func (*PieceDownloadRequest) ProtoMessage()    {}
func (*PieceDownloadRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{2}
}
func (m *PieceDownloadRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceDownloadRequest.Unmarshal(m, b)
}
func (m *PieceDownloadRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceDownloadRequest.Marshal(b, m, deterministic)
}
func (m *PieceDownloadRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceDownloadRequest.Merge(m, src)
}
func (m *PieceDownloadRequest) XXX_Size() int {
	return xxx_messageInfo_PieceDownloadRequest.Size(m)
}
func (m *PieceDownloadRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceDownloadRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PieceDownloadRequest proto.InternalMessageInfo

func (m *PieceDownloadRequest) GetLimit() *OrderLimit {
	if m != nil {
		return m.Limit
	}
	return nil
}

func (m *PieceDownloadRequest) GetOrder() *Order {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *PieceDownloadRequest) GetChunk() *PieceDownloadRequest_Chunk {
	if m != nil {
		return m.Chunk
	}
	return nil
}

// Chunk that we wish to download
type PieceDownloadRequest_Chunk struct {
	Offset               int64    `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	ChunkSize            int64    `protobuf:"varint,2,opt,name=chunk_size,json=chunkSize,proto3" json:"chunk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PieceDownloadRequest_Chunk) Reset()         { *m = PieceDownloadRequest_Chunk{} }
func (m *PieceDownloadRequest_Chunk) String() string { return proto.CompactTextString(m) }
func (*PieceDownloadRequest_Chunk) ProtoMessage()    {}
func (*PieceDownloadRequest_Chunk) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{2, 0}
}
func (m *PieceDownloadRequest_Chunk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceDownloadRequest_Chunk.Unmarshal(m, b)
}
func (m *PieceDownloadRequest_Chunk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceDownloadRequest_Chunk.Marshal(b, m, deterministic)
}
func (m *PieceDownloadRequest_Chunk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceDownloadRequest_Chunk.Merge(m, src)
}
func (m *PieceDownloadRequest_Chunk) XXX_Size() int {
	return xxx_messageInfo_PieceDownloadRequest_Chunk.Size(m)
}
func (m *PieceDownloadRequest_Chunk) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceDownloadRequest_Chunk.DiscardUnknown(m)
}

var xxx_messageInfo_PieceDownloadRequest_Chunk proto.InternalMessageInfo

func (m *PieceDownloadRequest_Chunk) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *PieceDownloadRequest_Chunk) GetChunkSize() int64 {
	if m != nil {
		return m.ChunkSize
	}
	return 0
}

type PieceDownloadResponse struct {
	Chunk                *PieceDownloadResponse_Chunk `protobuf:"bytes,1,opt,name=chunk,proto3" json:"chunk,omitempty"`
	Hash                 *PieceHash                   `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	Limit                *OrderLimit                  `protobuf:"bytes,3,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *PieceDownloadResponse) Reset()         { *m = PieceDownloadResponse{} }
func (m *PieceDownloadResponse) String() string { return proto.CompactTextString(m) }
func (*PieceDownloadResponse) ProtoMessage()    {}
func (*PieceDownloadResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{3}
}
func (m *PieceDownloadResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceDownloadResponse.Unmarshal(m, b)
}
func (m *PieceDownloadResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceDownloadResponse.Marshal(b, m, deterministic)
}
func (m *PieceDownloadResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceDownloadResponse.Merge(m, src)
}
func (m *PieceDownloadResponse) XXX_Size() int {
	return xxx_messageInfo_PieceDownloadResponse.Size(m)
}
func (m *PieceDownloadResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceDownloadResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PieceDownloadResponse proto.InternalMessageInfo

func (m *PieceDownloadResponse) GetChunk() *PieceDownloadResponse_Chunk {
	if m != nil {
		return m.Chunk
	}
	return nil
}

func (m *PieceDownloadResponse) GetHash() *PieceHash {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *PieceDownloadResponse) GetLimit() *OrderLimit {
	if m != nil {
		return m.Limit
	}
	return nil
}

// Chunk response for download request
type PieceDownloadResponse_Chunk struct {
	Offset               int64    `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PieceDownloadResponse_Chunk) Reset()         { *m = PieceDownloadResponse_Chunk{} }
func (m *PieceDownloadResponse_Chunk) String() string { return proto.CompactTextString(m) }
func (*PieceDownloadResponse_Chunk) ProtoMessage()    {}
func (*PieceDownloadResponse_Chunk) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{3, 0}
}
func (m *PieceDownloadResponse_Chunk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceDownloadResponse_Chunk.Unmarshal(m, b)
}
func (m *PieceDownloadResponse_Chunk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceDownloadResponse_Chunk.Marshal(b, m, deterministic)
}
func (m *PieceDownloadResponse_Chunk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceDownloadResponse_Chunk.Merge(m, src)
}
func (m *PieceDownloadResponse_Chunk) XXX_Size() int {
	return xxx_messageInfo_PieceDownloadResponse_Chunk.Size(m)
}
func (m *PieceDownloadResponse_Chunk) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceDownloadResponse_Chunk.DiscardUnknown(m)
}

var xxx_messageInfo_PieceDownloadResponse_Chunk proto.InternalMessageInfo

func (m *PieceDownloadResponse_Chunk) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *PieceDownloadResponse_Chunk) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type PieceDeleteRequest struct {
	Limit                *OrderLimit `protobuf:"bytes,1,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PieceDeleteRequest) Reset()         { *m = PieceDeleteRequest{} }
func (m *PieceDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*PieceDeleteRequest) ProtoMessage()    {}
func (*PieceDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{4}
}
func (m *PieceDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceDeleteRequest.Unmarshal(m, b)
}
func (m *PieceDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceDeleteRequest.Marshal(b, m, deterministic)
}
func (m *PieceDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceDeleteRequest.Merge(m, src)
}
func (m *PieceDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_PieceDeleteRequest.Size(m)
}
func (m *PieceDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PieceDeleteRequest proto.InternalMessageInfo

func (m *PieceDeleteRequest) GetLimit() *OrderLimit {
	if m != nil {
		return m.Limit
	}
	return nil
}

type PieceDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PieceDeleteResponse) Reset()         { *m = PieceDeleteResponse{} }
func (m *PieceDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*PieceDeleteResponse) ProtoMessage()    {}
func (*PieceDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{5}
}
func (m *PieceDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceDeleteResponse.Unmarshal(m, b)
}
func (m *PieceDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceDeleteResponse.Marshal(b, m, deterministic)
}
func (m *PieceDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceDeleteResponse.Merge(m, src)
}
func (m *PieceDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_PieceDeleteResponse.Size(m)
}
func (m *PieceDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PieceDeleteResponse proto.InternalMessageInfo

type DeletePiecesRequest struct {
	PieceIds             []PieceID `protobuf:"bytes,1,rep,name=piece_ids,json=pieceIds,proto3,customtype=PieceID" json:"piece_ids"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *DeletePiecesRequest) Reset()         { *m = DeletePiecesRequest{} }
func (m *DeletePiecesRequest) String() string { return proto.CompactTextString(m) }
func (*DeletePiecesRequest) ProtoMessage()    {}
func (*DeletePiecesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{6}
}
func (m *DeletePiecesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePiecesRequest.Unmarshal(m, b)
}
func (m *DeletePiecesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePiecesRequest.Marshal(b, m, deterministic)
}
func (m *DeletePiecesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePiecesRequest.Merge(m, src)
}
func (m *DeletePiecesRequest) XXX_Size() int {
	return xxx_messageInfo_DeletePiecesRequest.Size(m)
}
func (m *DeletePiecesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePiecesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePiecesRequest proto.InternalMessageInfo

type DeletePiecesResponse struct {
	UnhandledCount       int64    `protobuf:"varint,1,opt,name=unhandled_count,json=unhandledCount,proto3" json:"unhandled_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeletePiecesResponse) Reset()         { *m = DeletePiecesResponse{} }
func (m *DeletePiecesResponse) String() string { return proto.CompactTextString(m) }
func (*DeletePiecesResponse) ProtoMessage()    {}
func (*DeletePiecesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{7}
}
func (m *DeletePiecesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePiecesResponse.Unmarshal(m, b)
}
func (m *DeletePiecesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePiecesResponse.Marshal(b, m, deterministic)
}
func (m *DeletePiecesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePiecesResponse.Merge(m, src)
}
func (m *DeletePiecesResponse) XXX_Size() int {
	return xxx_messageInfo_DeletePiecesResponse.Size(m)
}
func (m *DeletePiecesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePiecesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePiecesResponse proto.InternalMessageInfo

func (m *DeletePiecesResponse) GetUnhandledCount() int64 {
	if m != nil {
		return m.UnhandledCount
	}
	return 0
}

type RetainRequest struct {
	CreationDate         time.Time `protobuf:"bytes,1,opt,name=creation_date,json=creationDate,proto3,stdtime" json:"creation_date"`
	Filter               []byte    `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RetainRequest) Reset()         { *m = RetainRequest{} }
func (m *RetainRequest) String() string { return proto.CompactTextString(m) }
func (*RetainRequest) ProtoMessage()    {}
func (*RetainRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{8}
}
func (m *RetainRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RetainRequest.Unmarshal(m, b)
}
func (m *RetainRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RetainRequest.Marshal(b, m, deterministic)
}
func (m *RetainRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetainRequest.Merge(m, src)
}
func (m *RetainRequest) XXX_Size() int {
	return xxx_messageInfo_RetainRequest.Size(m)
}
func (m *RetainRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RetainRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RetainRequest proto.InternalMessageInfo

func (m *RetainRequest) GetCreationDate() time.Time {
	if m != nil {
		return m.CreationDate
	}
	return time.Time{}
}

func (m *RetainRequest) GetFilter() []byte {
	if m != nil {
		return m.Filter
	}
	return nil
}

type RetainResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RetainResponse) Reset()         { *m = RetainResponse{} }
func (m *RetainResponse) String() string { return proto.CompactTextString(m) }
func (*RetainResponse) ProtoMessage()    {}
func (*RetainResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{9}
}
func (m *RetainResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RetainResponse.Unmarshal(m, b)
}
func (m *RetainResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RetainResponse.Marshal(b, m, deterministic)
}
func (m *RetainResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetainResponse.Merge(m, src)
}
func (m *RetainResponse) XXX_Size() int {
	return xxx_messageInfo_RetainResponse.Size(m)
}
func (m *RetainResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RetainResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RetainResponse proto.InternalMessageInfo

type RestoreTrashRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreTrashRequest) Reset()         { *m = RestoreTrashRequest{} }
func (m *RestoreTrashRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreTrashRequest) ProtoMessage()    {}
func (*RestoreTrashRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{10}
}
func (m *RestoreTrashRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreTrashRequest.Unmarshal(m, b)
}
func (m *RestoreTrashRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreTrashRequest.Marshal(b, m, deterministic)
}
func (m *RestoreTrashRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreTrashRequest.Merge(m, src)
}
func (m *RestoreTrashRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreTrashRequest.Size(m)
}
func (m *RestoreTrashRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreTrashRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreTrashRequest proto.InternalMessageInfo

type RestoreTrashResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreTrashResponse) Reset()         { *m = RestoreTrashResponse{} }
func (m *RestoreTrashResponse) String() string { return proto.CompactTextString(m) }
func (*RestoreTrashResponse) ProtoMessage()    {}
func (*RestoreTrashResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{11}
}
func (m *RestoreTrashResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreTrashResponse.Unmarshal(m, b)
}
func (m *RestoreTrashResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreTrashResponse.Marshal(b, m, deterministic)
}
func (m *RestoreTrashResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreTrashResponse.Merge(m, src)
}
func (m *RestoreTrashResponse) XXX_Size() int {
	return xxx_messageInfo_RestoreTrashResponse.Size(m)
}
func (m *RestoreTrashResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreTrashResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreTrashResponse proto.InternalMessageInfo

// PieceHeader is used in piece storage to keep track of piece attributes.
type PieceHeader struct {
	// the storage format version being used for this piece. The piece filename should agree with this.
	// The inclusion of this field is intended to aid repairability when filenames are damaged.
	FormatVersion PieceHeader_FormatVersion `protobuf:"varint,1,opt,name=format_version,json=formatVersion,proto3,enum=piecestore.PieceHeader_FormatVersion" json:"format_version,omitempty"`
	// content hash of the piece
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	// timestamp when upload occurred, as given by the "timestamp" field in the original orders.PieceHash
	CreationTime time.Time `protobuf:"bytes,3,opt,name=creation_time,json=creationTime,proto3,stdtime" json:"creation_time"`
	// signature from uplink over the original orders.PieceHash (the corresponding PieceHashSigning
	// is reconstructable using the piece id from the piecestore, the piece size from the
	// filesystem (minus the piece header size), and these (hash, upload_time, signature) fields).
	Signature []byte `protobuf:"bytes,4,opt,name=signature,proto3" json:"signature,omitempty"`
	// the OrderLimit authorizing storage of this piece, as signed by the satellite and sent by
	// the uplink
	OrderLimit           OrderLimit `protobuf:"bytes,5,opt,name=order_limit,json=orderLimit,proto3" json:"order_limit"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *PieceHeader) Reset()         { *m = PieceHeader{} }
func (m *PieceHeader) String() string { return proto.CompactTextString(m) }
func (*PieceHeader) ProtoMessage()    {}
func (*PieceHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_23ff32dd550c2439, []int{12}
}
func (m *PieceHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PieceHeader.Unmarshal(m, b)
}
func (m *PieceHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PieceHeader.Marshal(b, m, deterministic)
}
func (m *PieceHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PieceHeader.Merge(m, src)
}
func (m *PieceHeader) XXX_Size() int {
	return xxx_messageInfo_PieceHeader.Size(m)
}
func (m *PieceHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_PieceHeader.DiscardUnknown(m)
}

var xxx_messageInfo_PieceHeader proto.InternalMessageInfo

func (m *PieceHeader) GetFormatVersion() PieceHeader_FormatVersion {
	if m != nil {
		return m.FormatVersion
	}
	return PieceHeader_FORMAT_V0
}

func (m *PieceHeader) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *PieceHeader) GetCreationTime() time.Time {
	if m != nil {
		return m.CreationTime
	}
	return time.Time{}
}

func (m *PieceHeader) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *PieceHeader) GetOrderLimit() OrderLimit {
	if m != nil {
		return m.OrderLimit
	}
	return OrderLimit{}
}

func init() {
	proto.RegisterEnum("piecestore.PieceHeader_FormatVersion", PieceHeader_FormatVersion_name, PieceHeader_FormatVersion_value)
	proto.RegisterType((*PieceUploadRequest)(nil), "piecestore.PieceUploadRequest")
	proto.RegisterType((*PieceUploadRequest_Chunk)(nil), "piecestore.PieceUploadRequest.Chunk")
	proto.RegisterType((*PieceUploadResponse)(nil), "piecestore.PieceUploadResponse")
	proto.RegisterType((*PieceDownloadRequest)(nil), "piecestore.PieceDownloadRequest")
	proto.RegisterType((*PieceDownloadRequest_Chunk)(nil), "piecestore.PieceDownloadRequest.Chunk")
	proto.RegisterType((*PieceDownloadResponse)(nil), "piecestore.PieceDownloadResponse")
	proto.RegisterType((*PieceDownloadResponse_Chunk)(nil), "piecestore.PieceDownloadResponse.Chunk")
	proto.RegisterType((*PieceDeleteRequest)(nil), "piecestore.PieceDeleteRequest")
	proto.RegisterType((*PieceDeleteResponse)(nil), "piecestore.PieceDeleteResponse")
	proto.RegisterType((*DeletePiecesRequest)(nil), "piecestore.DeletePiecesRequest")
	proto.RegisterType((*DeletePiecesResponse)(nil), "piecestore.DeletePiecesResponse")
	proto.RegisterType((*RetainRequest)(nil), "piecestore.RetainRequest")
	proto.RegisterType((*RetainResponse)(nil), "piecestore.RetainResponse")
	proto.RegisterType((*RestoreTrashRequest)(nil), "piecestore.RestoreTrashRequest")
	proto.RegisterType((*RestoreTrashResponse)(nil), "piecestore.RestoreTrashResponse")
	proto.RegisterType((*PieceHeader)(nil), "piecestore.PieceHeader")
}

func init() { proto.RegisterFile("piecestore2.proto", fileDescriptor_23ff32dd550c2439) }

var fileDescriptor_23ff32dd550c2439 = []byte{
	// 786 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x54, 0x4d, 0x4f, 0x13, 0x5d,
	0x14, 0xee, 0xd0, 0x8f, 0x97, 0x1e, 0xa6, 0x05, 0x2e, 0x85, 0xf4, 0x9d, 0xbc, 0xaf, 0xad, 0xa3,
	0x48, 0x17, 0x3a, 0xc5, 0xb2, 0xd2, 0x20, 0xc4, 0xd2, 0x10, 0x49, 0x40, 0xf0, 0xf2, 0xb1, 0x70,
	0xd3, 0x0c, 0x9d, 0xdb, 0x76, 0xb4, 0x9d, 0x5b, 0x67, 0x6e, 0x35, 0xe1, 0x17, 0xb8, 0xf4, 0x37,
	0xb9, 0xf2, 0x37, 0x18, 0x83, 0x0b, 0x97, 0xfe, 0x04, 0x37, 0xe6, 0x7e, 0x4c, 0xdb, 0xa1, 0x85,
	0x06, 0x13, 0x57, 0xed, 0x3d, 0xe7, 0x39, 0xf7, 0x3c, 0xf7, 0x99, 0xe7, 0x1c, 0x58, 0xec, 0xb9,
	0xa4, 0x41, 0x02, 0x46, 0x7d, 0x52, 0xb1, 0x7a, 0x3e, 0x65, 0x14, 0xc1, 0x30, 0x64, 0x40, 0x8b,
	0xb6, 0xa8, 0x8c, 0x1b, 0x85, 0x16, 0xa5, 0xad, 0x0e, 0x29, 0x8b, 0xd3, 0x79, 0xbf, 0x59, 0x66,
	0x6e, 0x97, 0x04, 0xcc, 0xee, 0xf6, 0x14, 0x40, 0xa7, 0xbe, 0x43, 0xfc, 0x40, 0x9e, 0xcc, 0x5f,
	0x1a, 0xa0, 0x23, 0x7e, 0xd3, 0x69, 0xaf, 0x43, 0x6d, 0x07, 0x93, 0x77, 0x7d, 0x12, 0x30, 0x54,
	0x82, 0x64, 0xc7, 0xed, 0xba, 0x2c, 0xaf, 0x15, 0xb5, 0xd2, 0x5c, 0x05, 0x59, 0xaa, 0xe8, 0x90,
	0xff, 0xec, 0xf3, 0x0c, 0x96, 0x00, 0x74, 0x0f, 0x92, 0x22, 0x97, 0x9f, 0x11, 0xc8, 0x4c, 0x04,
	0x89, 0x65, 0x0e, 0x3d, 0x85, 0x64, 0xa3, 0xdd, 0xf7, 0xde, 0xe6, 0xe3, 0x02, 0x74, 0xdf, 0x1a,
	0x92, 0xb7, 0xc6, 0xbb, 0x5b, 0x3b, 0x1c, 0x8b, 0x65, 0x09, 0x5a, 0x85, 0x84, 0x43, 0x3d, 0x92,
	0x4f, 0x88, 0xd2, 0xc5, 0xf0, 0x7e, 0x51, 0xf6, 0xc2, 0x0e, 0xda, 0x58, 0xa4, 0x8d, 0x0d, 0x48,
	0x8a, 0x32, 0xb4, 0x02, 0x29, 0xda, 0x6c, 0x06, 0x44, 0x72, 0x8f, 0x63, 0x75, 0x42, 0x08, 0x12,
	0x8e, 0xcd, 0x6c, 0xc1, 0x53, 0xc7, 0xe2, 0xbf, 0xb9, 0x09, 0x4b, 0x91, 0xf6, 0x41, 0x8f, 0x7a,
	0x01, 0x19, 0xb4, 0xd4, 0x6e, 0x6c, 0x69, 0xfe, 0xd0, 0x20, 0x27, 0x62, 0x35, 0xfa, 0xc1, 0xfb,
	0x8b, 0xea, 0x6d, 0x46, 0xd5, 0x7b, 0x30, 0xa6, 0xde, 0x95, 0xfe, 0x11, 0xfd, 0x8c, 0xad, 0x69,
	0xc2, 0xfc, 0x0f, 0x20, 0x90, 0xf5, 0xc0, 0xbd, 0x20, 0x82, 0x48, 0x1c, 0xa7, 0x45, 0xe4, 0xd8,
	0xbd, 0x20, 0xe6, 0x37, 0x0d, 0x96, 0xaf, 0x74, 0x51, 0x32, 0x3d, 0x0b, 0x79, 0xc9, 0x67, 0xae,
	0xdd, 0xc0, 0x4b, 0x56, 0x8c, 0x7d, 0xd8, 0xb6, 0x1d, 0xb4, 0xd5, 0xd3, 0x27, 0xa9, 0xcc, 0xd3,
	0x43, 0x31, 0xe3, 0x53, 0xc4, 0xfc, 0x33, 0x0b, 0x6c, 0x29, 0xff, 0xd7, 0x48, 0x87, 0x30, 0x72,
	0xeb, 0x2f, 0x68, 0x2e, 0x2b, 0x0b, 0x85, 0xf5, 0xf2, 0xa5, 0xe6, 0x0e, 0x2c, 0xc9, 0x88, 0x48,
	0x06, 0xe1, 0xbd, 0x0f, 0x21, 0x2d, 0x44, 0xaa, 0xbb, 0x4e, 0x90, 0xd7, 0x8a, 0xf1, 0x92, 0x5e,
	0x9d, 0xff, 0x72, 0x59, 0x88, 0x7d, 0xbd, 0x2c, 0xfc, 0x23, 0x90, 0x7b, 0x35, 0x3c, 0x2b, 0x10,
	0x7b, 0x4e, 0x60, 0x6e, 0x43, 0x2e, 0x7a, 0x89, 0x12, 0x7e, 0x0d, 0xe6, 0xfb, 0x5e, 0xdb, 0xf6,
	0x9c, 0x0e, 0x71, 0xea, 0x0d, 0xda, 0xf7, 0xc2, 0x87, 0x66, 0x07, 0xe1, 0x1d, 0x1e, 0x35, 0x7d,
	0xc8, 0x60, 0xc2, 0x6c, 0xd7, 0x0b, 0xfb, 0xef, 0x41, 0xa6, 0xe1, 0x13, 0x9b, 0xb9, 0xd4, 0xab,
	0x3b, 0x36, 0x0b, 0x2d, 0x6e, 0x58, 0x72, 0x6b, 0x58, 0xe1, 0xd6, 0xb0, 0x4e, 0xc2, 0xad, 0x51,
	0x9d, 0xe5, 0xfc, 0x3e, 0x7d, 0x2f, 0x68, 0x58, 0x0f, 0x4b, 0x6b, 0x36, 0x23, 0x5c, 0xe4, 0xa6,
	0xdb, 0x61, 0xca, 0xbb, 0x3a, 0x56, 0x27, 0x73, 0x01, 0xb2, 0x61, 0x4f, 0xa5, 0xc5, 0x32, 0x2c,
	0x61, 0x69, 0x8b, 0x13, 0x9f, 0x7f, 0x57, 0xc9, 0xc5, 0x5c, 0x81, 0x5c, 0x34, 0xac, 0xe0, 0x9f,
	0x67, 0x60, 0x4e, 0x9a, 0x80, 0xd8, 0xdc, 0xfe, 0xfb, 0x90, 0x6d, 0x52, 0xbf, 0x6b, 0xb3, 0xfa,
	0x7b, 0xe2, 0x07, 0x2e, 0xf5, 0x04, 0xe9, 0x6c, 0x65, 0x75, 0xcc, 0x6f, 0xb2, 0xc0, 0xda, 0x15,
	0xe8, 0x33, 0x09, 0xc6, 0x99, 0xe6, 0xe8, 0x91, 0x7b, 0x60, 0xe0, 0x3a, 0x5d, 0x59, 0x6c, 0x54,
	0x15, 0xbe, 0x2e, 0x95, 0xd5, 0x6e, 0xa9, 0x0a, 0x4f, 0xa2, 0xff, 0x20, 0x1d, 0xb8, 0x2d, 0xcf,
	0x66, 0x7d, 0x5f, 0xae, 0x2c, 0x1d, 0x0f, 0x03, 0xe8, 0x09, 0xcc, 0x09, 0x23, 0xd5, 0xa5, 0xb9,
	0x92, 0xd7, 0x99, 0xab, 0x9a, 0xe0, 0xd7, 0x63, 0xa0, 0x83, 0x88, 0xf9, 0x08, 0x32, 0x91, 0x77,
	0xa1, 0x0c, 0xa4, 0x77, 0x0f, 0xf1, 0xc1, 0xf3, 0x93, 0xfa, 0xd9, 0xfa, 0x42, 0x6c, 0xf4, 0xf8,
	0x78, 0x41, 0xab, 0xfc, 0x8c, 0x03, 0x1c, 0x0d, 0xe4, 0x41, 0x07, 0x90, 0x92, 0x3b, 0x0e, 0xdd,
	0xb9, 0x79, 0xf7, 0x1a, 0x85, 0x6b, 0xf3, 0xea, 0xf3, 0xc4, 0x4a, 0x1a, 0x3a, 0x85, 0xd9, 0x70,
	0xb6, 0x51, 0x71, 0xda, 0x3a, 0x32, 0xee, 0x4e, 0x5d, 0x0c, 0xfc, 0xd2, 0x75, 0x0d, 0xbd, 0x84,
	0x94, 0xf4, 0xfb, 0x04, 0x96, 0x91, 0xf9, 0x9c, 0xc0, 0xf2, 0xca, 0xfc, 0xc5, 0x3f, 0xce, 0x68,
	0xe8, 0x15, 0xe8, 0xa3, 0xf3, 0x83, 0x22, 0x55, 0x13, 0xc6, 0xd3, 0x28, 0x5e, 0x0f, 0x50, 0xa3,
	0xb7, 0x0d, 0x29, 0xe9, 0x6e, 0xf4, 0xef, 0x28, 0x36, 0x32, 0x65, 0x86, 0x31, 0x29, 0xa5, 0x2e,
	0x38, 0x06, 0x7d, 0xd4, 0xf5, 0x51, 0x4e, 0x13, 0xc6, 0x24, 0xca, 0x69, 0xe2, 0xc0, 0xc4, 0xaa,
	0xb9, 0xd7, 0x88, 0xc7, 0xdf, 0x58, 0x2e, 0x2d, 0x37, 0x68, 0xb7, 0x4b, 0xbd, 0x72, 0xef, 0xfc,
	0x3c, 0x25, 0x7c, 0xbb, 0xf1, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x46, 0xf3, 0x6f, 0x64, 0x3e, 0x08,
	0x00, 0x00,
}

// --- DRPC BEGIN ---

type DRPCPiecestoreClient interface {
	DRPCConn() drpc.Conn

	Upload(ctx context.Context) (DRPCPiecestore_UploadClient, error)
	Download(ctx context.Context) (DRPCPiecestore_DownloadClient, error)
	Delete(ctx context.Context, in *PieceDeleteRequest) (*PieceDeleteResponse, error)
	// DeletePieces deletes a set of pieces on satellite request
	DeletePieces(ctx context.Context, in *DeletePiecesRequest) (*DeletePiecesResponse, error)
	Retain(ctx context.Context, in *RetainRequest) (*RetainResponse, error)
	RestoreTrash(ctx context.Context, in *RestoreTrashRequest) (*RestoreTrashResponse, error)
}

type drpcPiecestoreClient struct {
	cc drpc.Conn
}

func NewDRPCPiecestoreClient(cc drpc.Conn) DRPCPiecestoreClient {
	return &drpcPiecestoreClient{cc}
}

func (c *drpcPiecestoreClient) DRPCConn() drpc.Conn { return c.cc }

func (c *drpcPiecestoreClient) Upload(ctx context.Context) (DRPCPiecestore_UploadClient, error) {
	stream, err := c.cc.NewStream(ctx, "/piecestore.Piecestore/Upload")
	if err != nil {
		return nil, err
	}
	x := &drpcPiecestoreUploadClient{stream}
	return x, nil
}

type DRPCPiecestore_UploadClient interface {
	drpc.Stream
	Send(*PieceUploadRequest) error
	CloseAndRecv() (*PieceUploadResponse, error)
}

type drpcPiecestoreUploadClient struct {
	drpc.Stream
}

func (x *drpcPiecestoreUploadClient) Send(m *PieceUploadRequest) error {
	return x.MsgSend(m)
}

func (x *drpcPiecestoreUploadClient) CloseAndRecv() (*PieceUploadResponse, error) {
	if err := x.CloseSend(); err != nil {
		return nil, err
	}
	m := new(PieceUploadResponse)
	if err := x.MsgRecv(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *drpcPiecestoreClient) Download(ctx context.Context) (DRPCPiecestore_DownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, "/piecestore.Piecestore/Download")
	if err != nil {
		return nil, err
	}
	x := &drpcPiecestoreDownloadClient{stream}
	return x, nil
}

type DRPCPiecestore_DownloadClient interface {
	drpc.Stream
	Send(*PieceDownloadRequest) error
	Recv() (*PieceDownloadResponse, error)
}

type drpcPiecestoreDownloadClient struct {
	drpc.Stream
}

func (x *drpcPiecestoreDownloadClient) Send(m *PieceDownloadRequest) error {
	return x.MsgSend(m)
}

func (x *drpcPiecestoreDownloadClient) Recv() (*PieceDownloadResponse, error) {
	m := new(PieceDownloadResponse)
	if err := x.MsgRecv(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *drpcPiecestoreClient) Delete(ctx context.Context, in *PieceDeleteRequest) (*PieceDeleteResponse, error) {
	out := new(PieceDeleteResponse)
	err := c.cc.Invoke(ctx, "/piecestore.Piecestore/Delete", in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *drpcPiecestoreClient) DeletePieces(ctx context.Context, in *DeletePiecesRequest) (*DeletePiecesResponse, error) {
	out := new(DeletePiecesResponse)
	err := c.cc.Invoke(ctx, "/piecestore.Piecestore/DeletePieces", in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *drpcPiecestoreClient) Retain(ctx context.Context, in *RetainRequest) (*RetainResponse, error) {
	out := new(RetainResponse)
	err := c.cc.Invoke(ctx, "/piecestore.Piecestore/Retain", in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *drpcPiecestoreClient) RestoreTrash(ctx context.Context, in *RestoreTrashRequest) (*RestoreTrashResponse, error) {
	out := new(RestoreTrashResponse)
	err := c.cc.Invoke(ctx, "/piecestore.Piecestore/RestoreTrash", in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

type DRPCPiecestoreServer interface {
	Upload(DRPCPiecestore_UploadStream) error
	Download(DRPCPiecestore_DownloadStream) error
	Delete(context.Context, *PieceDeleteRequest) (*PieceDeleteResponse, error)
	// DeletePieces deletes a set of pieces on satellite request
	DeletePieces(context.Context, *DeletePiecesRequest) (*DeletePiecesResponse, error)
	Retain(context.Context, *RetainRequest) (*RetainResponse, error)
	RestoreTrash(context.Context, *RestoreTrashRequest) (*RestoreTrashResponse, error)
}

type DRPCPiecestoreDescription struct{}

func (DRPCPiecestoreDescription) NumMethods() int { return 6 }

func (DRPCPiecestoreDescription) Method(n int) (string, drpc.Receiver, interface{}, bool) {
	switch n {
	case 0:
		return "/piecestore.Piecestore/Upload",
			func(srv interface{}, ctx context.Context, in1, in2 interface{}) (drpc.Message, error) {
				return nil, srv.(DRPCPiecestoreServer).
					Upload(
						&drpcPiecestoreUploadStream{in1.(drpc.Stream)},
					)
			}, DRPCPiecestoreServer.Upload, true
	case 1:
		return "/piecestore.Piecestore/Download",
			func(srv interface{}, ctx context.Context, in1, in2 interface{}) (drpc.Message, error) {
				return nil, srv.(DRPCPiecestoreServer).
					Download(
						&drpcPiecestoreDownloadStream{in1.(drpc.Stream)},
					)
			}, DRPCPiecestoreServer.Download, true
	case 2:
		return "/piecestore.Piecestore/Delete",
			func(srv interface{}, ctx context.Context, in1, in2 interface{}) (drpc.Message, error) {
				return srv.(DRPCPiecestoreServer).
					Delete(
						ctx,
						in1.(*PieceDeleteRequest),
					)
			}, DRPCPiecestoreServer.Delete, true
	case 3:
		return "/piecestore.Piecestore/DeletePieces",
			func(srv interface{}, ctx context.Context, in1, in2 interface{}) (drpc.Message, error) {
				return srv.(DRPCPiecestoreServer).
					DeletePieces(
						ctx,
						in1.(*DeletePiecesRequest),
					)
			}, DRPCPiecestoreServer.DeletePieces, true
	case 4:
		return "/piecestore.Piecestore/Retain",
			func(srv interface{}, ctx context.Context, in1, in2 interface{}) (drpc.Message, error) {
				return srv.(DRPCPiecestoreServer).
					Retain(
						ctx,
						in1.(*RetainRequest),
					)
			}, DRPCPiecestoreServer.Retain, true
	case 5:
		return "/piecestore.Piecestore/RestoreTrash",
			func(srv interface{}, ctx context.Context, in1, in2 interface{}) (drpc.Message, error) {
				return srv.(DRPCPiecestoreServer).
					RestoreTrash(
						ctx,
						in1.(*RestoreTrashRequest),
					)
			}, DRPCPiecestoreServer.RestoreTrash, true
	default:
		return "", nil, nil, false
	}
}

func DRPCRegisterPiecestore(mux drpc.Mux, impl DRPCPiecestoreServer) error {
	return mux.Register(impl, DRPCPiecestoreDescription{})
}

type DRPCPiecestore_UploadStream interface {
	drpc.Stream
	SendAndClose(*PieceUploadResponse) error
	Recv() (*PieceUploadRequest, error)
}

type drpcPiecestoreUploadStream struct {
	drpc.Stream
}

func (x *drpcPiecestoreUploadStream) SendAndClose(m *PieceUploadResponse) error {
	if err := x.MsgSend(m); err != nil {
		return err
	}
	return x.CloseSend()
}

func (x *drpcPiecestoreUploadStream) Recv() (*PieceUploadRequest, error) {
	m := new(PieceUploadRequest)
	if err := x.MsgRecv(m); err != nil {
		return nil, err
	}
	return m, nil
}

type DRPCPiecestore_DownloadStream interface {
	drpc.Stream
	Send(*PieceDownloadResponse) error
	Recv() (*PieceDownloadRequest, error)
}

type drpcPiecestoreDownloadStream struct {
	drpc.Stream
}

func (x *drpcPiecestoreDownloadStream) Send(m *PieceDownloadResponse) error {
	return x.MsgSend(m)
}

func (x *drpcPiecestoreDownloadStream) Recv() (*PieceDownloadRequest, error) {
	m := new(PieceDownloadRequest)
	if err := x.MsgRecv(m); err != nil {
		return nil, err
	}
	return m, nil
}

type DRPCPiecestore_DeleteStream interface {
	drpc.Stream
	SendAndClose(*PieceDeleteResponse) error
}

type drpcPiecestoreDeleteStream struct {
	drpc.Stream
}

func (x *drpcPiecestoreDeleteStream) SendAndClose(m *PieceDeleteResponse) error {
	if err := x.MsgSend(m); err != nil {
		return err
	}
	return x.CloseSend()
}

type DRPCPiecestore_DeletePiecesStream interface {
	drpc.Stream
	SendAndClose(*DeletePiecesResponse) error
}

type drpcPiecestoreDeletePiecesStream struct {
	drpc.Stream
}

func (x *drpcPiecestoreDeletePiecesStream) SendAndClose(m *DeletePiecesResponse) error {
	if err := x.MsgSend(m); err != nil {
		return err
	}
	return x.CloseSend()
}

type DRPCPiecestore_RetainStream interface {
	drpc.Stream
	SendAndClose(*RetainResponse) error
}

type drpcPiecestoreRetainStream struct {
	drpc.Stream
}

func (x *drpcPiecestoreRetainStream) SendAndClose(m *RetainResponse) error {
	if err := x.MsgSend(m); err != nil {
		return err
	}
	return x.CloseSend()
}

type DRPCPiecestore_RestoreTrashStream interface {
	drpc.Stream
	SendAndClose(*RestoreTrashResponse) error
}

type drpcPiecestoreRestoreTrashStream struct {
	drpc.Stream
}

func (x *drpcPiecestoreRestoreTrashStream) SendAndClose(m *RestoreTrashResponse) error {
	if err := x.MsgSend(m); err != nil {
		return err
	}
	return x.CloseSend()
}

// --- DRPC END ---
