// Code generated by ./internal/gen/main.go. DO NOT EDIT.

//go:generate go run ./internal/gen/main.go

package encoder

var testCasesSingle = []testCase{
	{ // 0
		mask: EncodeZero,
		in:   "？2π\x15ｊ８␉aｗ␐k\x01\x01β\x00σ\x1dτ７␓<R\x1e␀τ␆β7７␗",
		out:  "？2π\x15ｊ８␉aｗ␐k\x01\x01β␀σ\x1dτ７␓<R\x1e‛␀τ␆β7７␗",
	}, { // 1
		mask: EncodeWin,
		in:   "\x04＊:：␟␀\x06<|?＂，μ＜*X｜δ？β>\x13ｐ0υ\"＞g＞Ｈ",
		out:  "\x04‛＊：‛：␟‛␀\x06＜｜？‛＂，μ‛＜＊X‛｜δ‛？β＞\x13ｐ0υ＂‛＞g‛＞Ｈ",
	}, { // 2
		mask: EncodeSlash,
		in:   "P\b\x06␀ｚＪ␈␅#｛／δ\x0f]ε/\x13A\x1f␗#κ␟FγιＹψ␋＂",
		out:  "P\b\x06‛␀ｚＪ␈␅#｛‛／δ\x0f]ε／\x13A\x1f␗#κ␟FγιＹψ␋＂",
	}, { // 3
		mask: EncodeBackSlash,
		in:   "τδ\x15\t␜\\／␒␚Ｇκ～-ｖ5σ\\␙\x05<7`ｕδ,␈φ＼␌\x06",
		out:  "τδ\x15\t␜＼／␒␚Ｇκ～-ｖ5σ＼␙\x05<7`ｕδ,␈φ‛＼␌\x06",
	}, { // 4
		mask: EncodeHashPercent,
		in:   "γ\x1a＃\x12φω\x05％%#c'␃␉Ｎ␔％ψEαｓm＼ｆ\b|<：θｋ",
		out:  "γ\x1a‛＃\x12φω\x05‛％％＃c'␃␉Ｎ␔‛％ψEαｓm＼ｆ\b|<：θｋ",
	}, { // 5
		mask: EncodeDel,
		in:   "m／ν+ｑ．/λτ?␍／ιHw\x01Ｉ\"␡\u007f␌＞ｍ␉Nψ\x13|＊ρ",
		out:  "m／ν+ｑ．/λτ?␍／ιHw\x01Ｉ\"‛␡␡␌＞ｍ␉Nψ\x13|＊ρ",
	}, { // 6
		mask: EncodeCtl,
		in:   "\x03＂␐\x1f␈\u007f␖\x15φ;␋␒ｓ\aY\x1a␏＞␂␚\x19␊␁␍␍␊％␄\x14\x06\x1c␞␉␁␃ｙ␔>ς＂\a␌\\␜\x05\x10\x01\x04R␗\x0e\x16␛'\x11\x1b␅\n\"␕\x13␌␎ｌδ%\x04ω\x0f\b␝\x18␘\r\x17\x02\x0eO␓ι\x1d␙␆ξ␀\f␑␟\x1e\t\x12\v␇",
		out:  "␃＂‛␐␟‛␈\u007f‛␖␕φ;‛␋‛␒ｓ␇Y␚‛␏＞‛␂‛␚␙‛␊‛␁‛␍‛␍‛␊％‛␄␔␆␜‛␞‛␉‛␁‛␃ｙ‛␔>ς＂␇‛␌\\‛␜␅␐␁␄R‛␗␎␖‛␛'␑␛‛␅␊\"‛␕␓‛␌‛␎ｌδ%␄ω␏␈‛␝␘‛␘␍␗␂␎O‛␓ι␝‛␙‛␆ξ‛␀␌‛␑‛␟␞␉␒␋‛␇",
	},
}

var testCasesSingleEdge = []testCase{
	{ // 0
		mask: EncodeLeftSpace,
		in:   " ",
		out:  "␠",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17ω",
		out:  "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17ω",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17ω",
		out:  "␠␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17ω",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17ω",
		out:  "‛␠␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17ω",
	}, { // 4
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ␠ω",
		out:  "␠␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ␠ω",
	}, { // 5
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ␠ω",
		out:  "‛␠␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ␠ω",
	}, { // 6
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17␠",
		out:  "␠␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17␠",
	}, { // 7
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17␠",
		out:  "‛␠␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17␠",
	}, { // 8
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00 ＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17ω",
		out:  "\uff00 ＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17ω",
	}, { // 9
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17ω",
		out:  "\uff00␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17ω",
	}, { // 10
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00 ＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ␠ω",
		out:  "\uff00 ＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ␠ω",
	}, { // 11
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ␠ω",
		out:  "\uff00␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ␠ω",
	}, { // 12
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00 ＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17␠",
		out:  "\uff00 ＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17␠",
	}, { // 13
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17␠",
		out:  "\uff00␠＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17␠",
	}, { // 14
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ ω",
		out:  "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ ω",
	}, { // 15
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ␠ω",
		out:  "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ␠ω",
	}, { // 16
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ ␠",
		out:  "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ ␠",
	}, { // 17
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ␠␠",
		out:  "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ␠␠",
	}, { // 18
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17 ",
		out:  "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17 ",
	}, { // 19
		mask: EncodeZero | EncodeLeftSpace,
		in:   "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8\x00␕\x18␂ｒY＼ρ\x17␠",
		out:  "\uff00␞＆␡/\x17\"ηｒβ |ω=gＥ：ξR8␀␕\x18␂ｒY＼ρ\x17␠",
	}, { // 20
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍εS",
		out:  "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍εS",
	}, { // 21
		mask: EncodeWin | EncodeLeftSpace,
		in:   " ␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍εS",
		out:  "␠␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍εS",
	}, { // 22
		mask: EncodeWin | EncodeLeftSpace,
		in:   "␠␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍εS",
		out:  "‛␠␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍εS",
	}, { // 23
		mask: EncodeWin | EncodeLeftSpace,
		in:   " -＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍␠S",
		out:  "␠-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍␠S",
	}, { // 24
		mask: EncodeWin | EncodeLeftSpace,
		in:   "␠-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍␠S",
		out:  "‛␠-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍␠S",
	}, { // 25
		mask: EncodeWin | EncodeLeftSpace,
		in:   " -＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ε␠",
		out:  "␠-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ε␠",
	}, { // 26
		mask: EncodeWin | EncodeLeftSpace,
		in:   "␠-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ε␠",
		out:  "‛␠-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ε␠",
	}, { // 27
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O ＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍εS",
		out:  "O ＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍εS",
	}, { // 28
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍εS",
		out:  "O␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍εS",
	}, { // 29
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O ＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍␠S",
		out:  "O ＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍␠S",
	}, { // 30
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍␠S",
		out:  "O␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍␠S",
	}, { // 31
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O ＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ε␠",
		out:  "O ＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ε␠",
	}, { // 32
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ε␠",
		out:  "O␠＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ε␠",
	}, { // 33
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ S",
		out:  "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ S",
	}, { // 34
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍␠S",
		out:  "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍␠S",
	}, { // 35
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ ␠",
		out:  "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ ␠",
	}, { // 36
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍␠␠",
		out:  "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍␠␠",
	}, { // 37
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ε ",
		out:  "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ε ",
	}, { // 38
		mask: EncodeWin | EncodeLeftSpace,
		in:   "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n<Ｊ?␍ε␠",
		out:  "O-＃｛α\rD#ｏ␙ ␞\x11ｒ\x0eＣ␏ωυρν␈\x02\n＜Ｊ？␍ε␠",
	}, { // 39
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␞",
		out:  "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␞",
	}, { // 40
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␞",
		out:  "␠␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␞",
	}, { // 41
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␞",
		out:  "‛␠␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␞",
	}, { // 42
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
		out:  "␠ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
	}, { // 43
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
		out:  "‛␠ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
	}, { // 44
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␠",
		out:  "␠ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␠",
	}, { // 45
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␠",
		out:  "‛␠ＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␠",
	}, { // 46
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "O Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␞",
		out:  "O Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␞",
	}, { // 47
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "O␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␞",
		out:  "O␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␞",
	}, { // 48
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "O Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
		out:  "O Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
	}, { // 49
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "O␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
		out:  "O␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
	}, { // 50
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "O Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␠",
		out:  "O Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␠",
	}, { // 51
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "O␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␠",
		out:  "O␠Ｉτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␠",
	}, { // 52
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17 ␞",
		out:  "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17 ␞",
	}, { // 53
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
		out:  "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␞",
	}, { // 54
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17 ␠",
		out:  "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17 ␠",
	}, { // 55
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␠",
		out:  "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17␠␠",
	}, { // 56
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／ ",
		out:  "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／ ",
	}, { // 57
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17／␠",
		out:  "OＱＩτ＋␉\x18φδ? CO*s\x05R０␗\x03␗ω|ρ␌～ζ\x17‛／␠",
	}, { // 58
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ\t",
		out:  "␂）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ\t",
	}, { // 59
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " ␠\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ\t",
		out:  "␠␠\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ\t",
	}, { // 60
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠␠\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ\t",
		out:  "‛␠␠\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ\t",
	}, { // 61
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " ）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy␠\t",
		out:  "␠）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy␠\t",
	}, { // 62
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy␠\t",
		out:  "‛␠）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy␠\t",
	}, { // 63
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " ）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ␠",
		out:  "␠）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ␠",
	}, { // 64
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ␠",
		out:  "‛␠）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ␠",
	}, { // 65
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂ \x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ\t",
		out:  "␂ \x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ\t",
	}, { // 66
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂␠\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ\t",
		out:  "␂␠\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ\t",
	}, { // 67
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂ \x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy␠\t",
		out:  "␂ \x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy␠\t",
	}, { // 68
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂␠\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy␠\t",
		out:  "␂␠\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy␠\t",
	}, { // 69
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂ \x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ␠",
		out:  "␂ \x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ␠",
	}, { // 70
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂␠\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ␠",
		out:  "␂␠\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ␠",
	}, { // 71
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy \t",
		out:  "␂）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy \t",
	}, { // 72
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy␠\t",
		out:  "␂）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy␠\t",
	}, { // 73
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy ␠",
		out:  "␂）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy ␠",
	}, { // 74
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSy␠␠",
		out:  "␂）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSy␠␠",
	}, { // 75
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ ",
		out:  "␂）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ ",
	}, { // 76
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␂）\x19＠1␒\t␒ξs ␋Ｉα２\\ξ,\x18３１\x1fFφ␈υSyθ␠",
		out:  "␂）\x19＠1␒\t␒ξs ␋Ｉα２＼ξ,\x18３１\x1fFφ␈υSyθ␠",
	}, { // 77
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
		out:  "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
	}, { // 78
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   " ␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
		out:  "␠␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
	}, { // 79
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "␠␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
		out:  "‛␠␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
	}, { // 80
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   " ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
		out:  "␠␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
	}, { // 81
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "␠␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
		out:  "‛␠␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
	}, { // 82
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   " ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
		out:  "␠␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
	}, { // 83
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "␠␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
		out:  "‛␠␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
	}, { // 84
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
		out:  "ｆ δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
	}, { // 85
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
		out:  "ｆ␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜Iy",
	}, { // 86
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
		out:  "ｆ δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
	}, { // 87
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
		out:  "ｆ␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
	}, { // 88
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
		out:  "ｆ δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
	}, { // 89
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
		out:  "ｆ␠δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
	}, { // 90
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜ y",
		out:  "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜ y",
	}, { // 91
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
		out:  "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠y",
	}, { // 92
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜ ␠",
		out:  "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜ ␠",
	}, { // 93
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠␠",
		out:  "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜␠␠",
	}, { // 94
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I ",
		out:  "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I ",
	}, { // 95
		mask: EncodeHashPercent | EncodeLeftSpace,
		in:   "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
		out:  "ｆ␙δ␃\"*$φZｍ ␙\a８τ␓ζ\x16Ｙ\x10\x12ψｋξＷyd␜I␠",
	}, { // 96
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
		out:  "＃␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
	}, { // 97
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␠\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
		out:  "␠␠␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
	}, { // 98
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␠\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
		out:  "‛␠␠␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
	}, { // 99
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
		out:  "␠␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
	}, { // 100
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
		out:  "‛␠␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
	}, { // 101
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
		out:  "␠␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
	}, { // 102
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
		out:  "‛␠␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
	}, { // 103
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃ \x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
		out:  "＃ ␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
	}, { // 104
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␠\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
		out:  "＃␠␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４\x12",
	}, { // 105
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃ \x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
		out:  "＃ ␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
	}, { // 106
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␠\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
		out:  "＃␠␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
	}, { // 107
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃ \x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
		out:  "＃ ␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
	}, { // 108
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␠\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
		out:  "＃␠␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
	}, { // 109
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω \x12",
		out:  "＃␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω \x12",
	}, { // 110
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
		out:  "＃␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠\x12",
	}, { // 111
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω ␠",
		out:  "＃␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω ␠",
	}, { // 112
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠␠",
		out:  "＃␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω␠␠",
	}, { // 113
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４ ",
		out:  "＃␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４ ",
	}, { // 114
		mask: EncodeDel | EncodeLeftSpace,
		in:   "＃␎\x00ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
		out:  "＃␎␀ｊ\x02m＼ρ*ｉ ｐ#ψ\\\x19tω␋Mς␙μXＬ␍␋ω４␠",
	}, { // 115
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξχ",
		out:  "‛␜υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξχ",
	}, { // 116
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " ␠ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξχ",
		out:  "␠␠ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξχ",
	}, { // 117
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠␠ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξχ",
		out:  "‛␠␠ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξχ",
	}, { // 118
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&␠χ",
		out:  "␠υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&␠χ",
	}, { // 119
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&␠χ",
		out:  "‛␠υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&␠χ",
	}, { // 120
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξ␠",
		out:  "␠υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξ␠",
	}, { // 121
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξ␠",
		out:  "‛␠υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξ␠",
	}, { // 122
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜ ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξχ",
		out:  "‛␜ ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξχ",
	}, { // 123
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜␠ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξχ",
		out:  "‛␜␠ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξχ",
	}, { // 124
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜ ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&␠χ",
		out:  "‛␜ ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&␠χ",
	}, { // 125
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜␠ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&␠χ",
		out:  "‛␜␠ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&␠χ",
	}, { // 126
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜ ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξ␠",
		out:  "‛␜ ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξ␠",
	}, { // 127
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜␠ｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξ␠",
		out:  "‛␜␠ｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξ␠",
	}, { // 128
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏& χ",
		out:  "‛␜υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏& χ",
	}, { // 129
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&␠χ",
		out:  "‛␜υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&␠χ",
	}, { // 130
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏& ␠",
		out:  "‛␜υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏& ␠",
	}, { // 131
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&␠␠",
		out:  "‛␜υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&␠␠",
	}, { // 132
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξ ",
		out:  "‛␜υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξ ",
	}, { // 133
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␜υｃ␇\x13ty␌＠\x11 ζＢω？s<\x1bｃ`h\x0fα？\x16␗␏&ξ␠",
		out:  "‛␜υｃ‛␇␓ty‛␌＠␑ ζＢω？s<␛ｃ`h␏α？␖‛␗‛␏&ξ␠",
	}, { // 134
		mask: EncodeLeftTilde,
		in:   "~",
		out:  "～",
	}, { // 135
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
		out:  ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
	}, { // 136
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
		out:  "～～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
	}, { // 137
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
		out:  "‛～～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
	}, { // 138
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
		out:  "～␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
	}, { // 139
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
		out:  "‛～␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
	}, { // 140
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
		out:  "～␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
	}, { // 141
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
		out:  "‛～␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
	}, { // 142
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":~ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
		out:  ":~ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
	}, { // 143
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
		out:  ":～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο＊",
	}, { // 144
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":~ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
		out:  ":~ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
	}, { // 145
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
		out:  ":～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
	}, { // 146
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":~ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
		out:  ":~ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
	}, { // 147
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
		out:  ":～ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
	}, { // 148
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ~＊",
		out:  ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ~＊",
	}, { // 149
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
		out:  ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～＊",
	}, { // 150
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ~～",
		out:  ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ~～",
	}, { // 151
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～～",
		out:  ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏ～～",
	}, { // 152
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο~",
		out:  ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο~",
	}, { // 153
		mask: EncodeZero | EncodeLeftTilde,
		in:   ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
		out:  ":␏ς<\x19ξＧ\x14:d~＃0ι\x17φ\x1d.Ｔ/␕γ\"␄Ｗ＊␝Ｏο～",
	}, { // 154
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#γ",
		out:  "\x14␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#γ",
	}, { // 155
		mask: EncodeWin | EncodeLeftTilde,
		in:   "~～Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#γ",
		out:  "～～Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#γ",
	}, { // 156
		mask: EncodeWin | EncodeLeftTilde,
		in:   "～～Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#γ",
		out:  "‛～～Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#γ",
	}, { // 157
		mask: EncodeWin | EncodeLeftTilde,
		in:   "~␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?～γ",
		out:  "～␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？～γ",
	}, { // 158
		mask: EncodeWin | EncodeLeftTilde,
		in:   "～␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?～γ",
		out:  "‛～␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？～γ",
	}, { // 159
		mask: EncodeWin | EncodeLeftTilde,
		in:   "~␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#～",
		out:  "～␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#～",
	}, { // 160
		mask: EncodeWin | EncodeLeftTilde,
		in:   "～␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#～",
		out:  "‛～␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#～",
	}, { // 161
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14~Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#γ",
		out:  "\x14~Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#γ",
	}, { // 162
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14～Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#γ",
		out:  "\x14～Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#γ",
	}, { // 163
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14~Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?～γ",
		out:  "\x14~Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？～γ",
	}, { // 164
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14～Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?～γ",
		out:  "\x14～Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？～γ",
	}, { // 165
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14~Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#～",
		out:  "\x14~Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#～",
	}, { // 166
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14～Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#～",
		out:  "\x14～Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#～",
	}, { // 167
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?~γ",
		out:  "\x14␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？~γ",
	}, { // 168
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?～γ",
		out:  "\x14␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？～γ",
	}, { // 169
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?~～",
		out:  "\x14␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？~～",
	}, { // 170
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?～～",
		out:  "\x14␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？～～",
	}, { // 171
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#~",
		out:  "\x14␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#~",
	}, { // 172
		mask: EncodeWin | EncodeLeftTilde,
		in:   "\x14␚Wｒμ，οａφＣ~\x14␕␈＞\x16␊θ␇Hｘyl\v\x01υR?#～",
		out:  "\x14␚Wｒμ，οａφＣ~\x14␕␈‛＞\x16␊θ␇Hｘyl\v\x01υR？#～",
	}, { // 173
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋s",
		out:  "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋s",
	}, { // 174
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋s",
		out:  "～～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋s",
	}, { // 175
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋s",
		out:  "‛～～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋s",
	}, { // 176
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g～s",
		out:  "～）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g～s",
	}, { // 177
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g～s",
		out:  "‛～）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g～s",
	}, { // 178
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋～",
		out:  "～）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋～",
	}, { // 179
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋～",
		out:  "‛～）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋～",
	}, { // 180
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ~ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋s",
		out:  "ｖ~ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋s",
	}, { // 181
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋s",
		out:  "ｖ～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋s",
	}, { // 182
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ~ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g～s",
		out:  "ｖ~ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g～s",
	}, { // 183
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g～s",
		out:  "ｖ～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g～s",
	}, { // 184
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ~ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋～",
		out:  "ｖ~ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋～",
	}, { // 185
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋～",
		out:  "ｖ～ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋～",
	}, { // 186
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g~s",
		out:  "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g~s",
	}, { // 187
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g～s",
		out:  "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g～s",
	}, { // 188
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g~～",
		out:  "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g~～",
	}, { // 189
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g～～",
		out:  "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g～～",
	}, { // 190
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋~",
		out:  "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋~",
	}, { // 191
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e／\x06σ5␔ο５ｏβ?_␞．g␋～",
		out:  "ｖ）ζ\v␙θ＊\u007f\v\x12~␐ω\x0e‛／\x06σ5␔ο５ｏβ?_␞．g␋～",
	}, { // 192
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<8",
		out:  "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<8",
	}, { // 193
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<8",
		out:  "～～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<8",
	}, { // 194
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<8",
		out:  "‛～～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<8",
	}, { // 195
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?～8",
		out:  "～οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?～8",
	}, { // 196
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?～8",
		out:  "‛～οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?～8",
	}, { // 197
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<～",
		out:  "～οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<～",
	}, { // 198
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<～",
		out:  "‛～οτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<～",
	}, { // 199
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μ~τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<8",
		out:  "μ~τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<8",
	}, { // 200
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μ～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<8",
		out:  "μ～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<8",
	}, { // 201
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μ~τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?～8",
		out:  "μ~τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?～8",
	}, { // 202
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μ～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?～8",
		out:  "μ～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?～8",
	}, { // 203
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μ~τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<～",
		out:  "μ~τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<～",
	}, { // 204
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μ～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<～",
		out:  "μ～τ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<～",
	}, { // 205
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?~8",
		out:  "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?~8",
	}, { // 206
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?～8",
		out:  "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?～8",
	}, { // 207
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?~～",
		out:  "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?~～",
	}, { // 208
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?～～",
		out:  "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?～～",
	}, { // 209
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<~",
		out:  "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<~",
	}, { // 210
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%\\；<\x1cｔ%5?<～",
		out:  "μοτ␏ｐ␅␂｝＃ρ~％＂3νψ）\x0eL%＼；<\x1cｔ%5?<～",
	}, { // 211
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%{",
		out:  "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％{",
	}, { // 212
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "~～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%{",
		out:  "～～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％{",
	}, { // 213
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "～～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%{",
		out:  "‛～～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％{",
	}, { // 214
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "~φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
		out:  "～φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
	}, { // 215
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "～φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
		out:  "‛～φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
	}, { // 216
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "~φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%～",
		out:  "～φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％～",
	}, { // 217
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "～φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%～",
		out:  "‛～φgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％～",
	}, { // 218
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θ~gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%{",
		out:  "θ~gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％{",
	}, { // 219
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θ～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%{",
		out:  "θ～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％{",
	}, { // 220
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θ~gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
		out:  "θ~gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
	}, { // 221
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θ～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
		out:  "θ～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
	}, { // 222
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θ~gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%～",
		out:  "θ~gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％～",
	}, { // 223
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θ～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%～",
		out:  "θ～gｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％～",
	}, { // 224
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n~{",
		out:  "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n~{",
	}, { // 225
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
		out:  "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～{",
	}, { // 226
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n~～",
		out:  "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n~～",
	}, { // 227
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～～",
		out:  "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n～～",
	}, { // 228
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%~",
		out:  "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％~",
	}, { // 229
		mask: EncodeHashPercent | EncodeLeftTilde,
		in:   "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n%～",
		out:  "θφgｔ␍＾2␍␆\x10~?Oρ＠)Ｄ␎ｐ␡αο？?Ｄα:n％～",
	}, { // 230
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
		out:  "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
	}, { // 231
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
		out:  "～～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
	}, { // 232
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
		out:  "‛～～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
	}, { // 233
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
		out:  "～ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
	}, { // 234
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
		out:  "‛～ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
	}, { // 235
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
		out:  "～ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
	}, { // 236
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
		out:  "‛～ε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
	}, { // 237
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1f~\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
		out:  "\x1f~\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
	}, { // 238
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1f～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
		out:  "\x1f～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19（",
	}, { // 239
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1f~\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
		out:  "\x1f~\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
	}, { // 240
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1f～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
		out:  "\x1f～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
	}, { // 241
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1f~\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
		out:  "\x1f~\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
	}, { // 242
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1f～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
		out:  "\x1f～\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
	}, { // 243
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔~（",
		out:  "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔~（",
	}, { // 244
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
		out:  "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～（",
	}, { // 245
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔~～",
		out:  "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔~～",
	}, { // 246
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～～",
		out:  "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔～～",
	}, { // 247
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19~",
		out:  "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19~",
	}, { // 248
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
		out:  "\x1fε\x02␉,ω＝＜\x02＜~θ}φ９％9ψ\x13pＰυｒ;&\x19␇␔\x19～",
	}, { // 249
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q＝",
		out:  "λ␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q＝",
	}, { // 250
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~～8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q＝",
		out:  "～～8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q＝",
	}, { // 251
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～～8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q＝",
		out:  "‛～～8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q＝",
	}, { // 252
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％～＝",
		out:  "～␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％～＝",
	}, { // 253
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％～＝",
		out:  "‛～␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％～＝",
	}, { // 254
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q～",
		out:  "～␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q～",
	}, { // 255
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q～",
		out:  "‛～␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q～",
	}, { // 256
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ~8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q＝",
		out:  "λ~8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q＝",
	}, { // 257
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ～8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q＝",
		out:  "λ～8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q＝",
	}, { // 258
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ~8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％～＝",
		out:  "λ~8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％～＝",
	}, { // 259
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ～8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％～＝",
		out:  "λ～8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％～＝",
	}, { // 260
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ~8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q～",
		out:  "λ~8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q～",
	}, { // 261
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ～8␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q～",
		out:  "λ～8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q～",
	}, { // 262
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％~＝",
		out:  "λ␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％~＝",
	}, { // 263
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％～＝",
		out:  "λ␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％～＝",
	}, { // 264
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％~～",
		out:  "λ␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％~～",
	}, { // 265
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％～～",
		out:  "λ␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％～～",
	}, { // 266
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q~",
		out:  "λ␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q~",
	}, { // 267
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "λ\x118␝\x04␍Ｃ γ\t~4\x12␔＞ｃｎ␃l8\x18ρｏ\x04κρε％q～",
		out:  "λ␑8‛␝␄‛␍Ｃ γ␉~4␒‛␔＞ｃｎ‛␃l8␘ρｏ␄κρε％q～",
	}, { // 268
		mask: EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 269
		mask: EncodeZero | EncodeRightSpace,
		in:   "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣα",
		out:  "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣα",
	}, { // 270
		mask: EncodeZero | EncodeRightSpace,
		in:   " ␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣα",
		out:  " ␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣα",
	}, { // 271
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣα",
		out:  "␠␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣα",
	}, { // 272
		mask: EncodeZero | EncodeRightSpace,
		in:   " Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β␠α",
		out:  " Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β␠α",
	}, { // 273
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β␠α",
		out:  "␠Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β␠α",
	}, { // 274
		mask: EncodeZero | EncodeRightSpace,
		in:   " Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣ␠",
		out:  " Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣ‛␠",
	}, { // 275
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣ␠",
		out:  "␠Mα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣ‛␠",
	}, { // 276
		mask: EncodeZero | EncodeRightSpace,
		in:   "J α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣα",
		out:  "J α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣα",
	}, { // 277
		mask: EncodeZero | EncodeRightSpace,
		in:   "J␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣα",
		out:  "J␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣα",
	}, { // 278
		mask: EncodeZero | EncodeRightSpace,
		in:   "J α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β␠α",
		out:  "J α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β␠α",
	}, { // 279
		mask: EncodeZero | EncodeRightSpace,
		in:   "J␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β␠α",
		out:  "J␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β␠α",
	}, { // 280
		mask: EncodeZero | EncodeRightSpace,
		in:   "J α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣ␠",
		out:  "J α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣ‛␠",
	}, { // 281
		mask: EncodeZero | EncodeRightSpace,
		in:   "J␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣ␠",
		out:  "J␠α\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣ‛␠",
	}, { // 282
		mask: EncodeZero | EncodeRightSpace,
		in:   "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β α",
		out:  "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β α",
	}, { // 283
		mask: EncodeZero | EncodeRightSpace,
		in:   "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β␠α",
		out:  "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β␠α",
	}, { // 284
		mask: EncodeZero | EncodeRightSpace,
		in:   "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β ␠",
		out:  "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β ‛␠",
	}, { // 285
		mask: EncodeZero | EncodeRightSpace,
		in:   "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17β␠␠",
		out:  "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17β␠‛␠",
	}, { // 286
		mask: EncodeZero | EncodeRightSpace,
		in:   "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣ ",
		out:  "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣ␠",
	}, { // 287
		mask: EncodeZero | EncodeRightSpace,
		in:   "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ\x00\x17βＣ␠",
		out:  "JMα\n␞B␖＃？\x04 ς\x11ν：␙＞␕［\n5.％θｏ␀\x17βＣ‛␠",
	}, { // 288
		mask: EncodeWin | EncodeRightSpace,
		in:   "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ\x1c",
		out:  "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ\x1c",
	}, { // 289
		mask: EncodeWin | EncodeRightSpace,
		in:   " ␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ\x1c",
		out:  " ␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ\x1c",
	}, { // 290
		mask: EncodeWin | EncodeRightSpace,
		in:   "␠␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ\x1c",
		out:  "␠␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ\x1c",
	}, { // 291
		mask: EncodeWin | EncodeRightSpace,
		in:   " βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍␠\x1c",
		out:  " βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍␠\x1c",
	}, { // 292
		mask: EncodeWin | EncodeRightSpace,
		in:   "␠βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍␠\x1c",
		out:  "␠βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍␠\x1c",
	}, { // 293
		mask: EncodeWin | EncodeRightSpace,
		in:   " βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ␠",
		out:  " βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ‛␠",
	}, { // 294
		mask: EncodeWin | EncodeRightSpace,
		in:   "␠βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ␠",
		out:  "␠βηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ‛␠",
	}, { // 295
		mask: EncodeWin | EncodeRightSpace,
		in:   "g ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ\x1c",
		out:  "g ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ\x1c",
	}, { // 296
		mask: EncodeWin | EncodeRightSpace,
		in:   "g␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ\x1c",
		out:  "g␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ\x1c",
	}, { // 297
		mask: EncodeWin | EncodeRightSpace,
		in:   "g ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍␠\x1c",
		out:  "g ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍␠\x1c",
	}, { // 298
		mask: EncodeWin | EncodeRightSpace,
		in:   "g␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍␠\x1c",
		out:  "g␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍␠\x1c",
	}, { // 299
		mask: EncodeWin | EncodeRightSpace,
		in:   "g ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ␠",
		out:  "g ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ‛␠",
	}, { // 300
		mask: EncodeWin | EncodeRightSpace,
		in:   "g␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ␠",
		out:  "g␠ηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ‛␠",
	}, { // 301
		mask: EncodeWin | EncodeRightSpace,
		in:   "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍ \x1c",
		out:  "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍ \x1c",
	}, { // 302
		mask: EncodeWin | EncodeRightSpace,
		in:   "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍␠\x1c",
		out:  "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍␠\x1c",
	}, { // 303
		mask: EncodeWin | EncodeRightSpace,
		in:   "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍ ␠",
		out:  "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍ ‛␠",
	}, { // 304
		mask: EncodeWin | EncodeRightSpace,
		in:   "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍␠␠",
		out:  "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍␠‛␠",
	}, { // 305
		mask: EncodeWin | EncodeRightSpace,
		in:   "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ ",
		out:  "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ␠",
	}, { // 306
		mask: EncodeWin | EncodeRightSpace,
		in:   "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b：７H␍θ␠",
		out:  "gβηρＱ␝Ｏμ␎ｗ \x19Y\x1e␝＿\bcjκs４\x1b\b‛：７H␍θ‛␠",
	}, { // 307
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
		out:  "＆η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
	}, { // 308
		mask: EncodeSlash | EncodeRightSpace,
		in:   " ␠␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
		out:  " ␠␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
	}, { // 309
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠␠␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
		out:  "␠␠␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
	}, { // 310
		mask: EncodeSlash | EncodeRightSpace,
		in:   " η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
		out:  " η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
	}, { // 311
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
		out:  "␠η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
	}, { // 312
		mask: EncodeSlash | EncodeRightSpace,
		in:   " η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄␠",
		out:  " η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄‛␠",
	}, { // 313
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄␠",
		out:  "␠η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄‛␠",
	}, { // 314
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆ ␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
		out:  "＆ ␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
	}, { // 315
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆␠␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
		out:  "＆␠␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄π",
	}, { // 316
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆ ␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
		out:  "＆ ␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
	}, { // 317
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆␠␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
		out:  "＆␠␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
	}, { // 318
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆ ␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄␠",
		out:  "＆ ␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄‛␠",
	}, { // 319
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆␠␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄␠",
		out:  "＆␠␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄‛␠",
	}, { // 320
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂ π",
		out:  "＆η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂ π",
	}, { // 321
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
		out:  "＆η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠π",
	}, { // 322
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂ ␠",
		out:  "＆η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂ ‛␠",
	}, { // 323
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠␠",
		out:  "＆η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␠‛␠",
	}, { // 324
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄ ",
		out:  "＆η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄␠",
	}, { // 325
		mask: EncodeSlash | EncodeRightSpace,
		in:   "＆η␕Fξ}r1|\f ／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄␠",
		out:  "＆η␕Fξ}r1|\f ‛／\rｇ␆ｄ７}:＃υιπ{ｔ#|␂␄‛␠",
	}, { // 326
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
		out:  "V3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
	}, { // 327
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " ␠ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
		out:  " ␠ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
	}, { // 328
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠␠ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
		out:  "␠␠ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
	}, { // 329
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " 3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
		out:  " 3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
	}, { // 330
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
		out:  "␠3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
	}, { // 331
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " 3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ␠",
		out:  " 3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ‛␠",
	}, { // 332
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ␠",
		out:  "␠3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ‛␠",
	}, { // 333
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
		out:  "V ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
	}, { // 334
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V␠ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
		out:  "V␠ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ\x04",
	}, { // 335
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
		out:  "V ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
	}, { // 336
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V␠ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
		out:  "V␠ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
	}, { // 337
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ␠",
		out:  "V ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ‛␠",
	}, { // 338
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V␠ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ␠",
		out:  "V␠ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ‛␠",
	}, { // 339
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a \x04",
		out:  "V3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a \x04",
	}, { // 340
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
		out:  "V3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠\x04",
	}, { // 341
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a ␠",
		out:  "V3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a ‛␠",
	}, { // 342
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠␠",
		out:  "V3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1a␠‛␠",
	}, { // 343
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ ",
		out:  "V3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ␠",
	}, { // 344
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "V3ο␆␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ␠",
		out:  "V3ο␆‛␀\x03\x13／ω␡ \v␛ελ␊９ｃβTＧ｜nρ\x1ddW\x1aｑ‛␠",
	}, { // 345
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "ηπ\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␚",
		out:  "ηπ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡␚",
	}, { // 346
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   " ␠\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␚",
		out:  " ␠␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡␚",
	}, { // 347
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "␠␠\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␚",
		out:  "␠␠␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡␚",
	}, { // 348
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   " π\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␠␚",
		out:  " π␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␠␚",
	}, { // 349
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "␠π\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␠␚",
		out:  "␠π␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␠␚",
	}, { // 350
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   " π\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␠",
		out:  " π␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡‛␠",
	}, { // 351
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "␠π\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␠",
		out:  "␠π␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡‛␠",
	}, { // 352
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "η \x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␚",
		out:  "η ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡␚",
	}, { // 353
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "η␠\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␚",
		out:  "η␠␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡␚",
	}, { // 354
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "η \x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␠␚",
		out:  "η ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␠␚",
	}, { // 355
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "η␠\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␠␚",
		out:  "η␠␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␠␚",
	}, { // 356
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "η \x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␠",
		out:  "η ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡‛␠",
	}, { // 357
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "η␠\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␠",
		out:  "η␠␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡‛␠",
	}, { // 358
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "ηπ\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～ ␚",
		out:  "ηπ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～ ␚",
	}, { // 359
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "ηπ\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␠␚",
		out:  "ηπ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␠␚",
	}, { // 360
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "ηπ\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～ ␠",
		out:  "ηπ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～ ‛␠",
	}, { // 361
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "ηπ\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␠␠",
		out:  "ηπ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␠‛␠",
	}, { // 362
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "ηπ\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡ ",
		out:  "ηπ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡␠",
	}, { // 363
		mask: EncodeHashPercent | EncodeRightSpace,
		in:   "ηπ\x00？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06％Ｎ\uff00[␕Tg(～␡␠",
		out:  "ηπ␀？\x12πＭ\x1fcχ \x1f9β\uff00␋␈ε\x06‛％Ｎ\uff00[␕Tg(～␡‛␠",
	}, { // 364
		mask: EncodeDel | EncodeRightSpace,
		in:   "νJ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
		out:  "νJ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
	}, { // 365
		mask: EncodeDel | EncodeRightSpace,
		in:   " ␠？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
		out:  " ␠？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
	}, { // 366
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠␠？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
		out:  "␠␠？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
	}, { // 367
		mask: EncodeDel | EncodeRightSpace,
		in:   " J？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
		out:  " J？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
	}, { // 368
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠J？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
		out:  "␠J？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
	}, { // 369
		mask: EncodeDel | EncodeRightSpace,
		in:   " J？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4␠",
		out:  " J？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4‛␠",
	}, { // 370
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠J？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4␠",
		out:  "␠J？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4‛␠",
	}, { // 371
		mask: EncodeDel | EncodeRightSpace,
		in:   "ν ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
		out:  "ν ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
	}, { // 372
		mask: EncodeDel | EncodeRightSpace,
		in:   "ν␠？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
		out:  "ν␠？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4ｕ",
	}, { // 373
		mask: EncodeDel | EncodeRightSpace,
		in:   "ν ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
		out:  "ν ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
	}, { // 374
		mask: EncodeDel | EncodeRightSpace,
		in:   "ν␠？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
		out:  "ν␠？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
	}, { // 375
		mask: EncodeDel | EncodeRightSpace,
		in:   "ν ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4␠",
		out:  "ν ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4‛␠",
	}, { // 376
		mask: EncodeDel | EncodeRightSpace,
		in:   "ν␠？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4␠",
		out:  "ν␠？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4‛␠",
	}, { // 377
		mask: EncodeDel | EncodeRightSpace,
		in:   "νJ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕ ｕ",
		out:  "νJ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕ ｕ",
	}, { // 378
		mask: EncodeDel | EncodeRightSpace,
		in:   "νJ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
		out:  "νJ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠ｕ",
	}, { // 379
		mask: EncodeDel | EncodeRightSpace,
		in:   "νJ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕ ␠",
		out:  "νJ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕ ‛␠",
	}, { // 380
		mask: EncodeDel | EncodeRightSpace,
		in:   "νJ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠␠",
		out:  "νJ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕␠‛␠",
	}, { // 381
		mask: EncodeDel | EncodeRightSpace,
		in:   "νJ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4 ",
		out:  "νJ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4␠",
	}, { // 382
		mask: EncodeDel | EncodeRightSpace,
		in:   "νJ？\x1e*δ*χ␕␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4␠",
		out:  "νJ？\x1e*δ*χ␕‛␀ ␓=ａ␗ξｑ＝Ｃ|\x13φ?４1ψ\x15␕4‛␠",
	}, { // 383
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\bＱ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(\x18",
		out:  "␈Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(␘",
	}, { // 384
		mask: EncodeCtl | EncodeRightSpace,
		in:   " ␠␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(\x18",
		out:  " ␠‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(␘",
	}, { // 385
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠␠␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(\x18",
		out:  "␠␠‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(␘",
	}, { // 386
		mask: EncodeCtl | EncodeRightSpace,
		in:   " Ｑ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"␠\x18",
		out:  " Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"␠␘",
	}, { // 387
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠Ｑ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"␠\x18",
		out:  "␠Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"␠␘",
	}, { // 388
		mask: EncodeCtl | EncodeRightSpace,
		in:   " Ｑ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(␠",
		out:  " Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(‛␠",
	}, { // 389
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠Ｑ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(␠",
		out:  "␠Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(‛␠",
	}, { // 390
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\b ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(\x18",
		out:  "␈ ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(␘",
	}, { // 391
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\b␠␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(\x18",
		out:  "␈␠‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(␘",
	}, { // 392
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\b ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"␠\x18",
		out:  "␈ ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"␠␘",
	}, { // 393
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\b␠␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"␠\x18",
		out:  "␈␠‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"␠␘",
	}, { // 394
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\b ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(␠",
		out:  "␈ ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(‛␠",
	}, { // 395
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\b␠␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(␠",
		out:  "␈␠‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(‛␠",
	}, { // 396
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\bＱ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\" \x18",
		out:  "␈Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\" ␘",
	}, { // 397
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\bＱ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"␠\x18",
		out:  "␈Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"␠␘",
	}, { // 398
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\bＱ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\" ␠",
		out:  "␈Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\" ‛␠",
	}, { // 399
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\bＱ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"␠␠",
		out:  "␈Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"␠‛␠",
	}, { // 400
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\bＱ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"( ",
		out:  "␈Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(␠",
	}, { // 401
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\bＱ␟tξ／~UＫ； [\x10χ\x03：ξ\u007fι＃␅#θＥ␊γｙ\"(␠",
		out:  "␈Ｑ‛␟tξ／~UＫ； [␐χ␃：ξ\u007fι＃‛␅#θＥ‛␊γｙ\"(‛␠",
	}, { // 402
		mask: EncodeRightPeriod,
		in:   ".",
		out:  "．",
	}, { // 403
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
		out:  "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
	}, { // 404
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
		out:  ".．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
	}, { // 405
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
		out:  "．．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
	}, { // 406
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
		out:  ".Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
	}, { // 407
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
		out:  "．Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
	}, { // 408
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ．",
		out:  ".Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ‛．",
	}, { // 409
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ．",
		out:  "．Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ‛．",
	}, { // 410
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05.\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
		out:  "\x05.\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
	}, { // 411
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
		out:  "\x05．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄｈ",
	}, { // 412
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05.\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
		out:  "\x05.\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
	}, { // 413
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
		out:  "\x05．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
	}, { // 414
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05.\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ．",
		out:  "\x05.\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ‛．",
	}, { // 415
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ．",
		out:  "\x05．\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ‛．",
	}, { // 416
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ.ｈ",
		out:  "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ.ｈ",
	}, { // 417
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
		out:  "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．ｈ",
	}, { // 418
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ.．",
		out:  "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ.‛．",
	}, { // 419
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．．",
		out:  "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘ．‛．",
	}, { // 420
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ.",
		out:  "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ．",
	}, { // 421
		mask: EncodeZero | EncodeRightPeriod,
		in:   "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ．",
		out:  "\x05Ｄ\r␘Q＼ο>T?.７␁ο{Jδθο␘>\aσ\x13␗Ｖ␉Ｘｄ‛．",
	}, { // 422
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χπ",
		out:  "μｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χπ",
	}, { // 423
		mask: EncodeWin | EncodeRightPeriod,
		in:   ".．ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χπ",
		out:  ".．ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χπ",
	}, { // 424
		mask: EncodeWin | EncodeRightPeriod,
		in:   "．．ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χπ",
		out:  "．．ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χπ",
	}, { // 425
		mask: EncodeWin | EncodeRightPeriod,
		in:   ".ｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎．π",
		out:  ".ｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎．π",
	}, { // 426
		mask: EncodeWin | EncodeRightPeriod,
		in:   "．ｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎．π",
		out:  "．ｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎．π",
	}, { // 427
		mask: EncodeWin | EncodeRightPeriod,
		in:   ".ｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χ．",
		out:  ".ｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χ‛．",
	}, { // 428
		mask: EncodeWin | EncodeRightPeriod,
		in:   "．ｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χ．",
		out:  "．ｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χ‛．",
	}, { // 429
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μ.ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χπ",
		out:  "μ.ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χπ",
	}, { // 430
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μ．ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χπ",
		out:  "μ．ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χπ",
	}, { // 431
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μ.ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎．π",
		out:  "μ.ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎．π",
	}, { // 432
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μ．ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎．π",
		out:  "μ．ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎．π",
	}, { // 433
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μ.ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χ．",
		out:  "μ.ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χ‛．",
	}, { // 434
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μ．ＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χ．",
		out:  "μ．ＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χ‛．",
	}, { // 435
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎.π",
		out:  "μｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎.π",
	}, { // 436
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎．π",
		out:  "μｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎．π",
	}, { // 437
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎.．",
		out:  "μｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎.‛．",
	}, { // 438
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎．．",
		out:  "μｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎．‛．",
	}, { // 439
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χ.",
		out:  "μｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χ．",
	}, { // 440
		mask: EncodeWin | EncodeRightPeriod,
		in:   "μｍＴｖσLs\x1bσ*.｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ?␎χ．",
		out:  "μｍＴｖσLs\x1bσ＊.‛｜ｅｌx\x10ν␋␂N\x11+\x134␑Ｏ？␎χ‛．",
	}, { // 441
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ'",
		out:  "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ'",
	}, { // 442
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ'",
		out:  ".．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ'",
	}, { // 443
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ'",
		out:  "．．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ'",
	}, { // 444
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀．'",
		out:  ".％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀．'",
	}, { // 445
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀．'",
		out:  "．％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀．'",
	}, { // 446
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ．",
		out:  ".％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ‛．",
	}, { // 447
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ．",
		out:  "．％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ‛．",
	}, { // 448
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17.␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ'",
		out:  "\x17.␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ'",
	}, { // 449
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ'",
		out:  "\x17．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ'",
	}, { // 450
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17.␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀．'",
		out:  "\x17.␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀．'",
	}, { // 451
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀．'",
		out:  "\x17．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀．'",
	}, { // 452
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17.␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ．",
		out:  "\x17.␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ‛．",
	}, { // 453
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ．",
		out:  "\x17．␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ‛．",
	}, { // 454
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀.'",
		out:  "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀.'",
	}, { // 455
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀．'",
		out:  "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀．'",
	}, { // 456
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀.．",
		out:  "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀.‛．",
	}, { // 457
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀．．",
		out:  "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀．‛．",
	}, { // 458
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ.",
		out:  "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ．",
	}, { // 459
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ␀ｔ．",
		out:  "\x17％␂＇(５\x01θｒδ.\x12ξ␓\x04v\\\x17Ｓ%ξ␎εDv＼μ‛␀ｔ‛．",
	}, { // 460
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
		out:  "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
	}, { // 461
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
		out:  ".．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
	}, { // 462
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
		out:  "．．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
	}, { // 463
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "./μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
		out:  "./μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
	}, { // 464
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
		out:  "．/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
	}, { // 465
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "./μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗．",
		out:  "./μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗‛．",
	}, { // 466
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗．",
		out:  "．/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗‛．",
	}, { // 467
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X.μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
		out:  "X.μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
	}, { // 468
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
		out:  "X．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗␇",
	}, { // 469
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X.μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
		out:  "X.μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
	}, { // 470
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
		out:  "X．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
	}, { // 471
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X.μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗．",
		out:  "X.μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗‛．",
	}, { // 472
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗．",
		out:  "X．μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗‛．",
	}, { // 473
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!.␇",
		out:  "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!.␇",
	}, { // 474
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
		out:  "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．␇",
	}, { // 475
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!.．",
		out:  "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!.‛．",
	}, { // 476
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．．",
		out:  "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!．‛．",
	}, { // 477
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗.",
		out:  "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗．",
	}, { // 478
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗．",
		out:  "X/μ＾ψ\x18：σＡＯ.Eν\x1f:␅=\x1eＭ\n％θｐP＂\x1c␊!␗‛．",
	}, { // 479
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
		out:  "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
	}, { // 480
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   ".．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
		out:  ".．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
	}, { // 481
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "．．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
		out:  "．．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
	}, { // 482
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   ".\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
		out:  ".\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
	}, { // 483
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "．\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
		out:  "．\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
	}, { // 484
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   ".\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜．",
		out:  ".\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜‛．",
	}, { // 485
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "．\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜．",
		out:  "．\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜‛．",
	}, { // 486
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑.D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
		out:  "␑.D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
	}, { // 487
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
		out:  "␑．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜ω",
	}, { // 488
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑.D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
		out:  "␑.D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
	}, { // 489
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
		out:  "␑．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
	}, { // 490
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑.D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜．",
		out:  "␑.D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜‛．",
	}, { // 491
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜．",
		out:  "␑．D␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜‛．",
	}, { // 492
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６.ω",
		out:  "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６.ω",
	}, { // 493
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
		out:  "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．ω",
	}, { // 494
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６.．",
		out:  "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６.‛．",
	}, { // 495
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．．",
		out:  "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６．‛．",
	}, { // 496
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜.",
		out:  "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜．",
	}, { // 497
		mask: EncodeHashPercent | EncodeRightPeriod,
		in:   "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜．",
		out:  "␑\x1eD␝~ρQ␇hｆ.\bω>\x1dq６\x02κβ\x13：ω␏，@；６＜‛．",
	}, { // 498
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ:",
		out:  "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ:",
	}, { // 499
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ:",
		out:  ".．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ:",
	}, { // 500
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ:",
		out:  "．．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ:",
	}, { // 501
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃．:",
		out:  ".ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃．:",
	}, { // 502
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃．:",
		out:  "．ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃．:",
	}, { // 503
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ．",
		out:  ".ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ‛．",
	}, { // 504
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ．",
		out:  "．ｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ‛．",
	}, { // 505
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0e.\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ:",
		out:  "\x0e.\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ:",
	}, { // 506
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0e．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ:",
		out:  "\x0e．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ:",
	}, { // 507
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0e.\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃．:",
		out:  "\x0e.\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃．:",
	}, { // 508
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0e．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃．:",
		out:  "\x0e．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃．:",
	}, { // 509
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0e.\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ．",
		out:  "\x0e.\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ‛．",
	}, { // 510
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0e．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ．",
		out:  "\x0e．\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ‛．",
	}, { // 511
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃.:",
		out:  "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃.:",
	}, { // 512
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃．:",
		out:  "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃．:",
	}, { // 513
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃.．",
		out:  "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃.‛．",
	}, { // 514
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃．．",
		out:  "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃．‛．",
	}, { // 515
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ.",
		out:  "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ．",
	}, { // 516
		mask: EncodeDel | EncodeRightPeriod,
		in:   "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06␀;π*ＵE＞␈＃λ．",
		out:  "\x0eｚ\f\x0fμ*Ｇ␈＿η.\x1c␙／|＂χ*\x06‛␀;π*ＵE＞␈＃λ‛．",
	}, { // 517
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF␐",
		out:  "‛␔μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛␐",
	}, { // 518
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".．!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF␐",
		out:  ".．!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛␐",
	}, { // 519
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．．!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF␐",
		out:  "．．!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛␐",
	}, { // 520
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s．␐",
		out:  ".μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s．‛␐",
	}, { // 521
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s．␐",
		out:  "．μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s．‛␐",
	}, { // 522
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF．",
		out:  ".μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛．",
	}, { // 523
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF．",
		out:  "．μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛．",
	}, { // 524
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔.!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF␐",
		out:  "‛␔.!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛␐",
	}, { // 525
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔．!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF␐",
		out:  "‛␔．!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛␐",
	}, { // 526
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔.!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s．␐",
		out:  "‛␔.!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s．‛␐",
	}, { // 527
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔．!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s．␐",
		out:  "‛␔．!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s．‛␐",
	}, { // 528
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔.!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF．",
		out:  "‛␔.!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛．",
	}, { // 529
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔．!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF．",
		out:  "‛␔．!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛．",
	}, { // 530
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s.␐",
		out:  "‛␔μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s.‛␐",
	}, { // 531
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s．␐",
		out:  "‛␔μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s．‛␐",
	}, { // 532
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s.．",
		out:  "‛␔μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s.‛．",
	}, { // 533
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９s．．",
		out:  "‛␔μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９s．‛．",
	}, { // 534
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF.",
		out:  "‛␔μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF．",
	}, { // 535
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "␔μ!␅:Lｐ␖ｈ␄.Zαε＋\x1aδＳη\f\vτｃ\x1a＊{９sF．",
		out:  "‛␔μ!‛␅:Lｐ‛␖ｈ‛␄.Zαε＋␚δＳη␌␋τｃ␚＊{９sF‛．",
	}, { // 536
		mask: EncodeLeftSpace,
		in:   "  ",
		out:  "␠ ",
	}, { // 537
		mask: EncodeLeftTilde,
		in:   "~~",
		out:  "～~",
	}, { // 538
		mask: EncodeRightSpace,
		in:   "  ",
		out:  " ␠",
	}, { // 539
		mask: EncodeRightPeriod,
		in:   "..",
		out:  ".．",
	}, { // 540
		mask: EncodeLeftSpace | EncodeRightPeriod,
		in:   " .",
		out:  "␠．",
	}, { // 541
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 542
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "  ",
		out:  "␠␠",
	}, { // 543
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "   ",
		out:  "␠ ␠",
	},
}
