
---
title: "ModuleResource"
title_tag: "foobar.ModuleResource"
meta_desc: "Documentation for the foobar.ModuleResource resource with examples, input properties, output properties, lookup functions, and supporting types."
layout: api
no_edit_this_page: true
---



<!-- WARNING: this file was generated by test. -->
<!-- Do not edit by hand unless you're certain you know what you are doing! -->




## Create a ModuleResource Resource {#create}
<div>
<pulumi-chooser type="language" options="typescript,python,go,csharp,java,yaml"></pulumi-chooser>
</div>


<div>
<pulumi-choosable type="language" values="javascript,typescript">
<div class="highlight"><pre class="chroma"><code class="language-typescript" data-lang="typescript"><span class="k">new </span><span class="nx">ModuleResource</span><span class="p">(</span><span class="nx">name</span><span class="p">:</span> <span class="nx">string</span><span class="p">,</span> <span class="nx">args</span><span class="p">:</span> <span class="nx"><a href="#inputs">ModuleResourceArgs</a></span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#CustomResourceOptions">CustomResourceOptions</a></span><span class="p">);</span></code></pre></div>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<div class="highlight"><pre class="chroma"><code class="language-python" data-lang="python"><span class=nd>@overload</span>
<span class="k">def </span><span class="nx">ModuleResource</span><span class="p">(</span><span class="nx">resource_name</span><span class="p">:</span> <span class="nx">str</span><span class="p">,</span>
                   <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">Optional[ResourceOptions]</a></span> = None<span class="p">,</span>
                   <span class="nx">optional_bool</span><span class="p">:</span> <span class="nx">Optional[bool]</span> = None<span class="p">,</span>
                   <span class="nx">optional_enum</span><span class="p">:</span> <span class="nx">Optional[EnumThing]</span> = None<span class="p">,</span>
                   <span class="nx">optional_number</span><span class="p">:</span> <span class="nx">Optional[float]</span> = None<span class="p">,</span>
                   <span class="nx">optional_string</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                   <span class="nx">plain_optional_bool</span><span class="p">:</span> <span class="nx">Optional[bool]</span> = None<span class="p">,</span>
                   <span class="nx">plain_optional_number</span><span class="p">:</span> <span class="nx">Optional[float]</span> = None<span class="p">,</span>
                   <span class="nx">plain_optional_string</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                   <span class="nx">plain_required_bool</span><span class="p">:</span> <span class="nx">Optional[bool]</span> = None<span class="p">,</span>
                   <span class="nx">plain_required_number</span><span class="p">:</span> <span class="nx">Optional[float]</span> = None<span class="p">,</span>
                   <span class="nx">plain_required_string</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                   <span class="nx">required_bool</span><span class="p">:</span> <span class="nx">Optional[bool]</span> = None<span class="p">,</span>
                   <span class="nx">required_enum</span><span class="p">:</span> <span class="nx">Optional[EnumThing]</span> = None<span class="p">,</span>
                   <span class="nx">required_number</span><span class="p">:</span> <span class="nx">Optional[float]</span> = None<span class="p">,</span>
                   <span class="nx">required_string</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">)</span>
<span class=nd>@overload</span>
<span class="k">def </span><span class="nx">ModuleResource</span><span class="p">(</span><span class="nx">resource_name</span><span class="p">:</span> <span class="nx">str</span><span class="p">,</span>
                   <span class="nx">args</span><span class="p">:</span> <span class="nx"><a href="#inputs">ModuleResourceArgs</a></span><span class="p">,</span>
                   <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">Optional[ResourceOptions]</a></span> = None<span class="p">)</span></code></pre></div>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<div class="highlight"><pre class="chroma"><code class="language-go" data-lang="go"><span class="k">func </span><span class="nx">NewModuleResource</span><span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">name</span><span class="p"> </span><span class="nx">string</span><span class="p">,</span> <span class="nx">args</span><span class="p"> </span><span class="nx"><a href="#inputs">ModuleResourceArgs</a></span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#ResourceOption">ResourceOption</a></span><span class="p">) (*<span class="nx">ModuleResource</span>, error)</span></code></pre></div>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="csharp">
<div class="highlight"><pre class="chroma"><code class="language-csharp" data-lang="csharp"><span class="k">public </span><span class="nx">ModuleResource</span><span class="p">(</span><span class="nx">string</span><span class="p"> </span><span class="nx">name<span class="p">,</span> <span class="nx"><a href="#inputs">ModuleResourceArgs</a></span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.CustomResourceOptions.html">CustomResourceOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span></code></pre></div>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<div class="highlight"><pre class="chroma">
<code class="language-java" data-lang="java"><span class="k">public </span><span class="nx">ModuleResource</span><span class="p">(</span><span class="nx">String</span><span class="p"> </span><span class="nx">name<span class="p">,</span> <span class="nx"><a href="#inputs">ModuleResourceArgs</a></span><span class="p"> </span><span class="nx">args<span class="p">)</span>
<span class="k">public </span><span class="nx">ModuleResource</span><span class="p">(</span><span class="nx">String</span><span class="p"> </span><span class="nx">name<span class="p">,</span> <span class="nx"><a href="#inputs">ModuleResourceArgs</a></span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx">CustomResourceOptions</span><span class="p"> </span><span class="nx">options<span class="p">)</span>
</code></pre></div>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<div class="highlight"><pre class="chroma"><code class="language-yaml" data-lang="yaml">type: <span class="nx">foobar:ModuleResource</span><span class="p"></span>
<span class="p">properties</span><span class="p">: </span><span class="c">#&nbsp;The arguments to resource properties.</span>
<span class="p"></span><span class="p">options</span><span class="p">: </span><span class="c">#&nbsp;Bag of options to control resource&#39;s behavior.</span>
<span class="p"></span>
</code></pre></div>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">ModuleResourceArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#CustomResourceOptions">CustomResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>resource_name</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">ModuleResourceArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/python/pulumi/#pulumi.ResourceOptions">ResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">

<dl class="resources-properties"><dt
        class="property-optional" title="Optional">
        <span>ctx</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span>
    </dt>
    <dd>Context object for the current deployment.</dd><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">ModuleResourceArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#ResourceOption">ResourceOption</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="csharp">

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">ModuleResourceArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>opts</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.CustomResourceOptions.html">CustomResourceOptions</a></span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">

<dl class="resources-properties"><dt
        class="property-required" title="Required">
        <span>name</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd>The unique name of the resource.</dd><dt
        class="property-required" title="Required">
        <span>args</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#inputs">ModuleResourceArgs</a></span>
    </dt>
    <dd>The arguments to resource properties.</dd><dt
        class="property-optional" title="Optional">
        <span>options</span>
        <span class="property-indicator"></span>
        <span class="property-type">CustomResourceOptions</span>
    </dt>
    <dd>Bag of options to control resource&#39;s behavior.</dd></dl>

</pulumi-choosable>
</div>

## ModuleResource Resource Properties {#properties}

To learn more about resource properties and how to use them, see [Inputs and Outputs](/docs/intro/concepts/inputs-outputs) in the Architecture and Concepts docs.

### Inputs

The ModuleResource resource accepts the following [input](/docs/intro/concepts/inputs-outputs) properties:



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="plain_required_bool_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_bool_csharp" style="color: inherit; text-decoration: inherit;">Plain_<wbr>required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_number_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_number_csharp" style="color: inherit; text-decoration: inherit;">Plain_<wbr>required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_string_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_string_csharp" style="color: inherit; text-decoration: inherit;">Plain_<wbr>required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_bool_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_bool_csharp" style="color: inherit; text-decoration: inherit;">Required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_enum_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_enum_csharp" style="color: inherit; text-decoration: inherit;">Required_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Pulumi.<wbr>Foo<wbr>Bar.<wbr>Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_number_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_number_csharp" style="color: inherit; text-decoration: inherit;">Required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_string_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_string_csharp" style="color: inherit; text-decoration: inherit;">Required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_bool_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_bool_csharp" style="color: inherit; text-decoration: inherit;">Optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_enum_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_enum_csharp" style="color: inherit; text-decoration: inherit;">Optional_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Pulumi.<wbr>Foo<wbr>Bar.<wbr>Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_number_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_number_csharp" style="color: inherit; text-decoration: inherit;">Optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_string_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_string_csharp" style="color: inherit; text-decoration: inherit;">Optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_bool_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_bool_csharp" style="color: inherit; text-decoration: inherit;">Plain_<wbr>optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_number_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_number_csharp" style="color: inherit; text-decoration: inherit;">Plain_<wbr>optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_string_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_string_csharp" style="color: inherit; text-decoration: inherit;">Plain_<wbr>optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="plain_required_bool_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_bool_go" style="color: inherit; text-decoration: inherit;">Plain_<wbr>required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_number_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_number_go" style="color: inherit; text-decoration: inherit;">Plain_<wbr>required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_string_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_string_go" style="color: inherit; text-decoration: inherit;">Plain_<wbr>required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_bool_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_bool_go" style="color: inherit; text-decoration: inherit;">Required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_enum_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_enum_go" style="color: inherit; text-decoration: inherit;">Required_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_number_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_number_go" style="color: inherit; text-decoration: inherit;">Required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_string_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_string_go" style="color: inherit; text-decoration: inherit;">Required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_bool_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_bool_go" style="color: inherit; text-decoration: inherit;">Optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_enum_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_enum_go" style="color: inherit; text-decoration: inherit;">Optional_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_number_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_number_go" style="color: inherit; text-decoration: inherit;">Optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_string_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_string_go" style="color: inherit; text-decoration: inherit;">Optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_bool_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_bool_go" style="color: inherit; text-decoration: inherit;">Plain_<wbr>optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_number_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_number_go" style="color: inherit; text-decoration: inherit;">Plain_<wbr>optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_string_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_string_go" style="color: inherit; text-decoration: inherit;">Plain_<wbr>optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="plain_required_bool_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_bool_java" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_number_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_number_java" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_string_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_string_java" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_bool_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_bool_java" style="color: inherit; text-decoration: inherit;">required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_enum_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_enum_java" style="color: inherit; text-decoration: inherit;">required_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_number_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_number_java" style="color: inherit; text-decoration: inherit;">required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_string_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_string_java" style="color: inherit; text-decoration: inherit;">required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_bool_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_bool_java" style="color: inherit; text-decoration: inherit;">optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_enum_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_enum_java" style="color: inherit; text-decoration: inherit;">optional_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_number_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_number_java" style="color: inherit; text-decoration: inherit;">optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_string_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_string_java" style="color: inherit; text-decoration: inherit;">optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_bool_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_bool_java" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_number_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_number_java" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_string_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_string_java" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="plain_required_bool_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_bool_nodejs" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">boolean</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_number_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_number_nodejs" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_string_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_string_nodejs" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_bool_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_bool_nodejs" style="color: inherit; text-decoration: inherit;">required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">boolean</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_enum_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_enum_nodejs" style="color: inherit; text-decoration: inherit;">required_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_number_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_number_nodejs" style="color: inherit; text-decoration: inherit;">required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_string_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_string_nodejs" style="color: inherit; text-decoration: inherit;">required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_bool_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_bool_nodejs" style="color: inherit; text-decoration: inherit;">optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">boolean</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_enum_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_enum_nodejs" style="color: inherit; text-decoration: inherit;">optional_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_number_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_number_nodejs" style="color: inherit; text-decoration: inherit;">optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_string_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_string_nodejs" style="color: inherit; text-decoration: inherit;">optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_bool_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_bool_nodejs" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">boolean</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_number_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_number_nodejs" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_string_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_string_nodejs" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="plain_required_bool_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_bool_python" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_number_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_number_python" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_string_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_string_python" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_bool_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_bool_python" style="color: inherit; text-decoration: inherit;">required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_enum_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_enum_python" style="color: inherit; text-decoration: inherit;">required_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_number_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_number_python" style="color: inherit; text-decoration: inherit;">required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_string_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_string_python" style="color: inherit; text-decoration: inherit;">required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_bool_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_bool_python" style="color: inherit; text-decoration: inherit;">optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_enum_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_enum_python" style="color: inherit; text-decoration: inherit;">optional_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">Enum<wbr>Thing</a></span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_number_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_number_python" style="color: inherit; text-decoration: inherit;">optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_string_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_string_python" style="color: inherit; text-decoration: inherit;">optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_bool_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_bool_python" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">bool</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_number_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_number_python" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_string_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_string_python" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="plain_required_bool_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_bool_yaml" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_number_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_number_yaml" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="plain_required_string_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_required_string_yaml" style="color: inherit; text-decoration: inherit;">plain_<wbr>required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_bool_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_bool_yaml" style="color: inherit; text-decoration: inherit;">required_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_enum_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_enum_yaml" style="color: inherit; text-decoration: inherit;">required_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">4 | 6 | 8</a></span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_number_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_number_yaml" style="color: inherit; text-decoration: inherit;">required_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd></dd><dt class="property-required"
            title="Required">
        <span id="required_string_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#required_string_yaml" style="color: inherit; text-decoration: inherit;">required_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_bool_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_bool_yaml" style="color: inherit; text-decoration: inherit;">optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_enum_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_enum_yaml" style="color: inherit; text-decoration: inherit;">optional_<wbr>enum</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#enumthing">4 | 6 | 8</a></span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_number_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_number_yaml" style="color: inherit; text-decoration: inherit;">optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="optional_string_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#optional_string_yaml" style="color: inherit; text-decoration: inherit;">optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_bool_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_bool_yaml" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>bool</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Boolean</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_number_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_number_yaml" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>number</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd></dd><dt class="property-optional"
            title="Optional">
        <span id="plain_optional_string_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#plain_optional_string_yaml" style="color: inherit; text-decoration: inherit;">plain_<wbr>optional_<wbr>string</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd></dd></dl>
</pulumi-choosable>
</div>


### Outputs

All [input](#inputs) properties are implicitly available as output properties. Additionally, the ModuleResource resource produces the following output properties:



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_csharp" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_go" style="color: inherit; text-decoration: inherit;">Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_java" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_nodejs" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_python" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="id_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#id_yaml" style="color: inherit; text-decoration: inherit;">id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>The provider-assigned unique ID for this managed resource.</p>
</dd></dl>
</pulumi-choosable>
</div>







## Supporting Types



<h4 id="enumthing">Enum<wbr>Thing</h4>

<div>
<pulumi-choosable type="language" values="csharp">
<dl class="tabular"><dt>Four</dt>
    <dd>4</dd><dt>Six</dt>
    <dd>6</dd><dt>Eight</dt>
    <dd>8</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="tabular"><dt>Enum<wbr>Thing<wbr>Four</dt>
    <dd>4</dd><dt>Enum<wbr>Thing<wbr>Six</dt>
    <dd>6</dd><dt>Enum<wbr>Thing<wbr>Eight</dt>
    <dd>8</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="tabular"><dt>Four</dt>
    <dd>4</dd><dt>Six</dt>
    <dd>6</dd><dt>Eight</dt>
    <dd>8</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="nodejs">
<dl class="tabular"><dt>Four</dt>
    <dd>4</dd><dt>Six</dt>
    <dd>6</dd><dt>Eight</dt>
    <dd>8</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="tabular"><dt>FOUR</dt>
    <dd>4</dd><dt>SIX</dt>
    <dd>6</dd><dt>EIGHT</dt>
    <dd>8</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="tabular"><dt>'\x04'</dt>
    <dd>4</dd><dt>'\x06'</dt>
    <dd>6</dd><dt>'\b'</dt>
    <dd>8</dd></dl>
</pulumi-choosable>
</div>


<h2 id="package-details">Package Details</h2>
<dl class="package-details">
	<dt>Repository</dt>
	<dd><a href=""></a></dd>
	<dt>License</dt>
	<dd></dd>
</dl>

