
---
title: "listProductFamilies"
title_tag: "myedgeorder.listProductFamilies"
meta_desc: "Documentation for the myedgeorder.listProductFamilies function with examples, input properties, output properties, and supporting types."
layout: api
no_edit_this_page: true
---



<!-- WARNING: this file was generated by test. -->
<!-- Do not edit by hand unless you're certain you know what you are doing! -->

The list of product families.
API Version: 2020-12-01-preview.




## Using listProductFamilies {#using}

Two invocation forms are available. The direct form accepts plain
arguments and either blocks until the result value is available, or
returns a Promise-wrapped result. The output form accepts
Input-wrapped arguments and returns an Output-wrapped result.

<div>
<pulumi-chooser type="language" options="typescript,python,go,csharp,java,yaml"></pulumi-chooser>
</div>


<div>
<pulumi-choosable type="language" values="javascript,typescript">
<div class="highlight"
><pre class="chroma"><code class="language-typescript" data-lang="typescript"
><span class="k">function </span>listProductFamilies<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">ListProductFamiliesArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Promise&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>></span
><span class="k">
function </span>listProductFamiliesOutput<span class="p">(</span><span class="nx">args</span><span class="p">:</span> <span class="nx">ListProductFamiliesOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p">?:</span> <span class="nx"><a href="/docs/reference/pkg/nodejs/pulumi/pulumi/#InvokeOptions">InvokeOptions</a></span><span class="p">): Output&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>></span
></code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="python">
<div class="highlight"><pre class="chroma"><code class="language-python" data-lang="python"
><span class="k">def </span>list_product_families<span class="p">(</span><span class="nx">customer_subscription_details</span><span class="p">:</span> <span class="nx">Optional[CustomerSubscriptionDetails]</span> = None<span class="p">,</span>
                          <span class="nx">expand</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                          <span class="nx">filterable_properties</span><span class="p">:</span> <span class="nx">Optional[Mapping[str, Sequence[FilterableProperty]]]</span> = None<span class="p">,</span>
                          <span class="nx">skip_token</span><span class="p">:</span> <span class="nx">Optional[str]</span> = None<span class="p">,</span>
                          <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>ListProductFamiliesResult</span
><span class="k">
def </span>list_product_families_output<span class="p">(</span><span class="nx">customer_subscription_details</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[CustomerSubscriptionDetailsArgs]]</span> = None<span class="p">,</span>
                          <span class="nx">expand</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[str]]</span> = None<span class="p">,</span>
                          <span class="nx">filterable_properties</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[FilterablePropertyArgs]]]]]]</span> = None<span class="p">,</span>
                          <span class="nx">skip_token</span><span class="p">:</span> <span class="nx">Optional[pulumi.Input[str]]</span> = None<span class="p">,</span>
                          <span class="nx">opts</span><span class="p">:</span> <span class="nx"><a href="/docs/reference/pkg/python/pulumi/#pulumi.InvokeOptions">Optional[InvokeOptions]</a></span> = None<span class="p">) -&gt;</span> <span>Output[ListProductFamiliesResult]</span
></code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="go">
<div class="highlight"><pre class="chroma"><code class="language-go" data-lang="go"
><span class="k">func </span>ListProductFamilies<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">ListProductFamiliesArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) (*<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>, error)</span
><span class="k">
func </span>ListProductFamiliesOutput<span class="p">(</span><span class="nx">ctx</span><span class="p"> *</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#Context">Context</a></span><span class="p">,</span> <span class="nx">args</span><span class="p"> *</span><span class="nx">ListProductFamiliesOutputArgs</span><span class="p">,</span> <span class="nx">opts</span><span class="p"> ...</span><span class="nx"><a href="https://pkg.go.dev/github.com/pulumi/pulumi/sdk/v3/go/pulumi?tab=doc#InvokeOption">InvokeOption</a></span><span class="p">) ListProductFamiliesResultOutput</span
></code></pre></div>

&gt; Note: This function is named `ListProductFamilies` in the Go SDK.

</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="csharp">
<div class="highlight"><pre class="chroma"><code class="language-csharp" data-lang="csharp"><span class="k">public static class </span><span class="nx">ListProductFamilies </span><span class="p">
{</span><span class="k">
    public static </span>Task&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>> <span class="p">InvokeAsync(</span><span class="nx">ListProductFamiliesArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="k">
    public static </span>Output&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>> <span class="p">Invoke(</span><span class="nx">ListProductFamiliesInvokeArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx"><a href="/docs/reference/pkg/dotnet/Pulumi/Pulumi.InvokeOptions.html">InvokeOptions</a></span><span class="p">? </span><span class="nx">opts = null<span class="p">)</span><span class="p">
}</span></code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="java">
<div class="highlight"><pre class="chroma"><code class="language-java" data-lang="java"><span class="k">public static CompletableFuture&lt;<span class="nx"><a href="#result">ListProductFamiliesResult</a></span>> </span>listProductFamilies<span class="p">(</span><span class="nx">ListProductFamiliesArgs</span><span class="p"> </span><span class="nx">args<span class="p">,</span> <span class="nx">InvokeOptions</span><span class="p"> </span><span class="nx">options<span class="p">)</span>
<span class="c">// Output-based functions aren't available in Java yet</span>
</code></pre></div>
</pulumi-choosable>
</div>


<div>
<pulumi-choosable type="language" values="java">
<div class="highlight"><pre class="chroma"><code class="language-yaml" data-lang="yaml"><span class="k">Fn::Invoke:</span>
<span class="k">&nbsp;&nbsp;Function:</span> myedgeorder:listProductFamilies
<span class="k">&nbsp;&nbsp;Arguments:</span>
<span class="c">&nbsp;&nbsp;&nbsp;&nbsp;# Arguments dictionary</span></code></pre></div>
</pulumi-choosable>
</div>



The following arguments are supported:


<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Dictionary&lt;string, Immutable<wbr>Array&lt;Filterable<wbr>Property&gt;&gt;</span>
    </dt>
    <dd><p>Dictionary of filterable properties on product family.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_csharp" style="color: inherit; text-decoration: inherit;">Customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd><p>Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#expand_csharp" style="color: inherit; text-decoration: inherit;">Expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>$expand is supported on configurations parameter for product, which provides details on the configurations for the product.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_csharp" style="color: inherit; text-decoration: inherit;">Skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>$skipToken is supported on list of product families, which provides the next page in the list of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">map[string][]Filterable<wbr>Property</span>
    </dt>
    <dd><p>Dictionary of filterable properties on product family.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_go" style="color: inherit; text-decoration: inherit;">Customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd><p>Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#expand_go" style="color: inherit; text-decoration: inherit;">Expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>$expand is supported on configurations parameter for product, which provides details on the configurations for the product.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_go" style="color: inherit; text-decoration: inherit;">Skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>$skipToken is supported on list of product families, which provides the next page in the list of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_java" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Map<String,List<Filterable<wbr>Property>></span>
    </dt>
    <dd><p>Dictionary of filterable properties on product family.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_java" style="color: inherit; text-decoration: inherit;">customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd><p>Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#expand_java" style="color: inherit; text-decoration: inherit;">expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>$expand is supported on configurations parameter for product, which provides details on the configurations for the product.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_java" style="color: inherit; text-decoration: inherit;">skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>$skipToken is supported on list of product families, which provides the next page in the list of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">{[key: string]: Filterable<wbr>Property[]}</span>
    </dt>
    <dd><p>Dictionary of filterable properties on product family.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_nodejs" style="color: inherit; text-decoration: inherit;">customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd><p>Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#expand_nodejs" style="color: inherit; text-decoration: inherit;">expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>$expand is supported on configurations parameter for product, which provides details on the configurations for the product.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_nodejs" style="color: inherit; text-decoration: inherit;">skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>$skipToken is supported on list of product families, which provides the next page in the list of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Mapping[str, Sequence[Filterable<wbr>Property]]</span>
    </dt>
    <dd><p>Dictionary of filterable properties on product family.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="customer_subscription_details_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customer_subscription_details_python" style="color: inherit; text-decoration: inherit;">customer_<wbr>subscription_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</a></span>
    </dt>
    <dd><p>Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#expand_python" style="color: inherit; text-decoration: inherit;">expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>$expand is supported on configurations parameter for product, which provides details on the configurations for the product.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="skip_token_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skip_token_python" style="color: inherit; text-decoration: inherit;">skip_<wbr>token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>$skipToken is supported on list of product families, which provides the next page in the list of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="filterableproperties_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_yaml" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Map<List<Property Map>></span>
    </dt>
    <dd><p>Dictionary of filterable properties on product family.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="customersubscriptiondetails_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#customersubscriptiondetails_yaml" style="color: inherit; text-decoration: inherit;">customer<wbr>Subscription<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptiondetails">Property Map</a></span>
    </dt>
    <dd><p>Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="expand_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#expand_yaml" style="color: inherit; text-decoration: inherit;">expand</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>$expand is supported on configurations parameter for product, which provides details on the configurations for the product.</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="skiptoken_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skiptoken_yaml" style="color: inherit; text-decoration: inherit;">skip<wbr>Token</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>$skipToken is supported on list of product families, which provides the next page in the list of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>




## listProductFamilies Result {#result}

The following output properties are available:



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_csharp" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">List&lt;Product<wbr>Family<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>List of product families.</p>
</dd><dt class="property-"
            title="">
        <span id="nextlink_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_csharp" style="color: inherit; text-decoration: inherit;">Next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Link for the next set of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_go" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">[]Product<wbr>Family<wbr>Response</a></span>
    </dt>
    <dd><p>List of product families.</p>
</dd><dt class="property-"
            title="">
        <span id="nextlink_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_go" style="color: inherit; text-decoration: inherit;">Next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Link for the next set of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_java" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">List<Product<wbr>Family<wbr>Response></a></span>
    </dt>
    <dd><p>List of product families.</p>
</dd><dt class="property-"
            title="">
        <span id="nextlink_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_java" style="color: inherit; text-decoration: inherit;">next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Link for the next set of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_nodejs" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">Product<wbr>Family<wbr>Response[]</a></span>
    </dt>
    <dd><p>List of product families.</p>
</dd><dt class="property-"
            title="">
        <span id="nextlink_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_nodejs" style="color: inherit; text-decoration: inherit;">next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Link for the next set of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_python" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">Sequence[Product<wbr>Family<wbr>Response]</a></span>
    </dt>
    <dd><p>List of product families.</p>
</dd><dt class="property-"
            title="">
        <span id="next_link_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#next_link_python" style="color: inherit; text-decoration: inherit;">next_<wbr>link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Link for the next set of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-"
            title="">
        <span id="value_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_yaml" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productfamilyresponse">List<Property Map></a></span>
    </dt>
    <dd><p>List of product families.</p>
</dd><dt class="property-"
            title="">
        <span id="nextlink_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#nextlink_yaml" style="color: inherit; text-decoration: inherit;">next<wbr>Link</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Link for the next set of product families.</p>
</dd></dl>
</pulumi-choosable>
</div>




## Supporting Types


<h4 id="availabilityinformationresponse">Availability<wbr>Information<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Current availability stage of the product. Availability stage</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_csharp" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Reason why the product is disabled.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_csharp" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Message for why the product is disabled.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Current availability stage of the product. Availability stage</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_go" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Reason why the product is disabled.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_go" style="color: inherit; text-decoration: inherit;">Disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Message for why the product is disabled.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_java" style="color: inherit; text-decoration: inherit;">availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Current availability stage of the product. Availability stage</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_java" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Reason why the product is disabled.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_java" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Message for why the product is disabled.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Current availability stage of the product. Availability stage</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_nodejs" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Reason why the product is disabled.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_nodejs" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Message for why the product is disabled.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_stage_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availability_stage_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Current availability stage of the product. Availability stage</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabled_reason_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabled_reason_python" style="color: inherit; text-decoration: inherit;">disabled_<wbr>reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Reason why the product is disabled.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabled_reason_message_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabled_reason_message_python" style="color: inherit; text-decoration: inherit;">disabled_<wbr>reason_<wbr>message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Message for why the product is disabled.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilitystage_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilitystage_yaml" style="color: inherit; text-decoration: inherit;">availability<wbr>Stage</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Current availability stage of the product. Availability stage</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreason_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreason_yaml" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Reason why the product is disabled.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="disabledreasonmessage_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#disabledreasonmessage_yaml" style="color: inherit; text-decoration: inherit;">disabled<wbr>Reason<wbr>Message</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Message for why the product is disabled.</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="billingmeterdetailsresponse">Billing<wbr>Meter<wbr>Details<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_csharp" style="color: inherit; text-decoration: inherit;">Frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Frequency of recurrence</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_csharp" style="color: inherit; text-decoration: inherit;">Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd><p>Represents MeterDetails</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_csharp" style="color: inherit; text-decoration: inherit;">Metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents Metering type (eg one-time or recurrent)</p>
</dd><dt class="property-required"
            title="Required">
        <span id="name_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents Billing type name</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_go" style="color: inherit; text-decoration: inherit;">Frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Frequency of recurrence</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_go" style="color: inherit; text-decoration: inherit;">Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd><p>Represents MeterDetails</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_go" style="color: inherit; text-decoration: inherit;">Metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents Metering type (eg one-time or recurrent)</p>
</dd><dt class="property-required"
            title="Required">
        <span id="name_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents Billing type name</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_java" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Frequency of recurrence</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_java" style="color: inherit; text-decoration: inherit;">meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd><p>Represents MeterDetails</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_java" style="color: inherit; text-decoration: inherit;">metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents Metering type (eg one-time or recurrent)</p>
</dd><dt class="property-required"
            title="Required">
        <span id="name_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_java" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents Billing type name</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_nodejs" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Frequency of recurrence</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_nodejs" style="color: inherit; text-decoration: inherit;">meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd><p>Represents MeterDetails</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_nodejs" style="color: inherit; text-decoration: inherit;">metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents Metering type (eg one-time or recurrent)</p>
</dd><dt class="property-required"
            title="Required">
        <span id="name_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents Billing type name</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_python" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Frequency of recurrence</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meter_details_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meter_details_python" style="color: inherit; text-decoration: inherit;">meter_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</a> | <a href="#purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd><p>Represents MeterDetails</p>
</dd><dt class="property-required"
            title="Required">
        <span id="metering_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#metering_type_python" style="color: inherit; text-decoration: inherit;">metering_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Represents Metering type (eg one-time or recurrent)</p>
</dd><dt class="property-required"
            title="Required">
        <span id="name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Represents Billing type name</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="frequency_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#frequency_yaml" style="color: inherit; text-decoration: inherit;">frequency</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Frequency of recurrence</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterdetails_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterdetails_yaml" style="color: inherit; text-decoration: inherit;">meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#pav2meterdetailsresponse">Property Map</a> | <a href="#purchasemeterdetailsresponse">Property Map</a></span>
    </dt>
    <dd><p>Represents MeterDetails</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meteringtype_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meteringtype_yaml" style="color: inherit; text-decoration: inherit;">metering<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents Metering type (eg one-time or recurrent)</p>
</dd><dt class="property-required"
            title="Required">
        <span id="name_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_yaml" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents Billing type name</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="configurationresponse">Configuration<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_csharp" style="color: inherit; text-decoration: inherit;">Dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd><p>Dimensions of the configuration</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="specifications_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_csharp" style="color: inherit; text-decoration: inherit;">Specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">List&lt;Specification<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>Specifications of the configuration</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_go" style="color: inherit; text-decoration: inherit;">Dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd><p>Dimensions of the configuration</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="specifications_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_go" style="color: inherit; text-decoration: inherit;">Specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">[]Specification<wbr>Response</a></span>
    </dt>
    <dd><p>Specifications of the configuration</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_java" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_java" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_java" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_java" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd><p>Dimensions of the configuration</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_java" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_java" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Filterable<wbr>Property<wbr>Response></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_java" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_java" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Image<wbr>Information<wbr>Response></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="specifications_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_java" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">List<Specification<wbr>Response></a></span>
    </dt>
    <dd><p>Specifications of the configuration</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_nodejs" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd><p>Dimensions of the configuration</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="specifications_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_nodejs" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">Specification<wbr>Response[]</a></span>
    </dt>
    <dd><p>Specifications of the configuration</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_python" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Dimensions<wbr>Response</a></span>
    </dt>
    <dd><p>Dimensions of the configuration</p>
</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="specifications_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_python" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">Sequence[Specification<wbr>Response]</a></span>
    </dt>
    <dd><p>Specifications of the configuration</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_yaml" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_yaml" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_yaml" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Property Map</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="dimensions_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#dimensions_yaml" style="color: inherit; text-decoration: inherit;">dimensions</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#dimensionsresponse">Property Map</a></span>
    </dt>
    <dd><p>Dimensions of the configuration</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_yaml" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_yaml" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Property Map></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_yaml" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_yaml" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Property Map></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="specifications_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#specifications_yaml" style="color: inherit; text-decoration: inherit;">specifications</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#specificationresponse">List<Property Map></a></span>
    </dt>
    <dd><p>Specifications of the configuration</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="costinformationresponse">Cost<wbr>Information<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_csharp" style="color: inherit; text-decoration: inherit;">Billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Default url to display billing information</p>
</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_csharp" style="color: inherit; text-decoration: inherit;">Billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">List&lt;Billing<wbr>Meter<wbr>Details<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>Details on the various billing aspects for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_go" style="color: inherit; text-decoration: inherit;">Billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Default url to display billing information</p>
</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_go" style="color: inherit; text-decoration: inherit;">Billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">[]Billing<wbr>Meter<wbr>Details<wbr>Response</a></span>
    </dt>
    <dd><p>Details on the various billing aspects for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_java" style="color: inherit; text-decoration: inherit;">billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Default url to display billing information</p>
</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_java" style="color: inherit; text-decoration: inherit;">billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">List<Billing<wbr>Meter<wbr>Details<wbr>Response></a></span>
    </dt>
    <dd><p>Details on the various billing aspects for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_nodejs" style="color: inherit; text-decoration: inherit;">billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Default url to display billing information</p>
</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_nodejs" style="color: inherit; text-decoration: inherit;">billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">Billing<wbr>Meter<wbr>Details<wbr>Response[]</a></span>
    </dt>
    <dd><p>Details on the various billing aspects for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billing_info_url_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billing_info_url_python" style="color: inherit; text-decoration: inherit;">billing_<wbr>info_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Default url to display billing information</p>
</dd><dt class="property-required"
            title="Required">
        <span id="billing_meter_details_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billing_meter_details_python" style="color: inherit; text-decoration: inherit;">billing_<wbr>meter_<wbr>details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">Sequence[Billing<wbr>Meter<wbr>Details<wbr>Response]</a></span>
    </dt>
    <dd><p>Details on the various billing aspects for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="billinginfourl_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billinginfourl_yaml" style="color: inherit; text-decoration: inherit;">billing<wbr>Info<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Default url to display billing information</p>
</dd><dt class="property-required"
            title="Required">
        <span id="billingmeterdetails_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#billingmeterdetails_yaml" style="color: inherit; text-decoration: inherit;">billing<wbr>Meter<wbr>Details</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#billingmeterdetailsresponse">List<Property Map></a></span>
    </dt>
    <dd><p>Details on the various billing aspects for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="customersubscriptiondetails">Customer<wbr>Subscription<wbr>Details</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_csharp" style="color: inherit; text-decoration: inherit;">Quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Quota ID of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_csharp" style="color: inherit; text-decoration: inherit;">Location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Location placement Id of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_csharp" style="color: inherit; text-decoration: inherit;">Registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">List&lt;Customer<wbr>Subscription<wbr>Registered<wbr>Features&gt;</a></span>
    </dt>
    <dd><p>List of registered feature flags for subscription</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_go" style="color: inherit; text-decoration: inherit;">Quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Quota ID of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_go" style="color: inherit; text-decoration: inherit;">Location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Location placement Id of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_go" style="color: inherit; text-decoration: inherit;">Registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">[]Customer<wbr>Subscription<wbr>Registered<wbr>Features</a></span>
    </dt>
    <dd><p>List of registered feature flags for subscription</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_java" style="color: inherit; text-decoration: inherit;">quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Quota ID of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_java" style="color: inherit; text-decoration: inherit;">location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Location placement Id of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_java" style="color: inherit; text-decoration: inherit;">registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">List<Customer<wbr>Subscription<wbr>Registered<wbr>Features></a></span>
    </dt>
    <dd><p>List of registered feature flags for subscription</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_nodejs" style="color: inherit; text-decoration: inherit;">quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Quota ID of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_nodejs" style="color: inherit; text-decoration: inherit;">location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Location placement Id of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_nodejs" style="color: inherit; text-decoration: inherit;">registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">Customer<wbr>Subscription<wbr>Registered<wbr>Features[]</a></span>
    </dt>
    <dd><p>List of registered feature flags for subscription</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quota_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quota_id_python" style="color: inherit; text-decoration: inherit;">quota_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Quota ID of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="location_placement_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#location_placement_id_python" style="color: inherit; text-decoration: inherit;">location_<wbr>placement_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Location placement Id of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="registered_features_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registered_features_python" style="color: inherit; text-decoration: inherit;">registered_<wbr>features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">Sequence[Customer<wbr>Subscription<wbr>Registered<wbr>Features]</a></span>
    </dt>
    <dd><p>List of registered feature flags for subscription</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="quotaid_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#quotaid_yaml" style="color: inherit; text-decoration: inherit;">quota<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Quota ID of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="locationplacementid_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#locationplacementid_yaml" style="color: inherit; text-decoration: inherit;">location<wbr>Placement<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Location placement Id of a subscription</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="registeredfeatures_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#registeredfeatures_yaml" style="color: inherit; text-decoration: inherit;">registered<wbr>Features</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#customersubscriptionregisteredfeatures">List<Property Map></a></span>
    </dt>
    <dd><p>List of registered feature flags for subscription</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="customersubscriptionregisteredfeatures">Customer<wbr>Subscription<wbr>Registered<wbr>Features</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Name of subscription registered feature</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="state_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_csharp" style="color: inherit; text-decoration: inherit;">State</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>State of subscription registered feature</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Name of subscription registered feature</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="state_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_go" style="color: inherit; text-decoration: inherit;">State</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>State of subscription registered feature</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_java" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Name of subscription registered feature</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="state_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_java" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>State of subscription registered feature</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Name of subscription registered feature</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="state_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_nodejs" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>State of subscription registered feature</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Name of subscription registered feature</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="state_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_python" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>State of subscription registered feature</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="name_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_yaml" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Name of subscription registered feature</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="state_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#state_yaml" style="color: inherit; text-decoration: inherit;">state</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>State of subscription registered feature</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="descriptionresponse">Description<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_csharp" style="color: inherit; text-decoration: inherit;">Attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd><p>Attributes for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_csharp" style="color: inherit; text-decoration: inherit;">Description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of description.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="keywords_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_csharp" style="color: inherit; text-decoration: inherit;">Keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd><p>Keywords for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="links_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_csharp" style="color: inherit; text-decoration: inherit;">Links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">List&lt;Link<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>Links for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_csharp" style="color: inherit; text-decoration: inherit;">Long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Long description of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_csharp" style="color: inherit; text-decoration: inherit;">Short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Short description of the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_go" style="color: inherit; text-decoration: inherit;">Attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd><p>Attributes for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_go" style="color: inherit; text-decoration: inherit;">Description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of description.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="keywords_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_go" style="color: inherit; text-decoration: inherit;">Keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd><p>Keywords for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="links_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_go" style="color: inherit; text-decoration: inherit;">Links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">[]Link<wbr>Response</a></span>
    </dt>
    <dd><p>Links for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_go" style="color: inherit; text-decoration: inherit;">Long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Long description of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_go" style="color: inherit; text-decoration: inherit;">Short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Short description of the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_java" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Attributes for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_java" style="color: inherit; text-decoration: inherit;">description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of description.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="keywords_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_java" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Keywords for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="links_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_java" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">List<Link<wbr>Response></a></span>
    </dt>
    <dd><p>Links for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_java" style="color: inherit; text-decoration: inherit;">long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Long description of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_java" style="color: inherit; text-decoration: inherit;">short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Short description of the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_nodejs" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd><p>Attributes for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_nodejs" style="color: inherit; text-decoration: inherit;">description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of description.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="keywords_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_nodejs" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd><p>Keywords for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="links_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_nodejs" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">Link<wbr>Response[]</a></span>
    </dt>
    <dd><p>Links for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_nodejs" style="color: inherit; text-decoration: inherit;">long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Long description of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_nodejs" style="color: inherit; text-decoration: inherit;">short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Short description of the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_python" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd><p>Attributes for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_type_python" style="color: inherit; text-decoration: inherit;">description_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Type of description.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="keywords_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_python" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd><p>Keywords for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="links_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_python" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">Sequence[Link<wbr>Response]</a></span>
    </dt>
    <dd><p>Links for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="long_description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#long_description_python" style="color: inherit; text-decoration: inherit;">long_<wbr>description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Long description of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="short_description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#short_description_python" style="color: inherit; text-decoration: inherit;">short_<wbr>description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Short description of the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="attributes_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#attributes_yaml" style="color: inherit; text-decoration: inherit;">attributes</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Attributes for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="descriptiontype_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#descriptiontype_yaml" style="color: inherit; text-decoration: inherit;">description<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of description.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="keywords_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#keywords_yaml" style="color: inherit; text-decoration: inherit;">keywords</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Keywords for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="links_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#links_yaml" style="color: inherit; text-decoration: inherit;">links</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#linkresponse">List<Property Map></a></span>
    </dt>
    <dd><p>Links for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="longdescription_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#longdescription_yaml" style="color: inherit; text-decoration: inherit;">long<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Long description of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="shortdescription_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#shortdescription_yaml" style="color: inherit; text-decoration: inherit;">short<wbr>Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Short description of the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="dimensionsresponse">Dimensions<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_csharp" style="color: inherit; text-decoration: inherit;">Depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd><p>Depth of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="height_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_csharp" style="color: inherit; text-decoration: inherit;">Height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd><p>Height of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="length_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_csharp" style="color: inherit; text-decoration: inherit;">Length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd><p>Length of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_csharp" style="color: inherit; text-decoration: inherit;">Length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Unit for the dimensions of length, height and width.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weight_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_csharp" style="color: inherit; text-decoration: inherit;">Weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd><p>Weight of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_csharp" style="color: inherit; text-decoration: inherit;">Weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Unit for the dimensions of weight.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="width_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_csharp" style="color: inherit; text-decoration: inherit;">Width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd><p>Width of the device.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_go" style="color: inherit; text-decoration: inherit;">Depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd><p>Depth of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="height_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_go" style="color: inherit; text-decoration: inherit;">Height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd><p>Height of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="length_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_go" style="color: inherit; text-decoration: inherit;">Length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd><p>Length of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_go" style="color: inherit; text-decoration: inherit;">Length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Unit for the dimensions of length, height and width.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weight_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_go" style="color: inherit; text-decoration: inherit;">Weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd><p>Weight of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_go" style="color: inherit; text-decoration: inherit;">Weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Unit for the dimensions of weight.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="width_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_go" style="color: inherit; text-decoration: inherit;">Width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd><p>Width of the device.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_java" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd><p>Depth of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="height_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_java" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd><p>Height of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="length_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_java" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd><p>Length of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_java" style="color: inherit; text-decoration: inherit;">length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Unit for the dimensions of length, height and width.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weight_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_java" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd><p>Weight of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_java" style="color: inherit; text-decoration: inherit;">weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Unit for the dimensions of weight.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="width_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_java" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd><p>Width of the device.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_nodejs" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd><p>Depth of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="height_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_nodejs" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd><p>Height of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="length_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_nodejs" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd><p>Length of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_nodejs" style="color: inherit; text-decoration: inherit;">length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Unit for the dimensions of length, height and width.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weight_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_nodejs" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd><p>Weight of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_nodejs" style="color: inherit; text-decoration: inherit;">weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Unit for the dimensions of weight.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="width_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_nodejs" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd><p>Width of the device.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_python" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd><p>Depth of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="height_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_python" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd><p>Height of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="length_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_python" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd><p>Length of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="length_height_unit_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_height_unit_python" style="color: inherit; text-decoration: inherit;">length_<wbr>height_<wbr>unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Unit for the dimensions of length, height and width.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weight_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_python" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd><p>Weight of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weight_unit_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_unit_python" style="color: inherit; text-decoration: inherit;">weight_<wbr>unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Unit for the dimensions of weight.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="width_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_python" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd><p>Width of the device.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="depth_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#depth_yaml" style="color: inherit; text-decoration: inherit;">depth</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd><p>Depth of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="height_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#height_yaml" style="color: inherit; text-decoration: inherit;">height</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd><p>Height of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="length_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#length_yaml" style="color: inherit; text-decoration: inherit;">length</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd><p>Length of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="lengthheightunit_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#lengthheightunit_yaml" style="color: inherit; text-decoration: inherit;">length<wbr>Height<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Unit for the dimensions of length, height and width.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weight_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weight_yaml" style="color: inherit; text-decoration: inherit;">weight</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd><p>Weight of the device.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="weightunit_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#weightunit_yaml" style="color: inherit; text-decoration: inherit;">weight<wbr>Unit</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Unit for the dimensions of weight.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="width_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#width_yaml" style="color: inherit; text-decoration: inherit;">width</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd><p>Width of the device.</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="filterableproperty">Filterable<wbr>Property</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_csharp" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_csharp" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Pulumi.<wbr>Myedgeorder.<wbr>Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_go" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_go" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_java" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_java" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_nodejs" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_nodejs" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supported_values_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supported_values_python" style="color: inherit; text-decoration: inherit;">supported_<wbr>values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_python" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str | <a href="#supportedfiltertypes">Supported<wbr>Filter<wbr>Types</a></span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_yaml" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_yaml" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String | <a href="#supportedfiltertypes">"Ship<wbr>To<wbr>Countries" | "Double<wbr>Encryption<wbr>Status"</a></span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="filterablepropertyresponse">Filterable<wbr>Property<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_csharp" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List&lt;string&gt;</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_csharp" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_go" style="color: inherit; text-decoration: inherit;">Supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">[]string</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_go" style="color: inherit; text-decoration: inherit;">Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_java" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_java" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_nodejs" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string[]</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_nodejs" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supported_values_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supported_values_python" style="color: inherit; text-decoration: inherit;">supported_<wbr>values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Sequence[str]</span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_python" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="supportedvalues_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#supportedvalues_yaml" style="color: inherit; text-decoration: inherit;">supported<wbr>Values</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">List<String></span>
    </dt>
    <dd><p>Values to be filtered.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="type_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#type_yaml" style="color: inherit; text-decoration: inherit;">type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of product filter.</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_csharp" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents configuration name that uniquely identifies configuration</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product family name that uniquely identifies product family</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product line name that uniquely identifies product line</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product name that uniquely identifies product</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_go" style="color: inherit; text-decoration: inherit;">Configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents configuration name that uniquely identifies configuration</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product family name that uniquely identifies product family</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product line name that uniquely identifies product line</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product name that uniquely identifies product</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_java" style="color: inherit; text-decoration: inherit;">configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents configuration name that uniquely identifies configuration</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_java" style="color: inherit; text-decoration: inherit;">product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents product family name that uniquely identifies product family</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_java" style="color: inherit; text-decoration: inherit;">product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents product line name that uniquely identifies product line</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_java" style="color: inherit; text-decoration: inherit;">product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents product name that uniquely identifies product</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_nodejs" style="color: inherit; text-decoration: inherit;">configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents configuration name that uniquely identifies configuration</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product family name that uniquely identifies product family</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product line name that uniquely identifies product line</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Represents product name that uniquely identifies product</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configuration_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configuration_name_python" style="color: inherit; text-decoration: inherit;">configuration_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Represents configuration name that uniquely identifies configuration</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="product_family_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_family_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>family_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Represents product family name that uniquely identifies product family</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="product_line_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_line_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>line_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Represents product line name that uniquely identifies product line</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="product_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_name_python" style="color: inherit; text-decoration: inherit;">product_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Represents product name that uniquely identifies product</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-optional"
            title="Optional">
        <span id="configurationname_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurationname_yaml" style="color: inherit; text-decoration: inherit;">configuration<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents configuration name that uniquely identifies configuration</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productfamilyname_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productfamilyname_yaml" style="color: inherit; text-decoration: inherit;">product<wbr>Family<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents product family name that uniquely identifies product family</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productlinename_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlinename_yaml" style="color: inherit; text-decoration: inherit;">product<wbr>Line<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents product line name that uniquely identifies product line</p>
</dd><dt class="property-optional"
            title="Optional">
        <span id="productname_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productname_yaml" style="color: inherit; text-decoration: inherit;">product<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Represents product name that uniquely identifies product</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="imageinformationresponse">Image<wbr>Information<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of the image</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Url of the image</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of the image</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Url of the image</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_java" style="color: inherit; text-decoration: inherit;">image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of the image</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_java" style="color: inherit; text-decoration: inherit;">image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Url of the image</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of the image</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Url of the image</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="image_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_type_python" style="color: inherit; text-decoration: inherit;">image_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Type of the image</p>
</dd><dt class="property-required"
            title="Required">
        <span id="image_url_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_url_python" style="color: inherit; text-decoration: inherit;">image_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Url of the image</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="imagetype_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imagetype_yaml" style="color: inherit; text-decoration: inherit;">image<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of the image</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageurl_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageurl_yaml" style="color: inherit; text-decoration: inherit;">image<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Url of the image</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="linkresponse">Link<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_csharp" style="color: inherit; text-decoration: inherit;">Link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of link</p>
</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_csharp" style="color: inherit; text-decoration: inherit;">Link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Url of the link</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_go" style="color: inherit; text-decoration: inherit;">Link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of link</p>
</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_go" style="color: inherit; text-decoration: inherit;">Link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Url of the link</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_java" style="color: inherit; text-decoration: inherit;">link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of link</p>
</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_java" style="color: inherit; text-decoration: inherit;">link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Url of the link</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_nodejs" style="color: inherit; text-decoration: inherit;">link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Type of link</p>
</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_nodejs" style="color: inherit; text-decoration: inherit;">link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Url of the link</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="link_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#link_type_python" style="color: inherit; text-decoration: inherit;">link_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Type of link</p>
</dd><dt class="property-required"
            title="Required">
        <span id="link_url_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#link_url_python" style="color: inherit; text-decoration: inherit;">link_<wbr>url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Url of the link</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="linktype_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linktype_yaml" style="color: inherit; text-decoration: inherit;">link<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Type of link</p>
</dd><dt class="property-required"
            title="Required">
        <span id="linkurl_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#linkurl_yaml" style="color: inherit; text-decoration: inherit;">link<wbr>Url</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Url of the link</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="pav2meterdetailsresponse">Pav2Meter<wbr>Details<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_csharp" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_csharp" style="color: inherit; text-decoration: inherit;">Meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Validation status of requested data center and transport.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_csharp" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_go" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_go" style="color: inherit; text-decoration: inherit;">Meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Validation status of requested data center and transport.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_go" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_java" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_java" style="color: inherit; text-decoration: inherit;">meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Validation status of requested data center and transport.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_java" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_nodejs" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_nodejs" style="color: inherit; text-decoration: inherit;">meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Validation status of requested data center and transport.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_nodejs" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="charging_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#charging_type_python" style="color: inherit; text-decoration: inherit;">charging_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meter_guid_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meter_guid_python" style="color: inherit; text-decoration: inherit;">meter_<wbr>guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Validation status of requested data center and transport.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_python" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_yaml" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="meterguid_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#meterguid_yaml" style="color: inherit; text-decoration: inherit;">meter<wbr>Guid</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Validation status of requested data center and transport.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_yaml" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="productfamilyresponse">Product<wbr>Family<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productlines_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlines_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">List&lt;Product<wbr>Line<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>List of product lines supported in the product family</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productlines_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlines_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">[]Product<wbr>Line<wbr>Response</a></span>
    </dt>
    <dd><p>List of product lines supported in the product family</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_java" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_java" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_java" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_java" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_java" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Filterable<wbr>Property<wbr>Response></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_java" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_java" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Image<wbr>Information<wbr>Response></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productlines_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlines_java" style="color: inherit; text-decoration: inherit;">product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">List<Product<wbr>Line<wbr>Response></a></span>
    </dt>
    <dd><p>List of product lines supported in the product family</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productlines_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlines_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">Product<wbr>Line<wbr>Response[]</a></span>
    </dt>
    <dd><p>List of product lines supported in the product family</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="product_lines_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_lines_python" style="color: inherit; text-decoration: inherit;">product_<wbr>lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">Sequence[Product<wbr>Line<wbr>Response]</a></span>
    </dt>
    <dd><p>List of product lines supported in the product family</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_yaml" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_yaml" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_yaml" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Property Map</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_yaml" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_yaml" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Property Map></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_yaml" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_yaml" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Property Map></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productlines_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productlines_yaml" style="color: inherit; text-decoration: inherit;">product<wbr>Lines</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productlineresponse">List<Property Map></a></span>
    </dt>
    <dd><p>List of product lines supported in the product family</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="productlineresponse">Product<wbr>Line<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="products_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#products_csharp" style="color: inherit; text-decoration: inherit;">Products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">List&lt;Product<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>List of products in the product line</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="products_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#products_go" style="color: inherit; text-decoration: inherit;">Products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">[]Product<wbr>Response</a></span>
    </dt>
    <dd><p>List of products in the product line</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_java" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_java" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_java" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_java" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_java" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Filterable<wbr>Property<wbr>Response></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_java" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_java" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Image<wbr>Information<wbr>Response></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="products_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#products_java" style="color: inherit; text-decoration: inherit;">products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">List<Product<wbr>Response></a></span>
    </dt>
    <dd><p>List of products in the product line</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="products_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#products_nodejs" style="color: inherit; text-decoration: inherit;">products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">Product<wbr>Response[]</a></span>
    </dt>
    <dd><p>List of products in the product line</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="products_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#products_python" style="color: inherit; text-decoration: inherit;">products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">Sequence[Product<wbr>Response]</a></span>
    </dt>
    <dd><p>List of products in the product line</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_yaml" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_yaml" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_yaml" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Property Map</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_yaml" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_yaml" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Property Map></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_yaml" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_yaml" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Property Map></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="products_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#products_yaml" style="color: inherit; text-decoration: inherit;">products</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#productresponse">List<Property Map></a></span>
    </dt>
    <dd><p>List of products in the product line</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="productresponse">Product<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_csharp" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="configurations_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurations_csharp" style="color: inherit; text-decoration: inherit;">Configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">List&lt;Configuration<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>List of configurations for the product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_csharp" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_csharp" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_csharp" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_csharp" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List&lt;Filterable<wbr>Property<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_csharp" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_csharp" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List&lt;Image<wbr>Information<wbr>Response&gt;</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_go" style="color: inherit; text-decoration: inherit;">Availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="configurations_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurations_go" style="color: inherit; text-decoration: inherit;">Configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">[]Configuration<wbr>Response</a></span>
    </dt>
    <dd><p>List of configurations for the product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_go" style="color: inherit; text-decoration: inherit;">Cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_go" style="color: inherit; text-decoration: inherit;">Description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_go" style="color: inherit; text-decoration: inherit;">Display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_go" style="color: inherit; text-decoration: inherit;">Filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">[]Filterable<wbr>Property<wbr>Response</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_go" style="color: inherit; text-decoration: inherit;">Hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_go" style="color: inherit; text-decoration: inherit;">Image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">[]Image<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_java" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="configurations_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurations_java" style="color: inherit; text-decoration: inherit;">configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">List<Configuration<wbr>Response></a></span>
    </dt>
    <dd><p>List of configurations for the product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_java" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_java" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_java" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_java" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Filterable<wbr>Property<wbr>Response></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_java" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_java" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Image<wbr>Information<wbr>Response></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_nodejs" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="configurations_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurations_nodejs" style="color: inherit; text-decoration: inherit;">configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">Configuration<wbr>Response[]</a></span>
    </dt>
    <dd><p>List of configurations for the product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_nodejs" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_nodejs" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_nodejs" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_nodejs" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Filterable<wbr>Property<wbr>Response[]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_nodejs" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_nodejs" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Image<wbr>Information<wbr>Response[]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availability_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availability_information_python" style="color: inherit; text-decoration: inherit;">availability_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Availability<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="configurations_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurations_python" style="color: inherit; text-decoration: inherit;">configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">Sequence[Configuration<wbr>Response]</a></span>
    </dt>
    <dd><p>List of configurations for the product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="cost_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#cost_information_python" style="color: inherit; text-decoration: inherit;">cost_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Cost<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_python" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Description<wbr>Response</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="display_name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#display_name_python" style="color: inherit; text-decoration: inherit;">display_<wbr>name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterable_properties_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterable_properties_python" style="color: inherit; text-decoration: inherit;">filterable_<wbr>properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">Sequence[Filterable<wbr>Property<wbr>Response]</a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchy_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchy_information_python" style="color: inherit; text-decoration: inherit;">hierarchy_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Hierarchy<wbr>Information<wbr>Response</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="image_information_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#image_information_python" style="color: inherit; text-decoration: inherit;">image_<wbr>information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">Sequence[Image<wbr>Information<wbr>Response]</a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="availabilityinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#availabilityinformation_yaml" style="color: inherit; text-decoration: inherit;">availability<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#availabilityinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Availability information of the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="configurations_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#configurations_yaml" style="color: inherit; text-decoration: inherit;">configurations</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#configurationresponse">List<Property Map></a></span>
    </dt>
    <dd><p>List of configurations for the product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="costinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#costinformation_yaml" style="color: inherit; text-decoration: inherit;">cost<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#costinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Cost information for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="description_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#description_yaml" style="color: inherit; text-decoration: inherit;">description</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#descriptionresponse">Property Map</a></span>
    </dt>
    <dd><p>Description related to the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="displayname_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#displayname_yaml" style="color: inherit; text-decoration: inherit;">display<wbr>Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Display Name for the product system.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="filterableproperties_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#filterableproperties_yaml" style="color: inherit; text-decoration: inherit;">filterable<wbr>Properties</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#filterablepropertyresponse">List<Property Map></a></span>
    </dt>
    <dd><p>list of filters supported for a product</p>
</dd><dt class="property-required"
            title="Required">
        <span id="hierarchyinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#hierarchyinformation_yaml" style="color: inherit; text-decoration: inherit;">hierarchy<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#hierarchyinformationresponse">Property Map</a></span>
    </dt>
    <dd><p>Hierarchy information of a product.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="imageinformation_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#imageinformation_yaml" style="color: inherit; text-decoration: inherit;">image<wbr>Information</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type"><a href="#imageinformationresponse">List<Property Map></a></span>
    </dt>
    <dd><p>Image information for the product system.</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="purchasemeterdetailsresponse">Purchase<wbr>Meter<wbr>Details<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_csharp" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_csharp" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">double</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_csharp" style="color: inherit; text-decoration: inherit;">Product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Product Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="skuid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_csharp" style="color: inherit; text-decoration: inherit;">Sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Sku Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="termid_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_csharp" style="color: inherit; text-decoration: inherit;">Term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Term Id</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_go" style="color: inherit; text-decoration: inherit;">Charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_go" style="color: inherit; text-decoration: inherit;">Multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float64</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_go" style="color: inherit; text-decoration: inherit;">Product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Product Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="skuid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_go" style="color: inherit; text-decoration: inherit;">Sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Sku Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="termid_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_go" style="color: inherit; text-decoration: inherit;">Term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Term Id</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_java" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_java" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Double</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productid_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_java" style="color: inherit; text-decoration: inherit;">product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Product Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="skuid_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_java" style="color: inherit; text-decoration: inherit;">sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Sku Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="termid_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_java" style="color: inherit; text-decoration: inherit;">term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Term Id</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_nodejs" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_nodejs" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">number</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_nodejs" style="color: inherit; text-decoration: inherit;">product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Product Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="skuid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_nodejs" style="color: inherit; text-decoration: inherit;">sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Sku Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="termid_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_nodejs" style="color: inherit; text-decoration: inherit;">term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Term Id</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="charging_type_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#charging_type_python" style="color: inherit; text-decoration: inherit;">charging_<wbr>type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_python" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">float</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd><dt class="property-required"
            title="Required">
        <span id="product_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#product_id_python" style="color: inherit; text-decoration: inherit;">product_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Product Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="sku_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#sku_id_python" style="color: inherit; text-decoration: inherit;">sku_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Sku Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="term_id_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#term_id_python" style="color: inherit; text-decoration: inherit;">term_<wbr>id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Term Id</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="chargingtype_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#chargingtype_yaml" style="color: inherit; text-decoration: inherit;">charging<wbr>Type</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Charging type.</p>
</dd><dt class="property-required"
            title="Required">
        <span id="multiplier_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#multiplier_yaml" style="color: inherit; text-decoration: inherit;">multiplier</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">Number</span>
    </dt>
    <dd><p>Billing unit applicable for Pav2 billing</p>
</dd><dt class="property-required"
            title="Required">
        <span id="productid_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#productid_yaml" style="color: inherit; text-decoration: inherit;">product<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Product Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="skuid_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#skuid_yaml" style="color: inherit; text-decoration: inherit;">sku<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Sku Id</p>
</dd><dt class="property-required"
            title="Required">
        <span id="termid_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#termid_yaml" style="color: inherit; text-decoration: inherit;">term<wbr>Id</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Term Id</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="specificationresponse">Specification<wbr>Response</h4>



<div>
<pulumi-choosable type="language" values="csharp">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_csharp" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Name of the specification</p>
</dd><dt class="property-required"
            title="Required">
        <span id="value_csharp">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_csharp" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Value of the specification</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="go">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_go" style="color: inherit; text-decoration: inherit;">Name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Name of the specification</p>
</dd><dt class="property-required"
            title="Required">
        <span id="value_go">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_go" style="color: inherit; text-decoration: inherit;">Value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Value of the specification</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="java">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_java" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Name of the specification</p>
</dd><dt class="property-required"
            title="Required">
        <span id="value_java">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_java" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Value of the specification</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="javascript,typescript">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_nodejs" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Name of the specification</p>
</dd><dt class="property-required"
            title="Required">
        <span id="value_nodejs">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_nodejs" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">string</span>
    </dt>
    <dd><p>Value of the specification</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="python">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_python" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Name of the specification</p>
</dd><dt class="property-required"
            title="Required">
        <span id="value_python">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_python" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">str</span>
    </dt>
    <dd><p>Value of the specification</p>
</dd></dl>
</pulumi-choosable>
</div>

<div>
<pulumi-choosable type="language" values="yaml">
<dl class="resources-properties"><dt class="property-required"
            title="Required">
        <span id="name_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#name_yaml" style="color: inherit; text-decoration: inherit;">name</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Name of the specification</p>
</dd><dt class="property-required"
            title="Required">
        <span id="value_yaml">
<a data-swiftype-name="resource-property" data-swiftype-type="text" href="#value_yaml" style="color: inherit; text-decoration: inherit;">value</a>
</span>
        <span class="property-indicator"></span>
        <span class="property-type">String</span>
    </dt>
    <dd><p>Value of the specification</p>
</dd></dl>
</pulumi-choosable>
</div>

<h4 id="supportedfiltertypes">Supported<wbr>Filter<wbr>Types</h4>







<h2 id="package-details">Package Details</h2>
<dl class="package-details">
	<dt>Repository</dt>
	<dd><a href=""></a></dd>
	<dt>License</dt>
	<dd></dd>
</dl>

