// Copyright 2016-2020, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package main

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestValidatePolicyPackConfig(t *testing.T) {
	t.Parallel()

	var tests = []struct {
		PolicyPackPaths       []string
		PolicyPackConfigPaths []string
		ExpectError           bool
	}{
		{
			PolicyPackPaths:       nil,
			PolicyPackConfigPaths: nil,
			ExpectError:           false,
		},
		{
			PolicyPackPaths:       []string{},
			PolicyPackConfigPaths: []string{},
			ExpectError:           false,
		},
		{
			PolicyPackPaths:       []string{"foo"},
			PolicyPackConfigPaths: []string{},
			ExpectError:           false,
		},
		{
			PolicyPackPaths:       []string{"foo", "bar"},
			PolicyPackConfigPaths: []string{},
			ExpectError:           false,
		},
		{
			PolicyPackPaths:       []string{"foo"},
			PolicyPackConfigPaths: []string{"foo"},
			ExpectError:           false,
		},
		{
			PolicyPackPaths:       []string{"foo", "bar"},
			PolicyPackConfigPaths: []string{"foo", "bar"},
			ExpectError:           false,
		},
		{
			PolicyPackPaths:       []string{"foo", "bar"},
			PolicyPackConfigPaths: []string{"foo"},
			ExpectError:           true,
		},
		{
			PolicyPackPaths:       []string{},
			PolicyPackConfigPaths: []string{"foo"},
			ExpectError:           true,
		},
		{
			PolicyPackPaths:       []string{"foo"},
			PolicyPackConfigPaths: []string{"foo", "bar"},
			ExpectError:           true,
		},
	}

	//nolint:paralleltest // false positive because range var isn't used directly in t.Run(name) arg
	for _, test := range tests {
		test := test
		t.Run(fmt.Sprintf("%v", test), func(t *testing.T) {
			err := validatePolicyPackConfig(test.PolicyPackPaths, test.PolicyPackConfigPaths)
			if test.ExpectError {
				assert.Error(t, err)
			} else {
				assert.NoError(t, err)
			}
		})
	}
}
