package main

// Code generated by ./peg -inline -switch peg.peg DO NOT EDIT.

import (
	"fmt"
	"github.com/pointlander/peg/tree"
	"io"
	"os"
	"sort"
	"strconv"
	"strings"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	ruleGrammar
	ruleImport
	ruleSingleImport
	ruleMultiImport
	ruleImportName
	ruleDefinition
	ruleExpression
	ruleSequence
	rulePrefix
	ruleSuffix
	rulePrimary
	ruleIdentifier
	ruleIdentStart
	ruleIdentCont
	ruleLiteral
	ruleClass
	ruleRanges
	ruleDoubleRanges
	ruleRange
	ruleDoubleRange
	ruleChar
	ruleDoubleChar
	ruleEscape
	ruleLeftArrow
	ruleSlash
	ruleAnd
	ruleNot
	ruleQuestion
	ruleStar
	rulePlus
	ruleOpen
	ruleClose
	ruleDot
	ruleSpaceComment
	ruleSpacing
	ruleMustSpacing
	ruleComment
	ruleSpace
	ruleEndOfLine
	ruleEndOfFile
	ruleAction
	ruleActionBody
	ruleBegin
	ruleEnd
	ruleAction0
	ruleAction1
	ruleAction2
	rulePegText
	ruleAction3
	ruleAction4
	ruleAction5
	ruleAction6
	ruleAction7
	ruleAction8
	ruleAction9
	ruleAction10
	ruleAction11
	ruleAction12
	ruleAction13
	ruleAction14
	ruleAction15
	ruleAction16
	ruleAction17
	ruleAction18
	ruleAction19
	ruleAction20
	ruleAction21
	ruleAction22
	ruleAction23
	ruleAction24
	ruleAction25
	ruleAction26
	ruleAction27
	ruleAction28
	ruleAction29
	ruleAction30
	ruleAction31
	ruleAction32
	ruleAction33
	ruleAction34
	ruleAction35
	ruleAction36
	ruleAction37
	ruleAction38
	ruleAction39
	ruleAction40
	ruleAction41
	ruleAction42
	ruleAction43
	ruleAction44
	ruleAction45
	ruleAction46
	ruleAction47
	ruleAction48
)

var rul3s = [...]string{
	"Unknown",
	"Grammar",
	"Import",
	"SingleImport",
	"MultiImport",
	"ImportName",
	"Definition",
	"Expression",
	"Sequence",
	"Prefix",
	"Suffix",
	"Primary",
	"Identifier",
	"IdentStart",
	"IdentCont",
	"Literal",
	"Class",
	"Ranges",
	"DoubleRanges",
	"Range",
	"DoubleRange",
	"Char",
	"DoubleChar",
	"Escape",
	"LeftArrow",
	"Slash",
	"And",
	"Not",
	"Question",
	"Star",
	"Plus",
	"Open",
	"Close",
	"Dot",
	"SpaceComment",
	"Spacing",
	"MustSpacing",
	"Comment",
	"Space",
	"EndOfLine",
	"EndOfFile",
	"Action",
	"ActionBody",
	"Begin",
	"End",
	"Action0",
	"Action1",
	"Action2",
	"PegText",
	"Action3",
	"Action4",
	"Action5",
	"Action6",
	"Action7",
	"Action8",
	"Action9",
	"Action10",
	"Action11",
	"Action12",
	"Action13",
	"Action14",
	"Action15",
	"Action16",
	"Action17",
	"Action18",
	"Action19",
	"Action20",
	"Action21",
	"Action22",
	"Action23",
	"Action24",
	"Action25",
	"Action26",
	"Action27",
	"Action28",
	"Action29",
	"Action30",
	"Action31",
	"Action32",
	"Action33",
	"Action34",
	"Action35",
	"Action36",
	"Action37",
	"Action38",
	"Action39",
	"Action40",
	"Action41",
	"Action42",
	"Action43",
	"Action44",
	"Action45",
	"Action46",
	"Action47",
	"Action48",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type Peg struct {
	*tree.Tree

	Buffer string
	buffer []rune
	rules  [95]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *Peg) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *Peg) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *Peg
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *Peg) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *Peg) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *Peg) SprintSyntaxTree() string {
	var bldr strings.Builder
	p.WriteSyntaxTree(&bldr)
	return bldr.String()
}

func (p *Peg) Execute() {
	buffer, _buffer, text, begin, end := p.Buffer, p.buffer, "", 0, 0
	for _, token := range p.Tokens() {
		switch token.pegRule {

		case rulePegText:
			begin, end = int(token.begin), int(token.end)
			text = string(_buffer[begin:end])

		case ruleAction0:
			p.AddPackage(text)
		case ruleAction1:
			p.AddPeg(text)
		case ruleAction2:
			p.AddState(text)
		case ruleAction3:
			p.AddImport(text)
		case ruleAction4:
			p.AddRule(text)
		case ruleAction5:
			p.AddExpression()
		case ruleAction6:
			p.AddAlternate()
		case ruleAction7:
			p.AddNil()
			p.AddAlternate()
		case ruleAction8:
			p.AddNil()
		case ruleAction9:
			p.AddSequence()
		case ruleAction10:
			p.AddPredicate(text)
		case ruleAction11:
			p.AddStateChange(text)
		case ruleAction12:
			p.AddPeekFor()
		case ruleAction13:
			p.AddPeekNot()
		case ruleAction14:
			p.AddQuery()
		case ruleAction15:
			p.AddStar()
		case ruleAction16:
			p.AddPlus()
		case ruleAction17:
			p.AddName(text)
		case ruleAction18:
			p.AddDot()
		case ruleAction19:
			p.AddAction(text)
		case ruleAction20:
			p.AddPush()
		case ruleAction21:
			p.AddSequence()
		case ruleAction22:
			p.AddSequence()
		case ruleAction23:
			p.AddPeekNot()
			p.AddDot()
			p.AddSequence()
		case ruleAction24:
			p.AddPeekNot()
			p.AddDot()
			p.AddSequence()
		case ruleAction25:
			p.AddAlternate()
		case ruleAction26:
			p.AddAlternate()
		case ruleAction27:
			p.AddRange()
		case ruleAction28:
			p.AddDoubleRange()
		case ruleAction29:
			p.AddCharacter(text)
		case ruleAction30:
			p.AddDoubleCharacter(text)
		case ruleAction31:
			p.AddCharacter(text)
		case ruleAction32:
			p.AddCharacter("\a")
		case ruleAction33:
			p.AddCharacter("\b")
		case ruleAction34:
			p.AddCharacter("\x1B")
		case ruleAction35:
			p.AddCharacter("\f")
		case ruleAction36:
			p.AddCharacter("\n")
		case ruleAction37:
			p.AddCharacter("\r")
		case ruleAction38:
			p.AddCharacter("\t")
		case ruleAction39:
			p.AddCharacter("\v")
		case ruleAction40:
			p.AddCharacter("'")
		case ruleAction41:
			p.AddCharacter("\"")
		case ruleAction42:
			p.AddCharacter("[")
		case ruleAction43:
			p.AddCharacter("]")
		case ruleAction44:
			p.AddCharacter("-")
		case ruleAction45:
			p.AddHexaCharacter(text)
		case ruleAction46:
			p.AddOctalCharacter(text)
		case ruleAction47:
			p.AddOctalCharacter(text)
		case ruleAction48:
			p.AddCharacter("\\")

		}
	}
	_, _, _, _, _ = buffer, _buffer, text, begin, end
}

func Pretty(pretty bool) func(*Peg) error {
	return func(p *Peg) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*Peg) error {
	return func(p *Peg) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *Peg) Init(options ...func(*Peg) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 Grammar <- <(Spacing ('p' 'a' 'c' 'k' 'a' 'g' 'e') MustSpacing Identifier Action0 Import* ('t' 'y' 'p' 'e') MustSpacing Identifier Action1 ('P' 'e' 'g') Spacing Action Action2 Definition+ EndOfFile)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
				if !_rules[ruleSpacing]() {
					goto l0
				}
				if buffer[position] != rune('p') {
					goto l0
				}
				position++
				if buffer[position] != rune('a') {
					goto l0
				}
				position++
				if buffer[position] != rune('c') {
					goto l0
				}
				position++
				if buffer[position] != rune('k') {
					goto l0
				}
				position++
				if buffer[position] != rune('a') {
					goto l0
				}
				position++
				if buffer[position] != rune('g') {
					goto l0
				}
				position++
				if buffer[position] != rune('e') {
					goto l0
				}
				position++
				if !_rules[ruleMustSpacing]() {
					goto l0
				}
				if !_rules[ruleIdentifier]() {
					goto l0
				}
				{
					add(ruleAction0, position)
				}
			l3:
				{
					position4, tokenIndex4 := position, tokenIndex
					{
						position5 := position
						if buffer[position] != rune('i') {
							goto l4
						}
						position++
						if buffer[position] != rune('m') {
							goto l4
						}
						position++
						if buffer[position] != rune('p') {
							goto l4
						}
						position++
						if buffer[position] != rune('o') {
							goto l4
						}
						position++
						if buffer[position] != rune('r') {
							goto l4
						}
						position++
						if buffer[position] != rune('t') {
							goto l4
						}
						position++
						if !_rules[ruleSpacing]() {
							goto l4
						}
						{
							position6, tokenIndex6 := position, tokenIndex
							{
								position8 := position
								if buffer[position] != rune('(') {
									goto l7
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l7
								}
							l9:
								{
									position10, tokenIndex10 := position, tokenIndex
									if !_rules[ruleImportName]() {
										goto l10
									}
									if buffer[position] != rune('\n') {
										goto l10
									}
									position++
									if !_rules[ruleSpacing]() {
										goto l10
									}
									goto l9
								l10:
									position, tokenIndex = position10, tokenIndex10
								}
								if !_rules[ruleSpacing]() {
									goto l7
								}
								if buffer[position] != rune(')') {
									goto l7
								}
								position++
								add(ruleMultiImport, position8)
							}
							goto l6
						l7:
							position, tokenIndex = position6, tokenIndex6
							{
								position11 := position
								if !_rules[ruleImportName]() {
									goto l4
								}
								add(ruleSingleImport, position11)
							}
						}
					l6:
						if !_rules[ruleSpacing]() {
							goto l4
						}
						add(ruleImport, position5)
					}
					goto l3
				l4:
					position, tokenIndex = position4, tokenIndex4
				}
				if buffer[position] != rune('t') {
					goto l0
				}
				position++
				if buffer[position] != rune('y') {
					goto l0
				}
				position++
				if buffer[position] != rune('p') {
					goto l0
				}
				position++
				if buffer[position] != rune('e') {
					goto l0
				}
				position++
				if !_rules[ruleMustSpacing]() {
					goto l0
				}
				if !_rules[ruleIdentifier]() {
					goto l0
				}
				{
					add(ruleAction1, position)
				}
				if buffer[position] != rune('P') {
					goto l0
				}
				position++
				if buffer[position] != rune('e') {
					goto l0
				}
				position++
				if buffer[position] != rune('g') {
					goto l0
				}
				position++
				if !_rules[ruleSpacing]() {
					goto l0
				}
				if !_rules[ruleAction]() {
					goto l0
				}
				{
					add(ruleAction2, position)
				}
				{
					position16 := position
					if !_rules[ruleIdentifier]() {
						goto l0
					}
					{
						add(ruleAction4, position)
					}
					if !_rules[ruleLeftArrow]() {
						goto l0
					}
					if !_rules[ruleExpression]() {
						goto l0
					}
					{
						add(ruleAction5, position)
					}
					{
						position19, tokenIndex19 := position, tokenIndex
						{
							position20, tokenIndex20 := position, tokenIndex
							if !_rules[ruleIdentifier]() {
								goto l21
							}
							if !_rules[ruleLeftArrow]() {
								goto l21
							}
							goto l20
						l21:
							position, tokenIndex = position20, tokenIndex20
							{
								position22, tokenIndex22 := position, tokenIndex
								if !matchDot() {
									goto l22
								}
								goto l0
							l22:
								position, tokenIndex = position22, tokenIndex22
							}
						}
					l20:
						position, tokenIndex = position19, tokenIndex19
					}
					add(ruleDefinition, position16)
				}
			l14:
				{
					position15, tokenIndex15 := position, tokenIndex
					{
						position23 := position
						if !_rules[ruleIdentifier]() {
							goto l15
						}
						{
							add(ruleAction4, position)
						}
						if !_rules[ruleLeftArrow]() {
							goto l15
						}
						if !_rules[ruleExpression]() {
							goto l15
						}
						{
							add(ruleAction5, position)
						}
						{
							position26, tokenIndex26 := position, tokenIndex
							{
								position27, tokenIndex27 := position, tokenIndex
								if !_rules[ruleIdentifier]() {
									goto l28
								}
								if !_rules[ruleLeftArrow]() {
									goto l28
								}
								goto l27
							l28:
								position, tokenIndex = position27, tokenIndex27
								{
									position29, tokenIndex29 := position, tokenIndex
									if !matchDot() {
										goto l29
									}
									goto l15
								l29:
									position, tokenIndex = position29, tokenIndex29
								}
							}
						l27:
							position, tokenIndex = position26, tokenIndex26
						}
						add(ruleDefinition, position23)
					}
					goto l14
				l15:
					position, tokenIndex = position15, tokenIndex15
				}
				{
					position30 := position
					{
						position31, tokenIndex31 := position, tokenIndex
						if !matchDot() {
							goto l31
						}
						goto l0
					l31:
						position, tokenIndex = position31, tokenIndex31
					}
					add(ruleEndOfFile, position30)
				}
				add(ruleGrammar, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 Import <- <('i' 'm' 'p' 'o' 'r' 't' Spacing (MultiImport / SingleImport) Spacing)> */
		nil,
		/* 2 SingleImport <- <ImportName> */
		nil,
		/* 3 MultiImport <- <('(' Spacing (ImportName '\n' Spacing)* Spacing ')')> */
		nil,
		/* 4 ImportName <- <('"' <((&('-') '-') | (&('.') '.') | (&('/') '/') | (&('_') '_') | (&('A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' | 'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' | 'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z') [A-Z]) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') [0-9]) | (&('a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z') [a-z]))+> '"' Action3)> */
		func() bool {
			position35, tokenIndex35 := position, tokenIndex
			{
				position36 := position
				if buffer[position] != rune('"') {
					goto l35
				}
				position++
				{
					position37 := position
					{
						switch buffer[position] {
						case '-':
							if buffer[position] != rune('-') {
								goto l35
							}
							position++
						case '.':
							if buffer[position] != rune('.') {
								goto l35
							}
							position++
						case '/':
							if buffer[position] != rune('/') {
								goto l35
							}
							position++
						case '_':
							if buffer[position] != rune('_') {
								goto l35
							}
							position++
						case 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z':
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l35
							}
							position++
						case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9':
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l35
							}
							position++
						default:
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l35
							}
							position++
						}
					}

				l38:
					{
						position39, tokenIndex39 := position, tokenIndex
						{
							switch buffer[position] {
							case '-':
								if buffer[position] != rune('-') {
									goto l39
								}
								position++
							case '.':
								if buffer[position] != rune('.') {
									goto l39
								}
								position++
							case '/':
								if buffer[position] != rune('/') {
									goto l39
								}
								position++
							case '_':
								if buffer[position] != rune('_') {
									goto l39
								}
								position++
							case 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z':
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l39
								}
								position++
							case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9':
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l39
								}
								position++
							default:
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l39
								}
								position++
							}
						}

						goto l38
					l39:
						position, tokenIndex = position39, tokenIndex39
					}
					add(rulePegText, position37)
				}
				if buffer[position] != rune('"') {
					goto l35
				}
				position++
				{
					add(ruleAction3, position)
				}
				add(ruleImportName, position36)
			}
			return true
		l35:
			position, tokenIndex = position35, tokenIndex35
			return false
		},
		/* 5 Definition <- <(Identifier Action4 LeftArrow Expression Action5 &((Identifier LeftArrow) / !.))> */
		nil,
		/* 6 Expression <- <((Sequence (Slash Sequence Action6)* (Slash Action7)?) / Action8)> */
		func() bool {
			{
				position45 := position
				{
					position46, tokenIndex46 := position, tokenIndex
					if !_rules[ruleSequence]() {
						goto l47
					}
				l48:
					{
						position49, tokenIndex49 := position, tokenIndex
						if !_rules[ruleSlash]() {
							goto l49
						}
						if !_rules[ruleSequence]() {
							goto l49
						}
						{
							add(ruleAction6, position)
						}
						goto l48
					l49:
						position, tokenIndex = position49, tokenIndex49
					}
					{
						position51, tokenIndex51 := position, tokenIndex
						if !_rules[ruleSlash]() {
							goto l51
						}
						{
							add(ruleAction7, position)
						}
						goto l52
					l51:
						position, tokenIndex = position51, tokenIndex51
					}
				l52:
					goto l46
				l47:
					position, tokenIndex = position46, tokenIndex46
					{
						add(ruleAction8, position)
					}
				}
			l46:
				add(ruleExpression, position45)
			}
			return true
		},
		/* 7 Sequence <- <(Prefix (Prefix Action9)*)> */
		func() bool {
			position55, tokenIndex55 := position, tokenIndex
			{
				position56 := position
				if !_rules[rulePrefix]() {
					goto l55
				}
			l57:
				{
					position58, tokenIndex58 := position, tokenIndex
					if !_rules[rulePrefix]() {
						goto l58
					}
					{
						add(ruleAction9, position)
					}
					goto l57
				l58:
					position, tokenIndex = position58, tokenIndex58
				}
				add(ruleSequence, position56)
			}
			return true
		l55:
			position, tokenIndex = position55, tokenIndex55
			return false
		},
		/* 8 Prefix <- <((And Action Action10) / (Not Action Action11) / ((&('!') (Not Suffix Action13)) | (&('&') (And Suffix Action12)) | (&('"' | '\'' | '(' | '.' | '<' | 'A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' | 'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' | 'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z' | '[' | '_' | 'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z' | '{') Suffix)))> */
		func() bool {
			position60, tokenIndex60 := position, tokenIndex
			{
				position61 := position
				{
					position62, tokenIndex62 := position, tokenIndex
					if !_rules[ruleAnd]() {
						goto l63
					}
					if !_rules[ruleAction]() {
						goto l63
					}
					{
						add(ruleAction10, position)
					}
					goto l62
				l63:
					position, tokenIndex = position62, tokenIndex62
					if !_rules[ruleNot]() {
						goto l65
					}
					if !_rules[ruleAction]() {
						goto l65
					}
					{
						add(ruleAction11, position)
					}
					goto l62
				l65:
					position, tokenIndex = position62, tokenIndex62
					{
						switch buffer[position] {
						case '!':
							if !_rules[ruleNot]() {
								goto l60
							}
							if !_rules[ruleSuffix]() {
								goto l60
							}
							{
								add(ruleAction13, position)
							}
						case '&':
							if !_rules[ruleAnd]() {
								goto l60
							}
							if !_rules[ruleSuffix]() {
								goto l60
							}
							{
								add(ruleAction12, position)
							}
						default:
							if !_rules[ruleSuffix]() {
								goto l60
							}
						}
					}

				}
			l62:
				add(rulePrefix, position61)
			}
			return true
		l60:
			position, tokenIndex = position60, tokenIndex60
			return false
		},
		/* 9 Suffix <- <(Primary ((&('+') (Plus Action16)) | (&('*') (Star Action15)) | (&('?') (Question Action14)))?)> */
		func() bool {
			position70, tokenIndex70 := position, tokenIndex
			{
				position71 := position
				{
					position72 := position
					{
						switch buffer[position] {
						case '<':
							{
								position74 := position
								if buffer[position] != rune('<') {
									goto l70
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l70
								}
								add(ruleBegin, position74)
							}
							if !_rules[ruleExpression]() {
								goto l70
							}
							{
								position75 := position
								if buffer[position] != rune('>') {
									goto l70
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l70
								}
								add(ruleEnd, position75)
							}
							{
								add(ruleAction20, position)
							}
						case '{':
							if !_rules[ruleAction]() {
								goto l70
							}
							{
								add(ruleAction19, position)
							}
						case '.':
							{
								position78 := position
								if buffer[position] != rune('.') {
									goto l70
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l70
								}
								add(ruleDot, position78)
							}
							{
								add(ruleAction18, position)
							}
						case '[':
							{
								position80 := position
								{
									position81, tokenIndex81 := position, tokenIndex
									if buffer[position] != rune('[') {
										goto l82
									}
									position++
									if buffer[position] != rune('[') {
										goto l82
									}
									position++
									{
										position83, tokenIndex83 := position, tokenIndex
										{
											position85, tokenIndex85 := position, tokenIndex
											if buffer[position] != rune('^') {
												goto l86
											}
											position++
											if !_rules[ruleDoubleRanges]() {
												goto l86
											}
											{
												add(ruleAction23, position)
											}
											goto l85
										l86:
											position, tokenIndex = position85, tokenIndex85
											if !_rules[ruleDoubleRanges]() {
												goto l83
											}
										}
									l85:
										goto l84
									l83:
										position, tokenIndex = position83, tokenIndex83
									}
								l84:
									if buffer[position] != rune(']') {
										goto l82
									}
									position++
									if buffer[position] != rune(']') {
										goto l82
									}
									position++
									goto l81
								l82:
									position, tokenIndex = position81, tokenIndex81
									if buffer[position] != rune('[') {
										goto l70
									}
									position++
									{
										position88, tokenIndex88 := position, tokenIndex
										{
											position90, tokenIndex90 := position, tokenIndex
											if buffer[position] != rune('^') {
												goto l91
											}
											position++
											if !_rules[ruleRanges]() {
												goto l91
											}
											{
												add(ruleAction24, position)
											}
											goto l90
										l91:
											position, tokenIndex = position90, tokenIndex90
											if !_rules[ruleRanges]() {
												goto l88
											}
										}
									l90:
										goto l89
									l88:
										position, tokenIndex = position88, tokenIndex88
									}
								l89:
									if buffer[position] != rune(']') {
										goto l70
									}
									position++
								}
							l81:
								if !_rules[ruleSpacing]() {
									goto l70
								}
								add(ruleClass, position80)
							}
						case '"', '\'':
							{
								position93 := position
								{
									position94, tokenIndex94 := position, tokenIndex
									if buffer[position] != rune('\'') {
										goto l95
									}
									position++
									{
										position96, tokenIndex96 := position, tokenIndex
										{
											position98, tokenIndex98 := position, tokenIndex
											if buffer[position] != rune('\'') {
												goto l98
											}
											position++
											goto l96
										l98:
											position, tokenIndex = position98, tokenIndex98
										}
										if !_rules[ruleChar]() {
											goto l96
										}
										goto l97
									l96:
										position, tokenIndex = position96, tokenIndex96
									}
								l97:
								l99:
									{
										position100, tokenIndex100 := position, tokenIndex
										{
											position101, tokenIndex101 := position, tokenIndex
											if buffer[position] != rune('\'') {
												goto l101
											}
											position++
											goto l100
										l101:
											position, tokenIndex = position101, tokenIndex101
										}
										if !_rules[ruleChar]() {
											goto l100
										}
										{
											add(ruleAction21, position)
										}
										goto l99
									l100:
										position, tokenIndex = position100, tokenIndex100
									}
									if buffer[position] != rune('\'') {
										goto l95
									}
									position++
									if !_rules[ruleSpacing]() {
										goto l95
									}
									goto l94
								l95:
									position, tokenIndex = position94, tokenIndex94
									if buffer[position] != rune('"') {
										goto l70
									}
									position++
									{
										position103, tokenIndex103 := position, tokenIndex
										{
											position105, tokenIndex105 := position, tokenIndex
											if buffer[position] != rune('"') {
												goto l105
											}
											position++
											goto l103
										l105:
											position, tokenIndex = position105, tokenIndex105
										}
										if !_rules[ruleDoubleChar]() {
											goto l103
										}
										goto l104
									l103:
										position, tokenIndex = position103, tokenIndex103
									}
								l104:
								l106:
									{
										position107, tokenIndex107 := position, tokenIndex
										{
											position108, tokenIndex108 := position, tokenIndex
											if buffer[position] != rune('"') {
												goto l108
											}
											position++
											goto l107
										l108:
											position, tokenIndex = position108, tokenIndex108
										}
										if !_rules[ruleDoubleChar]() {
											goto l107
										}
										{
											add(ruleAction22, position)
										}
										goto l106
									l107:
										position, tokenIndex = position107, tokenIndex107
									}
									if buffer[position] != rune('"') {
										goto l70
									}
									position++
									if !_rules[ruleSpacing]() {
										goto l70
									}
								}
							l94:
								add(ruleLiteral, position93)
							}
						case '(':
							{
								position110 := position
								if buffer[position] != rune('(') {
									goto l70
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l70
								}
								add(ruleOpen, position110)
							}
							if !_rules[ruleExpression]() {
								goto l70
							}
							{
								position111 := position
								if buffer[position] != rune(')') {
									goto l70
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l70
								}
								add(ruleClose, position111)
							}
						default:
							if !_rules[ruleIdentifier]() {
								goto l70
							}
							{
								position112, tokenIndex112 := position, tokenIndex
								if !_rules[ruleLeftArrow]() {
									goto l112
								}
								goto l70
							l112:
								position, tokenIndex = position112, tokenIndex112
							}
							{
								add(ruleAction17, position)
							}
						}
					}

					add(rulePrimary, position72)
				}
				{
					position114, tokenIndex114 := position, tokenIndex
					{
						switch buffer[position] {
						case '+':
							{
								position117 := position
								if buffer[position] != rune('+') {
									goto l114
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l114
								}
								add(rulePlus, position117)
							}
							{
								add(ruleAction16, position)
							}
						case '*':
							{
								position119 := position
								if buffer[position] != rune('*') {
									goto l114
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l114
								}
								add(ruleStar, position119)
							}
							{
								add(ruleAction15, position)
							}
						default:
							{
								position121 := position
								if buffer[position] != rune('?') {
									goto l114
								}
								position++
								if !_rules[ruleSpacing]() {
									goto l114
								}
								add(ruleQuestion, position121)
							}
							{
								add(ruleAction14, position)
							}
						}
					}

					goto l115
				l114:
					position, tokenIndex = position114, tokenIndex114
				}
			l115:
				add(ruleSuffix, position71)
			}
			return true
		l70:
			position, tokenIndex = position70, tokenIndex70
			return false
		},
		/* 10 Primary <- <((&('<') (Begin Expression End Action20)) | (&('{') (Action Action19)) | (&('.') (Dot Action18)) | (&('[') Class) | (&('"' | '\'') Literal) | (&('(') (Open Expression Close)) | (&('A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' | 'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' | 'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z' | '_' | 'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z') (Identifier !LeftArrow Action17)))> */
		nil,
		/* 11 Identifier <- <(<(IdentStart IdentCont*)> Spacing)> */
		func() bool {
			position124, tokenIndex124 := position, tokenIndex
			{
				position125 := position
				{
					position126 := position
					if !_rules[ruleIdentStart]() {
						goto l124
					}
				l127:
					{
						position128, tokenIndex128 := position, tokenIndex
						{
							position129 := position
							{
								position130, tokenIndex130 := position, tokenIndex
								if !_rules[ruleIdentStart]() {
									goto l131
								}
								goto l130
							l131:
								position, tokenIndex = position130, tokenIndex130
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l128
								}
								position++
							}
						l130:
							add(ruleIdentCont, position129)
						}
						goto l127
					l128:
						position, tokenIndex = position128, tokenIndex128
					}
					add(rulePegText, position126)
				}
				if !_rules[ruleSpacing]() {
					goto l124
				}
				add(ruleIdentifier, position125)
			}
			return true
		l124:
			position, tokenIndex = position124, tokenIndex124
			return false
		},
		/* 12 IdentStart <- <((&('_') '_') | (&('A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' | 'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' | 'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z') [A-Z]) | (&('a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z') [a-z]))> */
		func() bool {
			position132, tokenIndex132 := position, tokenIndex
			{
				position133 := position
				{
					switch buffer[position] {
					case '_':
						if buffer[position] != rune('_') {
							goto l132
						}
						position++
					case 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z':
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l132
						}
						position++
					default:
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l132
						}
						position++
					}
				}

				add(ruleIdentStart, position133)
			}
			return true
		l132:
			position, tokenIndex = position132, tokenIndex132
			return false
		},
		/* 13 IdentCont <- <(IdentStart / [0-9])> */
		nil,
		/* 14 Literal <- <(('\'' (!'\'' Char)? (!'\'' Char Action21)* '\'' Spacing) / ('"' (!'"' DoubleChar)? (!'"' DoubleChar Action22)* '"' Spacing))> */
		nil,
		/* 15 Class <- <((('[' '[' (('^' DoubleRanges Action23) / DoubleRanges)? (']' ']')) / ('[' (('^' Ranges Action24) / Ranges)? ']')) Spacing)> */
		nil,
		/* 16 Ranges <- <(!']' Range (!']' Range Action25)*)> */
		func() bool {
			position138, tokenIndex138 := position, tokenIndex
			{
				position139 := position
				{
					position140, tokenIndex140 := position, tokenIndex
					if buffer[position] != rune(']') {
						goto l140
					}
					position++
					goto l138
				l140:
					position, tokenIndex = position140, tokenIndex140
				}
				if !_rules[ruleRange]() {
					goto l138
				}
			l141:
				{
					position142, tokenIndex142 := position, tokenIndex
					{
						position143, tokenIndex143 := position, tokenIndex
						if buffer[position] != rune(']') {
							goto l143
						}
						position++
						goto l142
					l143:
						position, tokenIndex = position143, tokenIndex143
					}
					if !_rules[ruleRange]() {
						goto l142
					}
					{
						add(ruleAction25, position)
					}
					goto l141
				l142:
					position, tokenIndex = position142, tokenIndex142
				}
				add(ruleRanges, position139)
			}
			return true
		l138:
			position, tokenIndex = position138, tokenIndex138
			return false
		},
		/* 17 DoubleRanges <- <(!(']' ']') DoubleRange (!(']' ']') DoubleRange Action26)*)> */
		func() bool {
			position145, tokenIndex145 := position, tokenIndex
			{
				position146 := position
				{
					position147, tokenIndex147 := position, tokenIndex
					if buffer[position] != rune(']') {
						goto l147
					}
					position++
					if buffer[position] != rune(']') {
						goto l147
					}
					position++
					goto l145
				l147:
					position, tokenIndex = position147, tokenIndex147
				}
				if !_rules[ruleDoubleRange]() {
					goto l145
				}
			l148:
				{
					position149, tokenIndex149 := position, tokenIndex
					{
						position150, tokenIndex150 := position, tokenIndex
						if buffer[position] != rune(']') {
							goto l150
						}
						position++
						if buffer[position] != rune(']') {
							goto l150
						}
						position++
						goto l149
					l150:
						position, tokenIndex = position150, tokenIndex150
					}
					if !_rules[ruleDoubleRange]() {
						goto l149
					}
					{
						add(ruleAction26, position)
					}
					goto l148
				l149:
					position, tokenIndex = position149, tokenIndex149
				}
				add(ruleDoubleRanges, position146)
			}
			return true
		l145:
			position, tokenIndex = position145, tokenIndex145
			return false
		},
		/* 18 Range <- <((Char '-' Char Action27) / Char)> */
		func() bool {
			position152, tokenIndex152 := position, tokenIndex
			{
				position153 := position
				{
					position154, tokenIndex154 := position, tokenIndex
					if !_rules[ruleChar]() {
						goto l155
					}
					if buffer[position] != rune('-') {
						goto l155
					}
					position++
					if !_rules[ruleChar]() {
						goto l155
					}
					{
						add(ruleAction27, position)
					}
					goto l154
				l155:
					position, tokenIndex = position154, tokenIndex154
					if !_rules[ruleChar]() {
						goto l152
					}
				}
			l154:
				add(ruleRange, position153)
			}
			return true
		l152:
			position, tokenIndex = position152, tokenIndex152
			return false
		},
		/* 19 DoubleRange <- <((Char '-' Char Action28) / DoubleChar)> */
		func() bool {
			position157, tokenIndex157 := position, tokenIndex
			{
				position158 := position
				{
					position159, tokenIndex159 := position, tokenIndex
					if !_rules[ruleChar]() {
						goto l160
					}
					if buffer[position] != rune('-') {
						goto l160
					}
					position++
					if !_rules[ruleChar]() {
						goto l160
					}
					{
						add(ruleAction28, position)
					}
					goto l159
				l160:
					position, tokenIndex = position159, tokenIndex159
					if !_rules[ruleDoubleChar]() {
						goto l157
					}
				}
			l159:
				add(ruleDoubleRange, position158)
			}
			return true
		l157:
			position, tokenIndex = position157, tokenIndex157
			return false
		},
		/* 20 Char <- <(Escape / (!'\\' <.> Action29))> */
		func() bool {
			position162, tokenIndex162 := position, tokenIndex
			{
				position163 := position
				{
					position164, tokenIndex164 := position, tokenIndex
					if !_rules[ruleEscape]() {
						goto l165
					}
					goto l164
				l165:
					position, tokenIndex = position164, tokenIndex164
					{
						position166, tokenIndex166 := position, tokenIndex
						if buffer[position] != rune('\\') {
							goto l166
						}
						position++
						goto l162
					l166:
						position, tokenIndex = position166, tokenIndex166
					}
					{
						position167 := position
						if !matchDot() {
							goto l162
						}
						add(rulePegText, position167)
					}
					{
						add(ruleAction29, position)
					}
				}
			l164:
				add(ruleChar, position163)
			}
			return true
		l162:
			position, tokenIndex = position162, tokenIndex162
			return false
		},
		/* 21 DoubleChar <- <(Escape / (<([a-z] / [A-Z])> Action30) / (!'\\' <.> Action31))> */
		func() bool {
			position169, tokenIndex169 := position, tokenIndex
			{
				position170 := position
				{
					position171, tokenIndex171 := position, tokenIndex
					if !_rules[ruleEscape]() {
						goto l172
					}
					goto l171
				l172:
					position, tokenIndex = position171, tokenIndex171
					{
						position174 := position
						{
							position175, tokenIndex175 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l176
							}
							position++
							goto l175
						l176:
							position, tokenIndex = position175, tokenIndex175
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l173
							}
							position++
						}
					l175:
						add(rulePegText, position174)
					}
					{
						add(ruleAction30, position)
					}
					goto l171
				l173:
					position, tokenIndex = position171, tokenIndex171
					{
						position178, tokenIndex178 := position, tokenIndex
						if buffer[position] != rune('\\') {
							goto l178
						}
						position++
						goto l169
					l178:
						position, tokenIndex = position178, tokenIndex178
					}
					{
						position179 := position
						if !matchDot() {
							goto l169
						}
						add(rulePegText, position179)
					}
					{
						add(ruleAction31, position)
					}
				}
			l171:
				add(ruleDoubleChar, position170)
			}
			return true
		l169:
			position, tokenIndex = position169, tokenIndex169
			return false
		},
		/* 22 Escape <- <(('\\' ('a' / 'A') Action32) / ('\\' ('b' / 'B') Action33) / ('\\' ('e' / 'E') Action34) / ('\\' ('f' / 'F') Action35) / ('\\' ('n' / 'N') Action36) / ('\\' ('r' / 'R') Action37) / ('\\' ('t' / 'T') Action38) / ('\\' ('v' / 'V') Action39) / ('\\' '\'' Action40) / ('\\' '"' Action41) / ('\\' '[' Action42) / ('\\' ']' Action43) / ('\\' '-' Action44) / ('\\' ('0' ('x' / 'X')) <((&('A' | 'B' | 'C' | 'D' | 'E' | 'F') [A-F]) | (&('a' | 'b' | 'c' | 'd' | 'e' | 'f') [a-f]) | (&('0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9') [0-9]))+> Action45) / ('\\' <([0-3] [0-7] [0-7])> Action46) / ('\\' <([0-7] [0-7]?)> Action47) / ('\\' '\\' Action48))> */
		func() bool {
			position181, tokenIndex181 := position, tokenIndex
			{
				position182 := position
				{
					position183, tokenIndex183 := position, tokenIndex
					if buffer[position] != rune('\\') {
						goto l184
					}
					position++
					{
						position185, tokenIndex185 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l186
						}
						position++
						goto l185
					l186:
						position, tokenIndex = position185, tokenIndex185
						if buffer[position] != rune('A') {
							goto l184
						}
						position++
					}
				l185:
					{
						add(ruleAction32, position)
					}
					goto l183
				l184:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l188
					}
					position++
					{
						position189, tokenIndex189 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l190
						}
						position++
						goto l189
					l190:
						position, tokenIndex = position189, tokenIndex189
						if buffer[position] != rune('B') {
							goto l188
						}
						position++
					}
				l189:
					{
						add(ruleAction33, position)
					}
					goto l183
				l188:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l192
					}
					position++
					{
						position193, tokenIndex193 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l194
						}
						position++
						goto l193
					l194:
						position, tokenIndex = position193, tokenIndex193
						if buffer[position] != rune('E') {
							goto l192
						}
						position++
					}
				l193:
					{
						add(ruleAction34, position)
					}
					goto l183
				l192:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l196
					}
					position++
					{
						position197, tokenIndex197 := position, tokenIndex
						if buffer[position] != rune('f') {
							goto l198
						}
						position++
						goto l197
					l198:
						position, tokenIndex = position197, tokenIndex197
						if buffer[position] != rune('F') {
							goto l196
						}
						position++
					}
				l197:
					{
						add(ruleAction35, position)
					}
					goto l183
				l196:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l200
					}
					position++
					{
						position201, tokenIndex201 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l202
						}
						position++
						goto l201
					l202:
						position, tokenIndex = position201, tokenIndex201
						if buffer[position] != rune('N') {
							goto l200
						}
						position++
					}
				l201:
					{
						add(ruleAction36, position)
					}
					goto l183
				l200:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l204
					}
					position++
					{
						position205, tokenIndex205 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l206
						}
						position++
						goto l205
					l206:
						position, tokenIndex = position205, tokenIndex205
						if buffer[position] != rune('R') {
							goto l204
						}
						position++
					}
				l205:
					{
						add(ruleAction37, position)
					}
					goto l183
				l204:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l208
					}
					position++
					{
						position209, tokenIndex209 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l210
						}
						position++
						goto l209
					l210:
						position, tokenIndex = position209, tokenIndex209
						if buffer[position] != rune('T') {
							goto l208
						}
						position++
					}
				l209:
					{
						add(ruleAction38, position)
					}
					goto l183
				l208:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l212
					}
					position++
					{
						position213, tokenIndex213 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l214
						}
						position++
						goto l213
					l214:
						position, tokenIndex = position213, tokenIndex213
						if buffer[position] != rune('V') {
							goto l212
						}
						position++
					}
				l213:
					{
						add(ruleAction39, position)
					}
					goto l183
				l212:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l216
					}
					position++
					if buffer[position] != rune('\'') {
						goto l216
					}
					position++
					{
						add(ruleAction40, position)
					}
					goto l183
				l216:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l218
					}
					position++
					if buffer[position] != rune('"') {
						goto l218
					}
					position++
					{
						add(ruleAction41, position)
					}
					goto l183
				l218:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l220
					}
					position++
					if buffer[position] != rune('[') {
						goto l220
					}
					position++
					{
						add(ruleAction42, position)
					}
					goto l183
				l220:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l222
					}
					position++
					if buffer[position] != rune(']') {
						goto l222
					}
					position++
					{
						add(ruleAction43, position)
					}
					goto l183
				l222:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l224
					}
					position++
					if buffer[position] != rune('-') {
						goto l224
					}
					position++
					{
						add(ruleAction44, position)
					}
					goto l183
				l224:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l226
					}
					position++
					if buffer[position] != rune('0') {
						goto l226
					}
					position++
					{
						position227, tokenIndex227 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l228
						}
						position++
						goto l227
					l228:
						position, tokenIndex = position227, tokenIndex227
						if buffer[position] != rune('X') {
							goto l226
						}
						position++
					}
				l227:
					{
						position229 := position
						{
							switch buffer[position] {
							case 'A', 'B', 'C', 'D', 'E', 'F':
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l226
								}
								position++
							case 'a', 'b', 'c', 'd', 'e', 'f':
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l226
								}
								position++
							default:
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l226
								}
								position++
							}
						}

					l230:
						{
							position231, tokenIndex231 := position, tokenIndex
							{
								switch buffer[position] {
								case 'A', 'B', 'C', 'D', 'E', 'F':
									if c := buffer[position]; c < rune('A') || c > rune('F') {
										goto l231
									}
									position++
								case 'a', 'b', 'c', 'd', 'e', 'f':
									if c := buffer[position]; c < rune('a') || c > rune('f') {
										goto l231
									}
									position++
								default:
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l231
									}
									position++
								}
							}

							goto l230
						l231:
							position, tokenIndex = position231, tokenIndex231
						}
						add(rulePegText, position229)
					}
					{
						add(ruleAction45, position)
					}
					goto l183
				l226:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l235
					}
					position++
					{
						position236 := position
						if c := buffer[position]; c < rune('0') || c > rune('3') {
							goto l235
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('7') {
							goto l235
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('7') {
							goto l235
						}
						position++
						add(rulePegText, position236)
					}
					{
						add(ruleAction46, position)
					}
					goto l183
				l235:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l238
					}
					position++
					{
						position239 := position
						if c := buffer[position]; c < rune('0') || c > rune('7') {
							goto l238
						}
						position++
						{
							position240, tokenIndex240 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('7') {
								goto l240
							}
							position++
							goto l241
						l240:
							position, tokenIndex = position240, tokenIndex240
						}
					l241:
						add(rulePegText, position239)
					}
					{
						add(ruleAction47, position)
					}
					goto l183
				l238:
					position, tokenIndex = position183, tokenIndex183
					if buffer[position] != rune('\\') {
						goto l181
					}
					position++
					if buffer[position] != rune('\\') {
						goto l181
					}
					position++
					{
						add(ruleAction48, position)
					}
				}
			l183:
				add(ruleEscape, position182)
			}
			return true
		l181:
			position, tokenIndex = position181, tokenIndex181
			return false
		},
		/* 23 LeftArrow <- <((('<' '-') / '←') Spacing)> */
		func() bool {
			position244, tokenIndex244 := position, tokenIndex
			{
				position245 := position
				{
					position246, tokenIndex246 := position, tokenIndex
					if buffer[position] != rune('<') {
						goto l247
					}
					position++
					if buffer[position] != rune('-') {
						goto l247
					}
					position++
					goto l246
				l247:
					position, tokenIndex = position246, tokenIndex246
					if buffer[position] != rune('←') {
						goto l244
					}
					position++
				}
			l246:
				if !_rules[ruleSpacing]() {
					goto l244
				}
				add(ruleLeftArrow, position245)
			}
			return true
		l244:
			position, tokenIndex = position244, tokenIndex244
			return false
		},
		/* 24 Slash <- <('/' Spacing)> */
		func() bool {
			position248, tokenIndex248 := position, tokenIndex
			{
				position249 := position
				if buffer[position] != rune('/') {
					goto l248
				}
				position++
				if !_rules[ruleSpacing]() {
					goto l248
				}
				add(ruleSlash, position249)
			}
			return true
		l248:
			position, tokenIndex = position248, tokenIndex248
			return false
		},
		/* 25 And <- <('&' Spacing)> */
		func() bool {
			position250, tokenIndex250 := position, tokenIndex
			{
				position251 := position
				if buffer[position] != rune('&') {
					goto l250
				}
				position++
				if !_rules[ruleSpacing]() {
					goto l250
				}
				add(ruleAnd, position251)
			}
			return true
		l250:
			position, tokenIndex = position250, tokenIndex250
			return false
		},
		/* 26 Not <- <('!' Spacing)> */
		func() bool {
			position252, tokenIndex252 := position, tokenIndex
			{
				position253 := position
				if buffer[position] != rune('!') {
					goto l252
				}
				position++
				if !_rules[ruleSpacing]() {
					goto l252
				}
				add(ruleNot, position253)
			}
			return true
		l252:
			position, tokenIndex = position252, tokenIndex252
			return false
		},
		/* 27 Question <- <('?' Spacing)> */
		nil,
		/* 28 Star <- <('*' Spacing)> */
		nil,
		/* 29 Plus <- <('+' Spacing)> */
		nil,
		/* 30 Open <- <('(' Spacing)> */
		nil,
		/* 31 Close <- <(')' Spacing)> */
		nil,
		/* 32 Dot <- <('.' Spacing)> */
		nil,
		/* 33 SpaceComment <- <(Space / Comment)> */
		func() bool {
			position260, tokenIndex260 := position, tokenIndex
			{
				position261 := position
				{
					position262, tokenIndex262 := position, tokenIndex
					{
						position264 := position
						{
							switch buffer[position] {
							case '\t':
								if buffer[position] != rune('\t') {
									goto l263
								}
								position++
							case ' ':
								if buffer[position] != rune(' ') {
									goto l263
								}
								position++
							default:
								if !_rules[ruleEndOfLine]() {
									goto l263
								}
							}
						}

						add(ruleSpace, position264)
					}
					goto l262
				l263:
					position, tokenIndex = position262, tokenIndex262
					{
						position266 := position
						{
							position267, tokenIndex267 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l268
							}
							position++
							goto l267
						l268:
							position, tokenIndex = position267, tokenIndex267
							if buffer[position] != rune('/') {
								goto l260
							}
							position++
							if buffer[position] != rune('/') {
								goto l260
							}
							position++
						}
					l267:
					l269:
						{
							position270, tokenIndex270 := position, tokenIndex
							{
								position271, tokenIndex271 := position, tokenIndex
								if !_rules[ruleEndOfLine]() {
									goto l271
								}
								goto l270
							l271:
								position, tokenIndex = position271, tokenIndex271
							}
							if !matchDot() {
								goto l270
							}
							goto l269
						l270:
							position, tokenIndex = position270, tokenIndex270
						}
						if !_rules[ruleEndOfLine]() {
							goto l260
						}
						add(ruleComment, position266)
					}
				}
			l262:
				add(ruleSpaceComment, position261)
			}
			return true
		l260:
			position, tokenIndex = position260, tokenIndex260
			return false
		},
		/* 34 Spacing <- <SpaceComment*> */
		func() bool {
			{
				position273 := position
			l274:
				{
					position275, tokenIndex275 := position, tokenIndex
					if !_rules[ruleSpaceComment]() {
						goto l275
					}
					goto l274
				l275:
					position, tokenIndex = position275, tokenIndex275
				}
				add(ruleSpacing, position273)
			}
			return true
		},
		/* 35 MustSpacing <- <SpaceComment+> */
		func() bool {
			position276, tokenIndex276 := position, tokenIndex
			{
				position277 := position
				if !_rules[ruleSpaceComment]() {
					goto l276
				}
			l278:
				{
					position279, tokenIndex279 := position, tokenIndex
					if !_rules[ruleSpaceComment]() {
						goto l279
					}
					goto l278
				l279:
					position, tokenIndex = position279, tokenIndex279
				}
				add(ruleMustSpacing, position277)
			}
			return true
		l276:
			position, tokenIndex = position276, tokenIndex276
			return false
		},
		/* 36 Comment <- <(('#' / ('/' '/')) (!EndOfLine .)* EndOfLine)> */
		nil,
		/* 37 Space <- <((&('\t') '\t') | (&(' ') ' ') | (&('\n' | '\r') EndOfLine))> */
		nil,
		/* 38 EndOfLine <- <(('\r' '\n') / '\n' / '\r')> */
		func() bool {
			position282, tokenIndex282 := position, tokenIndex
			{
				position283 := position
				{
					position284, tokenIndex284 := position, tokenIndex
					if buffer[position] != rune('\r') {
						goto l285
					}
					position++
					if buffer[position] != rune('\n') {
						goto l285
					}
					position++
					goto l284
				l285:
					position, tokenIndex = position284, tokenIndex284
					if buffer[position] != rune('\n') {
						goto l286
					}
					position++
					goto l284
				l286:
					position, tokenIndex = position284, tokenIndex284
					if buffer[position] != rune('\r') {
						goto l282
					}
					position++
				}
			l284:
				add(ruleEndOfLine, position283)
			}
			return true
		l282:
			position, tokenIndex = position282, tokenIndex282
			return false
		},
		/* 39 EndOfFile <- <!.> */
		nil,
		/* 40 Action <- <('{' <ActionBody*> '}' Spacing)> */
		func() bool {
			position288, tokenIndex288 := position, tokenIndex
			{
				position289 := position
				if buffer[position] != rune('{') {
					goto l288
				}
				position++
				{
					position290 := position
				l291:
					{
						position292, tokenIndex292 := position, tokenIndex
						if !_rules[ruleActionBody]() {
							goto l292
						}
						goto l291
					l292:
						position, tokenIndex = position292, tokenIndex292
					}
					add(rulePegText, position290)
				}
				if buffer[position] != rune('}') {
					goto l288
				}
				position++
				if !_rules[ruleSpacing]() {
					goto l288
				}
				add(ruleAction, position289)
			}
			return true
		l288:
			position, tokenIndex = position288, tokenIndex288
			return false
		},
		/* 41 ActionBody <- <((!('{' / '}') .) / ('{' ActionBody* '}'))> */
		func() bool {
			position293, tokenIndex293 := position, tokenIndex
			{
				position294 := position
				{
					position295, tokenIndex295 := position, tokenIndex
					{
						position297, tokenIndex297 := position, tokenIndex
						{
							position298, tokenIndex298 := position, tokenIndex
							if buffer[position] != rune('{') {
								goto l299
							}
							position++
							goto l298
						l299:
							position, tokenIndex = position298, tokenIndex298
							if buffer[position] != rune('}') {
								goto l297
							}
							position++
						}
					l298:
						goto l296
					l297:
						position, tokenIndex = position297, tokenIndex297
					}
					if !matchDot() {
						goto l296
					}
					goto l295
				l296:
					position, tokenIndex = position295, tokenIndex295
					if buffer[position] != rune('{') {
						goto l293
					}
					position++
				l300:
					{
						position301, tokenIndex301 := position, tokenIndex
						if !_rules[ruleActionBody]() {
							goto l301
						}
						goto l300
					l301:
						position, tokenIndex = position301, tokenIndex301
					}
					if buffer[position] != rune('}') {
						goto l293
					}
					position++
				}
			l295:
				add(ruleActionBody, position294)
			}
			return true
		l293:
			position, tokenIndex = position293, tokenIndex293
			return false
		},
		/* 42 Begin <- <('<' Spacing)> */
		nil,
		/* 43 End <- <('>' Spacing)> */
		nil,
		/* 45 Action0 <- <{ p.AddPackage(text) }> */
		nil,
		/* 46 Action1 <- <{ p.AddPeg(text) }> */
		nil,
		/* 47 Action2 <- <{ p.AddState(text) }> */
		nil,
		nil,
		/* 49 Action3 <- <{ p.AddImport(text) }> */
		nil,
		/* 50 Action4 <- <{ p.AddRule(text) }> */
		nil,
		/* 51 Action5 <- <{ p.AddExpression() }> */
		nil,
		/* 52 Action6 <- <{ p.AddAlternate() }> */
		nil,
		/* 53 Action7 <- <{ p.AddNil(); p.AddAlternate() }> */
		nil,
		/* 54 Action8 <- <{ p.AddNil() }> */
		nil,
		/* 55 Action9 <- <{ p.AddSequence() }> */
		nil,
		/* 56 Action10 <- <{ p.AddPredicate(text) }> */
		nil,
		/* 57 Action11 <- <{ p.AddStateChange(text) }> */
		nil,
		/* 58 Action12 <- <{ p.AddPeekFor() }> */
		nil,
		/* 59 Action13 <- <{ p.AddPeekNot() }> */
		nil,
		/* 60 Action14 <- <{ p.AddQuery() }> */
		nil,
		/* 61 Action15 <- <{ p.AddStar() }> */
		nil,
		/* 62 Action16 <- <{ p.AddPlus() }> */
		nil,
		/* 63 Action17 <- <{ p.AddName(text) }> */
		nil,
		/* 64 Action18 <- <{ p.AddDot() }> */
		nil,
		/* 65 Action19 <- <{ p.AddAction(text) }> */
		nil,
		/* 66 Action20 <- <{ p.AddPush() }> */
		nil,
		/* 67 Action21 <- <{ p.AddSequence() }> */
		nil,
		/* 68 Action22 <- <{ p.AddSequence() }> */
		nil,
		/* 69 Action23 <- <{ p.AddPeekNot(); p.AddDot(); p.AddSequence() }> */
		nil,
		/* 70 Action24 <- <{ p.AddPeekNot(); p.AddDot(); p.AddSequence() }> */
		nil,
		/* 71 Action25 <- <{ p.AddAlternate() }> */
		nil,
		/* 72 Action26 <- <{ p.AddAlternate() }> */
		nil,
		/* 73 Action27 <- <{ p.AddRange() }> */
		nil,
		/* 74 Action28 <- <{ p.AddDoubleRange() }> */
		nil,
		/* 75 Action29 <- <{ p.AddCharacter(text) }> */
		nil,
		/* 76 Action30 <- <{ p.AddDoubleCharacter(text) }> */
		nil,
		/* 77 Action31 <- <{ p.AddCharacter(text) }> */
		nil,
		/* 78 Action32 <- <{ p.AddCharacter("\a") }> */
		nil,
		/* 79 Action33 <- <{ p.AddCharacter("\b") }> */
		nil,
		/* 80 Action34 <- <{ p.AddCharacter("\x1B") }> */
		nil,
		/* 81 Action35 <- <{ p.AddCharacter("\f") }> */
		nil,
		/* 82 Action36 <- <{ p.AddCharacter("\n") }> */
		nil,
		/* 83 Action37 <- <{ p.AddCharacter("\r") }> */
		nil,
		/* 84 Action38 <- <{ p.AddCharacter("\t") }> */
		nil,
		/* 85 Action39 <- <{ p.AddCharacter("\v") }> */
		nil,
		/* 86 Action40 <- <{ p.AddCharacter("'") }> */
		nil,
		/* 87 Action41 <- <{ p.AddCharacter("\"") }> */
		nil,
		/* 88 Action42 <- <{ p.AddCharacter("[") }> */
		nil,
		/* 89 Action43 <- <{ p.AddCharacter("]") }> */
		nil,
		/* 90 Action44 <- <{ p.AddCharacter("-") }> */
		nil,
		/* 91 Action45 <- <{ p.AddHexaCharacter(text) }> */
		nil,
		/* 92 Action46 <- <{ p.AddOctalCharacter(text) }> */
		nil,
		/* 93 Action47 <- <{ p.AddOctalCharacter(text) }> */
		nil,
		/* 94 Action48 <- <{ p.AddCharacter("\\") }> */
		nil,
	}
	p.rules = _rules
	return nil
}
