// Redirects for Packer Plugins extraction
// prettier-ignore
const pluginsExtractionRedirects = [
  // base
  {source: '/docs/:type/oneandone', destination: '/plugins/:type/oneandone', permanent: true},
  {source: '/docs/:type/alicloud', destination: '/plugins/:type/alicloud', permanent: true},
  {source: '/docs/:type/amazon', destination: '/plugins/:type/amazon', permanent: true},
  {source: '/docs/:type/anka', destination: '/plugins/:type/anka', permanent: true},
  {source: '/docs/:type/azure', destination: '/plugins/:type/azure', permanent: true},
  {source: '/docs/:type/cloudstack', destination: '/plugins/:type/cloudstack', permanent: true},
  {source: '/docs/:type/digitalocean', destination: '/plugins/:type/digitalocean', permanent: true},
  {source: '/docs/:type/docker', destination: '/plugins/:type/docker', permanent: true},
  {source: '/docs/:type/googlecompute', destination: '/plugins/:type/googlecompute', permanent: true},
  {source: '/docs/:type/hashicups', destination: '/plugins/:type/hashicups', permanent: true},
  {source: '/docs/:type/hetzner-cloud', destination: '/plugins/:type/hetzner-cloud', permanent: true},
  {source: '/docs/:type/huaweicloud', destination: '/plugins/:type/huaweicloud', permanent: true},
  {source: '/docs/:type/hyperv', destination: '/plugins/:type/hyperv', permanent: true},
  {source: '/docs/:type/hyperone', destination: '/plugins/:type/hyperone', permanent: true},
  {source: '/docs/:type/jdcloud', destination: '/plugins/:type/jdcloud', permanent: true},
  {source: '/docs/:type/kamatera', destination: '/plugins/:type/kamatera', permanent: true},
  {source: '/docs/:type/linode', destination: '/plugins/:type/linode', permanent: true},
  {source: '/docs/:type/lxc', destination: '/plugins/:type/lxc', permanent: true},
  {source: '/docs/:type/lxd', destination: '/plugins/:type/lxd', permanent: true},
  {source: '/docs/:type/ncloud', destination: '/plugins/:type/ncloud', permanent: true},
  {source: '/docs/:type/openstack', destination: '/plugins/:type/openstack', permanent: true},
  {source: '/docs/:type/oracle', destination: '/plugins/:type/oracle', permanent: true},
  {source: '/docs/:type/outscale', destination: '/plugins/:type/outscale', permanent: true},
  {source: '/docs/:type/parallels', destination: '/plugins/:type/parallels', permanent: true},
  {source: '/docs/:type/profitbricks', destination: '/plugins/:type/profitbricks', permanent: true},
  {source: '/docs/:type/proxmox', destination: '/plugins/:type/proxmox', permanent: true},
  {source: '/docs/:type/qemu', destination: '/plugins/:type/qemu', permanent: true},
  {source: '/docs/:type/scaleway', destination: '/plugins/:type/scaleway', permanent: true},
  {source: '/docs/:type/tencentcloud', destination: '/plugins/:type/tencentcloud', permanent: true},
  {source: '/docs/:type/triton', destination: '/plugins/:type/triton', permanent: true},
  {source: '/docs/:type/ucloud', destination: '/plugins/:type/ucloud', permanent: true},
  {source: '/docs/:type/vagrant', destination: '/plugins/:type/vagrant', permanent: true},
  {source: '/docs/:type/virtualbox', destination: '/plugins/:type/virtualbox', permanent: true},
  {source: '/docs/:type/vmware', destination: '/plugins/:type/vmware', permanent: true},
  {source: '/docs/:type/vsphere', destination: '/plugins/:type/vsphere', permanent: true},
  {source: '/docs/:type/vultr', destination: '/plugins/:type/vultr', permanent: true},
  {source: '/docs/:type/yandex', destination: '/plugins/:type/yandex', permanent: true},
  {source: '/docs/:type/git', destination: '/plugins/:type/git', permanent: true},
  {source: '/docs/:type/sshkey', destination: '/plugins/:type/sshkey', permanent: true},
  {source: '/docs/:type/ansible', destination: '/plugins/:type/ansible', permanent: true},
  {source: '/docs/:type/chef', destination: '/plugins/:type/chef', permanent: true},
  {source: '/docs/:type/converge', destination: '/plugins/:type/converge', permanent: true},
  {source: '/docs/:type/inspec', destination: '/plugins/:type/inspec', permanent: true},
  {source: '/docs/:type/puppet', destination: '/plugins/:type/puppet', permanent: true},
  {source: '/docs/:type/salt',   destination: '/plugins/:type/salt', permanent: true},
  // nested
  {source: '/docs/:type/oneandone/:path', destination: '/plugins/:type/oneandone/:path', permanent: true},
  {source: '/docs/:type/alicloud/:path', destination: '/plugins/:type/alicloud/:path', permanent: true},
  {source: '/docs/:type/amazon/:path', destination: '/plugins/:type/amazon/:path', permanent: true},
  {source: '/docs/:type/anka/:path', destination: '/plugins/:type/anka/:path', permanent: true},
  {source: '/docs/:type/azure/:path', destination: '/plugins/:type/azure/:path', permanent: true},
  {source: '/docs/:type/cloudstack/:path', destination: '/plugins/:type/cloudstack/:path', permanent: true},
  {source: '/docs/:type/digitalocean/:path', destination: '/plugins/:type/digitalocean/:path', permanent: true},
  {source: '/docs/:type/docker/:path', destination: '/plugins/:type/docker/:path', permanent: true},
  {source: '/docs/:type/googlecompute/:path', destination: '/plugins/:type/googlecompute/:path', permanent: true},
  {source: '/docs/:type/hashicups/:path', destination: '/plugins/:type/hashicups/:path', permanent: true},
  {source: '/docs/:type/hetzner-cloud/:path', destination: '/plugins/:type/hetzner-cloud/:path', permanent: true},
  {source: '/docs/:type/huaweicloud/:path', destination: '/plugins/:type/huaweicloud/:path', permanent: true},
  {source: '/docs/:type/hyperv/:path', destination: '/plugins/:type/hyperv/:path', permanent: true},
  {source: '/docs/:type/hyperone/:path', destination: '/plugins/:type/hyperone/:path', permanent: true},
  {source: '/docs/:type/jdcloud/:path', destination: '/plugins/:type/jdcloud/:path', permanent: true},
  {source: '/docs/:type/kamatera/:path', destination: '/plugins/:type/kamatera/:path', permanent: true},
  {source: '/docs/:type/linode/:path', destination: '/plugins/:type/linode/:path', permanent: true},
  {source: '/docs/:type/lxc/:path', destination: '/plugins/:type/lxc/:path', permanent: true},
  {source: '/docs/:type/lxd/:path', destination: '/plugins/:type/lxd/:path', permanent: true},
  {source: '/docs/:type/ncloud/:path', destination: '/plugins/:type/ncloud/:path', permanent: true},
  {source: '/docs/:type/openstack/:path', destination: '/plugins/:type/openstack/:path', permanent: true},
  {source: '/docs/:type/oracle/:path', destination: '/plugins/:type/oracle/:path', permanent: true},
  {source: '/docs/:type/outscale/:path', destination: '/plugins/:type/outscale/:path', permanent: true},
  {source: '/docs/:type/parallels/:path', destination: '/plugins/:type/parallels/:path', permanent: true},
  {source: '/docs/:type/profitbricks/:path', destination: '/plugins/:type/profitbricks/:path', permanent: true},
  {source: '/docs/:type/proxmox/:path', destination: '/plugins/:type/proxmox/:path', permanent: true},
  {source: '/docs/:type/qemu/:path', destination: '/plugins/:type/qemu/:path', permanent: true},
  {source: '/docs/:type/scaleway/:path', destination: '/plugins/:type/scaleway/:path', permanent: true},
  {source: '/docs/:type/tencentcloud/:path', destination: '/plugins/:type/tencentcloud/:path', permanent: true},
  {source: '/docs/:type/triton/:path', destination: '/plugins/:type/triton/:path', permanent: true},
  {source: '/docs/:type/ucloud/:path', destination: '/plugins/:type/ucloud/:path', permanent: true},
  {source: '/docs/:type/vagrant/:path', destination: '/plugins/:type/vagrant/:path', permanent: true},
  {source: '/docs/:type/virtualbox/:path', destination: '/plugins/:type/virtualbox/:path', permanent: true},
  {source: '/docs/:type/vmware/:path', destination: '/plugins/:type/vmware/:path', permanent: true},
  {source: '/docs/:type/vsphere/:path', destination: '/plugins/:type/vsphere/:path', permanent: true},
  {source: '/docs/:type/vultr/:path', destination: '/plugins/:type/vultr/:path', permanent: true},
  {source: '/docs/:type/yandex/:path', destination: '/plugins/:type/yandex/:path', permanent: true},
  {source: '/docs/:type/git/:path', destination: '/plugins/:type/git/:path', permanent: true},
  {source: '/docs/:type/sshkey/:path', destination: '/plugins/:type/sshkey/:path', permanent: true},
  {source: '/docs/:type/ansible/:path', destination: '/plugins/:type/ansible/:path', permanent: true},
  {source: '/docs/:type/chef/:path', destination: '/plugins/:type/chef/:path', permanent: true},
  {source: '/docs/:type/converge/:path', destination: '/plugins/:type/converge/:path', permanent: true},
  {source: '/docs/:type/inspec/:path', destination: '/plugins/:type/inspec/:path', permanent: true},
  {source: '/docs/:type/puppet/:path', destination: '/plugins/:type/puppet/:path', permanent: true},
  {source: '/docs/:type/salt/:path',   destination: '/plugins/:type/salt/:path', permanent: true},
]

module.exports = [
  {
    source: '/home',
    destination: '/',
    permanent: true,
  },
  {
    source: '/docs/installation',
    destination: '/docs/install',
    permanent: true,
  },
  {
    source: '/docs/command-line/machine-readable',
    destination: '/docs/commands',
    permanent: true,
  },
  {
    source: '/docs/command-line/introduction',
    destination: '/docs/commands',
    permanent: true,
  },
  {
    source: '/docs/templates/introduction',
    destination: '/docs/templates',
    permanent: true,
  },
  {
    source: '/docs/builders/azure-setup',
    destination: '/docs/builders/azure',
    permanent: true,
  },
  {
    source: '/docs/extend/developing-plugins',
    destination: '/docs/plugins',
    permanent: true,
  },
  {
    source: '/docs/extending/developing-plugins',
    destination: '/docs/plugins',
    permanent: true,
  },
  {
    source: '/docs/extending/plugins',
    destination: '/docs/plugins',
    permanent: true,
  },
  {
    source: '/docs/extend/builder',
    destination: '/docs/extending/custom-builders',
    permanent: true,
  },
  {
    source: '/docs/extending/custom-builders',
    destination: '/docs/plugins/creation/custom-builders',
    permanent: true,
  },
  {
    source: '/docs/extending/custom-provisioners',
    destination: '/docs/plugins/creation/custom-provisioners',
    permanent: true,
  },
  {
    source: '/docs/extending/custom-post-processors',
    destination: '/docs/plugins/creation/custom-post-processors',
    permanent: true,
  },
  {
    source: '/docs/getting-started/setup',
    destination: '/docs/getting-started/install',
    permanent: true,
  },
  {
    source: '/docs/other/community',
    destination: '/community-tools',
    permanent: true,
  },
  {
    source: '/downloads-community',
    destination: '/community-tools',
    permanent: true,
  },
  {
    source: '/docs/platforms',
    destination: '/docs/builders',
    permanent: true,
  },
  {
    source: '/intro/platforms',
    destination: '/docs/builders',
    permanent: true,
  },
  {
    source: '/docs/templates/configuration-templates',
    destination: '/docs/templates/legacy_json_templates/engine',
    permanent: true,
  },
  {
    source: '/docs/machine-readable/:path*',
    destination: '/docs/commands',
    permanent: true,
  },
  {
    source: '/docs/command-line/:path*',
    destination: '/docs/commands/:path*',
    permanent: true,
  },
  {
    source: '/intro/getting-started',
    destination: 'https://learn.hashicorp.com/packer/getting-started/install',
    permanent: true,
  },
  {
    source: '/intro/getting-started/install',
    destination: 'https://learn.hashicorp.com/packer/getting-started/install',
    permanent: true,
  },
  {
    source: '/intro/getting-started/build-image',
    destination:
      'https://learn.hashicorp.com/packer/getting-started/build-image',
    permanent: true,
  },
  {
    source: '/intro/getting-started/provision',
    destination: 'https://learn.hashicorp.com/packer/getting-started/provision',
    permanent: true,
  },
  {
    source: '/intro/getting-started/parallel-builds',
    destination:
      'https://learn.hashicorp.com/packer/getting-started/parallel-builds',
    permanent: true,
  },
  {
    source: '/intro/getting-started/vagrant',
    destination:
      'https://learn.hashicorp.com/tutorials/packer/aws-get-started-post-processors-vagrant?in=packer/aws-get-started',
    permanent: true,
  },
  {
    source: '/intro/getting-started/next',
    destination:
      'https://learn.hashicorp.com/collections/packer/docker-get-started',
    permanent: true,
  },
  {
    source: '/docs/basics/terminology',
    destination: '/docs/terminology',
    permanent: true,
  },
  {
    source: '/docs/other/:path*',
    destination: '/docs/:path*',
    permanent: true,
  },
  {
    source: '/docs/configuration/from-1.5/:path*/overview',
    destination: '/docs/templates/hcl_templates/:path*',
    permanent: true,
  },
  {
    source: '/docs/from-1.5/:path*',
    destination: '/docs/templates/hcl_templates/:path*',
    permanent: true,
  },
  {
    source: '/docs/templates/hcl_templates/:path*/overview',
    destination: '/docs/templates/hcl_templates/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/amazon-:path',
    destination: '/docs/builders/amazon/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/azure-:path',
    destination: '/docs/builders/azure/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/hyperv-:path',
    destination: '/docs/builders/hyperv/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/oracle-:path',
    destination: '/docs/builders/oracle/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/osc-:path',
    destination: '/docs/builders/outscale/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/parallels-:path',
    destination: '/docs/builders/parallels/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/virtualbox-:path',
    destination: '/docs/builders/virtualbox/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/vmware-:path',
    destination: '/docs/builders/vmware/:path*',
    permanent: true,
  },
  {
    source: '/docs/builders/vsphere-:path',
    destination: '/docs/builders/vmware/vsphere-:path*',
    permanent: true,
  },
  {
    source: '/docs/post-processors/docker-:path',
    destination: '/docs/post-processors/docker/docker-:path*',
    permanent: true,
  },
  {
    source: '/guides/hcl/from-json-v1',
    destination: 'https://learn.hashicorp.com/tutorials/packer/hcl2-upgrade',
    permanent: true,
  },
  // disallow '.html' or '/index.html' in favor of cleaner, simpler paths
  { source: '/:path*/index', destination: '/:path*', permanent: true },
  { source: '/:path*.html', destination: '/:path*', permanent: true },

  ...pluginsExtractionRedirects,
]
