// Code generated by sdkgen. DO NOT EDIT.

//nolint
package functions

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	functions "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/functions/v1"
)

//revive:disable

// FunctionServiceClient is a functions.FunctionServiceClient with
// lazy GRPC connection initialization.
type FunctionServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements functions.FunctionServiceClient
func (c *FunctionServiceClient) Create(ctx context.Context, in *functions.CreateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).Create(ctx, in, opts...)
}

// CreateVersion implements functions.FunctionServiceClient
func (c *FunctionServiceClient) CreateVersion(ctx context.Context, in *functions.CreateFunctionVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).CreateVersion(ctx, in, opts...)
}

// Delete implements functions.FunctionServiceClient
func (c *FunctionServiceClient) Delete(ctx context.Context, in *functions.DeleteFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements functions.FunctionServiceClient
func (c *FunctionServiceClient) Get(ctx context.Context, in *functions.GetFunctionRequest, opts ...grpc.CallOption) (*functions.Function, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).Get(ctx, in, opts...)
}

// GetVersion implements functions.FunctionServiceClient
func (c *FunctionServiceClient) GetVersion(ctx context.Context, in *functions.GetFunctionVersionRequest, opts ...grpc.CallOption) (*functions.Version, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).GetVersion(ctx, in, opts...)
}

// GetVersionByTag implements functions.FunctionServiceClient
func (c *FunctionServiceClient) GetVersionByTag(ctx context.Context, in *functions.GetFunctionVersionByTagRequest, opts ...grpc.CallOption) (*functions.Version, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).GetVersionByTag(ctx, in, opts...)
}

// List implements functions.FunctionServiceClient
func (c *FunctionServiceClient) List(ctx context.Context, in *functions.ListFunctionsRequest, opts ...grpc.CallOption) (*functions.ListFunctionsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).List(ctx, in, opts...)
}

type FunctionIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *FunctionServiceClient
	request *functions.ListFunctionsRequest

	items []*functions.Function
}

func (c *FunctionServiceClient) FunctionIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *FunctionIterator {
	return &FunctionIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &functions.ListFunctionsRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *FunctionIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Functions
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *FunctionIterator) Value() *functions.Function {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *FunctionIterator) Error() error {
	return it.err
}

// ListAccessBindings implements functions.FunctionServiceClient
func (c *FunctionServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type FunctionAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *FunctionServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *FunctionServiceClient) FunctionAccessBindingsIterator(ctx context.Context, resourceId string, opts ...grpc.CallOption) *FunctionAccessBindingsIterator {
	return &FunctionAccessBindingsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &access.ListAccessBindingsRequest{
			ResourceId: resourceId,
			PageSize:   1000,
		},
	}
}

func (it *FunctionAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *FunctionAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *FunctionAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements functions.FunctionServiceClient
func (c *FunctionServiceClient) ListOperations(ctx context.Context, in *functions.ListFunctionOperationsRequest, opts ...grpc.CallOption) (*functions.ListFunctionOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).ListOperations(ctx, in, opts...)
}

type FunctionOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *FunctionServiceClient
	request *functions.ListFunctionOperationsRequest

	items []*operation.Operation
}

func (c *FunctionServiceClient) FunctionOperationsIterator(ctx context.Context, functionId string, opts ...grpc.CallOption) *FunctionOperationsIterator {
	return &FunctionOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &functions.ListFunctionOperationsRequest{
			FunctionId: functionId,
			PageSize:   1000,
		},
	}
}

func (it *FunctionOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *FunctionOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *FunctionOperationsIterator) Error() error {
	return it.err
}

// ListRuntimes implements functions.FunctionServiceClient
func (c *FunctionServiceClient) ListRuntimes(ctx context.Context, in *functions.ListRuntimesRequest, opts ...grpc.CallOption) (*functions.ListRuntimesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).ListRuntimes(ctx, in, opts...)
}

type FunctionRuntimesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *FunctionServiceClient
	request *functions.ListRuntimesRequest

	items []string
}

func (c *FunctionServiceClient) FunctionRuntimesIterator(ctx context.Context, opts ...grpc.CallOption) *FunctionRuntimesIterator {
	return &FunctionRuntimesIterator{
		ctx:     ctx,
		opts:    opts,
		client:  c,
		request: &functions.ListRuntimesRequest{},
	}
}

func (it *FunctionRuntimesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListRuntimes(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Runtimes
	return len(it.items) > 0
}

func (it *FunctionRuntimesIterator) Value() string {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *FunctionRuntimesIterator) Error() error {
	return it.err
}

// ListTagHistory implements functions.FunctionServiceClient
func (c *FunctionServiceClient) ListTagHistory(ctx context.Context, in *functions.ListFunctionTagHistoryRequest, opts ...grpc.CallOption) (*functions.ListFunctionTagHistoryResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).ListTagHistory(ctx, in, opts...)
}

type FunctionTagHistoryIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *FunctionServiceClient
	request *functions.ListFunctionTagHistoryRequest

	items []*functions.ListFunctionTagHistoryResponse_FunctionTagHistoryRecord
}

func (c *FunctionServiceClient) FunctionTagHistoryIterator(ctx context.Context, functionId string, opts ...grpc.CallOption) *FunctionTagHistoryIterator {
	return &FunctionTagHistoryIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &functions.ListFunctionTagHistoryRequest{
			FunctionId: functionId,
			PageSize:   1000,
		},
	}
}

func (it *FunctionTagHistoryIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListTagHistory(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.FunctionTagHistoryRecord
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *FunctionTagHistoryIterator) Value() *functions.ListFunctionTagHistoryResponse_FunctionTagHistoryRecord {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *FunctionTagHistoryIterator) Error() error {
	return it.err
}

// ListVersions implements functions.FunctionServiceClient
func (c *FunctionServiceClient) ListVersions(ctx context.Context, in *functions.ListFunctionsVersionsRequest, opts ...grpc.CallOption) (*functions.ListFunctionsVersionsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).ListVersions(ctx, in, opts...)
}

// RemoveTag implements functions.FunctionServiceClient
func (c *FunctionServiceClient) RemoveTag(ctx context.Context, in *functions.RemoveFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).RemoveTag(ctx, in, opts...)
}

// SetAccessBindings implements functions.FunctionServiceClient
func (c *FunctionServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// SetTag implements functions.FunctionServiceClient
func (c *FunctionServiceClient) SetTag(ctx context.Context, in *functions.SetFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).SetTag(ctx, in, opts...)
}

// Update implements functions.FunctionServiceClient
func (c *FunctionServiceClient) Update(ctx context.Context, in *functions.UpdateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements functions.FunctionServiceClient
func (c *FunctionServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewFunctionServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
