// Code is generated by ucloud-model, DO NOT EDIT IT.

package ufile

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// UpdateUFileTokenRequest is request schema for UpdateUFileToken action
type UpdateUFileTokenRequest struct {
	request.CommonBase

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"true"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"false"`

	// 令牌允许操作的bucket
	AllowedBuckets []string `required:"false"`

	// 令牌允许执行的操作，[ TOKEN_ALLOW_NONE , TOKEN_ALLOW_READ , TOKEN_ALLOW_WRITE , TOKEN_ALLOW_DELETE , TOKEN_ALLOW_LIST, TOKEN_ALLOW_IOP , TOKEN_ALLOW_DP ]
	AllowedOps []string `required:"false"`

	// 令牌允许操作的key前缀
	AllowedPrefixes []string `required:"false"`

	// 令牌的超时时间点（时间戳）;注意：过期时间不能超过 4102416000
	ExpireTime *int `required:"false"`

	// 令牌ID
	TokenId *string `required:"true"`

	// 令牌名称
	TokenName *string `required:"false"`
}

// UpdateUFileTokenResponse is response schema for UpdateUFileToken action
type UpdateUFileTokenResponse struct {
	response.CommonBase
}

// NewUpdateUFileTokenRequest will create request of UpdateUFileToken action.
func (c *UFileClient) NewUpdateUFileTokenRequest() *UpdateUFileTokenRequest {
	req := &UpdateUFileTokenRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// UpdateUFileToken - 更新令牌的操作权限，可操作key的前缀，可操作bucket和令牌超时时间点
func (c *UFileClient) UpdateUFileToken(req *UpdateUFileTokenRequest) (*UpdateUFileTokenResponse, error) {
	var err error
	var res UpdateUFileTokenResponse

	reqCopier := *req

	err = c.Client.InvokeAction("UpdateUFileToken", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
