# Go API client for osc

Welcome to the 3DS OUTSCALE's API documentation.<br /><br />

The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />

Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />

You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 1.2
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get github.com/aws/aws-sdk-go/aws
go get golang.org/x/net/context
go get github.com/antihax/optional
```

Put the package under your project folder and add the following in import:

```golang
import "./osc"
```

## Documentation for API Endpoints

All URIs are relative to *https://api.eu-west-2.outscale.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessKeyApi* | [**CreateAccessKey**](docs/AccessKeyApi.md#createaccesskey) | **Post** /CreateAccessKey | 
*AccessKeyApi* | [**DeleteAccessKey**](docs/AccessKeyApi.md#deleteaccesskey) | **Post** /DeleteAccessKey | 
*AccessKeyApi* | [**ReadAccessKeys**](docs/AccessKeyApi.md#readaccesskeys) | **Post** /ReadAccessKeys | 
*AccessKeyApi* | [**ReadSecretAccessKey**](docs/AccessKeyApi.md#readsecretaccesskey) | **Post** /ReadSecretAccessKey | 
*AccessKeyApi* | [**UpdateAccessKey**](docs/AccessKeyApi.md#updateaccesskey) | **Post** /UpdateAccessKey | 
*AccountApi* | [**CheckAuthentication**](docs/AccountApi.md#checkauthentication) | **Post** /CheckAuthentication | 
*AccountApi* | [**CreateAccount**](docs/AccountApi.md#createaccount) | **Post** /CreateAccount | 
*AccountApi* | [**ReadAccounts**](docs/AccountApi.md#readaccounts) | **Post** /ReadAccounts | 
*AccountApi* | [**ResetAccountPassword**](docs/AccountApi.md#resetaccountpassword) | **Post** /ResetAccountPassword | 
*AccountApi* | [**SendResetPasswordEmail**](docs/AccountApi.md#sendresetpasswordemail) | **Post** /SendResetPasswordEmail | 
*AccountApi* | [**UpdateAccount**](docs/AccountApi.md#updateaccount) | **Post** /UpdateAccount | 
*ApiLogApi* | [**ReadApiLogs**](docs/ApiLogApi.md#readapilogs) | **Post** /ReadApiLogs | 
*ClientGatewayApi* | [**CreateClientGateway**](docs/ClientGatewayApi.md#createclientgateway) | **Post** /CreateClientGateway | 
*ClientGatewayApi* | [**DeleteClientGateway**](docs/ClientGatewayApi.md#deleteclientgateway) | **Post** /DeleteClientGateway | 
*ClientGatewayApi* | [**ReadClientGateways**](docs/ClientGatewayApi.md#readclientgateways) | **Post** /ReadClientGateways | 
*DefaultApi* | [**ReadConsumptionAccount**](docs/DefaultApi.md#readconsumptionaccount) | **Post** /ReadConsumptionAccount | 
*DhcpOptionApi* | [**CreateDhcpOptions**](docs/DhcpOptionApi.md#createdhcpoptions) | **Post** /CreateDhcpOptions | 
*DhcpOptionApi* | [**DeleteDhcpOptions**](docs/DhcpOptionApi.md#deletedhcpoptions) | **Post** /DeleteDhcpOptions | 
*DhcpOptionApi* | [**ReadDhcpOptions**](docs/DhcpOptionApi.md#readdhcpoptions) | **Post** /ReadDhcpOptions | 
*DirectLinkApi* | [**CreateDirectLink**](docs/DirectLinkApi.md#createdirectlink) | **Post** /CreateDirectLink | 
*DirectLinkApi* | [**DeleteDirectLink**](docs/DirectLinkApi.md#deletedirectlink) | **Post** /DeleteDirectLink | 
*DirectLinkApi* | [**ReadDirectLinks**](docs/DirectLinkApi.md#readdirectlinks) | **Post** /ReadDirectLinks | 
*DirectLinkInterfaceApi* | [**CreateDirectLinkInterface**](docs/DirectLinkInterfaceApi.md#createdirectlinkinterface) | **Post** /CreateDirectLinkInterface | 
*DirectLinkInterfaceApi* | [**DeleteDirectLinkInterface**](docs/DirectLinkInterfaceApi.md#deletedirectlinkinterface) | **Post** /DeleteDirectLinkInterface | 
*DirectLinkInterfaceApi* | [**ReadDirectLinkInterfaces**](docs/DirectLinkInterfaceApi.md#readdirectlinkinterfaces) | **Post** /ReadDirectLinkInterfaces | 
*FlexibleGpuApi* | [**CreateFlexibleGpu**](docs/FlexibleGpuApi.md#createflexiblegpu) | **Post** /CreateFlexibleGpu | 
*FlexibleGpuApi* | [**DeleteFlexibleGpu**](docs/FlexibleGpuApi.md#deleteflexiblegpu) | **Post** /DeleteFlexibleGpu | 
*FlexibleGpuApi* | [**LinkFlexibleGpu**](docs/FlexibleGpuApi.md#linkflexiblegpu) | **Post** /LinkFlexibleGpu | 
*FlexibleGpuApi* | [**ReadFlexibleGpuCatalog**](docs/FlexibleGpuApi.md#readflexiblegpucatalog) | **Post** /ReadFlexibleGpuCatalog | 
*FlexibleGpuApi* | [**ReadFlexibleGpus**](docs/FlexibleGpuApi.md#readflexiblegpus) | **Post** /ReadFlexibleGpus | 
*FlexibleGpuApi* | [**UnlinkFlexibleGpu**](docs/FlexibleGpuApi.md#unlinkflexiblegpu) | **Post** /UnlinkFlexibleGpu | 
*FlexibleGpuApi* | [**UpdateFlexibleGpu**](docs/FlexibleGpuApi.md#updateflexiblegpu) | **Post** /UpdateFlexibleGpu | 
*ImageApi* | [**CreateImage**](docs/ImageApi.md#createimage) | **Post** /CreateImage | 
*ImageApi* | [**CreateImageExportTask**](docs/ImageApi.md#createimageexporttask) | **Post** /CreateImageExportTask | 
*ImageApi* | [**DeleteImage**](docs/ImageApi.md#deleteimage) | **Post** /DeleteImage | 
*ImageApi* | [**ReadImageExportTasks**](docs/ImageApi.md#readimageexporttasks) | **Post** /ReadImageExportTasks | 
*ImageApi* | [**ReadImages**](docs/ImageApi.md#readimages) | **Post** /ReadImages | 
*ImageApi* | [**UpdateImage**](docs/ImageApi.md#updateimage) | **Post** /UpdateImage | 
*InternetServiceApi* | [**CreateInternetService**](docs/InternetServiceApi.md#createinternetservice) | **Post** /CreateInternetService | 
*InternetServiceApi* | [**DeleteInternetService**](docs/InternetServiceApi.md#deleteinternetservice) | **Post** /DeleteInternetService | 
*InternetServiceApi* | [**LinkInternetService**](docs/InternetServiceApi.md#linkinternetservice) | **Post** /LinkInternetService | 
*InternetServiceApi* | [**ReadInternetServices**](docs/InternetServiceApi.md#readinternetservices) | **Post** /ReadInternetServices | 
*InternetServiceApi* | [**UnlinkInternetService**](docs/InternetServiceApi.md#unlinkinternetservice) | **Post** /UnlinkInternetService | 
*KeypairApi* | [**CreateKeypair**](docs/KeypairApi.md#createkeypair) | **Post** /CreateKeypair | 
*KeypairApi* | [**DeleteKeypair**](docs/KeypairApi.md#deletekeypair) | **Post** /DeleteKeypair | 
*KeypairApi* | [**ReadKeypairs**](docs/KeypairApi.md#readkeypairs) | **Post** /ReadKeypairs | 
*ListenerApi* | [**CreateListenerRule**](docs/ListenerApi.md#createlistenerrule) | **Post** /CreateListenerRule | 
*ListenerApi* | [**CreateLoadBalancerListeners**](docs/ListenerApi.md#createloadbalancerlisteners) | **Post** /CreateLoadBalancerListeners | 
*ListenerApi* | [**DeleteListenerRule**](docs/ListenerApi.md#deletelistenerrule) | **Post** /DeleteListenerRule | 
*ListenerApi* | [**DeleteLoadBalancerListeners**](docs/ListenerApi.md#deleteloadbalancerlisteners) | **Post** /DeleteLoadBalancerListeners | 
*ListenerApi* | [**ReadListenerRules**](docs/ListenerApi.md#readlistenerrules) | **Post** /ReadListenerRules | 
*ListenerApi* | [**UpdateListenerRule**](docs/ListenerApi.md#updatelistenerrule) | **Post** /UpdateListenerRule | 
*LoadBalancerApi* | [**CreateLoadBalancer**](docs/LoadBalancerApi.md#createloadbalancer) | **Post** /CreateLoadBalancer | 
*LoadBalancerApi* | [**CreateLoadBalancerTags**](docs/LoadBalancerApi.md#createloadbalancertags) | **Post** /CreateLoadBalancerTags | 
*LoadBalancerApi* | [**DeleteLoadBalancer**](docs/LoadBalancerApi.md#deleteloadbalancer) | **Post** /DeleteLoadBalancer | 
*LoadBalancerApi* | [**DeleteLoadBalancerTags**](docs/LoadBalancerApi.md#deleteloadbalancertags) | **Post** /DeleteLoadBalancerTags | 
*LoadBalancerApi* | [**DeregisterVmsInLoadBalancer**](docs/LoadBalancerApi.md#deregistervmsinloadbalancer) | **Post** /DeregisterVmsInLoadBalancer | 
*LoadBalancerApi* | [**ReadLoadBalancerTags**](docs/LoadBalancerApi.md#readloadbalancertags) | **Post** /ReadLoadBalancerTags | 
*LoadBalancerApi* | [**ReadLoadBalancers**](docs/LoadBalancerApi.md#readloadbalancers) | **Post** /ReadLoadBalancers | 
*LoadBalancerApi* | [**ReadVmsHealth**](docs/LoadBalancerApi.md#readvmshealth) | **Post** /ReadVmsHealth | 
*LoadBalancerApi* | [**RegisterVmsInLoadBalancer**](docs/LoadBalancerApi.md#registervmsinloadbalancer) | **Post** /RegisterVmsInLoadBalancer | 
*LoadBalancerApi* | [**UpdateLoadBalancer**](docs/LoadBalancerApi.md#updateloadbalancer) | **Post** /UpdateLoadBalancer | 
*LoadBalancerPolicyApi* | [**CreateLoadBalancerPolicy**](docs/LoadBalancerPolicyApi.md#createloadbalancerpolicy) | **Post** /CreateLoadBalancerPolicy | 
*LoadBalancerPolicyApi* | [**DeleteLoadBalancerPolicy**](docs/LoadBalancerPolicyApi.md#deleteloadbalancerpolicy) | **Post** /DeleteLoadBalancerPolicy | 
*LocationApi* | [**ReadLocations**](docs/LocationApi.md#readlocations) | **Post** /ReadLocations | 
*NatServiceApi* | [**CreateNatService**](docs/NatServiceApi.md#createnatservice) | **Post** /CreateNatService | 
*NatServiceApi* | [**DeleteNatService**](docs/NatServiceApi.md#deletenatservice) | **Post** /DeleteNatService | 
*NatServiceApi* | [**ReadNatServices**](docs/NatServiceApi.md#readnatservices) | **Post** /ReadNatServices | 
*NetApi* | [**CreateNet**](docs/NetApi.md#createnet) | **Post** /CreateNet | 
*NetApi* | [**DeleteNet**](docs/NetApi.md#deletenet) | **Post** /DeleteNet | 
*NetApi* | [**ReadNets**](docs/NetApi.md#readnets) | **Post** /ReadNets | 
*NetApi* | [**UpdateNet**](docs/NetApi.md#updatenet) | **Post** /UpdateNet | 
*NetAccessPointApi* | [**CreateNetAccessPoint**](docs/NetAccessPointApi.md#createnetaccesspoint) | **Post** /CreateNetAccessPoint | 
*NetAccessPointApi* | [**DeleteNetAccessPoint**](docs/NetAccessPointApi.md#deletenetaccesspoint) | **Post** /DeleteNetAccessPoint | 
*NetAccessPointApi* | [**ReadNetAccessPointServices**](docs/NetAccessPointApi.md#readnetaccesspointservices) | **Post** /ReadNetAccessPointServices | 
*NetAccessPointApi* | [**ReadNetAccessPoints**](docs/NetAccessPointApi.md#readnetaccesspoints) | **Post** /ReadNetAccessPoints | 
*NetAccessPointApi* | [**UpdateNetAccessPoint**](docs/NetAccessPointApi.md#updatenetaccesspoint) | **Post** /UpdateNetAccessPoint | 
*NetPeeringApi* | [**AcceptNetPeering**](docs/NetPeeringApi.md#acceptnetpeering) | **Post** /AcceptNetPeering | 
*NetPeeringApi* | [**CreateNetPeering**](docs/NetPeeringApi.md#createnetpeering) | **Post** /CreateNetPeering | 
*NetPeeringApi* | [**DeleteNetPeering**](docs/NetPeeringApi.md#deletenetpeering) | **Post** /DeleteNetPeering | 
*NetPeeringApi* | [**ReadNetPeerings**](docs/NetPeeringApi.md#readnetpeerings) | **Post** /ReadNetPeerings | 
*NetPeeringApi* | [**RejectNetPeering**](docs/NetPeeringApi.md#rejectnetpeering) | **Post** /RejectNetPeering | 
*NicApi* | [**CreateNic**](docs/NicApi.md#createnic) | **Post** /CreateNic | 
*NicApi* | [**DeleteNic**](docs/NicApi.md#deletenic) | **Post** /DeleteNic | 
*NicApi* | [**LinkNic**](docs/NicApi.md#linknic) | **Post** /LinkNic | 
*NicApi* | [**LinkPrivateIps**](docs/NicApi.md#linkprivateips) | **Post** /LinkPrivateIps | 
*NicApi* | [**ReadNics**](docs/NicApi.md#readnics) | **Post** /ReadNics | 
*NicApi* | [**UnlinkNic**](docs/NicApi.md#unlinknic) | **Post** /UnlinkNic | 
*NicApi* | [**UnlinkPrivateIps**](docs/NicApi.md#unlinkprivateips) | **Post** /UnlinkPrivateIps | 
*NicApi* | [**UpdateNic**](docs/NicApi.md#updatenic) | **Post** /UpdateNic | 
*ProductTypeApi* | [**ReadProductTypes**](docs/ProductTypeApi.md#readproducttypes) | **Post** /ReadProductTypes | 
*PublicIpApi* | [**CreatePublicIp**](docs/PublicIpApi.md#createpublicip) | **Post** /CreatePublicIp | 
*PublicIpApi* | [**DeletePublicIp**](docs/PublicIpApi.md#deletepublicip) | **Post** /DeletePublicIp | 
*PublicIpApi* | [**LinkPublicIp**](docs/PublicIpApi.md#linkpublicip) | **Post** /LinkPublicIp | 
*PublicIpApi* | [**ReadPublicIpRanges**](docs/PublicIpApi.md#readpublicipranges) | **Post** /ReadPublicIpRanges | 
*PublicIpApi* | [**ReadPublicIps**](docs/PublicIpApi.md#readpublicips) | **Post** /ReadPublicIps | 
*PublicIpApi* | [**UnlinkPublicIp**](docs/PublicIpApi.md#unlinkpublicip) | **Post** /UnlinkPublicIp | 
*QuotaApi* | [**ReadQuotas**](docs/QuotaApi.md#readquotas) | **Post** /ReadQuotas | 
*RegionApi* | [**ReadRegions**](docs/RegionApi.md#readregions) | **Post** /ReadRegions | 
*RouteApi* | [**CreateRoute**](docs/RouteApi.md#createroute) | **Post** /CreateRoute | 
*RouteApi* | [**DeleteRoute**](docs/RouteApi.md#deleteroute) | **Post** /DeleteRoute | 
*RouteApi* | [**UpdateRoute**](docs/RouteApi.md#updateroute) | **Post** /UpdateRoute | 
*RouteTableApi* | [**CreateRouteTable**](docs/RouteTableApi.md#createroutetable) | **Post** /CreateRouteTable | 
*RouteTableApi* | [**DeleteRouteTable**](docs/RouteTableApi.md#deleteroutetable) | **Post** /DeleteRouteTable | 
*RouteTableApi* | [**LinkRouteTable**](docs/RouteTableApi.md#linkroutetable) | **Post** /LinkRouteTable | 
*RouteTableApi* | [**ReadRouteTables**](docs/RouteTableApi.md#readroutetables) | **Post** /ReadRouteTables | 
*RouteTableApi* | [**UnlinkRouteTable**](docs/RouteTableApi.md#unlinkroutetable) | **Post** /UnlinkRouteTable | 
*SecurityGroupApi* | [**CreateSecurityGroup**](docs/SecurityGroupApi.md#createsecuritygroup) | **Post** /CreateSecurityGroup | 
*SecurityGroupApi* | [**DeleteSecurityGroup**](docs/SecurityGroupApi.md#deletesecuritygroup) | **Post** /DeleteSecurityGroup | 
*SecurityGroupApi* | [**ReadSecurityGroups**](docs/SecurityGroupApi.md#readsecuritygroups) | **Post** /ReadSecurityGroups | 
*SecurityGroupRuleApi* | [**CreateSecurityGroupRule**](docs/SecurityGroupRuleApi.md#createsecuritygrouprule) | **Post** /CreateSecurityGroupRule | 
*SecurityGroupRuleApi* | [**DeleteSecurityGroupRule**](docs/SecurityGroupRuleApi.md#deletesecuritygrouprule) | **Post** /DeleteSecurityGroupRule | 
*ServerCertificateApi* | [**CreateServerCertificate**](docs/ServerCertificateApi.md#createservercertificate) | **Post** /CreateServerCertificate | 
*ServerCertificateApi* | [**DeleteServerCertificate**](docs/ServerCertificateApi.md#deleteservercertificate) | **Post** /DeleteServerCertificate | 
*ServerCertificateApi* | [**ReadServerCertificates**](docs/ServerCertificateApi.md#readservercertificates) | **Post** /ReadServerCertificates | 
*ServerCertificateApi* | [**UpdateServerCertificate**](docs/ServerCertificateApi.md#updateservercertificate) | **Post** /UpdateServerCertificate | 
*SnapshotApi* | [**CreateSnapshot**](docs/SnapshotApi.md#createsnapshot) | **Post** /CreateSnapshot | 
*SnapshotApi* | [**CreateSnapshotExportTask**](docs/SnapshotApi.md#createsnapshotexporttask) | **Post** /CreateSnapshotExportTask | 
*SnapshotApi* | [**DeleteSnapshot**](docs/SnapshotApi.md#deletesnapshot) | **Post** /DeleteSnapshot | 
*SnapshotApi* | [**ReadSnapshotExportTasks**](docs/SnapshotApi.md#readsnapshotexporttasks) | **Post** /ReadSnapshotExportTasks | 
*SnapshotApi* | [**ReadSnapshots**](docs/SnapshotApi.md#readsnapshots) | **Post** /ReadSnapshots | 
*SnapshotApi* | [**UpdateSnapshot**](docs/SnapshotApi.md#updatesnapshot) | **Post** /UpdateSnapshot | 
*SubnetApi* | [**CreateSubnet**](docs/SubnetApi.md#createsubnet) | **Post** /CreateSubnet | 
*SubnetApi* | [**DeleteSubnet**](docs/SubnetApi.md#deletesubnet) | **Post** /DeleteSubnet | 
*SubnetApi* | [**ReadSubnets**](docs/SubnetApi.md#readsubnets) | **Post** /ReadSubnets | 
*SubnetApi* | [**UpdateSubnet**](docs/SubnetApi.md#updatesubnet) | **Post** /UpdateSubnet | 
*SubregionApi* | [**ReadSubregions**](docs/SubregionApi.md#readsubregions) | **Post** /ReadSubregions | 
*TagApi* | [**CreateTags**](docs/TagApi.md#createtags) | **Post** /CreateTags | 
*TagApi* | [**DeleteTags**](docs/TagApi.md#deletetags) | **Post** /DeleteTags | 
*TagApi* | [**ReadTags**](docs/TagApi.md#readtags) | **Post** /ReadTags | 
*TaskApi* | [**DeleteExportTask**](docs/TaskApi.md#deleteexporttask) | **Post** /DeleteExportTask | 
*VirtualGatewayApi* | [**CreateVirtualGateway**](docs/VirtualGatewayApi.md#createvirtualgateway) | **Post** /CreateVirtualGateway | 
*VirtualGatewayApi* | [**DeleteVirtualGateway**](docs/VirtualGatewayApi.md#deletevirtualgateway) | **Post** /DeleteVirtualGateway | 
*VirtualGatewayApi* | [**LinkVirtualGateway**](docs/VirtualGatewayApi.md#linkvirtualgateway) | **Post** /LinkVirtualGateway | 
*VirtualGatewayApi* | [**ReadVirtualGateways**](docs/VirtualGatewayApi.md#readvirtualgateways) | **Post** /ReadVirtualGateways | 
*VirtualGatewayApi* | [**UnlinkVirtualGateway**](docs/VirtualGatewayApi.md#unlinkvirtualgateway) | **Post** /UnlinkVirtualGateway | 
*VirtualGatewayApi* | [**UpdateRoutePropagation**](docs/VirtualGatewayApi.md#updateroutepropagation) | **Post** /UpdateRoutePropagation | 
*VmApi* | [**CreateVms**](docs/VmApi.md#createvms) | **Post** /CreateVms | 
*VmApi* | [**DeleteVms**](docs/VmApi.md#deletevms) | **Post** /DeleteVms | 
*VmApi* | [**ReadAdminPassword**](docs/VmApi.md#readadminpassword) | **Post** /ReadAdminPassword | 
*VmApi* | [**ReadConsoleOutput**](docs/VmApi.md#readconsoleoutput) | **Post** /ReadConsoleOutput | 
*VmApi* | [**ReadVmTypes**](docs/VmApi.md#readvmtypes) | **Post** /ReadVmTypes | 
*VmApi* | [**ReadVms**](docs/VmApi.md#readvms) | **Post** /ReadVms | 
*VmApi* | [**ReadVmsState**](docs/VmApi.md#readvmsstate) | **Post** /ReadVmsState | 
*VmApi* | [**RebootVms**](docs/VmApi.md#rebootvms) | **Post** /RebootVms | 
*VmApi* | [**StartVms**](docs/VmApi.md#startvms) | **Post** /StartVms | 
*VmApi* | [**StopVms**](docs/VmApi.md#stopvms) | **Post** /StopVms | 
*VmApi* | [**UpdateVm**](docs/VmApi.md#updatevm) | **Post** /UpdateVm | 
*VolumeApi* | [**CreateVolume**](docs/VolumeApi.md#createvolume) | **Post** /CreateVolume | 
*VolumeApi* | [**DeleteVolume**](docs/VolumeApi.md#deletevolume) | **Post** /DeleteVolume | 
*VolumeApi* | [**LinkVolume**](docs/VolumeApi.md#linkvolume) | **Post** /LinkVolume | 
*VolumeApi* | [**ReadVolumes**](docs/VolumeApi.md#readvolumes) | **Post** /ReadVolumes | 
*VolumeApi* | [**UnlinkVolume**](docs/VolumeApi.md#unlinkvolume) | **Post** /UnlinkVolume | 
*VpnConnectionApi* | [**CreateVpnConnection**](docs/VpnConnectionApi.md#createvpnconnection) | **Post** /CreateVpnConnection | 
*VpnConnectionApi* | [**CreateVpnConnectionRoute**](docs/VpnConnectionApi.md#createvpnconnectionroute) | **Post** /CreateVpnConnectionRoute | 
*VpnConnectionApi* | [**DeleteVpnConnection**](docs/VpnConnectionApi.md#deletevpnconnection) | **Post** /DeleteVpnConnection | 
*VpnConnectionApi* | [**DeleteVpnConnectionRoute**](docs/VpnConnectionApi.md#deletevpnconnectionroute) | **Post** /DeleteVpnConnectionRoute | 
*VpnConnectionApi* | [**ReadVpnConnections**](docs/VpnConnectionApi.md#readvpnconnections) | **Post** /ReadVpnConnections | 


## Documentation For Models

 - [AcceptNetPeeringRequest](docs/AcceptNetPeeringRequest.md)
 - [AcceptNetPeeringResponse](docs/AcceptNetPeeringResponse.md)
 - [AccepterNet](docs/AccepterNet.md)
 - [AccessKey](docs/AccessKey.md)
 - [AccessKeySecretKey](docs/AccessKeySecretKey.md)
 - [AccessLog](docs/AccessLog.md)
 - [Account](docs/Account.md)
 - [ApplicationStickyCookiePolicy](docs/ApplicationStickyCookiePolicy.md)
 - [BackendVmHealth](docs/BackendVmHealth.md)
 - [BlockDeviceMappingCreated](docs/BlockDeviceMappingCreated.md)
 - [BlockDeviceMappingImage](docs/BlockDeviceMappingImage.md)
 - [BlockDeviceMappingVmCreation](docs/BlockDeviceMappingVmCreation.md)
 - [BlockDeviceMappingVmUpdate](docs/BlockDeviceMappingVmUpdate.md)
 - [BsuCreated](docs/BsuCreated.md)
 - [BsuToCreate](docs/BsuToCreate.md)
 - [BsuToUpdateVm](docs/BsuToUpdateVm.md)
 - [CheckAuthenticationRequest](docs/CheckAuthenticationRequest.md)
 - [CheckAuthenticationResponse](docs/CheckAuthenticationResponse.md)
 - [ClientGateway](docs/ClientGateway.md)
 - [ConsumptionEntry](docs/ConsumptionEntry.md)
 - [CreateAccessKeyRequest](docs/CreateAccessKeyRequest.md)
 - [CreateAccessKeyResponse](docs/CreateAccessKeyResponse.md)
 - [CreateAccountRequest](docs/CreateAccountRequest.md)
 - [CreateAccountResponse](docs/CreateAccountResponse.md)
 - [CreateClientGatewayRequest](docs/CreateClientGatewayRequest.md)
 - [CreateClientGatewayResponse](docs/CreateClientGatewayResponse.md)
 - [CreateDhcpOptionsRequest](docs/CreateDhcpOptionsRequest.md)
 - [CreateDhcpOptionsResponse](docs/CreateDhcpOptionsResponse.md)
 - [CreateDirectLinkInterfaceRequest](docs/CreateDirectLinkInterfaceRequest.md)
 - [CreateDirectLinkInterfaceResponse](docs/CreateDirectLinkInterfaceResponse.md)
 - [CreateDirectLinkRequest](docs/CreateDirectLinkRequest.md)
 - [CreateDirectLinkResponse](docs/CreateDirectLinkResponse.md)
 - [CreateFlexibleGpuRequest](docs/CreateFlexibleGpuRequest.md)
 - [CreateFlexibleGpuResponse](docs/CreateFlexibleGpuResponse.md)
 - [CreateImageExportTaskRequest](docs/CreateImageExportTaskRequest.md)
 - [CreateImageExportTaskResponse](docs/CreateImageExportTaskResponse.md)
 - [CreateImageRequest](docs/CreateImageRequest.md)
 - [CreateImageResponse](docs/CreateImageResponse.md)
 - [CreateInternetServiceRequest](docs/CreateInternetServiceRequest.md)
 - [CreateInternetServiceResponse](docs/CreateInternetServiceResponse.md)
 - [CreateKeypairRequest](docs/CreateKeypairRequest.md)
 - [CreateKeypairResponse](docs/CreateKeypairResponse.md)
 - [CreateListenerRuleRequest](docs/CreateListenerRuleRequest.md)
 - [CreateListenerRuleResponse](docs/CreateListenerRuleResponse.md)
 - [CreateLoadBalancerListenersRequest](docs/CreateLoadBalancerListenersRequest.md)
 - [CreateLoadBalancerListenersResponse](docs/CreateLoadBalancerListenersResponse.md)
 - [CreateLoadBalancerPolicyRequest](docs/CreateLoadBalancerPolicyRequest.md)
 - [CreateLoadBalancerPolicyResponse](docs/CreateLoadBalancerPolicyResponse.md)
 - [CreateLoadBalancerRequest](docs/CreateLoadBalancerRequest.md)
 - [CreateLoadBalancerResponse](docs/CreateLoadBalancerResponse.md)
 - [CreateLoadBalancerTagsRequest](docs/CreateLoadBalancerTagsRequest.md)
 - [CreateLoadBalancerTagsResponse](docs/CreateLoadBalancerTagsResponse.md)
 - [CreateNatServiceRequest](docs/CreateNatServiceRequest.md)
 - [CreateNatServiceResponse](docs/CreateNatServiceResponse.md)
 - [CreateNetAccessPointRequest](docs/CreateNetAccessPointRequest.md)
 - [CreateNetAccessPointResponse](docs/CreateNetAccessPointResponse.md)
 - [CreateNetPeeringRequest](docs/CreateNetPeeringRequest.md)
 - [CreateNetPeeringResponse](docs/CreateNetPeeringResponse.md)
 - [CreateNetRequest](docs/CreateNetRequest.md)
 - [CreateNetResponse](docs/CreateNetResponse.md)
 - [CreateNicRequest](docs/CreateNicRequest.md)
 - [CreateNicResponse](docs/CreateNicResponse.md)
 - [CreatePublicIpRequest](docs/CreatePublicIpRequest.md)
 - [CreatePublicIpResponse](docs/CreatePublicIpResponse.md)
 - [CreateRouteRequest](docs/CreateRouteRequest.md)
 - [CreateRouteResponse](docs/CreateRouteResponse.md)
 - [CreateRouteTableRequest](docs/CreateRouteTableRequest.md)
 - [CreateRouteTableResponse](docs/CreateRouteTableResponse.md)
 - [CreateSecurityGroupRequest](docs/CreateSecurityGroupRequest.md)
 - [CreateSecurityGroupResponse](docs/CreateSecurityGroupResponse.md)
 - [CreateSecurityGroupRuleRequest](docs/CreateSecurityGroupRuleRequest.md)
 - [CreateSecurityGroupRuleResponse](docs/CreateSecurityGroupRuleResponse.md)
 - [CreateServerCertificateRequest](docs/CreateServerCertificateRequest.md)
 - [CreateServerCertificateResponse](docs/CreateServerCertificateResponse.md)
 - [CreateSnapshotExportTaskRequest](docs/CreateSnapshotExportTaskRequest.md)
 - [CreateSnapshotExportTaskResponse](docs/CreateSnapshotExportTaskResponse.md)
 - [CreateSnapshotRequest](docs/CreateSnapshotRequest.md)
 - [CreateSnapshotResponse](docs/CreateSnapshotResponse.md)
 - [CreateSubnetRequest](docs/CreateSubnetRequest.md)
 - [CreateSubnetResponse](docs/CreateSubnetResponse.md)
 - [CreateTagsRequest](docs/CreateTagsRequest.md)
 - [CreateTagsResponse](docs/CreateTagsResponse.md)
 - [CreateVirtualGatewayRequest](docs/CreateVirtualGatewayRequest.md)
 - [CreateVirtualGatewayResponse](docs/CreateVirtualGatewayResponse.md)
 - [CreateVmsRequest](docs/CreateVmsRequest.md)
 - [CreateVmsResponse](docs/CreateVmsResponse.md)
 - [CreateVolumeRequest](docs/CreateVolumeRequest.md)
 - [CreateVolumeResponse](docs/CreateVolumeResponse.md)
 - [CreateVpnConnectionRequest](docs/CreateVpnConnectionRequest.md)
 - [CreateVpnConnectionResponse](docs/CreateVpnConnectionResponse.md)
 - [CreateVpnConnectionRouteRequest](docs/CreateVpnConnectionRouteRequest.md)
 - [CreateVpnConnectionRouteResponse](docs/CreateVpnConnectionRouteResponse.md)
 - [DeleteAccessKeyRequest](docs/DeleteAccessKeyRequest.md)
 - [DeleteAccessKeyResponse](docs/DeleteAccessKeyResponse.md)
 - [DeleteClientGatewayRequest](docs/DeleteClientGatewayRequest.md)
 - [DeleteClientGatewayResponse](docs/DeleteClientGatewayResponse.md)
 - [DeleteDhcpOptionsRequest](docs/DeleteDhcpOptionsRequest.md)
 - [DeleteDhcpOptionsResponse](docs/DeleteDhcpOptionsResponse.md)
 - [DeleteDirectLinkInterfaceRequest](docs/DeleteDirectLinkInterfaceRequest.md)
 - [DeleteDirectLinkInterfaceResponse](docs/DeleteDirectLinkInterfaceResponse.md)
 - [DeleteDirectLinkRequest](docs/DeleteDirectLinkRequest.md)
 - [DeleteDirectLinkResponse](docs/DeleteDirectLinkResponse.md)
 - [DeleteExportTaskRequest](docs/DeleteExportTaskRequest.md)
 - [DeleteExportTaskResponse](docs/DeleteExportTaskResponse.md)
 - [DeleteFlexibleGpuRequest](docs/DeleteFlexibleGpuRequest.md)
 - [DeleteFlexibleGpuResponse](docs/DeleteFlexibleGpuResponse.md)
 - [DeleteImageRequest](docs/DeleteImageRequest.md)
 - [DeleteImageResponse](docs/DeleteImageResponse.md)
 - [DeleteInternetServiceRequest](docs/DeleteInternetServiceRequest.md)
 - [DeleteInternetServiceResponse](docs/DeleteInternetServiceResponse.md)
 - [DeleteKeypairRequest](docs/DeleteKeypairRequest.md)
 - [DeleteKeypairResponse](docs/DeleteKeypairResponse.md)
 - [DeleteListenerRuleRequest](docs/DeleteListenerRuleRequest.md)
 - [DeleteListenerRuleResponse](docs/DeleteListenerRuleResponse.md)
 - [DeleteLoadBalancerListenersRequest](docs/DeleteLoadBalancerListenersRequest.md)
 - [DeleteLoadBalancerListenersResponse](docs/DeleteLoadBalancerListenersResponse.md)
 - [DeleteLoadBalancerPolicyRequest](docs/DeleteLoadBalancerPolicyRequest.md)
 - [DeleteLoadBalancerPolicyResponse](docs/DeleteLoadBalancerPolicyResponse.md)
 - [DeleteLoadBalancerRequest](docs/DeleteLoadBalancerRequest.md)
 - [DeleteLoadBalancerResponse](docs/DeleteLoadBalancerResponse.md)
 - [DeleteLoadBalancerTagsRequest](docs/DeleteLoadBalancerTagsRequest.md)
 - [DeleteLoadBalancerTagsResponse](docs/DeleteLoadBalancerTagsResponse.md)
 - [DeleteNatServiceRequest](docs/DeleteNatServiceRequest.md)
 - [DeleteNatServiceResponse](docs/DeleteNatServiceResponse.md)
 - [DeleteNetAccessPointRequest](docs/DeleteNetAccessPointRequest.md)
 - [DeleteNetAccessPointResponse](docs/DeleteNetAccessPointResponse.md)
 - [DeleteNetPeeringRequest](docs/DeleteNetPeeringRequest.md)
 - [DeleteNetPeeringResponse](docs/DeleteNetPeeringResponse.md)
 - [DeleteNetRequest](docs/DeleteNetRequest.md)
 - [DeleteNetResponse](docs/DeleteNetResponse.md)
 - [DeleteNicRequest](docs/DeleteNicRequest.md)
 - [DeleteNicResponse](docs/DeleteNicResponse.md)
 - [DeletePublicIpRequest](docs/DeletePublicIpRequest.md)
 - [DeletePublicIpResponse](docs/DeletePublicIpResponse.md)
 - [DeleteRouteRequest](docs/DeleteRouteRequest.md)
 - [DeleteRouteResponse](docs/DeleteRouteResponse.md)
 - [DeleteRouteTableRequest](docs/DeleteRouteTableRequest.md)
 - [DeleteRouteTableResponse](docs/DeleteRouteTableResponse.md)
 - [DeleteSecurityGroupRequest](docs/DeleteSecurityGroupRequest.md)
 - [DeleteSecurityGroupResponse](docs/DeleteSecurityGroupResponse.md)
 - [DeleteSecurityGroupRuleRequest](docs/DeleteSecurityGroupRuleRequest.md)
 - [DeleteSecurityGroupRuleResponse](docs/DeleteSecurityGroupRuleResponse.md)
 - [DeleteServerCertificateRequest](docs/DeleteServerCertificateRequest.md)
 - [DeleteServerCertificateResponse](docs/DeleteServerCertificateResponse.md)
 - [DeleteSnapshotRequest](docs/DeleteSnapshotRequest.md)
 - [DeleteSnapshotResponse](docs/DeleteSnapshotResponse.md)
 - [DeleteSubnetRequest](docs/DeleteSubnetRequest.md)
 - [DeleteSubnetResponse](docs/DeleteSubnetResponse.md)
 - [DeleteTagsRequest](docs/DeleteTagsRequest.md)
 - [DeleteTagsResponse](docs/DeleteTagsResponse.md)
 - [DeleteVirtualGatewayRequest](docs/DeleteVirtualGatewayRequest.md)
 - [DeleteVirtualGatewayResponse](docs/DeleteVirtualGatewayResponse.md)
 - [DeleteVmsRequest](docs/DeleteVmsRequest.md)
 - [DeleteVmsResponse](docs/DeleteVmsResponse.md)
 - [DeleteVolumeRequest](docs/DeleteVolumeRequest.md)
 - [DeleteVolumeResponse](docs/DeleteVolumeResponse.md)
 - [DeleteVpnConnectionRequest](docs/DeleteVpnConnectionRequest.md)
 - [DeleteVpnConnectionResponse](docs/DeleteVpnConnectionResponse.md)
 - [DeleteVpnConnectionRouteRequest](docs/DeleteVpnConnectionRouteRequest.md)
 - [DeleteVpnConnectionRouteResponse](docs/DeleteVpnConnectionRouteResponse.md)
 - [DeregisterVmsInLoadBalancerRequest](docs/DeregisterVmsInLoadBalancerRequest.md)
 - [DeregisterVmsInLoadBalancerResponse](docs/DeregisterVmsInLoadBalancerResponse.md)
 - [DhcpOptionsSet](docs/DhcpOptionsSet.md)
 - [DirectLink](docs/DirectLink.md)
 - [DirectLinkInterface](docs/DirectLinkInterface.md)
 - [DirectLinkInterfaces](docs/DirectLinkInterfaces.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Errors](docs/Errors.md)
 - [FiltersAccessKeys](docs/FiltersAccessKeys.md)
 - [FiltersApiLog](docs/FiltersApiLog.md)
 - [FiltersClientGateway](docs/FiltersClientGateway.md)
 - [FiltersDhcpOptions](docs/FiltersDhcpOptions.md)
 - [FiltersDirectLink](docs/FiltersDirectLink.md)
 - [FiltersDirectLinkInterface](docs/FiltersDirectLinkInterface.md)
 - [FiltersExportTask](docs/FiltersExportTask.md)
 - [FiltersFlexibleGpu](docs/FiltersFlexibleGpu.md)
 - [FiltersImage](docs/FiltersImage.md)
 - [FiltersInternetService](docs/FiltersInternetService.md)
 - [FiltersKeypair](docs/FiltersKeypair.md)
 - [FiltersListenerRule](docs/FiltersListenerRule.md)
 - [FiltersLoadBalancer](docs/FiltersLoadBalancer.md)
 - [FiltersNatService](docs/FiltersNatService.md)
 - [FiltersNet](docs/FiltersNet.md)
 - [FiltersNetAccessPoint](docs/FiltersNetAccessPoint.md)
 - [FiltersNetPeering](docs/FiltersNetPeering.md)
 - [FiltersNic](docs/FiltersNic.md)
 - [FiltersProductType](docs/FiltersProductType.md)
 - [FiltersPublicIp](docs/FiltersPublicIp.md)
 - [FiltersQuota](docs/FiltersQuota.md)
 - [FiltersRouteTable](docs/FiltersRouteTable.md)
 - [FiltersSecurityGroup](docs/FiltersSecurityGroup.md)
 - [FiltersServerCertificate](docs/FiltersServerCertificate.md)
 - [FiltersService](docs/FiltersService.md)
 - [FiltersSnapshot](docs/FiltersSnapshot.md)
 - [FiltersSubnet](docs/FiltersSubnet.md)
 - [FiltersSubregion](docs/FiltersSubregion.md)
 - [FiltersTag](docs/FiltersTag.md)
 - [FiltersVirtualGateway](docs/FiltersVirtualGateway.md)
 - [FiltersVm](docs/FiltersVm.md)
 - [FiltersVmType](docs/FiltersVmType.md)
 - [FiltersVmsState](docs/FiltersVmsState.md)
 - [FiltersVolume](docs/FiltersVolume.md)
 - [FiltersVpnConnection](docs/FiltersVpnConnection.md)
 - [FlexibleGpu](docs/FlexibleGpu.md)
 - [FlexibleGpuCatalog](docs/FlexibleGpuCatalog.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [Image](docs/Image.md)
 - [ImageExportTask](docs/ImageExportTask.md)
 - [InternetService](docs/InternetService.md)
 - [Keypair](docs/Keypair.md)
 - [KeypairCreated](docs/KeypairCreated.md)
 - [LinkFlexibleGpuRequest](docs/LinkFlexibleGpuRequest.md)
 - [LinkFlexibleGpuResponse](docs/LinkFlexibleGpuResponse.md)
 - [LinkInternetServiceRequest](docs/LinkInternetServiceRequest.md)
 - [LinkInternetServiceResponse](docs/LinkInternetServiceResponse.md)
 - [LinkNic](docs/LinkNic.md)
 - [LinkNicLight](docs/LinkNicLight.md)
 - [LinkNicRequest](docs/LinkNicRequest.md)
 - [LinkNicResponse](docs/LinkNicResponse.md)
 - [LinkNicToUpdate](docs/LinkNicToUpdate.md)
 - [LinkPrivateIpsRequest](docs/LinkPrivateIpsRequest.md)
 - [LinkPrivateIpsResponse](docs/LinkPrivateIpsResponse.md)
 - [LinkPublicIp](docs/LinkPublicIp.md)
 - [LinkPublicIpLightForVm](docs/LinkPublicIpLightForVm.md)
 - [LinkPublicIpRequest](docs/LinkPublicIpRequest.md)
 - [LinkPublicIpResponse](docs/LinkPublicIpResponse.md)
 - [LinkRouteTable](docs/LinkRouteTable.md)
 - [LinkRouteTableRequest](docs/LinkRouteTableRequest.md)
 - [LinkRouteTableResponse](docs/LinkRouteTableResponse.md)
 - [LinkVirtualGatewayRequest](docs/LinkVirtualGatewayRequest.md)
 - [LinkVirtualGatewayResponse](docs/LinkVirtualGatewayResponse.md)
 - [LinkVolumeRequest](docs/LinkVolumeRequest.md)
 - [LinkVolumeResponse](docs/LinkVolumeResponse.md)
 - [LinkedVolume](docs/LinkedVolume.md)
 - [Listener](docs/Listener.md)
 - [ListenerForCreation](docs/ListenerForCreation.md)
 - [ListenerRule](docs/ListenerRule.md)
 - [ListenerRuleForCreation](docs/ListenerRuleForCreation.md)
 - [LoadBalancer](docs/LoadBalancer.md)
 - [LoadBalancerLight](docs/LoadBalancerLight.md)
 - [LoadBalancerStickyCookiePolicy](docs/LoadBalancerStickyCookiePolicy.md)
 - [LoadBalancerTag](docs/LoadBalancerTag.md)
 - [Location](docs/Location.md)
 - [Log](docs/Log.md)
 - [MaintenanceEvent](docs/MaintenanceEvent.md)
 - [NatService](docs/NatService.md)
 - [Net](docs/Net.md)
 - [NetAccessPoint](docs/NetAccessPoint.md)
 - [NetPeering](docs/NetPeering.md)
 - [NetPeeringState](docs/NetPeeringState.md)
 - [NetToVirtualGatewayLink](docs/NetToVirtualGatewayLink.md)
 - [Nic](docs/Nic.md)
 - [NicForVmCreation](docs/NicForVmCreation.md)
 - [NicLight](docs/NicLight.md)
 - [OsuApiKey](docs/OsuApiKey.md)
 - [OsuExport](docs/OsuExport.md)
 - [PermissionsOnResource](docs/PermissionsOnResource.md)
 - [PermissionsOnResourceCreation](docs/PermissionsOnResourceCreation.md)
 - [Placement](docs/Placement.md)
 - [PrivateIp](docs/PrivateIp.md)
 - [PrivateIpLight](docs/PrivateIpLight.md)
 - [PrivateIpLightForVm](docs/PrivateIpLightForVm.md)
 - [ProductType](docs/ProductType.md)
 - [PublicIp](docs/PublicIp.md)
 - [PublicIpLight](docs/PublicIpLight.md)
 - [Quota](docs/Quota.md)
 - [QuotaTypes](docs/QuotaTypes.md)
 - [ReadAccessKeysRequest](docs/ReadAccessKeysRequest.md)
 - [ReadAccessKeysResponse](docs/ReadAccessKeysResponse.md)
 - [ReadAccountsRequest](docs/ReadAccountsRequest.md)
 - [ReadAccountsResponse](docs/ReadAccountsResponse.md)
 - [ReadAdminPasswordRequest](docs/ReadAdminPasswordRequest.md)
 - [ReadAdminPasswordResponse](docs/ReadAdminPasswordResponse.md)
 - [ReadApiLogsRequest](docs/ReadApiLogsRequest.md)
 - [ReadApiLogsResponse](docs/ReadApiLogsResponse.md)
 - [ReadClientGatewaysRequest](docs/ReadClientGatewaysRequest.md)
 - [ReadClientGatewaysResponse](docs/ReadClientGatewaysResponse.md)
 - [ReadConsoleOutputRequest](docs/ReadConsoleOutputRequest.md)
 - [ReadConsoleOutputResponse](docs/ReadConsoleOutputResponse.md)
 - [ReadConsumptionAccountRequest](docs/ReadConsumptionAccountRequest.md)
 - [ReadConsumptionAccountResponse](docs/ReadConsumptionAccountResponse.md)
 - [ReadDhcpOptionsRequest](docs/ReadDhcpOptionsRequest.md)
 - [ReadDhcpOptionsResponse](docs/ReadDhcpOptionsResponse.md)
 - [ReadDirectLinkInterfacesRequest](docs/ReadDirectLinkInterfacesRequest.md)
 - [ReadDirectLinkInterfacesResponse](docs/ReadDirectLinkInterfacesResponse.md)
 - [ReadDirectLinksRequest](docs/ReadDirectLinksRequest.md)
 - [ReadDirectLinksResponse](docs/ReadDirectLinksResponse.md)
 - [ReadFlexibleGpuCatalogRequest](docs/ReadFlexibleGpuCatalogRequest.md)
 - [ReadFlexibleGpuCatalogResponse](docs/ReadFlexibleGpuCatalogResponse.md)
 - [ReadFlexibleGpusRequest](docs/ReadFlexibleGpusRequest.md)
 - [ReadFlexibleGpusResponse](docs/ReadFlexibleGpusResponse.md)
 - [ReadImageExportTasksRequest](docs/ReadImageExportTasksRequest.md)
 - [ReadImageExportTasksResponse](docs/ReadImageExportTasksResponse.md)
 - [ReadImagesRequest](docs/ReadImagesRequest.md)
 - [ReadImagesResponse](docs/ReadImagesResponse.md)
 - [ReadInternetServicesRequest](docs/ReadInternetServicesRequest.md)
 - [ReadInternetServicesResponse](docs/ReadInternetServicesResponse.md)
 - [ReadKeypairsRequest](docs/ReadKeypairsRequest.md)
 - [ReadKeypairsResponse](docs/ReadKeypairsResponse.md)
 - [ReadListenerRulesRequest](docs/ReadListenerRulesRequest.md)
 - [ReadListenerRulesResponse](docs/ReadListenerRulesResponse.md)
 - [ReadLoadBalancerTagsRequest](docs/ReadLoadBalancerTagsRequest.md)
 - [ReadLoadBalancerTagsResponse](docs/ReadLoadBalancerTagsResponse.md)
 - [ReadLoadBalancersRequest](docs/ReadLoadBalancersRequest.md)
 - [ReadLoadBalancersResponse](docs/ReadLoadBalancersResponse.md)
 - [ReadLocationsRequest](docs/ReadLocationsRequest.md)
 - [ReadLocationsResponse](docs/ReadLocationsResponse.md)
 - [ReadNatServicesRequest](docs/ReadNatServicesRequest.md)
 - [ReadNatServicesResponse](docs/ReadNatServicesResponse.md)
 - [ReadNetAccessPointServicesRequest](docs/ReadNetAccessPointServicesRequest.md)
 - [ReadNetAccessPointServicesResponse](docs/ReadNetAccessPointServicesResponse.md)
 - [ReadNetAccessPointsRequest](docs/ReadNetAccessPointsRequest.md)
 - [ReadNetAccessPointsResponse](docs/ReadNetAccessPointsResponse.md)
 - [ReadNetPeeringsRequest](docs/ReadNetPeeringsRequest.md)
 - [ReadNetPeeringsResponse](docs/ReadNetPeeringsResponse.md)
 - [ReadNetsRequest](docs/ReadNetsRequest.md)
 - [ReadNetsResponse](docs/ReadNetsResponse.md)
 - [ReadNicsRequest](docs/ReadNicsRequest.md)
 - [ReadNicsResponse](docs/ReadNicsResponse.md)
 - [ReadProductTypesRequest](docs/ReadProductTypesRequest.md)
 - [ReadProductTypesResponse](docs/ReadProductTypesResponse.md)
 - [ReadPublicIpRangesRequest](docs/ReadPublicIpRangesRequest.md)
 - [ReadPublicIpRangesResponse](docs/ReadPublicIpRangesResponse.md)
 - [ReadPublicIpsRequest](docs/ReadPublicIpsRequest.md)
 - [ReadPublicIpsResponse](docs/ReadPublicIpsResponse.md)
 - [ReadQuotasRequest](docs/ReadQuotasRequest.md)
 - [ReadQuotasResponse](docs/ReadQuotasResponse.md)
 - [ReadRegionsRequest](docs/ReadRegionsRequest.md)
 - [ReadRegionsResponse](docs/ReadRegionsResponse.md)
 - [ReadRouteTablesRequest](docs/ReadRouteTablesRequest.md)
 - [ReadRouteTablesResponse](docs/ReadRouteTablesResponse.md)
 - [ReadSecretAccessKeyRequest](docs/ReadSecretAccessKeyRequest.md)
 - [ReadSecretAccessKeyResponse](docs/ReadSecretAccessKeyResponse.md)
 - [ReadSecurityGroupsRequest](docs/ReadSecurityGroupsRequest.md)
 - [ReadSecurityGroupsResponse](docs/ReadSecurityGroupsResponse.md)
 - [ReadServerCertificatesRequest](docs/ReadServerCertificatesRequest.md)
 - [ReadServerCertificatesResponse](docs/ReadServerCertificatesResponse.md)
 - [ReadSnapshotExportTasksRequest](docs/ReadSnapshotExportTasksRequest.md)
 - [ReadSnapshotExportTasksResponse](docs/ReadSnapshotExportTasksResponse.md)
 - [ReadSnapshotsRequest](docs/ReadSnapshotsRequest.md)
 - [ReadSnapshotsResponse](docs/ReadSnapshotsResponse.md)
 - [ReadSubnetsRequest](docs/ReadSubnetsRequest.md)
 - [ReadSubnetsResponse](docs/ReadSubnetsResponse.md)
 - [ReadSubregionsRequest](docs/ReadSubregionsRequest.md)
 - [ReadSubregionsResponse](docs/ReadSubregionsResponse.md)
 - [ReadTagsRequest](docs/ReadTagsRequest.md)
 - [ReadTagsResponse](docs/ReadTagsResponse.md)
 - [ReadVirtualGatewaysRequest](docs/ReadVirtualGatewaysRequest.md)
 - [ReadVirtualGatewaysResponse](docs/ReadVirtualGatewaysResponse.md)
 - [ReadVmTypesRequest](docs/ReadVmTypesRequest.md)
 - [ReadVmTypesResponse](docs/ReadVmTypesResponse.md)
 - [ReadVmsHealthRequest](docs/ReadVmsHealthRequest.md)
 - [ReadVmsHealthResponse](docs/ReadVmsHealthResponse.md)
 - [ReadVmsRequest](docs/ReadVmsRequest.md)
 - [ReadVmsResponse](docs/ReadVmsResponse.md)
 - [ReadVmsStateRequest](docs/ReadVmsStateRequest.md)
 - [ReadVmsStateResponse](docs/ReadVmsStateResponse.md)
 - [ReadVolumesRequest](docs/ReadVolumesRequest.md)
 - [ReadVolumesResponse](docs/ReadVolumesResponse.md)
 - [ReadVpnConnectionsRequest](docs/ReadVpnConnectionsRequest.md)
 - [ReadVpnConnectionsResponse](docs/ReadVpnConnectionsResponse.md)
 - [RebootVmsRequest](docs/RebootVmsRequest.md)
 - [RebootVmsResponse](docs/RebootVmsResponse.md)
 - [Region](docs/Region.md)
 - [RegisterVmsInLoadBalancerRequest](docs/RegisterVmsInLoadBalancerRequest.md)
 - [RegisterVmsInLoadBalancerResponse](docs/RegisterVmsInLoadBalancerResponse.md)
 - [RejectNetPeeringRequest](docs/RejectNetPeeringRequest.md)
 - [RejectNetPeeringResponse](docs/RejectNetPeeringResponse.md)
 - [ResetAccountPasswordRequest](docs/ResetAccountPasswordRequest.md)
 - [ResetAccountPasswordResponse](docs/ResetAccountPasswordResponse.md)
 - [ResourceLoadBalancerTag](docs/ResourceLoadBalancerTag.md)
 - [ResourceTag](docs/ResourceTag.md)
 - [ResponseContext](docs/ResponseContext.md)
 - [Route](docs/Route.md)
 - [RouteLight](docs/RouteLight.md)
 - [RoutePropagatingVirtualGateway](docs/RoutePropagatingVirtualGateway.md)
 - [RouteTable](docs/RouteTable.md)
 - [SecurityGroup](docs/SecurityGroup.md)
 - [SecurityGroupLight](docs/SecurityGroupLight.md)
 - [SecurityGroupRule](docs/SecurityGroupRule.md)
 - [SecurityGroupsMember](docs/SecurityGroupsMember.md)
 - [SendResetPasswordEmailRequest](docs/SendResetPasswordEmailRequest.md)
 - [SendResetPasswordEmailResponse](docs/SendResetPasswordEmailResponse.md)
 - [ServerCertificate](docs/ServerCertificate.md)
 - [Service](docs/Service.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotExportTask](docs/SnapshotExportTask.md)
 - [SourceNet](docs/SourceNet.md)
 - [SourceSecurityGroup](docs/SourceSecurityGroup.md)
 - [StartVmsRequest](docs/StartVmsRequest.md)
 - [StartVmsResponse](docs/StartVmsResponse.md)
 - [StateComment](docs/StateComment.md)
 - [StopVmsRequest](docs/StopVmsRequest.md)
 - [StopVmsResponse](docs/StopVmsResponse.md)
 - [Subnet](docs/Subnet.md)
 - [Subregion](docs/Subregion.md)
 - [Tag](docs/Tag.md)
 - [UnlinkFlexibleGpuRequest](docs/UnlinkFlexibleGpuRequest.md)
 - [UnlinkFlexibleGpuResponse](docs/UnlinkFlexibleGpuResponse.md)
 - [UnlinkInternetServiceRequest](docs/UnlinkInternetServiceRequest.md)
 - [UnlinkInternetServiceResponse](docs/UnlinkInternetServiceResponse.md)
 - [UnlinkNicRequest](docs/UnlinkNicRequest.md)
 - [UnlinkNicResponse](docs/UnlinkNicResponse.md)
 - [UnlinkPrivateIpsRequest](docs/UnlinkPrivateIpsRequest.md)
 - [UnlinkPrivateIpsResponse](docs/UnlinkPrivateIpsResponse.md)
 - [UnlinkPublicIpRequest](docs/UnlinkPublicIpRequest.md)
 - [UnlinkPublicIpResponse](docs/UnlinkPublicIpResponse.md)
 - [UnlinkRouteTableRequest](docs/UnlinkRouteTableRequest.md)
 - [UnlinkRouteTableResponse](docs/UnlinkRouteTableResponse.md)
 - [UnlinkVirtualGatewayRequest](docs/UnlinkVirtualGatewayRequest.md)
 - [UnlinkVirtualGatewayResponse](docs/UnlinkVirtualGatewayResponse.md)
 - [UnlinkVolumeRequest](docs/UnlinkVolumeRequest.md)
 - [UnlinkVolumeResponse](docs/UnlinkVolumeResponse.md)
 - [UpdateAccessKeyRequest](docs/UpdateAccessKeyRequest.md)
 - [UpdateAccessKeyResponse](docs/UpdateAccessKeyResponse.md)
 - [UpdateAccountRequest](docs/UpdateAccountRequest.md)
 - [UpdateAccountResponse](docs/UpdateAccountResponse.md)
 - [UpdateFlexibleGpuRequest](docs/UpdateFlexibleGpuRequest.md)
 - [UpdateFlexibleGpuResponse](docs/UpdateFlexibleGpuResponse.md)
 - [UpdateImageRequest](docs/UpdateImageRequest.md)
 - [UpdateImageResponse](docs/UpdateImageResponse.md)
 - [UpdateListenerRuleRequest](docs/UpdateListenerRuleRequest.md)
 - [UpdateListenerRuleResponse](docs/UpdateListenerRuleResponse.md)
 - [UpdateLoadBalancerRequest](docs/UpdateLoadBalancerRequest.md)
 - [UpdateLoadBalancerResponse](docs/UpdateLoadBalancerResponse.md)
 - [UpdateNetAccessPointRequest](docs/UpdateNetAccessPointRequest.md)
 - [UpdateNetAccessPointResponse](docs/UpdateNetAccessPointResponse.md)
 - [UpdateNetRequest](docs/UpdateNetRequest.md)
 - [UpdateNetResponse](docs/UpdateNetResponse.md)
 - [UpdateNicRequest](docs/UpdateNicRequest.md)
 - [UpdateNicResponse](docs/UpdateNicResponse.md)
 - [UpdateRoutePropagationRequest](docs/UpdateRoutePropagationRequest.md)
 - [UpdateRoutePropagationResponse](docs/UpdateRoutePropagationResponse.md)
 - [UpdateRouteRequest](docs/UpdateRouteRequest.md)
 - [UpdateRouteResponse](docs/UpdateRouteResponse.md)
 - [UpdateServerCertificateRequest](docs/UpdateServerCertificateRequest.md)
 - [UpdateServerCertificateResponse](docs/UpdateServerCertificateResponse.md)
 - [UpdateSnapshotRequest](docs/UpdateSnapshotRequest.md)
 - [UpdateSnapshotResponse](docs/UpdateSnapshotResponse.md)
 - [UpdateSubnetRequest](docs/UpdateSubnetRequest.md)
 - [UpdateSubnetResponse](docs/UpdateSubnetResponse.md)
 - [UpdateVmRequest](docs/UpdateVmRequest.md)
 - [UpdateVmResponse](docs/UpdateVmResponse.md)
 - [VirtualGateway](docs/VirtualGateway.md)
 - [Vm](docs/Vm.md)
 - [VmState](docs/VmState.md)
 - [VmStates](docs/VmStates.md)
 - [VmType](docs/VmType.md)
 - [Volume](docs/Volume.md)
 - [VpnConnection](docs/VpnConnection.md)
 - [With](docs/With.md)


## Documentation For Authorization



## ApiKeyAuth

- **Type**: API key

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextAPIKey, sw.APIKey{
    Key: "APIKEY",
    Prefix: "Bearer", // Omit if not necessary.
})
r, err := client.Service.Operation(auth, args)
```


Example

```golang
auth := context.WithValue(context.Background(), sw.ContextAWSv4, sw.AWSv4{
    AccessKey: "ACCESSKEYSTRING",
    SecretKey: "SECRETKEYSTRING",
})
r, err := client.Service.Operation(auth, args)
```

## Author

support@outscale.com

