// Package publicapi provides primitives to interact the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen DO NOT EDIT.
package publicapi

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"
	"time"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/pkg/errors"
)

// AntiAffinityGroup defines model for anti-affinity-group.
type AntiAffinityGroup struct {
	Description *string     `json:"description,omitempty"`
	Id          *string     `json:"id,omitempty"`
	Instances   *[]Instance `json:"instances,omitempty"`
	Name        *string     `json:"name,omitempty"`
}

// ElasticIp defines model for elastic-ip.
type ElasticIp struct {
	Id *string `json:"id,omitempty"`
	Ip *string `json:"ip,omitempty"`
}

// Event defines model for event.
type Event struct {
	Payload   *Event_Payload `json:"payload,omitempty"`
	Timestamp *time.Time     `json:"timestamp,omitempty"`
}

// Event_Payload defines model for Event.Payload.
type Event_Payload struct {
	AdditionalProperties map[string]interface{} `json:"-"`
}

// Healthcheck defines model for healthcheck.
type Healthcheck struct {
	Interval *int64  `json:"interval,omitempty"`
	Mode     string  `json:"mode"`
	Port     int64   `json:"port"`
	Retries  *int64  `json:"retries,omitempty"`
	Timeout  *int64  `json:"timeout,omitempty"`
	TlsSni   *string `json:"tls-sni,omitempty"`
	Uri      *string `json:"uri,omitempty"`
}

// Instance defines model for instance.
type Instance struct {
	Id   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
}

// InstancePool defines model for instance-pool.
type InstancePool struct {
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	Description        *string              `json:"description,omitempty"`
	DiskSize           *int64               `json:"disk-size,omitempty"`
	ElasticIps         *[]ElasticIp         `json:"elastic-ips,omitempty"`
	Id                 *string              `json:"id,omitempty"`
	InstanceType       *InstanceType        `json:"instance-type,omitempty"`
	Instances          *[]Instance          `json:"instances,omitempty"`
	Ipv6Enabled        *bool                `json:"ipv6-enabled,omitempty"`
	Manager            *Manager             `json:"manager,omitempty"`
	Name               *string              `json:"name,omitempty"`
	PrivateNetworks    *[]PrivateNetwork    `json:"private-networks,omitempty"`
	SecurityGroups     *[]SecurityGroup     `json:"security-groups,omitempty"`
	Size               *int64               `json:"size,omitempty"`
	SshKey             *SshKey              `json:"ssh-key,omitempty"`
	State              *string              `json:"state,omitempty"`
	Template           *Template            `json:"template,omitempty"`
	UserData           *string              `json:"user-data,omitempty"`
}

// InstanceType defines model for instance-type.
type InstanceType struct {
	Authorized *bool   `json:"authorized,omitempty"`
	Cpus       *int64  `json:"cpus,omitempty"`
	Family     *string `json:"family,omitempty"`
	Gpus       *int64  `json:"gpus,omitempty"`
	Id         *string `json:"id,omitempty"`
	Memory     *int64  `json:"memory,omitempty"`
	Size       *string `json:"size,omitempty"`
}

// LoadBalancer defines model for load-balancer.
type LoadBalancer struct {
	CreatedAt   *time.Time             `json:"created-at,omitempty"`
	Description *string                `json:"description,omitempty"`
	Id          *string                `json:"id,omitempty"`
	Ip          *string                `json:"ip,omitempty"`
	Name        *string                `json:"name,omitempty"`
	Services    *[]LoadBalancerService `json:"services,omitempty"`
	State       *string                `json:"state,omitempty"`
}

// LoadBalancerServerStatus defines model for load-balancer-server-status.
type LoadBalancerServerStatus struct {
	PublicIp *string `json:"public-ip,omitempty"`
	Status   *string `json:"status,omitempty"`
}

// LoadBalancerService defines model for load-balancer-service.
type LoadBalancerService struct {
	Description       *string                     `json:"description,omitempty"`
	Healthcheck       *Healthcheck                `json:"healthcheck,omitempty"`
	HealthcheckStatus *[]LoadBalancerServerStatus `json:"healthcheck-status,omitempty"`
	Id                *string                     `json:"id,omitempty"`
	InstancePool      *InstancePool               `json:"instance-pool,omitempty"`
	Name              *string                     `json:"name,omitempty"`
	Port              *int64                      `json:"port,omitempty"`
	Protocol          *string                     `json:"protocol,omitempty"`
	State             *string                     `json:"state,omitempty"`
	Strategy          *string                     `json:"strategy,omitempty"`
	TargetPort        *int64                      `json:"target-port,omitempty"`
}

// Manager defines model for manager.
type Manager struct {
	Id   *string `json:"id,omitempty"`
	Type *string `json:"type,omitempty"`
}

// Operation defines model for operation.
type Operation struct {
	Id        *string    `json:"id,omitempty"`
	Message   *string    `json:"message,omitempty"`
	Reason    *string    `json:"reason,omitempty"`
	Reference *Reference `json:"reference,omitempty"`
	State     *string    `json:"state,omitempty"`
}

// PrivateNetwork defines model for private-network.
type PrivateNetwork struct {
	Description *string `json:"description,omitempty"`
	EndIp       *string `json:"end-ip,omitempty"`
	Id          *string `json:"id,omitempty"`
	Name        *string `json:"name,omitempty"`
	Netmask     *string `json:"netmask,omitempty"`
	StartIp     *string `json:"start-ip,omitempty"`
}

// Reference defines model for reference.
type Reference struct {
	Command *string `json:"command,omitempty"`
	Id      *string `json:"id,omitempty"`
	Link    *string `json:"link,omitempty"`
}

// SecurityGroup defines model for security-group.
type SecurityGroup struct {
	Description *string              `json:"description,omitempty"`
	Id          *string              `json:"id,omitempty"`
	Name        *string              `json:"name,omitempty"`
	Rules       *[]SecurityGroupRule `json:"rules,omitempty"`
}

// SecurityGroupResource defines model for security-group-resource.
type SecurityGroupResource struct {
	Id   *string `json:"id,omitempty"`
	Name string  `json:"name"`
}

// SecurityGroupRule defines model for security-group-rule.
type SecurityGroupRule struct {
	Description   *string `json:"description,omitempty"`
	EndPort       *int64  `json:"end-port,omitempty"`
	FlowDirection *string `json:"flow-direction,omitempty"`
	Icmp          *struct {
		Code *int64 `json:"code,omitempty"`
		Type *int64 `json:"type,omitempty"`
	} `json:"icmp,omitempty"`
	Id            *string                `json:"id,omitempty"`
	Network       *string                `json:"network,omitempty"`
	Protocol      *string                `json:"protocol,omitempty"`
	SecurityGroup *SecurityGroupResource `json:"security-group,omitempty"`
	StartPort     *int64                 `json:"start-port,omitempty"`
}

// SksCluster defines model for sks-cluster.
type SksCluster struct {
	Addons      *[]string      `json:"addons,omitempty"`
	Cni         *string        `json:"cni,omitempty"`
	CreatedAt   *time.Time     `json:"created-at,omitempty"`
	Description *string        `json:"description,omitempty"`
	Endpoint    *string        `json:"endpoint,omitempty"`
	Id          *string        `json:"id,omitempty"`
	Level       *string        `json:"level,omitempty"`
	Name        *string        `json:"name,omitempty"`
	Nodepools   *[]SksNodepool `json:"nodepools,omitempty"`
	State       *string        `json:"state,omitempty"`
	Version     *string        `json:"version,omitempty"`
}

// SksKubeconfigRequest defines model for sks-kubeconfig-request.
type SksKubeconfigRequest struct {
	Groups *[]string `json:"groups,omitempty"`
	Ttl    *int64    `json:"ttl,omitempty"`
	User   *string   `json:"user,omitempty"`
}

// SksNodepool defines model for sks-nodepool.
type SksNodepool struct {
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	CreatedAt          *time.Time           `json:"created-at,omitempty"`
	Description        *string              `json:"description,omitempty"`
	DiskSize           *int64               `json:"disk-size,omitempty"`
	Id                 *string              `json:"id,omitempty"`
	InstancePool       *InstancePool        `json:"instance-pool,omitempty"`
	InstanceType       *InstanceType        `json:"instance-type,omitempty"`
	Name               *string              `json:"name,omitempty"`
	SecurityGroups     *[]SecurityGroup     `json:"security-groups,omitempty"`
	Size               *int64               `json:"size,omitempty"`
	State              *string              `json:"state,omitempty"`
	Template           *Template            `json:"template,omitempty"`
	Version            *string              `json:"version,omitempty"`
}

// Snapshot defines model for snapshot.
type Snapshot struct {
	CreatedAt   *time.Time `json:"created-at,omitempty"`
	Description *string    `json:"description,omitempty"`
	Export      *struct {
		Md5sum       *string `json:"md5sum,omitempty"`
		PresignedUrl *string `json:"presigned-url,omitempty"`
	} `json:"export,omitempty"`
	Id       *string   `json:"id,omitempty"`
	Instance *Instance `json:"instance,omitempty"`
	Name     *string   `json:"name,omitempty"`
	State    *string   `json:"state,omitempty"`
}

// SshKey defines model for ssh-key.
type SshKey struct {
	Fingerprint *string `json:"fingerprint,omitempty"`
	Name        *string `json:"name,omitempty"`
}

// Template defines model for template.
type Template struct {
	BootMode        *string    `json:"boot-mode,omitempty"`
	Build           *string    `json:"build,omitempty"`
	Checksum        *string    `json:"checksum,omitempty"`
	CreatedAt       *time.Time `json:"created-at,omitempty"`
	DefaultUser     *string    `json:"default-user,omitempty"`
	Description     *string    `json:"description,omitempty"`
	Family          *string    `json:"family,omitempty"`
	Id              *string    `json:"id,omitempty"`
	Name            *string    `json:"name,omitempty"`
	PasswordEnabled *bool      `json:"password-enabled,omitempty"`
	Size            *int64     `json:"size,omitempty"`
	SshKeyEnabled   *bool      `json:"ssh-key-enabled,omitempty"`
	Url             *string    `json:"url,omitempty"`
	Version         *string    `json:"version,omitempty"`
	Visibility      *string    `json:"visibility,omitempty"`
}

// Zone defines model for zone.
type Zone struct {
	Name *string `json:"name,omitempty"`
}

// CreateAntiAffinityGroupJSONBody defines parameters for CreateAntiAffinityGroup.
type CreateAntiAffinityGroupJSONBody struct {
	Description *string `json:"description,omitempty"`
	Name        string  `json:"name"`
}

// ListEventsParams defines parameters for ListEvents.
type ListEventsParams struct {
	From *time.Time `json:"from,omitempty"`
	To   *time.Time `json:"to,omitempty"`
}

// CreateInstanceJSONBody defines parameters for CreateInstance.
type CreateInstanceJSONBody Instance

// CreateInstanceParams defines parameters for CreateInstance.
type CreateInstanceParams struct {
	Start *bool `json:"start,omitempty"`
}

// CreateInstancePoolJSONBody defines parameters for CreateInstancePool.
type CreateInstancePoolJSONBody struct {
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	Description        *string              `json:"description,omitempty"`
	DiskSize           int64                `json:"disk-size"`
	ElasticIps         *[]ElasticIp         `json:"elastic-ips,omitempty"`
	InstanceType       InstanceType         `json:"instance-type"`
	Ipv6Enabled        *bool                `json:"ipv6-enabled,omitempty"`
	Name               string               `json:"name"`
	PrivateNetworks    *[]PrivateNetwork    `json:"private-networks,omitempty"`
	SecurityGroups     *[]SecurityGroup     `json:"security-groups,omitempty"`
	Size               int64                `json:"size"`
	SshKey             *SshKey              `json:"ssh-key,omitempty"`
	Template           Template             `json:"template"`
	UserData           *string              `json:"user-data,omitempty"`
}

// UpdateInstancePoolJSONBody defines parameters for UpdateInstancePool.
type UpdateInstancePoolJSONBody struct {
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	Description        *string              `json:"description,omitempty"`
	DiskSize           *int64               `json:"disk-size,omitempty"`
	ElasticIps         *[]ElasticIp         `json:"elastic-ips,omitempty"`
	InstanceType       *InstanceType        `json:"instance-type,omitempty"`
	Ipv6Enabled        *bool                `json:"ipv6-enabled,omitempty"`
	Name               *string              `json:"name,omitempty"`
	PrivateNetworks    *[]PrivateNetwork    `json:"private-networks,omitempty"`
	SecurityGroups     *[]SecurityGroup     `json:"security-groups,omitempty"`
	SshKey             *SshKey              `json:"ssh-key,omitempty"`
	Template           *Template            `json:"template,omitempty"`
	UserData           *string              `json:"user-data,omitempty"`
}

// EvictInstancePoolMembersJSONBody defines parameters for EvictInstancePoolMembers.
type EvictInstancePoolMembersJSONBody struct {
	Instances *[]string `json:"instances,omitempty"`
}

// ScaleInstancePoolJSONBody defines parameters for ScaleInstancePool.
type ScaleInstancePoolJSONBody struct {
	Size int64 `json:"size"`
}

// RevertInstanceToSnapshotJSONBody defines parameters for RevertInstanceToSnapshot.
type RevertInstanceToSnapshotJSONBody struct {
	Id string `json:"id"`
}

// CreateLoadBalancerJSONBody defines parameters for CreateLoadBalancer.
type CreateLoadBalancerJSONBody struct {
	Description *string `json:"description,omitempty"`
	Name        string  `json:"name"`
}

// UpdateLoadBalancerJSONBody defines parameters for UpdateLoadBalancer.
type UpdateLoadBalancerJSONBody struct {
	Description *string `json:"description,omitempty"`
	Name        *string `json:"name,omitempty"`
}

// AddServiceToLoadBalancerJSONBody defines parameters for AddServiceToLoadBalancer.
type AddServiceToLoadBalancerJSONBody struct {
	Description  *string      `json:"description,omitempty"`
	Healthcheck  Healthcheck  `json:"healthcheck"`
	InstancePool InstancePool `json:"instance-pool"`
	Name         string       `json:"name"`
	Port         int64        `json:"port"`
	Protocol     string       `json:"protocol"`
	Strategy     string       `json:"strategy"`
	TargetPort   int64        `json:"target-port"`
}

// UpdateLoadBalancerServiceJSONBody defines parameters for UpdateLoadBalancerService.
type UpdateLoadBalancerServiceJSONBody struct {
	Description *string      `json:"description,omitempty"`
	Healthcheck *Healthcheck `json:"healthcheck,omitempty"`
	Name        *string      `json:"name,omitempty"`
	Port        *int64       `json:"port,omitempty"`
	Protocol    *string      `json:"protocol,omitempty"`
	Strategy    *string      `json:"strategy,omitempty"`
	TargetPort  *int64       `json:"target-port,omitempty"`
}

// CreatePrivateNetworkJSONBody defines parameters for CreatePrivateNetwork.
type CreatePrivateNetworkJSONBody struct {
	Description *string `json:"description,omitempty"`
	EndIp       *string `json:"end-ip,omitempty"`
	Name        string  `json:"name"`
	Netmask     *string `json:"netmask,omitempty"`
	StartIp     *string `json:"start-ip,omitempty"`
}

// UpdatePrivateNetworkJSONBody defines parameters for UpdatePrivateNetwork.
type UpdatePrivateNetworkJSONBody struct {
	Description *string `json:"description,omitempty"`
	EndIp       *string `json:"end-ip,omitempty"`
	Name        *string `json:"name,omitempty"`
	Netmask     *string `json:"netmask,omitempty"`
	StartIp     *string `json:"start-ip,omitempty"`
}

// CreateSecurityGroupJSONBody defines parameters for CreateSecurityGroup.
type CreateSecurityGroupJSONBody struct {
	Description *string `json:"description,omitempty"`
	Name        string  `json:"name"`
}

// AddRuleToSecurityGroupJSONBody defines parameters for AddRuleToSecurityGroup.
type AddRuleToSecurityGroupJSONBody struct {
	Description   *string `json:"description,omitempty"`
	EndPort       *int64  `json:"end-port,omitempty"`
	FlowDirection string  `json:"flow-direction"`
	Icmp          *struct {
		Code *int64 `json:"code,omitempty"`
		Type *int64 `json:"type,omitempty"`
	} `json:"icmp,omitempty"`
	Network       *string                `json:"network,omitempty"`
	Protocol      *string                `json:"protocol,omitempty"`
	SecurityGroup *SecurityGroupResource `json:"security-group,omitempty"`
	StartPort     *int64                 `json:"start-port,omitempty"`
}

// CreateSksClusterJSONBody defines parameters for CreateSksCluster.
type CreateSksClusterJSONBody struct {
	Addons      *[]string `json:"addons,omitempty"`
	Cni         *string   `json:"cni,omitempty"`
	Description *string   `json:"description,omitempty"`
	Level       string    `json:"level"`
	Name        string    `json:"name"`
	Version     string    `json:"version"`
}

// GenerateSksClusterKubeconfigJSONBody defines parameters for GenerateSksClusterKubeconfig.
type GenerateSksClusterKubeconfigJSONBody SksKubeconfigRequest

// UpdateSksClusterJSONBody defines parameters for UpdateSksCluster.
type UpdateSksClusterJSONBody struct {
	Description *string `json:"description,omitempty"`
	Name        *string `json:"name,omitempty"`
}

// CreateSksNodepoolJSONBody defines parameters for CreateSksNodepool.
type CreateSksNodepoolJSONBody struct {
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	Description        *string              `json:"description,omitempty"`
	DiskSize           int64                `json:"disk-size"`
	InstanceType       InstanceType         `json:"instance-type"`
	Name               string               `json:"name"`
	SecurityGroups     *[]SecurityGroup     `json:"security-groups,omitempty"`
	Size               int64                `json:"size"`
}

// UpdateSksNodepoolJSONBody defines parameters for UpdateSksNodepool.
type UpdateSksNodepoolJSONBody struct {
	AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	Description        *string              `json:"description,omitempty"`
	DiskSize           *int64               `json:"disk-size,omitempty"`
	InstanceType       *InstanceType        `json:"instance-type,omitempty"`
	Name               *string              `json:"name,omitempty"`
	SecurityGroups     *[]SecurityGroup     `json:"security-groups,omitempty"`
}

// EvictSksNodepoolMembersJSONBody defines parameters for EvictSksNodepoolMembers.
type EvictSksNodepoolMembersJSONBody struct {
	Instances *[]string `json:"instances,omitempty"`
}

// ScaleSksNodepoolJSONBody defines parameters for ScaleSksNodepool.
type ScaleSksNodepoolJSONBody struct {
	Size int64 `json:"size"`
}

// UpgradeSksClusterJSONBody defines parameters for UpgradeSksCluster.
type UpgradeSksClusterJSONBody struct {
	Version string `json:"version"`
}

// GetSosPresignedUrlParams defines parameters for GetSosPresignedUrl.
type GetSosPresignedUrlParams struct {
	Key *string `json:"key,omitempty"`
}

// ListTemplatesParams defines parameters for ListTemplates.
type ListTemplatesParams struct {
	Visibility *string `json:"visibility,omitempty"`
	Family     *string `json:"family,omitempty"`
}

// RegisterTemplateJSONBody defines parameters for RegisterTemplate.
type RegisterTemplateJSONBody struct {
	BootMode        *string `json:"boot-mode,omitempty"`
	Checksum        string  `json:"checksum"`
	DefaultUser     *string `json:"default-user,omitempty"`
	Description     *string `json:"description,omitempty"`
	Name            string  `json:"name"`
	PasswordEnabled bool    `json:"password-enabled"`
	Size            *int64  `json:"size,omitempty"`
	SshKeyEnabled   bool    `json:"ssh-key-enabled"`
	Url             string  `json:"url"`
}

// CopyTemplateJSONBody defines parameters for CopyTemplate.
type CopyTemplateJSONBody struct {
	TargetZone string `json:"target-zone"`
}

// CreateAntiAffinityGroupRequestBody defines body for CreateAntiAffinityGroup for application/json ContentType.
type CreateAntiAffinityGroupJSONRequestBody CreateAntiAffinityGroupJSONBody

// CreateInstanceRequestBody defines body for CreateInstance for application/json ContentType.
type CreateInstanceJSONRequestBody CreateInstanceJSONBody

// CreateInstancePoolRequestBody defines body for CreateInstancePool for application/json ContentType.
type CreateInstancePoolJSONRequestBody CreateInstancePoolJSONBody

// UpdateInstancePoolRequestBody defines body for UpdateInstancePool for application/json ContentType.
type UpdateInstancePoolJSONRequestBody UpdateInstancePoolJSONBody

// EvictInstancePoolMembersRequestBody defines body for EvictInstancePoolMembers for application/json ContentType.
type EvictInstancePoolMembersJSONRequestBody EvictInstancePoolMembersJSONBody

// ScaleInstancePoolRequestBody defines body for ScaleInstancePool for application/json ContentType.
type ScaleInstancePoolJSONRequestBody ScaleInstancePoolJSONBody

// RevertInstanceToSnapshotRequestBody defines body for RevertInstanceToSnapshot for application/json ContentType.
type RevertInstanceToSnapshotJSONRequestBody RevertInstanceToSnapshotJSONBody

// CreateLoadBalancerRequestBody defines body for CreateLoadBalancer for application/json ContentType.
type CreateLoadBalancerJSONRequestBody CreateLoadBalancerJSONBody

// UpdateLoadBalancerRequestBody defines body for UpdateLoadBalancer for application/json ContentType.
type UpdateLoadBalancerJSONRequestBody UpdateLoadBalancerJSONBody

// AddServiceToLoadBalancerRequestBody defines body for AddServiceToLoadBalancer for application/json ContentType.
type AddServiceToLoadBalancerJSONRequestBody AddServiceToLoadBalancerJSONBody

// UpdateLoadBalancerServiceRequestBody defines body for UpdateLoadBalancerService for application/json ContentType.
type UpdateLoadBalancerServiceJSONRequestBody UpdateLoadBalancerServiceJSONBody

// CreatePrivateNetworkRequestBody defines body for CreatePrivateNetwork for application/json ContentType.
type CreatePrivateNetworkJSONRequestBody CreatePrivateNetworkJSONBody

// UpdatePrivateNetworkRequestBody defines body for UpdatePrivateNetwork for application/json ContentType.
type UpdatePrivateNetworkJSONRequestBody UpdatePrivateNetworkJSONBody

// CreateSecurityGroupRequestBody defines body for CreateSecurityGroup for application/json ContentType.
type CreateSecurityGroupJSONRequestBody CreateSecurityGroupJSONBody

// AddRuleToSecurityGroupRequestBody defines body for AddRuleToSecurityGroup for application/json ContentType.
type AddRuleToSecurityGroupJSONRequestBody AddRuleToSecurityGroupJSONBody

// CreateSksClusterRequestBody defines body for CreateSksCluster for application/json ContentType.
type CreateSksClusterJSONRequestBody CreateSksClusterJSONBody

// GenerateSksClusterKubeconfigRequestBody defines body for GenerateSksClusterKubeconfig for application/json ContentType.
type GenerateSksClusterKubeconfigJSONRequestBody GenerateSksClusterKubeconfigJSONBody

// UpdateSksClusterRequestBody defines body for UpdateSksCluster for application/json ContentType.
type UpdateSksClusterJSONRequestBody UpdateSksClusterJSONBody

// CreateSksNodepoolRequestBody defines body for CreateSksNodepool for application/json ContentType.
type CreateSksNodepoolJSONRequestBody CreateSksNodepoolJSONBody

// UpdateSksNodepoolRequestBody defines body for UpdateSksNodepool for application/json ContentType.
type UpdateSksNodepoolJSONRequestBody UpdateSksNodepoolJSONBody

// EvictSksNodepoolMembersRequestBody defines body for EvictSksNodepoolMembers for application/json ContentType.
type EvictSksNodepoolMembersJSONRequestBody EvictSksNodepoolMembersJSONBody

// ScaleSksNodepoolRequestBody defines body for ScaleSksNodepool for application/json ContentType.
type ScaleSksNodepoolJSONRequestBody ScaleSksNodepoolJSONBody

// UpgradeSksClusterRequestBody defines body for UpgradeSksCluster for application/json ContentType.
type UpgradeSksClusterJSONRequestBody UpgradeSksClusterJSONBody

// RegisterTemplateRequestBody defines body for RegisterTemplate for application/json ContentType.
type RegisterTemplateJSONRequestBody RegisterTemplateJSONBody

// CopyTemplateRequestBody defines body for CopyTemplate for application/json ContentType.
type CopyTemplateJSONRequestBody CopyTemplateJSONBody

// Getter for additional properties for Event_Payload. Returns the specified
// element and whether it was found
func (a Event_Payload) Get(fieldName string) (value interface{}, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for Event_Payload
func (a *Event_Payload) Set(fieldName string, value interface{}) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]interface{})
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for Event_Payload to handle AdditionalProperties
func (a *Event_Payload) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]interface{})
		for fieldName, fieldBuf := range object {
			var fieldVal interface{}
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return errors.Wrap(err, fmt.Sprintf("error unmarshaling field %s", fieldName))
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for Event_Payload to handle AdditionalProperties
func (a Event_Payload) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, errors.Wrap(err, fmt.Sprintf("error marshaling '%s'", fieldName))
		}
	}
	return json.Marshal(object)
}

// RequestEditorFn  is the function signature for the RequestEditor callback function
type RequestEditorFn func(ctx context.Context, req *http.Request) error

// Doer performs HTTP requests.
//
// The standard http.Client implements this interface.
type HttpRequestDoer interface {
	Do(req *http.Request) (*http.Response, error)
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example. This can contain a path relative
	// to the server, such as https://api.deepmap.com/dev-test, and all the
	// paths in the swagger spec will be appended to the server.
	Server string

	// Doer for performing requests, typically a *http.Client with any
	// customized settings, such as certificate chains.
	Client HttpRequestDoer

	// A callback for modifying requests which are generated before sending over
	// the network.
	RequestEditor RequestEditorFn
}

// ClientOption allows setting custom parameters during construction
type ClientOption func(*Client) error

// Creates a new Client, with reasonable defaults
func NewClient(server string, opts ...ClientOption) (*Client, error) {
	// create a client with sane default values
	client := Client{
		Server: server,
	}
	// mutate client and add all optional params
	for _, o := range opts {
		if err := o(&client); err != nil {
			return nil, err
		}
	}
	// ensure the server URL always has a trailing slash
	if !strings.HasSuffix(client.Server, "/") {
		client.Server += "/"
	}
	// create httpClient, if not already present
	if client.Client == nil {
		client.Client = http.DefaultClient
	}
	return &client, nil
}

// WithHTTPClient allows overriding the default Doer, which is
// automatically created using http.Client. This is useful for tests.
func WithHTTPClient(doer HttpRequestDoer) ClientOption {
	return func(c *Client) error {
		c.Client = doer
		return nil
	}
}

// WithRequestEditorFn allows setting up a callback function, which will be
// called right before sending the request. This can be used to mutate the request.
func WithRequestEditorFn(fn RequestEditorFn) ClientOption {
	return func(c *Client) error {
		c.RequestEditor = fn
		return nil
	}
}

// The interface specification for the client above.
type ClientInterface interface {
	// ListAntiAffinityGroups request
	ListAntiAffinityGroups(ctx context.Context) (*http.Response, error)

	// CreateAntiAffinityGroup request  with any body
	CreateAntiAffinityGroupWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateAntiAffinityGroup(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody) (*http.Response, error)

	// DeleteAntiAffinityGroup request
	DeleteAntiAffinityGroup(ctx context.Context, id string) (*http.Response, error)

	// GetAntiAffinityGroup request
	GetAntiAffinityGroup(ctx context.Context, id string) (*http.Response, error)

	// GetElasticIp request
	GetElasticIp(ctx context.Context, id string) (*http.Response, error)

	// ListEvents request
	ListEvents(ctx context.Context, params *ListEventsParams) (*http.Response, error)

	// CreateInstance request  with any body
	CreateInstanceWithBody(ctx context.Context, params *CreateInstanceParams, contentType string, body io.Reader) (*http.Response, error)

	CreateInstance(ctx context.Context, params *CreateInstanceParams, body CreateInstanceJSONRequestBody) (*http.Response, error)

	// ListInstancePools request
	ListInstancePools(ctx context.Context) (*http.Response, error)

	// CreateInstancePool request  with any body
	CreateInstancePoolWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateInstancePool(ctx context.Context, body CreateInstancePoolJSONRequestBody) (*http.Response, error)

	// DeleteInstancePool request
	DeleteInstancePool(ctx context.Context, id string) (*http.Response, error)

	// GetInstancePool request
	GetInstancePool(ctx context.Context, id string) (*http.Response, error)

	// UpdateInstancePool request  with any body
	UpdateInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	UpdateInstancePool(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody) (*http.Response, error)

	// DeleteInstancePoolField request
	DeleteInstancePoolField(ctx context.Context, id string, field string) (*http.Response, error)

	// EvictInstancePoolMembers request  with any body
	EvictInstancePoolMembersWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	EvictInstancePoolMembers(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody) (*http.Response, error)

	// ScaleInstancePool request  with any body
	ScaleInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	ScaleInstancePool(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody) (*http.Response, error)

	// ListInstanceTypes request
	ListInstanceTypes(ctx context.Context) (*http.Response, error)

	// GetInstanceType request
	GetInstanceType(ctx context.Context, id string) (*http.Response, error)

	// CreateSnapshot request
	CreateSnapshot(ctx context.Context, id string) (*http.Response, error)

	// RevertInstanceToSnapshot request  with any body
	RevertInstanceToSnapshotWithBody(ctx context.Context, instanceId string, contentType string, body io.Reader) (*http.Response, error)

	RevertInstanceToSnapshot(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody) (*http.Response, error)

	// ListLoadBalancers request
	ListLoadBalancers(ctx context.Context) (*http.Response, error)

	// CreateLoadBalancer request  with any body
	CreateLoadBalancerWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateLoadBalancer(ctx context.Context, body CreateLoadBalancerJSONRequestBody) (*http.Response, error)

	// DeleteLoadBalancer request
	DeleteLoadBalancer(ctx context.Context, id string) (*http.Response, error)

	// GetLoadBalancer request
	GetLoadBalancer(ctx context.Context, id string) (*http.Response, error)

	// UpdateLoadBalancer request  with any body
	UpdateLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	UpdateLoadBalancer(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody) (*http.Response, error)

	// AddServiceToLoadBalancer request  with any body
	AddServiceToLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	AddServiceToLoadBalancer(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody) (*http.Response, error)

	// DeleteLoadBalancerService request
	DeleteLoadBalancerService(ctx context.Context, id string, serviceId string) (*http.Response, error)

	// GetLoadBalancerService request
	GetLoadBalancerService(ctx context.Context, id string, serviceId string) (*http.Response, error)

	// UpdateLoadBalancerService request  with any body
	UpdateLoadBalancerServiceWithBody(ctx context.Context, id string, serviceId string, contentType string, body io.Reader) (*http.Response, error)

	UpdateLoadBalancerService(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody) (*http.Response, error)

	// GetOperation request
	GetOperation(ctx context.Context, id string) (*http.Response, error)

	// ListPrivateNetworks request
	ListPrivateNetworks(ctx context.Context) (*http.Response, error)

	// CreatePrivateNetwork request  with any body
	CreatePrivateNetworkWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreatePrivateNetwork(ctx context.Context, body CreatePrivateNetworkJSONRequestBody) (*http.Response, error)

	// DeletePrivateNetwork request
	DeletePrivateNetwork(ctx context.Context, id string) (*http.Response, error)

	// GetPrivateNetwork request
	GetPrivateNetwork(ctx context.Context, id string) (*http.Response, error)

	// UpdatePrivateNetwork request  with any body
	UpdatePrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	UpdatePrivateNetwork(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody) (*http.Response, error)

	// DeletePrivateNetworkField request
	DeletePrivateNetworkField(ctx context.Context, id string, field string) (*http.Response, error)

	// ListSecurityGroups request
	ListSecurityGroups(ctx context.Context) (*http.Response, error)

	// CreateSecurityGroup request  with any body
	CreateSecurityGroupWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateSecurityGroup(ctx context.Context, body CreateSecurityGroupJSONRequestBody) (*http.Response, error)

	// DeleteSecurityGroup request
	DeleteSecurityGroup(ctx context.Context, id string) (*http.Response, error)

	// GetSecurityGroup request
	GetSecurityGroup(ctx context.Context, id string) (*http.Response, error)

	// AddRuleToSecurityGroup request  with any body
	AddRuleToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	AddRuleToSecurityGroup(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody) (*http.Response, error)

	// DeleteRuleFromSecurityGroup request
	DeleteRuleFromSecurityGroup(ctx context.Context, id string, ruleId string) (*http.Response, error)

	// ListSksClusters request
	ListSksClusters(ctx context.Context) (*http.Response, error)

	// CreateSksCluster request  with any body
	CreateSksClusterWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateSksCluster(ctx context.Context, body CreateSksClusterJSONRequestBody) (*http.Response, error)

	// GenerateSksClusterKubeconfig request  with any body
	GenerateSksClusterKubeconfigWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	GenerateSksClusterKubeconfig(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody) (*http.Response, error)

	// ListSksClusterVersions request
	ListSksClusterVersions(ctx context.Context) (*http.Response, error)

	// DeleteSksCluster request
	DeleteSksCluster(ctx context.Context, id string) (*http.Response, error)

	// GetSksCluster request
	GetSksCluster(ctx context.Context, id string) (*http.Response, error)

	// UpdateSksCluster request  with any body
	UpdateSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	UpdateSksCluster(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody) (*http.Response, error)

	// CreateSksNodepool request  with any body
	CreateSksNodepoolWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	CreateSksNodepool(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody) (*http.Response, error)

	// DeleteSksNodepool request
	DeleteSksNodepool(ctx context.Context, id string, sksNodepoolId string) (*http.Response, error)

	// GetSksNodepool request
	GetSksNodepool(ctx context.Context, id string, sksNodepoolId string) (*http.Response, error)

	// UpdateSksNodepool request  with any body
	UpdateSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Response, error)

	UpdateSksNodepool(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody) (*http.Response, error)

	// DeleteSksNodepoolField request
	DeleteSksNodepoolField(ctx context.Context, id string, sksNodepoolId string, field string) (*http.Response, error)

	// EvictSksNodepoolMembers request  with any body
	EvictSksNodepoolMembersWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Response, error)

	EvictSksNodepoolMembers(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody) (*http.Response, error)

	// ScaleSksNodepool request  with any body
	ScaleSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Response, error)

	ScaleSksNodepool(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody) (*http.Response, error)

	// UpgradeSksCluster request  with any body
	UpgradeSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	UpgradeSksCluster(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody) (*http.Response, error)

	// DeleteSksClusterField request
	DeleteSksClusterField(ctx context.Context, id string, field string) (*http.Response, error)

	// ListSnapshots request
	ListSnapshots(ctx context.Context) (*http.Response, error)

	// DeleteSnapshot request
	DeleteSnapshot(ctx context.Context, id string) (*http.Response, error)

	// GetSnapshot request
	GetSnapshot(ctx context.Context, id string) (*http.Response, error)

	// ExportSnapshot request
	ExportSnapshot(ctx context.Context, id string) (*http.Response, error)

	// GetSosPresignedUrl request
	GetSosPresignedUrl(ctx context.Context, bucket string, params *GetSosPresignedUrlParams) (*http.Response, error)

	// GetSshKey request
	GetSshKey(ctx context.Context, name string) (*http.Response, error)

	// ListTemplates request
	ListTemplates(ctx context.Context, params *ListTemplatesParams) (*http.Response, error)

	// RegisterTemplate request  with any body
	RegisterTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	RegisterTemplate(ctx context.Context, body RegisterTemplateJSONRequestBody) (*http.Response, error)

	// DeleteTemplate request
	DeleteTemplate(ctx context.Context, id string) (*http.Response, error)

	// GetTemplate request
	GetTemplate(ctx context.Context, id string) (*http.Response, error)

	// CopyTemplate request  with any body
	CopyTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error)

	CopyTemplate(ctx context.Context, id string, body CopyTemplateJSONRequestBody) (*http.Response, error)

	// ListZones request
	ListZones(ctx context.Context) (*http.Response, error)
}

func (c *Client) ListAntiAffinityGroups(ctx context.Context) (*http.Response, error) {
	req, err := NewListAntiAffinityGroupsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateAntiAffinityGroupWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateAntiAffinityGroupRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateAntiAffinityGroup(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateAntiAffinityGroupRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteAntiAffinityGroup(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeleteAntiAffinityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetAntiAffinityGroup(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetAntiAffinityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetElasticIp(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetElasticIpRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListEvents(ctx context.Context, params *ListEventsParams) (*http.Response, error) {
	req, err := NewListEventsRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstanceWithBody(ctx context.Context, params *CreateInstanceParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateInstanceRequestWithBody(c.Server, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstance(ctx context.Context, params *CreateInstanceParams, body CreateInstanceJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateInstanceRequest(c.Server, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListInstancePools(ctx context.Context) (*http.Response, error) {
	req, err := NewListInstancePoolsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstancePoolWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateInstancePoolRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateInstancePool(ctx context.Context, body CreateInstancePoolJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateInstancePoolRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteInstancePool(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeleteInstancePoolRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetInstancePool(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetInstancePoolRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdateInstancePoolRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateInstancePool(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdateInstancePoolRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteInstancePoolField(ctx context.Context, id string, field string) (*http.Response, error) {
	req, err := NewDeleteInstancePoolFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) EvictInstancePoolMembersWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewEvictInstancePoolMembersRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) EvictInstancePoolMembers(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewEvictInstancePoolMembersRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleInstancePoolWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewScaleInstancePoolRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleInstancePool(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody) (*http.Response, error) {
	req, err := NewScaleInstancePoolRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListInstanceTypes(ctx context.Context) (*http.Response, error) {
	req, err := NewListInstanceTypesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetInstanceType(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetInstanceTypeRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSnapshot(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewCreateSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) RevertInstanceToSnapshotWithBody(ctx context.Context, instanceId string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewRevertInstanceToSnapshotRequestWithBody(c.Server, instanceId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) RevertInstanceToSnapshot(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody) (*http.Response, error) {
	req, err := NewRevertInstanceToSnapshotRequest(c.Server, instanceId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListLoadBalancers(ctx context.Context) (*http.Response, error) {
	req, err := NewListLoadBalancersRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateLoadBalancerWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateLoadBalancerRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateLoadBalancer(ctx context.Context, body CreateLoadBalancerJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateLoadBalancerRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteLoadBalancer(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeleteLoadBalancerRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetLoadBalancer(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetLoadBalancerRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancer(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) AddServiceToLoadBalancerWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewAddServiceToLoadBalancerRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) AddServiceToLoadBalancer(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody) (*http.Response, error) {
	req, err := NewAddServiceToLoadBalancerRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteLoadBalancerService(ctx context.Context, id string, serviceId string) (*http.Response, error) {
	req, err := NewDeleteLoadBalancerServiceRequest(c.Server, id, serviceId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetLoadBalancerService(ctx context.Context, id string, serviceId string) (*http.Response, error) {
	req, err := NewGetLoadBalancerServiceRequest(c.Server, id, serviceId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancerServiceWithBody(ctx context.Context, id string, serviceId string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerServiceRequestWithBody(c.Server, id, serviceId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateLoadBalancerService(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdateLoadBalancerServiceRequest(c.Server, id, serviceId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetOperation(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetOperationRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListPrivateNetworks(ctx context.Context) (*http.Response, error) {
	req, err := NewListPrivateNetworksRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreatePrivateNetworkWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreatePrivateNetworkRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreatePrivateNetwork(ctx context.Context, body CreatePrivateNetworkJSONRequestBody) (*http.Response, error) {
	req, err := NewCreatePrivateNetworkRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeletePrivateNetwork(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeletePrivateNetworkRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetPrivateNetwork(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetPrivateNetworkRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdatePrivateNetworkWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdatePrivateNetworkRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdatePrivateNetwork(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdatePrivateNetworkRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeletePrivateNetworkField(ctx context.Context, id string, field string) (*http.Response, error) {
	req, err := NewDeletePrivateNetworkFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListSecurityGroups(ctx context.Context) (*http.Response, error) {
	req, err := NewListSecurityGroupsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSecurityGroupWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateSecurityGroupRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSecurityGroup(ctx context.Context, body CreateSecurityGroupJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateSecurityGroupRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSecurityGroup(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeleteSecurityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetSecurityGroup(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetSecurityGroupRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) AddRuleToSecurityGroupWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewAddRuleToSecurityGroupRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) AddRuleToSecurityGroup(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody) (*http.Response, error) {
	req, err := NewAddRuleToSecurityGroupRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteRuleFromSecurityGroup(ctx context.Context, id string, ruleId string) (*http.Response, error) {
	req, err := NewDeleteRuleFromSecurityGroupRequest(c.Server, id, ruleId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListSksClusters(ctx context.Context) (*http.Response, error) {
	req, err := NewListSksClustersRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksClusterWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateSksClusterRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksCluster(ctx context.Context, body CreateSksClusterJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateSksClusterRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GenerateSksClusterKubeconfigWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewGenerateSksClusterKubeconfigRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GenerateSksClusterKubeconfig(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody) (*http.Response, error) {
	req, err := NewGenerateSksClusterKubeconfigRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListSksClusterVersions(ctx context.Context) (*http.Response, error) {
	req, err := NewListSksClusterVersionsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSksCluster(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeleteSksClusterRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetSksCluster(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetSksClusterRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdateSksClusterRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksCluster(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdateSksClusterRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksNodepoolWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateSksNodepoolRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CreateSksNodepool(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateSksNodepoolRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSksNodepool(ctx context.Context, id string, sksNodepoolId string) (*http.Response, error) {
	req, err := NewDeleteSksNodepoolRequest(c.Server, id, sksNodepoolId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetSksNodepool(ctx context.Context, id string, sksNodepoolId string) (*http.Response, error) {
	req, err := NewGetSksNodepoolRequest(c.Server, id, sksNodepoolId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdateSksNodepoolRequestWithBody(c.Server, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpdateSksNodepool(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdateSksNodepoolRequest(c.Server, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSksNodepoolField(ctx context.Context, id string, sksNodepoolId string, field string) (*http.Response, error) {
	req, err := NewDeleteSksNodepoolFieldRequest(c.Server, id, sksNodepoolId, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) EvictSksNodepoolMembersWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewEvictSksNodepoolMembersRequestWithBody(c.Server, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) EvictSksNodepoolMembers(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewEvictSksNodepoolMembersRequest(c.Server, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleSksNodepoolWithBody(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewScaleSksNodepoolRequestWithBody(c.Server, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ScaleSksNodepool(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody) (*http.Response, error) {
	req, err := NewScaleSksNodepoolRequest(c.Server, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpgradeSksClusterWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpgradeSksClusterRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) UpgradeSksCluster(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody) (*http.Response, error) {
	req, err := NewUpgradeSksClusterRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSksClusterField(ctx context.Context, id string, field string) (*http.Response, error) {
	req, err := NewDeleteSksClusterFieldRequest(c.Server, id, field)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListSnapshots(ctx context.Context) (*http.Response, error) {
	req, err := NewListSnapshotsRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteSnapshot(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeleteSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetSnapshot(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ExportSnapshot(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewExportSnapshotRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetSosPresignedUrl(ctx context.Context, bucket string, params *GetSosPresignedUrlParams) (*http.Response, error) {
	req, err := NewGetSosPresignedUrlRequest(c.Server, bucket, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetSshKey(ctx context.Context, name string) (*http.Response, error) {
	req, err := NewGetSshKeyRequest(c.Server, name)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListTemplates(ctx context.Context, params *ListTemplatesParams) (*http.Response, error) {
	req, err := NewListTemplatesRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) RegisterTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewRegisterTemplateRequestWithBody(c.Server, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) RegisterTemplate(ctx context.Context, body RegisterTemplateJSONRequestBody) (*http.Response, error) {
	req, err := NewRegisterTemplateRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) DeleteTemplate(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewDeleteTemplateRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) GetTemplate(ctx context.Context, id string) (*http.Response, error) {
	req, err := NewGetTemplateRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CopyTemplateWithBody(ctx context.Context, id string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCopyTemplateRequestWithBody(c.Server, id, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) CopyTemplate(ctx context.Context, id string, body CopyTemplateJSONRequestBody) (*http.Response, error) {
	req, err := NewCopyTemplateRequest(c.Server, id, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

func (c *Client) ListZones(ctx context.Context) (*http.Response, error) {
	req, err := NewListZonesRequest(c.Server)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(ctx, req)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// NewListAntiAffinityGroupsRequest generates requests for ListAntiAffinityGroups
func NewListAntiAffinityGroupsRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/anti-affinity-group")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateAntiAffinityGroupRequest calls the generic CreateAntiAffinityGroup builder with application/json body
func NewCreateAntiAffinityGroupRequest(server string, body CreateAntiAffinityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateAntiAffinityGroupRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateAntiAffinityGroupRequestWithBody generates requests for CreateAntiAffinityGroup with any type of body
func NewCreateAntiAffinityGroupRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/anti-affinity-group")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteAntiAffinityGroupRequest generates requests for DeleteAntiAffinityGroup
func NewDeleteAntiAffinityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/anti-affinity-group/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetAntiAffinityGroupRequest generates requests for GetAntiAffinityGroup
func NewGetAntiAffinityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/anti-affinity-group/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetElasticIpRequest generates requests for GetElasticIp
func NewGetElasticIpRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/elastic-ip/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListEventsRequest generates requests for ListEvents
func NewListEventsRequest(server string, params *ListEventsParams) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/event")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryUrl.Query()

	if params.From != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "from", *params.From); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.To != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "to", *params.To); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryUrl.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateInstanceRequest calls the generic CreateInstance builder with application/json body
func NewCreateInstanceRequest(server string, params *CreateInstanceParams, body CreateInstanceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateInstanceRequestWithBody(server, params, "application/json", bodyReader)
}

// NewCreateInstanceRequestWithBody generates requests for CreateInstance with any type of body
func NewCreateInstanceRequestWithBody(server string, params *CreateInstanceParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryUrl.Query()

	if params.Start != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "start", *params.Start); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryUrl.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewListInstancePoolsRequest generates requests for ListInstancePools
func NewListInstancePoolsRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateInstancePoolRequest calls the generic CreateInstancePool builder with application/json body
func NewCreateInstancePoolRequest(server string, body CreateInstancePoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateInstancePoolRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateInstancePoolRequestWithBody generates requests for CreateInstancePool with any type of body
func NewCreateInstancePoolRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteInstancePoolRequest generates requests for DeleteInstancePool
func NewDeleteInstancePoolRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetInstancePoolRequest generates requests for GetInstancePool
func NewGetInstancePoolRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateInstancePoolRequest calls the generic UpdateInstancePool builder with application/json body
func NewUpdateInstancePoolRequest(server string, id string, body UpdateInstancePoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateInstancePoolRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateInstancePoolRequestWithBody generates requests for UpdateInstancePool with any type of body
func NewUpdateInstancePoolRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteInstancePoolFieldRequest generates requests for DeleteInstancePoolField
func NewDeleteInstancePoolFieldRequest(server string, id string, field string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "field", field)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool/%s/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewEvictInstancePoolMembersRequest calls the generic EvictInstancePoolMembers builder with application/json body
func NewEvictInstancePoolMembersRequest(server string, id string, body EvictInstancePoolMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewEvictInstancePoolMembersRequestWithBody(server, id, "application/json", bodyReader)
}

// NewEvictInstancePoolMembersRequestWithBody generates requests for EvictInstancePoolMembers with any type of body
func NewEvictInstancePoolMembersRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool/%s:evict", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewScaleInstancePoolRequest calls the generic ScaleInstancePool builder with application/json body
func NewScaleInstancePoolRequest(server string, id string, body ScaleInstancePoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewScaleInstancePoolRequestWithBody(server, id, "application/json", bodyReader)
}

// NewScaleInstancePoolRequestWithBody generates requests for ScaleInstancePool with any type of body
func NewScaleInstancePoolRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-pool/%s:scale", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewListInstanceTypesRequest generates requests for ListInstanceTypes
func NewListInstanceTypesRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-type")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetInstanceTypeRequest generates requests for GetInstanceType
func NewGetInstanceTypeRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance-type/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSnapshotRequest generates requests for CreateSnapshot
func NewCreateSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance/%s:create-snapshot", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRevertInstanceToSnapshotRequest calls the generic RevertInstanceToSnapshot builder with application/json body
func NewRevertInstanceToSnapshotRequest(server string, instanceId string, body RevertInstanceToSnapshotJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewRevertInstanceToSnapshotRequestWithBody(server, instanceId, "application/json", bodyReader)
}

// NewRevertInstanceToSnapshotRequestWithBody generates requests for RevertInstanceToSnapshot with any type of body
func NewRevertInstanceToSnapshotRequestWithBody(server string, instanceId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "instance-id", instanceId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/instance/%s:revert-snapshot", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewListLoadBalancersRequest generates requests for ListLoadBalancers
func NewListLoadBalancersRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateLoadBalancerRequest calls the generic CreateLoadBalancer builder with application/json body
func NewCreateLoadBalancerRequest(server string, body CreateLoadBalancerJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateLoadBalancerRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateLoadBalancerRequestWithBody generates requests for CreateLoadBalancer with any type of body
func NewCreateLoadBalancerRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteLoadBalancerRequest generates requests for DeleteLoadBalancer
func NewDeleteLoadBalancerRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLoadBalancerRequest generates requests for GetLoadBalancer
func NewGetLoadBalancerRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateLoadBalancerRequest calls the generic UpdateLoadBalancer builder with application/json body
func NewUpdateLoadBalancerRequest(server string, id string, body UpdateLoadBalancerJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateLoadBalancerRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateLoadBalancerRequestWithBody generates requests for UpdateLoadBalancer with any type of body
func NewUpdateLoadBalancerRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewAddServiceToLoadBalancerRequest calls the generic AddServiceToLoadBalancer builder with application/json body
func NewAddServiceToLoadBalancerRequest(server string, id string, body AddServiceToLoadBalancerJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAddServiceToLoadBalancerRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAddServiceToLoadBalancerRequestWithBody generates requests for AddServiceToLoadBalancer with any type of body
func NewAddServiceToLoadBalancerRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer/%s/service", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteLoadBalancerServiceRequest generates requests for DeleteLoadBalancerService
func NewDeleteLoadBalancerServiceRequest(server string, id string, serviceId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "service-id", serviceId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer/%s/service/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLoadBalancerServiceRequest generates requests for GetLoadBalancerService
func NewGetLoadBalancerServiceRequest(server string, id string, serviceId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "service-id", serviceId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer/%s/service/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateLoadBalancerServiceRequest calls the generic UpdateLoadBalancerService builder with application/json body
func NewUpdateLoadBalancerServiceRequest(server string, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateLoadBalancerServiceRequestWithBody(server, id, serviceId, "application/json", bodyReader)
}

// NewUpdateLoadBalancerServiceRequestWithBody generates requests for UpdateLoadBalancerService with any type of body
func NewUpdateLoadBalancerServiceRequestWithBody(server string, id string, serviceId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "service-id", serviceId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/load-balancer/%s/service/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetOperationRequest generates requests for GetOperation
func NewGetOperationRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/operation/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListPrivateNetworksRequest generates requests for ListPrivateNetworks
func NewListPrivateNetworksRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/private-network")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreatePrivateNetworkRequest calls the generic CreatePrivateNetwork builder with application/json body
func NewCreatePrivateNetworkRequest(server string, body CreatePrivateNetworkJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreatePrivateNetworkRequestWithBody(server, "application/json", bodyReader)
}

// NewCreatePrivateNetworkRequestWithBody generates requests for CreatePrivateNetwork with any type of body
func NewCreatePrivateNetworkRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/private-network")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeletePrivateNetworkRequest generates requests for DeletePrivateNetwork
func NewDeletePrivateNetworkRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/private-network/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetPrivateNetworkRequest generates requests for GetPrivateNetwork
func NewGetPrivateNetworkRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/private-network/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdatePrivateNetworkRequest calls the generic UpdatePrivateNetwork builder with application/json body
func NewUpdatePrivateNetworkRequest(server string, id string, body UpdatePrivateNetworkJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdatePrivateNetworkRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdatePrivateNetworkRequestWithBody generates requests for UpdatePrivateNetwork with any type of body
func NewUpdatePrivateNetworkRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/private-network/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeletePrivateNetworkFieldRequest generates requests for DeletePrivateNetworkField
func NewDeletePrivateNetworkFieldRequest(server string, id string, field string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "field", field)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/private-network/%s/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListSecurityGroupsRequest generates requests for ListSecurityGroups
func NewListSecurityGroupsRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/security-group")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSecurityGroupRequest calls the generic CreateSecurityGroup builder with application/json body
func NewCreateSecurityGroupRequest(server string, body CreateSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSecurityGroupRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateSecurityGroupRequestWithBody generates requests for CreateSecurityGroup with any type of body
func NewCreateSecurityGroupRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/security-group")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteSecurityGroupRequest generates requests for DeleteSecurityGroup
func NewDeleteSecurityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/security-group/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSecurityGroupRequest generates requests for GetSecurityGroup
func NewGetSecurityGroupRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/security-group/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewAddRuleToSecurityGroupRequest calls the generic AddRuleToSecurityGroup builder with application/json body
func NewAddRuleToSecurityGroupRequest(server string, id string, body AddRuleToSecurityGroupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewAddRuleToSecurityGroupRequestWithBody(server, id, "application/json", bodyReader)
}

// NewAddRuleToSecurityGroupRequestWithBody generates requests for AddRuleToSecurityGroup with any type of body
func NewAddRuleToSecurityGroupRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/security-group/%s/rules", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteRuleFromSecurityGroupRequest generates requests for DeleteRuleFromSecurityGroup
func NewDeleteRuleFromSecurityGroupRequest(server string, id string, ruleId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "rule-id", ruleId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/security-group/%s/rules/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListSksClustersRequest generates requests for ListSksClusters
func NewListSksClustersRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateSksClusterRequest calls the generic CreateSksCluster builder with application/json body
func NewCreateSksClusterRequest(server string, body CreateSksClusterJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSksClusterRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateSksClusterRequestWithBody generates requests for CreateSksCluster with any type of body
func NewCreateSksClusterRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGenerateSksClusterKubeconfigRequest calls the generic GenerateSksClusterKubeconfig builder with application/json body
func NewGenerateSksClusterKubeconfigRequest(server string, id string, body GenerateSksClusterKubeconfigJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewGenerateSksClusterKubeconfigRequestWithBody(server, id, "application/json", bodyReader)
}

// NewGenerateSksClusterKubeconfigRequestWithBody generates requests for GenerateSksClusterKubeconfig with any type of body
func NewGenerateSksClusterKubeconfigRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster-kubeconfig/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewListSksClusterVersionsRequest generates requests for ListSksClusterVersions
func NewListSksClusterVersionsRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster-version")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteSksClusterRequest generates requests for DeleteSksCluster
func NewDeleteSksClusterRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSksClusterRequest generates requests for GetSksCluster
func NewGetSksClusterRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateSksClusterRequest calls the generic UpdateSksCluster builder with application/json body
func NewUpdateSksClusterRequest(server string, id string, body UpdateSksClusterJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateSksClusterRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpdateSksClusterRequestWithBody generates requests for UpdateSksCluster with any type of body
func NewUpdateSksClusterRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewCreateSksNodepoolRequest calls the generic CreateSksNodepool builder with application/json body
func NewCreateSksNodepoolRequest(server string, id string, body CreateSksNodepoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateSksNodepoolRequestWithBody(server, id, "application/json", bodyReader)
}

// NewCreateSksNodepoolRequestWithBody generates requests for CreateSksNodepool with any type of body
func NewCreateSksNodepoolRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/nodepool", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteSksNodepoolRequest generates requests for DeleteSksNodepool
func NewDeleteSksNodepoolRequest(server string, id string, sksNodepoolId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "sks-nodepool-id", sksNodepoolId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSksNodepoolRequest generates requests for GetSksNodepool
func NewGetSksNodepoolRequest(server string, id string, sksNodepoolId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "sks-nodepool-id", sksNodepoolId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateSksNodepoolRequest calls the generic UpdateSksNodepool builder with application/json body
func NewUpdateSksNodepoolRequest(server string, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateSksNodepoolRequestWithBody(server, id, sksNodepoolId, "application/json", bodyReader)
}

// NewUpdateSksNodepoolRequestWithBody generates requests for UpdateSksNodepool with any type of body
func NewUpdateSksNodepoolRequestWithBody(server string, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "sks-nodepool-id", sksNodepoolId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteSksNodepoolFieldRequest generates requests for DeleteSksNodepoolField
func NewDeleteSksNodepoolFieldRequest(server string, id string, sksNodepoolId string, field string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "sks-nodepool-id", sksNodepoolId)
	if err != nil {
		return nil, err
	}

	var pathParam2 string

	pathParam2, err = runtime.StyleParam("simple", false, "field", field)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s/%s", pathParam0, pathParam1, pathParam2)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewEvictSksNodepoolMembersRequest calls the generic EvictSksNodepoolMembers builder with application/json body
func NewEvictSksNodepoolMembersRequest(server string, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewEvictSksNodepoolMembersRequestWithBody(server, id, sksNodepoolId, "application/json", bodyReader)
}

// NewEvictSksNodepoolMembersRequestWithBody generates requests for EvictSksNodepoolMembers with any type of body
func NewEvictSksNodepoolMembersRequestWithBody(server string, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "sks-nodepool-id", sksNodepoolId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s:evict", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewScaleSksNodepoolRequest calls the generic ScaleSksNodepool builder with application/json body
func NewScaleSksNodepoolRequest(server string, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewScaleSksNodepoolRequestWithBody(server, id, sksNodepoolId, "application/json", bodyReader)
}

// NewScaleSksNodepoolRequestWithBody generates requests for ScaleSksNodepool with any type of body
func NewScaleSksNodepoolRequestWithBody(server string, id string, sksNodepoolId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "sks-nodepool-id", sksNodepoolId)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/nodepool/%s:scale", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewUpgradeSksClusterRequest calls the generic UpgradeSksCluster builder with application/json body
func NewUpgradeSksClusterRequest(server string, id string, body UpgradeSksClusterJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpgradeSksClusterRequestWithBody(server, id, "application/json", bodyReader)
}

// NewUpgradeSksClusterRequestWithBody generates requests for UpgradeSksCluster with any type of body
func NewUpgradeSksClusterRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/upgrade", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteSksClusterFieldRequest generates requests for DeleteSksClusterField
func NewDeleteSksClusterFieldRequest(server string, id string, field string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "field", field)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sks-cluster/%s/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListSnapshotsRequest generates requests for ListSnapshots
func NewListSnapshotsRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/snapshot")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewDeleteSnapshotRequest generates requests for DeleteSnapshot
func NewDeleteSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/snapshot/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSnapshotRequest generates requests for GetSnapshot
func NewGetSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/snapshot/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewExportSnapshotRequest generates requests for ExportSnapshot
func NewExportSnapshotRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/snapshot/%s:export", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSosPresignedUrlRequest generates requests for GetSosPresignedUrl
func NewGetSosPresignedUrlRequest(server string, bucket string, params *GetSosPresignedUrlParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucket", bucket)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sos/%s/presigned-url", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryUrl.Query()

	if params.Key != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "key", *params.Key); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryUrl.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSshKeyRequest generates requests for GetSshKey
func NewGetSshKeyRequest(server string, name string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "name", name)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/ssh-key/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewListTemplatesRequest generates requests for ListTemplates
func NewListTemplatesRequest(server string, params *ListTemplatesParams) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/template")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryUrl.Query()

	if params.Visibility != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "visibility", *params.Visibility); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Family != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "family", *params.Family); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryUrl.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewRegisterTemplateRequest calls the generic RegisterTemplate builder with application/json body
func NewRegisterTemplateRequest(server string, body RegisterTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewRegisterTemplateRequestWithBody(server, "application/json", bodyReader)
}

// NewRegisterTemplateRequestWithBody generates requests for RegisterTemplate with any type of body
func NewRegisterTemplateRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/template")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTemplateRequest generates requests for DeleteTemplate
func NewDeleteTemplateRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/template/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetTemplateRequest generates requests for GetTemplate
func NewGetTemplateRequest(server string, id string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/template/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCopyTemplateRequest calls the generic CopyTemplate builder with application/json body
func NewCopyTemplateRequest(server string, id string, body CopyTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCopyTemplateRequestWithBody(server, id, "application/json", bodyReader)
}

// NewCopyTemplateRequestWithBody generates requests for CopyTemplate with any type of body
func NewCopyTemplateRequestWithBody(server string, id string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/template/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryUrl.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewListZonesRequest generates requests for ListZones
func NewListZonesRequest(server string) (*http.Request, error) {
	var err error

	queryUrl, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/zone")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryUrl, err = queryUrl.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryUrl.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(server string, opts ...ClientOption) (*ClientWithResponses, error) {
	client, err := NewClient(server, opts...)
	if err != nil {
		return nil, err
	}
	return &ClientWithResponses{client}, nil
}

// WithBaseURL overrides the baseURL.
func WithBaseURL(baseURL string) ClientOption {
	return func(c *Client) error {
		newBaseURL, err := url.Parse(baseURL)
		if err != nil {
			return err
		}
		c.Server = newBaseURL.String()
		return nil
	}
}

// ClientWithResponsesInterface is the interface specification for the client with responses above.
type ClientWithResponsesInterface interface {
	// ListAntiAffinityGroups request
	ListAntiAffinityGroupsWithResponse(ctx context.Context) (*ListAntiAffinityGroupsResponse, error)

	// CreateAntiAffinityGroup request  with any body
	CreateAntiAffinityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateAntiAffinityGroupResponse, error)

	CreateAntiAffinityGroupWithResponse(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody) (*CreateAntiAffinityGroupResponse, error)

	// DeleteAntiAffinityGroup request
	DeleteAntiAffinityGroupWithResponse(ctx context.Context, id string) (*DeleteAntiAffinityGroupResponse, error)

	// GetAntiAffinityGroup request
	GetAntiAffinityGroupWithResponse(ctx context.Context, id string) (*GetAntiAffinityGroupResponse, error)

	// GetElasticIp request
	GetElasticIpWithResponse(ctx context.Context, id string) (*GetElasticIpResponse, error)

	// ListEvents request
	ListEventsWithResponse(ctx context.Context, params *ListEventsParams) (*ListEventsResponse, error)

	// CreateInstance request  with any body
	CreateInstanceWithBodyWithResponse(ctx context.Context, params *CreateInstanceParams, contentType string, body io.Reader) (*CreateInstanceResponse, error)

	CreateInstanceWithResponse(ctx context.Context, params *CreateInstanceParams, body CreateInstanceJSONRequestBody) (*CreateInstanceResponse, error)

	// ListInstancePools request
	ListInstancePoolsWithResponse(ctx context.Context) (*ListInstancePoolsResponse, error)

	// CreateInstancePool request  with any body
	CreateInstancePoolWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateInstancePoolResponse, error)

	CreateInstancePoolWithResponse(ctx context.Context, body CreateInstancePoolJSONRequestBody) (*CreateInstancePoolResponse, error)

	// DeleteInstancePool request
	DeleteInstancePoolWithResponse(ctx context.Context, id string) (*DeleteInstancePoolResponse, error)

	// GetInstancePool request
	GetInstancePoolWithResponse(ctx context.Context, id string) (*GetInstancePoolResponse, error)

	// UpdateInstancePool request  with any body
	UpdateInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdateInstancePoolResponse, error)

	UpdateInstancePoolWithResponse(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody) (*UpdateInstancePoolResponse, error)

	// DeleteInstancePoolField request
	DeleteInstancePoolFieldWithResponse(ctx context.Context, id string, field string) (*DeleteInstancePoolFieldResponse, error)

	// EvictInstancePoolMembers request  with any body
	EvictInstancePoolMembersWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*EvictInstancePoolMembersResponse, error)

	EvictInstancePoolMembersWithResponse(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody) (*EvictInstancePoolMembersResponse, error)

	// ScaleInstancePool request  with any body
	ScaleInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*ScaleInstancePoolResponse, error)

	ScaleInstancePoolWithResponse(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody) (*ScaleInstancePoolResponse, error)

	// ListInstanceTypes request
	ListInstanceTypesWithResponse(ctx context.Context) (*ListInstanceTypesResponse, error)

	// GetInstanceType request
	GetInstanceTypeWithResponse(ctx context.Context, id string) (*GetInstanceTypeResponse, error)

	// CreateSnapshot request
	CreateSnapshotWithResponse(ctx context.Context, id string) (*CreateSnapshotResponse, error)

	// RevertInstanceToSnapshot request  with any body
	RevertInstanceToSnapshotWithBodyWithResponse(ctx context.Context, instanceId string, contentType string, body io.Reader) (*RevertInstanceToSnapshotResponse, error)

	RevertInstanceToSnapshotWithResponse(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody) (*RevertInstanceToSnapshotResponse, error)

	// ListLoadBalancers request
	ListLoadBalancersWithResponse(ctx context.Context) (*ListLoadBalancersResponse, error)

	// CreateLoadBalancer request  with any body
	CreateLoadBalancerWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateLoadBalancerResponse, error)

	CreateLoadBalancerWithResponse(ctx context.Context, body CreateLoadBalancerJSONRequestBody) (*CreateLoadBalancerResponse, error)

	// DeleteLoadBalancer request
	DeleteLoadBalancerWithResponse(ctx context.Context, id string) (*DeleteLoadBalancerResponse, error)

	// GetLoadBalancer request
	GetLoadBalancerWithResponse(ctx context.Context, id string) (*GetLoadBalancerResponse, error)

	// UpdateLoadBalancer request  with any body
	UpdateLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdateLoadBalancerResponse, error)

	UpdateLoadBalancerWithResponse(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody) (*UpdateLoadBalancerResponse, error)

	// AddServiceToLoadBalancer request  with any body
	AddServiceToLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*AddServiceToLoadBalancerResponse, error)

	AddServiceToLoadBalancerWithResponse(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody) (*AddServiceToLoadBalancerResponse, error)

	// DeleteLoadBalancerService request
	DeleteLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string) (*DeleteLoadBalancerServiceResponse, error)

	// GetLoadBalancerService request
	GetLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string) (*GetLoadBalancerServiceResponse, error)

	// UpdateLoadBalancerService request  with any body
	UpdateLoadBalancerServiceWithBodyWithResponse(ctx context.Context, id string, serviceId string, contentType string, body io.Reader) (*UpdateLoadBalancerServiceResponse, error)

	UpdateLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody) (*UpdateLoadBalancerServiceResponse, error)

	// GetOperation request
	GetOperationWithResponse(ctx context.Context, id string) (*GetOperationResponse, error)

	// ListPrivateNetworks request
	ListPrivateNetworksWithResponse(ctx context.Context) (*ListPrivateNetworksResponse, error)

	// CreatePrivateNetwork request  with any body
	CreatePrivateNetworkWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreatePrivateNetworkResponse, error)

	CreatePrivateNetworkWithResponse(ctx context.Context, body CreatePrivateNetworkJSONRequestBody) (*CreatePrivateNetworkResponse, error)

	// DeletePrivateNetwork request
	DeletePrivateNetworkWithResponse(ctx context.Context, id string) (*DeletePrivateNetworkResponse, error)

	// GetPrivateNetwork request
	GetPrivateNetworkWithResponse(ctx context.Context, id string) (*GetPrivateNetworkResponse, error)

	// UpdatePrivateNetwork request  with any body
	UpdatePrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdatePrivateNetworkResponse, error)

	UpdatePrivateNetworkWithResponse(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody) (*UpdatePrivateNetworkResponse, error)

	// DeletePrivateNetworkField request
	DeletePrivateNetworkFieldWithResponse(ctx context.Context, id string, field string) (*DeletePrivateNetworkFieldResponse, error)

	// ListSecurityGroups request
	ListSecurityGroupsWithResponse(ctx context.Context) (*ListSecurityGroupsResponse, error)

	// CreateSecurityGroup request  with any body
	CreateSecurityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateSecurityGroupResponse, error)

	CreateSecurityGroupWithResponse(ctx context.Context, body CreateSecurityGroupJSONRequestBody) (*CreateSecurityGroupResponse, error)

	// DeleteSecurityGroup request
	DeleteSecurityGroupWithResponse(ctx context.Context, id string) (*DeleteSecurityGroupResponse, error)

	// GetSecurityGroup request
	GetSecurityGroupWithResponse(ctx context.Context, id string) (*GetSecurityGroupResponse, error)

	// AddRuleToSecurityGroup request  with any body
	AddRuleToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*AddRuleToSecurityGroupResponse, error)

	AddRuleToSecurityGroupWithResponse(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody) (*AddRuleToSecurityGroupResponse, error)

	// DeleteRuleFromSecurityGroup request
	DeleteRuleFromSecurityGroupWithResponse(ctx context.Context, id string, ruleId string) (*DeleteRuleFromSecurityGroupResponse, error)

	// ListSksClusters request
	ListSksClustersWithResponse(ctx context.Context) (*ListSksClustersResponse, error)

	// CreateSksCluster request  with any body
	CreateSksClusterWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateSksClusterResponse, error)

	CreateSksClusterWithResponse(ctx context.Context, body CreateSksClusterJSONRequestBody) (*CreateSksClusterResponse, error)

	// GenerateSksClusterKubeconfig request  with any body
	GenerateSksClusterKubeconfigWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*GenerateSksClusterKubeconfigResponse, error)

	GenerateSksClusterKubeconfigWithResponse(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody) (*GenerateSksClusterKubeconfigResponse, error)

	// ListSksClusterVersions request
	ListSksClusterVersionsWithResponse(ctx context.Context) (*ListSksClusterVersionsResponse, error)

	// DeleteSksCluster request
	DeleteSksClusterWithResponse(ctx context.Context, id string) (*DeleteSksClusterResponse, error)

	// GetSksCluster request
	GetSksClusterWithResponse(ctx context.Context, id string) (*GetSksClusterResponse, error)

	// UpdateSksCluster request  with any body
	UpdateSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdateSksClusterResponse, error)

	UpdateSksClusterWithResponse(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody) (*UpdateSksClusterResponse, error)

	// CreateSksNodepool request  with any body
	CreateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*CreateSksNodepoolResponse, error)

	CreateSksNodepoolWithResponse(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody) (*CreateSksNodepoolResponse, error)

	// DeleteSksNodepool request
	DeleteSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string) (*DeleteSksNodepoolResponse, error)

	// GetSksNodepool request
	GetSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string) (*GetSksNodepoolResponse, error)

	// UpdateSksNodepool request  with any body
	UpdateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*UpdateSksNodepoolResponse, error)

	UpdateSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody) (*UpdateSksNodepoolResponse, error)

	// DeleteSksNodepoolField request
	DeleteSksNodepoolFieldWithResponse(ctx context.Context, id string, sksNodepoolId string, field string) (*DeleteSksNodepoolFieldResponse, error)

	// EvictSksNodepoolMembers request  with any body
	EvictSksNodepoolMembersWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*EvictSksNodepoolMembersResponse, error)

	EvictSksNodepoolMembersWithResponse(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody) (*EvictSksNodepoolMembersResponse, error)

	// ScaleSksNodepool request  with any body
	ScaleSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*ScaleSksNodepoolResponse, error)

	ScaleSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody) (*ScaleSksNodepoolResponse, error)

	// UpgradeSksCluster request  with any body
	UpgradeSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpgradeSksClusterResponse, error)

	UpgradeSksClusterWithResponse(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody) (*UpgradeSksClusterResponse, error)

	// DeleteSksClusterField request
	DeleteSksClusterFieldWithResponse(ctx context.Context, id string, field string) (*DeleteSksClusterFieldResponse, error)

	// ListSnapshots request
	ListSnapshotsWithResponse(ctx context.Context) (*ListSnapshotsResponse, error)

	// DeleteSnapshot request
	DeleteSnapshotWithResponse(ctx context.Context, id string) (*DeleteSnapshotResponse, error)

	// GetSnapshot request
	GetSnapshotWithResponse(ctx context.Context, id string) (*GetSnapshotResponse, error)

	// ExportSnapshot request
	ExportSnapshotWithResponse(ctx context.Context, id string) (*ExportSnapshotResponse, error)

	// GetSosPresignedUrl request
	GetSosPresignedUrlWithResponse(ctx context.Context, bucket string, params *GetSosPresignedUrlParams) (*GetSosPresignedUrlResponse, error)

	// GetSshKey request
	GetSshKeyWithResponse(ctx context.Context, name string) (*GetSshKeyResponse, error)

	// ListTemplates request
	ListTemplatesWithResponse(ctx context.Context, params *ListTemplatesParams) (*ListTemplatesResponse, error)

	// RegisterTemplate request  with any body
	RegisterTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*RegisterTemplateResponse, error)

	RegisterTemplateWithResponse(ctx context.Context, body RegisterTemplateJSONRequestBody) (*RegisterTemplateResponse, error)

	// DeleteTemplate request
	DeleteTemplateWithResponse(ctx context.Context, id string) (*DeleteTemplateResponse, error)

	// GetTemplate request
	GetTemplateWithResponse(ctx context.Context, id string) (*GetTemplateResponse, error)

	// CopyTemplate request  with any body
	CopyTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*CopyTemplateResponse, error)

	CopyTemplateWithResponse(ctx context.Context, id string, body CopyTemplateJSONRequestBody) (*CopyTemplateResponse, error)

	// ListZones request
	ListZonesWithResponse(ctx context.Context) (*ListZonesResponse, error)
}

type ListAntiAffinityGroupsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListAntiAffinityGroupsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListAntiAffinityGroupsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateAntiAffinityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateAntiAffinityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateAntiAffinityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteAntiAffinityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteAntiAffinityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteAntiAffinityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetAntiAffinityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *AntiAffinityGroup
}

// Status returns HTTPResponse.Status
func (r GetAntiAffinityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetAntiAffinityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetElasticIpResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ElasticIp
}

// Status returns HTTPResponse.Status
func (r GetElasticIpResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetElasticIpResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListEventsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]Event
}

// Status returns HTTPResponse.Status
func (r ListEventsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListEventsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateInstanceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateInstanceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateInstanceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListInstancePoolsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		InstancePools *[]InstancePool `json:"instance-pools,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListInstancePoolsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListInstancePoolsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *InstancePool
}

// Status returns HTTPResponse.Status
func (r GetInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteInstancePoolFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteInstancePoolFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteInstancePoolFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type EvictInstancePoolMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r EvictInstancePoolMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r EvictInstancePoolMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ScaleInstancePoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ScaleInstancePoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ScaleInstancePoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListInstanceTypesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		InstanceTypes *[]InstanceType `json:"instance-types,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListInstanceTypesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListInstanceTypesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetInstanceTypeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *InstanceType
}

// Status returns HTTPResponse.Status
func (r GetInstanceTypeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetInstanceTypeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RevertInstanceToSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RevertInstanceToSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RevertInstanceToSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListLoadBalancersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		LoadBalancers *[]LoadBalancer `json:"load-balancers,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListLoadBalancersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListLoadBalancersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LoadBalancer
}

// Status returns HTTPResponse.Status
func (r GetLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AddServiceToLoadBalancerResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AddServiceToLoadBalancerResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AddServiceToLoadBalancerResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteLoadBalancerServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteLoadBalancerServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteLoadBalancerServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLoadBalancerServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LoadBalancerService
}

// Status returns HTTPResponse.Status
func (r GetLoadBalancerServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLoadBalancerServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateLoadBalancerServiceResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateLoadBalancerServiceResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateLoadBalancerServiceResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetOperationResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r GetOperationResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetOperationResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListPrivateNetworksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		PrivateNetworks *[]PrivateNetwork `json:"private-networks,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListPrivateNetworksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListPrivateNetworksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreatePrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreatePrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreatePrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeletePrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeletePrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeletePrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetPrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *PrivateNetwork
}

// Status returns HTTPResponse.Status
func (r GetPrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetPrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdatePrivateNetworkResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdatePrivateNetworkResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdatePrivateNetworkResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeletePrivateNetworkFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeletePrivateNetworkFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeletePrivateNetworkFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSecurityGroupsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSecurityGroupsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSecurityGroupsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SecurityGroup
}

// Status returns HTTPResponse.Status
func (r GetSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type AddRuleToSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r AddRuleToSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r AddRuleToSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteRuleFromSecurityGroupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteRuleFromSecurityGroupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteRuleFromSecurityGroupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSksClustersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SksClusters *[]SksCluster `json:"sks-clusters,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSksClustersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSksClustersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GenerateSksClusterKubeconfigResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Kubeconfig *string `json:"kubeconfig,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GenerateSksClusterKubeconfigResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GenerateSksClusterKubeconfigResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSksClusterVersionsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		SksClusterVersions *[]string `json:"sks-cluster-versions,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSksClusterVersionsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSksClusterVersionsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SksCluster
}

// Status returns HTTPResponse.Status
func (r GetSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CreateSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SksNodepool
}

// Status returns HTTPResponse.Status
func (r GetSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpdateSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSksNodepoolFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSksNodepoolFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSksNodepoolFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type EvictSksNodepoolMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r EvictSksNodepoolMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r EvictSksNodepoolMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ScaleSksNodepoolResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ScaleSksNodepoolResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ScaleSksNodepoolResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpgradeSksClusterResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r UpgradeSksClusterResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpgradeSksClusterResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSksClusterFieldResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSksClusterFieldResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSksClusterFieldResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListSnapshotsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Snapshots *[]Snapshot `json:"snapshots,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListSnapshotsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListSnapshotsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Snapshot
}

// Status returns HTTPResponse.Status
func (r GetSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ExportSnapshotResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r ExportSnapshotResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ExportSnapshotResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSosPresignedUrlResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Url *string `json:"url,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r GetSosPresignedUrlResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSosPresignedUrlResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSshKeyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SshKey
}

// Status returns HTTPResponse.Status
func (r GetSshKeyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSshKeyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListTemplatesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Templates *[]Template `json:"templates,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListTemplatesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListTemplatesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type RegisterTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r RegisterTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r RegisterTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r DeleteTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Template
}

// Status returns HTTPResponse.Status
func (r GetTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CopyTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Operation
}

// Status returns HTTPResponse.Status
func (r CopyTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CopyTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListZonesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Zones *[]Zone `json:"zones,omitempty"`
	}
}

// Status returns HTTPResponse.Status
func (r ListZonesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListZonesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ListAntiAffinityGroupsWithResponse request returning *ListAntiAffinityGroupsResponse
func (c *ClientWithResponses) ListAntiAffinityGroupsWithResponse(ctx context.Context) (*ListAntiAffinityGroupsResponse, error) {
	rsp, err := c.ListAntiAffinityGroups(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListAntiAffinityGroupsResponse(rsp)
}

// CreateAntiAffinityGroupWithBodyWithResponse request with arbitrary body returning *CreateAntiAffinityGroupResponse
func (c *ClientWithResponses) CreateAntiAffinityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateAntiAffinityGroupResponse, error) {
	rsp, err := c.CreateAntiAffinityGroupWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateAntiAffinityGroupResponse(rsp)
}

func (c *ClientWithResponses) CreateAntiAffinityGroupWithResponse(ctx context.Context, body CreateAntiAffinityGroupJSONRequestBody) (*CreateAntiAffinityGroupResponse, error) {
	rsp, err := c.CreateAntiAffinityGroup(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateAntiAffinityGroupResponse(rsp)
}

// DeleteAntiAffinityGroupWithResponse request returning *DeleteAntiAffinityGroupResponse
func (c *ClientWithResponses) DeleteAntiAffinityGroupWithResponse(ctx context.Context, id string) (*DeleteAntiAffinityGroupResponse, error) {
	rsp, err := c.DeleteAntiAffinityGroup(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeleteAntiAffinityGroupResponse(rsp)
}

// GetAntiAffinityGroupWithResponse request returning *GetAntiAffinityGroupResponse
func (c *ClientWithResponses) GetAntiAffinityGroupWithResponse(ctx context.Context, id string) (*GetAntiAffinityGroupResponse, error) {
	rsp, err := c.GetAntiAffinityGroup(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetAntiAffinityGroupResponse(rsp)
}

// GetElasticIpWithResponse request returning *GetElasticIpResponse
func (c *ClientWithResponses) GetElasticIpWithResponse(ctx context.Context, id string) (*GetElasticIpResponse, error) {
	rsp, err := c.GetElasticIp(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetElasticIpResponse(rsp)
}

// ListEventsWithResponse request returning *ListEventsResponse
func (c *ClientWithResponses) ListEventsWithResponse(ctx context.Context, params *ListEventsParams) (*ListEventsResponse, error) {
	rsp, err := c.ListEvents(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseListEventsResponse(rsp)
}

// CreateInstanceWithBodyWithResponse request with arbitrary body returning *CreateInstanceResponse
func (c *ClientWithResponses) CreateInstanceWithBodyWithResponse(ctx context.Context, params *CreateInstanceParams, contentType string, body io.Reader) (*CreateInstanceResponse, error) {
	rsp, err := c.CreateInstanceWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstanceResponse(rsp)
}

func (c *ClientWithResponses) CreateInstanceWithResponse(ctx context.Context, params *CreateInstanceParams, body CreateInstanceJSONRequestBody) (*CreateInstanceResponse, error) {
	rsp, err := c.CreateInstance(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstanceResponse(rsp)
}

// ListInstancePoolsWithResponse request returning *ListInstancePoolsResponse
func (c *ClientWithResponses) ListInstancePoolsWithResponse(ctx context.Context) (*ListInstancePoolsResponse, error) {
	rsp, err := c.ListInstancePools(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListInstancePoolsResponse(rsp)
}

// CreateInstancePoolWithBodyWithResponse request with arbitrary body returning *CreateInstancePoolResponse
func (c *ClientWithResponses) CreateInstancePoolWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateInstancePoolResponse, error) {
	rsp, err := c.CreateInstancePoolWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstancePoolResponse(rsp)
}

func (c *ClientWithResponses) CreateInstancePoolWithResponse(ctx context.Context, body CreateInstancePoolJSONRequestBody) (*CreateInstancePoolResponse, error) {
	rsp, err := c.CreateInstancePool(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateInstancePoolResponse(rsp)
}

// DeleteInstancePoolWithResponse request returning *DeleteInstancePoolResponse
func (c *ClientWithResponses) DeleteInstancePoolWithResponse(ctx context.Context, id string) (*DeleteInstancePoolResponse, error) {
	rsp, err := c.DeleteInstancePool(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeleteInstancePoolResponse(rsp)
}

// GetInstancePoolWithResponse request returning *GetInstancePoolResponse
func (c *ClientWithResponses) GetInstancePoolWithResponse(ctx context.Context, id string) (*GetInstancePoolResponse, error) {
	rsp, err := c.GetInstancePool(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetInstancePoolResponse(rsp)
}

// UpdateInstancePoolWithBodyWithResponse request with arbitrary body returning *UpdateInstancePoolResponse
func (c *ClientWithResponses) UpdateInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdateInstancePoolResponse, error) {
	rsp, err := c.UpdateInstancePoolWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateInstancePoolResponse(rsp)
}

func (c *ClientWithResponses) UpdateInstancePoolWithResponse(ctx context.Context, id string, body UpdateInstancePoolJSONRequestBody) (*UpdateInstancePoolResponse, error) {
	rsp, err := c.UpdateInstancePool(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateInstancePoolResponse(rsp)
}

// DeleteInstancePoolFieldWithResponse request returning *DeleteInstancePoolFieldResponse
func (c *ClientWithResponses) DeleteInstancePoolFieldWithResponse(ctx context.Context, id string, field string) (*DeleteInstancePoolFieldResponse, error) {
	rsp, err := c.DeleteInstancePoolField(ctx, id, field)
	if err != nil {
		return nil, err
	}
	return ParseDeleteInstancePoolFieldResponse(rsp)
}

// EvictInstancePoolMembersWithBodyWithResponse request with arbitrary body returning *EvictInstancePoolMembersResponse
func (c *ClientWithResponses) EvictInstancePoolMembersWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*EvictInstancePoolMembersResponse, error) {
	rsp, err := c.EvictInstancePoolMembersWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseEvictInstancePoolMembersResponse(rsp)
}

func (c *ClientWithResponses) EvictInstancePoolMembersWithResponse(ctx context.Context, id string, body EvictInstancePoolMembersJSONRequestBody) (*EvictInstancePoolMembersResponse, error) {
	rsp, err := c.EvictInstancePoolMembers(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseEvictInstancePoolMembersResponse(rsp)
}

// ScaleInstancePoolWithBodyWithResponse request with arbitrary body returning *ScaleInstancePoolResponse
func (c *ClientWithResponses) ScaleInstancePoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*ScaleInstancePoolResponse, error) {
	rsp, err := c.ScaleInstancePoolWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseScaleInstancePoolResponse(rsp)
}

func (c *ClientWithResponses) ScaleInstancePoolWithResponse(ctx context.Context, id string, body ScaleInstancePoolJSONRequestBody) (*ScaleInstancePoolResponse, error) {
	rsp, err := c.ScaleInstancePool(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseScaleInstancePoolResponse(rsp)
}

// ListInstanceTypesWithResponse request returning *ListInstanceTypesResponse
func (c *ClientWithResponses) ListInstanceTypesWithResponse(ctx context.Context) (*ListInstanceTypesResponse, error) {
	rsp, err := c.ListInstanceTypes(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListInstanceTypesResponse(rsp)
}

// GetInstanceTypeWithResponse request returning *GetInstanceTypeResponse
func (c *ClientWithResponses) GetInstanceTypeWithResponse(ctx context.Context, id string) (*GetInstanceTypeResponse, error) {
	rsp, err := c.GetInstanceType(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetInstanceTypeResponse(rsp)
}

// CreateSnapshotWithResponse request returning *CreateSnapshotResponse
func (c *ClientWithResponses) CreateSnapshotWithResponse(ctx context.Context, id string) (*CreateSnapshotResponse, error) {
	rsp, err := c.CreateSnapshot(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseCreateSnapshotResponse(rsp)
}

// RevertInstanceToSnapshotWithBodyWithResponse request with arbitrary body returning *RevertInstanceToSnapshotResponse
func (c *ClientWithResponses) RevertInstanceToSnapshotWithBodyWithResponse(ctx context.Context, instanceId string, contentType string, body io.Reader) (*RevertInstanceToSnapshotResponse, error) {
	rsp, err := c.RevertInstanceToSnapshotWithBody(ctx, instanceId, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseRevertInstanceToSnapshotResponse(rsp)
}

func (c *ClientWithResponses) RevertInstanceToSnapshotWithResponse(ctx context.Context, instanceId string, body RevertInstanceToSnapshotJSONRequestBody) (*RevertInstanceToSnapshotResponse, error) {
	rsp, err := c.RevertInstanceToSnapshot(ctx, instanceId, body)
	if err != nil {
		return nil, err
	}
	return ParseRevertInstanceToSnapshotResponse(rsp)
}

// ListLoadBalancersWithResponse request returning *ListLoadBalancersResponse
func (c *ClientWithResponses) ListLoadBalancersWithResponse(ctx context.Context) (*ListLoadBalancersResponse, error) {
	rsp, err := c.ListLoadBalancers(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListLoadBalancersResponse(rsp)
}

// CreateLoadBalancerWithBodyWithResponse request with arbitrary body returning *CreateLoadBalancerResponse
func (c *ClientWithResponses) CreateLoadBalancerWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateLoadBalancerResponse, error) {
	rsp, err := c.CreateLoadBalancerWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateLoadBalancerResponse(rsp)
}

func (c *ClientWithResponses) CreateLoadBalancerWithResponse(ctx context.Context, body CreateLoadBalancerJSONRequestBody) (*CreateLoadBalancerResponse, error) {
	rsp, err := c.CreateLoadBalancer(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateLoadBalancerResponse(rsp)
}

// DeleteLoadBalancerWithResponse request returning *DeleteLoadBalancerResponse
func (c *ClientWithResponses) DeleteLoadBalancerWithResponse(ctx context.Context, id string) (*DeleteLoadBalancerResponse, error) {
	rsp, err := c.DeleteLoadBalancer(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeleteLoadBalancerResponse(rsp)
}

// GetLoadBalancerWithResponse request returning *GetLoadBalancerResponse
func (c *ClientWithResponses) GetLoadBalancerWithResponse(ctx context.Context, id string) (*GetLoadBalancerResponse, error) {
	rsp, err := c.GetLoadBalancer(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetLoadBalancerResponse(rsp)
}

// UpdateLoadBalancerWithBodyWithResponse request with arbitrary body returning *UpdateLoadBalancerResponse
func (c *ClientWithResponses) UpdateLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdateLoadBalancerResponse, error) {
	rsp, err := c.UpdateLoadBalancerWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerResponse(rsp)
}

func (c *ClientWithResponses) UpdateLoadBalancerWithResponse(ctx context.Context, id string, body UpdateLoadBalancerJSONRequestBody) (*UpdateLoadBalancerResponse, error) {
	rsp, err := c.UpdateLoadBalancer(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerResponse(rsp)
}

// AddServiceToLoadBalancerWithBodyWithResponse request with arbitrary body returning *AddServiceToLoadBalancerResponse
func (c *ClientWithResponses) AddServiceToLoadBalancerWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*AddServiceToLoadBalancerResponse, error) {
	rsp, err := c.AddServiceToLoadBalancerWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseAddServiceToLoadBalancerResponse(rsp)
}

func (c *ClientWithResponses) AddServiceToLoadBalancerWithResponse(ctx context.Context, id string, body AddServiceToLoadBalancerJSONRequestBody) (*AddServiceToLoadBalancerResponse, error) {
	rsp, err := c.AddServiceToLoadBalancer(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseAddServiceToLoadBalancerResponse(rsp)
}

// DeleteLoadBalancerServiceWithResponse request returning *DeleteLoadBalancerServiceResponse
func (c *ClientWithResponses) DeleteLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string) (*DeleteLoadBalancerServiceResponse, error) {
	rsp, err := c.DeleteLoadBalancerService(ctx, id, serviceId)
	if err != nil {
		return nil, err
	}
	return ParseDeleteLoadBalancerServiceResponse(rsp)
}

// GetLoadBalancerServiceWithResponse request returning *GetLoadBalancerServiceResponse
func (c *ClientWithResponses) GetLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string) (*GetLoadBalancerServiceResponse, error) {
	rsp, err := c.GetLoadBalancerService(ctx, id, serviceId)
	if err != nil {
		return nil, err
	}
	return ParseGetLoadBalancerServiceResponse(rsp)
}

// UpdateLoadBalancerServiceWithBodyWithResponse request with arbitrary body returning *UpdateLoadBalancerServiceResponse
func (c *ClientWithResponses) UpdateLoadBalancerServiceWithBodyWithResponse(ctx context.Context, id string, serviceId string, contentType string, body io.Reader) (*UpdateLoadBalancerServiceResponse, error) {
	rsp, err := c.UpdateLoadBalancerServiceWithBody(ctx, id, serviceId, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerServiceResponse(rsp)
}

func (c *ClientWithResponses) UpdateLoadBalancerServiceWithResponse(ctx context.Context, id string, serviceId string, body UpdateLoadBalancerServiceJSONRequestBody) (*UpdateLoadBalancerServiceResponse, error) {
	rsp, err := c.UpdateLoadBalancerService(ctx, id, serviceId, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateLoadBalancerServiceResponse(rsp)
}

// GetOperationWithResponse request returning *GetOperationResponse
func (c *ClientWithResponses) GetOperationWithResponse(ctx context.Context, id string) (*GetOperationResponse, error) {
	rsp, err := c.GetOperation(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetOperationResponse(rsp)
}

// ListPrivateNetworksWithResponse request returning *ListPrivateNetworksResponse
func (c *ClientWithResponses) ListPrivateNetworksWithResponse(ctx context.Context) (*ListPrivateNetworksResponse, error) {
	rsp, err := c.ListPrivateNetworks(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListPrivateNetworksResponse(rsp)
}

// CreatePrivateNetworkWithBodyWithResponse request with arbitrary body returning *CreatePrivateNetworkResponse
func (c *ClientWithResponses) CreatePrivateNetworkWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreatePrivateNetworkResponse, error) {
	rsp, err := c.CreatePrivateNetworkWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreatePrivateNetworkResponse(rsp)
}

func (c *ClientWithResponses) CreatePrivateNetworkWithResponse(ctx context.Context, body CreatePrivateNetworkJSONRequestBody) (*CreatePrivateNetworkResponse, error) {
	rsp, err := c.CreatePrivateNetwork(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreatePrivateNetworkResponse(rsp)
}

// DeletePrivateNetworkWithResponse request returning *DeletePrivateNetworkResponse
func (c *ClientWithResponses) DeletePrivateNetworkWithResponse(ctx context.Context, id string) (*DeletePrivateNetworkResponse, error) {
	rsp, err := c.DeletePrivateNetwork(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeletePrivateNetworkResponse(rsp)
}

// GetPrivateNetworkWithResponse request returning *GetPrivateNetworkResponse
func (c *ClientWithResponses) GetPrivateNetworkWithResponse(ctx context.Context, id string) (*GetPrivateNetworkResponse, error) {
	rsp, err := c.GetPrivateNetwork(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetPrivateNetworkResponse(rsp)
}

// UpdatePrivateNetworkWithBodyWithResponse request with arbitrary body returning *UpdatePrivateNetworkResponse
func (c *ClientWithResponses) UpdatePrivateNetworkWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdatePrivateNetworkResponse, error) {
	rsp, err := c.UpdatePrivateNetworkWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdatePrivateNetworkResponse(rsp)
}

func (c *ClientWithResponses) UpdatePrivateNetworkWithResponse(ctx context.Context, id string, body UpdatePrivateNetworkJSONRequestBody) (*UpdatePrivateNetworkResponse, error) {
	rsp, err := c.UpdatePrivateNetwork(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdatePrivateNetworkResponse(rsp)
}

// DeletePrivateNetworkFieldWithResponse request returning *DeletePrivateNetworkFieldResponse
func (c *ClientWithResponses) DeletePrivateNetworkFieldWithResponse(ctx context.Context, id string, field string) (*DeletePrivateNetworkFieldResponse, error) {
	rsp, err := c.DeletePrivateNetworkField(ctx, id, field)
	if err != nil {
		return nil, err
	}
	return ParseDeletePrivateNetworkFieldResponse(rsp)
}

// ListSecurityGroupsWithResponse request returning *ListSecurityGroupsResponse
func (c *ClientWithResponses) ListSecurityGroupsWithResponse(ctx context.Context) (*ListSecurityGroupsResponse, error) {
	rsp, err := c.ListSecurityGroups(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListSecurityGroupsResponse(rsp)
}

// CreateSecurityGroupWithBodyWithResponse request with arbitrary body returning *CreateSecurityGroupResponse
func (c *ClientWithResponses) CreateSecurityGroupWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateSecurityGroupResponse, error) {
	rsp, err := c.CreateSecurityGroupWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) CreateSecurityGroupWithResponse(ctx context.Context, body CreateSecurityGroupJSONRequestBody) (*CreateSecurityGroupResponse, error) {
	rsp, err := c.CreateSecurityGroup(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateSecurityGroupResponse(rsp)
}

// DeleteSecurityGroupWithResponse request returning *DeleteSecurityGroupResponse
func (c *ClientWithResponses) DeleteSecurityGroupWithResponse(ctx context.Context, id string) (*DeleteSecurityGroupResponse, error) {
	rsp, err := c.DeleteSecurityGroup(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSecurityGroupResponse(rsp)
}

// GetSecurityGroupWithResponse request returning *GetSecurityGroupResponse
func (c *ClientWithResponses) GetSecurityGroupWithResponse(ctx context.Context, id string) (*GetSecurityGroupResponse, error) {
	rsp, err := c.GetSecurityGroup(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetSecurityGroupResponse(rsp)
}

// AddRuleToSecurityGroupWithBodyWithResponse request with arbitrary body returning *AddRuleToSecurityGroupResponse
func (c *ClientWithResponses) AddRuleToSecurityGroupWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*AddRuleToSecurityGroupResponse, error) {
	rsp, err := c.AddRuleToSecurityGroupWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseAddRuleToSecurityGroupResponse(rsp)
}

func (c *ClientWithResponses) AddRuleToSecurityGroupWithResponse(ctx context.Context, id string, body AddRuleToSecurityGroupJSONRequestBody) (*AddRuleToSecurityGroupResponse, error) {
	rsp, err := c.AddRuleToSecurityGroup(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseAddRuleToSecurityGroupResponse(rsp)
}

// DeleteRuleFromSecurityGroupWithResponse request returning *DeleteRuleFromSecurityGroupResponse
func (c *ClientWithResponses) DeleteRuleFromSecurityGroupWithResponse(ctx context.Context, id string, ruleId string) (*DeleteRuleFromSecurityGroupResponse, error) {
	rsp, err := c.DeleteRuleFromSecurityGroup(ctx, id, ruleId)
	if err != nil {
		return nil, err
	}
	return ParseDeleteRuleFromSecurityGroupResponse(rsp)
}

// ListSksClustersWithResponse request returning *ListSksClustersResponse
func (c *ClientWithResponses) ListSksClustersWithResponse(ctx context.Context) (*ListSksClustersResponse, error) {
	rsp, err := c.ListSksClusters(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListSksClustersResponse(rsp)
}

// CreateSksClusterWithBodyWithResponse request with arbitrary body returning *CreateSksClusterResponse
func (c *ClientWithResponses) CreateSksClusterWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateSksClusterResponse, error) {
	rsp, err := c.CreateSksClusterWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksClusterResponse(rsp)
}

func (c *ClientWithResponses) CreateSksClusterWithResponse(ctx context.Context, body CreateSksClusterJSONRequestBody) (*CreateSksClusterResponse, error) {
	rsp, err := c.CreateSksCluster(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksClusterResponse(rsp)
}

// GenerateSksClusterKubeconfigWithBodyWithResponse request with arbitrary body returning *GenerateSksClusterKubeconfigResponse
func (c *ClientWithResponses) GenerateSksClusterKubeconfigWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*GenerateSksClusterKubeconfigResponse, error) {
	rsp, err := c.GenerateSksClusterKubeconfigWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseGenerateSksClusterKubeconfigResponse(rsp)
}

func (c *ClientWithResponses) GenerateSksClusterKubeconfigWithResponse(ctx context.Context, id string, body GenerateSksClusterKubeconfigJSONRequestBody) (*GenerateSksClusterKubeconfigResponse, error) {
	rsp, err := c.GenerateSksClusterKubeconfig(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseGenerateSksClusterKubeconfigResponse(rsp)
}

// ListSksClusterVersionsWithResponse request returning *ListSksClusterVersionsResponse
func (c *ClientWithResponses) ListSksClusterVersionsWithResponse(ctx context.Context) (*ListSksClusterVersionsResponse, error) {
	rsp, err := c.ListSksClusterVersions(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListSksClusterVersionsResponse(rsp)
}

// DeleteSksClusterWithResponse request returning *DeleteSksClusterResponse
func (c *ClientWithResponses) DeleteSksClusterWithResponse(ctx context.Context, id string) (*DeleteSksClusterResponse, error) {
	rsp, err := c.DeleteSksCluster(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSksClusterResponse(rsp)
}

// GetSksClusterWithResponse request returning *GetSksClusterResponse
func (c *ClientWithResponses) GetSksClusterWithResponse(ctx context.Context, id string) (*GetSksClusterResponse, error) {
	rsp, err := c.GetSksCluster(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetSksClusterResponse(rsp)
}

// UpdateSksClusterWithBodyWithResponse request with arbitrary body returning *UpdateSksClusterResponse
func (c *ClientWithResponses) UpdateSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpdateSksClusterResponse, error) {
	rsp, err := c.UpdateSksClusterWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksClusterResponse(rsp)
}

func (c *ClientWithResponses) UpdateSksClusterWithResponse(ctx context.Context, id string, body UpdateSksClusterJSONRequestBody) (*UpdateSksClusterResponse, error) {
	rsp, err := c.UpdateSksCluster(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksClusterResponse(rsp)
}

// CreateSksNodepoolWithBodyWithResponse request with arbitrary body returning *CreateSksNodepoolResponse
func (c *ClientWithResponses) CreateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*CreateSksNodepoolResponse, error) {
	rsp, err := c.CreateSksNodepoolWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksNodepoolResponse(rsp)
}

func (c *ClientWithResponses) CreateSksNodepoolWithResponse(ctx context.Context, id string, body CreateSksNodepoolJSONRequestBody) (*CreateSksNodepoolResponse, error) {
	rsp, err := c.CreateSksNodepool(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateSksNodepoolResponse(rsp)
}

// DeleteSksNodepoolWithResponse request returning *DeleteSksNodepoolResponse
func (c *ClientWithResponses) DeleteSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string) (*DeleteSksNodepoolResponse, error) {
	rsp, err := c.DeleteSksNodepool(ctx, id, sksNodepoolId)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSksNodepoolResponse(rsp)
}

// GetSksNodepoolWithResponse request returning *GetSksNodepoolResponse
func (c *ClientWithResponses) GetSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string) (*GetSksNodepoolResponse, error) {
	rsp, err := c.GetSksNodepool(ctx, id, sksNodepoolId)
	if err != nil {
		return nil, err
	}
	return ParseGetSksNodepoolResponse(rsp)
}

// UpdateSksNodepoolWithBodyWithResponse request with arbitrary body returning *UpdateSksNodepoolResponse
func (c *ClientWithResponses) UpdateSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*UpdateSksNodepoolResponse, error) {
	rsp, err := c.UpdateSksNodepoolWithBody(ctx, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksNodepoolResponse(rsp)
}

func (c *ClientWithResponses) UpdateSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body UpdateSksNodepoolJSONRequestBody) (*UpdateSksNodepoolResponse, error) {
	rsp, err := c.UpdateSksNodepool(ctx, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateSksNodepoolResponse(rsp)
}

// DeleteSksNodepoolFieldWithResponse request returning *DeleteSksNodepoolFieldResponse
func (c *ClientWithResponses) DeleteSksNodepoolFieldWithResponse(ctx context.Context, id string, sksNodepoolId string, field string) (*DeleteSksNodepoolFieldResponse, error) {
	rsp, err := c.DeleteSksNodepoolField(ctx, id, sksNodepoolId, field)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSksNodepoolFieldResponse(rsp)
}

// EvictSksNodepoolMembersWithBodyWithResponse request with arbitrary body returning *EvictSksNodepoolMembersResponse
func (c *ClientWithResponses) EvictSksNodepoolMembersWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*EvictSksNodepoolMembersResponse, error) {
	rsp, err := c.EvictSksNodepoolMembersWithBody(ctx, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseEvictSksNodepoolMembersResponse(rsp)
}

func (c *ClientWithResponses) EvictSksNodepoolMembersWithResponse(ctx context.Context, id string, sksNodepoolId string, body EvictSksNodepoolMembersJSONRequestBody) (*EvictSksNodepoolMembersResponse, error) {
	rsp, err := c.EvictSksNodepoolMembers(ctx, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	return ParseEvictSksNodepoolMembersResponse(rsp)
}

// ScaleSksNodepoolWithBodyWithResponse request with arbitrary body returning *ScaleSksNodepoolResponse
func (c *ClientWithResponses) ScaleSksNodepoolWithBodyWithResponse(ctx context.Context, id string, sksNodepoolId string, contentType string, body io.Reader) (*ScaleSksNodepoolResponse, error) {
	rsp, err := c.ScaleSksNodepoolWithBody(ctx, id, sksNodepoolId, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseScaleSksNodepoolResponse(rsp)
}

func (c *ClientWithResponses) ScaleSksNodepoolWithResponse(ctx context.Context, id string, sksNodepoolId string, body ScaleSksNodepoolJSONRequestBody) (*ScaleSksNodepoolResponse, error) {
	rsp, err := c.ScaleSksNodepool(ctx, id, sksNodepoolId, body)
	if err != nil {
		return nil, err
	}
	return ParseScaleSksNodepoolResponse(rsp)
}

// UpgradeSksClusterWithBodyWithResponse request with arbitrary body returning *UpgradeSksClusterResponse
func (c *ClientWithResponses) UpgradeSksClusterWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*UpgradeSksClusterResponse, error) {
	rsp, err := c.UpgradeSksClusterWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpgradeSksClusterResponse(rsp)
}

func (c *ClientWithResponses) UpgradeSksClusterWithResponse(ctx context.Context, id string, body UpgradeSksClusterJSONRequestBody) (*UpgradeSksClusterResponse, error) {
	rsp, err := c.UpgradeSksCluster(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseUpgradeSksClusterResponse(rsp)
}

// DeleteSksClusterFieldWithResponse request returning *DeleteSksClusterFieldResponse
func (c *ClientWithResponses) DeleteSksClusterFieldWithResponse(ctx context.Context, id string, field string) (*DeleteSksClusterFieldResponse, error) {
	rsp, err := c.DeleteSksClusterField(ctx, id, field)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSksClusterFieldResponse(rsp)
}

// ListSnapshotsWithResponse request returning *ListSnapshotsResponse
func (c *ClientWithResponses) ListSnapshotsWithResponse(ctx context.Context) (*ListSnapshotsResponse, error) {
	rsp, err := c.ListSnapshots(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListSnapshotsResponse(rsp)
}

// DeleteSnapshotWithResponse request returning *DeleteSnapshotResponse
func (c *ClientWithResponses) DeleteSnapshotWithResponse(ctx context.Context, id string) (*DeleteSnapshotResponse, error) {
	rsp, err := c.DeleteSnapshot(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSnapshotResponse(rsp)
}

// GetSnapshotWithResponse request returning *GetSnapshotResponse
func (c *ClientWithResponses) GetSnapshotWithResponse(ctx context.Context, id string) (*GetSnapshotResponse, error) {
	rsp, err := c.GetSnapshot(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetSnapshotResponse(rsp)
}

// ExportSnapshotWithResponse request returning *ExportSnapshotResponse
func (c *ClientWithResponses) ExportSnapshotWithResponse(ctx context.Context, id string) (*ExportSnapshotResponse, error) {
	rsp, err := c.ExportSnapshot(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseExportSnapshotResponse(rsp)
}

// GetSosPresignedUrlWithResponse request returning *GetSosPresignedUrlResponse
func (c *ClientWithResponses) GetSosPresignedUrlWithResponse(ctx context.Context, bucket string, params *GetSosPresignedUrlParams) (*GetSosPresignedUrlResponse, error) {
	rsp, err := c.GetSosPresignedUrl(ctx, bucket, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSosPresignedUrlResponse(rsp)
}

// GetSshKeyWithResponse request returning *GetSshKeyResponse
func (c *ClientWithResponses) GetSshKeyWithResponse(ctx context.Context, name string) (*GetSshKeyResponse, error) {
	rsp, err := c.GetSshKey(ctx, name)
	if err != nil {
		return nil, err
	}
	return ParseGetSshKeyResponse(rsp)
}

// ListTemplatesWithResponse request returning *ListTemplatesResponse
func (c *ClientWithResponses) ListTemplatesWithResponse(ctx context.Context, params *ListTemplatesParams) (*ListTemplatesResponse, error) {
	rsp, err := c.ListTemplates(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseListTemplatesResponse(rsp)
}

// RegisterTemplateWithBodyWithResponse request with arbitrary body returning *RegisterTemplateResponse
func (c *ClientWithResponses) RegisterTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*RegisterTemplateResponse, error) {
	rsp, err := c.RegisterTemplateWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseRegisterTemplateResponse(rsp)
}

func (c *ClientWithResponses) RegisterTemplateWithResponse(ctx context.Context, body RegisterTemplateJSONRequestBody) (*RegisterTemplateResponse, error) {
	rsp, err := c.RegisterTemplate(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseRegisterTemplateResponse(rsp)
}

// DeleteTemplateWithResponse request returning *DeleteTemplateResponse
func (c *ClientWithResponses) DeleteTemplateWithResponse(ctx context.Context, id string) (*DeleteTemplateResponse, error) {
	rsp, err := c.DeleteTemplate(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTemplateResponse(rsp)
}

// GetTemplateWithResponse request returning *GetTemplateResponse
func (c *ClientWithResponses) GetTemplateWithResponse(ctx context.Context, id string) (*GetTemplateResponse, error) {
	rsp, err := c.GetTemplate(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParseGetTemplateResponse(rsp)
}

// CopyTemplateWithBodyWithResponse request with arbitrary body returning *CopyTemplateResponse
func (c *ClientWithResponses) CopyTemplateWithBodyWithResponse(ctx context.Context, id string, contentType string, body io.Reader) (*CopyTemplateResponse, error) {
	rsp, err := c.CopyTemplateWithBody(ctx, id, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCopyTemplateResponse(rsp)
}

func (c *ClientWithResponses) CopyTemplateWithResponse(ctx context.Context, id string, body CopyTemplateJSONRequestBody) (*CopyTemplateResponse, error) {
	rsp, err := c.CopyTemplate(ctx, id, body)
	if err != nil {
		return nil, err
	}
	return ParseCopyTemplateResponse(rsp)
}

// ListZonesWithResponse request returning *ListZonesResponse
func (c *ClientWithResponses) ListZonesWithResponse(ctx context.Context) (*ListZonesResponse, error) {
	rsp, err := c.ListZones(ctx)
	if err != nil {
		return nil, err
	}
	return ParseListZonesResponse(rsp)
}

// ParseListAntiAffinityGroupsResponse parses an HTTP response from a ListAntiAffinityGroupsWithResponse call
func ParseListAntiAffinityGroupsResponse(rsp *http.Response) (*ListAntiAffinityGroupsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListAntiAffinityGroupsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			AntiAffinityGroups *[]AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateAntiAffinityGroupResponse parses an HTTP response from a CreateAntiAffinityGroupWithResponse call
func ParseCreateAntiAffinityGroupResponse(rsp *http.Response) (*CreateAntiAffinityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateAntiAffinityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteAntiAffinityGroupResponse parses an HTTP response from a DeleteAntiAffinityGroupWithResponse call
func ParseDeleteAntiAffinityGroupResponse(rsp *http.Response) (*DeleteAntiAffinityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteAntiAffinityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetAntiAffinityGroupResponse parses an HTTP response from a GetAntiAffinityGroupWithResponse call
func ParseGetAntiAffinityGroupResponse(rsp *http.Response) (*GetAntiAffinityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetAntiAffinityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest AntiAffinityGroup
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetElasticIpResponse parses an HTTP response from a GetElasticIpWithResponse call
func ParseGetElasticIpResponse(rsp *http.Response) (*GetElasticIpResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetElasticIpResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ElasticIp
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListEventsResponse parses an HTTP response from a ListEventsWithResponse call
func ParseListEventsResponse(rsp *http.Response) (*ListEventsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListEventsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest []Event
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateInstanceResponse parses an HTTP response from a CreateInstanceWithResponse call
func ParseCreateInstanceResponse(rsp *http.Response) (*CreateInstanceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateInstanceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListInstancePoolsResponse parses an HTTP response from a ListInstancePoolsWithResponse call
func ParseListInstancePoolsResponse(rsp *http.Response) (*ListInstancePoolsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListInstancePoolsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			InstancePools *[]InstancePool `json:"instance-pools,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateInstancePoolResponse parses an HTTP response from a CreateInstancePoolWithResponse call
func ParseCreateInstancePoolResponse(rsp *http.Response) (*CreateInstancePoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateInstancePoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteInstancePoolResponse parses an HTTP response from a DeleteInstancePoolWithResponse call
func ParseDeleteInstancePoolResponse(rsp *http.Response) (*DeleteInstancePoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteInstancePoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetInstancePoolResponse parses an HTTP response from a GetInstancePoolWithResponse call
func ParseGetInstancePoolResponse(rsp *http.Response) (*GetInstancePoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetInstancePoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest InstancePool
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateInstancePoolResponse parses an HTTP response from a UpdateInstancePoolWithResponse call
func ParseUpdateInstancePoolResponse(rsp *http.Response) (*UpdateInstancePoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpdateInstancePoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteInstancePoolFieldResponse parses an HTTP response from a DeleteInstancePoolFieldWithResponse call
func ParseDeleteInstancePoolFieldResponse(rsp *http.Response) (*DeleteInstancePoolFieldResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteInstancePoolFieldResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseEvictInstancePoolMembersResponse parses an HTTP response from a EvictInstancePoolMembersWithResponse call
func ParseEvictInstancePoolMembersResponse(rsp *http.Response) (*EvictInstancePoolMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &EvictInstancePoolMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseScaleInstancePoolResponse parses an HTTP response from a ScaleInstancePoolWithResponse call
func ParseScaleInstancePoolResponse(rsp *http.Response) (*ScaleInstancePoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ScaleInstancePoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListInstanceTypesResponse parses an HTTP response from a ListInstanceTypesWithResponse call
func ParseListInstanceTypesResponse(rsp *http.Response) (*ListInstanceTypesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListInstanceTypesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			InstanceTypes *[]InstanceType `json:"instance-types,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetInstanceTypeResponse parses an HTTP response from a GetInstanceTypeWithResponse call
func ParseGetInstanceTypeResponse(rsp *http.Response) (*GetInstanceTypeResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetInstanceTypeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest InstanceType
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateSnapshotResponse parses an HTTP response from a CreateSnapshotWithResponse call
func ParseCreateSnapshotResponse(rsp *http.Response) (*CreateSnapshotResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateSnapshotResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseRevertInstanceToSnapshotResponse parses an HTTP response from a RevertInstanceToSnapshotWithResponse call
func ParseRevertInstanceToSnapshotResponse(rsp *http.Response) (*RevertInstanceToSnapshotResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &RevertInstanceToSnapshotResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListLoadBalancersResponse parses an HTTP response from a ListLoadBalancersWithResponse call
func ParseListLoadBalancersResponse(rsp *http.Response) (*ListLoadBalancersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListLoadBalancersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			LoadBalancers *[]LoadBalancer `json:"load-balancers,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateLoadBalancerResponse parses an HTTP response from a CreateLoadBalancerWithResponse call
func ParseCreateLoadBalancerResponse(rsp *http.Response) (*CreateLoadBalancerResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateLoadBalancerResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteLoadBalancerResponse parses an HTTP response from a DeleteLoadBalancerWithResponse call
func ParseDeleteLoadBalancerResponse(rsp *http.Response) (*DeleteLoadBalancerResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteLoadBalancerResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetLoadBalancerResponse parses an HTTP response from a GetLoadBalancerWithResponse call
func ParseGetLoadBalancerResponse(rsp *http.Response) (*GetLoadBalancerResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetLoadBalancerResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LoadBalancer
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateLoadBalancerResponse parses an HTTP response from a UpdateLoadBalancerWithResponse call
func ParseUpdateLoadBalancerResponse(rsp *http.Response) (*UpdateLoadBalancerResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpdateLoadBalancerResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseAddServiceToLoadBalancerResponse parses an HTTP response from a AddServiceToLoadBalancerWithResponse call
func ParseAddServiceToLoadBalancerResponse(rsp *http.Response) (*AddServiceToLoadBalancerResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &AddServiceToLoadBalancerResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteLoadBalancerServiceResponse parses an HTTP response from a DeleteLoadBalancerServiceWithResponse call
func ParseDeleteLoadBalancerServiceResponse(rsp *http.Response) (*DeleteLoadBalancerServiceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteLoadBalancerServiceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetLoadBalancerServiceResponse parses an HTTP response from a GetLoadBalancerServiceWithResponse call
func ParseGetLoadBalancerServiceResponse(rsp *http.Response) (*GetLoadBalancerServiceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetLoadBalancerServiceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LoadBalancerService
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateLoadBalancerServiceResponse parses an HTTP response from a UpdateLoadBalancerServiceWithResponse call
func ParseUpdateLoadBalancerServiceResponse(rsp *http.Response) (*UpdateLoadBalancerServiceResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpdateLoadBalancerServiceResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetOperationResponse parses an HTTP response from a GetOperationWithResponse call
func ParseGetOperationResponse(rsp *http.Response) (*GetOperationResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetOperationResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListPrivateNetworksResponse parses an HTTP response from a ListPrivateNetworksWithResponse call
func ParseListPrivateNetworksResponse(rsp *http.Response) (*ListPrivateNetworksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListPrivateNetworksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			PrivateNetworks *[]PrivateNetwork `json:"private-networks,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreatePrivateNetworkResponse parses an HTTP response from a CreatePrivateNetworkWithResponse call
func ParseCreatePrivateNetworkResponse(rsp *http.Response) (*CreatePrivateNetworkResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreatePrivateNetworkResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeletePrivateNetworkResponse parses an HTTP response from a DeletePrivateNetworkWithResponse call
func ParseDeletePrivateNetworkResponse(rsp *http.Response) (*DeletePrivateNetworkResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeletePrivateNetworkResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetPrivateNetworkResponse parses an HTTP response from a GetPrivateNetworkWithResponse call
func ParseGetPrivateNetworkResponse(rsp *http.Response) (*GetPrivateNetworkResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetPrivateNetworkResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest PrivateNetwork
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdatePrivateNetworkResponse parses an HTTP response from a UpdatePrivateNetworkWithResponse call
func ParseUpdatePrivateNetworkResponse(rsp *http.Response) (*UpdatePrivateNetworkResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpdatePrivateNetworkResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeletePrivateNetworkFieldResponse parses an HTTP response from a DeletePrivateNetworkFieldWithResponse call
func ParseDeletePrivateNetworkFieldResponse(rsp *http.Response) (*DeletePrivateNetworkFieldResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeletePrivateNetworkFieldResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListSecurityGroupsResponse parses an HTTP response from a ListSecurityGroupsWithResponse call
func ParseListSecurityGroupsResponse(rsp *http.Response) (*ListSecurityGroupsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListSecurityGroupsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			SecurityGroups *[]SecurityGroup `json:"security-groups,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateSecurityGroupResponse parses an HTTP response from a CreateSecurityGroupWithResponse call
func ParseCreateSecurityGroupResponse(rsp *http.Response) (*CreateSecurityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateSecurityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteSecurityGroupResponse parses an HTTP response from a DeleteSecurityGroupWithResponse call
func ParseDeleteSecurityGroupResponse(rsp *http.Response) (*DeleteSecurityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteSecurityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetSecurityGroupResponse parses an HTTP response from a GetSecurityGroupWithResponse call
func ParseGetSecurityGroupResponse(rsp *http.Response) (*GetSecurityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSecurityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest SecurityGroup
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseAddRuleToSecurityGroupResponse parses an HTTP response from a AddRuleToSecurityGroupWithResponse call
func ParseAddRuleToSecurityGroupResponse(rsp *http.Response) (*AddRuleToSecurityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &AddRuleToSecurityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteRuleFromSecurityGroupResponse parses an HTTP response from a DeleteRuleFromSecurityGroupWithResponse call
func ParseDeleteRuleFromSecurityGroupResponse(rsp *http.Response) (*DeleteRuleFromSecurityGroupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteRuleFromSecurityGroupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListSksClustersResponse parses an HTTP response from a ListSksClustersWithResponse call
func ParseListSksClustersResponse(rsp *http.Response) (*ListSksClustersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListSksClustersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			SksClusters *[]SksCluster `json:"sks-clusters,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateSksClusterResponse parses an HTTP response from a CreateSksClusterWithResponse call
func ParseCreateSksClusterResponse(rsp *http.Response) (*CreateSksClusterResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateSksClusterResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGenerateSksClusterKubeconfigResponse parses an HTTP response from a GenerateSksClusterKubeconfigWithResponse call
func ParseGenerateSksClusterKubeconfigResponse(rsp *http.Response) (*GenerateSksClusterKubeconfigResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GenerateSksClusterKubeconfigResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Kubeconfig *string `json:"kubeconfig,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListSksClusterVersionsResponse parses an HTTP response from a ListSksClusterVersionsWithResponse call
func ParseListSksClusterVersionsResponse(rsp *http.Response) (*ListSksClusterVersionsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListSksClusterVersionsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			SksClusterVersions *[]string `json:"sks-cluster-versions,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteSksClusterResponse parses an HTTP response from a DeleteSksClusterWithResponse call
func ParseDeleteSksClusterResponse(rsp *http.Response) (*DeleteSksClusterResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteSksClusterResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetSksClusterResponse parses an HTTP response from a GetSksClusterWithResponse call
func ParseGetSksClusterResponse(rsp *http.Response) (*GetSksClusterResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSksClusterResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest SksCluster
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateSksClusterResponse parses an HTTP response from a UpdateSksClusterWithResponse call
func ParseUpdateSksClusterResponse(rsp *http.Response) (*UpdateSksClusterResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpdateSksClusterResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCreateSksNodepoolResponse parses an HTTP response from a CreateSksNodepoolWithResponse call
func ParseCreateSksNodepoolResponse(rsp *http.Response) (*CreateSksNodepoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateSksNodepoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteSksNodepoolResponse parses an HTTP response from a DeleteSksNodepoolWithResponse call
func ParseDeleteSksNodepoolResponse(rsp *http.Response) (*DeleteSksNodepoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteSksNodepoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetSksNodepoolResponse parses an HTTP response from a GetSksNodepoolWithResponse call
func ParseGetSksNodepoolResponse(rsp *http.Response) (*GetSksNodepoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSksNodepoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest SksNodepool
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpdateSksNodepoolResponse parses an HTTP response from a UpdateSksNodepoolWithResponse call
func ParseUpdateSksNodepoolResponse(rsp *http.Response) (*UpdateSksNodepoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpdateSksNodepoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteSksNodepoolFieldResponse parses an HTTP response from a DeleteSksNodepoolFieldWithResponse call
func ParseDeleteSksNodepoolFieldResponse(rsp *http.Response) (*DeleteSksNodepoolFieldResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteSksNodepoolFieldResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseEvictSksNodepoolMembersResponse parses an HTTP response from a EvictSksNodepoolMembersWithResponse call
func ParseEvictSksNodepoolMembersResponse(rsp *http.Response) (*EvictSksNodepoolMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &EvictSksNodepoolMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseScaleSksNodepoolResponse parses an HTTP response from a ScaleSksNodepoolWithResponse call
func ParseScaleSksNodepoolResponse(rsp *http.Response) (*ScaleSksNodepoolResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ScaleSksNodepoolResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseUpgradeSksClusterResponse parses an HTTP response from a UpgradeSksClusterWithResponse call
func ParseUpgradeSksClusterResponse(rsp *http.Response) (*UpgradeSksClusterResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpgradeSksClusterResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteSksClusterFieldResponse parses an HTTP response from a DeleteSksClusterFieldWithResponse call
func ParseDeleteSksClusterFieldResponse(rsp *http.Response) (*DeleteSksClusterFieldResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteSksClusterFieldResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListSnapshotsResponse parses an HTTP response from a ListSnapshotsWithResponse call
func ParseListSnapshotsResponse(rsp *http.Response) (*ListSnapshotsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListSnapshotsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Snapshots *[]Snapshot `json:"snapshots,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteSnapshotResponse parses an HTTP response from a DeleteSnapshotWithResponse call
func ParseDeleteSnapshotResponse(rsp *http.Response) (*DeleteSnapshotResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteSnapshotResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetSnapshotResponse parses an HTTP response from a GetSnapshotWithResponse call
func ParseGetSnapshotResponse(rsp *http.Response) (*GetSnapshotResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSnapshotResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Snapshot
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseExportSnapshotResponse parses an HTTP response from a ExportSnapshotWithResponse call
func ParseExportSnapshotResponse(rsp *http.Response) (*ExportSnapshotResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ExportSnapshotResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetSosPresignedUrlResponse parses an HTTP response from a GetSosPresignedUrlWithResponse call
func ParseGetSosPresignedUrlResponse(rsp *http.Response) (*GetSosPresignedUrlResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSosPresignedUrlResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Url *string `json:"url,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetSshKeyResponse parses an HTTP response from a GetSshKeyWithResponse call
func ParseGetSshKeyResponse(rsp *http.Response) (*GetSshKeyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSshKeyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest SshKey
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListTemplatesResponse parses an HTTP response from a ListTemplatesWithResponse call
func ParseListTemplatesResponse(rsp *http.Response) (*ListTemplatesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListTemplatesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Templates *[]Template `json:"templates,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseRegisterTemplateResponse parses an HTTP response from a RegisterTemplateWithResponse call
func ParseRegisterTemplateResponse(rsp *http.Response) (*RegisterTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &RegisterTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseDeleteTemplateResponse parses an HTTP response from a DeleteTemplateWithResponse call
func ParseDeleteTemplateResponse(rsp *http.Response) (*DeleteTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseGetTemplateResponse parses an HTTP response from a GetTemplateWithResponse call
func ParseGetTemplateResponse(rsp *http.Response) (*GetTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Template
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseCopyTemplateResponse parses an HTTP response from a CopyTemplateWithResponse call
func ParseCopyTemplateResponse(rsp *http.Response) (*CopyTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CopyTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Operation
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParseListZonesResponse parses an HTTP response from a ListZonesWithResponse call
func ParseListZonesResponse(rsp *http.Response) (*ListZonesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListZonesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Zones *[]Zone `json:"zones,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}
